/*!
 * jQuery JavaScript Library v3.0.0
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2016-06-09T18:02Z
 */
( function( global, factory ) {

    "use strict";

    if ( typeof module === "object" && typeof module.exports === "object" ) {

        // For CommonJS and CommonJS-like environments where a proper `window`
        // is present, execute the factory and get jQuery.
        // For environments that do not have a `window` with a `document`
        // (such as Node.js), expose a factory as module.exports.
        // This accentuates the need for the creation of a real `window`.
        // e.g. var jQuery = require("jquery")(window);
        // See ticket #14549 for more info.
        module.exports = global.document ?
            factory( global, true ) :
            function( w ) {
                if ( !w.document ) {
                    throw new Error( "jQuery requires a window with a document" );
                }
                return factory( w );
            };
    } else {
        factory( global );
    }

// Pass this if window is not defined yet
}( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
    "use strict";

    var arr = [];

    var document = window.document;

    var getProto = Object.getPrototypeOf;

    var slice = arr.slice;

    var concat = arr.concat;

    var push = arr.push;

    var indexOf = arr.indexOf;

    var class2type = {};

    var toString = class2type.toString;

    var hasOwn = class2type.hasOwnProperty;

    var fnToString = hasOwn.toString;

    var ObjectFunctionString = fnToString.call( Object );

    var support = {};



    function DOMEval( code, doc ) {
        doc = doc || document;

        var script = doc.createElement( "script" );

        script.text = code;
        doc.head.appendChild( script ).parentNode.removeChild( script );
    }


    var
        version = "3.0.0",

    // Define a local copy of jQuery
        jQuery = function( selector, context ) {

            // The jQuery object is actually just the init constructor 'enhanced'
            // Need init if jQuery is called (just allow error to be thrown if not included)
            return new jQuery.fn.init( selector, context );
        },

    // Support: Android <=4.0 only
    // Make sure we trim BOM and NBSP
        rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

    // Matches dashed string for camelizing
        rmsPrefix = /^-ms-/,
        rdashAlpha = /-([a-z])/g,

    // Used by jQuery.camelCase as callback to replace()
        fcamelCase = function( all, letter ) {
            return letter.toUpperCase();
        };

    jQuery.fn = jQuery.prototype = {

        // The current version of jQuery being used
        jquery: version,

        constructor: jQuery,

        // The default length of a jQuery object is 0
        length: 0,

        toArray: function() {
            return slice.call( this );
        },

        // Get the Nth element in the matched element set OR
        // Get the whole matched element set as a clean array
        get: function( num ) {
            return num != null ?

                // Return just the one element from the set
                ( num < 0 ? this[ num + this.length ] : this[ num ] ) :

                // Return all the elements in a clean array
                slice.call( this );
        },

        // Take an array of elements and push it onto the stack
        // (returning the new matched element set)
        pushStack: function( elems ) {

            // Build a new jQuery matched element set
            var ret = jQuery.merge( this.constructor(), elems );

            // Add the old object onto the stack (as a reference)
            ret.prevObject = this;

            // Return the newly-formed element set
            return ret;
        },

        // Execute a callback for every element in the matched set.
        each: function( callback ) {
            return jQuery.each( this, callback );
        },

        map: function( callback ) {
            return this.pushStack( jQuery.map( this, function( elem, i ) {
                return callback.call( elem, i, elem );
            } ) );
        },

        slice: function() {
            return this.pushStack( slice.apply( this, arguments ) );
        },

        first: function() {
            return this.eq( 0 );
        },

        last: function() {
            return this.eq( -1 );
        },

        eq: function( i ) {
            var len = this.length,
                j = +i + ( i < 0 ? len : 0 );
            return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
        },

        end: function() {
            return this.prevObject || this.constructor();
        },

        // For internal use only.
        // Behaves like an Array's method, not like a jQuery method.
        push: push,
        sort: arr.sort,
        splice: arr.splice
    };

    jQuery.extend = jQuery.fn.extend = function() {
        var options, name, src, copy, copyIsArray, clone,
            target = arguments[ 0 ] || {},
            i = 1,
            length = arguments.length,
            deep = false;

        // Handle a deep copy situation
        if ( typeof target === "boolean" ) {
            deep = target;

            // Skip the boolean and the target
            target = arguments[ i ] || {};
            i++;
        }

        // Handle case when target is a string or something (possible in deep copy)
        if ( typeof target !== "object" && !jQuery.isFunction( target ) ) {
            target = {};
        }

        // Extend jQuery itself if only one argument is passed
        if ( i === length ) {
            target = this;
            i--;
        }

        for ( ; i < length; i++ ) {

            // Only deal with non-null/undefined values
            if ( ( options = arguments[ i ] ) != null ) {

                // Extend the base object
                for ( name in options ) {
                    src = target[ name ];
                    copy = options[ name ];

                    // Prevent never-ending loop
                    if ( target === copy ) {
                        continue;
                    }

                    // Recurse if we're merging plain objects or arrays
                    if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
                        ( copyIsArray = jQuery.isArray( copy ) ) ) ) {

                        if ( copyIsArray ) {
                            copyIsArray = false;
                            clone = src && jQuery.isArray( src ) ? src : [];

                        } else {
                            clone = src && jQuery.isPlainObject( src ) ? src : {};
                        }

                        // Never move original objects, clone them
                        target[ name ] = jQuery.extend( deep, clone, copy );

                        // Don't bring in undefined values
                    } else if ( copy !== undefined ) {
                        target[ name ] = copy;
                    }
                }
            }
        }

        // Return the modified object
        return target;
    };

    jQuery.extend( {

        // Unique for each copy of jQuery on the page
        expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

        // Assume jQuery is ready without the ready module
        isReady: true,

        error: function( msg ) {
            throw new Error( msg );
        },

        noop: function() {},

        isFunction: function( obj ) {
            return jQuery.type( obj ) === "function";
        },

        isArray: Array.isArray,

        isWindow: function( obj ) {
            return obj != null && obj === obj.window;
        },

        isNumeric: function( obj ) {

            // As of jQuery 3.0, isNumeric is limited to
            // strings and numbers (primitives or objects)
            // that can be coerced to finite numbers (gh-2662)
            var type = jQuery.type( obj );
            return ( type === "number" || type === "string" ) &&

                    // parseFloat NaNs numeric-cast false positives ("")
                    // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
                    // subtraction forces infinities to NaN
                !isNaN( obj - parseFloat( obj ) );
        },

        isPlainObject: function( obj ) {
            var proto, Ctor;

            // Detect obvious negatives
            // Use toString instead of jQuery.type to catch host objects
            if ( !obj || toString.call( obj ) !== "[object Object]" ) {
                return false;
            }

            proto = getProto( obj );

            // Objects with no prototype (e.g., `Object.create( null )`) are plain
            if ( !proto ) {
                return true;
            }

            // Objects with prototype are plain iff they were constructed by a global Object function
            Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
            return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
        },

        isEmptyObject: function( obj ) {
            var name;
            for ( name in obj ) {
                return false;
            }
            return true;
        },

        type: function( obj ) {
            if ( obj == null ) {
                return obj + "";
            }

            // Support: Android <=2.3 only (functionish RegExp)
            return typeof obj === "object" || typeof obj === "function" ?
            class2type[ toString.call( obj ) ] || "object" :
                typeof obj;
        },

        // Evaluates a script in a global context
        globalEval: function( code ) {
            DOMEval( code );
        },

        // Convert dashed to camelCase; used by the css and data modules
        // Support: IE <=9 - 11, Edge 12 - 13
        // Microsoft forgot to hump their vendor prefix (#9572)
        camelCase: function( string ) {
            return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
        },

        nodeName: function( elem, name ) {
            return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
        },

        each: function( obj, callback ) {
            var length, i = 0;

            if ( isArrayLike( obj ) ) {
                length = obj.length;
                for ( ; i < length; i++ ) {
                    if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
                        break;
                    }
                }
            } else {
                for ( i in obj ) {
                    if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
                        break;
                    }
                }
            }

            return obj;
        },

        // Support: Android <=4.0 only
        trim: function( text ) {
            return text == null ?
                "" :
                ( text + "" ).replace( rtrim, "" );
        },

        // results is for internal usage only
        makeArray: function( arr, results ) {
            var ret = results || [];

            if ( arr != null ) {
                if ( isArrayLike( Object( arr ) ) ) {
                    jQuery.merge( ret,
                        typeof arr === "string" ?
                            [ arr ] : arr
                    );
                } else {
                    push.call( ret, arr );
                }
            }

            return ret;
        },

        inArray: function( elem, arr, i ) {
            return arr == null ? -1 : indexOf.call( arr, elem, i );
        },

        // Support: Android <=4.0 only, PhantomJS 1 only
        // push.apply(_, arraylike) throws on ancient WebKit
        merge: function( first, second ) {
            var len = +second.length,
                j = 0,
                i = first.length;

            for ( ; j < len; j++ ) {
                first[ i++ ] = second[ j ];
            }

            first.length = i;

            return first;
        },

        grep: function( elems, callback, invert ) {
            var callbackInverse,
                matches = [],
                i = 0,
                length = elems.length,
                callbackExpect = !invert;

            // Go through the array, only saving the items
            // that pass the validator function
            for ( ; i < length; i++ ) {
                callbackInverse = !callback( elems[ i ], i );
                if ( callbackInverse !== callbackExpect ) {
                    matches.push( elems[ i ] );
                }
            }

            return matches;
        },

        // arg is for internal usage only
        map: function( elems, callback, arg ) {
            var length, value,
                i = 0,
                ret = [];

            // Go through the array, translating each of the items to their new values
            if ( isArrayLike( elems ) ) {
                length = elems.length;
                for ( ; i < length; i++ ) {
                    value = callback( elems[ i ], i, arg );

                    if ( value != null ) {
                        ret.push( value );
                    }
                }

                // Go through every key on the object,
            } else {
                for ( i in elems ) {
                    value = callback( elems[ i ], i, arg );

                    if ( value != null ) {
                        ret.push( value );
                    }
                }
            }

            // Flatten any nested arrays
            return concat.apply( [], ret );
        },

        // A global GUID counter for objects
        guid: 1,

        // Bind a function to a context, optionally partially applying any
        // arguments.
        proxy: function( fn, context ) {
            var tmp, args, proxy;

            if ( typeof context === "string" ) {
                tmp = fn[ context ];
                context = fn;
                fn = tmp;
            }

            // Quick check to determine if target is callable, in the spec
            // this throws a TypeError, but we will just return undefined.
            if ( !jQuery.isFunction( fn ) ) {
                return undefined;
            }

            // Simulated bind
            args = slice.call( arguments, 2 );
            proxy = function() {
                return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
            };

            // Set the guid of unique handler to the same of original handler, so it can be removed
            proxy.guid = fn.guid = fn.guid || jQuery.guid++;

            return proxy;
        },

        now: Date.now,

        // jQuery.support is not used in Core but other projects attach their
        // properties to it so it needs to exist.
        support: support
    } );

// JSHint would error on this code due to the Symbol not being defined in ES5.
// Defining this global in .jshintrc would create a danger of using the global
// unguarded in another place, it seems safer to just disable JSHint for these
// three lines.
    /* jshint ignore: start */
    if ( typeof Symbol === "function" ) {
        jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
    }
    /* jshint ignore: end */

// Populate the class2type map
    jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
        function( i, name ) {
            class2type[ "[object " + name + "]" ] = name.toLowerCase();
        } );

    function isArrayLike( obj ) {

        // Support: real iOS 8.2 only (not reproducible in simulator)
        // `in` check used to prevent JIT error (gh-2145)
        // hasOwn isn't used here due to false negatives
        // regarding Nodelist length in IE
        var length = !!obj && "length" in obj && obj.length,
            type = jQuery.type( obj );

        if ( type === "function" || jQuery.isWindow( obj ) ) {
            return false;
        }

        return type === "array" || length === 0 ||
            typeof length === "number" && length > 0 && ( length - 1 ) in obj;
    }
    var Sizzle =
        /*!
         * Sizzle CSS Selector Engine v2.3.0
         * https://sizzlejs.com/
         *
         * Copyright jQuery Foundation and other contributors
         * Released under the MIT license
         * http://jquery.org/license
         *
         * Date: 2016-01-04
         */
        (function( window ) {

            var i,
                support,
                Expr,
                getText,
                isXML,
                tokenize,
                compile,
                select,
                outermostContext,
                sortInput,
                hasDuplicate,

            // Local document vars
                setDocument,
                document,
                docElem,
                documentIsHTML,
                rbuggyQSA,
                rbuggyMatches,
                matches,
                contains,

            // Instance-specific data
                expando = "sizzle" + 1 * new Date(),
                preferredDoc = window.document,
                dirruns = 0,
                done = 0,
                classCache = createCache(),
                tokenCache = createCache(),
                compilerCache = createCache(),
                sortOrder = function( a, b ) {
                    if ( a === b ) {
                        hasDuplicate = true;
                    }
                    return 0;
                },

            // Instance methods
                hasOwn = ({}).hasOwnProperty,
                arr = [],
                pop = arr.pop,
                push_native = arr.push,
                push = arr.push,
                slice = arr.slice,
            // Use a stripped-down indexOf as it's faster than native
            // https://jsperf.com/thor-indexof-vs-for/5
                indexOf = function( list, elem ) {
                    var i = 0,
                        len = list.length;
                    for ( ; i < len; i++ ) {
                        if ( list[i] === elem ) {
                            return i;
                        }
                    }
                    return -1;
                },

                booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",

            // Regular expressions

            // http://www.w3.org/TR/css3-selectors/#whitespace
                whitespace = "[\\x20\\t\\r\\n\\f]",

            // http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
                identifier = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+",

            // Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
                attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +
                        // Operator (capture 2)
                    "*([*^$|!~]?=)" + whitespace +
                        // "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
                    "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace +
                    "*\\]",

                pseudos = ":(" + identifier + ")(?:\\((" +
                        // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
                        // 1. quoted (capture 3; capture 4 or capture 5)
                    "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
                        // 2. simple (capture 6)
                    "((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +
                        // 3. anything else (capture 2)
                    ".*" +
                    ")\\)|)",

            // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
                rwhitespace = new RegExp( whitespace + "+", "g" ),
                rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

                rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
                rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),

                rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),

                rpseudo = new RegExp( pseudos ),
                ridentifier = new RegExp( "^" + identifier + "$" ),

                matchExpr = {
                    "ID": new RegExp( "^#(" + identifier + ")" ),
                    "CLASS": new RegExp( "^\\.(" + identifier + ")" ),
                    "TAG": new RegExp( "^(" + identifier + "|[*])" ),
                    "ATTR": new RegExp( "^" + attributes ),
                    "PSEUDO": new RegExp( "^" + pseudos ),
                    "CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +
                        "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
                        "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
                    "bool": new RegExp( "^(?:" + booleans + ")$", "i" ),
                    // For use in libraries implementing .is()
                    // We use this for POS matching in `select`
                    "needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
                        whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
                },

                rinputs = /^(?:input|select|textarea|button)$/i,
                rheader = /^h\d$/i,

                rnative = /^[^{]+\{\s*\[native \w/,

            // Easily-parseable/retrievable ID or TAG or CLASS selectors
                rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

                rsibling = /[+~]/,

            // CSS escapes
            // http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
                runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),
                funescape = function( _, escaped, escapedWhitespace ) {
                    var high = "0x" + escaped - 0x10000;
                    // NaN means non-codepoint
                    // Support: Firefox<24
                    // Workaround erroneous numeric interpretation of +"0x"
                    return high !== high || escapedWhitespace ?
                        escaped :
                        high < 0 ?
                            // BMP codepoint
                            String.fromCharCode( high + 0x10000 ) :
                            // Supplemental Plane codepoint (surrogate pair)
                            String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
                },

            // CSS string/identifier serialization
            // https://drafts.csswg.org/cssom/#common-serializing-idioms
                rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g,
                fcssescape = function( ch, asCodePoint ) {
                    if ( asCodePoint ) {

                        // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
                        if ( ch === "\0" ) {
                            return "\uFFFD";
                        }

                        // Control characters and (dependent upon position) numbers get escaped as code points
                        return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
                    }

                    // Other potentially-special ASCII characters get backslash-escaped
                    return "\\" + ch;
                },

            // Used for iframes
            // See setDocument()
            // Removing the function wrapper causes a "Permission Denied"
            // error in IE
                unloadHandler = function() {
                    setDocument();
                },

                disabledAncestor = addCombinator(
                    function( elem ) {
                        return elem.disabled === true;
                    },
                    { dir: "parentNode", next: "legend" }
                );

// Optimize for push.apply( _, NodeList )
            try {
                push.apply(
                    (arr = slice.call( preferredDoc.childNodes )),
                    preferredDoc.childNodes
                );
                // Support: Android<4.0
                // Detect silently failing push.apply
                arr[ preferredDoc.childNodes.length ].nodeType;
            } catch ( e ) {
                push = { apply: arr.length ?

                    // Leverage slice if possible
                    function( target, els ) {
                        push_native.apply( target, slice.call(els) );
                    } :

                    // Support: IE<9
                    // Otherwise append directly
                    function( target, els ) {
                        var j = target.length,
                            i = 0;
                        // Can't trust NodeList.length
                        while ( (target[j++] = els[i++]) ) {}
                        target.length = j - 1;
                    }
                };
            }

            function Sizzle( selector, context, results, seed ) {
                var m, i, elem, nid, match, groups, newSelector,
                    newContext = context && context.ownerDocument,

                // nodeType defaults to 9, since context defaults to document
                    nodeType = context ? context.nodeType : 9;

                results = results || [];

                // Return early from calls with invalid selector or context
                if ( typeof selector !== "string" || !selector ||
                    nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

                    return results;
                }

                // Try to shortcut find operations (as opposed to filters) in HTML documents
                if ( !seed ) {

                    if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {
                        setDocument( context );
                    }
                    context = context || document;

                    if ( documentIsHTML ) {

                        // If the selector is sufficiently simple, try using a "get*By*" DOM method
                        // (excepting DocumentFragment context, where the methods don't exist)
                        if ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {

                            // ID selector
                            if ( (m = match[1]) ) {

                                // Document context
                                if ( nodeType === 9 ) {
                                    if ( (elem = context.getElementById( m )) ) {

                                        // Support: IE, Opera, Webkit
                                        // TODO: identify versions
                                        // getElementById can match elements by name instead of ID
                                        if ( elem.id === m ) {
                                            results.push( elem );
                                            return results;
                                        }
                                    } else {
                                        return results;
                                    }

                                    // Element context
                                } else {

                                    // Support: IE, Opera, Webkit
                                    // TODO: identify versions
                                    // getElementById can match elements by name instead of ID
                                    if ( newContext && (elem = newContext.getElementById( m )) &&
                                        contains( context, elem ) &&
                                        elem.id === m ) {

                                        results.push( elem );
                                        return results;
                                    }
                                }

                                // Type selector
                            } else if ( match[2] ) {
                                push.apply( results, context.getElementsByTagName( selector ) );
                                return results;

                                // Class selector
                            } else if ( (m = match[3]) && support.getElementsByClassName &&
                                context.getElementsByClassName ) {

                                push.apply( results, context.getElementsByClassName( m ) );
                                return results;
                            }
                        }

                        // Take advantage of querySelectorAll
                        if ( support.qsa &&
                            !compilerCache[ selector + " " ] &&
                            (!rbuggyQSA || !rbuggyQSA.test( selector )) ) {

                            if ( nodeType !== 1 ) {
                                newContext = context;
                                newSelector = selector;

                                // qSA looks outside Element context, which is not what we want
                                // Thanks to Andrew Dupont for this workaround technique
                                // Support: IE <=8
                                // Exclude object elements
                            } else if ( context.nodeName.toLowerCase() !== "object" ) {

                                // Capture the context ID, setting it first if necessary
                                if ( (nid = context.getAttribute( "id" )) ) {
                                    nid = nid.replace( rcssescape, fcssescape );
                                } else {
                                    context.setAttribute( "id", (nid = expando) );
                                }

                                // Prefix every selector in the list
                                groups = tokenize( selector );
                                i = groups.length;
                                while ( i-- ) {
                                    groups[i] = "#" + nid + " " + toSelector( groups[i] );
                                }
                                newSelector = groups.join( "," );

                                // Expand context for sibling selectors
                                newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
                                    context;
                            }

                            if ( newSelector ) {
                                try {
                                    push.apply( results,
                                        newContext.querySelectorAll( newSelector )
                                    );
                                    return results;
                                } catch ( qsaError ) {
                                } finally {
                                    if ( nid === expando ) {
                                        context.removeAttribute( "id" );
                                    }
                                }
                            }
                        }
                    }
                }

                // All others
                return select( selector.replace( rtrim, "$1" ), context, results, seed );
            }

            /**
             * Create key-value caches of limited size
             * @returns {function(string, object)} Returns the Object data after storing it on itself with
             *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
             *	deleting the oldest entry
             */
            function createCache() {
                var keys = [];

                function cache( key, value ) {
                    // Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
                    if ( keys.push( key + " " ) > Expr.cacheLength ) {
                        // Only keep the most recent entries
                        delete cache[ keys.shift() ];
                    }
                    return (cache[ key + " " ] = value);
                }
                return cache;
            }

            /**
             * Mark a function for special use by Sizzle
             * @param {Function} fn The function to mark
             */
            function markFunction( fn ) {
                fn[ expando ] = true;
                return fn;
            }

            /**
             * Support testing using an element
             * @param {Function} fn Passed the created element and returns a boolean result
             */
            function assert( fn ) {
                var el = document.createElement("fieldset");

                try {
                    return !!fn( el );
                } catch (e) {
                    return false;
                } finally {
                    // Remove from its parent by default
                    if ( el.parentNode ) {
                        el.parentNode.removeChild( el );
                    }
                    // release memory in IE
                    el = null;
                }
            }

            /**
             * Adds the same handler for all of the specified attrs
             * @param {String} attrs Pipe-separated list of attributes
             * @param {Function} handler The method that will be applied
             */
            function addHandle( attrs, handler ) {
                var arr = attrs.split("|"),
                    i = arr.length;

                while ( i-- ) {
                    Expr.attrHandle[ arr[i] ] = handler;
                }
            }

            /**
             * Checks document order of two siblings
             * @param {Element} a
             * @param {Element} b
             * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
             */
            function siblingCheck( a, b ) {
                var cur = b && a,
                    diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
                        a.sourceIndex - b.sourceIndex;

                // Use IE sourceIndex if available on both nodes
                if ( diff ) {
                    return diff;
                }

                // Check if b follows a
                if ( cur ) {
                    while ( (cur = cur.nextSibling) ) {
                        if ( cur === b ) {
                            return -1;
                        }
                    }
                }

                return a ? 1 : -1;
            }

            /**
             * Returns a function to use in pseudos for input types
             * @param {String} type
             */
            function createInputPseudo( type ) {
                return function( elem ) {
                    var name = elem.nodeName.toLowerCase();
                    return name === "input" && elem.type === type;
                };
            }

            /**
             * Returns a function to use in pseudos for buttons
             * @param {String} type
             */
            function createButtonPseudo( type ) {
                return function( elem ) {
                    var name = elem.nodeName.toLowerCase();
                    return (name === "input" || name === "button") && elem.type === type;
                };
            }

            /**
             * Returns a function to use in pseudos for :enabled/:disabled
             * @param {Boolean} disabled true for :disabled; false for :enabled
             */
            function createDisabledPseudo( disabled ) {
                // Known :disabled false positives:
                // IE: *[disabled]:not(button, input, select, textarea, optgroup, option, menuitem, fieldset)
                // not IE: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
                return function( elem ) {

                    // Check form elements and option elements for explicit disabling
                    return "label" in elem && elem.disabled === disabled ||
                        "form" in elem && elem.disabled === disabled ||

                            // Check non-disabled form elements for fieldset[disabled] ancestors
                        "form" in elem && elem.disabled === false && (
                            // Support: IE6-11+
                            // Ancestry is covered for us
                            elem.isDisabled === disabled ||

                                // Otherwise, assume any non-<option> under fieldset[disabled] is disabled
                                /* jshint -W018 */
                            elem.isDisabled !== !disabled &&
                            ("label" in elem || !disabledAncestor( elem )) !== disabled
                        );
                };
            }

            /**
             * Returns a function to use in pseudos for positionals
             * @param {Function} fn
             */
            function createPositionalPseudo( fn ) {
                return markFunction(function( argument ) {
                    argument = +argument;
                    return markFunction(function( seed, matches ) {
                        var j,
                            matchIndexes = fn( [], seed.length, argument ),
                            i = matchIndexes.length;

                        // Match elements found at the specified indexes
                        while ( i-- ) {
                            if ( seed[ (j = matchIndexes[i]) ] ) {
                                seed[j] = !(matches[j] = seed[j]);
                            }
                        }
                    });
                });
            }

            /**
             * Checks a node for validity as a Sizzle context
             * @param {Element|Object=} context
             * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
             */
            function testContext( context ) {
                return context && typeof context.getElementsByTagName !== "undefined" && context;
            }

// Expose support vars for convenience
            support = Sizzle.support = {};

            /**
             * Detects XML nodes
             * @param {Element|Object} elem An element or a document
             * @returns {Boolean} True iff elem is a non-HTML XML node
             */
            isXML = Sizzle.isXML = function( elem ) {
                // documentElement is verified for cases where it doesn't yet exist
                // (such as loading iframes in IE - #4833)
                var documentElement = elem && (elem.ownerDocument || elem).documentElement;
                return documentElement ? documentElement.nodeName !== "HTML" : false;
            };

            /**
             * Sets document-related variables once based on the current document
             * @param {Element|Object} [doc] An element or document object to use to set the document
             * @returns {Object} Returns the current document
             */
            setDocument = Sizzle.setDocument = function( node ) {
                var hasCompare, subWindow,
                    doc = node ? node.ownerDocument || node : preferredDoc;

                // Return early if doc is invalid or already selected
                if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {
                    return document;
                }

                // Update global variables
                document = doc;
                docElem = document.documentElement;
                documentIsHTML = !isXML( document );

                // Support: IE 9-11, Edge
                // Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
                if ( preferredDoc !== document &&
                    (subWindow = document.defaultView) && subWindow.top !== subWindow ) {

                    // Support: IE 11, Edge
                    if ( subWindow.addEventListener ) {
                        subWindow.addEventListener( "unload", unloadHandler, false );

                        // Support: IE 9 - 10 only
                    } else if ( subWindow.attachEvent ) {
                        subWindow.attachEvent( "onunload", unloadHandler );
                    }
                }

                /* Attributes
                 ---------------------------------------------------------------------- */

                // Support: IE<8
                // Verify that getAttribute really returns attributes and not properties
                // (excepting IE8 booleans)
                support.attributes = assert(function( el ) {
                    el.className = "i";
                    return !el.getAttribute("className");
                });

                /* getElement(s)By*
                 ---------------------------------------------------------------------- */

                // Check if getElementsByTagName("*") returns only elements
                support.getElementsByTagName = assert(function( el ) {
                    el.appendChild( document.createComment("") );
                    return !el.getElementsByTagName("*").length;
                });

                // Support: IE<9
                support.getElementsByClassName = rnative.test( document.getElementsByClassName );

                // Support: IE<10
                // Check if getElementById returns elements by name
                // The broken getElementById methods don't pick up programmatically-set names,
                // so use a roundabout getElementsByName test
                support.getById = assert(function( el ) {
                    docElem.appendChild( el ).id = expando;
                    return !document.getElementsByName || !document.getElementsByName( expando ).length;
                });

                // ID find and filter
                if ( support.getById ) {
                    Expr.find["ID"] = function( id, context ) {
                        if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
                            var m = context.getElementById( id );
                            return m ? [ m ] : [];
                        }
                    };
                    Expr.filter["ID"] = function( id ) {
                        var attrId = id.replace( runescape, funescape );
                        return function( elem ) {
                            return elem.getAttribute("id") === attrId;
                        };
                    };
                } else {
                    // Support: IE6/7
                    // getElementById is not reliable as a find shortcut
                    delete Expr.find["ID"];

                    Expr.filter["ID"] =  function( id ) {
                        var attrId = id.replace( runescape, funescape );
                        return function( elem ) {
                            var node = typeof elem.getAttributeNode !== "undefined" &&
                                elem.getAttributeNode("id");
                            return node && node.value === attrId;
                        };
                    };
                }

                // Tag
                Expr.find["TAG"] = support.getElementsByTagName ?
                    function( tag, context ) {
                        if ( typeof context.getElementsByTagName !== "undefined" ) {
                            return context.getElementsByTagName( tag );

                            // DocumentFragment nodes don't have gEBTN
                        } else if ( support.qsa ) {
                            return context.querySelectorAll( tag );
                        }
                    } :

                    function( tag, context ) {
                        var elem,
                            tmp = [],
                            i = 0,
                        // By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
                            results = context.getElementsByTagName( tag );

                        // Filter out possible comments
                        if ( tag === "*" ) {
                            while ( (elem = results[i++]) ) {
                                if ( elem.nodeType === 1 ) {
                                    tmp.push( elem );
                                }
                            }

                            return tmp;
                        }
                        return results;
                    };

                // Class
                Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {
                        if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
                            return context.getElementsByClassName( className );
                        }
                    };

                /* QSA/matchesSelector
                 ---------------------------------------------------------------------- */

                // QSA and matchesSelector support

                // matchesSelector(:active) reports false when true (IE9/Opera 11.5)
                rbuggyMatches = [];

                // qSa(:focus) reports false when true (Chrome 21)
                // We allow this because of a bug in IE8/9 that throws an error
                // whenever `document.activeElement` is accessed on an iframe
                // So, we allow :focus to pass through QSA all the time to avoid the IE error
                // See https://bugs.jquery.com/ticket/13378
                rbuggyQSA = [];

                if ( (support.qsa = rnative.test( document.querySelectorAll )) ) {
                    // Build QSA regex
                    // Regex strategy adopted from Diego Perini
                    assert(function( el ) {
                        // Select is set to empty string on purpose
                        // This is to test IE's treatment of not explicitly
                        // setting a boolean content attribute,
                        // since its presence should be enough
                        // https://bugs.jquery.com/ticket/12359
                        docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
                            "<select id='" + expando + "-\r\\' msallowcapture=''>" +
                            "<option selected=''></option></select>";

                        // Support: IE8, Opera 11-12.16
                        // Nothing should be selected when empty strings follow ^= or $= or *=
                        // The test attribute must be unknown in Opera but "safe" for WinRT
                        // https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
                        if ( el.querySelectorAll("[msallowcapture^='']").length ) {
                            rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
                        }

                        // Support: IE8
                        // Boolean attributes and "value" are not treated correctly
                        if ( !el.querySelectorAll("[selected]").length ) {
                            rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
                        }

                        // Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
                        if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
                            rbuggyQSA.push("~=");
                        }

                        // Webkit/Opera - :checked should return selected option elements
                        // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                        // IE8 throws error here and will not see later tests
                        if ( !el.querySelectorAll(":checked").length ) {
                            rbuggyQSA.push(":checked");
                        }

                        // Support: Safari 8+, iOS 8+
                        // https://bugs.webkit.org/show_bug.cgi?id=136851
                        // In-page `selector#id sibling-combinator selector` fails
                        if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
                            rbuggyQSA.push(".#.+[+~]");
                        }
                    });

                    assert(function( el ) {
                        el.innerHTML = "<a href='' disabled='disabled'></a>" +
                            "<select disabled='disabled'><option/></select>";

                        // Support: Windows 8 Native Apps
                        // The type and name attributes are restricted during .innerHTML assignment
                        var input = document.createElement("input");
                        input.setAttribute( "type", "hidden" );
                        el.appendChild( input ).setAttribute( "name", "D" );

                        // Support: IE8
                        // Enforce case-sensitivity of name attribute
                        if ( el.querySelectorAll("[name=d]").length ) {
                            rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
                        }

                        // FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
                        // IE8 throws error here and will not see later tests
                        if ( el.querySelectorAll(":enabled").length !== 2 ) {
                            rbuggyQSA.push( ":enabled", ":disabled" );
                        }

                        // Support: IE9-11+
                        // IE's :disabled selector does not pick up the children of disabled fieldsets
                        docElem.appendChild( el ).disabled = true;
                        if ( el.querySelectorAll(":disabled").length !== 2 ) {
                            rbuggyQSA.push( ":enabled", ":disabled" );
                        }

                        // Opera 10-11 does not throw on post-comma invalid pseudos
                        el.querySelectorAll("*,:x");
                        rbuggyQSA.push(",.*:");
                    });
                }

                if ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||
                        docElem.webkitMatchesSelector ||
                        docElem.mozMatchesSelector ||
                        docElem.oMatchesSelector ||
                        docElem.msMatchesSelector) )) ) {

                    assert(function( el ) {
                        // Check to see if it's possible to do matchesSelector
                        // on a disconnected node (IE 9)
                        support.disconnectedMatch = matches.call( el, "*" );

                        // This should fail with an exception
                        // Gecko does not error, returns false instead
                        matches.call( el, "[s!='']:x" );
                        rbuggyMatches.push( "!=", pseudos );
                    });
                }

                rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );
                rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );

                /* Contains
                 ---------------------------------------------------------------------- */
                hasCompare = rnative.test( docElem.compareDocumentPosition );

                // Element contains another
                // Purposefully self-exclusive
                // As in, an element does not contain itself
                contains = hasCompare || rnative.test( docElem.contains ) ?
                    function( a, b ) {
                        var adown = a.nodeType === 9 ? a.documentElement : a,
                            bup = b && b.parentNode;
                        return a === bup || !!( bup && bup.nodeType === 1 && (
                                adown.contains ?
                                    adown.contains( bup ) :
                                a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
                            ));
                    } :
                    function( a, b ) {
                        if ( b ) {
                            while ( (b = b.parentNode) ) {
                                if ( b === a ) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    };

                /* Sorting
                 ---------------------------------------------------------------------- */

                // Document order sorting
                sortOrder = hasCompare ?
                    function( a, b ) {

                        // Flag for duplicate removal
                        if ( a === b ) {
                            hasDuplicate = true;
                            return 0;
                        }

                        // Sort on method existence if only one input has compareDocumentPosition
                        var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
                        if ( compare ) {
                            return compare;
                        }

                        // Calculate position if both inputs belong to the same document
                        compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?
                            a.compareDocumentPosition( b ) :

                            // Otherwise we know they are disconnected
                            1;

                        // Disconnected nodes
                        if ( compare & 1 ||
                            (!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {

                            // Choose the first element that is related to our preferred document
                            if ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {
                                return -1;
                            }
                            if ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {
                                return 1;
                            }

                            // Maintain original order
                            return sortInput ?
                                ( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
                                0;
                        }

                        return compare & 4 ? -1 : 1;
                    } :
                    function( a, b ) {
                        // Exit early if the nodes are identical
                        if ( a === b ) {
                            hasDuplicate = true;
                            return 0;
                        }

                        var cur,
                            i = 0,
                            aup = a.parentNode,
                            bup = b.parentNode,
                            ap = [ a ],
                            bp = [ b ];

                        // Parentless nodes are either documents or disconnected
                        if ( !aup || !bup ) {
                            return a === document ? -1 :
                                b === document ? 1 :
                                    aup ? -1 :
                                        bup ? 1 :
                                            sortInput ?
                                                ( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
                                                0;

                            // If the nodes are siblings, we can do a quick check
                        } else if ( aup === bup ) {
                            return siblingCheck( a, b );
                        }

                        // Otherwise we need full lists of their ancestors for comparison
                        cur = a;
                        while ( (cur = cur.parentNode) ) {
                            ap.unshift( cur );
                        }
                        cur = b;
                        while ( (cur = cur.parentNode) ) {
                            bp.unshift( cur );
                        }

                        // Walk down the tree looking for a discrepancy
                        while ( ap[i] === bp[i] ) {
                            i++;
                        }

                        return i ?
                            // Do a sibling check if the nodes have a common ancestor
                            siblingCheck( ap[i], bp[i] ) :

                            // Otherwise nodes in our document sort first
                            ap[i] === preferredDoc ? -1 :
                                bp[i] === preferredDoc ? 1 :
                                    0;
                    };

                return document;
            };

            Sizzle.matches = function( expr, elements ) {
                return Sizzle( expr, null, null, elements );
            };

            Sizzle.matchesSelector = function( elem, expr ) {
                // Set document vars if needed
                if ( ( elem.ownerDocument || elem ) !== document ) {
                    setDocument( elem );
                }

                // Make sure that attribute selectors are quoted
                expr = expr.replace( rattributeQuotes, "='$1']" );

                if ( support.matchesSelector && documentIsHTML &&
                    !compilerCache[ expr + " " ] &&
                    ( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
                    ( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

                    try {
                        var ret = matches.call( elem, expr );

                        // IE 9's matchesSelector returns false on disconnected nodes
                        if ( ret || support.disconnectedMatch ||
                                // As well, disconnected nodes are said to be in a document
                                // fragment in IE 9
                            elem.document && elem.document.nodeType !== 11 ) {
                            return ret;
                        }
                    } catch (e) {}
                }

                return Sizzle( expr, document, null, [ elem ] ).length > 0;
            };

            Sizzle.contains = function( context, elem ) {
                // Set document vars if needed
                if ( ( context.ownerDocument || context ) !== document ) {
                    setDocument( context );
                }
                return contains( context, elem );
            };

            Sizzle.attr = function( elem, name ) {
                // Set document vars if needed
                if ( ( elem.ownerDocument || elem ) !== document ) {
                    setDocument( elem );
                }

                var fn = Expr.attrHandle[ name.toLowerCase() ],
                // Don't get fooled by Object.prototype properties (jQuery #13807)
                    val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
                        fn( elem, name, !documentIsHTML ) :
                        undefined;

                return val !== undefined ?
                    val :
                    support.attributes || !documentIsHTML ?
                        elem.getAttribute( name ) :
                        (val = elem.getAttributeNode(name)) && val.specified ?
                            val.value :
                            null;
            };

            Sizzle.escape = function( sel ) {
                return (sel + "").replace( rcssescape, fcssescape );
            };

            Sizzle.error = function( msg ) {
                throw new Error( "Syntax error, unrecognized expression: " + msg );
            };

            /**
             * Document sorting and removing duplicates
             * @param {ArrayLike} results
             */
            Sizzle.uniqueSort = function( results ) {
                var elem,
                    duplicates = [],
                    j = 0,
                    i = 0;

                // Unless we *know* we can detect duplicates, assume their presence
                hasDuplicate = !support.detectDuplicates;
                sortInput = !support.sortStable && results.slice( 0 );
                results.sort( sortOrder );

                if ( hasDuplicate ) {
                    while ( (elem = results[i++]) ) {
                        if ( elem === results[ i ] ) {
                            j = duplicates.push( i );
                        }
                    }
                    while ( j-- ) {
                        results.splice( duplicates[ j ], 1 );
                    }
                }

                // Clear input after sorting to release objects
                // See https://github.com/jquery/sizzle/pull/225
                sortInput = null;

                return results;
            };

            /**
             * Utility function for retrieving the text value of an array of DOM nodes
             * @param {Array|Element} elem
             */
            getText = Sizzle.getText = function( elem ) {
                var node,
                    ret = "",
                    i = 0,
                    nodeType = elem.nodeType;

                if ( !nodeType ) {
                    // If no nodeType, this is expected to be an array
                    while ( (node = elem[i++]) ) {
                        // Do not traverse comment nodes
                        ret += getText( node );
                    }
                } else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
                    // Use textContent for elements
                    // innerText usage removed for consistency of new lines (jQuery #11153)
                    if ( typeof elem.textContent === "string" ) {
                        return elem.textContent;
                    } else {
                        // Traverse its children
                        for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
                            ret += getText( elem );
                        }
                    }
                } else if ( nodeType === 3 || nodeType === 4 ) {
                    return elem.nodeValue;
                }
                // Do not include comment or processing instruction nodes

                return ret;
            };

            Expr = Sizzle.selectors = {

                // Can be adjusted by the user
                cacheLength: 50,

                createPseudo: markFunction,

                match: matchExpr,

                attrHandle: {},

                find: {},

                relative: {
                    ">": { dir: "parentNode", first: true },
                    " ": { dir: "parentNode" },
                    "+": { dir: "previousSibling", first: true },
                    "~": { dir: "previousSibling" }
                },

                preFilter: {
                    "ATTR": function( match ) {
                        match[1] = match[1].replace( runescape, funescape );

                        // Move the given value to match[3] whether quoted or unquoted
                        match[3] = ( match[3] || match[4] || match[5] || "" ).replace( runescape, funescape );

                        if ( match[2] === "~=" ) {
                            match[3] = " " + match[3] + " ";
                        }

                        return match.slice( 0, 4 );
                    },

                    "CHILD": function( match ) {
                        /* matches from matchExpr["CHILD"]
                         1 type (only|nth|...)
                         2 what (child|of-type)
                         3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
                         4 xn-component of xn+y argument ([+-]?\d*n|)
                         5 sign of xn-component
                         6 x of xn-component
                         7 sign of y-component
                         8 y of y-component
                         */
                        match[1] = match[1].toLowerCase();

                        if ( match[1].slice( 0, 3 ) === "nth" ) {
                            // nth-* requires argument
                            if ( !match[3] ) {
                                Sizzle.error( match[0] );
                            }

                            // numeric x and y parameters for Expr.filter.CHILD
                            // remember that false/true cast respectively to 0/1
                            match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );
                            match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );

                            // other types prohibit arguments
                        } else if ( match[3] ) {
                            Sizzle.error( match[0] );
                        }

                        return match;
                    },

                    "PSEUDO": function( match ) {
                        var excess,
                            unquoted = !match[6] && match[2];

                        if ( matchExpr["CHILD"].test( match[0] ) ) {
                            return null;
                        }

                        // Accept quoted arguments as-is
                        if ( match[3] ) {
                            match[2] = match[4] || match[5] || "";

                            // Strip excess characters from unquoted arguments
                        } else if ( unquoted && rpseudo.test( unquoted ) &&
                                // Get excess from tokenize (recursively)
                            (excess = tokenize( unquoted, true )) &&
                                // advance to the next closing parenthesis
                            (excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

                            // excess is a negative index
                            match[0] = match[0].slice( 0, excess );
                            match[2] = unquoted.slice( 0, excess );
                        }

                        // Return only captures needed by the pseudo filter method (type and argument)
                        return match.slice( 0, 3 );
                    }
                },

                filter: {

                    "TAG": function( nodeNameSelector ) {
                        var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
                        return nodeNameSelector === "*" ?
                            function() { return true; } :
                            function( elem ) {
                                return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
                            };
                    },

                    "CLASS": function( className ) {
                        var pattern = classCache[ className + " " ];

                        return pattern ||
                            (pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
                            classCache( className, function( elem ) {
                                return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "" );
                            });
                    },

                    "ATTR": function( name, operator, check ) {
                        return function( elem ) {
                            var result = Sizzle.attr( elem, name );

                            if ( result == null ) {
                                return operator === "!=";
                            }
                            if ( !operator ) {
                                return true;
                            }

                            result += "";

                            return operator === "=" ? result === check :
                                operator === "!=" ? result !== check :
                                    operator === "^=" ? check && result.indexOf( check ) === 0 :
                                        operator === "*=" ? check && result.indexOf( check ) > -1 :
                                            operator === "$=" ? check && result.slice( -check.length ) === check :
                                                operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
                                                    operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
                                                        false;
                        };
                    },

                    "CHILD": function( type, what, argument, first, last ) {
                        var simple = type.slice( 0, 3 ) !== "nth",
                            forward = type.slice( -4 ) !== "last",
                            ofType = what === "of-type";

                        return first === 1 && last === 0 ?

                            // Shortcut for :nth-*(n)
                            function( elem ) {
                                return !!elem.parentNode;
                            } :

                            function( elem, context, xml ) {
                                var cache, uniqueCache, outerCache, node, nodeIndex, start,
                                    dir = simple !== forward ? "nextSibling" : "previousSibling",
                                    parent = elem.parentNode,
                                    name = ofType && elem.nodeName.toLowerCase(),
                                    useCache = !xml && !ofType,
                                    diff = false;

                                if ( parent ) {

                                    // :(first|last|only)-(child|of-type)
                                    if ( simple ) {
                                        while ( dir ) {
                                            node = elem;
                                            while ( (node = node[ dir ]) ) {
                                                if ( ofType ?
                                                    node.nodeName.toLowerCase() === name :
                                                    node.nodeType === 1 ) {

                                                    return false;
                                                }
                                            }
                                            // Reverse direction for :only-* (if we haven't yet done so)
                                            start = dir = type === "only" && !start && "nextSibling";
                                        }
                                        return true;
                                    }

                                    start = [ forward ? parent.firstChild : parent.lastChild ];

                                    // non-xml :nth-child(...) stores cache data on `parent`
                                    if ( forward && useCache ) {

                                        // Seek `elem` from a previously-cached index

                                        // ...in a gzip-friendly way
                                        node = parent;
                                        outerCache = node[ expando ] || (node[ expando ] = {});

                                        // Support: IE <9 only
                                        // Defend against cloned attroperties (jQuery gh-1709)
                                        uniqueCache = outerCache[ node.uniqueID ] ||
                                            (outerCache[ node.uniqueID ] = {});

                                        cache = uniqueCache[ type ] || [];
                                        nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
                                        diff = nodeIndex && cache[ 2 ];
                                        node = nodeIndex && parent.childNodes[ nodeIndex ];

                                        while ( (node = ++nodeIndex && node && node[ dir ] ||

                                                // Fallback to seeking `elem` from the start
                                            (diff = nodeIndex = 0) || start.pop()) ) {

                                            // When found, cache indexes on `parent` and break
                                            if ( node.nodeType === 1 && ++diff && node === elem ) {
                                                uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
                                                break;
                                            }
                                        }

                                    } else {
                                        // Use previously-cached element index if available
                                        if ( useCache ) {
                                            // ...in a gzip-friendly way
                                            node = elem;
                                            outerCache = node[ expando ] || (node[ expando ] = {});

                                            // Support: IE <9 only
                                            // Defend against cloned attroperties (jQuery gh-1709)
                                            uniqueCache = outerCache[ node.uniqueID ] ||
                                                (outerCache[ node.uniqueID ] = {});

                                            cache = uniqueCache[ type ] || [];
                                            nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
                                            diff = nodeIndex;
                                        }

                                        // xml :nth-child(...)
                                        // or :nth-last-child(...) or :nth(-last)?-of-type(...)
                                        if ( diff === false ) {
                                            // Use the same loop as above to seek `elem` from the start
                                            while ( (node = ++nodeIndex && node && node[ dir ] ||
                                                (diff = nodeIndex = 0) || start.pop()) ) {

                                                if ( ( ofType ?
                                                    node.nodeName.toLowerCase() === name :
                                                    node.nodeType === 1 ) &&
                                                    ++diff ) {

                                                    // Cache the index of each encountered element
                                                    if ( useCache ) {
                                                        outerCache = node[ expando ] || (node[ expando ] = {});

                                                        // Support: IE <9 only
                                                        // Defend against cloned attroperties (jQuery gh-1709)
                                                        uniqueCache = outerCache[ node.uniqueID ] ||
                                                            (outerCache[ node.uniqueID ] = {});

                                                        uniqueCache[ type ] = [ dirruns, diff ];
                                                    }

                                                    if ( node === elem ) {
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    // Incorporate the offset, then check against cycle size
                                    diff -= last;
                                    return diff === first || ( diff % first === 0 && diff / first >= 0 );
                                }
                            };
                    },

                    "PSEUDO": function( pseudo, argument ) {
                        // pseudo-class names are case-insensitive
                        // http://www.w3.org/TR/selectors/#pseudo-classes
                        // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
                        // Remember that setFilters inherits from pseudos
                        var args,
                            fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
                                Sizzle.error( "unsupported pseudo: " + pseudo );

                        // The user may use createPseudo to indicate that
                        // arguments are needed to create the filter function
                        // just as Sizzle does
                        if ( fn[ expando ] ) {
                            return fn( argument );
                        }

                        // But maintain support for old signatures
                        if ( fn.length > 1 ) {
                            args = [ pseudo, pseudo, "", argument ];
                            return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
                                markFunction(function( seed, matches ) {
                                    var idx,
                                        matched = fn( seed, argument ),
                                        i = matched.length;
                                    while ( i-- ) {
                                        idx = indexOf( seed, matched[i] );
                                        seed[ idx ] = !( matches[ idx ] = matched[i] );
                                    }
                                }) :
                                function( elem ) {
                                    return fn( elem, 0, args );
                                };
                        }

                        return fn;
                    }
                },

                pseudos: {
                    // Potentially complex pseudos
                    "not": markFunction(function( selector ) {
                        // Trim the selector passed to compile
                        // to avoid treating leading and trailing
                        // spaces as combinators
                        var input = [],
                            results = [],
                            matcher = compile( selector.replace( rtrim, "$1" ) );

                        return matcher[ expando ] ?
                            markFunction(function( seed, matches, context, xml ) {
                                var elem,
                                    unmatched = matcher( seed, null, xml, [] ),
                                    i = seed.length;

                                // Match elements unmatched by `matcher`
                                while ( i-- ) {
                                    if ( (elem = unmatched[i]) ) {
                                        seed[i] = !(matches[i] = elem);
                                    }
                                }
                            }) :
                            function( elem, context, xml ) {
                                input[0] = elem;
                                matcher( input, null, xml, results );
                                // Don't keep the element (issue #299)
                                input[0] = null;
                                return !results.pop();
                            };
                    }),

                    "has": markFunction(function( selector ) {
                        return function( elem ) {
                            return Sizzle( selector, elem ).length > 0;
                        };
                    }),

                    "contains": markFunction(function( text ) {
                        text = text.replace( runescape, funescape );
                        return function( elem ) {
                            return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
                        };
                    }),

                    // "Whether an element is represented by a :lang() selector
                    // is based solely on the element's language value
                    // being equal to the identifier C,
                    // or beginning with the identifier C immediately followed by "-".
                    // The matching of C against the element's language value is performed case-insensitively.
                    // The identifier C does not have to be a valid language name."
                    // http://www.w3.org/TR/selectors/#lang-pseudo
                    "lang": markFunction( function( lang ) {
                        // lang value must be a valid identifier
                        if ( !ridentifier.test(lang || "") ) {
                            Sizzle.error( "unsupported lang: " + lang );
                        }
                        lang = lang.replace( runescape, funescape ).toLowerCase();
                        return function( elem ) {
                            var elemLang;
                            do {
                                if ( (elemLang = documentIsHTML ?
                                        elem.lang :
                                    elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {

                                    elemLang = elemLang.toLowerCase();
                                    return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
                                }
                            } while ( (elem = elem.parentNode) && elem.nodeType === 1 );
                            return false;
                        };
                    }),

                    // Miscellaneous
                    "target": function( elem ) {
                        var hash = window.location && window.location.hash;
                        return hash && hash.slice( 1 ) === elem.id;
                    },

                    "root": function( elem ) {
                        return elem === docElem;
                    },

                    "focus": function( elem ) {
                        return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
                    },

                    // Boolean properties
                    "enabled": createDisabledPseudo( false ),
                    "disabled": createDisabledPseudo( true ),

                    "checked": function( elem ) {
                        // In CSS3, :checked should return both checked and selected elements
                        // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                        var nodeName = elem.nodeName.toLowerCase();
                        return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
                    },

                    "selected": function( elem ) {
                        // Accessing this property makes selected-by-default
                        // options in Safari work properly
                        if ( elem.parentNode ) {
                            elem.parentNode.selectedIndex;
                        }

                        return elem.selected === true;
                    },

                    // Contents
                    "empty": function( elem ) {
                        // http://www.w3.org/TR/selectors/#empty-pseudo
                        // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
                        //   but not by others (comment: 8; processing instruction: 7; etc.)
                        // nodeType < 6 works because attributes (2) do not appear as children
                        for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
                            if ( elem.nodeType < 6 ) {
                                return false;
                            }
                        }
                        return true;
                    },

                    "parent": function( elem ) {
                        return !Expr.pseudos["empty"]( elem );
                    },

                    // Element/input types
                    "header": function( elem ) {
                        return rheader.test( elem.nodeName );
                    },

                    "input": function( elem ) {
                        return rinputs.test( elem.nodeName );
                    },

                    "button": function( elem ) {
                        var name = elem.nodeName.toLowerCase();
                        return name === "input" && elem.type === "button" || name === "button";
                    },

                    "text": function( elem ) {
                        var attr;
                        return elem.nodeName.toLowerCase() === "input" &&
                            elem.type === "text" &&

                                // Support: IE<8
                                // New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
                            ( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );
                    },

                    // Position-in-collection
                    "first": createPositionalPseudo(function() {
                        return [ 0 ];
                    }),

                    "last": createPositionalPseudo(function( matchIndexes, length ) {
                        return [ length - 1 ];
                    }),

                    "eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
                        return [ argument < 0 ? argument + length : argument ];
                    }),

                    "even": createPositionalPseudo(function( matchIndexes, length ) {
                        var i = 0;
                        for ( ; i < length; i += 2 ) {
                            matchIndexes.push( i );
                        }
                        return matchIndexes;
                    }),

                    "odd": createPositionalPseudo(function( matchIndexes, length ) {
                        var i = 1;
                        for ( ; i < length; i += 2 ) {
                            matchIndexes.push( i );
                        }
                        return matchIndexes;
                    }),

                    "lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
                        var i = argument < 0 ? argument + length : argument;
                        for ( ; --i >= 0; ) {
                            matchIndexes.push( i );
                        }
                        return matchIndexes;
                    }),

                    "gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
                        var i = argument < 0 ? argument + length : argument;
                        for ( ; ++i < length; ) {
                            matchIndexes.push( i );
                        }
                        return matchIndexes;
                    })
                }
            };

            Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Add button/input type pseudos
            for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
                Expr.pseudos[ i ] = createInputPseudo( i );
            }
            for ( i in { submit: true, reset: true } ) {
                Expr.pseudos[ i ] = createButtonPseudo( i );
            }

// Easy API for creating new setFilters
            function setFilters() {}
            setFilters.prototype = Expr.filters = Expr.pseudos;
            Expr.setFilters = new setFilters();

            tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
                var matched, match, tokens, type,
                    soFar, groups, preFilters,
                    cached = tokenCache[ selector + " " ];

                if ( cached ) {
                    return parseOnly ? 0 : cached.slice( 0 );
                }

                soFar = selector;
                groups = [];
                preFilters = Expr.preFilter;

                while ( soFar ) {

                    // Comma and first run
                    if ( !matched || (match = rcomma.exec( soFar )) ) {
                        if ( match ) {
                            // Don't consume trailing commas as valid
                            soFar = soFar.slice( match[0].length ) || soFar;
                        }
                        groups.push( (tokens = []) );
                    }

                    matched = false;

                    // Combinators
                    if ( (match = rcombinators.exec( soFar )) ) {
                        matched = match.shift();
                        tokens.push({
                            value: matched,
                            // Cast descendant combinators to space
                            type: match[0].replace( rtrim, " " )
                        });
                        soFar = soFar.slice( matched.length );
                    }

                    // Filters
                    for ( type in Expr.filter ) {
                        if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
                            (match = preFilters[ type ]( match ))) ) {
                            matched = match.shift();
                            tokens.push({
                                value: matched,
                                type: type,
                                matches: match
                            });
                            soFar = soFar.slice( matched.length );
                        }
                    }

                    if ( !matched ) {
                        break;
                    }
                }

                // Return the length of the invalid excess
                // if we're just parsing
                // Otherwise, throw an error or return tokens
                return parseOnly ?
                    soFar.length :
                    soFar ?
                        Sizzle.error( selector ) :
                        // Cache the tokens
                        tokenCache( selector, groups ).slice( 0 );
            };

            function toSelector( tokens ) {
                var i = 0,
                    len = tokens.length,
                    selector = "";
                for ( ; i < len; i++ ) {
                    selector += tokens[i].value;
                }
                return selector;
            }

            function addCombinator( matcher, combinator, base ) {
                var dir = combinator.dir,
                    skip = combinator.next,
                    key = skip || dir,
                    checkNonElements = base && key === "parentNode",
                    doneName = done++;

                return combinator.first ?
                    // Check against closest ancestor/preceding element
                    function( elem, context, xml ) {
                        while ( (elem = elem[ dir ]) ) {
                            if ( elem.nodeType === 1 || checkNonElements ) {
                                return matcher( elem, context, xml );
                            }
                        }
                    } :

                    // Check against all ancestor/preceding elements
                    function( elem, context, xml ) {
                        var oldCache, uniqueCache, outerCache,
                            newCache = [ dirruns, doneName ];

                        // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
                        if ( xml ) {
                            while ( (elem = elem[ dir ]) ) {
                                if ( elem.nodeType === 1 || checkNonElements ) {
                                    if ( matcher( elem, context, xml ) ) {
                                        return true;
                                    }
                                }
                            }
                        } else {
                            while ( (elem = elem[ dir ]) ) {
                                if ( elem.nodeType === 1 || checkNonElements ) {
                                    outerCache = elem[ expando ] || (elem[ expando ] = {});

                                    // Support: IE <9 only
                                    // Defend against cloned attroperties (jQuery gh-1709)
                                    uniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});

                                    if ( skip && skip === elem.nodeName.toLowerCase() ) {
                                        elem = elem[ dir ] || elem;
                                    } else if ( (oldCache = uniqueCache[ key ]) &&
                                        oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

                                        // Assign to newCache so results back-propagate to previous elements
                                        return (newCache[ 2 ] = oldCache[ 2 ]);
                                    } else {
                                        // Reuse newcache so results back-propagate to previous elements
                                        uniqueCache[ key ] = newCache;

                                        // A match means we're done; a fail means we have to keep checking
                                        if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    };
            }

            function elementMatcher( matchers ) {
                return matchers.length > 1 ?
                    function( elem, context, xml ) {
                        var i = matchers.length;
                        while ( i-- ) {
                            if ( !matchers[i]( elem, context, xml ) ) {
                                return false;
                            }
                        }
                        return true;
                    } :
                    matchers[0];
            }

            function multipleContexts( selector, contexts, results ) {
                var i = 0,
                    len = contexts.length;
                for ( ; i < len; i++ ) {
                    Sizzle( selector, contexts[i], results );
                }
                return results;
            }

            function condense( unmatched, map, filter, context, xml ) {
                var elem,
                    newUnmatched = [],
                    i = 0,
                    len = unmatched.length,
                    mapped = map != null;

                for ( ; i < len; i++ ) {
                    if ( (elem = unmatched[i]) ) {
                        if ( !filter || filter( elem, context, xml ) ) {
                            newUnmatched.push( elem );
                            if ( mapped ) {
                                map.push( i );
                            }
                        }
                    }
                }

                return newUnmatched;
            }

            function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
                if ( postFilter && !postFilter[ expando ] ) {
                    postFilter = setMatcher( postFilter );
                }
                if ( postFinder && !postFinder[ expando ] ) {
                    postFinder = setMatcher( postFinder, postSelector );
                }
                return markFunction(function( seed, results, context, xml ) {
                    var temp, i, elem,
                        preMap = [],
                        postMap = [],
                        preexisting = results.length,

                    // Get initial elements from seed or context
                        elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

                    // Prefilter to get matcher input, preserving a map for seed-results synchronization
                        matcherIn = preFilter && ( seed || !selector ) ?
                            condense( elems, preMap, preFilter, context, xml ) :
                            elems,

                        matcherOut = matcher ?
                            // If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
                            postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

                                // ...intermediate processing is necessary
                                [] :

                                // ...otherwise use results directly
                                results :
                            matcherIn;

                    // Find primary matches
                    if ( matcher ) {
                        matcher( matcherIn, matcherOut, context, xml );
                    }

                    // Apply postFilter
                    if ( postFilter ) {
                        temp = condense( matcherOut, postMap );
                        postFilter( temp, [], context, xml );

                        // Un-match failing elements by moving them back to matcherIn
                        i = temp.length;
                        while ( i-- ) {
                            if ( (elem = temp[i]) ) {
                                matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
                            }
                        }
                    }

                    if ( seed ) {
                        if ( postFinder || preFilter ) {
                            if ( postFinder ) {
                                // Get the final matcherOut by condensing this intermediate into postFinder contexts
                                temp = [];
                                i = matcherOut.length;
                                while ( i-- ) {
                                    if ( (elem = matcherOut[i]) ) {
                                        // Restore matcherIn since elem is not yet a final match
                                        temp.push( (matcherIn[i] = elem) );
                                    }
                                }
                                postFinder( null, (matcherOut = []), temp, xml );
                            }

                            // Move matched elements from seed to results to keep them synchronized
                            i = matcherOut.length;
                            while ( i-- ) {
                                if ( (elem = matcherOut[i]) &&
                                    (temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {

                                    seed[temp] = !(results[temp] = elem);
                                }
                            }
                        }

                        // Add elements to results, through postFinder if defined
                    } else {
                        matcherOut = condense(
                            matcherOut === results ?
                                matcherOut.splice( preexisting, matcherOut.length ) :
                                matcherOut
                        );
                        if ( postFinder ) {
                            postFinder( null, results, matcherOut, xml );
                        } else {
                            push.apply( results, matcherOut );
                        }
                    }
                });
            }

            function matcherFromTokens( tokens ) {
                var checkContext, matcher, j,
                    len = tokens.length,
                    leadingRelative = Expr.relative[ tokens[0].type ],
                    implicitRelative = leadingRelative || Expr.relative[" "],
                    i = leadingRelative ? 1 : 0,

                // The foundational matcher ensures that elements are reachable from top-level context(s)
                    matchContext = addCombinator( function( elem ) {
                        return elem === checkContext;
                    }, implicitRelative, true ),
                    matchAnyContext = addCombinator( function( elem ) {
                        return indexOf( checkContext, elem ) > -1;
                    }, implicitRelative, true ),
                    matchers = [ function( elem, context, xml ) {
                        var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
                                (checkContext = context).nodeType ?
                                    matchContext( elem, context, xml ) :
                                    matchAnyContext( elem, context, xml ) );
                        // Avoid hanging onto element (issue #299)
                        checkContext = null;
                        return ret;
                    } ];

                for ( ; i < len; i++ ) {
                    if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
                        matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];
                    } else {
                        matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

                        // Return special upon seeing a positional matcher
                        if ( matcher[ expando ] ) {
                            // Find the next relative operator (if any) for proper handling
                            j = ++i;
                            for ( ; j < len; j++ ) {
                                if ( Expr.relative[ tokens[j].type ] ) {
                                    break;
                                }
                            }
                            return setMatcher(
                                i > 1 && elementMatcher( matchers ),
                                i > 1 && toSelector(
                                    // If the preceding token was a descendant combinator, insert an implicit any-element `*`
                                    tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })
                                ).replace( rtrim, "$1" ),
                                matcher,
                                i < j && matcherFromTokens( tokens.slice( i, j ) ),
                                j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
                                j < len && toSelector( tokens )
                            );
                        }
                        matchers.push( matcher );
                    }
                }

                return elementMatcher( matchers );
            }

            function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
                var bySet = setMatchers.length > 0,
                    byElement = elementMatchers.length > 0,
                    superMatcher = function( seed, context, xml, results, outermost ) {
                        var elem, j, matcher,
                            matchedCount = 0,
                            i = "0",
                            unmatched = seed && [],
                            setMatched = [],
                            contextBackup = outermostContext,
                        // We must always have either seed elements or outermost context
                            elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),
                        // Use integer dirruns iff this is the outermost matcher
                            dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),
                            len = elems.length;

                        if ( outermost ) {
                            outermostContext = context === document || context || outermost;
                        }

                        // Add elements passing elementMatchers directly to results
                        // Support: IE<9, Safari
                        // Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
                        for ( ; i !== len && (elem = elems[i]) != null; i++ ) {
                            if ( byElement && elem ) {
                                j = 0;
                                if ( !context && elem.ownerDocument !== document ) {
                                    setDocument( elem );
                                    xml = !documentIsHTML;
                                }
                                while ( (matcher = elementMatchers[j++]) ) {
                                    if ( matcher( elem, context || document, xml) ) {
                                        results.push( elem );
                                        break;
                                    }
                                }
                                if ( outermost ) {
                                    dirruns = dirrunsUnique;
                                }
                            }

                            // Track unmatched elements for set filters
                            if ( bySet ) {
                                // They will have gone through all possible matchers
                                if ( (elem = !matcher && elem) ) {
                                    matchedCount--;
                                }

                                // Lengthen the array for every element, matched or not
                                if ( seed ) {
                                    unmatched.push( elem );
                                }
                            }
                        }

                        // `i` is now the count of elements visited above, and adding it to `matchedCount`
                        // makes the latter nonnegative.
                        matchedCount += i;

                        // Apply set filters to unmatched elements
                        // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
                        // equals `i`), unless we didn't visit _any_ elements in the above loop because we have
                        // no element matchers and no seed.
                        // Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
                        // case, which will result in a "00" `matchedCount` that differs from `i` but is also
                        // numerically zero.
                        if ( bySet && i !== matchedCount ) {
                            j = 0;
                            while ( (matcher = setMatchers[j++]) ) {
                                matcher( unmatched, setMatched, context, xml );
                            }

                            if ( seed ) {
                                // Reintegrate element matches to eliminate the need for sorting
                                if ( matchedCount > 0 ) {
                                    while ( i-- ) {
                                        if ( !(unmatched[i] || setMatched[i]) ) {
                                            setMatched[i] = pop.call( results );
                                        }
                                    }
                                }

                                // Discard index placeholder values to get only actual matches
                                setMatched = condense( setMatched );
                            }

                            // Add matches to results
                            push.apply( results, setMatched );

                            // Seedless set matches succeeding multiple successful matchers stipulate sorting
                            if ( outermost && !seed && setMatched.length > 0 &&
                                ( matchedCount + setMatchers.length ) > 1 ) {

                                Sizzle.uniqueSort( results );
                            }
                        }

                        // Override manipulation of globals by nested matchers
                        if ( outermost ) {
                            dirruns = dirrunsUnique;
                            outermostContext = contextBackup;
                        }

                        return unmatched;
                    };

                return bySet ?
                    markFunction( superMatcher ) :
                    superMatcher;
            }

            compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
                var i,
                    setMatchers = [],
                    elementMatchers = [],
                    cached = compilerCache[ selector + " " ];

                if ( !cached ) {
                    // Generate a function of recursive functions that can be used to check each element
                    if ( !match ) {
                        match = tokenize( selector );
                    }
                    i = match.length;
                    while ( i-- ) {
                        cached = matcherFromTokens( match[i] );
                        if ( cached[ expando ] ) {
                            setMatchers.push( cached );
                        } else {
                            elementMatchers.push( cached );
                        }
                    }

                    // Cache the compiled function
                    cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );

                    // Save selector and tokenization
                    cached.selector = selector;
                }
                return cached;
            };

            /**
             * A low-level selection function that works with Sizzle's compiled
             *  selector functions
             * @param {String|Function} selector A selector or a pre-compiled
             *  selector function built with Sizzle.compile
             * @param {Element} context
             * @param {Array} [results]
             * @param {Array} [seed] A set of elements to match against
             */
            select = Sizzle.select = function( selector, context, results, seed ) {
                var i, tokens, token, type, find,
                    compiled = typeof selector === "function" && selector,
                    match = !seed && tokenize( (selector = compiled.selector || selector) );

                results = results || [];

                // Try to minimize operations if there is only one selector in the list and no seed
                // (the latter of which guarantees us context)
                if ( match.length === 1 ) {

                    // Reduce context if the leading compound selector is an ID
                    tokens = match[0] = match[0].slice( 0 );
                    if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
                        support.getById && context.nodeType === 9 && documentIsHTML &&
                        Expr.relative[ tokens[1].type ] ) {

                        context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];
                        if ( !context ) {
                            return results;

                            // Precompiled matchers will still verify ancestry, so step up a level
                        } else if ( compiled ) {
                            context = context.parentNode;
                        }

                        selector = selector.slice( tokens.shift().value.length );
                    }

                    // Fetch a seed set for right-to-left matching
                    i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;
                    while ( i-- ) {
                        token = tokens[i];

                        // Abort if we hit a combinator
                        if ( Expr.relative[ (type = token.type) ] ) {
                            break;
                        }
                        if ( (find = Expr.find[ type ]) ) {
                            // Search, expanding context for leading sibling combinators
                            if ( (seed = find(
                                    token.matches[0].replace( runescape, funescape ),
                                    rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context
                                )) ) {

                                // If seed is empty or no tokens remain, we can return early
                                tokens.splice( i, 1 );
                                selector = seed.length && toSelector( tokens );
                                if ( !selector ) {
                                    push.apply( results, seed );
                                    return results;
                                }

                                break;
                            }
                        }
                    }
                }

                // Compile and execute a filtering function if one is not provided
                // Provide `match` to avoid retokenization if we modified the selector above
                ( compiled || compile( selector, match ) )(
                    seed,
                    context,
                    !documentIsHTML,
                    results,
                    !context || rsibling.test( selector ) && testContext( context.parentNode ) || context
                );
                return results;
            };

// One-time assignments

// Sort stability
            support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
            support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
            setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
            support.sortDetached = assert(function( el ) {
                // Should return 1, but returns 4 (following)
                return el.compareDocumentPosition( document.createElement("fieldset") ) & 1;
            });

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
            if ( !assert(function( el ) {
                    el.innerHTML = "<a href='#'></a>";
                    return el.firstChild.getAttribute("href") === "#" ;
                }) ) {
                addHandle( "type|href|height|width", function( elem, name, isXML ) {
                    if ( !isXML ) {
                        return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
                    }
                });
            }

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
            if ( !support.attributes || !assert(function( el ) {
                    el.innerHTML = "<input/>";
                    el.firstChild.setAttribute( "value", "" );
                    return el.firstChild.getAttribute( "value" ) === "";
                }) ) {
                addHandle( "value", function( elem, name, isXML ) {
                    if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
                        return elem.defaultValue;
                    }
                });
            }

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
            if ( !assert(function( el ) {
                    return el.getAttribute("disabled") == null;
                }) ) {
                addHandle( booleans, function( elem, name, isXML ) {
                    var val;
                    if ( !isXML ) {
                        return elem[ name ] === true ? name.toLowerCase() :
                            (val = elem.getAttributeNode( name )) && val.specified ?
                                val.value :
                                null;
                    }
                });
            }

            return Sizzle;

        })( window );



    jQuery.find = Sizzle;
    jQuery.expr = Sizzle.selectors;

// Deprecated
    jQuery.expr[ ":" ] = jQuery.expr.pseudos;
    jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
    jQuery.text = Sizzle.getText;
    jQuery.isXMLDoc = Sizzle.isXML;
    jQuery.contains = Sizzle.contains;
    jQuery.escapeSelector = Sizzle.escape;



    var dir = function( elem, dir, until ) {
        var matched = [],
            truncate = until !== undefined;

        while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
            if ( elem.nodeType === 1 ) {
                if ( truncate && jQuery( elem ).is( until ) ) {
                    break;
                }
                matched.push( elem );
            }
        }
        return matched;
    };


    var siblings = function( n, elem ) {
        var matched = [];

        for ( ; n; n = n.nextSibling ) {
            if ( n.nodeType === 1 && n !== elem ) {
                matched.push( n );
            }
        }

        return matched;
    };


    var rneedsContext = jQuery.expr.match.needsContext;

    var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



    var risSimple = /^.[^:#\[\.,]*$/;

// Implement the identical functionality for filter and not
    function winnow( elements, qualifier, not ) {
        if ( jQuery.isFunction( qualifier ) ) {
            return jQuery.grep( elements, function( elem, i ) {
                /* jshint -W018 */
                return !!qualifier.call( elem, i, elem ) !== not;
            } );

        }

        if ( qualifier.nodeType ) {
            return jQuery.grep( elements, function( elem ) {
                return ( elem === qualifier ) !== not;
            } );

        }

        if ( typeof qualifier === "string" ) {
            if ( risSimple.test( qualifier ) ) {
                return jQuery.filter( qualifier, elements, not );
            }

            qualifier = jQuery.filter( qualifier, elements );
        }

        return jQuery.grep( elements, function( elem ) {
            return ( indexOf.call( qualifier, elem ) > -1 ) !== not && elem.nodeType === 1;
        } );
    }

    jQuery.filter = function( expr, elems, not ) {
        var elem = elems[ 0 ];

        if ( not ) {
            expr = ":not(" + expr + ")";
        }

        return elems.length === 1 && elem.nodeType === 1 ?
            jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :
            jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
                return elem.nodeType === 1;
            } ) );
    };

    jQuery.fn.extend( {
        find: function( selector ) {
            var i, ret,
                len = this.length,
                self = this;

            if ( typeof selector !== "string" ) {
                return this.pushStack( jQuery( selector ).filter( function() {
                    for ( i = 0; i < len; i++ ) {
                        if ( jQuery.contains( self[ i ], this ) ) {
                            return true;
                        }
                    }
                } ) );
            }

            ret = this.pushStack( [] );

            for ( i = 0; i < len; i++ ) {
                jQuery.find( selector, self[ i ], ret );
            }

            return len > 1 ? jQuery.uniqueSort( ret ) : ret;
        },
        filter: function( selector ) {
            return this.pushStack( winnow( this, selector || [], false ) );
        },
        not: function( selector ) {
            return this.pushStack( winnow( this, selector || [], true ) );
        },
        is: function( selector ) {
            return !!winnow(
                this,

                // If this is a positional/relative selector, check membership in the returned set
                // so $("p:first").is("p:last") won't return true for a doc with two "p".
                typeof selector === "string" && rneedsContext.test( selector ) ?
                    jQuery( selector ) :
                selector || [],
                false
            ).length;
        }
    } );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
    var rootjQuery,

    // A simple way to check for HTML strings
    // Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
    // Strict HTML recognition (#11290: must start with <)
    // Shortcut simple #id case for speed
        rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

        init = jQuery.fn.init = function( selector, context, root ) {
            var match, elem;

            // HANDLE: $(""), $(null), $(undefined), $(false)
            if ( !selector ) {
                return this;
            }

            // Method init() accepts an alternate rootjQuery
            // so migrate can support jQuery.sub (gh-2101)
            root = root || rootjQuery;

            // Handle HTML strings
            if ( typeof selector === "string" ) {
                if ( selector[ 0 ] === "<" &&
                    selector[ selector.length - 1 ] === ">" &&
                    selector.length >= 3 ) {

                    // Assume that strings that start and end with <> are HTML and skip the regex check
                    match = [ null, selector, null ];

                } else {
                    match = rquickExpr.exec( selector );
                }

                // Match html or make sure no context is specified for #id
                if ( match && ( match[ 1 ] || !context ) ) {

                    // HANDLE: $(html) -> $(array)
                    if ( match[ 1 ] ) {
                        context = context instanceof jQuery ? context[ 0 ] : context;

                        // Option to run scripts is true for back-compat
                        // Intentionally let the error be thrown if parseHTML is not present
                        jQuery.merge( this, jQuery.parseHTML(
                            match[ 1 ],
                            context && context.nodeType ? context.ownerDocument || context : document,
                            true
                        ) );

                        // HANDLE: $(html, props)
                        if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
                            for ( match in context ) {

                                // Properties of context are called as methods if possible
                                if ( jQuery.isFunction( this[ match ] ) ) {
                                    this[ match ]( context[ match ] );

                                    // ...and otherwise set as attributes
                                } else {
                                    this.attr( match, context[ match ] );
                                }
                            }
                        }

                        return this;

                        // HANDLE: $(#id)
                    } else {
                        elem = document.getElementById( match[ 2 ] );

                        if ( elem ) {

                            // Inject the element directly into the jQuery object
                            this[ 0 ] = elem;
                            this.length = 1;
                        }
                        return this;
                    }

                    // HANDLE: $(expr, $(...))
                } else if ( !context || context.jquery ) {
                    return ( context || root ).find( selector );

                    // HANDLE: $(expr, context)
                    // (which is just equivalent to: $(context).find(expr)
                } else {
                    return this.constructor( context ).find( selector );
                }

                // HANDLE: $(DOMElement)
            } else if ( selector.nodeType ) {
                this[ 0 ] = selector;
                this.length = 1;
                return this;

                // HANDLE: $(function)
                // Shortcut for document ready
            } else if ( jQuery.isFunction( selector ) ) {
                return root.ready !== undefined ?
                    root.ready( selector ) :

                    // Execute immediately if ready is not present
                    selector( jQuery );
            }

            return jQuery.makeArray( selector, this );
        };

// Give the init function the jQuery prototype for later instantiation
    init.prototype = jQuery.fn;

// Initialize central reference
    rootjQuery = jQuery( document );


    var rparentsprev = /^(?:parents|prev(?:Until|All))/,

    // Methods guaranteed to produce a unique set when starting from a unique set
        guaranteedUnique = {
            children: true,
            contents: true,
            next: true,
            prev: true
        };

    jQuery.fn.extend( {
        has: function( target ) {
            var targets = jQuery( target, this ),
                l = targets.length;

            return this.filter( function() {
                var i = 0;
                for ( ; i < l; i++ ) {
                    if ( jQuery.contains( this, targets[ i ] ) ) {
                        return true;
                    }
                }
            } );
        },

        closest: function( selectors, context ) {
            var cur,
                i = 0,
                l = this.length,
                matched = [],
                targets = typeof selectors !== "string" && jQuery( selectors );

            // Positional selectors never match, since there's no _selection_ context
            if ( !rneedsContext.test( selectors ) ) {
                for ( ; i < l; i++ ) {
                    for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

                        // Always skip document fragments
                        if ( cur.nodeType < 11 && ( targets ?
                            targets.index( cur ) > -1 :

                                // Don't pass non-elements to Sizzle
                            cur.nodeType === 1 &&
                            jQuery.find.matchesSelector( cur, selectors ) ) ) {

                            matched.push( cur );
                            break;
                        }
                    }
                }
            }

            return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
        },

        // Determine the position of an element within the set
        index: function( elem ) {

            // No argument, return index in parent
            if ( !elem ) {
                return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
            }

            // Index in selector
            if ( typeof elem === "string" ) {
                return indexOf.call( jQuery( elem ), this[ 0 ] );
            }

            // Locate the position of the desired element
            return indexOf.call( this,

                // If it receives a jQuery object, the first element is used
                elem.jquery ? elem[ 0 ] : elem
            );
        },

        add: function( selector, context ) {
            return this.pushStack(
                jQuery.uniqueSort(
                    jQuery.merge( this.get(), jQuery( selector, context ) )
                )
            );
        },

        addBack: function( selector ) {
            return this.add( selector == null ?
                this.prevObject : this.prevObject.filter( selector )
            );
        }
    } );

    function sibling( cur, dir ) {
        while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
        return cur;
    }

    jQuery.each( {
        parent: function( elem ) {
            var parent = elem.parentNode;
            return parent && parent.nodeType !== 11 ? parent : null;
        },
        parents: function( elem ) {
            return dir( elem, "parentNode" );
        },
        parentsUntil: function( elem, i, until ) {
            return dir( elem, "parentNode", until );
        },
        next: function( elem ) {
            return sibling( elem, "nextSibling" );
        },
        prev: function( elem ) {
            return sibling( elem, "previousSibling" );
        },
        nextAll: function( elem ) {
            return dir( elem, "nextSibling" );
        },
        prevAll: function( elem ) {
            return dir( elem, "previousSibling" );
        },
        nextUntil: function( elem, i, until ) {
            return dir( elem, "nextSibling", until );
        },
        prevUntil: function( elem, i, until ) {
            return dir( elem, "previousSibling", until );
        },
        siblings: function( elem ) {
            return siblings( ( elem.parentNode || {} ).firstChild, elem );
        },
        children: function( elem ) {
            return siblings( elem.firstChild );
        },
        contents: function( elem ) {
            return elem.contentDocument || jQuery.merge( [], elem.childNodes );
        }
    }, function( name, fn ) {
        jQuery.fn[ name ] = function( until, selector ) {
            var matched = jQuery.map( this, fn, until );

            if ( name.slice( -5 ) !== "Until" ) {
                selector = until;
            }

            if ( selector && typeof selector === "string" ) {
                matched = jQuery.filter( selector, matched );
            }

            if ( this.length > 1 ) {

                // Remove duplicates
                if ( !guaranteedUnique[ name ] ) {
                    jQuery.uniqueSort( matched );
                }

                // Reverse order for parents* and prev-derivatives
                if ( rparentsprev.test( name ) ) {
                    matched.reverse();
                }
            }

            return this.pushStack( matched );
        };
    } );
    var rnotwhite = ( /\S+/g );



// Convert String-formatted options into Object-formatted ones
    function createOptions( options ) {
        var object = {};
        jQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {
            object[ flag ] = true;
        } );
        return object;
    }

    /*
     * Create a callback list using the following parameters:
     *
     *	options: an optional list of space-separated options that will change how
     *			the callback list behaves or a more traditional option object
     *
     * By default a callback list will act like an event callback list and can be
     * "fired" multiple times.
     *
     * Possible options:
     *
     *	once:			will ensure the callback list can only be fired once (like a Deferred)
     *
     *	memory:			will keep track of previous values and will call any callback added
     *					after the list has been fired right away with the latest "memorized"
     *					values (like a Deferred)
     *
     *	unique:			will ensure a callback can only be added once (no duplicate in the list)
     *
     *	stopOnFalse:	interrupt callings when a callback returns false
     *
     */
    jQuery.Callbacks = function( options ) {

        // Convert options from String-formatted to Object-formatted if needed
        // (we check in cache first)
        options = typeof options === "string" ?
            createOptions( options ) :
            jQuery.extend( {}, options );

        var // Flag to know if list is currently firing
            firing,

        // Last fire value for non-forgettable lists
            memory,

        // Flag to know if list was already fired
            fired,

        // Flag to prevent firing
            locked,

        // Actual callback list
            list = [],

        // Queue of execution data for repeatable lists
            queue = [],

        // Index of currently firing callback (modified by add/remove as needed)
            firingIndex = -1,

        // Fire callbacks
            fire = function() {

                // Enforce single-firing
                locked = options.once;

                // Execute callbacks for all pending executions,
                // respecting firingIndex overrides and runtime changes
                fired = firing = true;
                for ( ; queue.length; firingIndex = -1 ) {
                    memory = queue.shift();
                    while ( ++firingIndex < list.length ) {

                        // Run callback and check for early termination
                        if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
                            options.stopOnFalse ) {

                            // Jump to end and forget the data so .add doesn't re-fire
                            firingIndex = list.length;
                            memory = false;
                        }
                    }
                }

                // Forget the data if we're done with it
                if ( !options.memory ) {
                    memory = false;
                }

                firing = false;

                // Clean up if we're done firing for good
                if ( locked ) {

                    // Keep an empty list if we have data for future add calls
                    if ( memory ) {
                        list = [];

                        // Otherwise, this object is spent
                    } else {
                        list = "";
                    }
                }
            },

        // Actual Callbacks object
            self = {

                // Add a callback or a collection of callbacks to the list
                add: function() {
                    if ( list ) {

                        // If we have memory from a past run, we should fire after adding
                        if ( memory && !firing ) {
                            firingIndex = list.length - 1;
                            queue.push( memory );
                        }

                        ( function add( args ) {
                            jQuery.each( args, function( _, arg ) {
                                if ( jQuery.isFunction( arg ) ) {
                                    if ( !options.unique || !self.has( arg ) ) {
                                        list.push( arg );
                                    }
                                } else if ( arg && arg.length && jQuery.type( arg ) !== "string" ) {

                                    // Inspect recursively
                                    add( arg );
                                }
                            } );
                        } )( arguments );

                        if ( memory && !firing ) {
                            fire();
                        }
                    }
                    return this;
                },

                // Remove a callback from the list
                remove: function() {
                    jQuery.each( arguments, function( _, arg ) {
                        var index;
                        while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
                            list.splice( index, 1 );

                            // Handle firing indexes
                            if ( index <= firingIndex ) {
                                firingIndex--;
                            }
                        }
                    } );
                    return this;
                },

                // Check if a given callback is in the list.
                // If no argument is given, return whether or not list has callbacks attached.
                has: function( fn ) {
                    return fn ?
                    jQuery.inArray( fn, list ) > -1 :
                    list.length > 0;
                },

                // Remove all callbacks from the list
                empty: function() {
                    if ( list ) {
                        list = [];
                    }
                    return this;
                },

                // Disable .fire and .add
                // Abort any current/pending executions
                // Clear all callbacks and values
                disable: function() {
                    locked = queue = [];
                    list = memory = "";
                    return this;
                },
                disabled: function() {
                    return !list;
                },

                // Disable .fire
                // Also disable .add unless we have memory (since it would have no effect)
                // Abort any pending executions
                lock: function() {
                    locked = queue = [];
                    if ( !memory && !firing ) {
                        list = memory = "";
                    }
                    return this;
                },
                locked: function() {
                    return !!locked;
                },

                // Call all callbacks with the given context and arguments
                fireWith: function( context, args ) {
                    if ( !locked ) {
                        args = args || [];
                        args = [ context, args.slice ? args.slice() : args ];
                        queue.push( args );
                        if ( !firing ) {
                            fire();
                        }
                    }
                    return this;
                },

                // Call all the callbacks with the given arguments
                fire: function() {
                    self.fireWith( this, arguments );
                    return this;
                },

                // To know if the callbacks have already been called at least once
                fired: function() {
                    return !!fired;
                }
            };

        return self;
    };


    function Identity( v ) {
        return v;
    }
    function Thrower( ex ) {
        throw ex;
    }

    function adoptValue( value, resolve, reject ) {
        var method;

        try {

            // Check for promise aspect first to privilege synchronous behavior
            if ( value && jQuery.isFunction( ( method = value.promise ) ) ) {
                method.call( value ).done( resolve ).fail( reject );

                // Other thenables
            } else if ( value && jQuery.isFunction( ( method = value.then ) ) ) {
                method.call( value, resolve, reject );

                // Other non-thenables
            } else {

                // Support: Android 4.0 only
                // Strict mode functions invoked without .call/.apply get global-object context
                resolve.call( undefined, value );
            }

            // For Promises/A+, convert exceptions into rejections
            // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
            // Deferred#then to conditionally suppress rejection.
        } catch ( /*jshint -W002 */ value ) {

            // Support: Android 4.0 only
            // Strict mode functions invoked without .call/.apply get global-object context
            reject.call( undefined, value );
        }
    }

    jQuery.extend( {

        Deferred: function( func ) {
            var tuples = [

                    // action, add listener, callbacks,
                    // ... .then handlers, argument index, [final state]
                    [ "notify", "progress", jQuery.Callbacks( "memory" ),
                        jQuery.Callbacks( "memory" ), 2 ],
                    [ "resolve", "done", jQuery.Callbacks( "once memory" ),
                        jQuery.Callbacks( "once memory" ), 0, "resolved" ],
                    [ "reject", "fail", jQuery.Callbacks( "once memory" ),
                        jQuery.Callbacks( "once memory" ), 1, "rejected" ]
                ],
                state = "pending",
                promise = {
                    state: function() {
                        return state;
                    },
                    always: function() {
                        deferred.done( arguments ).fail( arguments );
                        return this;
                    },
                    "catch": function( fn ) {
                        return promise.then( null, fn );
                    },

                    // Keep pipe for back-compat
                    pipe: function( /* fnDone, fnFail, fnProgress */ ) {
                        var fns = arguments;

                        return jQuery.Deferred( function( newDefer ) {
                            jQuery.each( tuples, function( i, tuple ) {

                                // Map tuples (progress, done, fail) to arguments (done, fail, progress)
                                var fn = jQuery.isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

                                // deferred.progress(function() { bind to newDefer or newDefer.notify })
                                // deferred.done(function() { bind to newDefer or newDefer.resolve })
                                // deferred.fail(function() { bind to newDefer or newDefer.reject })
                                deferred[ tuple[ 1 ] ]( function() {
                                    var returned = fn && fn.apply( this, arguments );
                                    if ( returned && jQuery.isFunction( returned.promise ) ) {
                                        returned.promise()
                                            .progress( newDefer.notify )
                                            .done( newDefer.resolve )
                                            .fail( newDefer.reject );
                                    } else {
                                        newDefer[ tuple[ 0 ] + "With" ](
                                            this,
                                            fn ? [ returned ] : arguments
                                        );
                                    }
                                } );
                            } );
                            fns = null;
                        } ).promise();
                    },
                    then: function( onFulfilled, onRejected, onProgress ) {
                        var maxDepth = 0;
                        function resolve( depth, deferred, handler, special ) {
                            return function() {
                                var that = this,
                                    args = arguments,
                                    mightThrow = function() {
                                        var returned, then;

                                        // Support: Promises/A+ section 2.3.3.3.3
                                        // https://promisesaplus.com/#point-59
                                        // Ignore double-resolution attempts
                                        if ( depth < maxDepth ) {
                                            return;
                                        }

                                        returned = handler.apply( that, args );

                                        // Support: Promises/A+ section 2.3.1
                                        // https://promisesaplus.com/#point-48
                                        if ( returned === deferred.promise() ) {
                                            throw new TypeError( "Thenable self-resolution" );
                                        }

                                        // Support: Promises/A+ sections 2.3.3.1, 3.5
                                        // https://promisesaplus.com/#point-54
                                        // https://promisesaplus.com/#point-75
                                        // Retrieve `then` only once
                                        then = returned &&

                                                // Support: Promises/A+ section 2.3.4
                                                // https://promisesaplus.com/#point-64
                                                // Only check objects and functions for thenability
                                            ( typeof returned === "object" ||
                                            typeof returned === "function" ) &&
                                            returned.then;

                                        // Handle a returned thenable
                                        if ( jQuery.isFunction( then ) ) {

                                            // Special processors (notify) just wait for resolution
                                            if ( special ) {
                                                then.call(
                                                    returned,
                                                    resolve( maxDepth, deferred, Identity, special ),
                                                    resolve( maxDepth, deferred, Thrower, special )
                                                );

                                                // Normal processors (resolve) also hook into progress
                                            } else {

                                                // ...and disregard older resolution values
                                                maxDepth++;

                                                then.call(
                                                    returned,
                                                    resolve( maxDepth, deferred, Identity, special ),
                                                    resolve( maxDepth, deferred, Thrower, special ),
                                                    resolve( maxDepth, deferred, Identity,
                                                        deferred.notifyWith )
                                                );
                                            }

                                            // Handle all other returned values
                                        } else {

                                            // Only substitute handlers pass on context
                                            // and multiple values (non-spec behavior)
                                            if ( handler !== Identity ) {
                                                that = undefined;
                                                args = [ returned ];
                                            }

                                            // Process the value(s)
                                            // Default process is resolve
                                            ( special || deferred.resolveWith )( that, args );
                                        }
                                    },

                                // Only normal processors (resolve) catch and reject exceptions
                                    process = special ?
                                        mightThrow :
                                        function() {
                                            try {
                                                mightThrow();
                                            } catch ( e ) {

                                                if ( jQuery.Deferred.exceptionHook ) {
                                                    jQuery.Deferred.exceptionHook( e,
                                                        process.stackTrace );
                                                }

                                                // Support: Promises/A+ section 2.3.3.3.4.1
                                                // https://promisesaplus.com/#point-61
                                                // Ignore post-resolution exceptions
                                                if ( depth + 1 >= maxDepth ) {

                                                    // Only substitute handlers pass on context
                                                    // and multiple values (non-spec behavior)
                                                    if ( handler !== Thrower ) {
                                                        that = undefined;
                                                        args = [ e ];
                                                    }

                                                    deferred.rejectWith( that, args );
                                                }
                                            }
                                        };

                                // Support: Promises/A+ section 2.3.3.3.1
                                // https://promisesaplus.com/#point-57
                                // Re-resolve promises immediately to dodge false rejection from
                                // subsequent errors
                                if ( depth ) {
                                    process();
                                } else {

                                    // Call an optional hook to record the stack, in case of exception
                                    // since it's otherwise lost when execution goes async
                                    if ( jQuery.Deferred.getStackHook ) {
                                        process.stackTrace = jQuery.Deferred.getStackHook();
                                    }
                                    window.setTimeout( process );
                                }
                            };
                        }

                        return jQuery.Deferred( function( newDefer ) {

                            // progress_handlers.add( ... )
                            tuples[ 0 ][ 3 ].add(
                                resolve(
                                    0,
                                    newDefer,
                                    jQuery.isFunction( onProgress ) ?
                                        onProgress :
                                        Identity,
                                    newDefer.notifyWith
                                )
                            );

                            // fulfilled_handlers.add( ... )
                            tuples[ 1 ][ 3 ].add(
                                resolve(
                                    0,
                                    newDefer,
                                    jQuery.isFunction( onFulfilled ) ?
                                        onFulfilled :
                                        Identity
                                )
                            );

                            // rejected_handlers.add( ... )
                            tuples[ 2 ][ 3 ].add(
                                resolve(
                                    0,
                                    newDefer,
                                    jQuery.isFunction( onRejected ) ?
                                        onRejected :
                                        Thrower
                                )
                            );
                        } ).promise();
                    },

                    // Get a promise for this deferred
                    // If obj is provided, the promise aspect is added to the object
                    promise: function( obj ) {
                        return obj != null ? jQuery.extend( obj, promise ) : promise;
                    }
                },
                deferred = {};

            // Add list-specific methods
            jQuery.each( tuples, function( i, tuple ) {
                var list = tuple[ 2 ],
                    stateString = tuple[ 5 ];

                // promise.progress = list.add
                // promise.done = list.add
                // promise.fail = list.add
                promise[ tuple[ 1 ] ] = list.add;

                // Handle state
                if ( stateString ) {
                    list.add(
                        function() {

                            // state = "resolved" (i.e., fulfilled)
                            // state = "rejected"
                            state = stateString;
                        },

                        // rejected_callbacks.disable
                        // fulfilled_callbacks.disable
                        tuples[ 3 - i ][ 2 ].disable,

                        // progress_callbacks.lock
                        tuples[ 0 ][ 2 ].lock
                    );
                }

                // progress_handlers.fire
                // fulfilled_handlers.fire
                // rejected_handlers.fire
                list.add( tuple[ 3 ].fire );

                // deferred.notify = function() { deferred.notifyWith(...) }
                // deferred.resolve = function() { deferred.resolveWith(...) }
                // deferred.reject = function() { deferred.rejectWith(...) }
                deferred[ tuple[ 0 ] ] = function() {
                    deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
                    return this;
                };

                // deferred.notifyWith = list.fireWith
                // deferred.resolveWith = list.fireWith
                // deferred.rejectWith = list.fireWith
                deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
            } );

            // Make the deferred a promise
            promise.promise( deferred );

            // Call given func if any
            if ( func ) {
                func.call( deferred, deferred );
            }

            // All done!
            return deferred;
        },

        // Deferred helper
        when: function( singleValue ) {
            var

            // count of uncompleted subordinates
                remaining = arguments.length,

            // count of unprocessed arguments
                i = remaining,

            // subordinate fulfillment data
                resolveContexts = Array( i ),
                resolveValues = slice.call( arguments ),

            // the master Deferred
                master = jQuery.Deferred(),

            // subordinate callback factory
                updateFunc = function( i ) {
                    return function( value ) {
                        resolveContexts[ i ] = this;
                        resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
                        if ( !( --remaining ) ) {
                            master.resolveWith( resolveContexts, resolveValues );
                        }
                    };
                };

            // Single- and empty arguments are adopted like Promise.resolve
            if ( remaining <= 1 ) {
                adoptValue( singleValue, master.done( updateFunc( i ) ).resolve, master.reject );

                // Use .then() to unwrap secondary thenables (cf. gh-3000)
                if ( master.state() === "pending" ||
                    jQuery.isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

                    return master.then();
                }
            }

            // Multiple arguments are aggregated like Promise.all array elements
            while ( i-- ) {
                adoptValue( resolveValues[ i ], updateFunc( i ), master.reject );
            }

            return master.promise();
        }
    } );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
    var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

    jQuery.Deferred.exceptionHook = function( error, stack ) {

        // Support: IE 8 - 9 only
        // Console exists when dev tools are open, which can happen at any time
        if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
            window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );
        }
    };




// The deferred used on DOM ready
    var readyList = jQuery.Deferred();

    jQuery.fn.ready = function( fn ) {

        readyList.then( fn );

        return this;
    };

    jQuery.extend( {

        // Is the DOM ready to be used? Set to true once it occurs.
        isReady: false,

        // A counter to track how many items to wait for before
        // the ready event fires. See #6781
        readyWait: 1,

        // Hold (or release) the ready event
        holdReady: function( hold ) {
            if ( hold ) {
                jQuery.readyWait++;
            } else {
                jQuery.ready( true );
            }
        },

        // Handle when the DOM is ready
        ready: function( wait ) {

            // Abort if there are pending holds or we're already ready
            if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
                return;
            }

            // Remember that the DOM is ready
            jQuery.isReady = true;

            // If a normal DOM Ready event fired, decrement, and wait if need be
            if ( wait !== true && --jQuery.readyWait > 0 ) {
                return;
            }

            // If there are functions bound, to execute
            readyList.resolveWith( document, [ jQuery ] );
        }
    } );

    jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
    function completed() {
        document.removeEventListener( "DOMContentLoaded", completed );
        window.removeEventListener( "load", completed );
        jQuery.ready();
    }

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
    if ( document.readyState === "complete" ||
        ( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

        // Handle it asynchronously to allow scripts the opportunity to delay ready
        window.setTimeout( jQuery.ready );

    } else {

        // Use the handy event callback
        document.addEventListener( "DOMContentLoaded", completed );

        // A fallback to window.onload, that will always work
        window.addEventListener( "load", completed );
    }




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
    var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
        var i = 0,
            len = elems.length,
            bulk = key == null;

        // Sets many values
        if ( jQuery.type( key ) === "object" ) {
            chainable = true;
            for ( i in key ) {
                access( elems, fn, i, key[ i ], true, emptyGet, raw );
            }

            // Sets one value
        } else if ( value !== undefined ) {
            chainable = true;

            if ( !jQuery.isFunction( value ) ) {
                raw = true;
            }

            if ( bulk ) {

                // Bulk operations run against the entire set
                if ( raw ) {
                    fn.call( elems, value );
                    fn = null;

                    // ...except when executing function values
                } else {
                    bulk = fn;
                    fn = function( elem, key, value ) {
                        return bulk.call( jQuery( elem ), value );
                    };
                }
            }

            if ( fn ) {
                for ( ; i < len; i++ ) {
                    fn(
                        elems[ i ], key, raw ?
                            value :
                            value.call( elems[ i ], i, fn( elems[ i ], key ) )
                    );
                }
            }
        }

        return chainable ?
            elems :

            // Gets
            bulk ?
                fn.call( elems ) :
                len ? fn( elems[ 0 ], key ) : emptyGet;
    };
    var acceptData = function( owner ) {

        // Accepts only:
        //  - Node
        //    - Node.ELEMENT_NODE
        //    - Node.DOCUMENT_NODE
        //  - Object
        //    - Any
        /* jshint -W018 */
        return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
    };




    function Data() {
        this.expando = jQuery.expando + Data.uid++;
    }

    Data.uid = 1;

    Data.prototype = {

        cache: function( owner ) {

            // Check if the owner object already has a cache
            var value = owner[ this.expando ];

            // If not, create one
            if ( !value ) {
                value = {};

                // We can accept data for non-element nodes in modern browsers,
                // but we should not, see #8335.
                // Always return an empty object.
                if ( acceptData( owner ) ) {

                    // If it is a node unlikely to be stringify-ed or looped over
                    // use plain assignment
                    if ( owner.nodeType ) {
                        owner[ this.expando ] = value;

                        // Otherwise secure it in a non-enumerable property
                        // configurable must be true to allow the property to be
                        // deleted when data is removed
                    } else {
                        Object.defineProperty( owner, this.expando, {
                            value: value,
                            configurable: true
                        } );
                    }
                }
            }

            return value;
        },
        set: function( owner, data, value ) {
            var prop,
                cache = this.cache( owner );

            // Handle: [ owner, key, value ] args
            // Always use camelCase key (gh-2257)
            if ( typeof data === "string" ) {
                cache[ jQuery.camelCase( data ) ] = value;

                // Handle: [ owner, { properties } ] args
            } else {

                // Copy the properties one-by-one to the cache object
                for ( prop in data ) {
                    cache[ jQuery.camelCase( prop ) ] = data[ prop ];
                }
            }
            return cache;
        },
        get: function( owner, key ) {
            return key === undefined ?
                this.cache( owner ) :

                // Always use camelCase key (gh-2257)
            owner[ this.expando ] && owner[ this.expando ][ jQuery.camelCase( key ) ];
        },
        access: function( owner, key, value ) {

            // In cases where either:
            //
            //   1. No key was specified
            //   2. A string key was specified, but no value provided
            //
            // Take the "read" path and allow the get method to determine
            // which value to return, respectively either:
            //
            //   1. The entire cache object
            //   2. The data stored at the key
            //
            if ( key === undefined ||
                ( ( key && typeof key === "string" ) && value === undefined ) ) {

                return this.get( owner, key );
            }

            // When the key is not a string, or both a key and value
            // are specified, set or extend (existing objects) with either:
            //
            //   1. An object of properties
            //   2. A key and value
            //
            this.set( owner, key, value );

            // Since the "set" path can have two possible entry points
            // return the expected data based on which path was taken[*]
            return value !== undefined ? value : key;
        },
        remove: function( owner, key ) {
            var i,
                cache = owner[ this.expando ];

            if ( cache === undefined ) {
                return;
            }

            if ( key !== undefined ) {

                // Support array or space separated string of keys
                if ( jQuery.isArray( key ) ) {

                    // If key is an array of keys...
                    // We always set camelCase keys, so remove that.
                    key = key.map( jQuery.camelCase );
                } else {
                    key = jQuery.camelCase( key );

                    // If a key with the spaces exists, use it.
                    // Otherwise, create an array by matching non-whitespace
                    key = key in cache ?
                        [ key ] :
                        ( key.match( rnotwhite ) || [] );
                }

                i = key.length;

                while ( i-- ) {
                    delete cache[ key[ i ] ];
                }
            }

            // Remove the expando if there's no more data
            if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

                // Support: Chrome <=35 - 45
                // Webkit & Blink performance suffers when deleting properties
                // from DOM nodes, so set to undefined instead
                // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
                if ( owner.nodeType ) {
                    owner[ this.expando ] = undefined;
                } else {
                    delete owner[ this.expando ];
                }
            }
        },
        hasData: function( owner ) {
            var cache = owner[ this.expando ];
            return cache !== undefined && !jQuery.isEmptyObject( cache );
        }
    };
    var dataPriv = new Data();

    var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

    var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
        rmultiDash = /[A-Z]/g;

    function dataAttr( elem, key, data ) {
        var name;

        // If nothing was found internally, try to fetch any
        // data from the HTML5 data-* attribute
        if ( data === undefined && elem.nodeType === 1 ) {
            name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
            data = elem.getAttribute( name );

            if ( typeof data === "string" ) {
                try {
                    data = data === "true" ? true :
                        data === "false" ? false :
                            data === "null" ? null :

                                // Only convert to a number if it doesn't change the string
                                +data + "" === data ? +data :
                                    rbrace.test( data ) ? JSON.parse( data ) :
                                        data;
                } catch ( e ) {}

                // Make sure we set the data so it isn't changed later
                dataUser.set( elem, key, data );
            } else {
                data = undefined;
            }
        }
        return data;
    }

    jQuery.extend( {
        hasData: function( elem ) {
            return dataUser.hasData( elem ) || dataPriv.hasData( elem );
        },

        data: function( elem, name, data ) {
            return dataUser.access( elem, name, data );
        },

        removeData: function( elem, name ) {
            dataUser.remove( elem, name );
        },

        // TODO: Now that all calls to _data and _removeData have been replaced
        // with direct calls to dataPriv methods, these can be deprecated.
        _data: function( elem, name, data ) {
            return dataPriv.access( elem, name, data );
        },

        _removeData: function( elem, name ) {
            dataPriv.remove( elem, name );
        }
    } );

    jQuery.fn.extend( {
        data: function( key, value ) {
            var i, name, data,
                elem = this[ 0 ],
                attrs = elem && elem.attributes;

            // Gets all values
            if ( key === undefined ) {
                if ( this.length ) {
                    data = dataUser.get( elem );

                    if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
                        i = attrs.length;
                        while ( i-- ) {

                            // Support: IE 11 only
                            // The attrs elements can be null (#14894)
                            if ( attrs[ i ] ) {
                                name = attrs[ i ].name;
                                if ( name.indexOf( "data-" ) === 0 ) {
                                    name = jQuery.camelCase( name.slice( 5 ) );
                                    dataAttr( elem, name, data[ name ] );
                                }
                            }
                        }
                        dataPriv.set( elem, "hasDataAttrs", true );
                    }
                }

                return data;
            }

            // Sets multiple values
            if ( typeof key === "object" ) {
                return this.each( function() {
                    dataUser.set( this, key );
                } );
            }

            return access( this, function( value ) {
                var data;

                // The calling jQuery object (element matches) is not empty
                // (and therefore has an element appears at this[ 0 ]) and the
                // `value` parameter was not undefined. An empty jQuery object
                // will result in `undefined` for elem = this[ 0 ] which will
                // throw an exception if an attempt to read a data cache is made.
                if ( elem && value === undefined ) {

                    // Attempt to get data from the cache
                    // The key will always be camelCased in Data
                    data = dataUser.get( elem, key );
                    if ( data !== undefined ) {
                        return data;
                    }

                    // Attempt to "discover" the data in
                    // HTML5 custom data-* attrs
                    data = dataAttr( elem, key );
                    if ( data !== undefined ) {
                        return data;
                    }

                    // We tried really hard, but the data doesn't exist.
                    return;
                }

                // Set the data...
                this.each( function() {

                    // We always store the camelCased key
                    dataUser.set( this, key, value );
                } );
            }, null, value, arguments.length > 1, null, true );
        },

        removeData: function( key ) {
            return this.each( function() {
                dataUser.remove( this, key );
            } );
        }
    } );


    jQuery.extend( {
        queue: function( elem, type, data ) {
            var queue;

            if ( elem ) {
                type = ( type || "fx" ) + "queue";
                queue = dataPriv.get( elem, type );

                // Speed up dequeue by getting out quickly if this is just a lookup
                if ( data ) {
                    if ( !queue || jQuery.isArray( data ) ) {
                        queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
                    } else {
                        queue.push( data );
                    }
                }
                return queue || [];
            }
        },

        dequeue: function( elem, type ) {
            type = type || "fx";

            var queue = jQuery.queue( elem, type ),
                startLength = queue.length,
                fn = queue.shift(),
                hooks = jQuery._queueHooks( elem, type ),
                next = function() {
                    jQuery.dequeue( elem, type );
                };

            // If the fx queue is dequeued, always remove the progress sentinel
            if ( fn === "inprogress" ) {
                fn = queue.shift();
                startLength--;
            }

            if ( fn ) {

                // Add a progress sentinel to prevent the fx queue from being
                // automatically dequeued
                if ( type === "fx" ) {
                    queue.unshift( "inprogress" );
                }

                // Clear up the last queue stop function
                delete hooks.stop;
                fn.call( elem, next, hooks );
            }

            if ( !startLength && hooks ) {
                hooks.empty.fire();
            }
        },

        // Not public - generate a queueHooks object, or return the current one
        _queueHooks: function( elem, type ) {
            var key = type + "queueHooks";
            return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
                    empty: jQuery.Callbacks( "once memory" ).add( function() {
                        dataPriv.remove( elem, [ type + "queue", key ] );
                    } )
                } );
        }
    } );

    jQuery.fn.extend( {
        queue: function( type, data ) {
            var setter = 2;

            if ( typeof type !== "string" ) {
                data = type;
                type = "fx";
                setter--;
            }

            if ( arguments.length < setter ) {
                return jQuery.queue( this[ 0 ], type );
            }

            return data === undefined ?
                this :
                this.each( function() {
                    var queue = jQuery.queue( this, type, data );

                    // Ensure a hooks for this queue
                    jQuery._queueHooks( this, type );

                    if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
                        jQuery.dequeue( this, type );
                    }
                } );
        },
        dequeue: function( type ) {
            return this.each( function() {
                jQuery.dequeue( this, type );
            } );
        },
        clearQueue: function( type ) {
            return this.queue( type || "fx", [] );
        },

        // Get a promise resolved when queues of a certain type
        // are emptied (fx is the type by default)
        promise: function( type, obj ) {
            var tmp,
                count = 1,
                defer = jQuery.Deferred(),
                elements = this,
                i = this.length,
                resolve = function() {
                    if ( !( --count ) ) {
                        defer.resolveWith( elements, [ elements ] );
                    }
                };

            if ( typeof type !== "string" ) {
                obj = type;
                type = undefined;
            }
            type = type || "fx";

            while ( i-- ) {
                tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
                if ( tmp && tmp.empty ) {
                    count++;
                    tmp.empty.add( resolve );
                }
            }
            resolve();
            return defer.promise( obj );
        }
    } );
    var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

    var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


    var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

    var isHiddenWithinTree = function( elem, el ) {

        // isHiddenWithinTree might be called from jQuery#filter function;
        // in that case, element will be second argument
        elem = el || elem;

        // Inline style trumps all
        return elem.style.display === "none" ||
            elem.style.display === "" &&

                // Otherwise, check computed style
                // Support: Firefox <=43 - 45
                // Disconnected elements can have computed display: none, so first confirm that elem is
                // in the document.
            jQuery.contains( elem.ownerDocument, elem ) &&

            jQuery.css( elem, "display" ) === "none";
    };

    var swap = function( elem, options, callback, args ) {
        var ret, name,
            old = {};

        // Remember the old values, and insert the new ones
        for ( name in options ) {
            old[ name ] = elem.style[ name ];
            elem.style[ name ] = options[ name ];
        }

        ret = callback.apply( elem, args || [] );

        // Revert the old values
        for ( name in options ) {
            elem.style[ name ] = old[ name ];
        }

        return ret;
    };




    function adjustCSS( elem, prop, valueParts, tween ) {
        var adjusted,
            scale = 1,
            maxIterations = 20,
            currentValue = tween ?
                function() { return tween.cur(); } :
                function() { return jQuery.css( elem, prop, "" ); },
            initial = currentValue(),
            unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

        // Starting value computation is required for potential unit mismatches
            initialInUnit = ( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
                rcssNum.exec( jQuery.css( elem, prop ) );

        if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

            // Trust units reported by jQuery.css
            unit = unit || initialInUnit[ 3 ];

            // Make sure we update the tween properties later on
            valueParts = valueParts || [];

            // Iteratively approximate from a nonzero starting point
            initialInUnit = +initial || 1;

            do {

                // If previous iteration zeroed out, double until we get *something*.
                // Use string for doubling so we don't accidentally see scale as unchanged below
                scale = scale || ".5";

                // Adjust and apply
                initialInUnit = initialInUnit / scale;
                jQuery.style( elem, prop, initialInUnit + unit );

                // Update scale, tolerating zero or NaN from tween.cur()
                // Break the loop if scale is unchanged or perfect, or if we've just had enough.
            } while (
            scale !== ( scale = currentValue() / initial ) && scale !== 1 && --maxIterations
                );
        }

        if ( valueParts ) {
            initialInUnit = +initialInUnit || +initial || 0;

            // Apply relative offset (+=/-=) if specified
            adjusted = valueParts[ 1 ] ?
            initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
                +valueParts[ 2 ];
            if ( tween ) {
                tween.unit = unit;
                tween.start = initialInUnit;
                tween.end = adjusted;
            }
        }
        return adjusted;
    }


    var defaultDisplayMap = {};

    function getDefaultDisplay( elem ) {
        var temp,
            doc = elem.ownerDocument,
            nodeName = elem.nodeName,
            display = defaultDisplayMap[ nodeName ];

        if ( display ) {
            return display;
        }

        temp = doc.body.appendChild( doc.createElement( nodeName ) ),
            display = jQuery.css( temp, "display" );

        temp.parentNode.removeChild( temp );

        if ( display === "none" ) {
            display = "block";
        }
        defaultDisplayMap[ nodeName ] = display;

        return display;
    }

    function showHide( elements, show ) {
        var display, elem,
            values = [],
            index = 0,
            length = elements.length;

        // Determine new display value for elements that need to change
        for ( ; index < length; index++ ) {
            elem = elements[ index ];
            if ( !elem.style ) {
                continue;
            }

            display = elem.style.display;
            if ( show ) {

                // Since we force visibility upon cascade-hidden elements, an immediate (and slow)
                // check is required in this first loop unless we have a nonempty display value (either
                // inline or about-to-be-restored)
                if ( display === "none" ) {
                    values[ index ] = dataPriv.get( elem, "display" ) || null;
                    if ( !values[ index ] ) {
                        elem.style.display = "";
                    }
                }
                if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
                    values[ index ] = getDefaultDisplay( elem );
                }
            } else {
                if ( display !== "none" ) {
                    values[ index ] = "none";

                    // Remember what we're overwriting
                    dataPriv.set( elem, "display", display );
                }
            }
        }

        // Set the display of the elements in a second loop to avoid constant reflow
        for ( index = 0; index < length; index++ ) {
            if ( values[ index ] != null ) {
                elements[ index ].style.display = values[ index ];
            }
        }

        return elements;
    }

    jQuery.fn.extend( {
        show: function() {
            return showHide( this, true );
        },
        hide: function() {
            return showHide( this );
        },
        toggle: function( state ) {
            if ( typeof state === "boolean" ) {
                return state ? this.show() : this.hide();
            }

            return this.each( function() {
                if ( isHiddenWithinTree( this ) ) {
                    jQuery( this ).show();
                } else {
                    jQuery( this ).hide();
                }
            } );
        }
    } );
    var rcheckableType = ( /^(?:checkbox|radio)$/i );

    var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]+)/i );

    var rscriptType = ( /^$|\/(?:java|ecma)script/i );



// We have to close these tags to support XHTML (#13200)
    var wrapMap = {

        // Support: IE <=9 only
        option: [ 1, "<select multiple='multiple'>", "</select>" ],

        // XHTML parsers do not magically insert elements in the
        // same way that tag soup parsers do. So we cannot shorten
        // this by omitting <tbody> or other required elements.
        thead: [ 1, "<table>", "</table>" ],
        col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
        tr: [ 2, "<table><tbody>", "</tbody></table>" ],
        td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

        _default: [ 0, "", "" ]
    };

// Support: IE <=9 only
    wrapMap.optgroup = wrapMap.option;

    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
    wrapMap.th = wrapMap.td;


    function getAll( context, tag ) {

        // Support: IE <=9 - 11 only
        // Use typeof to avoid zero-argument method invocation on host objects (#15151)
        var ret = typeof context.getElementsByTagName !== "undefined" ?
            context.getElementsByTagName( tag || "*" ) :
            typeof context.querySelectorAll !== "undefined" ?
                context.querySelectorAll( tag || "*" ) :
                [];

        return tag === undefined || tag && jQuery.nodeName( context, tag ) ?
            jQuery.merge( [ context ], ret ) :
            ret;
    }


// Mark scripts as having already been evaluated
    function setGlobalEval( elems, refElements ) {
        var i = 0,
            l = elems.length;

        for ( ; i < l; i++ ) {
            dataPriv.set(
                elems[ i ],
                "globalEval",
                !refElements || dataPriv.get( refElements[ i ], "globalEval" )
            );
        }
    }


    var rhtml = /<|&#?\w+;/;

    function buildFragment( elems, context, scripts, selection, ignored ) {
        var elem, tmp, tag, wrap, contains, j,
            fragment = context.createDocumentFragment(),
            nodes = [],
            i = 0,
            l = elems.length;

        for ( ; i < l; i++ ) {
            elem = elems[ i ];

            if ( elem || elem === 0 ) {

                // Add nodes directly
                if ( jQuery.type( elem ) === "object" ) {

                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // push.apply(_, arraylike) throws on ancient WebKit
                    jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

                    // Convert non-html into a text node
                } else if ( !rhtml.test( elem ) ) {
                    nodes.push( context.createTextNode( elem ) );

                    // Convert html into DOM nodes
                } else {
                    tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

                    // Deserialize a standard representation
                    tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
                    wrap = wrapMap[ tag ] || wrapMap._default;
                    tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

                    // Descend through wrappers to the right content
                    j = wrap[ 0 ];
                    while ( j-- ) {
                        tmp = tmp.lastChild;
                    }

                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // push.apply(_, arraylike) throws on ancient WebKit
                    jQuery.merge( nodes, tmp.childNodes );

                    // Remember the top-level container
                    tmp = fragment.firstChild;

                    // Ensure the created nodes are orphaned (#12392)
                    tmp.textContent = "";
                }
            }
        }

        // Remove wrapper from fragment
        fragment.textContent = "";

        i = 0;
        while ( ( elem = nodes[ i++ ] ) ) {

            // Skip elements already in the context collection (trac-4087)
            if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
                if ( ignored ) {
                    ignored.push( elem );
                }
                continue;
            }

            contains = jQuery.contains( elem.ownerDocument, elem );

            // Append to fragment
            tmp = getAll( fragment.appendChild( elem ), "script" );

            // Preserve script evaluation history
            if ( contains ) {
                setGlobalEval( tmp );
            }

            // Capture executables
            if ( scripts ) {
                j = 0;
                while ( ( elem = tmp[ j++ ] ) ) {
                    if ( rscriptType.test( elem.type || "" ) ) {
                        scripts.push( elem );
                    }
                }
            }
        }

        return fragment;
    }


    ( function() {
        var fragment = document.createDocumentFragment(),
            div = fragment.appendChild( document.createElement( "div" ) ),
            input = document.createElement( "input" );

        // Support: Android 4.0 - 4.3 only
        // Check state lost if the name is set (#11217)
        // Support: Windows Web Apps (WWA)
        // `name` and `type` must use .setAttribute for WWA (#14901)
        input.setAttribute( "type", "radio" );
        input.setAttribute( "checked", "checked" );
        input.setAttribute( "name", "t" );

        div.appendChild( input );

        // Support: Android <=4.1 only
        // Older WebKit doesn't clone checked state correctly in fragments
        support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

        // Support: IE <=11 only
        // Make sure textarea (and checkbox) defaultValue is properly cloned
        div.innerHTML = "<textarea>x</textarea>";
        support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;
    } )();
    var documentElement = document.documentElement;



    var
        rkeyEvent = /^key/,
        rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
        rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

    function returnTrue() {
        return true;
    }

    function returnFalse() {
        return false;
    }

// Support: IE <=9 only
// See #13393 for more info
    function safeActiveElement() {
        try {
            return document.activeElement;
        } catch ( err ) { }
    }

    function on( elem, types, selector, data, fn, one ) {
        var origFn, type;

        // Types can be a map of types/handlers
        if ( typeof types === "object" ) {

            // ( types-Object, selector, data )
            if ( typeof selector !== "string" ) {

                // ( types-Object, data )
                data = data || selector;
                selector = undefined;
            }
            for ( type in types ) {
                on( elem, type, selector, data, types[ type ], one );
            }
            return elem;
        }

        if ( data == null && fn == null ) {

            // ( types, fn )
            fn = selector;
            data = selector = undefined;
        } else if ( fn == null ) {
            if ( typeof selector === "string" ) {

                // ( types, selector, fn )
                fn = data;
                data = undefined;
            } else {

                // ( types, data, fn )
                fn = data;
                data = selector;
                selector = undefined;
            }
        }
        if ( fn === false ) {
            fn = returnFalse;
        } else if ( !fn ) {
            return elem;
        }

        if ( one === 1 ) {
            origFn = fn;
            fn = function( event ) {

                // Can use an empty set, since event contains the info
                jQuery().off( event );
                return origFn.apply( this, arguments );
            };

            // Use same guid so caller can remove using origFn
            fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
        }
        return elem.each( function() {
            jQuery.event.add( this, types, fn, data, selector );
        } );
    }

    /*
     * Helper functions for managing events -- not part of the public interface.
     * Props to Dean Edwards' addEvent library for many of the ideas.
     */
    jQuery.event = {

        global: {},

        add: function( elem, types, handler, data, selector ) {

            var handleObjIn, eventHandle, tmp,
                events, t, handleObj,
                special, handlers, type, namespaces, origType,
                elemData = dataPriv.get( elem );

            // Don't attach events to noData or text/comment nodes (but allow plain objects)
            if ( !elemData ) {
                return;
            }

            // Caller can pass in an object of custom data in lieu of the handler
            if ( handler.handler ) {
                handleObjIn = handler;
                handler = handleObjIn.handler;
                selector = handleObjIn.selector;
            }

            // Ensure that invalid selectors throw exceptions at attach time
            // Evaluate against documentElement in case elem is a non-element node (e.g., document)
            if ( selector ) {
                jQuery.find.matchesSelector( documentElement, selector );
            }

            // Make sure that the handler has a unique ID, used to find/remove it later
            if ( !handler.guid ) {
                handler.guid = jQuery.guid++;
            }

            // Init the element's event structure and main handler, if this is the first
            if ( !( events = elemData.events ) ) {
                events = elemData.events = {};
            }
            if ( !( eventHandle = elemData.handle ) ) {
                eventHandle = elemData.handle = function( e ) {

                    // Discard the second event of a jQuery.event.trigger() and
                    // when an event is called after a page has unloaded
                    return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
                        jQuery.event.dispatch.apply( elem, arguments ) : undefined;
                };
            }

            // Handle multiple events separated by a space
            types = ( types || "" ).match( rnotwhite ) || [ "" ];
            t = types.length;
            while ( t-- ) {
                tmp = rtypenamespace.exec( types[ t ] ) || [];
                type = origType = tmp[ 1 ];
                namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

                // There *must* be a type, no attaching namespace-only handlers
                if ( !type ) {
                    continue;
                }

                // If event changes its type, use the special event handlers for the changed type
                special = jQuery.event.special[ type ] || {};

                // If selector defined, determine special event api type, otherwise given type
                type = ( selector ? special.delegateType : special.bindType ) || type;

                // Update special based on newly reset type
                special = jQuery.event.special[ type ] || {};

                // handleObj is passed to all event handlers
                handleObj = jQuery.extend( {
                    type: type,
                    origType: origType,
                    data: data,
                    handler: handler,
                    guid: handler.guid,
                    selector: selector,
                    needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
                    namespace: namespaces.join( "." )
                }, handleObjIn );

                // Init the event handler queue if we're the first
                if ( !( handlers = events[ type ] ) ) {
                    handlers = events[ type ] = [];
                    handlers.delegateCount = 0;

                    // Only use addEventListener if the special events handler returns false
                    if ( !special.setup ||
                        special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

                        if ( elem.addEventListener ) {
                            elem.addEventListener( type, eventHandle );
                        }
                    }
                }

                if ( special.add ) {
                    special.add.call( elem, handleObj );

                    if ( !handleObj.handler.guid ) {
                        handleObj.handler.guid = handler.guid;
                    }
                }

                // Add to the element's handler list, delegates in front
                if ( selector ) {
                    handlers.splice( handlers.delegateCount++, 0, handleObj );
                } else {
                    handlers.push( handleObj );
                }

                // Keep track of which events have ever been used, for event optimization
                jQuery.event.global[ type ] = true;
            }

        },

        // Detach an event or set of events from an element
        remove: function( elem, types, handler, selector, mappedTypes ) {

            var j, origCount, tmp,
                events, t, handleObj,
                special, handlers, type, namespaces, origType,
                elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

            if ( !elemData || !( events = elemData.events ) ) {
                return;
            }

            // Once for each type.namespace in types; type may be omitted
            types = ( types || "" ).match( rnotwhite ) || [ "" ];
            t = types.length;
            while ( t-- ) {
                tmp = rtypenamespace.exec( types[ t ] ) || [];
                type = origType = tmp[ 1 ];
                namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

                // Unbind all events (on this namespace, if provided) for the element
                if ( !type ) {
                    for ( type in events ) {
                        jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
                    }
                    continue;
                }

                special = jQuery.event.special[ type ] || {};
                type = ( selector ? special.delegateType : special.bindType ) || type;
                handlers = events[ type ] || [];
                tmp = tmp[ 2 ] &&
                    new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

                // Remove matching events
                origCount = j = handlers.length;
                while ( j-- ) {
                    handleObj = handlers[ j ];

                    if ( ( mappedTypes || origType === handleObj.origType ) &&
                        ( !handler || handler.guid === handleObj.guid ) &&
                        ( !tmp || tmp.test( handleObj.namespace ) ) &&
                        ( !selector || selector === handleObj.selector ||
                        selector === "**" && handleObj.selector ) ) {
                        handlers.splice( j, 1 );

                        if ( handleObj.selector ) {
                            handlers.delegateCount--;
                        }
                        if ( special.remove ) {
                            special.remove.call( elem, handleObj );
                        }
                    }
                }

                // Remove generic event handler if we removed something and no more handlers exist
                // (avoids potential for endless recursion during removal of special event handlers)
                if ( origCount && !handlers.length ) {
                    if ( !special.teardown ||
                        special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

                        jQuery.removeEvent( elem, type, elemData.handle );
                    }

                    delete events[ type ];
                }
            }

            // Remove data and the expando if it's no longer used
            if ( jQuery.isEmptyObject( events ) ) {
                dataPriv.remove( elem, "handle events" );
            }
        },

        dispatch: function( nativeEvent ) {

            // Make a writable jQuery.Event from the native event object
            var event = jQuery.event.fix( nativeEvent );

            var i, j, ret, matched, handleObj, handlerQueue,
                args = new Array( arguments.length ),
                handlers = ( dataPriv.get( this, "events" ) || {} )[ event.type ] || [],
                special = jQuery.event.special[ event.type ] || {};

            // Use the fix-ed jQuery.Event rather than the (read-only) native event
            args[ 0 ] = event;

            for ( i = 1; i < arguments.length; i++ ) {
                args[ i ] = arguments[ i ];
            }

            event.delegateTarget = this;

            // Call the preDispatch hook for the mapped type, and let it bail if desired
            if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
                return;
            }

            // Determine handlers
            handlerQueue = jQuery.event.handlers.call( this, event, handlers );

            // Run delegates first; they may want to stop propagation beneath us
            i = 0;
            while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
                event.currentTarget = matched.elem;

                j = 0;
                while ( ( handleObj = matched.handlers[ j++ ] ) &&
                !event.isImmediatePropagationStopped() ) {

                    // Triggered event must either 1) have no namespace, or 2) have namespace(s)
                    // a subset or equal to those in the bound event (both can have no namespace).
                    if ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {

                        event.handleObj = handleObj;
                        event.data = handleObj.data;

                        ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
                        handleObj.handler ).apply( matched.elem, args );

                        if ( ret !== undefined ) {
                            if ( ( event.result = ret ) === false ) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                        }
                    }
                }
            }

            // Call the postDispatch hook for the mapped type
            if ( special.postDispatch ) {
                special.postDispatch.call( this, event );
            }

            return event.result;
        },

        handlers: function( event, handlers ) {
            var i, matches, sel, handleObj,
                handlerQueue = [],
                delegateCount = handlers.delegateCount,
                cur = event.target;

            // Support: IE <=9
            // Find delegate handlers
            // Black-hole SVG <use> instance trees (#13180)
            //
            // Support: Firefox <=42
            // Avoid non-left-click in FF but don't block IE radio events (#3861, gh-2343)
            if ( delegateCount && cur.nodeType &&
                ( event.type !== "click" || isNaN( event.button ) || event.button < 1 ) ) {

                for ( ; cur !== this; cur = cur.parentNode || this ) {

                    // Don't check non-elements (#13208)
                    // Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
                    if ( cur.nodeType === 1 && ( cur.disabled !== true || event.type !== "click" ) ) {
                        matches = [];
                        for ( i = 0; i < delegateCount; i++ ) {
                            handleObj = handlers[ i ];

                            // Don't conflict with Object.prototype properties (#13203)
                            sel = handleObj.selector + " ";

                            if ( matches[ sel ] === undefined ) {
                                matches[ sel ] = handleObj.needsContext ?
                                jQuery( sel, this ).index( cur ) > -1 :
                                    jQuery.find( sel, this, null, [ cur ] ).length;
                            }
                            if ( matches[ sel ] ) {
                                matches.push( handleObj );
                            }
                        }
                        if ( matches.length ) {
                            handlerQueue.push( { elem: cur, handlers: matches } );
                        }
                    }
                }
            }

            // Add the remaining (directly-bound) handlers
            if ( delegateCount < handlers.length ) {
                handlerQueue.push( { elem: this, handlers: handlers.slice( delegateCount ) } );
            }

            return handlerQueue;
        },

        addProp: function( name, hook ) {
            Object.defineProperty( jQuery.Event.prototype, name, {
                enumerable: true,
                configurable: true,

                get: jQuery.isFunction( hook ) ?
                    function() {
                        if ( this.originalEvent ) {
                            return hook( this.originalEvent );
                        }
                    } :
                    function() {
                        if ( this.originalEvent ) {
                            return this.originalEvent[ name ];
                        }
                    },

                set: function( value ) {
                    Object.defineProperty( this, name, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    } );
                }
            } );
        },

        fix: function( originalEvent ) {
            return originalEvent[ jQuery.expando ] ?
                originalEvent :
                new jQuery.Event( originalEvent );
        },

        special: {
            load: {

                // Prevent triggered image.load events from bubbling to window.load
                noBubble: true
            },
            focus: {

                // Fire native event if possible so blur/focus sequence is correct
                trigger: function() {
                    if ( this !== safeActiveElement() && this.focus ) {
                        this.focus();
                        return false;
                    }
                },
                delegateType: "focusin"
            },
            blur: {
                trigger: function() {
                    if ( this === safeActiveElement() && this.blur ) {
                        this.blur();
                        return false;
                    }
                },
                delegateType: "focusout"
            },
            click: {

                // For checkbox, fire native event so checked state will be right
                trigger: function() {
                    if ( this.type === "checkbox" && this.click && jQuery.nodeName( this, "input" ) ) {
                        this.click();
                        return false;
                    }
                },

                // For cross-browser consistency, don't fire native .click() on links
                _default: function( event ) {
                    return jQuery.nodeName( event.target, "a" );
                }
            },

            beforeunload: {
                postDispatch: function( event ) {

                    // Support: Firefox 20+
                    // Firefox doesn't alert if the returnValue field is not set.
                    if ( event.result !== undefined && event.originalEvent ) {
                        event.originalEvent.returnValue = event.result;
                    }
                }
            }
        }
    };

    jQuery.removeEvent = function( elem, type, handle ) {

        // This "if" is needed for plain objects
        if ( elem.removeEventListener ) {
            elem.removeEventListener( type, handle );
        }
    };

    jQuery.Event = function( src, props ) {

        // Allow instantiation without the 'new' keyword
        if ( !( this instanceof jQuery.Event ) ) {
            return new jQuery.Event( src, props );
        }

        // Event object
        if ( src && src.type ) {
            this.originalEvent = src;
            this.type = src.type;

            // Events bubbling up the document may have been marked as prevented
            // by a handler lower down the tree; reflect the correct value.
            this.isDefaultPrevented = src.defaultPrevented ||
            src.defaultPrevented === undefined &&

                // Support: Android <=2.3 only
            src.returnValue === false ?
                returnTrue :
                returnFalse;

            // Create target properties
            // Support: Safari <=6 - 7 only
            // Target should not be a text node (#504, #13143)
            this.target = ( src.target && src.target.nodeType === 3 ) ?
                src.target.parentNode :
                src.target;

            this.currentTarget = src.currentTarget;
            this.relatedTarget = src.relatedTarget;

            // Event type
        } else {
            this.type = src;
        }

        // Put explicitly provided properties onto the event object
        if ( props ) {
            jQuery.extend( this, props );
        }

        // Create a timestamp if incoming event doesn't have one
        this.timeStamp = src && src.timeStamp || jQuery.now();

        // Mark it as fixed
        this[ jQuery.expando ] = true;
    };

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
    jQuery.Event.prototype = {
        constructor: jQuery.Event,
        isDefaultPrevented: returnFalse,
        isPropagationStopped: returnFalse,
        isImmediatePropagationStopped: returnFalse,
        isSimulated: false,

        preventDefault: function() {
            var e = this.originalEvent;

            this.isDefaultPrevented = returnTrue;

            if ( e && !this.isSimulated ) {
                e.preventDefault();
            }
        },
        stopPropagation: function() {
            var e = this.originalEvent;

            this.isPropagationStopped = returnTrue;

            if ( e && !this.isSimulated ) {
                e.stopPropagation();
            }
        },
        stopImmediatePropagation: function() {
            var e = this.originalEvent;

            this.isImmediatePropagationStopped = returnTrue;

            if ( e && !this.isSimulated ) {
                e.stopImmediatePropagation();
            }

            this.stopPropagation();
        }
    };

// Includes all common event props including KeyEvent and MouseEvent specific props
    jQuery.each( {
        altKey: true,
        bubbles: true,
        cancelable: true,
        changedTouches: true,
        ctrlKey: true,
        detail: true,
        eventPhase: true,
        metaKey: true,
        pageX: true,
        pageY: true,
        shiftKey: true,
        view: true,
        "char": true,
        charCode: true,
        key: true,
        keyCode: true,
        button: true,
        buttons: true,
        clientX: true,
        clientY: true,
        offsetX: true,
        offsetY: true,
        pointerId: true,
        pointerType: true,
        screenX: true,
        screenY: true,
        targetTouches: true,
        toElement: true,
        touches: true,

        which: function( event ) {
            var button = event.button;

            // Add which for key events
            if ( event.which == null && rkeyEvent.test( event.type ) ) {
                return event.charCode != null ? event.charCode : event.keyCode;
            }

            // Add which for click: 1 === left; 2 === middle; 3 === right
            if ( !event.which && button !== undefined && rmouseEvent.test( event.type ) ) {
                return ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );
            }

            return event.which;
        }
    }, jQuery.event.addProp );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
    jQuery.each( {
        mouseenter: "mouseover",
        mouseleave: "mouseout",
        pointerenter: "pointerover",
        pointerleave: "pointerout"
    }, function( orig, fix ) {
        jQuery.event.special[ orig ] = {
            delegateType: fix,
            bindType: fix,

            handle: function( event ) {
                var ret,
                    target = this,
                    related = event.relatedTarget,
                    handleObj = event.handleObj;

                // For mouseenter/leave call the handler if related is outside the target.
                // NB: No relatedTarget if the mouse left/entered the browser window
                if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
                    event.type = handleObj.origType;
                    ret = handleObj.handler.apply( this, arguments );
                    event.type = fix;
                }
                return ret;
            }
        };
    } );

    jQuery.fn.extend( {

        on: function( types, selector, data, fn ) {
            return on( this, types, selector, data, fn );
        },
        one: function( types, selector, data, fn ) {
            return on( this, types, selector, data, fn, 1 );
        },
        off: function( types, selector, fn ) {
            var handleObj, type;
            if ( types && types.preventDefault && types.handleObj ) {

                // ( event )  dispatched jQuery.Event
                handleObj = types.handleObj;
                jQuery( types.delegateTarget ).off(
                    handleObj.namespace ?
                    handleObj.origType + "." + handleObj.namespace :
                        handleObj.origType,
                    handleObj.selector,
                    handleObj.handler
                );
                return this;
            }
            if ( typeof types === "object" ) {

                // ( types-object [, selector] )
                for ( type in types ) {
                    this.off( type, selector, types[ type ] );
                }
                return this;
            }
            if ( selector === false || typeof selector === "function" ) {

                // ( types [, fn] )
                fn = selector;
                selector = undefined;
            }
            if ( fn === false ) {
                fn = returnFalse;
            }
            return this.each( function() {
                jQuery.event.remove( this, types, fn, selector );
            } );
        }
    } );


    var
        rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,

    // Support: IE <=10 - 11, Edge 12 - 13
    // In IE/Edge using regex groups here causes severe slowdowns.
    // See https://connect.microsoft.com/IE/feedback/details/1736512/
        rnoInnerhtml = /<script|<style|<link/i,

    // checked="checked" or checked
        rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
        rscriptTypeMasked = /^true\/(.*)/,
        rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

    function manipulationTarget( elem, content ) {
        if ( jQuery.nodeName( elem, "table" ) &&
            jQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

            return elem.getElementsByTagName( "tbody" )[ 0 ] || elem;
        }

        return elem;
    }

// Replace/restore the type attribute of script elements for safe DOM manipulation
    function disableScript( elem ) {
        elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
        return elem;
    }
    function restoreScript( elem ) {
        var match = rscriptTypeMasked.exec( elem.type );

        if ( match ) {
            elem.type = match[ 1 ];
        } else {
            elem.removeAttribute( "type" );
        }

        return elem;
    }

    function cloneCopyEvent( src, dest ) {
        var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

        if ( dest.nodeType !== 1 ) {
            return;
        }

        // 1. Copy private data: events, handlers, etc.
        if ( dataPriv.hasData( src ) ) {
            pdataOld = dataPriv.access( src );
            pdataCur = dataPriv.set( dest, pdataOld );
            events = pdataOld.events;

            if ( events ) {
                delete pdataCur.handle;
                pdataCur.events = {};

                for ( type in events ) {
                    for ( i = 0, l = events[ type ].length; i < l; i++ ) {
                        jQuery.event.add( dest, type, events[ type ][ i ] );
                    }
                }
            }
        }

        // 2. Copy user data
        if ( dataUser.hasData( src ) ) {
            udataOld = dataUser.access( src );
            udataCur = jQuery.extend( {}, udataOld );

            dataUser.set( dest, udataCur );
        }
    }

// Fix IE bugs, see support tests
    function fixInput( src, dest ) {
        var nodeName = dest.nodeName.toLowerCase();

        // Fails to persist the checked state of a cloned checkbox or radio button.
        if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
            dest.checked = src.checked;

            // Fails to return the selected option to the default selected state when cloning options
        } else if ( nodeName === "input" || nodeName === "textarea" ) {
            dest.defaultValue = src.defaultValue;
        }
    }

    function domManip( collection, args, callback, ignored ) {

        // Flatten any nested arrays
        args = concat.apply( [], args );

        var fragment, first, scripts, hasScripts, node, doc,
            i = 0,
            l = collection.length,
            iNoClone = l - 1,
            value = args[ 0 ],
            isFunction = jQuery.isFunction( value );

        // We can't cloneNode fragments that contain checked, in WebKit
        if ( isFunction ||
            ( l > 1 && typeof value === "string" &&
            !support.checkClone && rchecked.test( value ) ) ) {
            return collection.each( function( index ) {
                var self = collection.eq( index );
                if ( isFunction ) {
                    args[ 0 ] = value.call( this, index, self.html() );
                }
                domManip( self, args, callback, ignored );
            } );
        }

        if ( l ) {
            fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
            first = fragment.firstChild;

            if ( fragment.childNodes.length === 1 ) {
                fragment = first;
            }

            // Require either new content or an interest in ignored elements to invoke the callback
            if ( first || ignored ) {
                scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
                hasScripts = scripts.length;

                // Use the original fragment for the last item
                // instead of the first because it can end up
                // being emptied incorrectly in certain situations (#8070).
                for ( ; i < l; i++ ) {
                    node = fragment;

                    if ( i !== iNoClone ) {
                        node = jQuery.clone( node, true, true );

                        // Keep references to cloned scripts for later restoration
                        if ( hasScripts ) {

                            // Support: Android <=4.0 only, PhantomJS 1 only
                            // push.apply(_, arraylike) throws on ancient WebKit
                            jQuery.merge( scripts, getAll( node, "script" ) );
                        }
                    }

                    callback.call( collection[ i ], node, i );
                }

                if ( hasScripts ) {
                    doc = scripts[ scripts.length - 1 ].ownerDocument;

                    // Reenable scripts
                    jQuery.map( scripts, restoreScript );

                    // Evaluate executable scripts on first document insertion
                    for ( i = 0; i < hasScripts; i++ ) {
                        node = scripts[ i ];
                        if ( rscriptType.test( node.type || "" ) &&
                            !dataPriv.access( node, "globalEval" ) &&
                            jQuery.contains( doc, node ) ) {

                            if ( node.src ) {

                                // Optional AJAX dependency, but won't run scripts if not present
                                if ( jQuery._evalUrl ) {
                                    jQuery._evalUrl( node.src );
                                }
                            } else {
                                DOMEval( node.textContent.replace( rcleanScript, "" ), doc );
                            }
                        }
                    }
                }
            }
        }

        return collection;
    }

    function remove( elem, selector, keepData ) {
        var node,
            nodes = selector ? jQuery.filter( selector, elem ) : elem,
            i = 0;

        for ( ; ( node = nodes[ i ] ) != null; i++ ) {
            if ( !keepData && node.nodeType === 1 ) {
                jQuery.cleanData( getAll( node ) );
            }

            if ( node.parentNode ) {
                if ( keepData && jQuery.contains( node.ownerDocument, node ) ) {
                    setGlobalEval( getAll( node, "script" ) );
                }
                node.parentNode.removeChild( node );
            }
        }

        return elem;
    }

    jQuery.extend( {
        htmlPrefilter: function( html ) {
            return html.replace( rxhtmlTag, "<$1></$2>" );
        },

        clone: function( elem, dataAndEvents, deepDataAndEvents ) {
            var i, l, srcElements, destElements,
                clone = elem.cloneNode( true ),
                inPage = jQuery.contains( elem.ownerDocument, elem );

            // Fix IE cloning issues
            if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
                !jQuery.isXMLDoc( elem ) ) {

                // We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
                destElements = getAll( clone );
                srcElements = getAll( elem );

                for ( i = 0, l = srcElements.length; i < l; i++ ) {
                    fixInput( srcElements[ i ], destElements[ i ] );
                }
            }

            // Copy the events from the original to the clone
            if ( dataAndEvents ) {
                if ( deepDataAndEvents ) {
                    srcElements = srcElements || getAll( elem );
                    destElements = destElements || getAll( clone );

                    for ( i = 0, l = srcElements.length; i < l; i++ ) {
                        cloneCopyEvent( srcElements[ i ], destElements[ i ] );
                    }
                } else {
                    cloneCopyEvent( elem, clone );
                }
            }

            // Preserve script evaluation history
            destElements = getAll( clone, "script" );
            if ( destElements.length > 0 ) {
                setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
            }

            // Return the cloned set
            return clone;
        },

        cleanData: function( elems ) {
            var data, elem, type,
                special = jQuery.event.special,
                i = 0;

            for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
                if ( acceptData( elem ) ) {
                    if ( ( data = elem[ dataPriv.expando ] ) ) {
                        if ( data.events ) {
                            for ( type in data.events ) {
                                if ( special[ type ] ) {
                                    jQuery.event.remove( elem, type );

                                    // This is a shortcut to avoid jQuery.event.remove's overhead
                                } else {
                                    jQuery.removeEvent( elem, type, data.handle );
                                }
                            }
                        }

                        // Support: Chrome <=35 - 45+
                        // Assign undefined instead of using delete, see Data#remove
                        elem[ dataPriv.expando ] = undefined;
                    }
                    if ( elem[ dataUser.expando ] ) {

                        // Support: Chrome <=35 - 45+
                        // Assign undefined instead of using delete, see Data#remove
                        elem[ dataUser.expando ] = undefined;
                    }
                }
            }
        }
    } );

    jQuery.fn.extend( {
        detach: function( selector ) {
            return remove( this, selector, true );
        },

        remove: function( selector ) {
            return remove( this, selector );
        },

        text: function( value ) {
            return access( this, function( value ) {
                return value === undefined ?
                    jQuery.text( this ) :
                    this.empty().each( function() {
                        if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
                            this.textContent = value;
                        }
                    } );
            }, null, value, arguments.length );
        },

        append: function() {
            return domManip( this, arguments, function( elem ) {
                if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
                    var target = manipulationTarget( this, elem );
                    target.appendChild( elem );
                }
            } );
        },

        prepend: function() {
            return domManip( this, arguments, function( elem ) {
                if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
                    var target = manipulationTarget( this, elem );
                    target.insertBefore( elem, target.firstChild );
                }
            } );
        },

        before: function() {
            return domManip( this, arguments, function( elem ) {
                if ( this.parentNode ) {
                    this.parentNode.insertBefore( elem, this );
                }
            } );
        },

        after: function() {
            return domManip( this, arguments, function( elem ) {
                if ( this.parentNode ) {
                    this.parentNode.insertBefore( elem, this.nextSibling );
                }
            } );
        },

        empty: function() {
            var elem,
                i = 0;

            for ( ; ( elem = this[ i ] ) != null; i++ ) {
                if ( elem.nodeType === 1 ) {

                    // Prevent memory leaks
                    jQuery.cleanData( getAll( elem, false ) );

                    // Remove any remaining nodes
                    elem.textContent = "";
                }
            }

            return this;
        },

        clone: function( dataAndEvents, deepDataAndEvents ) {
            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
            deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

            return this.map( function() {
                return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
            } );
        },

        html: function( value ) {
            return access( this, function( value ) {
                var elem = this[ 0 ] || {},
                    i = 0,
                    l = this.length;

                if ( value === undefined && elem.nodeType === 1 ) {
                    return elem.innerHTML;
                }

                // See if we can take a shortcut and just use innerHTML
                if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
                    !wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

                    value = jQuery.htmlPrefilter( value );

                    try {
                        for ( ; i < l; i++ ) {
                            elem = this[ i ] || {};

                            // Remove element nodes and prevent memory leaks
                            if ( elem.nodeType === 1 ) {
                                jQuery.cleanData( getAll( elem, false ) );
                                elem.innerHTML = value;
                            }
                        }

                        elem = 0;

                        // If using innerHTML throws an exception, use the fallback method
                    } catch ( e ) {}
                }

                if ( elem ) {
                    this.empty().append( value );
                }
            }, null, value, arguments.length );
        },

        replaceWith: function() {
            var ignored = [];

            // Make the changes, replacing each non-ignored context element with the new content
            return domManip( this, arguments, function( elem ) {
                var parent = this.parentNode;

                if ( jQuery.inArray( this, ignored ) < 0 ) {
                    jQuery.cleanData( getAll( this ) );
                    if ( parent ) {
                        parent.replaceChild( elem, this );
                    }
                }

                // Force callback invocation
            }, ignored );
        }
    } );

    jQuery.each( {
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
    }, function( name, original ) {
        jQuery.fn[ name ] = function( selector ) {
            var elems,
                ret = [],
                insert = jQuery( selector ),
                last = insert.length - 1,
                i = 0;

            for ( ; i <= last; i++ ) {
                elems = i === last ? this : this.clone( true );
                jQuery( insert[ i ] )[ original ]( elems );

                // Support: Android <=4.0 only, PhantomJS 1 only
                // .get() because push.apply(_, arraylike) throws on ancient WebKit
                push.apply( ret, elems.get() );
            }

            return this.pushStack( ret );
        };
    } );
    var rmargin = ( /^margin/ );

    var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

    var getStyles = function( elem ) {

        // Support: IE <=11 only, Firefox <=30 (#15098, #14150)
        // IE throws on elements created in popups
        // FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
        var view = elem.ownerDocument.defaultView;

        if ( !view || !view.opener ) {
            view = window;
        }

        return view.getComputedStyle( elem );
    };



    ( function() {

        // Executing both pixelPosition & boxSizingReliable tests require only one layout
        // so they're executed at the same time to save the second computation.
        function computeStyleTests() {

            // This is a singleton, we need to execute it only once
            if ( !div ) {
                return;
            }

            div.style.cssText =
                "box-sizing:border-box;" +
                "position:relative;display:block;" +
                "margin:auto;border:1px;padding:1px;" +
                "top:1%;width:50%";
            div.innerHTML = "";
            documentElement.appendChild( container );

            var divStyle = window.getComputedStyle( div );
            pixelPositionVal = divStyle.top !== "1%";

            // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
            reliableMarginLeftVal = divStyle.marginLeft === "2px";
            boxSizingReliableVal = divStyle.width === "4px";

            // Support: Android 4.0 - 4.3 only
            // Some styles come back with percentage values, even though they shouldn't
            div.style.marginRight = "50%";
            pixelMarginRightVal = divStyle.marginRight === "4px";

            documentElement.removeChild( container );

            // Nullify the div so it wouldn't be stored in the memory and
            // it will also be a sign that checks already performed
            div = null;
        }

        var pixelPositionVal, boxSizingReliableVal, pixelMarginRightVal, reliableMarginLeftVal,
            container = document.createElement( "div" ),
            div = document.createElement( "div" );

        // Finish early in limited (non-browser) environments
        if ( !div.style ) {
            return;
        }

        // Support: IE <=9 - 11 only
        // Style of cloned element affects source element cloned (#8908)
        div.style.backgroundClip = "content-box";
        div.cloneNode( true ).style.backgroundClip = "";
        support.clearCloneStyle = div.style.backgroundClip === "content-box";

        container.style.cssText = "border:0;width:8px;height:0;top:0;left:-9999px;" +
            "padding:0;margin-top:1px;position:absolute";
        container.appendChild( div );

        jQuery.extend( support, {
            pixelPosition: function() {
                computeStyleTests();
                return pixelPositionVal;
            },
            boxSizingReliable: function() {
                computeStyleTests();
                return boxSizingReliableVal;
            },
            pixelMarginRight: function() {
                computeStyleTests();
                return pixelMarginRightVal;
            },
            reliableMarginLeft: function() {
                computeStyleTests();
                return reliableMarginLeftVal;
            }
        } );
    } )();


    function curCSS( elem, name, computed ) {
        var width, minWidth, maxWidth, ret,
            style = elem.style;

        computed = computed || getStyles( elem );

        // Support: IE <=9 only
        // getPropertyValue is only needed for .css('filter') (#12537)
        if ( computed ) {
            ret = computed.getPropertyValue( name ) || computed[ name ];

            if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {
                ret = jQuery.style( elem, name );
            }

            // A tribute to the "awesome hack by Dean Edwards"
            // Android Browser returns percentage for some values,
            // but width seems to be reliably pixels.
            // This is against the CSSOM draft spec:
            // https://drafts.csswg.org/cssom/#resolved-values
            if ( !support.pixelMarginRight() && rnumnonpx.test( ret ) && rmargin.test( name ) ) {

                // Remember the original values
                width = style.width;
                minWidth = style.minWidth;
                maxWidth = style.maxWidth;

                // Put in the new values to get a computed value out
                style.minWidth = style.maxWidth = style.width = ret;
                ret = computed.width;

                // Revert the changed values
                style.width = width;
                style.minWidth = minWidth;
                style.maxWidth = maxWidth;
            }
        }

        return ret !== undefined ?

            // Support: IE <=9 - 11 only
            // IE returns zIndex value as an integer.
        ret + "" :
            ret;
    }


    function addGetHookIf( conditionFn, hookFn ) {

        // Define the hook, we'll check on the first run if it's really needed.
        return {
            get: function() {
                if ( conditionFn() ) {

                    // Hook not needed (or it's not possible to use it due
                    // to missing dependency), remove it.
                    delete this.get;
                    return;
                }

                // Hook needed; redefine it so that the support test is not executed again.
                return ( this.get = hookFn ).apply( this, arguments );
            }
        };
    }


    var

    // Swappable if display is none or starts with table
    // except "table", "table-cell", or "table-caption"
    // See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
        rdisplayswap = /^(none|table(?!-c[ea]).+)/,
        cssShow = { position: "absolute", visibility: "hidden", display: "block" },
        cssNormalTransform = {
            letterSpacing: "0",
            fontWeight: "400"
        },

        cssPrefixes = [ "Webkit", "Moz", "ms" ],
        emptyStyle = document.createElement( "div" ).style;

// Return a css property mapped to a potentially vendor prefixed property
    function vendorPropName( name ) {

        // Shortcut for names that are not vendor prefixed
        if ( name in emptyStyle ) {
            return name;
        }

        // Check for vendor prefixed names
        var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
            i = cssPrefixes.length;

        while ( i-- ) {
            name = cssPrefixes[ i ] + capName;
            if ( name in emptyStyle ) {
                return name;
            }
        }
    }

    function setPositiveNumber( elem, value, subtract ) {

        // Any relative (+/-) values have already been
        // normalized at this point
        var matches = rcssNum.exec( value );
        return matches ?

            // Guard against undefined "subtract", e.g., when used as in cssHooks
        Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
            value;
    }

    function augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {
        var i = extra === ( isBorderBox ? "border" : "content" ) ?

                // If we already have the right measurement, avoid augmentation
                4 :

                // Otherwise initialize for horizontal or vertical properties
                name === "width" ? 1 : 0,

            val = 0;

        for ( ; i < 4; i += 2 ) {

            // Both box models exclude margin, so add it if we want it
            if ( extra === "margin" ) {
                val += jQuery.css( elem, extra + cssExpand[ i ], true, styles );
            }

            if ( isBorderBox ) {

                // border-box includes padding, so remove it if we want content
                if ( extra === "content" ) {
                    val -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
                }

                // At this point, extra isn't border nor margin, so remove border
                if ( extra !== "margin" ) {
                    val -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
                }
            } else {

                // At this point, extra isn't content, so add padding
                val += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

                // At this point, extra isn't content nor padding, so add border
                if ( extra !== "padding" ) {
                    val += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
                }
            }
        }

        return val;
    }

    function getWidthOrHeight( elem, name, extra ) {

        // Start with offset property, which is equivalent to the border-box value
        var val,
            valueIsBorderBox = true,
            styles = getStyles( elem ),
            isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

        // Support: IE <=11 only
        // Running getBoundingClientRect on a disconnected node
        // in IE throws an error.
        if ( elem.getClientRects().length ) {
            val = elem.getBoundingClientRect()[ name ];
        }

        // Some non-html elements return undefined for offsetWidth, so check for null/undefined
        // svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
        // MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
        if ( val <= 0 || val == null ) {

            // Fall back to computed then uncomputed css if necessary
            val = curCSS( elem, name, styles );
            if ( val < 0 || val == null ) {
                val = elem.style[ name ];
            }

            // Computed unit is not pixels. Stop here and return.
            if ( rnumnonpx.test( val ) ) {
                return val;
            }

            // Check for style in case a browser which returns unreliable values
            // for getComputedStyle silently falls back to the reliable elem.style
            valueIsBorderBox = isBorderBox &&
                ( support.boxSizingReliable() || val === elem.style[ name ] );

            // Normalize "", auto, and prepare for extra
            val = parseFloat( val ) || 0;
        }

        // Use the active box-sizing model to add/subtract irrelevant styles
        return ( val +
                augmentWidthOrHeight(
                    elem,
                    name,
                    extra || ( isBorderBox ? "border" : "content" ),
                    valueIsBorderBox,
                    styles
                )
            ) + "px";
    }

    jQuery.extend( {

        // Add in style property hooks for overriding the default
        // behavior of getting and setting a style property
        cssHooks: {
            opacity: {
                get: function( elem, computed ) {
                    if ( computed ) {

                        // We should always get a number back from opacity
                        var ret = curCSS( elem, "opacity" );
                        return ret === "" ? "1" : ret;
                    }
                }
            }
        },

        // Don't automatically add "px" to these possibly-unitless properties
        cssNumber: {
            "animationIterationCount": true,
            "columnCount": true,
            "fillOpacity": true,
            "flexGrow": true,
            "flexShrink": true,
            "fontWeight": true,
            "lineHeight": true,
            "opacity": true,
            "order": true,
            "orphans": true,
            "widows": true,
            "zIndex": true,
            "zoom": true
        },

        // Add in properties whose names you wish to fix before
        // setting or getting the value
        cssProps: {
            "float": "cssFloat"
        },

        // Get and set the style property on a DOM Node
        style: function( elem, name, value, extra ) {

            // Don't set styles on text and comment nodes
            if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
                return;
            }

            // Make sure that we're working with the right name
            var ret, type, hooks,
                origName = jQuery.camelCase( name ),
                style = elem.style;

            name = jQuery.cssProps[ origName ] ||
                ( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );

            // Gets hook for the prefixed version, then unprefixed version
            hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

            // Check if we're setting a value
            if ( value !== undefined ) {
                type = typeof value;

                // Convert "+=" or "-=" to relative numbers (#7345)
                if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
                    value = adjustCSS( elem, name, ret );

                    // Fixes bug #9237
                    type = "number";
                }

                // Make sure that null and NaN values aren't set (#7116)
                if ( value == null || value !== value ) {
                    return;
                }

                // If a number was passed in, add the unit (except for certain CSS properties)
                if ( type === "number" ) {
                    value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
                }

                // background-* props affect original clone's values
                if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
                    style[ name ] = "inherit";
                }

                // If a hook was provided, use that value, otherwise just set the specified value
                if ( !hooks || !( "set" in hooks ) ||
                    ( value = hooks.set( elem, value, extra ) ) !== undefined ) {

                    style[ name ] = value;
                }

            } else {

                // If a hook was provided get the non-computed value from there
                if ( hooks && "get" in hooks &&
                    ( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

                    return ret;
                }

                // Otherwise just get the value from the style object
                return style[ name ];
            }
        },

        css: function( elem, name, extra, styles ) {
            var val, num, hooks,
                origName = jQuery.camelCase( name );

            // Make sure that we're working with the right name
            name = jQuery.cssProps[ origName ] ||
                ( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );

            // Try prefixed name followed by the unprefixed name
            hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

            // If a hook was provided get the computed value from there
            if ( hooks && "get" in hooks ) {
                val = hooks.get( elem, true, extra );
            }

            // Otherwise, if a way to get the computed value exists, use that
            if ( val === undefined ) {
                val = curCSS( elem, name, styles );
            }

            // Convert "normal" to computed value
            if ( val === "normal" && name in cssNormalTransform ) {
                val = cssNormalTransform[ name ];
            }

            // Make numeric if forced or a qualifier was provided and val looks numeric
            if ( extra === "" || extra ) {
                num = parseFloat( val );
                return extra === true || isFinite( num ) ? num || 0 : val;
            }
            return val;
        }
    } );

    jQuery.each( [ "height", "width" ], function( i, name ) {
        jQuery.cssHooks[ name ] = {
            get: function( elem, computed, extra ) {
                if ( computed ) {

                    // Certain elements can have dimension info if we invisibly show them
                    // but it must have a current display style that would benefit
                    return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

                        // Support: Safari 8+
                        // Table columns in Safari have non-zero offsetWidth & zero
                        // getBoundingClientRect().width unless display is changed.
                        // Support: IE <=11 only
                        // Running getBoundingClientRect on a disconnected node
                        // in IE throws an error.
                    ( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
                        swap( elem, cssShow, function() {
                            return getWidthOrHeight( elem, name, extra );
                        } ) :
                        getWidthOrHeight( elem, name, extra );
                }
            },

            set: function( elem, value, extra ) {
                var matches,
                    styles = extra && getStyles( elem ),
                    subtract = extra && augmentWidthOrHeight(
                            elem,
                            name,
                            extra,
                            jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
                            styles
                        );

                // Convert to pixels if value adjustment is needed
                if ( subtract && ( matches = rcssNum.exec( value ) ) &&
                    ( matches[ 3 ] || "px" ) !== "px" ) {

                    elem.style[ name ] = value;
                    value = jQuery.css( elem, name );
                }

                return setPositiveNumber( elem, value, subtract );
            }
        };
    } );

    jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
        function( elem, computed ) {
            if ( computed ) {
                return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
                        elem.getBoundingClientRect().left -
                        swap( elem, { marginLeft: 0 }, function() {
                            return elem.getBoundingClientRect().left;
                        } )
                    ) + "px";
            }
        }
    );

// These hooks are used by animate to expand properties
    jQuery.each( {
        margin: "",
        padding: "",
        border: "Width"
    }, function( prefix, suffix ) {
        jQuery.cssHooks[ prefix + suffix ] = {
            expand: function( value ) {
                var i = 0,
                    expanded = {},

                // Assumes a single number if not a string
                    parts = typeof value === "string" ? value.split( " " ) : [ value ];

                for ( ; i < 4; i++ ) {
                    expanded[ prefix + cssExpand[ i ] + suffix ] =
                        parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
                }

                return expanded;
            }
        };

        if ( !rmargin.test( prefix ) ) {
            jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
        }
    } );

    jQuery.fn.extend( {
        css: function( name, value ) {
            return access( this, function( elem, name, value ) {
                var styles, len,
                    map = {},
                    i = 0;

                if ( jQuery.isArray( name ) ) {
                    styles = getStyles( elem );
                    len = name.length;

                    for ( ; i < len; i++ ) {
                        map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
                    }

                    return map;
                }

                return value !== undefined ?
                    jQuery.style( elem, name, value ) :
                    jQuery.css( elem, name );
            }, name, value, arguments.length > 1 );
        }
    } );


    function Tween( elem, options, prop, end, easing ) {
        return new Tween.prototype.init( elem, options, prop, end, easing );
    }
    jQuery.Tween = Tween;

    Tween.prototype = {
        constructor: Tween,
        init: function( elem, options, prop, end, easing, unit ) {
            this.elem = elem;
            this.prop = prop;
            this.easing = easing || jQuery.easing._default;
            this.options = options;
            this.start = this.now = this.cur();
            this.end = end;
            this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
        },
        cur: function() {
            var hooks = Tween.propHooks[ this.prop ];

            return hooks && hooks.get ?
                hooks.get( this ) :
                Tween.propHooks._default.get( this );
        },
        run: function( percent ) {
            var eased,
                hooks = Tween.propHooks[ this.prop ];

            if ( this.options.duration ) {
                this.pos = eased = jQuery.easing[ this.easing ](
                    percent, this.options.duration * percent, 0, 1, this.options.duration
                );
            } else {
                this.pos = eased = percent;
            }
            this.now = ( this.end - this.start ) * eased + this.start;

            if ( this.options.step ) {
                this.options.step.call( this.elem, this.now, this );
            }

            if ( hooks && hooks.set ) {
                hooks.set( this );
            } else {
                Tween.propHooks._default.set( this );
            }
            return this;
        }
    };

    Tween.prototype.init.prototype = Tween.prototype;

    Tween.propHooks = {
        _default: {
            get: function( tween ) {
                var result;

                // Use a property on the element directly when it is not a DOM element,
                // or when there is no matching style property that exists.
                if ( tween.elem.nodeType !== 1 ||
                    tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
                    return tween.elem[ tween.prop ];
                }

                // Passing an empty string as a 3rd parameter to .css will automatically
                // attempt a parseFloat and fallback to a string if the parse fails.
                // Simple values such as "10px" are parsed to Float;
                // complex values such as "rotate(1rad)" are returned as-is.
                result = jQuery.css( tween.elem, tween.prop, "" );

                // Empty strings, null, undefined and "auto" are converted to 0.
                return !result || result === "auto" ? 0 : result;
            },
            set: function( tween ) {

                // Use step hook for back compat.
                // Use cssHook if its there.
                // Use .style if available and use plain properties where available.
                if ( jQuery.fx.step[ tween.prop ] ) {
                    jQuery.fx.step[ tween.prop ]( tween );
                } else if ( tween.elem.nodeType === 1 &&
                    ( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||
                    jQuery.cssHooks[ tween.prop ] ) ) {
                    jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
                } else {
                    tween.elem[ tween.prop ] = tween.now;
                }
            }
        }
    };

// Support: IE <=9 only
// Panic based approach to setting things on disconnected nodes
    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
        set: function( tween ) {
            if ( tween.elem.nodeType && tween.elem.parentNode ) {
                tween.elem[ tween.prop ] = tween.now;
            }
        }
    };

    jQuery.easing = {
        linear: function( p ) {
            return p;
        },
        swing: function( p ) {
            return 0.5 - Math.cos( p * Math.PI ) / 2;
        },
        _default: "swing"
    };

    jQuery.fx = Tween.prototype.init;

// Back compat <1.8 extension point
    jQuery.fx.step = {};




    var
        fxNow, timerId,
        rfxtypes = /^(?:toggle|show|hide)$/,
        rrun = /queueHooks$/;

    function raf() {
        if ( timerId ) {
            window.requestAnimationFrame( raf );
            jQuery.fx.tick();
        }
    }

// Animations created synchronously will run synchronously
    function createFxNow() {
        window.setTimeout( function() {
            fxNow = undefined;
        } );
        return ( fxNow = jQuery.now() );
    }

// Generate parameters to create a standard animation
    function genFx( type, includeWidth ) {
        var which,
            i = 0,
            attrs = { height: type };

        // If we include width, step value is 1 to do all cssExpand values,
        // otherwise step value is 2 to skip over Left and Right
        includeWidth = includeWidth ? 1 : 0;
        for ( ; i < 4 ; i += 2 - includeWidth ) {
            which = cssExpand[ i ];
            attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
        }

        if ( includeWidth ) {
            attrs.opacity = attrs.width = type;
        }

        return attrs;
    }

    function createTween( value, prop, animation ) {
        var tween,
            collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
            index = 0,
            length = collection.length;
        for ( ; index < length; index++ ) {
            if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

                // We're done with this property
                return tween;
            }
        }
    }

    function defaultPrefilter( elem, props, opts ) {
        /* jshint validthis: true */
        var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
            isBox = "width" in props || "height" in props,
            anim = this,
            orig = {},
            style = elem.style,
            hidden = elem.nodeType && isHiddenWithinTree( elem ),
            dataShow = dataPriv.get( elem, "fxshow" );

        // Queue-skipping animations hijack the fx hooks
        if ( !opts.queue ) {
            hooks = jQuery._queueHooks( elem, "fx" );
            if ( hooks.unqueued == null ) {
                hooks.unqueued = 0;
                oldfire = hooks.empty.fire;
                hooks.empty.fire = function() {
                    if ( !hooks.unqueued ) {
                        oldfire();
                    }
                };
            }
            hooks.unqueued++;

            anim.always( function() {

                // Ensure the complete handler is called before this completes
                anim.always( function() {
                    hooks.unqueued--;
                    if ( !jQuery.queue( elem, "fx" ).length ) {
                        hooks.empty.fire();
                    }
                } );
            } );
        }

        // Detect show/hide animations
        for ( prop in props ) {
            value = props[ prop ];
            if ( rfxtypes.test( value ) ) {
                delete props[ prop ];
                toggle = toggle || value === "toggle";
                if ( value === ( hidden ? "hide" : "show" ) ) {

                    // Pretend to be hidden if this is a "show" and
                    // there is still data from a stopped show/hide
                    if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
                        hidden = true;

                        // Ignore all other no-op show/hide data
                    } else {
                        continue;
                    }
                }
                orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
            }
        }

        // Bail out if this is a no-op like .hide().hide()
        propTween = !jQuery.isEmptyObject( props );
        if ( !propTween && jQuery.isEmptyObject( orig ) ) {
            return;
        }

        // Restrict "overflow" and "display" styles during box animations
        if ( isBox && elem.nodeType === 1 ) {

            // Support: IE <=9 - 11, Edge 12 - 13
            // Record all 3 overflow attributes because IE does not infer the shorthand
            // from identically-valued overflowX and overflowY
            opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

            // Identify a display type, preferring old show/hide data over the CSS cascade
            restoreDisplay = dataShow && dataShow.display;
            if ( restoreDisplay == null ) {
                restoreDisplay = dataPriv.get( elem, "display" );
            }
            display = jQuery.css( elem, "display" );
            if ( display === "none" ) {
                if ( restoreDisplay ) {
                    display = restoreDisplay;
                } else {

                    // Get nonempty value(s) by temporarily forcing visibility
                    showHide( [ elem ], true );
                    restoreDisplay = elem.style.display || restoreDisplay;
                    display = jQuery.css( elem, "display" );
                    showHide( [ elem ] );
                }
            }

            // Animate inline elements as inline-block
            if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
                if ( jQuery.css( elem, "float" ) === "none" ) {

                    // Restore the original display value at the end of pure show/hide animations
                    if ( !propTween ) {
                        anim.done( function() {
                            style.display = restoreDisplay;
                        } );
                        if ( restoreDisplay == null ) {
                            display = style.display;
                            restoreDisplay = display === "none" ? "" : display;
                        }
                    }
                    style.display = "inline-block";
                }
            }
        }

        if ( opts.overflow ) {
            style.overflow = "hidden";
            anim.always( function() {
                style.overflow = opts.overflow[ 0 ];
                style.overflowX = opts.overflow[ 1 ];
                style.overflowY = opts.overflow[ 2 ];
            } );
        }

        // Implement show/hide animations
        propTween = false;
        for ( prop in orig ) {

            // General show/hide setup for this element animation
            if ( !propTween ) {
                if ( dataShow ) {
                    if ( "hidden" in dataShow ) {
                        hidden = dataShow.hidden;
                    }
                } else {
                    dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
                }

                // Store hidden/visible for toggle so `.stop().toggle()` "reverses"
                if ( toggle ) {
                    dataShow.hidden = !hidden;
                }

                // Show elements before animating them
                if ( hidden ) {
                    showHide( [ elem ], true );
                }

                /* jshint -W083 */
                anim.done( function() {

                    // The final step of a "hide" animation is actually hiding the element
                    if ( !hidden ) {
                        showHide( [ elem ] );
                    }
                    dataPriv.remove( elem, "fxshow" );
                    for ( prop in orig ) {
                        jQuery.style( elem, prop, orig[ prop ] );
                    }
                } );
            }

            // Per-property setup
            propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
            if ( !( prop in dataShow ) ) {
                dataShow[ prop ] = propTween.start;
                if ( hidden ) {
                    propTween.end = propTween.start;
                    propTween.start = 0;
                }
            }
        }
    }

    function propFilter( props, specialEasing ) {
        var index, name, easing, value, hooks;

        // camelCase, specialEasing and expand cssHook pass
        for ( index in props ) {
            name = jQuery.camelCase( index );
            easing = specialEasing[ name ];
            value = props[ index ];
            if ( jQuery.isArray( value ) ) {
                easing = value[ 1 ];
                value = props[ index ] = value[ 0 ];
            }

            if ( index !== name ) {
                props[ name ] = value;
                delete props[ index ];
            }

            hooks = jQuery.cssHooks[ name ];
            if ( hooks && "expand" in hooks ) {
                value = hooks.expand( value );
                delete props[ name ];

                // Not quite $.extend, this won't overwrite existing keys.
                // Reusing 'index' because we have the correct "name"
                for ( index in value ) {
                    if ( !( index in props ) ) {
                        props[ index ] = value[ index ];
                        specialEasing[ index ] = easing;
                    }
                }
            } else {
                specialEasing[ name ] = easing;
            }
        }
    }

    function Animation( elem, properties, options ) {
        var result,
            stopped,
            index = 0,
            length = Animation.prefilters.length,
            deferred = jQuery.Deferred().always( function() {

                // Don't match elem in the :animated selector
                delete tick.elem;
            } ),
            tick = function() {
                if ( stopped ) {
                    return false;
                }
                var currentTime = fxNow || createFxNow(),
                    remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

                // Support: Android 2.3 only
                // Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
                    temp = remaining / animation.duration || 0,
                    percent = 1 - temp,
                    index = 0,
                    length = animation.tweens.length;

                for ( ; index < length ; index++ ) {
                    animation.tweens[ index ].run( percent );
                }

                deferred.notifyWith( elem, [ animation, percent, remaining ] );

                if ( percent < 1 && length ) {
                    return remaining;
                } else {
                    deferred.resolveWith( elem, [ animation ] );
                    return false;
                }
            },
            animation = deferred.promise( {
                elem: elem,
                props: jQuery.extend( {}, properties ),
                opts: jQuery.extend( true, {
                    specialEasing: {},
                    easing: jQuery.easing._default
                }, options ),
                originalProperties: properties,
                originalOptions: options,
                startTime: fxNow || createFxNow(),
                duration: options.duration,
                tweens: [],
                createTween: function( prop, end ) {
                    var tween = jQuery.Tween( elem, animation.opts, prop, end,
                        animation.opts.specialEasing[ prop ] || animation.opts.easing );
                    animation.tweens.push( tween );
                    return tween;
                },
                stop: function( gotoEnd ) {
                    var index = 0,

                    // If we are going to the end, we want to run all the tweens
                    // otherwise we skip this part
                        length = gotoEnd ? animation.tweens.length : 0;
                    if ( stopped ) {
                        return this;
                    }
                    stopped = true;
                    for ( ; index < length ; index++ ) {
                        animation.tweens[ index ].run( 1 );
                    }

                    // Resolve when we played the last frame; otherwise, reject
                    if ( gotoEnd ) {
                        deferred.notifyWith( elem, [ animation, 1, 0 ] );
                        deferred.resolveWith( elem, [ animation, gotoEnd ] );
                    } else {
                        deferred.rejectWith( elem, [ animation, gotoEnd ] );
                    }
                    return this;
                }
            } ),
            props = animation.props;

        propFilter( props, animation.opts.specialEasing );

        for ( ; index < length ; index++ ) {
            result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
            if ( result ) {
                if ( jQuery.isFunction( result.stop ) ) {
                    jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
                        jQuery.proxy( result.stop, result );
                }
                return result;
            }
        }

        jQuery.map( props, createTween, animation );

        if ( jQuery.isFunction( animation.opts.start ) ) {
            animation.opts.start.call( elem, animation );
        }

        jQuery.fx.timer(
            jQuery.extend( tick, {
                elem: elem,
                anim: animation,
                queue: animation.opts.queue
            } )
        );

        // attach callbacks from options
        return animation.progress( animation.opts.progress )
            .done( animation.opts.done, animation.opts.complete )
            .fail( animation.opts.fail )
            .always( animation.opts.always );
    }

    jQuery.Animation = jQuery.extend( Animation, {

        tweeners: {
            "*": [ function( prop, value ) {
                var tween = this.createTween( prop, value );
                adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
                return tween;
            } ]
        },

        tweener: function( props, callback ) {
            if ( jQuery.isFunction( props ) ) {
                callback = props;
                props = [ "*" ];
            } else {
                props = props.match( rnotwhite );
            }

            var prop,
                index = 0,
                length = props.length;

            for ( ; index < length ; index++ ) {
                prop = props[ index ];
                Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
                Animation.tweeners[ prop ].unshift( callback );
            }
        },

        prefilters: [ defaultPrefilter ],

        prefilter: function( callback, prepend ) {
            if ( prepend ) {
                Animation.prefilters.unshift( callback );
            } else {
                Animation.prefilters.push( callback );
            }
        }
    } );

    jQuery.speed = function( speed, easing, fn ) {
        var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
            complete: fn || !fn && easing ||
            jQuery.isFunction( speed ) && speed,
            duration: speed,
            easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing
        };

        // Go to the end state if fx are off or if document is hidden
        if ( jQuery.fx.off || document.hidden ) {
            opt.duration = 0;

        } else {
            opt.duration = typeof opt.duration === "number" ?
                opt.duration : opt.duration in jQuery.fx.speeds ?
                jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;
        }

        // Normalize opt.queue - true/undefined/null -> "fx"
        if ( opt.queue == null || opt.queue === true ) {
            opt.queue = "fx";
        }

        // Queueing
        opt.old = opt.complete;

        opt.complete = function() {
            if ( jQuery.isFunction( opt.old ) ) {
                opt.old.call( this );
            }

            if ( opt.queue ) {
                jQuery.dequeue( this, opt.queue );
            }
        };

        return opt;
    };

    jQuery.fn.extend( {
        fadeTo: function( speed, to, easing, callback ) {

            // Show any hidden elements after setting opacity to 0
            return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

                // Animate to the value specified
                .end().animate( { opacity: to }, speed, easing, callback );
        },
        animate: function( prop, speed, easing, callback ) {
            var empty = jQuery.isEmptyObject( prop ),
                optall = jQuery.speed( speed, easing, callback ),
                doAnimation = function() {

                    // Operate on a copy of prop so per-property easing won't be lost
                    var anim = Animation( this, jQuery.extend( {}, prop ), optall );

                    // Empty animations, or finishing resolves immediately
                    if ( empty || dataPriv.get( this, "finish" ) ) {
                        anim.stop( true );
                    }
                };
            doAnimation.finish = doAnimation;

            return empty || optall.queue === false ?
                this.each( doAnimation ) :
                this.queue( optall.queue, doAnimation );
        },
        stop: function( type, clearQueue, gotoEnd ) {
            var stopQueue = function( hooks ) {
                var stop = hooks.stop;
                delete hooks.stop;
                stop( gotoEnd );
            };

            if ( typeof type !== "string" ) {
                gotoEnd = clearQueue;
                clearQueue = type;
                type = undefined;
            }
            if ( clearQueue && type !== false ) {
                this.queue( type || "fx", [] );
            }

            return this.each( function() {
                var dequeue = true,
                    index = type != null && type + "queueHooks",
                    timers = jQuery.timers,
                    data = dataPriv.get( this );

                if ( index ) {
                    if ( data[ index ] && data[ index ].stop ) {
                        stopQueue( data[ index ] );
                    }
                } else {
                    for ( index in data ) {
                        if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
                            stopQueue( data[ index ] );
                        }
                    }
                }

                for ( index = timers.length; index--; ) {
                    if ( timers[ index ].elem === this &&
                        ( type == null || timers[ index ].queue === type ) ) {

                        timers[ index ].anim.stop( gotoEnd );
                        dequeue = false;
                        timers.splice( index, 1 );
                    }
                }

                // Start the next in the queue if the last step wasn't forced.
                // Timers currently will call their complete callbacks, which
                // will dequeue but only if they were gotoEnd.
                if ( dequeue || !gotoEnd ) {
                    jQuery.dequeue( this, type );
                }
            } );
        },
        finish: function( type ) {
            if ( type !== false ) {
                type = type || "fx";
            }
            return this.each( function() {
                var index,
                    data = dataPriv.get( this ),
                    queue = data[ type + "queue" ],
                    hooks = data[ type + "queueHooks" ],
                    timers = jQuery.timers,
                    length = queue ? queue.length : 0;

                // Enable finishing flag on private data
                data.finish = true;

                // Empty the queue first
                jQuery.queue( this, type, [] );

                if ( hooks && hooks.stop ) {
                    hooks.stop.call( this, true );
                }

                // Look for any active animations, and finish them
                for ( index = timers.length; index--; ) {
                    if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
                        timers[ index ].anim.stop( true );
                        timers.splice( index, 1 );
                    }
                }

                // Look for any animations in the old queue and finish them
                for ( index = 0; index < length; index++ ) {
                    if ( queue[ index ] && queue[ index ].finish ) {
                        queue[ index ].finish.call( this );
                    }
                }

                // Turn off finishing flag
                delete data.finish;
            } );
        }
    } );

    jQuery.each( [ "toggle", "show", "hide" ], function( i, name ) {
        var cssFn = jQuery.fn[ name ];
        jQuery.fn[ name ] = function( speed, easing, callback ) {
            return speed == null || typeof speed === "boolean" ?
                cssFn.apply( this, arguments ) :
                this.animate( genFx( name, true ), speed, easing, callback );
        };
    } );

// Generate shortcuts for custom animations
    jQuery.each( {
        slideDown: genFx( "show" ),
        slideUp: genFx( "hide" ),
        slideToggle: genFx( "toggle" ),
        fadeIn: { opacity: "show" },
        fadeOut: { opacity: "hide" },
        fadeToggle: { opacity: "toggle" }
    }, function( name, props ) {
        jQuery.fn[ name ] = function( speed, easing, callback ) {
            return this.animate( props, speed, easing, callback );
        };
    } );

    jQuery.timers = [];
    jQuery.fx.tick = function() {
        var timer,
            i = 0,
            timers = jQuery.timers;

        fxNow = jQuery.now();

        for ( ; i < timers.length; i++ ) {
            timer = timers[ i ];

            // Checks the timer has not already been removed
            if ( !timer() && timers[ i ] === timer ) {
                timers.splice( i--, 1 );
            }
        }

        if ( !timers.length ) {
            jQuery.fx.stop();
        }
        fxNow = undefined;
    };

    jQuery.fx.timer = function( timer ) {
        jQuery.timers.push( timer );
        if ( timer() ) {
            jQuery.fx.start();
        } else {
            jQuery.timers.pop();
        }
    };

    jQuery.fx.interval = 13;
    jQuery.fx.start = function() {
        if ( !timerId ) {
            timerId = window.requestAnimationFrame ?
                window.requestAnimationFrame( raf ) :
                window.setInterval( jQuery.fx.tick, jQuery.fx.interval );
        }
    };

    jQuery.fx.stop = function() {
        if ( window.cancelAnimationFrame ) {
            window.cancelAnimationFrame( timerId );
        } else {
            window.clearInterval( timerId );
        }

        timerId = null;
    };

    jQuery.fx.speeds = {
        slow: 600,
        fast: 200,

        // Default speed
        _default: 400
    };


// Based off of the plugin by Clint Helfers, with permission.
// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
    jQuery.fn.delay = function( time, type ) {
        time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
        type = type || "fx";

        return this.queue( type, function( next, hooks ) {
            var timeout = window.setTimeout( next, time );
            hooks.stop = function() {
                window.clearTimeout( timeout );
            };
        } );
    };


    ( function() {
        var input = document.createElement( "input" ),
            select = document.createElement( "select" ),
            opt = select.appendChild( document.createElement( "option" ) );

        input.type = "checkbox";

        // Support: Android <=4.3 only
        // Default value for a checkbox should be "on"
        support.checkOn = input.value !== "";

        // Support: IE <=11 only
        // Must access selectedIndex to make default options select
        support.optSelected = opt.selected;

        // Support: IE <=11 only
        // An input loses its value after becoming a radio
        input = document.createElement( "input" );
        input.value = "t";
        input.type = "radio";
        support.radioValue = input.value === "t";
    } )();


    var boolHook,
        attrHandle = jQuery.expr.attrHandle;

    jQuery.fn.extend( {
        attr: function( name, value ) {
            return access( this, jQuery.attr, name, value, arguments.length > 1 );
        },

        removeAttr: function( name ) {
            return this.each( function() {
                jQuery.removeAttr( this, name );
            } );
        }
    } );

    jQuery.extend( {
        attr: function( elem, name, value ) {
            var ret, hooks,
                nType = elem.nodeType;

            // Don't get/set attributes on text, comment and attribute nodes
            if ( nType === 3 || nType === 8 || nType === 2 ) {
                return;
            }

            // Fallback to prop when attributes are not supported
            if ( typeof elem.getAttribute === "undefined" ) {
                return jQuery.prop( elem, name, value );
            }

            // Attribute hooks are determined by the lowercase version
            // Grab necessary hook if one is defined
            if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
                hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
                    ( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
            }

            if ( value !== undefined ) {
                if ( value === null ) {
                    jQuery.removeAttr( elem, name );
                    return;
                }

                if ( hooks && "set" in hooks &&
                    ( ret = hooks.set( elem, value, name ) ) !== undefined ) {
                    return ret;
                }

                elem.setAttribute( name, value + "" );
                return value;
            }

            if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
                return ret;
            }

            ret = jQuery.find.attr( elem, name );

            // Non-existent attributes return null, we normalize to undefined
            return ret == null ? undefined : ret;
        },

        attrHooks: {
            type: {
                set: function( elem, value ) {
                    if ( !support.radioValue && value === "radio" &&
                        jQuery.nodeName( elem, "input" ) ) {
                        var val = elem.value;
                        elem.setAttribute( "type", value );
                        if ( val ) {
                            elem.value = val;
                        }
                        return value;
                    }
                }
            }
        },

        removeAttr: function( elem, value ) {
            var name,
                i = 0,
                attrNames = value && value.match( rnotwhite );

            if ( attrNames && elem.nodeType === 1 ) {
                while ( ( name = attrNames[ i++ ] ) ) {
                    elem.removeAttribute( name );
                }
            }
        }
    } );

// Hooks for boolean attributes
    boolHook = {
        set: function( elem, value, name ) {
            if ( value === false ) {

                // Remove boolean attributes when set to false
                jQuery.removeAttr( elem, name );
            } else {
                elem.setAttribute( name, name );
            }
            return name;
        }
    };

    jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( i, name ) {
        var getter = attrHandle[ name ] || jQuery.find.attr;

        attrHandle[ name ] = function( elem, name, isXML ) {
            var ret, handle,
                lowercaseName = name.toLowerCase();

            if ( !isXML ) {

                // Avoid an infinite loop by temporarily removing this function from the getter
                handle = attrHandle[ lowercaseName ];
                attrHandle[ lowercaseName ] = ret;
                ret = getter( elem, name, isXML ) != null ?
                    lowercaseName :
                    null;
                attrHandle[ lowercaseName ] = handle;
            }
            return ret;
        };
    } );




    var rfocusable = /^(?:input|select|textarea|button)$/i,
        rclickable = /^(?:a|area)$/i;

    jQuery.fn.extend( {
        prop: function( name, value ) {
            return access( this, jQuery.prop, name, value, arguments.length > 1 );
        },

        removeProp: function( name ) {
            return this.each( function() {
                delete this[ jQuery.propFix[ name ] || name ];
            } );
        }
    } );

    jQuery.extend( {
        prop: function( elem, name, value ) {
            var ret, hooks,
                nType = elem.nodeType;

            // Don't get/set properties on text, comment and attribute nodes
            if ( nType === 3 || nType === 8 || nType === 2 ) {
                return;
            }

            if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

                // Fix name and attach hooks
                name = jQuery.propFix[ name ] || name;
                hooks = jQuery.propHooks[ name ];
            }

            if ( value !== undefined ) {
                if ( hooks && "set" in hooks &&
                    ( ret = hooks.set( elem, value, name ) ) !== undefined ) {
                    return ret;
                }

                return ( elem[ name ] = value );
            }

            if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
                return ret;
            }

            return elem[ name ];
        },

        propHooks: {
            tabIndex: {
                get: function( elem ) {

                    // Support: IE <=9 - 11 only
                    // elem.tabIndex doesn't always return the
                    // correct value when it hasn't been explicitly set
                    // https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
                    // Use proper attribute retrieval(#12072)
                    var tabindex = jQuery.find.attr( elem, "tabindex" );

                    return tabindex ?
                        parseInt( tabindex, 10 ) :
                        rfocusable.test( elem.nodeName ) ||
                        rclickable.test( elem.nodeName ) && elem.href ?
                            0 :
                            -1;
                }
            }
        },

        propFix: {
            "for": "htmlFor",
            "class": "className"
        }
    } );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
    if ( !support.optSelected ) {
        jQuery.propHooks.selected = {
            get: function( elem ) {
                var parent = elem.parentNode;
                if ( parent && parent.parentNode ) {
                    parent.parentNode.selectedIndex;
                }
                return null;
            },
            set: function( elem ) {
                var parent = elem.parentNode;
                if ( parent ) {
                    parent.selectedIndex;

                    if ( parent.parentNode ) {
                        parent.parentNode.selectedIndex;
                    }
                }
            }
        };
    }

    jQuery.each( [
        "tabIndex",
        "readOnly",
        "maxLength",
        "cellSpacing",
        "cellPadding",
        "rowSpan",
        "colSpan",
        "useMap",
        "frameBorder",
        "contentEditable"
    ], function() {
        jQuery.propFix[ this.toLowerCase() ] = this;
    } );




    var rclass = /[\t\r\n\f]/g;

    function getClass( elem ) {
        return elem.getAttribute && elem.getAttribute( "class" ) || "";
    }

    jQuery.fn.extend( {
        addClass: function( value ) {
            var classes, elem, cur, curValue, clazz, j, finalValue,
                i = 0;

            if ( jQuery.isFunction( value ) ) {
                return this.each( function( j ) {
                    jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
                } );
            }

            if ( typeof value === "string" && value ) {
                classes = value.match( rnotwhite ) || [];

                while ( ( elem = this[ i++ ] ) ) {
                    curValue = getClass( elem );
                    cur = elem.nodeType === 1 &&
                        ( " " + curValue + " " ).replace( rclass, " " );

                    if ( cur ) {
                        j = 0;
                        while ( ( clazz = classes[ j++ ] ) ) {
                            if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
                                cur += clazz + " ";
                            }
                        }

                        // Only assign if different to avoid unneeded rendering.
                        finalValue = jQuery.trim( cur );
                        if ( curValue !== finalValue ) {
                            elem.setAttribute( "class", finalValue );
                        }
                    }
                }
            }

            return this;
        },

        removeClass: function( value ) {
            var classes, elem, cur, curValue, clazz, j, finalValue,
                i = 0;

            if ( jQuery.isFunction( value ) ) {
                return this.each( function( j ) {
                    jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
                } );
            }

            if ( !arguments.length ) {
                return this.attr( "class", "" );
            }

            if ( typeof value === "string" && value ) {
                classes = value.match( rnotwhite ) || [];

                while ( ( elem = this[ i++ ] ) ) {
                    curValue = getClass( elem );

                    // This expression is here for better compressibility (see addClass)
                    cur = elem.nodeType === 1 &&
                        ( " " + curValue + " " ).replace( rclass, " " );

                    if ( cur ) {
                        j = 0;
                        while ( ( clazz = classes[ j++ ] ) ) {

                            // Remove *all* instances
                            while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
                                cur = cur.replace( " " + clazz + " ", " " );
                            }
                        }

                        // Only assign if different to avoid unneeded rendering.
                        finalValue = jQuery.trim( cur );
                        if ( curValue !== finalValue ) {
                            elem.setAttribute( "class", finalValue );
                        }
                    }
                }
            }

            return this;
        },

        toggleClass: function( value, stateVal ) {
            var type = typeof value;

            if ( typeof stateVal === "boolean" && type === "string" ) {
                return stateVal ? this.addClass( value ) : this.removeClass( value );
            }

            if ( jQuery.isFunction( value ) ) {
                return this.each( function( i ) {
                    jQuery( this ).toggleClass(
                        value.call( this, i, getClass( this ), stateVal ),
                        stateVal
                    );
                } );
            }

            return this.each( function() {
                var className, i, self, classNames;

                if ( type === "string" ) {

                    // Toggle individual class names
                    i = 0;
                    self = jQuery( this );
                    classNames = value.match( rnotwhite ) || [];

                    while ( ( className = classNames[ i++ ] ) ) {

                        // Check each className given, space separated list
                        if ( self.hasClass( className ) ) {
                            self.removeClass( className );
                        } else {
                            self.addClass( className );
                        }
                    }

                    // Toggle whole class name
                } else if ( value === undefined || type === "boolean" ) {
                    className = getClass( this );
                    if ( className ) {

                        // Store className if set
                        dataPriv.set( this, "__className__", className );
                    }

                    // If the element has a class name or if we're passed `false`,
                    // then remove the whole classname (if there was one, the above saved it).
                    // Otherwise bring back whatever was previously saved (if anything),
                    // falling back to the empty string if nothing was stored.
                    if ( this.setAttribute ) {
                        this.setAttribute( "class",
                            className || value === false ?
                                "" :
                            dataPriv.get( this, "__className__" ) || ""
                        );
                    }
                }
            } );
        },

        hasClass: function( selector ) {
            var className, elem,
                i = 0;

            className = " " + selector + " ";
            while ( ( elem = this[ i++ ] ) ) {
                if ( elem.nodeType === 1 &&
                    ( " " + getClass( elem ) + " " ).replace( rclass, " " )
                        .indexOf( className ) > -1
                ) {
                    return true;
                }
            }

            return false;
        }
    } );




    var rreturn = /\r/g,
        rspaces = /[\x20\t\r\n\f]+/g;

    jQuery.fn.extend( {
        val: function( value ) {
            var hooks, ret, isFunction,
                elem = this[ 0 ];

            if ( !arguments.length ) {
                if ( elem ) {
                    hooks = jQuery.valHooks[ elem.type ] ||
                        jQuery.valHooks[ elem.nodeName.toLowerCase() ];

                    if ( hooks &&
                        "get" in hooks &&
                        ( ret = hooks.get( elem, "value" ) ) !== undefined
                    ) {
                        return ret;
                    }

                    ret = elem.value;

                    return typeof ret === "string" ?

                        // Handle most common string cases
                        ret.replace( rreturn, "" ) :

                        // Handle cases where value is null/undef or number
                        ret == null ? "" : ret;
                }

                return;
            }

            isFunction = jQuery.isFunction( value );

            return this.each( function( i ) {
                var val;

                if ( this.nodeType !== 1 ) {
                    return;
                }

                if ( isFunction ) {
                    val = value.call( this, i, jQuery( this ).val() );
                } else {
                    val = value;
                }

                // Treat null/undefined as ""; convert numbers to string
                if ( val == null ) {
                    val = "";

                } else if ( typeof val === "number" ) {
                    val += "";

                } else if ( jQuery.isArray( val ) ) {
                    val = jQuery.map( val, function( value ) {
                        return value == null ? "" : value + "";
                    } );
                }

                hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

                // If set returns undefined, fall back to normal setting
                if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
                    this.value = val;
                }
            } );
        }
    } );

    jQuery.extend( {
        valHooks: {
            option: {
                get: function( elem ) {

                    var val = jQuery.find.attr( elem, "value" );
                    return val != null ?
                        val :

                        // Support: IE <=10 - 11 only
                        // option.text throws exceptions (#14686, #14858)
                        // Strip and collapse whitespace
                        // https://html.spec.whatwg.org/#strip-and-collapse-whitespace
                        jQuery.trim( jQuery.text( elem ) ).replace( rspaces, " " );
                }
            },
            select: {
                get: function( elem ) {
                    var value, option,
                        options = elem.options,
                        index = elem.selectedIndex,
                        one = elem.type === "select-one",
                        values = one ? null : [],
                        max = one ? index + 1 : options.length,
                        i = index < 0 ?
                            max :
                            one ? index : 0;

                    // Loop through all the selected options
                    for ( ; i < max; i++ ) {
                        option = options[ i ];

                        // Support: IE <=9 only
                        // IE8-9 doesn't update selected after form reset (#2551)
                        if ( ( option.selected || i === index ) &&

                                // Don't return options that are disabled or in a disabled optgroup
                            !option.disabled &&
                            ( !option.parentNode.disabled ||
                            !jQuery.nodeName( option.parentNode, "optgroup" ) ) ) {

                            // Get the specific value for the option
                            value = jQuery( option ).val();

                            // We don't need an array for one selects
                            if ( one ) {
                                return value;
                            }

                            // Multi-Selects return an array
                            values.push( value );
                        }
                    }

                    return values;
                },

                set: function( elem, value ) {
                    var optionSet, option,
                        options = elem.options,
                        values = jQuery.makeArray( value ),
                        i = options.length;

                    while ( i-- ) {
                        option = options[ i ];
                        if ( option.selected =
                                jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
                        ) {
                            optionSet = true;
                        }
                    }

                    // Force browsers to behave consistently when non-matching value is set
                    if ( !optionSet ) {
                        elem.selectedIndex = -1;
                    }
                    return values;
                }
            }
        }
    } );

// Radios and checkboxes getter/setter
    jQuery.each( [ "radio", "checkbox" ], function() {
        jQuery.valHooks[ this ] = {
            set: function( elem, value ) {
                if ( jQuery.isArray( value ) ) {
                    return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
                }
            }
        };
        if ( !support.checkOn ) {
            jQuery.valHooks[ this ].get = function( elem ) {
                return elem.getAttribute( "value" ) === null ? "on" : elem.value;
            };
        }
    } );




// Return jQuery for attributes-only inclusion


    var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/;

    jQuery.extend( jQuery.event, {

        trigger: function( event, data, elem, onlyHandlers ) {

            var i, cur, tmp, bubbleType, ontype, handle, special,
                eventPath = [ elem || document ],
                type = hasOwn.call( event, "type" ) ? event.type : event,
                namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

            cur = tmp = elem = elem || document;

            // Don't do events on text and comment nodes
            if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
                return;
            }

            // focus/blur morphs to focusin/out; ensure we're not firing them right now
            if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
                return;
            }

            if ( type.indexOf( "." ) > -1 ) {

                // Namespaced trigger; create a regexp to match event type in handle()
                namespaces = type.split( "." );
                type = namespaces.shift();
                namespaces.sort();
            }
            ontype = type.indexOf( ":" ) < 0 && "on" + type;

            // Caller can pass in a jQuery.Event object, Object, or just an event type string
            event = event[ jQuery.expando ] ?
                event :
                new jQuery.Event( type, typeof event === "object" && event );

            // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
            event.isTrigger = onlyHandlers ? 2 : 3;
            event.namespace = namespaces.join( "." );
            event.rnamespace = event.namespace ?
                new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
                null;

            // Clean up the event in case it is being reused
            event.result = undefined;
            if ( !event.target ) {
                event.target = elem;
            }

            // Clone any incoming data and prepend the event, creating the handler arg list
            data = data == null ?
                [ event ] :
                jQuery.makeArray( data, [ event ] );

            // Allow special events to draw outside the lines
            special = jQuery.event.special[ type ] || {};
            if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
                return;
            }

            // Determine event propagation path in advance, per W3C events spec (#9951)
            // Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
            if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {

                bubbleType = special.delegateType || type;
                if ( !rfocusMorph.test( bubbleType + type ) ) {
                    cur = cur.parentNode;
                }
                for ( ; cur; cur = cur.parentNode ) {
                    eventPath.push( cur );
                    tmp = cur;
                }

                // Only add window if we got to document (e.g., not plain obj or detached DOM)
                if ( tmp === ( elem.ownerDocument || document ) ) {
                    eventPath.push( tmp.defaultView || tmp.parentWindow || window );
                }
            }

            // Fire handlers on the event path
            i = 0;
            while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {

                event.type = i > 1 ?
                    bubbleType :
                special.bindType || type;

                // jQuery handler
                handle = ( dataPriv.get( cur, "events" ) || {} )[ event.type ] &&
                    dataPriv.get( cur, "handle" );
                if ( handle ) {
                    handle.apply( cur, data );
                }

                // Native handler
                handle = ontype && cur[ ontype ];
                if ( handle && handle.apply && acceptData( cur ) ) {
                    event.result = handle.apply( cur, data );
                    if ( event.result === false ) {
                        event.preventDefault();
                    }
                }
            }
            event.type = type;

            // If nobody prevented the default action, do it now
            if ( !onlyHandlers && !event.isDefaultPrevented() ) {

                if ( ( !special._default ||
                    special._default.apply( eventPath.pop(), data ) === false ) &&
                    acceptData( elem ) ) {

                    // Call a native DOM method on the target with the same name as the event.
                    // Don't do default actions on window, that's where global variables be (#6170)
                    if ( ontype && jQuery.isFunction( elem[ type ] ) && !jQuery.isWindow( elem ) ) {

                        // Don't re-trigger an onFOO event when we call its FOO() method
                        tmp = elem[ ontype ];

                        if ( tmp ) {
                            elem[ ontype ] = null;
                        }

                        // Prevent re-triggering of the same event, since we already bubbled it above
                        jQuery.event.triggered = type;
                        elem[ type ]();
                        jQuery.event.triggered = undefined;

                        if ( tmp ) {
                            elem[ ontype ] = tmp;
                        }
                    }
                }
            }

            return event.result;
        },

        // Piggyback on a donor event to simulate a different one
        // Used only for `focus(in | out)` events
        simulate: function( type, elem, event ) {
            var e = jQuery.extend(
                new jQuery.Event(),
                event,
                {
                    type: type,
                    isSimulated: true
                }
            );

            jQuery.event.trigger( e, null, elem );
        }

    } );

    jQuery.fn.extend( {

        trigger: function( type, data ) {
            return this.each( function() {
                jQuery.event.trigger( type, data, this );
            } );
        },
        triggerHandler: function( type, data ) {
            var elem = this[ 0 ];
            if ( elem ) {
                return jQuery.event.trigger( type, data, elem, true );
            }
        }
    } );


    jQuery.each( ( "blur focus focusin focusout resize scroll click dblclick " +
        "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
        "change select submit keydown keypress keyup contextmenu" ).split( " " ),
        function( i, name ) {

            // Handle event binding
            jQuery.fn[ name ] = function( data, fn ) {
                return arguments.length > 0 ?
                    this.on( name, null, data, fn ) :
                    this.trigger( name );
            };
        } );

    jQuery.fn.extend( {
        hover: function( fnOver, fnOut ) {
            return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
        }
    } );




    support.focusin = "onfocusin" in window;


// Support: Firefox <=44
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
    if ( !support.focusin ) {
        jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

            // Attach a single capturing handler on the document while someone wants focusin/focusout
            var handler = function( event ) {
                jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
            };

            jQuery.event.special[ fix ] = {
                setup: function() {
                    var doc = this.ownerDocument || this,
                        attaches = dataPriv.access( doc, fix );

                    if ( !attaches ) {
                        doc.addEventListener( orig, handler, true );
                    }
                    dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
                },
                teardown: function() {
                    var doc = this.ownerDocument || this,
                        attaches = dataPriv.access( doc, fix ) - 1;

                    if ( !attaches ) {
                        doc.removeEventListener( orig, handler, true );
                        dataPriv.remove( doc, fix );

                    } else {
                        dataPriv.access( doc, fix, attaches );
                    }
                }
            };
        } );
    }
    var location = window.location;

    var nonce = jQuery.now();

    var rquery = ( /\?/ );



// Cross-browser xml parsing
    jQuery.parseXML = function( data ) {
        var xml;
        if ( !data || typeof data !== "string" ) {
            return null;
        }

        // Support: IE 9 - 11 only
        // IE throws on parseFromString with invalid input.
        try {
            xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
        } catch ( e ) {
            xml = undefined;
        }

        if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {
            jQuery.error( "Invalid XML: " + data );
        }
        return xml;
    };


    var
        rbracket = /\[\]$/,
        rCRLF = /\r?\n/g,
        rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
        rsubmittable = /^(?:input|select|textarea|keygen)/i;

    function buildParams( prefix, obj, traditional, add ) {
        var name;

        if ( jQuery.isArray( obj ) ) {

            // Serialize array item.
            jQuery.each( obj, function( i, v ) {
                if ( traditional || rbracket.test( prefix ) ) {

                    // Treat each array item as a scalar.
                    add( prefix, v );

                } else {

                    // Item is non-scalar (array or object), encode its numeric index.
                    buildParams(
                        prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
                        v,
                        traditional,
                        add
                    );
                }
            } );

        } else if ( !traditional && jQuery.type( obj ) === "object" ) {

            // Serialize object item.
            for ( name in obj ) {
                buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
            }

        } else {

            // Serialize scalar item.
            add( prefix, obj );
        }
    }

// Serialize an array of form elements or a set of
// key/values into a query string
    jQuery.param = function( a, traditional ) {
        var prefix,
            s = [],
            add = function( key, valueOrFunction ) {

                // If value is a function, invoke it and use its return value
                var value = jQuery.isFunction( valueOrFunction ) ?
                    valueOrFunction() :
                    valueOrFunction;

                s[ s.length ] = encodeURIComponent( key ) + "=" +
                    encodeURIComponent( value == null ? "" : value );
            };

        // If an array was passed in, assume that it is an array of form elements.
        if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

            // Serialize the form elements
            jQuery.each( a, function() {
                add( this.name, this.value );
            } );

        } else {

            // If traditional, encode the "old" way (the way 1.3.2 or older
            // did it), otherwise encode params recursively.
            for ( prefix in a ) {
                buildParams( prefix, a[ prefix ], traditional, add );
            }
        }

        // Return the resulting serialization
        return s.join( "&" );
    };

    jQuery.fn.extend( {
        serialize: function() {
            return jQuery.param( this.serializeArray() );
        },
        serializeArray: function() {
            return this.map( function() {

                    // Can add propHook for "elements" to filter or add form elements
                    var elements = jQuery.prop( this, "elements" );
                    return elements ? jQuery.makeArray( elements ) : this;
                } )
                .filter( function() {
                    var type = this.type;

                    // Use .is( ":disabled" ) so that fieldset[disabled] works
                    return this.name && !jQuery( this ).is( ":disabled" ) &&
                        rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
                        ( this.checked || !rcheckableType.test( type ) );
                } )
                .map( function( i, elem ) {
                    var val = jQuery( this ).val();

                    return val == null ?
                        null :
                        jQuery.isArray( val ) ?
                            jQuery.map( val, function( val ) {
                                return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
                            } ) :
                        { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
                } ).get();
        }
    } );


    var
        r20 = /%20/g,
        rhash = /#.*$/,
        rts = /([?&])_=[^&]*/,
        rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

    // #7653, #8125, #8152: local protocol detection
        rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
        rnoContent = /^(?:GET|HEAD)$/,
        rprotocol = /^\/\//,

    /* Prefilters
     * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
     * 2) These are called:
     *    - BEFORE asking for a transport
     *    - AFTER param serialization (s.data is a string if s.processData is true)
     * 3) key is the dataType
     * 4) the catchall symbol "*" can be used
     * 5) execution will start with transport dataType and THEN continue down to "*" if needed
     */
        prefilters = {},

    /* Transports bindings
     * 1) key is the dataType
     * 2) the catchall symbol "*" can be used
     * 3) selection will start with transport dataType and THEN go to "*" if needed
     */
        transports = {},

    // Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
        allTypes = "*/".concat( "*" ),

    // Anchor tag for parsing the document origin
        originAnchor = document.createElement( "a" );
    originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
    function addToPrefiltersOrTransports( structure ) {

        // dataTypeExpression is optional and defaults to "*"
        return function( dataTypeExpression, func ) {

            if ( typeof dataTypeExpression !== "string" ) {
                func = dataTypeExpression;
                dataTypeExpression = "*";
            }

            var dataType,
                i = 0,
                dataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];

            if ( jQuery.isFunction( func ) ) {

                // For each dataType in the dataTypeExpression
                while ( ( dataType = dataTypes[ i++ ] ) ) {

                    // Prepend if requested
                    if ( dataType[ 0 ] === "+" ) {
                        dataType = dataType.slice( 1 ) || "*";
                        ( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

                        // Otherwise append
                    } else {
                        ( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
                    }
                }
            }
        };
    }

// Base inspection function for prefilters and transports
    function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

        var inspected = {},
            seekingTransport = ( structure === transports );

        function inspect( dataType ) {
            var selected;
            inspected[ dataType ] = true;
            jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
                var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
                if ( typeof dataTypeOrTransport === "string" &&
                    !seekingTransport && !inspected[ dataTypeOrTransport ] ) {

                    options.dataTypes.unshift( dataTypeOrTransport );
                    inspect( dataTypeOrTransport );
                    return false;
                } else if ( seekingTransport ) {
                    return !( selected = dataTypeOrTransport );
                }
            } );
            return selected;
        }

        return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
    }

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
    function ajaxExtend( target, src ) {
        var key, deep,
            flatOptions = jQuery.ajaxSettings.flatOptions || {};

        for ( key in src ) {
            if ( src[ key ] !== undefined ) {
                ( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
            }
        }
        if ( deep ) {
            jQuery.extend( true, target, deep );
        }

        return target;
    }

    /* Handles responses to an ajax request:
     * - finds the right dataType (mediates between content-type and expected dataType)
     * - returns the corresponding response
     */
    function ajaxHandleResponses( s, jqXHR, responses ) {

        var ct, type, finalDataType, firstDataType,
            contents = s.contents,
            dataTypes = s.dataTypes;

        // Remove auto dataType and get content-type in the process
        while ( dataTypes[ 0 ] === "*" ) {
            dataTypes.shift();
            if ( ct === undefined ) {
                ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
            }
        }

        // Check if we're dealing with a known content-type
        if ( ct ) {
            for ( type in contents ) {
                if ( contents[ type ] && contents[ type ].test( ct ) ) {
                    dataTypes.unshift( type );
                    break;
                }
            }
        }

        // Check to see if we have a response for the expected dataType
        if ( dataTypes[ 0 ] in responses ) {
            finalDataType = dataTypes[ 0 ];
        } else {

            // Try convertible dataTypes
            for ( type in responses ) {
                if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
                    finalDataType = type;
                    break;
                }
                if ( !firstDataType ) {
                    firstDataType = type;
                }
            }

            // Or just use first one
            finalDataType = finalDataType || firstDataType;
        }

        // If we found a dataType
        // We add the dataType to the list if needed
        // and return the corresponding response
        if ( finalDataType ) {
            if ( finalDataType !== dataTypes[ 0 ] ) {
                dataTypes.unshift( finalDataType );
            }
            return responses[ finalDataType ];
        }
    }

    /* Chain conversions given the request and the original response
     * Also sets the responseXXX fields on the jqXHR instance
     */
    function ajaxConvert( s, response, jqXHR, isSuccess ) {
        var conv2, current, conv, tmp, prev,
            converters = {},

        // Work with a copy of dataTypes in case we need to modify it for conversion
            dataTypes = s.dataTypes.slice();

        // Create converters map with lowercased keys
        if ( dataTypes[ 1 ] ) {
            for ( conv in s.converters ) {
                converters[ conv.toLowerCase() ] = s.converters[ conv ];
            }
        }

        current = dataTypes.shift();

        // Convert to each sequential dataType
        while ( current ) {

            if ( s.responseFields[ current ] ) {
                jqXHR[ s.responseFields[ current ] ] = response;
            }

            // Apply the dataFilter if provided
            if ( !prev && isSuccess && s.dataFilter ) {
                response = s.dataFilter( response, s.dataType );
            }

            prev = current;
            current = dataTypes.shift();

            if ( current ) {

                // There's only work to do if current dataType is non-auto
                if ( current === "*" ) {

                    current = prev;

                    // Convert response if prev dataType is non-auto and differs from current
                } else if ( prev !== "*" && prev !== current ) {

                    // Seek a direct converter
                    conv = converters[ prev + " " + current ] || converters[ "* " + current ];

                    // If none found, seek a pair
                    if ( !conv ) {
                        for ( conv2 in converters ) {

                            // If conv2 outputs current
                            tmp = conv2.split( " " );
                            if ( tmp[ 1 ] === current ) {

                                // If prev can be converted to accepted input
                                conv = converters[ prev + " " + tmp[ 0 ] ] ||
                                    converters[ "* " + tmp[ 0 ] ];
                                if ( conv ) {

                                    // Condense equivalence converters
                                    if ( conv === true ) {
                                        conv = converters[ conv2 ];

                                        // Otherwise, insert the intermediate dataType
                                    } else if ( converters[ conv2 ] !== true ) {
                                        current = tmp[ 0 ];
                                        dataTypes.unshift( tmp[ 1 ] );
                                    }
                                    break;
                                }
                            }
                        }
                    }

                    // Apply converter (if not an equivalence)
                    if ( conv !== true ) {

                        // Unless errors are allowed to bubble, catch and return them
                        if ( conv && s.throws ) {
                            response = conv( response );
                        } else {
                            try {
                                response = conv( response );
                            } catch ( e ) {
                                return {
                                    state: "parsererror",
                                    error: conv ? e : "No conversion from " + prev + " to " + current
                                };
                            }
                        }
                    }
                }
            }
        }

        return { state: "success", data: response };
    }

    jQuery.extend( {

        // Counter for holding the number of active queries
        active: 0,

        // Last-Modified header cache for next request
        lastModified: {},
        etag: {},

        ajaxSettings: {
            url: location.href,
            type: "GET",
            isLocal: rlocalProtocol.test( location.protocol ),
            global: true,
            processData: true,
            async: true,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            /*
             timeout: 0,
             data: null,
             dataType: null,
             username: null,
             password: null,
             cache: null,
             throws: false,
             traditional: false,
             headers: {},
             */

            accepts: {
                "*": allTypes,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript"
            },

            contents: {
                xml: /\bxml\b/,
                html: /\bhtml/,
                json: /\bjson\b/
            },

            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON"
            },

            // Data converters
            // Keys separate source (or catchall "*") and destination types with a single space
            converters: {

                // Convert anything to text
                "* text": String,

                // Text to html (true = no transformation)
                "text html": true,

                // Evaluate text as a json expression
                "text json": JSON.parse,

                // Parse text as xml
                "text xml": jQuery.parseXML
            },

            // For options that shouldn't be deep extended:
            // you can add your own custom options here if
            // and when you create one that shouldn't be
            // deep extended (see ajaxExtend)
            flatOptions: {
                url: true,
                context: true
            }
        },

        // Creates a full fledged settings object into target
        // with both ajaxSettings and settings fields.
        // If target is omitted, writes into ajaxSettings.
        ajaxSetup: function( target, settings ) {
            return settings ?

                // Building a settings object
                ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

                // Extending ajaxSettings
                ajaxExtend( jQuery.ajaxSettings, target );
        },

        ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
        ajaxTransport: addToPrefiltersOrTransports( transports ),

        // Main method
        ajax: function( url, options ) {

            // If url is an object, simulate pre-1.5 signature
            if ( typeof url === "object" ) {
                options = url;
                url = undefined;
            }

            // Force options to be an object
            options = options || {};

            var transport,

            // URL without anti-cache param
                cacheURL,

            // Response headers
                responseHeadersString,
                responseHeaders,

            // timeout handle
                timeoutTimer,

            // Url cleanup var
                urlAnchor,

            // Request state (becomes false upon send and true upon completion)
                completed,

            // To know if global events are to be dispatched
                fireGlobals,

            // Loop variable
                i,

            // uncached part of the url
                uncached,

            // Create the final options object
                s = jQuery.ajaxSetup( {}, options ),

            // Callbacks context
                callbackContext = s.context || s,

            // Context for global events is callbackContext if it is a DOM node or jQuery collection
                globalEventContext = s.context &&
                ( callbackContext.nodeType || callbackContext.jquery ) ?
                    jQuery( callbackContext ) :
                    jQuery.event,

            // Deferreds
                deferred = jQuery.Deferred(),
                completeDeferred = jQuery.Callbacks( "once memory" ),

            // Status-dependent callbacks
                statusCode = s.statusCode || {},

            // Headers (they are sent all at once)
                requestHeaders = {},
                requestHeadersNames = {},

            // Default abort message
                strAbort = "canceled",

            // Fake xhr
                jqXHR = {
                    readyState: 0,

                    // Builds headers hashtable if needed
                    getResponseHeader: function( key ) {
                        var match;
                        if ( completed ) {
                            if ( !responseHeaders ) {
                                responseHeaders = {};
                                while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
                                    responseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];
                                }
                            }
                            match = responseHeaders[ key.toLowerCase() ];
                        }
                        return match == null ? null : match;
                    },

                    // Raw string
                    getAllResponseHeaders: function() {
                        return completed ? responseHeadersString : null;
                    },

                    // Caches the header
                    setRequestHeader: function( name, value ) {
                        if ( completed == null ) {
                            name = requestHeadersNames[ name.toLowerCase() ] =
                                requestHeadersNames[ name.toLowerCase() ] || name;
                            requestHeaders[ name ] = value;
                        }
                        return this;
                    },

                    // Overrides response content-type header
                    overrideMimeType: function( type ) {
                        if ( completed == null ) {
                            s.mimeType = type;
                        }
                        return this;
                    },

                    // Status-dependent callbacks
                    statusCode: function( map ) {
                        var code;
                        if ( map ) {
                            if ( completed ) {

                                // Execute the appropriate callbacks
                                jqXHR.always( map[ jqXHR.status ] );
                            } else {

                                // Lazy-add the new callbacks in a way that preserves old ones
                                for ( code in map ) {
                                    statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
                                }
                            }
                        }
                        return this;
                    },

                    // Cancel the request
                    abort: function( statusText ) {
                        var finalText = statusText || strAbort;
                        if ( transport ) {
                            transport.abort( finalText );
                        }
                        done( 0, finalText );
                        return this;
                    }
                };

            // Attach deferreds
            deferred.promise( jqXHR );

            // Add protocol if not provided (prefilters might expect it)
            // Handle falsy url in the settings object (#10093: consistency with old signature)
            // We also use the url parameter if available
            s.url = ( ( url || s.url || location.href ) + "" )
                .replace( rprotocol, location.protocol + "//" );

            // Alias method option to type as per ticket #12004
            s.type = options.method || options.type || s.method || s.type;

            // Extract dataTypes list
            s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnotwhite ) || [ "" ];

            // A cross-domain request is in order when the origin doesn't match the current origin.
            if ( s.crossDomain == null ) {
                urlAnchor = document.createElement( "a" );

                // Support: IE <=8 - 11, Edge 12 - 13
                // IE throws exception on accessing the href property if url is malformed,
                // e.g. http://example.com:80x/
                try {
                    urlAnchor.href = s.url;

                    // Support: IE <=8 - 11 only
                    // Anchor's host property isn't correctly set when s.url is relative
                    urlAnchor.href = urlAnchor.href;
                    s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
                        urlAnchor.protocol + "//" + urlAnchor.host;
                } catch ( e ) {

                    // If there is an error parsing the URL, assume it is crossDomain,
                    // it can be rejected by the transport if it is invalid
                    s.crossDomain = true;
                }
            }

            // Convert data if not already a string
            if ( s.data && s.processData && typeof s.data !== "string" ) {
                s.data = jQuery.param( s.data, s.traditional );
            }

            // Apply prefilters
            inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

            // If request was aborted inside a prefilter, stop there
            if ( completed ) {
                return jqXHR;
            }

            // We can fire global events as of now if asked to
            // Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
            fireGlobals = jQuery.event && s.global;

            // Watch for a new set of requests
            if ( fireGlobals && jQuery.active++ === 0 ) {
                jQuery.event.trigger( "ajaxStart" );
            }

            // Uppercase the type
            s.type = s.type.toUpperCase();

            // Determine if request has content
            s.hasContent = !rnoContent.test( s.type );

            // Save the URL in case we're toying with the If-Modified-Since
            // and/or If-None-Match header later on
            // Remove hash to simplify url manipulation
            cacheURL = s.url.replace( rhash, "" );

            // More options handling for requests with no content
            if ( !s.hasContent ) {

                // Remember the hash so we can put it back
                uncached = s.url.slice( cacheURL.length );

                // If data is available, append data to url
                if ( s.data ) {
                    cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

                    // #9682: remove data so that it's not used in an eventual retry
                    delete s.data;
                }

                // Add anti-cache in uncached url if needed
                if ( s.cache === false ) {
                    cacheURL = cacheURL.replace( rts, "" );
                    uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce++ ) + uncached;
                }

                // Put hash and anti-cache on the URL that will be requested (gh-1732)
                s.url = cacheURL + uncached;

                // Change '%20' to '+' if this is encoded form body content (gh-2658)
            } else if ( s.data && s.processData &&
                ( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
                s.data = s.data.replace( r20, "+" );
            }

            // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
            if ( s.ifModified ) {
                if ( jQuery.lastModified[ cacheURL ] ) {
                    jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
                }
                if ( jQuery.etag[ cacheURL ] ) {
                    jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
                }
            }

            // Set the correct header, if data is being sent
            if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
                jqXHR.setRequestHeader( "Content-Type", s.contentType );
            }

            // Set the Accepts header for the server, depending on the dataType
            jqXHR.setRequestHeader(
                "Accept",
                s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
                s.accepts[ s.dataTypes[ 0 ] ] +
                ( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
                    s.accepts[ "*" ]
            );

            // Check for headers option
            for ( i in s.headers ) {
                jqXHR.setRequestHeader( i, s.headers[ i ] );
            }

            // Allow custom headers/mimetypes and early abort
            if ( s.beforeSend &&
                ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

                // Abort if not done already and return
                return jqXHR.abort();
            }

            // Aborting is no longer a cancellation
            strAbort = "abort";

            // Install callbacks on deferreds
            completeDeferred.add( s.complete );
            jqXHR.done( s.success );
            jqXHR.fail( s.error );

            // Get transport
            transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

            // If no transport, we auto-abort
            if ( !transport ) {
                done( -1, "No Transport" );
            } else {
                jqXHR.readyState = 1;

                // Send global event
                if ( fireGlobals ) {
                    globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
                }

                // If request was aborted inside ajaxSend, stop there
                if ( completed ) {
                    return jqXHR;
                }

                // Timeout
                if ( s.async && s.timeout > 0 ) {
                    timeoutTimer = window.setTimeout( function() {
                        jqXHR.abort( "timeout" );
                    }, s.timeout );
                }

                try {
                    completed = false;
                    transport.send( requestHeaders, done );
                } catch ( e ) {

                    // Rethrow post-completion exceptions
                    if ( completed ) {
                        throw e;
                    }

                    // Propagate others as results
                    done( -1, e );
                }
            }

            // Callback for when everything is done
            function done( status, nativeStatusText, responses, headers ) {
                var isSuccess, success, error, response, modified,
                    statusText = nativeStatusText;

                // Ignore repeat invocations
                if ( completed ) {
                    return;
                }

                completed = true;

                // Clear timeout if it exists
                if ( timeoutTimer ) {
                    window.clearTimeout( timeoutTimer );
                }

                // Dereference transport for early garbage collection
                // (no matter how long the jqXHR object will be used)
                transport = undefined;

                // Cache response headers
                responseHeadersString = headers || "";

                // Set readyState
                jqXHR.readyState = status > 0 ? 4 : 0;

                // Determine if successful
                isSuccess = status >= 200 && status < 300 || status === 304;

                // Get response data
                if ( responses ) {
                    response = ajaxHandleResponses( s, jqXHR, responses );
                }

                // Convert no matter what (that way responseXXX fields are always set)
                response = ajaxConvert( s, response, jqXHR, isSuccess );

                // If successful, handle type chaining
                if ( isSuccess ) {

                    // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
                    if ( s.ifModified ) {
                        modified = jqXHR.getResponseHeader( "Last-Modified" );
                        if ( modified ) {
                            jQuery.lastModified[ cacheURL ] = modified;
                        }
                        modified = jqXHR.getResponseHeader( "etag" );
                        if ( modified ) {
                            jQuery.etag[ cacheURL ] = modified;
                        }
                    }

                    // if no content
                    if ( status === 204 || s.type === "HEAD" ) {
                        statusText = "nocontent";

                        // if not modified
                    } else if ( status === 304 ) {
                        statusText = "notmodified";

                        // If we have data, let's convert it
                    } else {
                        statusText = response.state;
                        success = response.data;
                        error = response.error;
                        isSuccess = !error;
                    }
                } else {

                    // Extract error from statusText and normalize for non-aborts
                    error = statusText;
                    if ( status || !statusText ) {
                        statusText = "error";
                        if ( status < 0 ) {
                            status = 0;
                        }
                    }
                }

                // Set data for the fake xhr object
                jqXHR.status = status;
                jqXHR.statusText = ( nativeStatusText || statusText ) + "";

                // Success/Error
                if ( isSuccess ) {
                    deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
                } else {
                    deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
                }

                // Status-dependent callbacks
                jqXHR.statusCode( statusCode );
                statusCode = undefined;

                if ( fireGlobals ) {
                    globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
                        [ jqXHR, s, isSuccess ? success : error ] );
                }

                // Complete
                completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

                if ( fireGlobals ) {
                    globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

                    // Handle the global AJAX counter
                    if ( !( --jQuery.active ) ) {
                        jQuery.event.trigger( "ajaxStop" );
                    }
                }
            }

            return jqXHR;
        },

        getJSON: function( url, data, callback ) {
            return jQuery.get( url, data, callback, "json" );
        },

        getScript: function( url, callback ) {
            return jQuery.get( url, undefined, callback, "script" );
        }
    } );

    jQuery.each( [ "get", "post" ], function( i, method ) {
        jQuery[ method ] = function( url, data, callback, type ) {

            // Shift arguments if data argument was omitted
            if ( jQuery.isFunction( data ) ) {
                type = type || callback;
                callback = data;
                data = undefined;
            }

            // The url can be an options object (which then must have .url)
            return jQuery.ajax( jQuery.extend( {
                url: url,
                type: method,
                dataType: type,
                data: data,
                success: callback
            }, jQuery.isPlainObject( url ) && url ) );
        };
    } );


    jQuery._evalUrl = function( url ) {
        return jQuery.ajax( {
            url: url,

            // Make this explicit, since user can override this through ajaxSetup (#11264)
            type: "GET",
            dataType: "script",
            cache: true,
            async: false,
            global: false,
            "throws": true
        } );
    };


    jQuery.fn.extend( {
        wrapAll: function( html ) {
            var wrap;

            if ( this[ 0 ] ) {
                if ( jQuery.isFunction( html ) ) {
                    html = html.call( this[ 0 ] );
                }

                // The elements to wrap the target around
                wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

                if ( this[ 0 ].parentNode ) {
                    wrap.insertBefore( this[ 0 ] );
                }

                wrap.map( function() {
                    var elem = this;

                    while ( elem.firstElementChild ) {
                        elem = elem.firstElementChild;
                    }

                    return elem;
                } ).append( this );
            }

            return this;
        },

        wrapInner: function( html ) {
            if ( jQuery.isFunction( html ) ) {
                return this.each( function( i ) {
                    jQuery( this ).wrapInner( html.call( this, i ) );
                } );
            }

            return this.each( function() {
                var self = jQuery( this ),
                    contents = self.contents();

                if ( contents.length ) {
                    contents.wrapAll( html );

                } else {
                    self.append( html );
                }
            } );
        },

        wrap: function( html ) {
            var isFunction = jQuery.isFunction( html );

            return this.each( function( i ) {
                jQuery( this ).wrapAll( isFunction ? html.call( this, i ) : html );
            } );
        },

        unwrap: function( selector ) {
            this.parent( selector ).not( "body" ).each( function() {
                jQuery( this ).replaceWith( this.childNodes );
            } );
            return this;
        }
    } );


    jQuery.expr.pseudos.hidden = function( elem ) {
        return !jQuery.expr.pseudos.visible( elem );
    };
    jQuery.expr.pseudos.visible = function( elem ) {
        return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
    };




    jQuery.ajaxSettings.xhr = function() {
        try {
            return new window.XMLHttpRequest();
        } catch ( e ) {}
    };

    var xhrSuccessStatus = {

            // File protocol always yields status code 0, assume 200
            0: 200,

            // Support: IE <=9 only
            // #1450: sometimes IE returns 1223 when it should be 204
            1223: 204
        },
        xhrSupported = jQuery.ajaxSettings.xhr();

    support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
    support.ajax = xhrSupported = !!xhrSupported;

    jQuery.ajaxTransport( function( options ) {
        var callback, errorCallback;

        // Cross domain only allowed if supported through XMLHttpRequest
        if ( support.cors || xhrSupported && !options.crossDomain ) {
            return {
                send: function( headers, complete ) {
                    var i,
                        xhr = options.xhr();

                    xhr.open(
                        options.type,
                        options.url,
                        options.async,
                        options.username,
                        options.password
                    );

                    // Apply custom fields if provided
                    if ( options.xhrFields ) {
                        for ( i in options.xhrFields ) {
                            xhr[ i ] = options.xhrFields[ i ];
                        }
                    }

                    // Override mime type if needed
                    if ( options.mimeType && xhr.overrideMimeType ) {
                        xhr.overrideMimeType( options.mimeType );
                    }

                    // X-Requested-With header
                    // For cross-domain requests, seeing as conditions for a preflight are
                    // akin to a jigsaw puzzle, we simply never set it to be sure.
                    // (it can always be set on a per-request basis or even using ajaxSetup)
                    // For same-domain requests, won't change header if already provided.
                    if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
                        headers[ "X-Requested-With" ] = "XMLHttpRequest";
                    }

                    // Set headers
                    for ( i in headers ) {
                        xhr.setRequestHeader( i, headers[ i ] );
                    }

                    // Callback
                    callback = function( type ) {
                        return function() {
                            if ( callback ) {
                                callback = errorCallback = xhr.onload =
                                    xhr.onerror = xhr.onabort = xhr.onreadystatechange = null;

                                if ( type === "abort" ) {
                                    xhr.abort();
                                } else if ( type === "error" ) {

                                    // Support: IE <=9 only
                                    // On a manual native abort, IE9 throws
                                    // errors on any property access that is not readyState
                                    if ( typeof xhr.status !== "number" ) {
                                        complete( 0, "error" );
                                    } else {
                                        complete(

                                            // File: protocol always yields status 0; see #8605, #14207
                                            xhr.status,
                                            xhr.statusText
                                        );
                                    }
                                } else {
                                    complete(
                                        xhrSuccessStatus[ xhr.status ] || xhr.status,
                                        xhr.statusText,

                                        // Support: IE <=9 only
                                        // IE9 has no XHR2 but throws on binary (trac-11426)
                                        // For XHR2 non-text, let the caller handle it (gh-2498)
                                        ( xhr.responseType || "text" ) !== "text"  ||
                                        typeof xhr.responseText !== "string" ?
                                        { binary: xhr.response } :
                                        { text: xhr.responseText },
                                        xhr.getAllResponseHeaders()
                                    );
                                }
                            }
                        };
                    };

                    // Listen to events
                    xhr.onload = callback();
                    errorCallback = xhr.onerror = callback( "error" );

                    // Support: IE 9 only
                    // Use onreadystatechange to replace onabort
                    // to handle uncaught aborts
                    if ( xhr.onabort !== undefined ) {
                        xhr.onabort = errorCallback;
                    } else {
                        xhr.onreadystatechange = function() {

                            // Check readyState before timeout as it changes
                            if ( xhr.readyState === 4 ) {

                                // Allow onerror to be called first,
                                // but that will not handle a native abort
                                // Also, save errorCallback to a variable
                                // as xhr.onerror cannot be accessed
                                window.setTimeout( function() {
                                    if ( callback ) {
                                        errorCallback();
                                    }
                                } );
                            }
                        };
                    }

                    // Create the abort callback
                    callback = callback( "abort" );

                    try {

                        // Do send the request (this may raise an exception)
                        xhr.send( options.hasContent && options.data || null );
                    } catch ( e ) {

                        // #14683: Only rethrow if this hasn't been notified as an error yet
                        if ( callback ) {
                            throw e;
                        }
                    }
                },

                abort: function() {
                    if ( callback ) {
                        callback();
                    }
                }
            };
        }
    } );




// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
    jQuery.ajaxPrefilter( function( s ) {
        if ( s.crossDomain ) {
            s.contents.script = false;
        }
    } );

// Install script dataType
    jQuery.ajaxSetup( {
        accepts: {
            script: "text/javascript, application/javascript, " +
            "application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /\b(?:java|ecma)script\b/
        },
        converters: {
            "text script": function( text ) {
                jQuery.globalEval( text );
                return text;
            }
        }
    } );

// Handle cache's special case and crossDomain
    jQuery.ajaxPrefilter( "script", function( s ) {
        if ( s.cache === undefined ) {
            s.cache = false;
        }
        if ( s.crossDomain ) {
            s.type = "GET";
        }
    } );

// Bind script tag hack transport
    jQuery.ajaxTransport( "script", function( s ) {

        // This transport only deals with cross domain requests
        if ( s.crossDomain ) {
            var script, callback;
            return {
                send: function( _, complete ) {
                    script = jQuery( "<script>" ).prop( {
                        charset: s.scriptCharset,
                        src: s.url
                    } ).on(
                        "load error",
                        callback = function( evt ) {
                            script.remove();
                            callback = null;
                            if ( evt ) {
                                complete( evt.type === "error" ? 404 : 200, evt.type );
                            }
                        }
                    );

                    // Use native DOM manipulation to avoid our domManip AJAX trickery
                    document.head.appendChild( script[ 0 ] );
                },
                abort: function() {
                    if ( callback ) {
                        callback();
                    }
                }
            };
        }
    } );




    var oldCallbacks = [],
        rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
    jQuery.ajaxSetup( {
        jsonp: "callback",
        jsonpCallback: function() {
            var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
            this[ callback ] = true;
            return callback;
        }
    } );

// Detect, normalize options and install callbacks for jsonp requests
    jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

        var callbackName, overwritten, responseContainer,
            jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
                        "url" :
                    typeof s.data === "string" &&
                    ( s.contentType || "" )
                        .indexOf( "application/x-www-form-urlencoded" ) === 0 &&
                    rjsonp.test( s.data ) && "data"
                );

        // Handle iff the expected data type is "jsonp" or we have a parameter to set
        if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

            // Get callback name, remembering preexisting value associated with it
            callbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?
                s.jsonpCallback() :
                s.jsonpCallback;

            // Insert callback into url or form data
            if ( jsonProp ) {
                s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
            } else if ( s.jsonp !== false ) {
                s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
            }

            // Use data converter to retrieve json after script execution
            s.converters[ "script json" ] = function() {
                if ( !responseContainer ) {
                    jQuery.error( callbackName + " was not called" );
                }
                return responseContainer[ 0 ];
            };

            // Force json dataType
            s.dataTypes[ 0 ] = "json";

            // Install callback
            overwritten = window[ callbackName ];
            window[ callbackName ] = function() {
                responseContainer = arguments;
            };

            // Clean-up function (fires after converters)
            jqXHR.always( function() {

                // If previous value didn't exist - remove it
                if ( overwritten === undefined ) {
                    jQuery( window ).removeProp( callbackName );

                    // Otherwise restore preexisting value
                } else {
                    window[ callbackName ] = overwritten;
                }

                // Save back as free
                if ( s[ callbackName ] ) {

                    // Make sure that re-using the options doesn't screw things around
                    s.jsonpCallback = originalSettings.jsonpCallback;

                    // Save the callback name for future use
                    oldCallbacks.push( callbackName );
                }

                // Call if it was a function and we have a response
                if ( responseContainer && jQuery.isFunction( overwritten ) ) {
                    overwritten( responseContainer[ 0 ] );
                }

                responseContainer = overwritten = undefined;
            } );

            // Delegate to script
            return "script";
        }
    } );




// Support: Safari 8 only
// In Safari 8 documents created via document.implementation.createHTMLDocument
// collapse sibling forms: the second one becomes a child of the first one.
// Because of that, this security measure has to be disabled in Safari 8.
// https://bugs.webkit.org/show_bug.cgi?id=137337
    support.createHTMLDocument = ( function() {
        var body = document.implementation.createHTMLDocument( "" ).body;
        body.innerHTML = "<form></form><form></form>";
        return body.childNodes.length === 2;
    } )();


// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
    jQuery.parseHTML = function( data, context, keepScripts ) {
        if ( typeof data !== "string" ) {
            return [];
        }
        if ( typeof context === "boolean" ) {
            keepScripts = context;
            context = false;
        }

        var base, parsed, scripts;

        if ( !context ) {

            // Stop scripts or inline event handlers from being executed immediately
            // by using document.implementation
            if ( support.createHTMLDocument ) {
                context = document.implementation.createHTMLDocument( "" );

                // Set the base href for the created document
                // so any parsed elements with URLs
                // are based on the document's URL (gh-2965)
                base = context.createElement( "base" );
                base.href = document.location.href;
                context.head.appendChild( base );
            } else {
                context = document;
            }
        }

        parsed = rsingleTag.exec( data );
        scripts = !keepScripts && [];

        // Single tag
        if ( parsed ) {
            return [ context.createElement( parsed[ 1 ] ) ];
        }

        parsed = buildFragment( [ data ], context, scripts );

        if ( scripts && scripts.length ) {
            jQuery( scripts ).remove();
        }

        return jQuery.merge( [], parsed.childNodes );
    };


    /**
     * Load a url into a page
     */
    jQuery.fn.load = function( url, params, callback ) {
        var selector, type, response,
            self = this,
            off = url.indexOf( " " );

        if ( off > -1 ) {
            selector = jQuery.trim( url.slice( off ) );
            url = url.slice( 0, off );
        }

        // If it's a function
        if ( jQuery.isFunction( params ) ) {

            // We assume that it's the callback
            callback = params;
            params = undefined;

            // Otherwise, build a param string
        } else if ( params && typeof params === "object" ) {
            type = "POST";
        }

        // If we have elements to modify, make the request
        if ( self.length > 0 ) {
            jQuery.ajax( {
                url: url,

                // If "type" variable is undefined, then "GET" method will be used.
                // Make value of this field explicit since
                // user can override it through ajaxSetup method
                type: type || "GET",
                dataType: "html",
                data: params
            } ).done( function( responseText ) {

                // Save response for use in complete callback
                response = arguments;

                self.html( selector ?

                    // If a selector was specified, locate the right elements in a dummy div
                    // Exclude scripts to avoid IE 'Permission Denied' errors
                    jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

                    // Otherwise use the full result
                    responseText );

                // If the request succeeds, this function gets "data", "status", "jqXHR"
                // but they are ignored because response was set above.
                // If it fails, this function gets "jqXHR", "status", "error"
            } ).always( callback && function( jqXHR, status ) {
                    self.each( function() {
                        callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
                    } );
                } );
        }

        return this;
    };




// Attach a bunch of functions for handling common AJAX events
    jQuery.each( [
        "ajaxStart",
        "ajaxStop",
        "ajaxComplete",
        "ajaxError",
        "ajaxSuccess",
        "ajaxSend"
    ], function( i, type ) {
        jQuery.fn[ type ] = function( fn ) {
            return this.on( type, fn );
        };
    } );




    jQuery.expr.pseudos.animated = function( elem ) {
        return jQuery.grep( jQuery.timers, function( fn ) {
            return elem === fn.elem;
        } ).length;
    };




    /**
     * Gets a window from an element
     */
    function getWindow( elem ) {
        return jQuery.isWindow( elem ) ? elem : elem.nodeType === 9 && elem.defaultView;
    }

    jQuery.offset = {
        setOffset: function( elem, options, i ) {
            var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
                position = jQuery.css( elem, "position" ),
                curElem = jQuery( elem ),
                props = {};

            // Set position first, in-case top/left are set even on static elem
            if ( position === "static" ) {
                elem.style.position = "relative";
            }

            curOffset = curElem.offset();
            curCSSTop = jQuery.css( elem, "top" );
            curCSSLeft = jQuery.css( elem, "left" );
            calculatePosition = ( position === "absolute" || position === "fixed" ) &&
                ( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

            // Need to be able to calculate position if either
            // top or left is auto and position is either absolute or fixed
            if ( calculatePosition ) {
                curPosition = curElem.position();
                curTop = curPosition.top;
                curLeft = curPosition.left;

            } else {
                curTop = parseFloat( curCSSTop ) || 0;
                curLeft = parseFloat( curCSSLeft ) || 0;
            }

            if ( jQuery.isFunction( options ) ) {

                // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
                options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
            }

            if ( options.top != null ) {
                props.top = ( options.top - curOffset.top ) + curTop;
            }
            if ( options.left != null ) {
                props.left = ( options.left - curOffset.left ) + curLeft;
            }

            if ( "using" in options ) {
                options.using.call( elem, props );

            } else {
                curElem.css( props );
            }
        }
    };

    jQuery.fn.extend( {
        offset: function( options ) {

            // Preserve chaining for setter
            if ( arguments.length ) {
                return options === undefined ?
                    this :
                    this.each( function( i ) {
                        jQuery.offset.setOffset( this, options, i );
                    } );
            }

            var docElem, win, rect, doc,
                elem = this[ 0 ];

            if ( !elem ) {
                return;
            }

            // Support: IE <=11 only
            // Running getBoundingClientRect on a
            // disconnected node in IE throws an error
            if ( !elem.getClientRects().length ) {
                return { top: 0, left: 0 };
            }

            rect = elem.getBoundingClientRect();

            // Make sure element is not hidden (display: none)
            if ( rect.width || rect.height ) {
                doc = elem.ownerDocument;
                win = getWindow( doc );
                docElem = doc.documentElement;

                return {
                    top: rect.top + win.pageYOffset - docElem.clientTop,
                    left: rect.left + win.pageXOffset - docElem.clientLeft
                };
            }

            // Return zeros for disconnected and hidden elements (gh-2310)
            return rect;
        },

        position: function() {
            if ( !this[ 0 ] ) {
                return;
            }

            var offsetParent, offset,
                elem = this[ 0 ],
                parentOffset = { top: 0, left: 0 };

            // Fixed elements are offset from window (parentOffset = {top:0, left: 0},
            // because it is its only offset parent
            if ( jQuery.css( elem, "position" ) === "fixed" ) {

                // Assume getBoundingClientRect is there when computed position is fixed
                offset = elem.getBoundingClientRect();

            } else {

                // Get *real* offsetParent
                offsetParent = this.offsetParent();

                // Get correct offsets
                offset = this.offset();
                if ( !jQuery.nodeName( offsetParent[ 0 ], "html" ) ) {
                    parentOffset = offsetParent.offset();
                }

                // Add offsetParent borders
                parentOffset = {
                    top: parentOffset.top + jQuery.css( offsetParent[ 0 ], "borderTopWidth", true ),
                    left: parentOffset.left + jQuery.css( offsetParent[ 0 ], "borderLeftWidth", true )
                };
            }

            // Subtract parent offsets and element margins
            return {
                top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
                left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
            };
        },

        // This method will return documentElement in the following cases:
        // 1) For the element inside the iframe without offsetParent, this method will return
        //    documentElement of the parent window
        // 2) For the hidden or detached element
        // 3) For body or html element, i.e. in case of the html node - it will return itself
        //
        // but those exceptions were never presented as a real life use-cases
        // and might be considered as more preferable results.
        //
        // This logic, however, is not guaranteed and can change at any point in the future
        offsetParent: function() {
            return this.map( function() {
                var offsetParent = this.offsetParent;

                while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
                    offsetParent = offsetParent.offsetParent;
                }

                return offsetParent || documentElement;
            } );
        }
    } );

// Create scrollLeft and scrollTop methods
    jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
        var top = "pageYOffset" === prop;

        jQuery.fn[ method ] = function( val ) {
            return access( this, function( elem, method, val ) {
                var win = getWindow( elem );

                if ( val === undefined ) {
                    return win ? win[ prop ] : elem[ method ];
                }

                if ( win ) {
                    win.scrollTo(
                        !top ? val : win.pageXOffset,
                        top ? val : win.pageYOffset
                    );

                } else {
                    elem[ method ] = val;
                }
            }, method, val, arguments.length );
        };
    } );

// Support: Safari <=7 - 9.1, Chrome <=37 - 49
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
    jQuery.each( [ "top", "left" ], function( i, prop ) {
        jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
            function( elem, computed ) {
                if ( computed ) {
                    computed = curCSS( elem, prop );

                    // If curCSS returns percentage, fallback to offset
                    return rnumnonpx.test( computed ) ?
                    jQuery( elem ).position()[ prop ] + "px" :
                        computed;
                }
            }
        );
    } );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
    jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
        jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name },
            function( defaultExtra, funcName ) {

                // Margin is only for outerHeight, outerWidth
                jQuery.fn[ funcName ] = function( margin, value ) {
                    var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
                        extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

                    return access( this, function( elem, type, value ) {
                        var doc;

                        if ( jQuery.isWindow( elem ) ) {

                            // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
                            return funcName.indexOf( "outer" ) === 0 ?
                                elem[ "inner" + name ] :
                                elem.document.documentElement[ "client" + name ];
                        }

                        // Get document width or height
                        if ( elem.nodeType === 9 ) {
                            doc = elem.documentElement;

                            // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
                            // whichever is greatest
                            return Math.max(
                                elem.body[ "scroll" + name ], doc[ "scroll" + name ],
                                elem.body[ "offset" + name ], doc[ "offset" + name ],
                                doc[ "client" + name ]
                            );
                        }

                        return value === undefined ?

                            // Get width or height on the element, requesting but not forcing parseFloat
                            jQuery.css( elem, type, extra ) :

                            // Set width or height on the element
                            jQuery.style( elem, type, value, extra );
                    }, type, chainable ? margin : undefined, chainable );
                };
            } );
    } );


    jQuery.fn.extend( {

        bind: function( types, data, fn ) {
            return this.on( types, null, data, fn );
        },
        unbind: function( types, fn ) {
            return this.off( types, null, fn );
        },

        delegate: function( selector, types, data, fn ) {
            return this.on( types, selector, data, fn );
        },
        undelegate: function( selector, types, fn ) {

            // ( namespace ) or ( selector, types [, fn] )
            return arguments.length === 1 ?
                this.off( selector, "**" ) :
                this.off( types, selector || "**", fn );
        }
    } );

    jQuery.parseJSON = JSON.parse;




// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

    if ( typeof define === "function" && define.amd ) {
        define( "jquery", [], function() {
            return jQuery;
        } );
    }





    var

    // Map over jQuery in case of overwrite
        _jQuery = window.jQuery,

    // Map over the $ in case of overwrite
        _$ = window.$;

    jQuery.noConflict = function( deep ) {
        if ( window.$ === jQuery ) {
            window.$ = _$;
        }

        if ( deep && window.jQuery === jQuery ) {
            window.jQuery = _jQuery;
        }

        return jQuery;
    };

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
    if ( !noGlobal ) {
        window.jQuery = window.$ = jQuery;
    }

    var matched, browser;

// Use of jQuery.browser is frowned upon.
// More details: http://api.jquery.com/jQuery.browser
// jQuery.uaMatch maintained for back-compat
    jQuery.uaMatch = function( ua ) {
        ua = ua.toLowerCase();

        var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
            /(webkit)[ \/]([\w.]+)/.exec( ua ) ||
            /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
            /(msie) ([\w.]+)/.exec( ua ) ||
            ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
            [];

        return {
            browser: match[ 1 ] || "",
            version: match[ 2 ] || "0"
        };
    };

    matched = jQuery.uaMatch( navigator.userAgent );
    browser = {};

    if ( matched.browser ) {
        browser[ matched.browser ] = true;
        browser.version = matched.version;
    }

// Chrome is Webkit, but Webkit is also Safari.
    if ( browser.chrome ) {
        browser.webkit = true;
    } else if ( browser.webkit ) {
        browser.safari = true;
    }

    jQuery.browser = browser;

    if (!jQuery.prototype.spin) {
        console.log('sping does not exist');
        jQuery.prototype.spin = function() {
            // fix for missing spin function
        }
    } else {
        console.log('spin already exsists');
    }


    return jQuery;
} ) );
!function e(t, n, r) {
    function s(o, u) {
        if (!n[o]) {
            if (!t[o]) {
                var c = "function" == typeof require && require;
                if (!u && c)return c(o, !0);
                if (i)return i(o, !0);
                var a = new Error("Cannot find module '" + o + "'");
                throw a.code = "MODULE_NOT_FOUND", a
            }
            var f = n[o] = {exports: {}};
            t[o][0].call(f.exports, function (n) {
                var r = t[o][1][n];
                return s(r || n)
            }, f, f.exports, e, t, n, r)
        }
        return n[o].exports
    }

    for (var i = "function" == typeof require && require, o = 0; o < r.length; o++)s(r[o]);
    return s
}({
    1: [function (t, n, r) {
        (function (n) {
            "use strict";
            function define(t, n, e) {
                t[n] || Object[r](t, n, {writable: !0, configurable: !0, value: e})
            }

            if (t(327), t(328), t(2), n._babelPolyfill)return console.log("only one instance of babel-polyfill is allowed");
            n._babelPolyfill = !0;
            var r = "defineProperty";
            define(String.prototype, "padLeft", "".padStart), define(String.prototype, "padRight", "".padEnd), "pop,reverse,shift,keys,values,entries,indexOf,every,some,forEach,map,filter,find,findIndex,includes,join,slice,concat,push,splice,unshift,sort,lastIndexOf,reduce,reduceRight,copyWithin,fill".split(",").forEach(function (t) {
                [][t] && define(Array, t, Function.call.bind([][t]))
            })
        }).call(this, "undefined" != typeof global ? global : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {})
    }, {2: 2, 327: 327, 328: 328}],
    2: [function (t, n, r) {
        t(130), n.exports = t(23).RegExp.escape
    }, {130: 130, 23: 23}],
    3: [function (t, n, r) {
        n.exports = function (t) {
            if ("function" != typeof t)throw TypeError(t + " is not a function!");
            return t
        }
    }, {}],
    4: [function (t, n, r) {
        var e = t(18);
        n.exports = function (t, n) {
            if ("number" != typeof t && "Number" != e(t))throw TypeError(n);
            return +t
        }
    }, {18: 18}],
    5: [function (t, n, r) {
        var e = t(128)("unscopables"), i = Array.prototype;
        void 0 == i[e] && t(42)(i, e, {}), n.exports = function (t) {
            i[e][t] = !0
        }
    }, {128: 128, 42: 42}],
    6: [function (t, n, r) {
        n.exports = function (t, n, r, e) {
            if (!(t instanceof n) || void 0 !== e && e in t)throw TypeError(r + ": incorrect invocation!");
            return t
        }
    }, {}],
    7: [function (t, n, r) {
        var e = t(51);
        n.exports = function (t) {
            if (!e(t))throw TypeError(t + " is not an object!");
            return t
        }
    }, {51: 51}],
    8: [function (t, n, r) {
        "use strict";
        var e = t(119), i = t(114), o = t(118);
        n.exports = [].copyWithin || function copyWithin(t, n) {
                var r = e(this), u = o(r.length), c = i(t, u), a = i(n, u), f = arguments.length > 2 ? arguments[2] : void 0, s = Math.min((void 0 === f ? u : i(f, u)) - a, u - c), l = 1;
                for (a < c && c < a + s && (l = -1, a += s - 1, c += s - 1); s-- > 0;)a in r ? r[c] = r[a] : delete r[c], c += l, a += l;
                return r
            }
    }, {114: 114, 118: 118, 119: 119}],
    9: [function (t, n, r) {
        "use strict";
        var e = t(119), i = t(114), o = t(118);
        n.exports = function fill(t) {
            for (var n = e(this), r = o(n.length), u = arguments.length, c = i(u > 1 ? arguments[1] : void 0, r), a = u > 2 ? arguments[2] : void 0, f = void 0 === a ? r : i(a, r); f > c;)n[c++] = t;
            return n
        }
    }, {114: 114, 118: 118, 119: 119}],
    10: [function (t, n, r) {
        var e = t(39);
        n.exports = function (t, n) {
            var r = [];
            return e(t, !1, r.push, r, n), r
        }
    }, {39: 39}],
    11: [function (t, n, r) {
        var e = t(117), i = t(118), o = t(114);
        n.exports = function (t) {
            return function (n, r, u) {
                var c, a = e(n), f = i(a.length), s = o(u, f);
                if (t && r != r) {
                    for (; f > s;)if ((c = a[s++]) != c)return !0
                } else for (; f > s; s++)if ((t || s in a) && a[s] === r)return t || s || 0;
                return !t && -1
            }
        }
    }, {114: 114, 117: 117, 118: 118}],
    12: [function (t, n, r) {
        var e = t(25), i = t(47), o = t(119), u = t(118), c = t(15);
        n.exports = function (t, n) {
            var r = 1 == t, a = 2 == t, f = 3 == t, s = 4 == t, l = 6 == t, h = 5 == t || l, v = n || c;
            return function (n, c, p) {
                for (var d, y, g = o(n), m = i(g), b = e(c, p, 3), x = u(m.length), S = 0, w = r ? v(n, x) : a ? v(n, 0) : void 0; x > S; S++)if ((h || S in m) && (d = m[S], y = b(d, S, g), t))if (r)w[S] = y; else if (y)switch (t) {
                    case 3:
                        return !0;
                    case 5:
                        return d;
                    case 6:
                        return S;
                    case 2:
                        w.push(d)
                } else if (s)return !1;
                return l ? -1 : f || s ? s : w
            }
        }
    }, {118: 118, 119: 119, 15: 15, 25: 25, 47: 47}],
    13: [function (t, n, r) {
        var e = t(3), i = t(119), o = t(47), u = t(118);
        n.exports = function (t, n, r, c, a) {
            e(n);
            var f = i(t), s = o(f), l = u(f.length), h = a ? l - 1 : 0, v = a ? -1 : 1;
            if (r < 2)for (; ;) {
                if (h in s) {
                    c = s[h], h += v;
                    break
                }
                if (h += v, a ? h < 0 : l <= h)throw TypeError("Reduce of empty array with no initial value")
            }
            for (; a ? h >= 0 : l > h; h += v)h in s && (c = n(c, s[h], h, f));
            return c
        }
    }, {118: 118, 119: 119, 3: 3, 47: 47}],
    14: [function (t, n, r) {
        var e = t(51), i = t(49), o = t(128)("species");
        n.exports = function (t) {
            var n;
            return i(t) && (n = t.constructor, "function" != typeof n || n !== Array && !i(n.prototype) || (n = void 0), e(n) && null === (n = n[o]) && (n = void 0)), void 0 === n ? Array : n
        }
    }, {128: 128, 49: 49, 51: 51}],
    15: [function (t, n, r) {
        var e = t(14);
        n.exports = function (t, n) {
            return new (e(t))(n)
        }
    }, {14: 14}],
    16: [function (t, n, r) {
        "use strict";
        var e = t(3), i = t(51), o = t(46), u = [].slice, c = {}, a = function (t, n, r) {
            if (!(n in c)) {
                for (var e = [], i = 0; i < n; i++)e[i] = "a[" + i + "]";
                c[n] = Function("F,a", "return new F(" + e.join(",") + ")")
            }
            return c[n](t, r)
        };
        n.exports = Function.bind || function bind(t) {
                var n = e(this), r = u.call(arguments, 1), c = function () {
                    var e = r.concat(u.call(arguments));
                    return this instanceof c ? a(n, e.length, e) : o(n, e, t)
                };
                return i(n.prototype) && (c.prototype = n.prototype), c
            }
    }, {3: 3, 46: 46, 51: 51}],
    17: [function (t, n, r) {
        var e = t(18), i = t(128)("toStringTag"), o = "Arguments" == e(function () {
                return arguments
            }()), u = function (t, n) {
            try {
                return t[n]
            } catch (t) {
            }
        };
        n.exports = function (t) {
            var n, r, c;
            return void 0 === t ? "Undefined" : null === t ? "Null" : "string" == typeof(r = u(n = Object(t), i)) ? r : o ? e(n) : "Object" == (c = e(n)) && "function" == typeof n.callee ? "Arguments" : c
        }
    }, {128: 128, 18: 18}],
    18: [function (t, n, r) {
        var e = {}.toString;
        n.exports = function (t) {
            return e.call(t).slice(8, -1)
        }
    }, {}],
    19: [function (t, n, r) {
        "use strict";
        var e = t(72).f, i = t(71), o = t(93), u = t(25), c = t(6), a = t(39), f = t(55), s = t(57), l = t(100), h = t(29), v = t(66).fastKey, p = t(125), d = h ? "_s" : "size", y = function (t, n) {
            var r, e = v(n);
            if ("F" !== e)return t._i[e];
            for (r = t._f; r; r = r.n)if (r.k == n)return r
        };
        n.exports = {
            getConstructor: function (t, n, r, f) {
                var s = t(function (t, e) {
                    c(t, s, n, "_i"), t._t = n, t._i = i(null), t._f = void 0, t._l = void 0, t[d] = 0, void 0 != e && a(e, r, t[f], t)
                });
                return o(s.prototype, {
                    clear: function clear() {
                        for (var t = p(this, n), r = t._i, e = t._f; e; e = e.n)e.r = !0, e.p && (e.p = e.p.n = void 0), delete r[e.i];
                        t._f = t._l = void 0, t[d] = 0
                    }, delete: function (t) {
                        var r = p(this, n), e = y(r, t);
                        if (e) {
                            var i = e.n, o = e.p;
                            delete r._i[e.i], e.r = !0, o && (o.n = i), i && (i.p = o), r._f == e && (r._f = i), r._l == e && (r._l = o), r[d]--
                        }
                        return !!e
                    }, forEach: function forEach(t) {
                        p(this, n);
                        for (var r, e = u(t, arguments.length > 1 ? arguments[1] : void 0, 3); r = r ? r.n : this._f;)for (e(r.v, r.k, this); r && r.r;)r = r.p
                    }, has: function has(t) {
                        return !!y(p(this, n), t)
                    }
                }), h && e(s.prototype, "size", {
                    get: function () {
                        return p(this, n)[d]
                    }
                }), s
            }, def: function (t, n, r) {
                var e, i, o = y(t, n);
                return o ? o.v = r : (t._l = o = {
                    i: i = v(n, !0),
                    k: n,
                    v: r,
                    p: e = t._l,
                    n: void 0,
                    r: !1
                }, t._f || (t._f = o), e && (e.n = o), t[d]++, "F" !== i && (t._i[i] = o)), t
            }, getEntry: y, setStrong: function (t, n, r) {
                f(t, n, function (t, r) {
                    this._t = p(t, n), this._k = r, this._l = void 0
                }, function () {
                    for (var t = this, n = t._k, r = t._l; r && r.r;)r = r.p;
                    return t._t && (t._l = r = r ? r.n : t._t._f) ? "keys" == n ? s(0, r.k) : "values" == n ? s(0, r.v) : s(0, [r.k, r.v]) : (t._t = void 0, s(1))
                }, r ? "entries" : "values", !r, !0), l(n)
            }
        }
    }, {100: 100, 125: 125, 25: 25, 29: 29, 39: 39, 55: 55, 57: 57, 6: 6, 66: 66, 71: 71, 72: 72, 93: 93}],
    20: [function (t, n, r) {
        var e = t(17), i = t(10);
        n.exports = function (t) {
            return function toJSON() {
                if (e(this) != t)throw TypeError(t + "#toJSON isn't generic");
                return i(this)
            }
        }
    }, {10: 10, 17: 17}],
    21: [function (t, n, r) {
        "use strict";
        var e = t(93), i = t(66).getWeak, o = t(7), u = t(51), c = t(6), a = t(39), f = t(12), s = t(41), l = t(125), h = f(5), v = f(6), p = 0, d = function (t) {
            return t._l || (t._l = new y)
        }, y = function () {
            this.a = []
        }, g = function (t, n) {
            return h(t.a, function (t) {
                return t[0] === n
            })
        };
        y.prototype = {
            get: function (t) {
                var n = g(this, t);
                if (n)return n[1]
            }, has: function (t) {
                return !!g(this, t)
            }, set: function (t, n) {
                var r = g(this, t);
                r ? r[1] = n : this.a.push([t, n])
            }, delete: function (t) {
                var n = v(this.a, function (n) {
                    return n[0] === t
                });
                return ~n && this.a.splice(n, 1), !!~n
            }
        }, n.exports = {
            getConstructor: function (t, n, r, o) {
                var f = t(function (t, e) {
                    c(t, f, n, "_i"), t._t = n, t._i = p++, t._l = void 0, void 0 != e && a(e, r, t[o], t)
                });
                return e(f.prototype, {
                    delete: function (t) {
                        if (!u(t))return !1;
                        var r = i(t);
                        return !0 === r ? d(l(this, n)).delete(t) : r && s(r, this._i) && delete r[this._i]
                    }, has: function has(t) {
                        if (!u(t))return !1;
                        var r = i(t);
                        return !0 === r ? d(l(this, n)).has(t) : r && s(r, this._i)
                    }
                }), f
            }, def: function (t, n, r) {
                var e = i(o(n), !0);
                return !0 === e ? d(t).set(n, r) : e[t._i] = r, t
            }, ufstore: d
        }
    }, {12: 12, 125: 125, 39: 39, 41: 41, 51: 51, 6: 6, 66: 66, 7: 7, 93: 93}],
    22: [function (t, n, r) {
        "use strict";
        var e = t(40), i = t(33), o = t(94), u = t(93), c = t(66), a = t(39), f = t(6), s = t(51), l = t(35), h = t(56), v = t(101), p = t(45);
        n.exports = function (t, n, r, d, y, g) {
            var m = e[t], b = m, x = y ? "set" : "add", S = b && b.prototype, w = {}, _ = function (t) {
                var n = S[t];
                o(S, t, "delete" == t ? function (t) {
                    return !(g && !s(t)) && n.call(this, 0 === t ? 0 : t)
                } : "has" == t ? function has(t) {
                    return !(g && !s(t)) && n.call(this, 0 === t ? 0 : t)
                } : "get" == t ? function get(t) {
                    return g && !s(t) ? void 0 : n.call(this, 0 === t ? 0 : t)
                } : "add" == t ? function add(t) {
                    return n.call(this, 0 === t ? 0 : t), this
                } : function set(t, r) {
                    return n.call(this, 0 === t ? 0 : t, r), this
                })
            };
            if ("function" == typeof b && (g || S.forEach && !l(function () {
                    (new b).entries().next()
                }))) {
                var E = new b, O = E[x](g ? {} : -0, 1) != E, P = l(function () {
                    E.has(1)
                }), M = h(function (t) {
                    new b(t)
                }), F = !g && l(function () {
                        for (var t = new b, n = 5; n--;)t[x](n, n);
                        return !t.has(-0)
                    });
                M || (b = n(function (n, r) {
                    f(n, b, t);
                    var e = p(new m, n, b);
                    return void 0 != r && a(r, y, e[x], e), e
                }), b.prototype = S, S.constructor = b), (P || F) && (_("delete"), _("has"), y && _("get")), (F || O) && _(x), g && S.clear && delete S.clear
            } else b = d.getConstructor(n, t, y, x), u(b.prototype, r), c.NEED = !0;
            return v(b, t), w[t] = b, i(i.G + i.W + i.F * (b != m), w), g || d.setStrong(b, t, y), b
        }
    }, {101: 101, 33: 33, 35: 35, 39: 39, 40: 40, 45: 45, 51: 51, 56: 56, 6: 6, 66: 66, 93: 93, 94: 94}],
    23: [function (t, n, r) {
        var e = n.exports = {version: "2.5.0"};
        "number" == typeof __e && (__e = e)
    }, {}],
    24: [function (t, n, r) {
        "use strict";
        var e = t(72), i = t(92);
        n.exports = function (t, n, r) {
            n in t ? e.f(t, n, i(0, r)) : t[n] = r
        }
    }, {72: 72, 92: 92}],
    25: [function (t, n, r) {
        var e = t(3);
        n.exports = function (t, n, r) {
            if (e(t), void 0 === n)return t;
            switch (r) {
                case 1:
                    return function (r) {
                        return t.call(n, r)
                    };
                case 2:
                    return function (r, e) {
                        return t.call(n, r, e)
                    };
                case 3:
                    return function (r, e, i) {
                        return t.call(n, r, e, i)
                    }
            }
            return function () {
                return t.apply(n, arguments)
            }
        }
    }, {3: 3}],
    26: [function (t, n, r) {
        "use strict";
        var e = t(35), i = Date.prototype.getTime, o = Date.prototype.toISOString, u = function (t) {
            return t > 9 ? t : "0" + t
        };
        n.exports = e(function () {
            return "0385-07-25T07:06:39.999Z" != o.call(new Date(-5e13 - 1))
        }) || !e(function () {
            o.call(new Date(NaN))
        }) ? function toISOString() {
            if (!isFinite(i.call(this)))throw RangeError("Invalid time value");
            var t = this, n = t.getUTCFullYear(), r = t.getUTCMilliseconds(), e = n < 0 ? "-" : n > 9999 ? "+" : "";
            return e + ("00000" + Math.abs(n)).slice(e ? -6 : -4) + "-" + u(t.getUTCMonth() + 1) + "-" + u(t.getUTCDate()) + "T" + u(t.getUTCHours()) + ":" + u(t.getUTCMinutes()) + ":" + u(t.getUTCSeconds()) + "." + (r > 99 ? r : "0" + u(r)) + "Z"
        } : o
    }, {35: 35}],
    27: [function (t, n, r) {
        "use strict";
        var e = t(7), i = t(120);
        n.exports = function (t) {
            if ("string" !== t && "number" !== t && "default" !== t)throw TypeError("Incorrect hint");
            return i(e(this), "number" != t)
        }
    }, {120: 120, 7: 7}],
    28: [function (t, n, r) {
        n.exports = function (t) {
            if (void 0 == t)throw TypeError("Can't call method on  " + t);
            return t
        }
    }, {}],
    29: [function (t, n, r) {
        n.exports = !t(35)(function () {
            return 7 != Object.defineProperty({}, "a", {
                    get: function () {
                        return 7
                    }
                }).a
        })
    }, {35: 35}],
    30: [function (t, n, r) {
        var e = t(51), i = t(40).document, o = e(i) && e(i.createElement);
        n.exports = function (t) {
            return o ? i.createElement(t) : {}
        }
    }, {40: 40, 51: 51}],
    31: [function (t, n, r) {
        n.exports = "constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")
    }, {}],
    32: [function (t, n, r) {
        var e = t(81), i = t(78), o = t(82);
        n.exports = function (t) {
            var n = e(t), r = i.f;
            if (r)for (var u, c = r(t), a = o.f, f = 0; c.length > f;)a.call(t, u = c[f++]) && n.push(u);
            return n
        }
    }, {78: 78, 81: 81, 82: 82}],
    33: [function (t, n, r) {
        var e = t(40), i = t(23), o = t(42), u = t(94), c = t(25), a = function (t, n, r) {
            var f, s, l, h, v = t & a.F, p = t & a.G, d = t & a.S, y = t & a.P, g = t & a.B, m = p ? e : d ? e[n] || (e[n] = {}) : (e[n] || {}).prototype, b = p ? i : i[n] || (i[n] = {}), x = b.prototype || (b.prototype = {});
            p && (r = n);
            for (f in r)s = !v && m && void 0 !== m[f], l = (s ? m : r)[f], h = g && s ? c(l, e) : y && "function" == typeof l ? c(Function.call, l) : l, m && u(m, f, l, t & a.U), b[f] != l && o(b, f, h), y && x[f] != l && (x[f] = l)
        };
        e.core = i, a.F = 1, a.G = 2, a.S = 4, a.P = 8, a.B = 16, a.W = 32, a.U = 64, a.R = 128, n.exports = a
    }, {23: 23, 25: 25, 40: 40, 42: 42, 94: 94}],
    34: [function (t, n, r) {
        var e = t(128)("match");
        n.exports = function (t) {
            var n = /./;
            try {
                "/./"[t](n)
            } catch (r) {
                try {
                    return n[e] = !1, !"/./"[t](n)
                } catch (t) {
                }
            }
            return !0
        }
    }, {128: 128}],
    35: [function (t, n, r) {
        n.exports = function (t) {
            try {
                return !!t()
            } catch (t) {
                return !0
            }
        }
    }, {}],
    36: [function (t, n, r) {
        "use strict";
        var e = t(42), i = t(94), o = t(35), u = t(28), c = t(128);
        n.exports = function (t, n, r) {
            var a = c(t), f = r(u, a, ""[t]), s = f[0], l = f[1];
            o(function () {
                var n = {};
                return n[a] = function () {
                    return 7
                }, 7 != ""[t](n)
            }) && (i(String.prototype, t, s), e(RegExp.prototype, a, 2 == n ? function (t, n) {
                return l.call(t, this, n)
            } : function (t) {
                return l.call(t, this)
            }))
        }
    }, {128: 128, 28: 28, 35: 35, 42: 42, 94: 94}],
    37: [function (t, n, r) {
        "use strict";
        var e = t(7);
        n.exports = function () {
            var t = e(this), n = "";
            return t.global && (n += "g"), t.ignoreCase && (n += "i"), t.multiline && (n += "m"), t.unicode && (n += "u"), t.sticky && (n += "y"), n
        }
    }, {7: 7}],
    38: [function (t, n, r) {
        "use strict";
        function flattenIntoArray(t, n, r, a, f, s, l, h) {
            for (var v, p, d = f, y = 0, g = !!l && u(l, h, 3); y < a;) {
                if (y in r) {
                    if (v = g ? g(r[y], y, n) : r[y], p = !1, i(v) && (p = v[c], p = void 0 !== p ? !!p : e(v)), p && s > 0)d = flattenIntoArray(t, n, v, o(v.length), d, s - 1) - 1; else {
                        if (d >= 9007199254740991)throw TypeError();
                        t[d] = v
                    }
                    d++
                }
                y++
            }
            return d
        }

        var e = t(49), i = t(51), o = t(118), u = t(25), c = t(128)("isConcatSpreadable");
        n.exports = flattenIntoArray
    }, {118: 118, 128: 128, 25: 25, 49: 49, 51: 51}],
    39: [function (t, n, r) {
        var e = t(25), i = t(53), o = t(48), u = t(7), c = t(118), a = t(129), f = {}, s = {}, r = n.exports = function (t, n, r, l, h) {
            var v, p, d, y, g = h ? function () {
                return t
            } : a(t), m = e(r, l, n ? 2 : 1), b = 0;
            if ("function" != typeof g)throw TypeError(t + " is not iterable!");
            if (o(g)) {
                for (v = c(t.length); v > b; b++)if ((y = n ? m(u(p = t[b])[0], p[1]) : m(t[b])) === f || y === s)return y
            } else for (d = g.call(t); !(p = d.next()).done;)if ((y = i(d, m, p.value, n)) === f || y === s)return y
        };
        r.BREAK = f, r.RETURN = s
    }, {118: 118, 129: 129, 25: 25, 48: 48, 53: 53, 7: 7}],
    40: [function (t, n, r) {
        var e = n.exports = "undefined" != typeof window && window.Math == Math ? window : "undefined" != typeof self && self.Math == Math ? self : Function("return this")();
        "number" == typeof __g && (__g = e)
    }, {}],
    41: [function (t, n, r) {
        var e = {}.hasOwnProperty;
        n.exports = function (t, n) {
            return e.call(t, n)
        }
    }, {}],
    42: [function (t, n, r) {
        var e = t(72), i = t(92);
        n.exports = t(29) ? function (t, n, r) {
            return e.f(t, n, i(1, r))
        } : function (t, n, r) {
            return t[n] = r, t
        }
    }, {29: 29, 72: 72, 92: 92}],
    43: [function (t, n, r) {
        var e = t(40).document;
        n.exports = e && e.documentElement
    }, {40: 40}],
    44: [function (t, n, r) {
        n.exports = !t(29) && !t(35)(function () {
                return 7 != Object.defineProperty(t(30)("div"), "a", {
                        get: function () {
                            return 7
                        }
                    }).a
            })
    }, {29: 29, 30: 30, 35: 35}],
    45: [function (t, n, r) {
        var e = t(51), i = t(99).set;
        n.exports = function (t, n, r) {
            var o, u = n.constructor;
            return u !== r && "function" == typeof u && (o = u.prototype) !== r.prototype && e(o) && i && i(t, o), t
        }
    }, {51: 51, 99: 99}],
    46: [function (t, n, r) {
        n.exports = function (t, n, r) {
            var e = void 0 === r;
            switch (n.length) {
                case 0:
                    return e ? t() : t.call(r);
                case 1:
                    return e ? t(n[0]) : t.call(r, n[0]);
                case 2:
                    return e ? t(n[0], n[1]) : t.call(r, n[0], n[1]);
                case 3:
                    return e ? t(n[0], n[1], n[2]) : t.call(r, n[0], n[1], n[2]);
                case 4:
                    return e ? t(n[0], n[1], n[2], n[3]) : t.call(r, n[0], n[1], n[2], n[3])
            }
            return t.apply(r, n)
        }
    }, {}],
    47: [function (t, n, r) {
        var e = t(18);
        n.exports = Object("z").propertyIsEnumerable(0) ? Object : function (t) {
            return "String" == e(t) ? t.split("") : Object(t)
        }
    }, {18: 18}],
    48: [function (t, n, r) {
        var e = t(58), i = t(128)("iterator"), o = Array.prototype;
        n.exports = function (t) {
            return void 0 !== t && (e.Array === t || o[i] === t)
        }
    }, {128: 128, 58: 58}],
    49: [function (t, n, r) {
        var e = t(18);
        n.exports = Array.isArray || function isArray(t) {
                return "Array" == e(t)
            }
    }, {18: 18}],
    50: [function (t, n, r) {
        var e = t(51), i = Math.floor;
        n.exports = function isInteger(t) {
            return !e(t) && isFinite(t) && i(t) === t
        }
    }, {51: 51}],
    51: [function (t, n, r) {
        n.exports = function (t) {
            return "object" == typeof t ? null !== t : "function" == typeof t
        }
    }, {}],
    52: [function (t, n, r) {
        var e = t(51), i = t(18), o = t(128)("match");
        n.exports = function (t) {
            var n;
            return e(t) && (void 0 !== (n = t[o]) ? !!n : "RegExp" == i(t))
        }
    }, {128: 128, 18: 18, 51: 51}],
    53: [function (t, n, r) {
        var e = t(7);
        n.exports = function (t, n, r, i) {
            try {
                return i ? n(e(r)[0], r[1]) : n(r)
            } catch (n) {
                var o = t.return;
                throw void 0 !== o && e(o.call(t)), n
            }
        }
    }, {7: 7}],
    54: [function (t, n, r) {
        "use strict";
        var e = t(71), i = t(92), o = t(101), u = {};
        t(42)(u, t(128)("iterator"), function () {
            return this
        }), n.exports = function (t, n, r) {
            t.prototype = e(u, {next: i(1, r)}), o(t, n + " Iterator")
        }
    }, {101: 101, 128: 128, 42: 42, 71: 71, 92: 92}],
    55: [function (t, n, r) {
        "use strict";
        var e = t(60), i = t(33), o = t(94), u = t(42), c = t(41), a = t(58), f = t(54), s = t(101), l = t(79), h = t(128)("iterator"), v = !([].keys && "next" in [].keys()), p = function () {
            return this
        };
        n.exports = function (t, n, r, d, y, g, m) {
            f(r, n, d);
            var b, x, S, w = function (t) {
                if (!v && t in P)return P[t];
                switch (t) {
                    case"keys":
                        return function keys() {
                            return new r(this, t)
                        };
                    case"values":
                        return function values() {
                            return new r(this, t)
                        }
                }
                return function entries() {
                    return new r(this, t)
                }
            }, _ = n + " Iterator", E = "values" == y, O = !1, P = t.prototype, M = P[h] || P["@@iterator"] || y && P[y], F = M || w(y), I = y ? E ? w("entries") : F : void 0, A = "Array" == n ? P.entries || M : M;
            if (A && (S = l(A.call(new t))) !== Object.prototype && S.next && (s(S, _, !0), e || c(S, h) || u(S, h, p)), E && M && "values" !== M.name && (O = !0, F = function values() {
                    return M.call(this)
                }), e && !m || !v && !O && P[h] || u(P, h, F), a[n] = F, a[_] = p, y)if (b = {
                    values: E ? F : w("values"),
                    keys: g ? F : w("keys"),
                    entries: I
                }, m)for (x in b)x in P || o(P, x, b[x]); else i(i.P + i.F * (v || O), n, b);
            return b
        }
    }, {101: 101, 128: 128, 33: 33, 41: 41, 42: 42, 54: 54, 58: 58, 60: 60, 79: 79, 94: 94}],
    56: [function (t, n, r) {
        var e = t(128)("iterator"), i = !1;
        try {
            var o = [7][e]();
            o.return = function () {
                i = !0
            }, Array.from(o, function () {
                throw 2
            })
        } catch (t) {
        }
        n.exports = function (t, n) {
            if (!n && !i)return !1;
            var r = !1;
            try {
                var o = [7], u = o[e]();
                u.next = function () {
                    return {done: r = !0}
                }, o[e] = function () {
                    return u
                }, t(o)
            } catch (t) {
            }
            return r
        }
    }, {128: 128}],
    57: [function (t, n, r) {
        n.exports = function (t, n) {
            return {value: n, done: !!t}
        }
    }, {}],
    58: [function (t, n, r) {
        n.exports = {}
    }, {}],
    59: [function (t, n, r) {
        var e = t(81), i = t(117);
        n.exports = function (t, n) {
            for (var r, o = i(t), u = e(o), c = u.length, a = 0; c > a;)if (o[r = u[a++]] === n)return r
        }
    }, {117: 117, 81: 81}],
    60: [function (t, n, r) {
        n.exports = !1
    }, {}],
    61: [function (t, n, r) {
        var e = Math.expm1;
        n.exports = !e || e(10) > 22025.465794806718 || e(10) < 22025.465794806718 || -2e-17 != e(-2e-17) ? function expm1(t) {
            return 0 == (t = +t) ? t : t > -1e-6 && t < 1e-6 ? t + t * t / 2 : Math.exp(t) - 1
        } : e
    }, {}],
    62: [function (t, n, r) {
        var e = t(65), i = Math.pow, o = i(2, -52), u = i(2, -23), c = i(2, 127) * (2 - u), a = i(2, -126), f = function (t) {
            return t + 1 / o - 1 / o
        };
        n.exports = Math.fround || function fround(t) {
                var n, r, i = Math.abs(t), s = e(t);
                return i < a ? s * f(i / a / u) * a * u : (n = (1 + u / o) * i, r = n - (n - i), r > c || r != r ? s * (1 / 0) : s * r)
            }
    }, {65: 65}],
    63: [function (t, n, r) {
        n.exports = Math.log1p || function log1p(t) {
                return (t = +t) > -1e-8 && t < 1e-8 ? t - t * t / 2 : Math.log(1 + t)
            }
    }, {}],
    64: [function (t, n, r) {
        n.exports = Math.scale || function scale(t, n, r, e, i) {
                return 0 === arguments.length || t != t || n != n || r != r || e != e || i != i ? NaN : t === 1 / 0 || t === -1 / 0 ? t : (t - n) * (i - e) / (r - n) + e
            }
    }, {}],
    65: [function (t, n, r) {
        n.exports = Math.sign || function sign(t) {
                return 0 == (t = +t) || t != t ? t : t < 0 ? -1 : 1
            }
    }, {}],
    66: [function (t, n, r) {
        var e = t(124)("meta"), i = t(51), o = t(41), u = t(72).f, c = 0, a = Object.isExtensible || function () {
                return !0
            }, f = !t(35)(function () {
            return a(Object.preventExtensions({}))
        }), s = function (t) {
            u(t, e, {value: {i: "O" + ++c, w: {}}})
        }, l = function (t, n) {
            if (!i(t))return "symbol" == typeof t ? t : ("string" == typeof t ? "S" : "P") + t;
            if (!o(t, e)) {
                if (!a(t))return "F";
                if (!n)return "E";
                s(t)
            }
            return t[e].i
        }, h = function (t, n) {
            if (!o(t, e)) {
                if (!a(t))return !0;
                if (!n)return !1;
                s(t)
            }
            return t[e].w
        }, v = function (t) {
            return f && p.NEED && a(t) && !o(t, e) && s(t), t
        }, p = n.exports = {KEY: e, NEED: !1, fastKey: l, getWeak: h, onFreeze: v}
    }, {124: 124, 35: 35, 41: 41, 51: 51, 72: 72}],
    67: [function (t, n, r) {
        var e = t(160), i = t(33), o = t(103)("metadata"), u = o.store || (o.store = new (t(266))), c = function (t, n, r) {
            var i = u.get(t);
            if (!i) {
                if (!r)return;
                u.set(t, i = new e)
            }
            var o = i.get(n);
            if (!o) {
                if (!r)return;
                i.set(n, o = new e)
            }
            return o
        }, a = function (t, n, r) {
            var e = c(n, r, !1);
            return void 0 !== e && e.has(t)
        }, f = function (t, n, r) {
            var e = c(n, r, !1);
            return void 0 === e ? void 0 : e.get(t)
        }, s = function (t, n, r, e) {
            c(r, e, !0).set(t, n)
        }, l = function (t, n) {
            var r = c(t, n, !1), e = [];
            return r && r.forEach(function (t, n) {
                e.push(n)
            }), e
        }, h = function (t) {
            return void 0 === t || "symbol" == typeof t ? t : String(t)
        }, v = function (t) {
            i(i.S, "Reflect", t)
        };
        n.exports = {store: u, map: c, has: a, get: f, set: s, keys: l, key: h, exp: v}
    }, {103: 103, 160: 160, 266: 266, 33: 33}],
    68: [function (t, n, r) {
        var e = t(40), i = t(113).set, o = e.MutationObserver || e.WebKitMutationObserver, u = e.process, c = e.Promise, a = "process" == t(18)(u);
        n.exports = function () {
            var t, n, r, f = function () {
                var e, i;
                for (a && (e = u.domain) && e.exit(); t;) {
                    i = t.fn, t = t.next;
                    try {
                        i()
                    } catch (e) {
                        throw t ? r() : n = void 0, e
                    }
                }
                n = void 0, e && e.enter()
            };
            if (a)r = function () {
                u.nextTick(f)
            }; else if (o) {
                var s = !0, l = document.createTextNode("");
                new o(f).observe(l, {characterData: !0}), r = function () {
                    l.data = s = !s
                }
            } else if (c && c.resolve) {
                var h = c.resolve();
                r = function () {
                    h.then(f)
                }
            } else r = function () {
                i.call(e, f)
            };
            return function (e) {
                var i = {fn: e, next: void 0};
                n && (n.next = i), t || (t = i, r()), n = i
            }
        }
    }, {113: 113, 18: 18, 40: 40}],
    69: [function (t, n, r) {
        "use strict";
        function PromiseCapability(t) {
            var n, r;
            this.promise = new t(function (t, e) {
                if (void 0 !== n || void 0 !== r)throw TypeError("Bad Promise constructor");
                n = t, r = e
            }), this.resolve = e(n), this.reject = e(r)
        }

        var e = t(3);
        n.exports.f = function (t) {
            return new PromiseCapability(t)
        }
    }, {3: 3}],
    70: [function (t, n, r) {
        "use strict";
        var e = t(81), i = t(78), o = t(82), u = t(119), c = t(47), a = Object.assign;
        n.exports = !a || t(35)(function () {
            var t = {}, n = {}, r = Symbol(), e = "abcdefghijklmnopqrst";
            return t[r] = 7, e.split("").forEach(function (t) {
                n[t] = t
            }), 7 != a({}, t)[r] || Object.keys(a({}, n)).join("") != e
        }) ? function assign(t, n) {
            for (var r = u(t), a = arguments.length, f = 1, s = i.f, l = o.f; a > f;)for (var h, v = c(arguments[f++]), p = s ? e(v).concat(s(v)) : e(v), d = p.length, y = 0; d > y;)l.call(v, h = p[y++]) && (r[h] = v[h]);
            return r
        } : a
    }, {119: 119, 35: 35, 47: 47, 78: 78, 81: 81, 82: 82}],
    71: [function (t, n, r) {
        var e = t(7), i = t(73), o = t(31), u = t(102)("IE_PROTO"), c = function () {
        }, a = function () {
            var n, r = t(30)("iframe"), e = o.length;
            for (r.style.display = "none", t(43).appendChild(r), r.src = "javascript:", n = r.contentWindow.document, n.open(), n.write("<script>document.F=Object<\/script>"), n.close(), a = n.F; e--;)delete a.prototype[o[e]];
            return a()
        };
        n.exports = Object.create || function create(t, n) {
                var r;
                return null !== t ? (c.prototype = e(t), r = new c, c.prototype = null, r[u] = t) : r = a(), void 0 === n ? r : i(r, n)
            }
    }, {102: 102, 30: 30, 31: 31, 43: 43, 7: 7, 73: 73}],
    72: [function (t, n, r) {
        var e = t(7), i = t(44), o = t(120), u = Object.defineProperty;
        r.f = t(29) ? Object.defineProperty : function defineProperty(t, n, r) {
            if (e(t), n = o(n, !0), e(r), i)try {
                return u(t, n, r)
            } catch (t) {
            }
            if ("get" in r || "set" in r)throw TypeError("Accessors not supported!");
            return "value" in r && (t[n] = r.value), t
        }
    }, {120: 120, 29: 29, 44: 44, 7: 7}],
    73: [function (t, n, r) {
        var e = t(72), i = t(7), o = t(81);
        n.exports = t(29) ? Object.defineProperties : function defineProperties(t, n) {
            i(t);
            for (var r, u = o(n), c = u.length, a = 0; c > a;)e.f(t, r = u[a++], n[r]);
            return t
        }
    }, {29: 29, 7: 7, 72: 72, 81: 81}],
    74: [function (t, n, r) {
        "use strict";
        n.exports = t(60) || !t(35)(function () {
                var n = Math.random();
                __defineSetter__.call(null, n, function () {
                }), delete t(40)[n]
            })
    }, {35: 35, 40: 40, 60: 60}],
    75: [function (t, n, r) {
        var e = t(82), i = t(92), o = t(117), u = t(120), c = t(41), a = t(44), f = Object.getOwnPropertyDescriptor;
        r.f = t(29) ? f : function getOwnPropertyDescriptor(t, n) {
            if (t = o(t), n = u(n, !0), a)try {
                return f(t, n)
            } catch (t) {
            }
            if (c(t, n))return i(!e.f.call(t, n), t[n])
        }
    }, {117: 117, 120: 120, 29: 29, 41: 41, 44: 44, 82: 82, 92: 92}],
    76: [function (t, n, r) {
        var e = t(117), i = t(77).f, o = {}.toString, u = "object" == typeof window && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [], c = function (t) {
            try {
                return i(t)
            } catch (t) {
                return u.slice()
            }
        };
        n.exports.f = function getOwnPropertyNames(t) {
            return u && "[object Window]" == o.call(t) ? c(t) : i(e(t))
        }
    }, {117: 117, 77: 77}],
    77: [function (t, n, r) {
        var e = t(80), i = t(31).concat("length", "prototype");
        r.f = Object.getOwnPropertyNames || function getOwnPropertyNames(t) {
                return e(t, i)
            }
    }, {31: 31, 80: 80}],
    78: [function (t, n, r) {
        r.f = Object.getOwnPropertySymbols
    }, {}],
    79: [function (t, n, r) {
        var e = t(41), i = t(119), o = t(102)("IE_PROTO"), u = Object.prototype;
        n.exports = Object.getPrototypeOf || function (t) {
                return t = i(t), e(t, o) ? t[o] : "function" == typeof t.constructor && t instanceof t.constructor ? t.constructor.prototype : t instanceof Object ? u : null
            }
    }, {102: 102, 119: 119, 41: 41}],
    80: [function (t, n, r) {
        var e = t(41), i = t(117), o = t(11)(!1), u = t(102)("IE_PROTO");
        n.exports = function (t, n) {
            var r, c = i(t), a = 0, f = [];
            for (r in c)r != u && e(c, r) && f.push(r);
            for (; n.length > a;)e(c, r = n[a++]) && (~o(f, r) || f.push(r));
            return f
        }
    }, {102: 102, 11: 11, 117: 117, 41: 41}],
    81: [function (t, n, r) {
        var e = t(80), i = t(31);
        n.exports = Object.keys || function keys(t) {
                return e(t, i)
            }
    }, {31: 31, 80: 80}],
    82: [function (t, n, r) {
        r.f = {}.propertyIsEnumerable
    }, {}],
    83: [function (t, n, r) {
        var e = t(33), i = t(23), o = t(35);
        n.exports = function (t, n) {
            var r = (i.Object || {})[t] || Object[t], u = {};
            u[t] = n(r), e(e.S + e.F * o(function () {
                    r(1)
                }), "Object", u)
        }
    }, {23: 23, 33: 33, 35: 35}],
    84: [function (t, n, r) {
        var e = t(81), i = t(117), o = t(82).f;
        n.exports = function (t) {
            return function (n) {
                for (var r, u = i(n), c = e(u), a = c.length, f = 0, s = []; a > f;)o.call(u, r = c[f++]) && s.push(t ? [r, u[r]] : u[r]);
                return s
            }
        }
    }, {117: 117, 81: 81, 82: 82}],
    85: [function (t, n, r) {
        var e = t(77), i = t(78), o = t(7), u = t(40).Reflect;
        n.exports = u && u.ownKeys || function ownKeys(t) {
                var n = e.f(o(t)), r = i.f;
                return r ? n.concat(r(t)) : n
            }
    }, {40: 40, 7: 7, 77: 77, 78: 78}],
    86: [function (t, n, r) {
        var e = t(40).parseFloat, i = t(111).trim;
        n.exports = 1 / e(t(112) + "-0") != -1 / 0 ? function parseFloat(t) {
            var n = i(String(t), 3), r = e(n);
            return 0 === r && "-" == n.charAt(0) ? -0 : r
        } : e
    }, {111: 111, 112: 112, 40: 40}],
    87: [function (t, n, r) {
        var e = t(40).parseInt, i = t(111).trim, o = t(112), u = /^[-+]?0[xX]/;
        n.exports = 8 !== e(o + "08") || 22 !== e(o + "0x16") ? function parseInt(t, n) {
            var r = i(String(t), 3);
            return e(r, n >>> 0 || (u.test(r) ? 16 : 10))
        } : e
    }, {111: 111, 112: 112, 40: 40}],
    88: [function (t, n, r) {
        "use strict";
        var e = t(89), i = t(46), o = t(3);
        n.exports = function () {
            for (var t = o(this), n = arguments.length, r = Array(n), u = 0, c = e._, a = !1; n > u;)(r[u] = arguments[u++]) === c && (a = !0);
            return function () {
                var e, o = this, u = arguments.length, f = 0, s = 0;
                if (!a && !u)return i(t, r, o);
                if (e = r.slice(), a)for (; n > f; f++)e[f] === c && (e[f] = arguments[s++]);
                for (; u > s;)e.push(arguments[s++]);
                return i(t, e, o)
            }
        }
    }, {3: 3, 46: 46, 89: 89}],
    89: [function (t, n, r) {
        n.exports = t(40)
    }, {40: 40}],
    90: [function (t, n, r) {
        n.exports = function (t) {
            try {
                return {e: !1, v: t()}
            } catch (t) {
                return {e: !0, v: t}
            }
        }
    }, {}],
    91: [function (t, n, r) {
        var e = t(69);
        n.exports = function (t, n) {
            var r = e.f(t);
            return (0, r.resolve)(n), r.promise
        }
    }, {69: 69}],
    92: [function (t, n, r) {
        n.exports = function (t, n) {
            return {enumerable: !(1 & t), configurable: !(2 & t), writable: !(4 & t), value: n}
        }
    }, {}],
    93: [function (t, n, r) {
        var e = t(94);
        n.exports = function (t, n, r) {
            for (var i in n)e(t, i, n[i], r);
            return t
        }
    }, {94: 94}],
    94: [function (t, n, r) {
        var e = t(40), i = t(42), o = t(41), u = t(124)("src"), c = Function.toString, a = ("" + c).split("toString");
        t(23).inspectSource = function (t) {
            return c.call(t)
        }, (n.exports = function (t, n, r, c) {
            var f = "function" == typeof r;
            f && (o(r, "name") || i(r, "name", n)), t[n] !== r && (f && (o(r, u) || i(r, u, t[n] ? "" + t[n] : a.join(String(n)))), t === e ? t[n] = r : c ? t[n] ? t[n] = r : i(t, n, r) : (delete t[n], i(t, n, r)))
        })(Function.prototype, "toString", function toString() {
            return "function" == typeof this && this[u] || c.call(this)
        })
    }, {124: 124, 23: 23, 40: 40, 41: 41, 42: 42}],
    95: [function (t, n, r) {
        n.exports = function (t, n) {
            var r = n === Object(n) ? function (t) {
                return n[t]
            } : n;
            return function (n) {
                return String(n).replace(t, r)
            }
        }
    }, {}],
    96: [function (t, n, r) {
        n.exports = Object.is || function is(t, n) {
                return t === n ? 0 !== t || 1 / t == 1 / n : t != t && n != n
            }
    }, {}],
    97: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(3), o = t(25), u = t(39);
        n.exports = function (t) {
            e(e.S, t, {
                from: function from(t) {
                    var n, r, e, c, a = arguments[1];
                    return i(this), n = void 0 !== a, n && i(a), void 0 == t ? new this : (r = [], n ? (e = 0, c = o(a, arguments[2], 2), u(t, !1, function (t) {
                        r.push(c(t, e++))
                    })) : u(t, !1, r.push, r), new this(r))
                }
            })
        }
    }, {25: 25, 3: 3, 33: 33, 39: 39}],
    98: [function (t, n, r) {
        "use strict";
        var e = t(33);
        n.exports = function (t) {
            e(e.S, t, {
                of: function of() {
                    for (var t = arguments.length, n = Array(t); t--;)n[t] = arguments[t];
                    return new this(n)
                }
            })
        }
    }, {33: 33}],
    99: [function (t, n, r) {
        var e = t(51), i = t(7), o = function (t, n) {
            if (i(t), !e(n) && null !== n)throw TypeError(n + ": can't set as prototype!")
        };
        n.exports = {
            set: Object.setPrototypeOf || ("__proto__" in {} ? function (n, r, e) {
                try {
                    e = t(25)(Function.call, t(75).f(Object.prototype, "__proto__").set, 2), e(n, []), r = !(n instanceof Array)
                } catch (t) {
                    r = !0
                }
                return function setPrototypeOf(t, n) {
                    return o(t, n), r ? t.__proto__ = n : e(t, n), t
                }
            }({}, !1) : void 0), check: o
        }
    }, {25: 25, 51: 51, 7: 7, 75: 75}],
    100: [function (t, n, r) {
        "use strict";
        var e = t(40), i = t(72), o = t(29), u = t(128)("species");
        n.exports = function (t) {
            var n = e[t];
            o && n && !n[u] && i.f(n, u, {
                configurable: !0, get: function () {
                    return this
                }
            })
        }
    }, {128: 128, 29: 29, 40: 40, 72: 72}],
    101: [function (t, n, r) {
        var e = t(72).f, i = t(41), o = t(128)("toStringTag");
        n.exports = function (t, n, r) {
            t && !i(t = r ? t : t.prototype, o) && e(t, o, {configurable: !0, value: n})
        }
    }, {128: 128, 41: 41, 72: 72}],
    102: [function (t, n, r) {
        var e = t(103)("keys"), i = t(124);
        n.exports = function (t) {
            return e[t] || (e[t] = i(t))
        }
    }, {103: 103, 124: 124}],
    103: [function (t, n, r) {
        var e = t(40), i = e["__core-js_shared__"] || (e["__core-js_shared__"] = {});
        n.exports = function (t) {
            return i[t] || (i[t] = {})
        }
    }, {40: 40}],
    104: [function (t, n, r) {
        var e = t(7), i = t(3), o = t(128)("species");
        n.exports = function (t, n) {
            var r, u = e(t).constructor;
            return void 0 === u || void 0 == (r = e(u)[o]) ? n : i(r)
        }
    }, {128: 128, 3: 3, 7: 7}],
    105: [function (t, n, r) {
        "use strict";
        var e = t(35);
        n.exports = function (t, n) {
            return !!t && e(function () {
                    n ? t.call(null, function () {
                    }, 1) : t.call(null)
                })
        }
    }, {35: 35}],
    106: [function (t, n, r) {
        var e = t(116), i = t(28);
        n.exports = function (t) {
            return function (n, r) {
                var o, u, c = String(i(n)), a = e(r), f = c.length;
                return a < 0 || a >= f ? t ? "" : void 0 : (o = c.charCodeAt(a), o < 55296 || o > 56319 || a + 1 === f || (u = c.charCodeAt(a + 1)) < 56320 || u > 57343 ? t ? c.charAt(a) : o : t ? c.slice(a, a + 2) : u - 56320 + (o - 55296 << 10) + 65536)
            }
        }
    }, {116: 116, 28: 28}],
    107: [function (t, n, r) {
        var e = t(52), i = t(28);
        n.exports = function (t, n, r) {
            if (e(n))throw TypeError("String#" + r + " doesn't accept regex!");
            return String(i(t))
        }
    }, {28: 28, 52: 52}],
    108: [function (t, n, r) {
        var e = t(33), i = t(35), o = t(28), u = /"/g, c = function (t, n, r, e) {
            var i = String(o(t)), c = "<" + n;
            return "" !== r && (c += " " + r + '="' + String(e).replace(u, "&quot;") + '"'), c + ">" + i + "</" + n + ">"
        };
        n.exports = function (t, n) {
            var r = {};
            r[t] = n(c), e(e.P + e.F * i(function () {
                    var n = ""[t]('"');
                    return n !== n.toLowerCase() || n.split('"').length > 3
                }), "String", r)
        }
    }, {28: 28, 33: 33, 35: 35}],
    109: [function (t, n, r) {
        var e = t(118), i = t(110), o = t(28);
        n.exports = function (t, n, r, u) {
            var c = String(o(t)), a = c.length, f = void 0 === r ? " " : String(r), s = e(n);
            if (s <= a || "" == f)return c;
            var l = s - a, h = i.call(f, Math.ceil(l / f.length));
            return h.length > l && (h = h.slice(0, l)), u ? h + c : c + h
        }
    }, {110: 110, 118: 118, 28: 28}],
    110: [function (t, n, r) {
        "use strict";
        var e = t(116), i = t(28);
        n.exports = function repeat(t) {
            var n = String(i(this)), r = "", o = e(t);
            if (o < 0 || o == 1 / 0)throw RangeError("Count can't be negative");
            for (; o > 0; (o >>>= 1) && (n += n))1 & o && (r += n);
            return r
        }
    }, {116: 116, 28: 28}],
    111: [function (t, n, r) {
        var e = t(33), i = t(28), o = t(35), u = t(112), c = "[" + u + "]", a = "​", f = RegExp("^" + c + c + "*"), s = RegExp(c + c + "*$"), l = function (t, n, r) {
            var i = {}, c = o(function () {
                return !!u[t]() || a[t]() != a
            }), f = i[t] = c ? n(h) : u[t];
            r && (i[r] = f), e(e.P + e.F * c, "String", i)
        }, h = l.trim = function (t, n) {
            return t = String(i(t)), 1 & n && (t = t.replace(f, "")), 2 & n && (t = t.replace(s, "")), t
        };
        n.exports = l
    }, {112: 112, 28: 28, 33: 33, 35: 35}],
    112: [function (t, n, r) {
        n.exports = "\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff"
    }, {}],
    113: [function (t, n, r) {
        var e, i, o, u = t(25), c = t(46), a = t(43), f = t(30), s = t(40), l = s.process, h = s.setImmediate, v = s.clearImmediate, p = s.MessageChannel, d = s.Dispatch, y = 0, g = {}, m = function () {
            var t = +this;
            if (g.hasOwnProperty(t)) {
                var n = g[t];
                delete g[t], n()
            }
        }, b = function (t) {
            m.call(t.data)
        };
        h && v || (h = function setImmediate(t) {
            for (var n = [], r = 1; arguments.length > r;)n.push(arguments[r++]);
            return g[++y] = function () {
                c("function" == typeof t ? t : Function(t), n)
            }, e(y), y
        }, v = function clearImmediate(t) {
            delete g[t]
        }, "process" == t(18)(l) ? e = function (t) {
            l.nextTick(u(m, t, 1))
        } : d && d.now ? e = function (t) {
            d.now(u(m, t, 1))
        } : p ? (i = new p, o = i.port2, i.port1.onmessage = b, e = u(o.postMessage, o, 1)) : s.addEventListener && "function" == typeof postMessage && !s.importScripts ? (e = function (t) {
            s.postMessage(t + "", "*")
        }, s.addEventListener("message", b, !1)) : e = "onreadystatechange" in f("script") ? function (t) {
            a.appendChild(f("script")).onreadystatechange = function () {
                a.removeChild(this), m.call(t)
            }
        } : function (t) {
            setTimeout(u(m, t, 1), 0)
        }), n.exports = {set: h, clear: v}
    }, {18: 18, 25: 25, 30: 30, 40: 40, 43: 43, 46: 46}],
    114: [function (t, n, r) {
        var e = t(116), i = Math.max, o = Math.min;
        n.exports = function (t, n) {
            return t = e(t), t < 0 ? i(t + n, 0) : o(t, n)
        }
    }, {116: 116}],
    115: [function (t, n, r) {
        var e = t(116), i = t(118);
        n.exports = function (t) {
            if (void 0 === t)return 0;
            var n = e(t), r = i(n);
            if (n !== r)throw RangeError("Wrong length!");
            return r
        }
    }, {116: 116, 118: 118}],
    116: [function (t, n, r) {
        var e = Math.ceil, i = Math.floor;
        n.exports = function (t) {
            return isNaN(t = +t) ? 0 : (t > 0 ? i : e)(t)
        }
    }, {}],
    117: [function (t, n, r) {
        var e = t(47), i = t(28);
        n.exports = function (t) {
            return e(i(t))
        }
    }, {28: 28, 47: 47}],
    118: [function (t, n, r) {
        var e = t(116), i = Math.min;
        n.exports = function (t) {
            return t > 0 ? i(e(t), 9007199254740991) : 0
        }
    }, {116: 116}],
    119: [function (t, n, r) {
        var e = t(28);
        n.exports = function (t) {
            return Object(e(t))
        }
    }, {28: 28}],
    120: [function (t, n, r) {
        var e = t(51);
        n.exports = function (t, n) {
            if (!e(t))return t;
            var r, i;
            if (n && "function" == typeof(r = t.toString) && !e(i = r.call(t)))return i;
            if ("function" == typeof(r = t.valueOf) && !e(i = r.call(t)))return i;
            if (!n && "function" == typeof(r = t.toString) && !e(i = r.call(t)))return i;
            throw TypeError("Can't convert object to primitive value")
        }
    }, {51: 51}],
    121: [function (t, n, r) {
        "use strict";
        if (t(29)) {
            var e = t(60), i = t(40), o = t(35), u = t(33), c = t(123), a = t(122), f = t(25), s = t(6), l = t(92), h = t(42), v = t(93), p = t(116), d = t(118), y = t(115), g = t(114), m = t(120), b = t(41), x = t(17), S = t(51), w = t(119), _ = t(48), E = t(71), O = t(79), P = t(77).f, M = t(129), F = t(124), I = t(128), A = t(12), k = t(11), N = t(104), j = t(141), T = t(58), R = t(56), L = t(100), G = t(9), D = t(8), C = t(72), W = t(75), U = C.f, B = W.f, V = i.RangeError, z = i.TypeError, q = i.Uint8Array, K = Array.prototype, Y = a.ArrayBuffer, J = a.DataView, H = A(0), X = A(2), $ = A(3), Z = A(4), Q = A(5), tt = A(6), nt = k(!0), rt = k(!1), et = j.values, it = j.keys, ot = j.entries, ut = K.lastIndexOf, ct = K.reduce, at = K.reduceRight, ft = K.join, st = K.sort, lt = K.slice, ht = K.toString, vt = K.toLocaleString, pt = I("iterator"), dt = I("toStringTag"), yt = F("typed_constructor"), gt = F("def_constructor"), mt = c.CONSTR, bt = c.TYPED, xt = c.VIEW, St = A(1, function (t, n) {
                return Pt(N(t, t[gt]), n)
            }), wt = o(function () {
                return 1 === new q(new Uint16Array([1]).buffer)[0]
            }), _t = !!q && !!q.prototype.set && o(function () {
                    new q(1).set({})
                }), Et = function (t, n) {
                var r = p(t);
                if (r < 0 || r % n)throw V("Wrong offset!");
                return r
            }, Ot = function (t) {
                if (S(t) && bt in t)return t;
                throw z(t + " is not a typed array!")
            }, Pt = function (t, n) {
                if (!(S(t) && yt in t))throw z("It is not a typed array constructor!");
                return new t(n)
            }, Mt = function (t, n) {
                return Ft(N(t, t[gt]), n)
            }, Ft = function (t, n) {
                for (var r = 0, e = n.length, i = Pt(t, e); e > r;)i[r] = n[r++];
                return i
            }, It = function (t, n, r) {
                U(t, n, {
                    get: function () {
                        return this._d[r]
                    }
                })
            }, At = function from(t) {
                var n, r, e, i, o, u, c = w(t), a = arguments.length, s = a > 1 ? arguments[1] : void 0, l = void 0 !== s, h = M(c);
                if (void 0 != h && !_(h)) {
                    for (u = h.call(c), e = [], n = 0; !(o = u.next()).done; n++)e.push(o.value);
                    c = e
                }
                for (l && a > 2 && (s = f(s, arguments[2], 2)), n = 0, r = d(c.length), i = Pt(this, r); r > n; n++)i[n] = l ? s(c[n], n) : c[n];
                return i
            }, kt = function of() {
                for (var t = 0, n = arguments.length, r = Pt(this, n); n > t;)r[t] = arguments[t++];
                return r
            }, Nt = !!q && o(function () {
                    vt.call(new q(1))
                }), jt = function toLocaleString() {
                return vt.apply(Nt ? lt.call(Ot(this)) : Ot(this), arguments)
            }, Tt = {
                copyWithin: function copyWithin(t, n) {
                    return D.call(Ot(this), t, n, arguments.length > 2 ? arguments[2] : void 0)
                }, every: function every(t) {
                    return Z(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, fill: function fill(t) {
                    return G.apply(Ot(this), arguments)
                }, filter: function filter(t) {
                    return Mt(this, X(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0))
                }, find: function find(t) {
                    return Q(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, findIndex: function findIndex(t) {
                    return tt(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, forEach: function forEach(t) {
                    H(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, indexOf: function indexOf(t) {
                    return rt(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, includes: function includes(t) {
                    return nt(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, join: function join(t) {
                    return ft.apply(Ot(this), arguments)
                }, lastIndexOf: function lastIndexOf(t) {
                    return ut.apply(Ot(this), arguments)
                }, map: function map(t) {
                    return St(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, reduce: function reduce(t) {
                    return ct.apply(Ot(this), arguments)
                }, reduceRight: function reduceRight(t) {
                    return at.apply(Ot(this), arguments)
                }, reverse: function reverse() {
                    for (var t, n = this, r = Ot(n).length, e = Math.floor(r / 2), i = 0; i < e;)t = n[i], n[i++] = n[--r], n[r] = t;
                    return n
                }, some: function some(t) {
                    return $(Ot(this), t, arguments.length > 1 ? arguments[1] : void 0)
                }, sort: function sort(t) {
                    return st.call(Ot(this), t)
                }, subarray: function subarray(t, n) {
                    var r = Ot(this), e = r.length, i = g(t, e);
                    return new (N(r, r[gt]))(r.buffer, r.byteOffset + i * r.BYTES_PER_ELEMENT, d((void 0 === n ? e : g(n, e)) - i))
                }
            }, Rt = function slice(t, n) {
                return Mt(this, lt.call(Ot(this), t, n))
            }, Lt = function set(t) {
                Ot(this);
                var n = Et(arguments[1], 1), r = this.length, e = w(t), i = d(e.length), o = 0;
                if (i + n > r)throw V("Wrong length!");
                for (; o < i;)this[n + o] = e[o++]
            }, Gt = {
                entries: function entries() {
                    return ot.call(Ot(this))
                }, keys: function keys() {
                    return it.call(Ot(this))
                }, values: function values() {
                    return et.call(Ot(this))
                }
            }, Dt = function (t, n) {
                return S(t) && t[bt] && "symbol" != typeof n && n in t && String(+n) == String(n)
            }, Ct = function getOwnPropertyDescriptor(t, n) {
                return Dt(t, n = m(n, !0)) ? l(2, t[n]) : B(t, n)
            }, Wt = function defineProperty(t, n, r) {
                return !(Dt(t, n = m(n, !0)) && S(r) && b(r, "value")) || b(r, "get") || b(r, "set") || r.configurable || b(r, "writable") && !r.writable || b(r, "enumerable") && !r.enumerable ? U(t, n, r) : (t[n] = r.value, t)
            };
            mt || (W.f = Ct, C.f = Wt), u(u.S + u.F * !mt, "Object", {
                getOwnPropertyDescriptor: Ct,
                defineProperty: Wt
            }), o(function () {
                ht.call({})
            }) && (ht = vt = function toString() {
                return ft.call(this)
            });
            var Ut = v({}, Tt);
            v(Ut, Gt), h(Ut, pt, Gt.values), v(Ut, {
                slice: Rt, set: Lt, constructor: function () {
                }, toString: ht, toLocaleString: jt
            }), It(Ut, "buffer", "b"), It(Ut, "byteOffset", "o"), It(Ut, "byteLength", "l"), It(Ut, "length", "e"), U(Ut, dt, {
                get: function () {
                    return this[bt]
                }
            }), n.exports = function (t, n, r, a) {
                a = !!a;
                var f = t + (a ? "Clamped" : "") + "Array", l = "get" + t, v = "set" + t, p = i[f], g = p || {}, m = p && O(p), b = !p || !c.ABV, w = {}, _ = p && p.prototype, M = function (t, r) {
                    var e = t._d;
                    return e.v[l](r * n + e.o, wt)
                }, F = function (t, r, e) {
                    var i = t._d;
                    a && (e = (e = Math.round(e)) < 0 ? 0 : e > 255 ? 255 : 255 & e), i.v[v](r * n + i.o, e, wt)
                }, I = function (t, n) {
                    U(t, n, {
                        get: function () {
                            return M(this, n)
                        }, set: function (t) {
                            return F(this, n, t)
                        }, enumerable: !0
                    })
                };
                b ? (p = r(function (t, r, e, i) {
                    s(t, p, f, "_d");
                    var o, u, c, a, l = 0, v = 0;
                    if (S(r)) {
                        if (!(r instanceof Y || "ArrayBuffer" == (a = x(r)) || "SharedArrayBuffer" == a))return bt in r ? Ft(p, r) : At.call(p, r);
                        o = r, v = Et(e, n);
                        var g = r.byteLength;
                        if (void 0 === i) {
                            if (g % n)throw V("Wrong length!");
                            if ((u = g - v) < 0)throw V("Wrong length!")
                        } else if ((u = d(i) * n) + v > g)throw V("Wrong length!");
                        c = u / n
                    } else c = y(r), u = c * n, o = new Y(u);
                    for (h(t, "_d", {b: o, o: v, l: u, e: c, v: new J(o)}); l < c;)I(t, l++)
                }), _ = p.prototype = E(Ut), h(_, "constructor", p)) : o(function () {
                    p(1)
                }) && o(function () {
                    new p(-1)
                }) && R(function (t) {
                    new p, new p(null), new p(1.5), new p(t)
                }, !0) || (p = r(function (t, r, e, i) {
                    s(t, p, f);
                    var o;
                    return S(r) ? r instanceof Y || "ArrayBuffer" == (o = x(r)) || "SharedArrayBuffer" == o ? void 0 !== i ? new g(r, Et(e, n), i) : void 0 !== e ? new g(r, Et(e, n)) : new g(r) : bt in r ? Ft(p, r) : At.call(p, r) : new g(y(r))
                }), H(m !== Function.prototype ? P(g).concat(P(m)) : P(g), function (t) {
                    t in p || h(p, t, g[t])
                }), p.prototype = _, e || (_.constructor = p));
                var A = _[pt], k = !!A && ("values" == A.name || void 0 == A.name), N = Gt.values;
                h(p, yt, !0), h(_, bt, f), h(_, xt, !0), h(_, gt, p), (a ? new p(1)[dt] == f : dt in _) || U(_, dt, {
                    get: function () {
                        return f
                    }
                }), w[f] = p, u(u.G + u.W + u.F * (p != g), w), u(u.S, f, {BYTES_PER_ELEMENT: n}), u(u.S + u.F * o(function () {
                        g.of.call(p, 1)
                    }), f, {
                    from: At,
                    of: kt
                }), "BYTES_PER_ELEMENT" in _ || h(_, "BYTES_PER_ELEMENT", n), u(u.P, f, Tt), L(f), u(u.P + u.F * _t, f, {set: Lt}), u(u.P + u.F * !k, f, Gt), e || _.toString == ht || (_.toString = ht), u(u.P + u.F * o(function () {
                        new p(1).slice()
                    }), f, {slice: Rt}), u(u.P + u.F * (o(function () {
                        return [1, 2].toLocaleString() != new p([1, 2]).toLocaleString()
                    }) || !o(function () {
                        _.toLocaleString.call([1, 2])
                    })), f, {toLocaleString: jt}), T[f] = k ? A : N, e || k || h(_, pt, N)
            }
        } else n.exports = function () {
        }
    }, {
        100: 100,
        104: 104,
        11: 11,
        114: 114,
        115: 115,
        116: 116,
        118: 118,
        119: 119,
        12: 12,
        120: 120,
        122: 122,
        123: 123,
        124: 124,
        128: 128,
        129: 129,
        141: 141,
        17: 17,
        25: 25,
        29: 29,
        33: 33,
        35: 35,
        40: 40,
        41: 41,
        42: 42,
        48: 48,
        51: 51,
        56: 56,
        58: 58,
        6: 6,
        60: 60,
        71: 71,
        72: 72,
        75: 75,
        77: 77,
        79: 79,
        8: 8,
        9: 9,
        92: 92,
        93: 93
    }],
    122: [function (t, n, r) {
        "use strict";
        function packIEEE754(t, n, r) {
            var e, i, o, u = Array(r), c = 8 * r - n - 1, a = (1 << c) - 1, f = a >> 1, s = 23 === n ? M(2, -24) - M(2, -77) : 0, l = 0, h = t < 0 || 0 === t && 1 / t < 0 ? 1 : 0;
            for (t = P(t), t != t || t === E ? (i = t != t ? 1 : 0, e = a) : (e = F(I(t) / A), t * (o = M(2, -e)) < 1 && (e--, o *= 2), t += e + f >= 1 ? s / o : s * M(2, 1 - f), t * o >= 2 && (e++, o /= 2), e + f >= a ? (i = 0, e = a) : e + f >= 1 ? (i = (t * o - 1) * M(2, n), e += f) : (i = t * M(2, f - 1) * M(2, n), e = 0)); n >= 8; u[l++] = 255 & i, i /= 256, n -= 8);
            for (e = e << n | i, c += n; c > 0; u[l++] = 255 & e, e /= 256, c -= 8);
            return u[--l] |= 128 * h, u
        }

        function unpackIEEE754(t, n, r) {
            var e, i = 8 * r - n - 1, o = (1 << i) - 1, u = o >> 1, c = i - 7, a = r - 1, f = t[a--], s = 127 & f;
            for (f >>= 7; c > 0; s = 256 * s + t[a], a--, c -= 8);
            for (e = s & (1 << -c) - 1, s >>= -c, c += n; c > 0; e = 256 * e + t[a], a--, c -= 8);
            if (0 === s)s = 1 - u; else {
                if (s === o)return e ? NaN : f ? -E : E;
                e += M(2, n), s -= u
            }
            return (f ? -1 : 1) * e * M(2, s - n)
        }

        function unpackI32(t) {
            return t[3] << 24 | t[2] << 16 | t[1] << 8 | t[0]
        }

        function packI8(t) {
            return [255 & t]
        }

        function packI16(t) {
            return [255 & t, t >> 8 & 255]
        }

        function packI32(t) {
            return [255 & t, t >> 8 & 255, t >> 16 & 255, t >> 24 & 255]
        }

        function packF64(t) {
            return packIEEE754(t, 52, 8)
        }

        function packF32(t) {
            return packIEEE754(t, 23, 4)
        }

        function addGetter(t, n, r) {
            d(t[m], n, {
                get: function () {
                    return this[r]
                }
            })
        }

        function get(t, n, r, e) {
            var i = +r, o = v(i);
            if (o + n > t[N])throw _(b);
            var u = t[k]._b, c = o + t[j], a = u.slice(c, c + n);
            return e ? a : a.reverse()
        }

        function set(t, n, r, e, i, o) {
            var u = +r, c = v(u);
            if (c + n > t[N])throw _(b);
            for (var a = t[k]._b, f = c + t[j], s = e(+i), l = 0; l < n; l++)a[f + l] = s[o ? l : n - l - 1]
        }

        var e = t(40), i = t(29), o = t(60), u = t(123), c = t(42), a = t(93), f = t(35), s = t(6), l = t(116), h = t(118), v = t(115), p = t(77).f, d = t(72).f, y = t(9), g = t(101), m = "prototype", b = "Wrong index!", x = e.ArrayBuffer, S = e.DataView, w = e.Math, _ = e.RangeError, E = e.Infinity, O = x, P = w.abs, M = w.pow, F = w.floor, I = w.log, A = w.LN2, k = i ? "_b" : "buffer", N = i ? "_l" : "byteLength", j = i ? "_o" : "byteOffset";
        if (u.ABV) {
            if (!f(function () {
                    x(1)
                }) || !f(function () {
                    new x(-1)
                }) || f(function () {
                    return new x, new x(1.5), new x(NaN), "ArrayBuffer" != x.name
                })) {
                x = function ArrayBuffer(t) {
                    return s(this, x), new O(v(t))
                };
                for (var T, R = x[m] = O[m], L = p(O), G = 0; L.length > G;)(T = L[G++]) in x || c(x, T, O[T]);
                o || (R.constructor = x)
            }
            var D = new S(new x(2)), C = S[m].setInt8;
            D.setInt8(0, 2147483648), D.setInt8(1, 2147483649), !D.getInt8(0) && D.getInt8(1) || a(S[m], {
                setInt8: function setInt8(t, n) {
                    C.call(this, t, n << 24 >> 24)
                }, setUint8: function setUint8(t, n) {
                    C.call(this, t, n << 24 >> 24)
                }
            }, !0)
        } else x = function ArrayBuffer(t) {
            s(this, x, "ArrayBuffer");
            var n = v(t);
            this._b = y.call(Array(n), 0), this[N] = n
        }, S = function DataView(t, n, r) {
            s(this, S, "DataView"), s(t, x, "DataView");
            var e = t[N], i = l(n);
            if (i < 0 || i > e)throw _("Wrong offset!");
            if (r = void 0 === r ? e - i : h(r), i + r > e)throw _("Wrong length!");
            this[k] = t, this[j] = i, this[N] = r
        }, i && (addGetter(x, "byteLength", "_l"), addGetter(S, "buffer", "_b"), addGetter(S, "byteLength", "_l"), addGetter(S, "byteOffset", "_o")), a(S[m], {
            getInt8: function getInt8(t) {
                return get(this, 1, t)[0] << 24 >> 24
            }, getUint8: function getUint8(t) {
                return get(this, 1, t)[0]
            }, getInt16: function getInt16(t) {
                var n = get(this, 2, t, arguments[1]);
                return (n[1] << 8 | n[0]) << 16 >> 16
            }, getUint16: function getUint16(t) {
                var n = get(this, 2, t, arguments[1]);
                return n[1] << 8 | n[0]
            }, getInt32: function getInt32(t) {
                return unpackI32(get(this, 4, t, arguments[1]))
            }, getUint32: function getUint32(t) {
                return unpackI32(get(this, 4, t, arguments[1])) >>> 0
            }, getFloat32: function getFloat32(t) {
                return unpackIEEE754(get(this, 4, t, arguments[1]), 23, 4)
            }, getFloat64: function getFloat64(t) {
                return unpackIEEE754(get(this, 8, t, arguments[1]), 52, 8)
            }, setInt8: function setInt8(t, n) {
                set(this, 1, t, packI8, n)
            }, setUint8: function setUint8(t, n) {
                set(this, 1, t, packI8, n)
            }, setInt16: function setInt16(t, n) {
                set(this, 2, t, packI16, n, arguments[2])
            }, setUint16: function setUint16(t, n) {
                set(this, 2, t, packI16, n, arguments[2])
            }, setInt32: function setInt32(t, n) {
                set(this, 4, t, packI32, n, arguments[2])
            }, setUint32: function setUint32(t, n) {
                set(this, 4, t, packI32, n, arguments[2])
            }, setFloat32: function setFloat32(t, n) {
                set(this, 4, t, packF32, n, arguments[2])
            }, setFloat64: function setFloat64(t, n) {
                set(this, 8, t, packF64, n, arguments[2])
            }
        });
        g(x, "ArrayBuffer"), g(S, "DataView"), c(S[m], u.VIEW, !0), r.ArrayBuffer = x, r.DataView = S
    }, {
        101: 101,
        115: 115,
        116: 116,
        118: 118,
        123: 123,
        29: 29,
        35: 35,
        40: 40,
        42: 42,
        6: 6,
        60: 60,
        72: 72,
        77: 77,
        9: 9,
        93: 93
    }],
    123: [function (t, n, r) {
        for (var e, i = t(40), o = t(42), u = t(124), c = u("typed_array"), a = u("view"), f = !(!i.ArrayBuffer || !i.DataView), s = f, l = 0, h = "Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array".split(","); l < 9;)(e = i[h[l++]]) ? (o(e.prototype, c, !0), o(e.prototype, a, !0)) : s = !1;
        n.exports = {ABV: f, CONSTR: s, TYPED: c, VIEW: a}
    }, {124: 124, 40: 40, 42: 42}],
    124: [function (t, n, r) {
        var e = 0, i = Math.random();
        n.exports = function (t) {
            return "Symbol(".concat(void 0 === t ? "" : t, ")_", (++e + i).toString(36))
        }
    }, {}],
    125: [function (t, n, r) {
        var e = t(51);
        n.exports = function (t, n) {
            if (!e(t) || t._t !== n)throw TypeError("Incompatible receiver, " + n + " required!");
            return t
        }
    }, {51: 51}],
    126: [function (t, n, r) {
        var e = t(40), i = t(23), o = t(60), u = t(127), c = t(72).f;
        n.exports = function (t) {
            var n = i.Symbol || (i.Symbol = o ? {} : e.Symbol || {});
            "_" == t.charAt(0) || t in n || c(n, t, {value: u.f(t)})
        }
    }, {127: 127, 23: 23, 40: 40, 60: 60, 72: 72}],
    127: [function (t, n, r) {
        r.f = t(128)
    }, {128: 128}],
    128: [function (t, n, r) {
        var e = t(103)("wks"), i = t(124), o = t(40).Symbol, u = "function" == typeof o;
        (n.exports = function (t) {
            return e[t] || (e[t] = u && o[t] || (u ? o : i)("Symbol." + t))
        }).store = e
    }, {103: 103, 124: 124, 40: 40}],
    129: [function (t, n, r) {
        var e = t(17), i = t(128)("iterator"), o = t(58);
        n.exports = t(23).getIteratorMethod = function (t) {
            if (void 0 != t)return t[i] || t["@@iterator"] || o[e(t)]
        }
    }, {128: 128, 17: 17, 23: 23, 58: 58}],
    130: [function (t, n, r) {
        var e = t(33), i = t(95)(/[\\^$*+?.()|[\]{}]/g, "\\$&");
        e(e.S, "RegExp", {
            escape: function escape(t) {
                return i(t)
            }
        })
    }, {33: 33, 95: 95}],
    131: [function (t, n, r) {
        var e = t(33);
        e(e.P, "Array", {copyWithin: t(8)}), t(5)("copyWithin")
    }, {33: 33, 5: 5, 8: 8}],
    132: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(4);
        e(e.P + e.F * !t(105)([].every, !0), "Array", {
            every: function every(t) {
                return i(this, t, arguments[1])
            }
        })
    }, {105: 105, 12: 12, 33: 33}],
    133: [function (t, n, r) {
        var e = t(33);
        e(e.P, "Array", {fill: t(9)}), t(5)("fill")
    }, {33: 33, 5: 5, 9: 9}],
    134: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(2);
        e(e.P + e.F * !t(105)([].filter, !0), "Array", {
            filter: function filter(t) {
                return i(this, t, arguments[1])
            }
        })
    }, {105: 105, 12: 12, 33: 33}],
    135: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(6), o = "findIndex", u = !0;
        o in [] && Array(1)[o](function () {
            u = !1
        }), e(e.P + e.F * u, "Array", {
            findIndex: function findIndex(t) {
                return i(this, t, arguments.length > 1 ? arguments[1] : void 0)
            }
        }), t(5)(o)
    }, {12: 12, 33: 33, 5: 5}],
    136: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(5), o = !0;
        "find" in [] && Array(1).find(function () {
            o = !1
        }), e(e.P + e.F * o, "Array", {
            find: function find(t) {
                return i(this, t, arguments.length > 1 ? arguments[1] : void 0)
            }
        }), t(5)("find")
    }, {12: 12, 33: 33, 5: 5}],
    137: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(0), o = t(105)([].forEach, !0);
        e(e.P + e.F * !o, "Array", {
            forEach: function forEach(t) {
                return i(this, t, arguments[1])
            }
        })
    }, {105: 105, 12: 12, 33: 33}],
    138: [function (t, n, r) {
        "use strict";
        var e = t(25), i = t(33), o = t(119), u = t(53), c = t(48), a = t(118), f = t(24), s = t(129);
        i(i.S + i.F * !t(56)(function (t) {
                Array.from(t)
            }), "Array", {
            from: function from(t) {
                var n, r, i, l, h = o(t), v = "function" == typeof this ? this : Array, p = arguments.length, d = p > 1 ? arguments[1] : void 0, y = void 0 !== d, g = 0, m = s(h);
                if (y && (d = e(d, p > 2 ? arguments[2] : void 0, 2)), void 0 == m || v == Array && c(m))for (n = a(h.length), r = new v(n); n > g; g++)f(r, g, y ? d(h[g], g) : h[g]); else for (l = m.call(h), r = new v; !(i = l.next()).done; g++)f(r, g, y ? u(l, d, [i.value, g], !0) : i.value);
                return r.length = g, r
            }
        })
    }, {118: 118, 119: 119, 129: 129, 24: 24, 25: 25, 33: 33, 48: 48, 53: 53, 56: 56}],
    139: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(11)(!1), o = [].indexOf, u = !!o && 1 / [1].indexOf(1, -0) < 0;
        e(e.P + e.F * (u || !t(105)(o)), "Array", {
            indexOf: function indexOf(t) {
                return u ? o.apply(this, arguments) || 0 : i(this, t, arguments[1])
            }
        })
    }, {105: 105, 11: 11, 33: 33}],
    140: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Array", {isArray: t(49)})
    }, {33: 33, 49: 49}],
    141: [function (t, n, r) {
        "use strict";
        var e = t(5), i = t(57), o = t(58), u = t(117);
        n.exports = t(55)(Array, "Array", function (t, n) {
            this._t = u(t), this._i = 0, this._k = n
        }, function () {
            var t = this._t, n = this._k, r = this._i++;
            return !t || r >= t.length ? (this._t = void 0, i(1)) : "keys" == n ? i(0, r) : "values" == n ? i(0, t[r]) : i(0, [r, t[r]])
        }, "values"), o.Arguments = o.Array, e("keys"), e("values"), e("entries")
    }, {117: 117, 5: 5, 55: 55, 57: 57, 58: 58}],
    142: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(117), o = [].join;
        e(e.P + e.F * (t(47) != Object || !t(105)(o)), "Array", {
            join: function join(t) {
                return o.call(i(this), void 0 === t ? "," : t)
            }
        })
    }, {105: 105, 117: 117, 33: 33, 47: 47}],
    143: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(117), o = t(116), u = t(118), c = [].lastIndexOf, a = !!c && 1 / [1].lastIndexOf(1, -0) < 0;
        e(e.P + e.F * (a || !t(105)(c)), "Array", {
            lastIndexOf: function lastIndexOf(t) {
                if (a)return c.apply(this, arguments) || 0;
                var n = i(this), r = u(n.length), e = r - 1;
                for (arguments.length > 1 && (e = Math.min(e, o(arguments[1]))), e < 0 && (e = r + e); e >= 0; e--)if (e in n && n[e] === t)return e || 0;
                return -1
            }
        })
    }, {105: 105, 116: 116, 117: 117, 118: 118, 33: 33}],
    144: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(1);
        e(e.P + e.F * !t(105)([].map, !0), "Array", {
            map: function map(t) {
                return i(this, t, arguments[1])
            }
        })
    }, {105: 105, 12: 12, 33: 33}],
    145: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(24);
        e(e.S + e.F * t(35)(function () {
                function F() {
                }

                return !(Array.of.call(F) instanceof F)
            }), "Array", {
            of: function of() {
                for (var t = 0, n = arguments.length, r = new ("function" == typeof this ? this : Array)(n); n > t;)i(r, t, arguments[t++]);
                return r.length = n, r
            }
        })
    }, {24: 24, 33: 33, 35: 35}],
    146: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(13);
        e(e.P + e.F * !t(105)([].reduceRight, !0), "Array", {
            reduceRight: function reduceRight(t) {
                return i(this, t, arguments.length, arguments[1], !0)
            }
        })
    }, {105: 105, 13: 13, 33: 33}],
    147: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(13);
        e(e.P + e.F * !t(105)([].reduce, !0), "Array", {
            reduce: function reduce(t) {
                return i(this, t, arguments.length, arguments[1], !1)
            }
        })
    }, {105: 105, 13: 13, 33: 33}],
    148: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(43), o = t(18), u = t(114), c = t(118), a = [].slice;
        e(e.P + e.F * t(35)(function () {
                i && a.call(i)
            }), "Array", {
            slice: function slice(t, n) {
                var r = c(this.length), e = o(this);
                if (n = void 0 === n ? r : n, "Array" == e)return a.call(this, t, n);
                for (var i = u(t, r), f = u(n, r), s = c(f - i), l = Array(s), h = 0; h < s; h++)l[h] = "String" == e ? this.charAt(i + h) : this[i + h];
                return l
            }
        })
    }, {114: 114, 118: 118, 18: 18, 33: 33, 35: 35, 43: 43}],
    149: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(12)(3);
        e(e.P + e.F * !t(105)([].some, !0), "Array", {
            some: function some(t) {
                return i(this, t, arguments[1])
            }
        })
    }, {105: 105, 12: 12, 33: 33}],
    150: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(3), o = t(119), u = t(35), c = [].sort, a = [1, 2, 3];
        e(e.P + e.F * (u(function () {
                a.sort(void 0)
            }) || !u(function () {
                a.sort(null)
            }) || !t(105)(c)), "Array", {
            sort: function sort(t) {
                return void 0 === t ? c.call(o(this)) : c.call(o(this), i(t))
            }
        })
    }, {105: 105, 119: 119, 3: 3, 33: 33, 35: 35}],
    151: [function (t, n, r) {
        t(100)("Array")
    }, {100: 100}],
    152: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Date", {
            now: function () {
                return (new Date).getTime()
            }
        })
    }, {33: 33}],
    153: [function (t, n, r) {
        var e = t(33), i = t(26);
        e(e.P + e.F * (Date.prototype.toISOString !== i), "Date", {toISOString: i})
    }, {26: 26, 33: 33}],
    154: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(119), o = t(120);
        e(e.P + e.F * t(35)(function () {
                return null !== new Date(NaN).toJSON() || 1 !== Date.prototype.toJSON.call({
                        toISOString: function () {
                            return 1
                        }
                    })
            }), "Date", {
            toJSON: function toJSON(t) {
                var n = i(this), r = o(n);
                return "number" != typeof r || isFinite(r) ? n.toISOString() : null
            }
        })
    }, {119: 119, 120: 120, 33: 33, 35: 35}],
    155: [function (t, n, r) {
        var e = t(128)("toPrimitive"), i = Date.prototype;
        e in i || t(42)(i, e, t(27))
    }, {128: 128, 27: 27, 42: 42}],
    156: [function (t, n, r) {
        var e = Date.prototype, i = e.toString, o = e.getTime;
        new Date(NaN) + "" != "Invalid Date" && t(94)(e, "toString", function toString() {
            var t = o.call(this);
            return t === t ? i.call(this) : "Invalid Date"
        })
    }, {94: 94}],
    157: [function (t, n, r) {
        var e = t(33);
        e(e.P, "Function", {bind: t(16)})
    }, {16: 16, 33: 33}],
    158: [function (t, n, r) {
        "use strict";
        var e = t(51), i = t(79), o = t(128)("hasInstance"), u = Function.prototype;
        o in u || t(72).f(u, o, {
            value: function (t) {
                if ("function" != typeof this || !e(t))return !1;
                if (!e(this.prototype))return t instanceof this;
                for (; t = i(t);)if (this.prototype === t)return !0;
                return !1
            }
        })
    }, {128: 128, 51: 51, 72: 72, 79: 79}],
    159: [function (t, n, r) {
        var e = t(72).f, i = Function.prototype, o = /^\s*function ([^ (]*)/;
        "name" in i || t(29) && e(i, "name", {
            configurable: !0, get: function () {
                try {
                    return ("" + this).match(o)[1]
                } catch (t) {
                    return ""
                }
            }
        })
    }, {29: 29, 72: 72}],
    160: [function (t, n, r) {
        "use strict";
        var e = t(19), i = t(125);
        n.exports = t(22)("Map", function (t) {
            return function Map() {
                return t(this, arguments.length > 0 ? arguments[0] : void 0)
            }
        }, {
            get: function get(t) {
                var n = e.getEntry(i(this, "Map"), t);
                return n && n.v
            }, set: function set(t, n) {
                return e.def(i(this, "Map"), 0 === t ? 0 : t, n)
            }
        }, e, !0)
    }, {125: 125, 19: 19, 22: 22}],
    161: [function (t, n, r) {
        var e = t(33), i = t(63), o = Math.sqrt, u = Math.acosh;
        e(e.S + e.F * !(u && 710 == Math.floor(u(Number.MAX_VALUE)) && u(1 / 0) == 1 / 0), "Math", {
            acosh: function acosh(t) {
                return (t = +t) < 1 ? NaN : t > 94906265.62425156 ? Math.log(t) + Math.LN2 : i(t - 1 + o(t - 1) * o(t + 1))
            }
        })
    }, {33: 33, 63: 63}],
    162: [function (t, n, r) {
        function asinh(t) {
            return isFinite(t = +t) && 0 != t ? t < 0 ? -asinh(-t) : Math.log(t + Math.sqrt(t * t + 1)) : t
        }

        var e = t(33), i = Math.asinh;
        e(e.S + e.F * !(i && 1 / i(0) > 0), "Math", {asinh: asinh})
    }, {33: 33}],
    163: [function (t, n, r) {
        var e = t(33), i = Math.atanh;
        e(e.S + e.F * !(i && 1 / i(-0) < 0), "Math", {
            atanh: function atanh(t) {
                return 0 == (t = +t) ? t : Math.log((1 + t) / (1 - t)) / 2
            }
        })
    }, {33: 33}],
    164: [function (t, n, r) {
        var e = t(33), i = t(65);
        e(e.S, "Math", {
            cbrt: function cbrt(t) {
                return i(t = +t) * Math.pow(Math.abs(t), 1 / 3)
            }
        })
    }, {33: 33, 65: 65}],
    165: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            clz32: function clz32(t) {
                return (t >>>= 0) ? 31 - Math.floor(Math.log(t + .5) * Math.LOG2E) : 32
            }
        })
    }, {33: 33}],
    166: [function (t, n, r) {
        var e = t(33), i = Math.exp;
        e(e.S, "Math", {
            cosh: function cosh(t) {
                return (i(t = +t) + i(-t)) / 2
            }
        })
    }, {33: 33}],
    167: [function (t, n, r) {
        var e = t(33), i = t(61);
        e(e.S + e.F * (i != Math.expm1), "Math", {expm1: i})
    }, {33: 33, 61: 61}],
    168: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {fround: t(62)})
    }, {33: 33, 62: 62}],
    169: [function (t, n, r) {
        var e = t(33), i = Math.abs;
        e(e.S, "Math", {
            hypot: function hypot(t, n) {
                for (var r, e, o = 0, u = 0, c = arguments.length, a = 0; u < c;)r = i(arguments[u++]), a < r ? (e = a / r, o = o * e * e + 1, a = r) : r > 0 ? (e = r / a, o += e * e) : o += r;
                return a === 1 / 0 ? 1 / 0 : a * Math.sqrt(o)
            }
        })
    }, {33: 33}],
    170: [function (t, n, r) {
        var e = t(33), i = Math.imul;
        e(e.S + e.F * t(35)(function () {
                return -5 != i(4294967295, 5) || 2 != i.length
            }), "Math", {
            imul: function imul(t, n) {
                var r = +t, e = +n, i = 65535 & r, o = 65535 & e;
                return 0 | i * o + ((65535 & r >>> 16) * o + i * (65535 & e >>> 16) << 16 >>> 0)
            }
        })
    }, {33: 33, 35: 35}],
    171: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            log10: function log10(t) {
                return Math.log(t) * Math.LOG10E
            }
        })
    }, {33: 33}],
    172: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {log1p: t(63)})
    }, {33: 33, 63: 63}],
    173: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            log2: function log2(t) {
                return Math.log(t) / Math.LN2
            }
        })
    }, {33: 33}],
    174: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {sign: t(65)})
    }, {33: 33, 65: 65}],
    175: [function (t, n, r) {
        var e = t(33), i = t(61), o = Math.exp;
        e(e.S + e.F * t(35)(function () {
                return -2e-17 != !Math.sinh(-2e-17)
            }), "Math", {
            sinh: function sinh(t) {
                return Math.abs(t = +t) < 1 ? (i(t) - i(-t)) / 2 : (o(t - 1) - o(-t - 1)) * (Math.E / 2)
            }
        })
    }, {33: 33, 35: 35, 61: 61}],
    176: [function (t, n, r) {
        var e = t(33), i = t(61), o = Math.exp;
        e(e.S, "Math", {
            tanh: function tanh(t) {
                var n = i(t = +t), r = i(-t);
                return n == 1 / 0 ? 1 : r == 1 / 0 ? -1 : (n - r) / (o(t) + o(-t))
            }
        })
    }, {33: 33, 61: 61}],
    177: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            trunc: function trunc(t) {
                return (t > 0 ? Math.floor : Math.ceil)(t)
            }
        })
    }, {33: 33}],
    178: [function (t, n, r) {
        "use strict";
        var e = t(40), i = t(41), o = t(18), u = t(45), c = t(120), a = t(35), f = t(77).f, s = t(75).f, l = t(72).f, h = t(111).trim, v = e.Number, p = v, d = v.prototype, y = "Number" == o(t(71)(d)), g = "trim" in String.prototype, m = function (t) {
            var n = c(t, !1);
            if ("string" == typeof n && n.length > 2) {
                n = g ? n.trim() : h(n, 3);
                var r, e, i, o = n.charCodeAt(0);
                if (43 === o || 45 === o) {
                    if (88 === (r = n.charCodeAt(2)) || 120 === r)return NaN
                } else if (48 === o) {
                    switch (n.charCodeAt(1)) {
                        case 66:
                        case 98:
                            e = 2, i = 49;
                            break;
                        case 79:
                        case 111:
                            e = 8, i = 55;
                            break;
                        default:
                            return +n
                    }
                    for (var u, a = n.slice(2), f = 0, s = a.length; f < s; f++)if ((u = a.charCodeAt(f)) < 48 || u > i)return NaN;
                    return parseInt(a, e)
                }
            }
            return +n
        };
        if (!v(" 0o1") || !v("0b1") || v("+0x1")) {
            v = function Number(t) {
                var n = arguments.length < 1 ? 0 : t, r = this;
                return r instanceof v && (y ? a(function () {
                    d.valueOf.call(r)
                }) : "Number" != o(r)) ? u(new p(m(n)), r, v) : m(n)
            };
            for (var b, x = t(29) ? f(p) : "MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger".split(","), S = 0; x.length > S; S++)i(p, b = x[S]) && !i(v, b) && l(v, b, s(p, b));
            v.prototype = d, d.constructor = v, t(94)(e, "Number", v)
        }
    }, {111: 111, 120: 120, 18: 18, 29: 29, 35: 35, 40: 40, 41: 41, 45: 45, 71: 71, 72: 72, 75: 75, 77: 77, 94: 94}],
    179: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Number", {EPSILON: Math.pow(2, -52)})
    }, {33: 33}],
    180: [function (t, n, r) {
        var e = t(33), i = t(40).isFinite;
        e(e.S, "Number", {
            isFinite: function isFinite(t) {
                return "number" == typeof t && i(t)
            }
        })
    }, {33: 33, 40: 40}],
    181: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Number", {isInteger: t(50)})
    }, {33: 33, 50: 50}],
    182: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Number", {
            isNaN: function isNaN(t) {
                return t != t
            }
        })
    }, {33: 33}],
    183: [function (t, n, r) {
        var e = t(33), i = t(50), o = Math.abs;
        e(e.S, "Number", {
            isSafeInteger: function isSafeInteger(t) {
                return i(t) && o(t) <= 9007199254740991
            }
        })
    }, {33: 33, 50: 50}],
    184: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Number", {MAX_SAFE_INTEGER: 9007199254740991})
    }, {33: 33}],
    185: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Number", {MIN_SAFE_INTEGER: -9007199254740991})
    }, {33: 33}],
    186: [function (t, n, r) {
        var e = t(33), i = t(86);
        e(e.S + e.F * (Number.parseFloat != i), "Number", {parseFloat: i})
    }, {33: 33, 86: 86}],
    187: [function (t, n, r) {
        var e = t(33), i = t(87);
        e(e.S + e.F * (Number.parseInt != i), "Number", {parseInt: i})
    }, {33: 33, 87: 87}],
    188: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(116), o = t(4), u = t(110), c = 1..toFixed, a = Math.floor, f = [0, 0, 0, 0, 0, 0], s = "Number.toFixed: incorrect invocation!", l = function (t, n) {
            for (var r = -1, e = n; ++r < 6;)e += t * f[r], f[r] = e % 1e7, e = a(e / 1e7)
        }, h = function (t) {
            for (var n = 6, r = 0; --n >= 0;)r += f[n], f[n] = a(r / t), r = r % t * 1e7
        }, v = function () {
            for (var t = 6, n = ""; --t >= 0;)if ("" !== n || 0 === t || 0 !== f[t]) {
                var r = String(f[t]);
                n = "" === n ? r : n + u.call("0", 7 - r.length) + r
            }
            return n
        }, p = function (t, n, r) {
            return 0 === n ? r : n % 2 == 1 ? p(t, n - 1, r * t) : p(t * t, n / 2, r)
        }, d = function (t) {
            for (var n = 0, r = t; r >= 4096;)n += 12, r /= 4096;
            for (; r >= 2;)n += 1, r /= 2;
            return n
        };
        e(e.P + e.F * (!!c && ("0.000" !== 8e-5.toFixed(3) || "1" !== .9.toFixed(0) || "1.25" !== 1.255.toFixed(2) || "1000000000000000128" !== (0xde0b6b3a7640080).toFixed(0)) || !t(35)(function () {
                c.call({})
            })), "Number", {
            toFixed: function toFixed(t) {
                var n, r, e, c, a = o(this, s), f = i(t), y = "", g = "0";
                if (f < 0 || f > 20)throw RangeError(s);
                if (a != a)return "NaN";
                if (a <= -1e21 || a >= 1e21)return String(a);
                if (a < 0 && (y = "-", a = -a), a > 1e-21)if (n = d(a * p(2, 69, 1)) - 69, r = n < 0 ? a * p(2, -n, 1) : a / p(2, n, 1), r *= 4503599627370496, (n = 52 - n) > 0) {
                    for (l(0, r), e = f; e >= 7;)l(1e7, 0), e -= 7;
                    for (l(p(10, e, 1), 0), e = n - 1; e >= 23;)h(1 << 23), e -= 23;
                    h(1 << e), l(1, 1), h(2), g = v()
                } else l(0, r), l(1 << -n, 0), g = v() + u.call("0", f);
                return f > 0 ? (c = g.length, g = y + (c <= f ? "0." + u.call("0", f - c) + g : g.slice(0, c - f) + "." + g.slice(c - f))) : g = y + g, g
            }
        })
    }, {110: 110, 116: 116, 33: 33, 35: 35, 4: 4}],
    189: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(35), o = t(4), u = 1..toPrecision;
        e(e.P + e.F * (i(function () {
                return "1" !== u.call(1, void 0)
            }) || !i(function () {
                u.call({})
            })), "Number", {
            toPrecision: function toPrecision(t) {
                var n = o(this, "Number#toPrecision: incorrect invocation!");
                return void 0 === t ? u.call(n) : u.call(n, t)
            }
        })
    }, {33: 33, 35: 35, 4: 4}],
    190: [function (t, n, r) {
        var e = t(33);
        e(e.S + e.F, "Object", {assign: t(70)})
    }, {33: 33, 70: 70}],
    191: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Object", {create: t(71)})
    }, {33: 33, 71: 71}],
    192: [function (t, n, r) {
        var e = t(33);
        e(e.S + e.F * !t(29), "Object", {defineProperties: t(73)})
    }, {29: 29, 33: 33, 73: 73}],
    193: [function (t, n, r) {
        var e = t(33);
        e(e.S + e.F * !t(29), "Object", {defineProperty: t(72).f})
    }, {29: 29, 33: 33, 72: 72}],
    194: [function (t, n, r) {
        var e = t(51), i = t(66).onFreeze;
        t(83)("freeze", function (t) {
            return function freeze(n) {
                return t && e(n) ? t(i(n)) : n
            }
        })
    }, {51: 51, 66: 66, 83: 83}],
    195: [function (t, n, r) {
        var e = t(117), i = t(75).f;
        t(83)("getOwnPropertyDescriptor", function () {
            return function getOwnPropertyDescriptor(t, n) {
                return i(e(t), n)
            }
        })
    }, {117: 117, 75: 75, 83: 83}],
    196: [function (t, n, r) {
        t(83)("getOwnPropertyNames", function () {
            return t(76).f
        })
    }, {76: 76, 83: 83}],
    197: [function (t, n, r) {
        var e = t(119), i = t(79);
        t(83)("getPrototypeOf", function () {
            return function getPrototypeOf(t) {
                return i(e(t))
            }
        })
    }, {119: 119, 79: 79, 83: 83}],
    198: [function (t, n, r) {
        var e = t(51);
        t(83)("isExtensible", function (t) {
            return function isExtensible(n) {
                return !!e(n) && (!t || t(n))
            }
        })
    }, {51: 51, 83: 83}],
    199: [function (t, n, r) {
        var e = t(51);
        t(83)("isFrozen", function (t) {
            return function isFrozen(n) {
                return !e(n) || !!t && t(n)
            }
        })
    }, {51: 51, 83: 83}],
    200: [function (t, n, r) {
        var e = t(51);
        t(83)("isSealed", function (t) {
            return function isSealed(n) {
                return !e(n) || !!t && t(n)
            }
        })
    }, {51: 51, 83: 83}],
    201: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Object", {is: t(96)})
    }, {33: 33, 96: 96}],
    202: [function (t, n, r) {
        var e = t(119), i = t(81);
        t(83)("keys", function () {
            return function keys(t) {
                return i(e(t))
            }
        })
    }, {119: 119, 81: 81, 83: 83}],
    203: [function (t, n, r) {
        var e = t(51), i = t(66).onFreeze;
        t(83)("preventExtensions", function (t) {
            return function preventExtensions(n) {
                return t && e(n) ? t(i(n)) : n
            }
        })
    }, {51: 51, 66: 66, 83: 83}],
    204: [function (t, n, r) {
        var e = t(51), i = t(66).onFreeze;
        t(83)("seal", function (t) {
            return function seal(n) {
                return t && e(n) ? t(i(n)) : n
            }
        })
    }, {51: 51, 66: 66, 83: 83}],
    205: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Object", {setPrototypeOf: t(99).set})
    }, {33: 33, 99: 99}],
    206: [function (t, n, r) {
        "use strict";
        var e = t(17), i = {};
        i[t(128)("toStringTag")] = "z", i + "" != "[object z]" && t(94)(Object.prototype, "toString", function toString() {
            return "[object " + e(this) + "]"
        }, !0)
    }, {128: 128, 17: 17, 94: 94}],
    207: [function (t, n, r) {
        var e = t(33), i = t(86);
        e(e.G + e.F * (parseFloat != i), {parseFloat: i})
    }, {33: 33, 86: 86}],
    208: [function (t, n, r) {
        var e = t(33), i = t(87);
        e(e.G + e.F * (parseInt != i), {parseInt: i})
    }, {33: 33, 87: 87}],
    209: [function (t, n, r) {
        "use strict";
        var e, i, o, u, c = t(60), a = t(40), f = t(25), s = t(17), l = t(33), h = t(51), v = t(3), p = t(6), d = t(39), y = t(104), g = t(113).set, m = t(68)(), b = t(69), x = t(90), S = t(91), w = a.TypeError, _ = a.process, E = a.Promise, O = "process" == s(_), P = function () {
        }, M = i = b.f, F = !!function () {
            try {
                var n = E.resolve(1), r = (n.constructor = {})[t(128)("species")] = function (t) {
                    t(P, P)
                };
                return (O || "function" == typeof PromiseRejectionEvent) && n.then(P) instanceof r
            } catch (t) {
            }
        }(), I = c ? function (t, n) {
            return t === n || t === E && n === u
        } : function (t, n) {
            return t === n
        }, A = function (t) {
            var n;
            return !(!h(t) || "function" != typeof(n = t.then)) && n
        }, k = function (t, n) {
            if (!t._n) {
                t._n = !0;
                var r = t._c;
                m(function () {
                    for (var e = t._v, i = 1 == t._s, o = 0; r.length > o;)!function (n) {
                        var r, o, u = i ? n.ok : n.fail, c = n.resolve, a = n.reject, f = n.domain;
                        try {
                            u ? (i || (2 == t._h && T(t), t._h = 1), !0 === u ? r = e : (f && f.enter(), r = u(e), f && f.exit()), r === n.promise ? a(w("Promise-chain cycle")) : (o = A(r)) ? o.call(r, c, a) : c(r)) : a(e)
                        } catch (t) {
                            a(t)
                        }
                    }(r[o++]);
                    t._c = [], t._n = !1, n && !t._h && N(t)
                })
            }
        }, N = function (t) {
            g.call(a, function () {
                var n, r, e, i = t._v, o = j(t);
                if (o && (n = x(function () {
                        O ? _.emit("unhandledRejection", i, t) : (r = a.onunhandledrejection) ? r({
                            promise: t,
                            reason: i
                        }) : (e = a.console) && e.error && e.error("Unhandled promise rejection", i)
                    }), t._h = O || j(t) ? 2 : 1), t._a = void 0, o && n.e)throw n.v
            })
        }, j = function (t) {
            if (1 == t._h)return !1;
            for (var n, r = t._a || t._c, e = 0; r.length > e;)if (n = r[e++], n.fail || !j(n.promise))return !1;
            return !0
        }, T = function (t) {
            g.call(a, function () {
                var n;
                O ? _.emit("rejectionHandled", t) : (n = a.onrejectionhandled) && n({promise: t, reason: t._v})
            })
        }, R = function (t) {
            var n = this;
            n._d || (n._d = !0, n = n._w || n, n._v = t, n._s = 2, n._a || (n._a = n._c.slice()), k(n, !0))
        }, L = function (t) {
            var n, r = this;
            if (!r._d) {
                r._d = !0, r = r._w || r;
                try {
                    if (r === t)throw w("Promise can't be resolved itself");
                    (n = A(t)) ? m(function () {
                        var e = {_w: r, _d: !1};
                        try {
                            n.call(t, f(L, e, 1), f(R, e, 1))
                        } catch (t) {
                            R.call(e, t)
                        }
                    }) : (r._v = t, r._s = 1, k(r, !1))
                } catch (t) {
                    R.call({_w: r, _d: !1}, t)
                }
            }
        };
        F || (E = function Promise(t) {
            p(this, E, "Promise", "_h"), v(t), e.call(this);
            try {
                t(f(L, this, 1), f(R, this, 1))
            } catch (t) {
                R.call(this, t)
            }
        }, e = function Promise(t) {
            this._c = [], this._a = void 0, this._s = 0, this._d = !1, this._v = void 0, this._h = 0, this._n = !1
        }, e.prototype = t(93)(E.prototype, {
            then: function then(t, n) {
                var r = M(y(this, E));
                return r.ok = "function" != typeof t || t, r.fail = "function" == typeof n && n, r.domain = O ? _.domain : void 0, this._c.push(r), this._a && this._a.push(r), this._s && k(this, !1), r.promise
            }, catch: function (t) {
                return this.then(void 0, t)
            }
        }), o = function () {
            var t = new e;
            this.promise = t, this.resolve = f(L, t, 1), this.reject = f(R, t, 1)
        }, b.f = M = function (t) {
            return I(E, t) ? new o(t) : i(t)
        }), l(l.G + l.W + l.F * !F, {Promise: E}), t(101)(E, "Promise"), t(100)("Promise"), u = t(23).Promise, l(l.S + l.F * !F, "Promise", {
            reject: function reject(t) {
                var n = M(this);
                return (0, n.reject)(t), n.promise
            }
        }), l(l.S + l.F * (c || !F), "Promise", {
            resolve: function resolve(t) {
                return t instanceof E && I(t.constructor, this) ? t : S(this, t)
            }
        }), l(l.S + l.F * !(F && t(56)(function (t) {
                E.all(t).catch(P)
            })), "Promise", {
            all: function all(t) {
                var n = this, r = M(n), e = r.resolve, i = r.reject, o = x(function () {
                    var r = [], o = 0, u = 1;
                    d(t, !1, function (t) {
                        var c = o++, a = !1;
                        r.push(void 0), u++, n.resolve(t).then(function (t) {
                            a || (a = !0, r[c] = t, --u || e(r))
                        }, i)
                    }), --u || e(r)
                });
                return o.e && i(o.v), r.promise
            }, race: function race(t) {
                var n = this, r = M(n), e = r.reject, i = x(function () {
                    d(t, !1, function (t) {
                        n.resolve(t).then(r.resolve, e)
                    })
                });
                return i.e && e(i.v), r.promise
            }
        })
    }, {
        100: 100, 101: 101, 104: 104, 113: 113, 128: 128, 17: 17, 23: 23, 25: 25,
        3: 3, 33: 33, 39: 39, 40: 40, 51: 51, 56: 56, 6: 6, 60: 60, 68: 68, 69: 69, 90: 90, 91: 91, 93: 93
    }],
    210: [function (t, n, r) {
        var e = t(33), i = t(3), o = t(7), u = (t(40).Reflect || {}).apply, c = Function.apply;
        e(e.S + e.F * !t(35)(function () {
                u(function () {
                })
            }), "Reflect", {
            apply: function apply(t, n, r) {
                var e = i(t), a = o(r);
                return u ? u(e, n, a) : c.call(e, n, a)
            }
        })
    }, {3: 3, 33: 33, 35: 35, 40: 40, 7: 7}],
    211: [function (t, n, r) {
        var e = t(33), i = t(71), o = t(3), u = t(7), c = t(51), a = t(35), f = t(16), s = (t(40).Reflect || {}).construct, l = a(function () {
            function F() {
            }

            return !(s(function () {
            }, [], F) instanceof F)
        }), h = !a(function () {
            s(function () {
            })
        });
        e(e.S + e.F * (l || h), "Reflect", {
            construct: function construct(t, n) {
                o(t), u(n);
                var r = arguments.length < 3 ? t : o(arguments[2]);
                if (h && !l)return s(t, n, r);
                if (t == r) {
                    switch (n.length) {
                        case 0:
                            return new t;
                        case 1:
                            return new t(n[0]);
                        case 2:
                            return new t(n[0], n[1]);
                        case 3:
                            return new t(n[0], n[1], n[2]);
                        case 4:
                            return new t(n[0], n[1], n[2], n[3])
                    }
                    var e = [null];
                    return e.push.apply(e, n), new (f.apply(t, e))
                }
                var a = r.prototype, v = i(c(a) ? a : Object.prototype), p = Function.apply.call(t, v, n);
                return c(p) ? p : v
            }
        })
    }, {16: 16, 3: 3, 33: 33, 35: 35, 40: 40, 51: 51, 7: 7, 71: 71}],
    212: [function (t, n, r) {
        var e = t(72), i = t(33), o = t(7), u = t(120);
        i(i.S + i.F * t(35)(function () {
                Reflect.defineProperty(e.f({}, 1, {value: 1}), 1, {value: 2})
            }), "Reflect", {
            defineProperty: function defineProperty(t, n, r) {
                o(t), n = u(n, !0), o(r);
                try {
                    return e.f(t, n, r), !0
                } catch (t) {
                    return !1
                }
            }
        })
    }, {120: 120, 33: 33, 35: 35, 7: 7, 72: 72}],
    213: [function (t, n, r) {
        var e = t(33), i = t(75).f, o = t(7);
        e(e.S, "Reflect", {
            deleteProperty: function deleteProperty(t, n) {
                var r = i(o(t), n);
                return !(r && !r.configurable) && delete t[n]
            }
        })
    }, {33: 33, 7: 7, 75: 75}],
    214: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(7), o = function (t) {
            this._t = i(t), this._i = 0;
            var n, r = this._k = [];
            for (n in t)r.push(n)
        };
        t(54)(o, "Object", function () {
            var t, n = this, r = n._k;
            do {
                if (n._i >= r.length)return {value: void 0, done: !0}
            } while (!((t = r[n._i++]) in n._t));
            return {value: t, done: !1}
        }), e(e.S, "Reflect", {
            enumerate: function enumerate(t) {
                return new o(t)
            }
        })
    }, {33: 33, 54: 54, 7: 7}],
    215: [function (t, n, r) {
        var e = t(75), i = t(33), o = t(7);
        i(i.S, "Reflect", {
            getOwnPropertyDescriptor: function getOwnPropertyDescriptor(t, n) {
                return e.f(o(t), n)
            }
        })
    }, {33: 33, 7: 7, 75: 75}],
    216: [function (t, n, r) {
        var e = t(33), i = t(79), o = t(7);
        e(e.S, "Reflect", {
            getPrototypeOf: function getPrototypeOf(t) {
                return i(o(t))
            }
        })
    }, {33: 33, 7: 7, 79: 79}],
    217: [function (t, n, r) {
        function get(t, n) {
            var r, u, f = arguments.length < 3 ? t : arguments[2];
            return a(t) === f ? t[n] : (r = e.f(t, n)) ? o(r, "value") ? r.value : void 0 !== r.get ? r.get.call(f) : void 0 : c(u = i(t)) ? get(u, n, f) : void 0
        }

        var e = t(75), i = t(79), o = t(41), u = t(33), c = t(51), a = t(7);
        u(u.S, "Reflect", {get: get})
    }, {33: 33, 41: 41, 51: 51, 7: 7, 75: 75, 79: 79}],
    218: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Reflect", {
            has: function has(t, n) {
                return n in t
            }
        })
    }, {33: 33}],
    219: [function (t, n, r) {
        var e = t(33), i = t(7), o = Object.isExtensible;
        e(e.S, "Reflect", {
            isExtensible: function isExtensible(t) {
                return i(t), !o || o(t)
            }
        })
    }, {33: 33, 7: 7}],
    220: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Reflect", {ownKeys: t(85)})
    }, {33: 33, 85: 85}],
    221: [function (t, n, r) {
        var e = t(33), i = t(7), o = Object.preventExtensions;
        e(e.S, "Reflect", {
            preventExtensions: function preventExtensions(t) {
                i(t);
                try {
                    return o && o(t), !0
                } catch (t) {
                    return !1
                }
            }
        })
    }, {33: 33, 7: 7}],
    222: [function (t, n, r) {
        var e = t(33), i = t(99);
        i && e(e.S, "Reflect", {
            setPrototypeOf: function setPrototypeOf(t, n) {
                i.check(t, n);
                try {
                    return i.set(t, n), !0
                } catch (t) {
                    return !1
                }
            }
        })
    }, {33: 33, 99: 99}],
    223: [function (t, n, r) {
        function set(t, n, r) {
            var c, l, h = arguments.length < 4 ? t : arguments[3], v = i.f(f(t), n);
            if (!v) {
                if (s(l = o(t)))return set(l, n, r, h);
                v = a(0)
            }
            return u(v, "value") ? !(!1 === v.writable || !s(h)) && (c = i.f(h, n) || a(0), c.value = r, e.f(h, n, c), !0) : void 0 !== v.set && (v.set.call(h, r), !0)
        }

        var e = t(72), i = t(75), o = t(79), u = t(41), c = t(33), a = t(92), f = t(7), s = t(51);
        c(c.S, "Reflect", {set: set})
    }, {33: 33, 41: 41, 51: 51, 7: 7, 72: 72, 75: 75, 79: 79, 92: 92}],
    224: [function (t, n, r) {
        var e = t(40), i = t(45), o = t(72).f, u = t(77).f, c = t(52), a = t(37), f = e.RegExp, s = f, l = f.prototype, h = /a/g, v = /a/g, p = new f(h) !== h;
        if (t(29) && (!p || t(35)(function () {
                return v[t(128)("match")] = !1, f(h) != h || f(v) == v || "/a/i" != f(h, "i")
            }))) {
            f = function RegExp(t, n) {
                var r = this instanceof f, e = c(t), o = void 0 === n;
                return !r && e && t.constructor === f && o ? t : i(p ? new s(e && !o ? t.source : t, n) : s((e = t instanceof f) ? t.source : t, e && o ? a.call(t) : n), r ? this : l, f)
            };
            for (var d = u(s), y = 0; d.length > y;)!function (t) {
                t in f || o(f, t, {
                    configurable: !0, get: function () {
                        return s[t]
                    }, set: function (n) {
                        s[t] = n
                    }
                })
            }(d[y++]);
            l.constructor = f, f.prototype = l, t(94)(e, "RegExp", f)
        }
        t(100)("RegExp")
    }, {100: 100, 128: 128, 29: 29, 35: 35, 37: 37, 40: 40, 45: 45, 52: 52, 72: 72, 77: 77, 94: 94}],
    225: [function (t, n, r) {
        t(29) && "g" != /./g.flags && t(72).f(RegExp.prototype, "flags", {configurable: !0, get: t(37)})
    }, {29: 29, 37: 37, 72: 72}],
    226: [function (t, n, r) {
        t(36)("match", 1, function (t, n, r) {
            return [function match(r) {
                "use strict";
                var e = t(this), i = void 0 == r ? void 0 : r[n];
                return void 0 !== i ? i.call(r, e) : new RegExp(r)[n](String(e))
            }, r]
        })
    }, {36: 36}],
    227: [function (t, n, r) {
        t(36)("replace", 2, function (t, n, r) {
            return [function replace(e, i) {
                "use strict";
                var o = t(this), u = void 0 == e ? void 0 : e[n];
                return void 0 !== u ? u.call(e, o, i) : r.call(String(o), e, i)
            }, r]
        })
    }, {36: 36}],
    228: [function (t, n, r) {
        t(36)("search", 1, function (t, n, r) {
            return [function search(r) {
                "use strict";
                var e = t(this), i = void 0 == r ? void 0 : r[n];
                return void 0 !== i ? i.call(r, e) : new RegExp(r)[n](String(e))
            }, r]
        })
    }, {36: 36}],
    229: [function (t, n, r) {
        t(36)("split", 2, function (n, r, e) {
            "use strict";
            var i = t(52), o = e, u = [].push, c = "length";
            if ("c" == "abbc".split(/(b)*/)[1] || 4 != "test".split(/(?:)/, -1)[c] || 2 != "ab".split(/(?:ab)*/)[c] || 4 != ".".split(/(.?)(.?)/)[c] || ".".split(/()()/)[c] > 1 || "".split(/.?/)[c]) {
                var a = void 0 === /()??/.exec("")[1];
                e = function (t, n) {
                    var r = String(this);
                    if (void 0 === t && 0 === n)return [];
                    if (!i(t))return o.call(r, t, n);
                    var e, f, s, l, h, v = [], p = (t.ignoreCase ? "i" : "") + (t.multiline ? "m" : "") + (t.unicode ? "u" : "") + (t.sticky ? "y" : ""), d = 0, y = void 0 === n ? 4294967295 : n >>> 0, g = new RegExp(t.source, p + "g");
                    for (a || (e = new RegExp("^" + g.source + "$(?!\\s)", p)); (f = g.exec(r)) && !((s = f.index + f[0][c]) > d && (v.push(r.slice(d, f.index)), !a && f[c] > 1 && f[0].replace(e, function () {
                        for (h = 1; h < arguments[c] - 2; h++)void 0 === arguments[h] && (f[h] = void 0)
                    }), f[c] > 1 && f.index < r[c] && u.apply(v, f.slice(1)), l = f[0][c], d = s, v[c] >= y));)g.lastIndex === f.index && g.lastIndex++;
                    return d === r[c] ? !l && g.test("") || v.push("") : v.push(r.slice(d)), v[c] > y ? v.slice(0, y) : v
                }
            } else"0".split(void 0, 0)[c] && (e = function (t, n) {
                return void 0 === t && 0 === n ? [] : o.call(this, t, n)
            });
            return [function split(t, i) {
                var o = n(this), u = void 0 == t ? void 0 : t[r];
                return void 0 !== u ? u.call(t, o, i) : e.call(String(o), t, i)
            }, e]
        })
    }, {36: 36, 52: 52}],
    230: [function (t, n, r) {
        "use strict";
        t(225);
        var e = t(7), i = t(37), o = t(29), u = /./.toString, c = function (n) {
            t(94)(RegExp.prototype, "toString", n, !0)
        };
        t(35)(function () {
            return "/a/b" != u.call({source: "a", flags: "b"})
        }) ? c(function toString() {
            var t = e(this);
            return "/".concat(t.source, "/", "flags" in t ? t.flags : !o && t instanceof RegExp ? i.call(t) : void 0)
        }) : "toString" != u.name && c(function toString() {
            return u.call(this)
        })
    }, {225: 225, 29: 29, 35: 35, 37: 37, 7: 7, 94: 94}],
    231: [function (t, n, r) {
        "use strict";
        var e = t(19), i = t(125);
        n.exports = t(22)("Set", function (t) {
            return function Set() {
                return t(this, arguments.length > 0 ? arguments[0] : void 0)
            }
        }, {
            add: function add(t) {
                return e.def(i(this, "Set"), t = 0 === t ? 0 : t, t)
            }
        }, e)
    }, {125: 125, 19: 19, 22: 22}],
    232: [function (t, n, r) {
        "use strict";
        t(108)("anchor", function (t) {
            return function anchor(n) {
                return t(this, "a", "name", n)
            }
        })
    }, {108: 108}],
    233: [function (t, n, r) {
        "use strict";
        t(108)("big", function (t) {
            return function big() {
                return t(this, "big", "", "")
            }
        })
    }, {108: 108}],
    234: [function (t, n, r) {
        "use strict";
        t(108)("blink", function (t) {
            return function blink() {
                return t(this, "blink", "", "")
            }
        })
    }, {108: 108}],
    235: [function (t, n, r) {
        "use strict";
        t(108)("bold", function (t) {
            return function bold() {
                return t(this, "b", "", "")
            }
        })
    }, {108: 108}],
    236: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(106)(!1);
        e(e.P, "String", {
            codePointAt: function codePointAt(t) {
                return i(this, t)
            }
        })
    }, {106: 106, 33: 33}],
    237: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(118), o = t(107), u = "".endsWith;
        e(e.P + e.F * t(34)("endsWith"), "String", {
            endsWith: function endsWith(t) {
                var n = o(this, t, "endsWith"), r = arguments.length > 1 ? arguments[1] : void 0, e = i(n.length), c = void 0 === r ? e : Math.min(i(r), e), a = String(t);
                return u ? u.call(n, a, c) : n.slice(c - a.length, c) === a
            }
        })
    }, {107: 107, 118: 118, 33: 33, 34: 34}],
    238: [function (t, n, r) {
        "use strict";
        t(108)("fixed", function (t) {
            return function fixed() {
                return t(this, "tt", "", "")
            }
        })
    }, {108: 108}],
    239: [function (t, n, r) {
        "use strict";
        t(108)("fontcolor", function (t) {
            return function fontcolor(n) {
                return t(this, "font", "color", n)
            }
        })
    }, {108: 108}],
    240: [function (t, n, r) {
        "use strict";
        t(108)("fontsize", function (t) {
            return function fontsize(n) {
                return t(this, "font", "size", n)
            }
        })
    }, {108: 108}],
    241: [function (t, n, r) {
        var e = t(33), i = t(114), o = String.fromCharCode, u = String.fromCodePoint;
        e(e.S + e.F * (!!u && 1 != u.length), "String", {
            fromCodePoint: function fromCodePoint(t) {
                for (var n, r = [], e = arguments.length, u = 0; e > u;) {
                    if (n = +arguments[u++], i(n, 1114111) !== n)throw RangeError(n + " is not a valid code point");
                    r.push(n < 65536 ? o(n) : o(55296 + ((n -= 65536) >> 10), n % 1024 + 56320))
                }
                return r.join("")
            }
        })
    }, {114: 114, 33: 33}],
    242: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(107);
        e(e.P + e.F * t(34)("includes"), "String", {
            includes: function includes(t) {
                return !!~i(this, t, "includes").indexOf(t, arguments.length > 1 ? arguments[1] : void 0)
            }
        })
    }, {107: 107, 33: 33, 34: 34}],
    243: [function (t, n, r) {
        "use strict";
        t(108)("italics", function (t) {
            return function italics() {
                return t(this, "i", "", "")
            }
        })
    }, {108: 108}],
    244: [function (t, n, r) {
        "use strict";
        var e = t(106)(!0);
        t(55)(String, "String", function (t) {
            this._t = String(t), this._i = 0
        }, function () {
            var t, n = this._t, r = this._i;
            return r >= n.length ? {value: void 0, done: !0} : (t = e(n, r), this._i += t.length, {value: t, done: !1})
        })
    }, {106: 106, 55: 55}],
    245: [function (t, n, r) {
        "use strict";
        t(108)("link", function (t) {
            return function link(n) {
                return t(this, "a", "href", n)
            }
        })
    }, {108: 108}],
    246: [function (t, n, r) {
        var e = t(33), i = t(117), o = t(118);
        e(e.S, "String", {
            raw: function raw(t) {
                for (var n = i(t.raw), r = o(n.length), e = arguments.length, u = [], c = 0; r > c;)u.push(String(n[c++])), c < e && u.push(String(arguments[c]));
                return u.join("")
            }
        })
    }, {117: 117, 118: 118, 33: 33}],
    247: [function (t, n, r) {
        var e = t(33);
        e(e.P, "String", {repeat: t(110)})
    }, {110: 110, 33: 33}],
    248: [function (t, n, r) {
        "use strict";
        t(108)("small", function (t) {
            return function small() {
                return t(this, "small", "", "")
            }
        })
    }, {108: 108}],
    249: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(118), o = t(107), u = "".startsWith;
        e(e.P + e.F * t(34)("startsWith"), "String", {
            startsWith: function startsWith(t) {
                var n = o(this, t, "startsWith"), r = i(Math.min(arguments.length > 1 ? arguments[1] : void 0, n.length)), e = String(t);
                return u ? u.call(n, e, r) : n.slice(r, r + e.length) === e
            }
        })
    }, {107: 107, 118: 118, 33: 33, 34: 34}],
    250: [function (t, n, r) {
        "use strict";
        t(108)("strike", function (t) {
            return function strike() {
                return t(this, "strike", "", "")
            }
        })
    }, {108: 108}],
    251: [function (t, n, r) {
        "use strict";
        t(108)("sub", function (t) {
            return function sub() {
                return t(this, "sub", "", "")
            }
        })
    }, {108: 108}],
    252: [function (t, n, r) {
        "use strict";
        t(108)("sup", function (t) {
            return function sup() {
                return t(this, "sup", "", "")
            }
        })
    }, {108: 108}],
    253: [function (t, n, r) {
        "use strict";
        t(111)("trim", function (t) {
            return function trim() {
                return t(this, 3)
            }
        })
    }, {111: 111}],
    254: [function (t, n, r) {
        "use strict";
        var e = t(40), i = t(41), o = t(29), u = t(33), c = t(94), a = t(66).KEY, f = t(35), s = t(103), l = t(101), h = t(124), v = t(128), p = t(127), d = t(126), y = t(59), g = t(32), m = t(49), b = t(7), x = t(117), S = t(120), w = t(92), _ = t(71), E = t(76), O = t(75), P = t(72), M = t(81), F = O.f, I = P.f, A = E.f, k = e.Symbol, N = e.JSON, j = N && N.stringify, T = v("_hidden"), R = v("toPrimitive"), L = {}.propertyIsEnumerable, G = s("symbol-registry"), D = s("symbols"), C = s("op-symbols"), W = Object.prototype, U = "function" == typeof k, B = e.QObject, V = !B || !B.prototype || !B.prototype.findChild, z = o && f(function () {
            return 7 != _(I({}, "a", {
                    get: function () {
                        return I(this, "a", {value: 7}).a
                    }
                })).a
        }) ? function (t, n, r) {
            var e = F(W, n);
            e && delete W[n], I(t, n, r), e && t !== W && I(W, n, e)
        } : I, q = function (t) {
            var n = D[t] = _(k.prototype);
            return n._k = t, n
        }, K = U && "symbol" == typeof k.iterator ? function (t) {
            return "symbol" == typeof t
        } : function (t) {
            return t instanceof k
        }, Y = function defineProperty(t, n, r) {
            return t === W && Y(C, n, r), b(t), n = S(n, !0), b(r), i(D, n) ? (r.enumerable ? (i(t, T) && t[T][n] && (t[T][n] = !1), r = _(r, {enumerable: w(0, !1)})) : (i(t, T) || I(t, T, w(1, {})), t[T][n] = !0), z(t, n, r)) : I(t, n, r)
        }, J = function defineProperties(t, n) {
            b(t);
            for (var r, e = g(n = x(n)), i = 0, o = e.length; o > i;)Y(t, r = e[i++], n[r]);
            return t
        }, H = function create(t, n) {
            return void 0 === n ? _(t) : J(_(t), n)
        }, X = function propertyIsEnumerable(t) {
            var n = L.call(this, t = S(t, !0));
            return !(this === W && i(D, t) && !i(C, t)) && (!(n || !i(this, t) || !i(D, t) || i(this, T) && this[T][t]) || n)
        }, $ = function getOwnPropertyDescriptor(t, n) {
            if (t = x(t), n = S(n, !0), t !== W || !i(D, n) || i(C, n)) {
                var r = F(t, n);
                return !r || !i(D, n) || i(t, T) && t[T][n] || (r.enumerable = !0), r
            }
        }, Z = function getOwnPropertyNames(t) {
            for (var n, r = A(x(t)), e = [], o = 0; r.length > o;)i(D, n = r[o++]) || n == T || n == a || e.push(n);
            return e
        }, Q = function getOwnPropertySymbols(t) {
            for (var n, r = t === W, e = A(r ? C : x(t)), o = [], u = 0; e.length > u;)!i(D, n = e[u++]) || r && !i(W, n) || o.push(D[n]);
            return o
        };
        U || (k = function Symbol() {
            if (this instanceof k)throw TypeError("Symbol is not a constructor!");
            var t = h(arguments.length > 0 ? arguments[0] : void 0), n = function (r) {
                this === W && n.call(C, r), i(this, T) && i(this[T], t) && (this[T][t] = !1), z(this, t, w(1, r))
            };
            return o && V && z(W, t, {configurable: !0, set: n}), q(t)
        }, c(k.prototype, "toString", function toString() {
            return this._k
        }), O.f = $, P.f = Y, t(77).f = E.f = Z, t(82).f = X, t(78).f = Q, o && !t(60) && c(W, "propertyIsEnumerable", X, !0), p.f = function (t) {
            return q(v(t))
        }), u(u.G + u.W + u.F * !U, {Symbol: k});
        for (var tt = "hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables".split(","), nt = 0; tt.length > nt;)v(tt[nt++]);
        for (var rt = M(v.store), et = 0; rt.length > et;)d(rt[et++]);
        u(u.S + u.F * !U, "Symbol", {
            for: function (t) {
                return i(G, t += "") ? G[t] : G[t] = k(t)
            }, keyFor: function keyFor(t) {
                if (K(t))return y(G, t);
                throw TypeError(t + " is not a symbol!")
            }, useSetter: function () {
                V = !0
            }, useSimple: function () {
                V = !1
            }
        }), u(u.S + u.F * !U, "Object", {
            create: H,
            defineProperty: Y,
            defineProperties: J,
            getOwnPropertyDescriptor: $,
            getOwnPropertyNames: Z,
            getOwnPropertySymbols: Q
        }), N && u(u.S + u.F * (!U || f(function () {
                var t = k();
                return "[null]" != j([t]) || "{}" != j({a: t}) || "{}" != j(Object(t))
            })), "JSON", {
            stringify: function stringify(t) {
                if (void 0 !== t && !K(t)) {
                    for (var n, r, e = [t], i = 1; arguments.length > i;)e.push(arguments[i++]);
                    return n = e[1], "function" == typeof n && (r = n), !r && m(n) || (n = function (t, n) {
                        if (r && (n = r.call(this, t, n)), !K(n))return n
                    }), e[1] = n, j.apply(N, e)
                }
            }
        }), k.prototype[R] || t(42)(k.prototype, R, k.prototype.valueOf), l(k, "Symbol"), l(Math, "Math", !0), l(e.JSON, "JSON", !0)
    }, {
        101: 101,
        103: 103,
        117: 117,
        120: 120,
        124: 124,
        126: 126,
        127: 127,
        128: 128,
        29: 29,
        32: 32,
        33: 33,
        35: 35,
        40: 40,
        41: 41,
        42: 42,
        49: 49,
        59: 59,
        60: 60,
        66: 66,
        7: 7,
        71: 71,
        72: 72,
        75: 75,
        76: 76,
        77: 77,
        78: 78,
        81: 81,
        82: 82,
        92: 92,
        94: 94
    }],
    255: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(123), o = t(122), u = t(7), c = t(114), a = t(118), f = t(51), s = t(40).ArrayBuffer, l = t(104), h = o.ArrayBuffer, v = o.DataView, p = i.ABV && s.isView, d = h.prototype.slice, y = i.VIEW;
        e(e.G + e.W + e.F * (s !== h), {ArrayBuffer: h}), e(e.S + e.F * !i.CONSTR, "ArrayBuffer", {
            isView: function isView(t) {
                return p && p(t) || f(t) && y in t
            }
        }), e(e.P + e.U + e.F * t(35)(function () {
                return !new h(2).slice(1, void 0).byteLength
            }), "ArrayBuffer", {
            slice: function slice(t, n) {
                if (void 0 !== d && void 0 === n)return d.call(u(this), t);
                for (var r = u(this).byteLength, e = c(t, r), i = c(void 0 === n ? r : n, r), o = new (l(this, h))(a(i - e)), f = new v(this), s = new v(o), p = 0; e < i;)s.setUint8(p++, f.getUint8(e++));
                return o
            }
        }), t(100)("ArrayBuffer")
    }, {100: 100, 104: 104, 114: 114, 118: 118, 122: 122, 123: 123, 33: 33, 35: 35, 40: 40, 51: 51, 7: 7}],
    256: [function (t, n, r) {
        var e = t(33);
        e(e.G + e.W + e.F * !t(123).ABV, {DataView: t(122).DataView})
    }, {122: 122, 123: 123, 33: 33}],
    257: [function (t, n, r) {
        t(121)("Float32", 4, function (t) {
            return function Float32Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    258: [function (t, n, r) {
        t(121)("Float64", 8, function (t) {
            return function Float64Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    259: [function (t, n, r) {
        t(121)("Int16", 2, function (t) {
            return function Int16Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    260: [function (t, n, r) {
        t(121)("Int32", 4, function (t) {
            return function Int32Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    261: [function (t, n, r) {
        t(121)("Int8", 1, function (t) {
            return function Int8Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    262: [function (t, n, r) {
        t(121)("Uint16", 2, function (t) {
            return function Uint16Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    263: [function (t, n, r) {
        t(121)("Uint32", 4, function (t) {
            return function Uint32Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    264: [function (t, n, r) {
        t(121)("Uint8", 1, function (t) {
            return function Uint8Array(n, r, e) {
                return t(this, n, r, e)
            }
        })
    }, {121: 121}],
    265: [function (t, n, r) {
        t(121)("Uint8", 1, function (t) {
            return function Uint8ClampedArray(n, r, e) {
                return t(this, n, r, e)
            }
        }, !0)
    }, {121: 121}],
    266: [function (t, n, r) {
        "use strict";
        var e, i = t(12)(0), o = t(94), u = t(66), c = t(70), a = t(21), f = t(51), s = t(35), l = t(125), h = u.getWeak, v = Object.isExtensible, p = a.ufstore, d = {}, y = function (t) {
            return function WeakMap() {
                return t(this, arguments.length > 0 ? arguments[0] : void 0)
            }
        }, g = {
            get: function get(t) {
                if (f(t)) {
                    var n = h(t);
                    return !0 === n ? p(l(this, "WeakMap")).get(t) : n ? n[this._i] : void 0
                }
            }, set: function set(t, n) {
                return a.def(l(this, "WeakMap"), t, n)
            }
        }, m = n.exports = t(22)("WeakMap", y, g, a, !0, !0);
        s(function () {
            return 7 != (new m).set((Object.freeze || Object)(d), 7).get(d)
        }) && (e = a.getConstructor(y, "WeakMap"), c(e.prototype, g), u.NEED = !0, i(["delete", "has", "get", "set"], function (t) {
            var n = m.prototype, r = n[t];
            o(n, t, function (n, i) {
                if (f(n) && !v(n)) {
                    this._f || (this._f = new e);
                    var o = this._f[t](n, i);
                    return "set" == t ? this : o
                }
                return r.call(this, n, i)
            })
        }))
    }, {12: 12, 125: 125, 21: 21, 22: 22, 35: 35, 51: 51, 66: 66, 70: 70, 94: 94}],
    267: [function (t, n, r) {
        "use strict";
        var e = t(21), i = t(125);
        t(22)("WeakSet", function (t) {
            return function WeakSet() {
                return t(this, arguments.length > 0 ? arguments[0] : void 0)
            }
        }, {
            add: function add(t) {
                return e.def(i(this, "WeakSet"), t, !0)
            }
        }, e, !1, !0)
    }, {125: 125, 21: 21, 22: 22}],
    268: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(38), o = t(119), u = t(118), c = t(3), a = t(15);
        e(e.P, "Array", {
            flatMap: function flatMap(t) {
                var n, r, e = o(this);
                return c(t), n = u(e.length), r = a(e, 0), i(r, e, e, n, 0, 1, t, arguments[1]), r
            }
        }), t(5)("flatMap")
    }, {118: 118, 119: 119, 15: 15, 3: 3, 33: 33, 38: 38, 5: 5}],
    269: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(38), o = t(119), u = t(118), c = t(116), a = t(15);
        e(e.P, "Array", {
            flatten: function flatten() {
                var t = arguments[0], n = o(this), r = u(n.length), e = a(n, 0);
                return i(e, n, n, r, 0, void 0 === t ? 1 : c(t)), e
            }
        }), t(5)("flatten")
    }, {116: 116, 118: 118, 119: 119, 15: 15, 33: 33, 38: 38, 5: 5}],
    270: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(11)(!0);
        e(e.P, "Array", {
            includes: function includes(t) {
                return i(this, t, arguments.length > 1 ? arguments[1] : void 0)
            }
        }), t(5)("includes")
    }, {11: 11, 33: 33, 5: 5}],
    271: [function (t, n, r) {
        var e = t(33), i = t(68)(), o = t(40).process, u = "process" == t(18)(o);
        e(e.G, {
            asap: function asap(t) {
                var n = u && o.domain;
                i(n ? n.bind(t) : t)
            }
        })
    }, {18: 18, 33: 33, 40: 40, 68: 68}],
    272: [function (t, n, r) {
        var e = t(33), i = t(18);
        e(e.S, "Error", {
            isError: function isError(t) {
                return "Error" === i(t)
            }
        })
    }, {18: 18, 33: 33}],
    273: [function (t, n, r) {
        var e = t(33);
        e(e.G, {global: t(40)})
    }, {33: 33, 40: 40}],
    274: [function (t, n, r) {
        t(97)("Map")
    }, {97: 97}],
    275: [function (t, n, r) {
        t(98)("Map")
    }, {98: 98}],
    276: [function (t, n, r) {
        var e = t(33);
        e(e.P + e.R, "Map", {toJSON: t(20)("Map")})
    }, {20: 20, 33: 33}],
    277: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            clamp: function clamp(t, n, r) {
                return Math.min(r, Math.max(n, t))
            }
        })
    }, {33: 33}],
    278: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {DEG_PER_RAD: Math.PI / 180})
    }, {33: 33}],
    279: [function (t, n, r) {
        var e = t(33), i = 180 / Math.PI;
        e(e.S, "Math", {
            degrees: function degrees(t) {
                return t * i
            }
        })
    }, {33: 33}],
    280: [function (t, n, r) {
        var e = t(33), i = t(64), o = t(62);
        e(e.S, "Math", {
            fscale: function fscale(t, n, r, e, u) {
                return o(i(t, n, r, e, u))
            }
        })
    }, {33: 33, 62: 62, 64: 64}],
    281: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            iaddh: function iaddh(t, n, r, e) {
                var i = t >>> 0, o = n >>> 0, u = r >>> 0;
                return o + (e >>> 0) + ((i & u | (i | u) & ~(i + u >>> 0)) >>> 31) | 0
            }
        })
    }, {33: 33}],
    282: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            imulh: function imulh(t, n) {
                var r = +t, e = +n, i = 65535 & r, o = 65535 & e, u = r >> 16, c = e >> 16, a = (u * o >>> 0) + (i * o >>> 16);
                return u * c + (a >> 16) + ((i * c >>> 0) + (65535 & a) >> 16)
            }
        })
    }, {33: 33}],
    283: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            isubh: function isubh(t, n, r, e) {
                var i = t >>> 0, o = n >>> 0, u = r >>> 0;
                return o - (e >>> 0) - ((~i & u | ~(i ^ u) & i - u >>> 0) >>> 31) | 0
            }
        })
    }, {33: 33}],
    284: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {RAD_PER_DEG: 180 / Math.PI})
    }, {33: 33}],
    285: [function (t, n, r) {
        var e = t(33), i = Math.PI / 180;
        e(e.S, "Math", {
            radians: function radians(t) {
                return t * i
            }
        })
    }, {33: 33}],
    286: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {scale: t(64)})
    }, {33: 33, 64: 64}],
    287: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            signbit: function signbit(t) {
                return (t = +t) != t ? t : 0 == t ? 1 / t == 1 / 0 : t > 0
            }
        })
    }, {33: 33}],
    288: [function (t, n, r) {
        var e = t(33);
        e(e.S, "Math", {
            umulh: function umulh(t, n) {
                var r = +t, e = +n, i = 65535 & r, o = 65535 & e, u = r >>> 16, c = e >>> 16, a = (u * o >>> 0) + (i * o >>> 16);
                return u * c + (a >>> 16) + ((i * c >>> 0) + (65535 & a) >>> 16)
            }
        })
    }, {33: 33}],
    289: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(119), o = t(3), u = t(72);
        t(29) && e(e.P + t(74), "Object", {
            __defineGetter__: function __defineGetter__(t, n) {
                u.f(i(this), t, {get: o(n), enumerable: !0, configurable: !0})
            }
        })
    }, {119: 119, 29: 29, 3: 3, 33: 33, 72: 72, 74: 74}],
    290: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(119), o = t(3), u = t(72);
        t(29) && e(e.P + t(74), "Object", {
            __defineSetter__: function __defineSetter__(t, n) {
                u.f(i(this), t, {set: o(n), enumerable: !0, configurable: !0})
            }
        })
    }, {119: 119, 29: 29, 3: 3, 33: 33, 72: 72, 74: 74}],
    291: [function (t, n, r) {
        var e = t(33), i = t(84)(!0);
        e(e.S, "Object", {
            entries: function entries(t) {
                return i(t)
            }
        })
    }, {33: 33, 84: 84}],
    292: [function (t, n, r) {
        var e = t(33), i = t(85), o = t(117), u = t(75), c = t(24);
        e(e.S, "Object", {
            getOwnPropertyDescriptors: function getOwnPropertyDescriptors(t) {
                for (var n, r, e = o(t), a = u.f, f = i(e), s = {}, l = 0; f.length > l;)void 0 !== (r = a(e, n = f[l++])) && c(s, n, r);
                return s
            }
        })
    }, {117: 117, 24: 24, 33: 33, 75: 75, 85: 85}],
    293: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(119), o = t(120), u = t(79), c = t(75).f;
        t(29) && e(e.P + t(74), "Object", {
            __lookupGetter__: function __lookupGetter__(t) {
                var n, r = i(this), e = o(t, !0);
                do {
                    if (n = c(r, e))return n.get
                } while (r = u(r))
            }
        })
    }, {119: 119, 120: 120, 29: 29, 33: 33, 74: 74, 75: 75, 79: 79}],
    294: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(119), o = t(120), u = t(79), c = t(75).f;
        t(29) && e(e.P + t(74), "Object", {
            __lookupSetter__: function __lookupSetter__(t) {
                var n, r = i(this), e = o(t, !0);
                do {
                    if (n = c(r, e))return n.set
                } while (r = u(r))
            }
        })
    }, {119: 119, 120: 120, 29: 29, 33: 33, 74: 74, 75: 75, 79: 79}],
    295: [function (t, n, r) {
        var e = t(33), i = t(84)(!1);
        e(e.S, "Object", {
            values: function values(t) {
                return i(t)
            }
        })
    }, {33: 33, 84: 84}],
    296: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(40), o = t(23), u = t(68)(), c = t(128)("observable"), a = t(3), f = t(7), s = t(6), l = t(93), h = t(42), v = t(39), p = v.RETURN, d = function (t) {
            return null == t ? void 0 : a(t)
        }, y = function (t) {
            var n = t._c;
            n && (t._c = void 0, n())
        }, g = function (t) {
            return void 0 === t._o
        }, m = function (t) {
            g(t) || (t._o = void 0, y(t))
        }, b = function (t, n) {
            f(t), this._c = void 0, this._o = t, t = new x(this);
            try {
                var r = n(t), e = r;
                null != r && ("function" == typeof r.unsubscribe ? r = function () {
                    e.unsubscribe()
                } : a(r), this._c = r)
            } catch (n) {
                return void t.error(n)
            }
            g(this) && y(this)
        };
        b.prototype = l({}, {
            unsubscribe: function unsubscribe() {
                m(this)
            }
        });
        var x = function (t) {
            this._s = t
        };
        x.prototype = l({}, {
            next: function next(t) {
                var n = this._s;
                if (!g(n)) {
                    var r = n._o;
                    try {
                        var e = d(r.next);
                        if (e)return e.call(r, t)
                    } catch (t) {
                        try {
                            m(n)
                        } finally {
                            throw t
                        }
                    }
                }
            }, error: function error(t) {
                var n = this._s;
                if (g(n))throw t;
                var r = n._o;
                n._o = void 0;
                try {
                    var e = d(r.error);
                    if (!e)throw t;
                    t = e.call(r, t)
                } catch (t) {
                    try {
                        y(n)
                    } finally {
                        throw t
                    }
                }
                return y(n), t
            }, complete: function complete(t) {
                var n = this._s;
                if (!g(n)) {
                    var r = n._o;
                    n._o = void 0;
                    try {
                        var e = d(r.complete);
                        t = e ? e.call(r, t) : void 0
                    } catch (t) {
                        try {
                            y(n)
                        } finally {
                            throw t
                        }
                    }
                    return y(n), t
                }
            }
        });
        var S = function Observable(t) {
            s(this, S, "Observable", "_f")._f = a(t)
        };
        l(S.prototype, {
            subscribe: function subscribe(t) {
                return new b(t, this._f)
            }, forEach: function forEach(t) {
                var n = this;
                return new (o.Promise || i.Promise)(function (r, e) {
                    a(t);
                    var i = n.subscribe({
                        next: function (n) {
                            try {
                                return t(n)
                            } catch (t) {
                                e(t), i.unsubscribe()
                            }
                        }, error: e, complete: r
                    })
                })
            }
        }), l(S, {
            from: function from(t) {
                var n = "function" == typeof this ? this : S, r = d(f(t)[c]);
                if (r) {
                    var e = f(r.call(t));
                    return e.constructor === n ? e : new n(function (t) {
                        return e.subscribe(t)
                    })
                }
                return new n(function (n) {
                    var r = !1;
                    return u(function () {
                        if (!r) {
                            try {
                                if (v(t, !1, function (t) {
                                        if (n.next(t), r)return p
                                    }) === p)return
                            } catch (t) {
                                if (r)throw t;
                                return void n.error(t)
                            }
                            n.complete()
                        }
                    }), function () {
                        r = !0
                    }
                })
            }, of: function of() {
                for (var t = 0, n = arguments.length, r = Array(n); t < n;)r[t] = arguments[t++];
                return new ("function" == typeof this ? this : S)(function (t) {
                    var n = !1;
                    return u(function () {
                        if (!n) {
                            for (var e = 0; e < r.length; ++e)if (t.next(r[e]), n)return;
                            t.complete()
                        }
                    }), function () {
                        n = !0
                    }
                })
            }
        }), h(S.prototype, c, function () {
            return this
        }), e(e.G, {Observable: S}), t(100)("Observable")
    }, {100: 100, 128: 128, 23: 23, 3: 3, 33: 33, 39: 39, 40: 40, 42: 42, 6: 6, 68: 68, 7: 7, 93: 93}],
    297: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(23), o = t(40), u = t(104), c = t(91);
        e(e.P + e.R, "Promise", {
            finally: function (t) {
                var n = u(this, i.Promise || o.Promise), r = "function" == typeof t;
                return this.then(r ? function (r) {
                    return c(n, t()).then(function () {
                        return r
                    })
                } : t, r ? function (r) {
                    return c(n, t()).then(function () {
                        throw r
                    })
                } : t)
            }
        })
    }, {104: 104, 23: 23, 33: 33, 40: 40, 91: 91}],
    298: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(69), o = t(90);
        e(e.S, "Promise", {
            try: function (t) {
                var n = i.f(this), r = o(t);
                return (r.e ? n.reject : n.resolve)(r.v), n.promise
            }
        })
    }, {33: 33, 69: 69, 90: 90}],
    299: [function (t, n, r) {
        var e = t(67), i = t(7), o = e.key, u = e.set;
        e.exp({
            defineMetadata: function defineMetadata(t, n, r, e) {
                u(t, n, i(r), o(e))
            }
        })
    }, {67: 67, 7: 7}],
    300: [function (t, n, r) {
        var e = t(67), i = t(7), o = e.key, u = e.map, c = e.store;
        e.exp({
            deleteMetadata: function deleteMetadata(t, n) {
                var r = arguments.length < 3 ? void 0 : o(arguments[2]), e = u(i(n), r, !1);
                if (void 0 === e || !e.delete(t))return !1;
                if (e.size)return !0;
                var a = c.get(n);
                return a.delete(r), !!a.size || c.delete(n)
            }
        })
    }, {67: 67, 7: 7}],
    301: [function (t, n, r) {
        var e = t(231), i = t(10), o = t(67), u = t(7), c = t(79), a = o.keys, f = o.key, s = function (t, n) {
            var r = a(t, n), o = c(t);
            if (null === o)return r;
            var u = s(o, n);
            return u.length ? r.length ? i(new e(r.concat(u))) : u : r
        };
        o.exp({
            getMetadataKeys: function getMetadataKeys(t) {
                return s(u(t), arguments.length < 2 ? void 0 : f(arguments[1]))
            }
        })
    }, {10: 10, 231: 231, 67: 67, 7: 7, 79: 79}],
    302: [function (t, n, r) {
        var e = t(67), i = t(7), o = t(79), u = e.has, c = e.get, a = e.key, f = function (t, n, r) {
            if (u(t, n, r))return c(t, n, r);
            var e = o(n);
            return null !== e ? f(t, e, r) : void 0
        };
        e.exp({
            getMetadata: function getMetadata(t, n) {
                return f(t, i(n), arguments.length < 3 ? void 0 : a(arguments[2]))
            }
        })
    }, {67: 67, 7: 7, 79: 79}],
    303: [function (t, n, r) {
        var e = t(67), i = t(7), o = e.keys, u = e.key;
        e.exp({
            getOwnMetadataKeys: function getOwnMetadataKeys(t) {
                return o(i(t), arguments.length < 2 ? void 0 : u(arguments[1]))
            }
        })
    }, {67: 67, 7: 7}],
    304: [function (t, n, r) {
        var e = t(67), i = t(7), o = e.get, u = e.key;
        e.exp({
            getOwnMetadata: function getOwnMetadata(t, n) {
                return o(t, i(n), arguments.length < 3 ? void 0 : u(arguments[2]))
            }
        })
    }, {67: 67, 7: 7}],
    305: [function (t, n, r) {
        var e = t(67), i = t(7), o = t(79), u = e.has, c = e.key, a = function (t, n, r) {
            if (u(t, n, r))return !0;
            var e = o(n);
            return null !== e && a(t, e, r)
        };
        e.exp({
            hasMetadata: function hasMetadata(t, n) {
                return a(t, i(n), arguments.length < 3 ? void 0 : c(arguments[2]))
            }
        })
    }, {67: 67, 7: 7, 79: 79}],
    306: [function (t, n, r) {
        var e = t(67), i = t(7), o = e.has, u = e.key;
        e.exp({
            hasOwnMetadata: function hasOwnMetadata(t, n) {
                return o(t, i(n), arguments.length < 3 ? void 0 : u(arguments[2]))
            }
        })
    }, {67: 67, 7: 7}],
    307: [function (t, n, r) {
        var e = t(67), i = t(7), o = t(3), u = e.key, c = e.set;
        e.exp({
            metadata: function metadata(t, n) {
                return function decorator(r, e) {
                    c(t, n, (void 0 !== e ? i : o)(r), u(e))
                }
            }
        })
    }, {3: 3, 67: 67, 7: 7}],
    308: [function (t, n, r) {
        t(97)("Set")
    }, {97: 97}],
    309: [function (t, n, r) {
        t(98)("Set")
    }, {98: 98}],
    310: [function (t, n, r) {
        var e = t(33);
        e(e.P + e.R, "Set", {toJSON: t(20)("Set")})
    }, {20: 20, 33: 33}],
    311: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(106)(!0);
        e(e.P, "String", {
            at: function at(t) {
                return i(this, t)
            }
        })
    }, {106: 106, 33: 33}],
    312: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(28), o = t(118), u = t(52), c = t(37), a = RegExp.prototype, f = function (t, n) {
            this._r = t, this._s = n
        };
        t(54)(f, "RegExp String", function next() {
            var t = this._r.exec(this._s);
            return {value: t, done: null === t}
        }), e(e.P, "String", {
            matchAll: function matchAll(t) {
                if (i(this), !u(t))throw TypeError(t + " is not a regexp!");
                var n = String(this), r = "flags" in a ? String(t.flags) : c.call(t), e = new RegExp(t.source, ~r.indexOf("g") ? r : "g" + r);
                return e.lastIndex = o(t.lastIndex), new f(e, n)
            }
        })
    }, {118: 118, 28: 28, 33: 33, 37: 37, 52: 52, 54: 54}],
    313: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(109);
        e(e.P, "String", {
            padEnd: function padEnd(t) {
                return i(this, t, arguments.length > 1 ? arguments[1] : void 0, !1)
            }
        })
    }, {109: 109, 33: 33}],
    314: [function (t, n, r) {
        "use strict";
        var e = t(33), i = t(109);
        e(e.P, "String", {
            padStart: function padStart(t) {
                return i(this, t, arguments.length > 1 ? arguments[1] : void 0, !0)
            }
        })
    }, {109: 109, 33: 33}],
    315: [function (t, n, r) {
        "use strict";
        t(111)("trimLeft", function (t) {
            return function trimLeft() {
                return t(this, 1)
            }
        }, "trimStart")
    }, {111: 111}],
    316: [function (t, n, r) {
        "use strict";
        t(111)("trimRight", function (t) {
            return function trimRight() {
                return t(this, 2)
            }
        }, "trimEnd")
    }, {111: 111}],
    317: [function (t, n, r) {
        t(126)("asyncIterator")
    }, {126: 126}],
    318: [function (t, n, r) {
        t(126)("observable")
    }, {126: 126}],
    319: [function (t, n, r) {
        var e = t(33);
        e(e.S, "System", {global: t(40)})
    }, {33: 33, 40: 40}],
    320: [function (t, n, r) {
        t(97)("WeakMap")
    }, {97: 97}],
    321: [function (t, n, r) {
        t(98)("WeakMap")
    }, {98: 98}],
    322: [function (t, n, r) {
        t(97)("WeakSet")
    }, {97: 97}],
    323: [function (t, n, r) {
        t(98)("WeakSet")
    }, {98: 98}],
    324: [function (t, n, r) {
        for (var e = t(141), i = t(81), o = t(94), u = t(40), c = t(42), a = t(58), f = t(128), s = f("iterator"), l = f("toStringTag"), h = a.Array, v = {
            CSSRuleList: !0,
            CSSStyleDeclaration: !1,
            CSSValueList: !1,
            ClientRectList: !1,
            DOMRectList: !1,
            DOMStringList: !1,
            DOMTokenList: !0,
            DataTransferItemList: !1,
            FileList: !1,
            HTMLAllCollection: !1,
            HTMLCollection: !1,
            HTMLFormElement: !1,
            HTMLSelectElement: !1,
            MediaList: !0,
            MimeTypeArray: !1,
            NamedNodeMap: !1,
            NodeList: !0,
            PaintRequestList: !1,
            Plugin: !1,
            PluginArray: !1,
            SVGLengthList: !1,
            SVGNumberList: !1,
            SVGPathSegList: !1,
            SVGPointList: !1,
            SVGStringList: !1,
            SVGTransformList: !1,
            SourceBufferList: !1,
            StyleSheetList: !0,
            TextTrackCueList: !1,
            TextTrackList: !1,
            TouchList: !1
        }, p = i(v), d = 0; d < p.length; d++) {
            var y, g = p[d], m = v[g], b = u[g], x = b && b.prototype;
            if (x && (x[s] || c(x, s, h), x[l] || c(x, l, g), a[g] = h, m))for (y in e)x[y] || o(x, y, e[y], !0)
        }
    }, {128: 128, 141: 141, 40: 40, 42: 42, 58: 58, 81: 81, 94: 94}],
    325: [function (t, n, r) {
        var e = t(33), i = t(113);
        e(e.G + e.B, {setImmediate: i.set, clearImmediate: i.clear})
    }, {113: 113, 33: 33}],
    326: [function (t, n, r) {
        var e = t(40), i = t(33), o = t(46), u = t(88), c = e.navigator, a = !!c && /MSIE .\./.test(c.userAgent), f = function (t) {
            return a ? function (n, r) {
                return t(o(u, [].slice.call(arguments, 2), "function" == typeof n ? n : Function(n)), r)
            } : t
        };
        i(i.G + i.B + i.F * a, {setTimeout: f(e.setTimeout), setInterval: f(e.setInterval)})
    }, {33: 33, 40: 40, 46: 46, 88: 88}],
    327: [function (t, n, r) {
        t(254), t(191), t(193), t(192), t(195), t(197), t(202), t(196), t(194), t(204), t(203), t(199), t(200), t(198), t(190), t(201), t(205), t(206), t(157), t(159), t(158), t(208), t(207), t(178), t(188), t(189), t(179), t(180), t(181), t(182), t(183), t(184), t(185), t(186), t(187), t(161), t(162), t(163), t(164), t(165), t(166), t(167), t(168), t(169), t(170), t(171), t(172), t(173), t(174), t(175), t(176), t(177), t(241), t(246), t(253), t(244), t(236), t(237), t(242), t(247), t(249), t(232), t(233), t(234), t(235), t(238), t(239), t(240), t(243), t(245), t(248), t(250), t(251), t(252), t(152), t(154), t(153), t(156), t(155), t(140), t(138), t(145), t(142), t(148), t(150), t(137), t(144), t(134), t(149), t(132), t(147), t(146), t(139), t(143), t(131), t(133), t(136), t(135), t(151), t(141), t(224),t(230),t(225),t(226),t(227),t(228),t(229),t(209),t(160),t(231),t(266),t(267),t(255),t(256),t(261),t(264),t(265),t(259),t(262),t(260),t(263),t(257),t(258),t(210),t(211),t(212),t(213),t(214),t(217),t(215),t(216),t(218),t(219),t(220),t(221),t(223),t(222),t(270),t(268),t(269),t(311),t(314),t(313),t(315),t(316),t(312),t(317),t(318),t(292),t(295),t(291),t(289),t(290),t(293),t(294),t(276),t(310),t(275),t(309),t(321),t(323),t(274),t(308),t(320),t(322),t(273),t(319),t(272),t(277),t(278),t(279),t(280),t(281),t(283),t(282),t(284),t(285),t(286),t(288),t(287),t(297),t(298),t(299),t(300),t(302),t(301),t(304),t(303),t(305),t(306),t(307),t(271),t(296),t(326),t(325),t(324),n.exports = t(23)
    }, {
        131: 131,
        132: 132,
        133: 133,
        134: 134,
        135: 135,
        136: 136,
        137: 137,
        138: 138,
        139: 139,
        140: 140,
        141: 141,
        142: 142,
        143: 143,
        144: 144,
        145: 145,
        146: 146,
        147: 147,
        148: 148,
        149: 149,
        150: 150,
        151: 151,
        152: 152,
        153: 153,
        154: 154,
        155: 155,
        156: 156,
        157: 157,
        158: 158,
        159: 159,
        160: 160,
        161: 161,
        162: 162,
        163: 163,
        164: 164,
        165: 165,
        166: 166,
        167: 167,
        168: 168,
        169: 169,
        170: 170,
        171: 171,
        172: 172,
        173: 173,
        174: 174,
        175: 175,
        176: 176,
        177: 177,
        178: 178,
        179: 179,
        180: 180,
        181: 181,
        182: 182,
        183: 183,
        184: 184,
        185: 185,
        186: 186,
        187: 187,
        188: 188,
        189: 189,
        190: 190,
        191: 191,
        192: 192,
        193: 193,
        194: 194,
        195: 195,
        196: 196,
        197: 197,
        198: 198,
        199: 199,
        200: 200,
        201: 201,
        202: 202,
        203: 203,
        204: 204,
        205: 205,
        206: 206,
        207: 207,
        208: 208,
        209: 209,
        210: 210,
        211: 211,
        212: 212,
        213: 213,
        214: 214,
        215: 215,
        216: 216,
        217: 217,
        218: 218,
        219: 219,
        220: 220,
        221: 221,
        222: 222,
        223: 223,
        224: 224,
        225: 225,
        226: 226,
        227: 227,
        228: 228,
        229: 229,
        23: 23,
        230: 230,
        231: 231,
        232: 232,
        233: 233,
        234: 234,
        235: 235,
        236: 236,
        237: 237,
        238: 238,
        239: 239,
        240: 240,
        241: 241,
        242: 242,
        243: 243,
        244: 244,
        245: 245,
        246: 246,
        247: 247,
        248: 248,
        249: 249,
        250: 250,
        251: 251,
        252: 252,
        253: 253,
        254: 254,
        255: 255,
        256: 256,
        257: 257,
        258: 258,
        259: 259,
        260: 260,
        261: 261,
        262: 262,
        263: 263,
        264: 264,
        265: 265,
        266: 266,
        267: 267,
        268: 268,
        269: 269,
        270: 270,
        271: 271,
        272: 272,
        273: 273,
        274: 274,
        275: 275,
        276: 276,
        277: 277,
        278: 278,
        279: 279,
        280: 280,
        281: 281,
        282: 282,
        283: 283,
        284: 284,
        285: 285,
        286: 286,
        287: 287,
        288: 288,
        289: 289,
        290: 290,
        291: 291,
        292: 292,
        293: 293,
        294: 294,
        295: 295,
        296: 296,
        297: 297,
        298: 298,
        299: 299,
        300: 300,
        301: 301,
        302: 302,
        303: 303,
        304: 304,
        305: 305,
        306: 306,
        307: 307,
        308: 308,
        309: 309,
        310: 310,
        311: 311,
        312: 312,
        313: 313,
        314: 314,
        315: 315,
        316: 316,
        317: 317,
        318: 318,
        319: 319,
        320: 320,
        321: 321,
        322: 322,
        323: 323,
        324: 324,
        325: 325,
        326: 326
    }],
    328: [function (t, n, r) {
        (function (t) {
            !function (t) {
                "use strict";
                function wrap(t, n, r, e) {
                    var i = n && n.prototype instanceof Generator ? n : Generator, o = Object.create(i.prototype), u = new Context(e || []);
                    return o._invoke = makeInvokeMethod(t, r, u), o
                }

                function tryCatch(t, n, r) {
                    try {
                        return {type: "normal", arg: t.call(n, r)}
                    } catch (t) {
                        return {type: "throw", arg: t}
                    }
                }

                function Generator() {
                }

                function GeneratorFunction() {
                }

                function GeneratorFunctionPrototype() {
                }

                function defineIteratorMethods(t) {
                    ["next", "throw", "return"].forEach(function (n) {
                        t[n] = function (t) {
                            return this._invoke(n, t)
                        }
                    })
                }

                function AsyncIterator(n) {
                    function invoke(t, r, e, o) {
                        var u = tryCatch(n[t], n, r);
                        if ("throw" !== u.type) {
                            var c = u.arg, a = c.value;
                            return a && "object" == typeof a && i.call(a, "__await") ? Promise.resolve(a.__await).then(function (t) {
                                invoke("next", t, e, o)
                            }, function (t) {
                                invoke("throw", t, e, o)
                            }) : Promise.resolve(a).then(function (t) {
                                c.value = t, e(c)
                            }, o)
                        }
                        o(u.arg)
                    }

                    function enqueue(t, n) {
                        function callInvokeWithMethodAndArg() {
                            return new Promise(function (r, e) {
                                invoke(t, n, r, e)
                            })
                        }

                        return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg()
                    }

                    "object" == typeof t.process && t.process.domain && (invoke = t.process.domain.bind(invoke));
                    var r;
                    this._invoke = enqueue
                }

                function makeInvokeMethod(t, n, r) {
                    var e = l;
                    return function invoke(i, o) {
                        if (e === v)throw new Error("Generator is already running");
                        if (e === p) {
                            if ("throw" === i)throw o;
                            return doneResult()
                        }
                        for (r.method = i, r.arg = o; ;) {
                            var u = r.delegate;
                            if (u) {
                                var c = maybeInvokeDelegate(u, r);
                                if (c) {
                                    if (c === d)continue;
                                    return c
                                }
                            }
                            if ("next" === r.method)r.sent = r._sent = r.arg; else if ("throw" === r.method) {
                                if (e === l)throw e = p, r.arg;
                                r.dispatchException(r.arg)
                            } else"return" === r.method && r.abrupt("return", r.arg);
                            e = v;
                            var a = tryCatch(t, n, r);
                            if ("normal" === a.type) {
                                if (e = r.done ? p : h, a.arg === d)continue;
                                return {value: a.arg, done: r.done}
                            }
                            "throw" === a.type && (e = p, r.method = "throw", r.arg = a.arg)
                        }
                    }
                }

                function maybeInvokeDelegate(t, n) {
                    var e = t.iterator[n.method];
                    if (e === r) {
                        if (n.delegate = null, "throw" === n.method) {
                            if (t.iterator.return && (n.method = "return", n.arg = r, maybeInvokeDelegate(t, n), "throw" === n.method))return d;
                            n.method = "throw", n.arg = new TypeError("The iterator does not provide a 'throw' method")
                        }
                        return d
                    }
                    var i = tryCatch(e, t.iterator, n.arg);
                    if ("throw" === i.type)return n.method = "throw", n.arg = i.arg, n.delegate = null, d;
                    var o = i.arg;
                    return o ? o.done ? (n[t.resultName] = o.value, n.next = t.nextLoc, "return" !== n.method && (n.method = "next", n.arg = r), n.delegate = null, d) : o : (n.method = "throw", n.arg = new TypeError("iterator result is not an object"), n.delegate = null, d)
                }

                function pushTryEntry(t) {
                    var n = {tryLoc: t[0]};
                    1 in t && (n.catchLoc = t[1]), 2 in t && (n.finallyLoc = t[2], n.afterLoc = t[3]), this.tryEntries.push(n)
                }

                function resetTryEntry(t) {
                    var n = t.completion || {};
                    n.type = "normal", delete n.arg, t.completion = n
                }

                function Context(t) {
                    this.tryEntries = [{tryLoc: "root"}], t.forEach(pushTryEntry, this), this.reset(!0)
                }

                function values(t) {
                    if (t) {
                        var n = t[u];
                        if (n)return n.call(t);
                        if ("function" == typeof t.next)return t;
                        if (!isNaN(t.length)) {
                            var e = -1, o = function next() {
                                for (; ++e < t.length;)if (i.call(t, e))return next.value = t[e], next.done = !1, next;
                                return next.value = r, next.done = !0, next
                            };
                            return o.next = o
                        }
                    }
                    return {next: doneResult}
                }

                function doneResult() {
                    return {value: r, done: !0}
                }

                var r, e = Object.prototype, i = e.hasOwnProperty, o = "function" == typeof Symbol ? Symbol : {}, u = o.iterator || "@@iterator", c = o.asyncIterator || "@@asyncIterator", a = o.toStringTag || "@@toStringTag", f = "object" == typeof n, s = t.regeneratorRuntime;
                if (s)return void(f && (n.exports = s));
                s = t.regeneratorRuntime = f ? n.exports : {}, s.wrap = wrap;
                var l = "suspendedStart", h = "suspendedYield", v = "executing", p = "completed", d = {}, y = {};
                y[u] = function () {
                    return this
                };
                var g = Object.getPrototypeOf, m = g && g(g(values([])));
                m && m !== e && i.call(m, u) && (y = m);
                var b = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(y);
                GeneratorFunction.prototype = b.constructor = GeneratorFunctionPrototype, GeneratorFunctionPrototype.constructor = GeneratorFunction, GeneratorFunctionPrototype[a] = GeneratorFunction.displayName = "GeneratorFunction", s.isGeneratorFunction = function (t) {
                    var n = "function" == typeof t && t.constructor;
                    return !!n && (n === GeneratorFunction || "GeneratorFunction" === (n.displayName || n.name))
                }, s.mark = function (t) {
                    return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, a in t || (t[a] = "GeneratorFunction")), t.prototype = Object.create(b), t
                }, s.awrap = function (t) {
                    return {__await: t}
                }, defineIteratorMethods(AsyncIterator.prototype), AsyncIterator.prototype[c] = function () {
                    return this
                }, s.AsyncIterator = AsyncIterator, s.async = function (t, n, r, e) {
                    var i = new AsyncIterator(wrap(t, n, r, e));
                    return s.isGeneratorFunction(n) ? i : i.next().then(function (t) {
                        return t.done ? t.value : i.next()
                    })
                }, defineIteratorMethods(b), b[a] = "Generator", b[u] = function () {
                    return this
                }, b.toString = function () {
                    return "[object Generator]"
                }, s.keys = function (t) {
                    var n = [];
                    for (var r in t)n.push(r);
                    return n.reverse(), function next() {
                        for (; n.length;) {
                            var r = n.pop();
                            if (r in t)return next.value = r, next.done = !1, next
                        }
                        return next.done = !0, next
                    }
                }, s.values = values, Context.prototype = {
                    constructor: Context, reset: function (t) {
                        if (this.prev = 0, this.next = 0, this.sent = this._sent = r, this.done = !1, this.delegate = null, this.method = "next", this.arg = r, this.tryEntries.forEach(resetTryEntry), !t)for (var n in this)"t" === n.charAt(0) && i.call(this, n) && !isNaN(+n.slice(1)) && (this[n] = r)
                    }, stop: function () {
                        this.done = !0;
                        var t = this.tryEntries[0], n = t.completion;
                        if ("throw" === n.type)throw n.arg;
                        return this.rval
                    }, dispatchException: function (t) {
                        function handle(e, i) {
                            return u.type = "throw", u.arg = t, n.next = e, i && (n.method = "next", n.arg = r), !!i
                        }

                        if (this.done)throw t;
                        for (var n = this, e = this.tryEntries.length - 1; e >= 0; --e) {
                            var o = this.tryEntries[e], u = o.completion;
                            if ("root" === o.tryLoc)return handle("end");
                            if (o.tryLoc <= this.prev) {
                                var c = i.call(o, "catchLoc"), a = i.call(o, "finallyLoc");
                                if (c && a) {
                                    if (this.prev < o.catchLoc)return handle(o.catchLoc, !0);
                                    if (this.prev < o.finallyLoc)return handle(o.finallyLoc)
                                } else if (c) {
                                    if (this.prev < o.catchLoc)return handle(o.catchLoc, !0)
                                } else {
                                    if (!a)throw new Error("try statement without catch or finally");
                                    if (this.prev < o.finallyLoc)return handle(o.finallyLoc)
                                }
                            }
                        }
                    }, abrupt: function (t, n) {
                        for (var r = this.tryEntries.length - 1; r >= 0; --r) {
                            var e = this.tryEntries[r];
                            if (e.tryLoc <= this.prev && i.call(e, "finallyLoc") && this.prev < e.finallyLoc) {
                                var o = e;
                                break
                            }
                        }
                        o && ("break" === t || "continue" === t) && o.tryLoc <= n && n <= o.finallyLoc && (o = null);
                        var u = o ? o.completion : {};
                        return u.type = t, u.arg = n, o ? (this.method = "next", this.next = o.finallyLoc, d) : this.complete(u)
                    }, complete: function (t, n) {
                        if ("throw" === t.type)throw t.arg;
                        return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && n && (this.next = n), d
                    }, finish: function (t) {
                        for (var n = this.tryEntries.length - 1; n >= 0; --n) {
                            var r = this.tryEntries[n];
                            if (r.finallyLoc === t)return this.complete(r.completion, r.afterLoc), resetTryEntry(r), d
                        }
                    }, catch: function (t) {
                        for (var n = this.tryEntries.length - 1; n >= 0; --n) {
                            var r = this.tryEntries[n];
                            if (r.tryLoc === t) {
                                var e = r.completion;
                                if ("throw" === e.type) {
                                    var i = e.arg;
                                    resetTryEntry(r)
                                }
                                return i
                            }
                        }
                        throw new Error("illegal catch attempt")
                    }, delegateYield: function (t, n, e) {
                        return this.delegate = {
                            iterator: values(t),
                            resultName: n,
                            nextLoc: e
                        }, "next" === this.method && (this.arg = r), d
                    }
                }
            }("object" == typeof t ? t : "object" == typeof window ? window : "object" == typeof self ? self : this)
        }).call(this, "undefined" != typeof global ? global : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {})
    }, {}]
}, {}, [1]);

/**
 * @license AngularJS v1.5.9
 * (c) 2010-2016 Google, Inc. http://angularjs.org
 * License: MIT
 */
(function(window) {'use strict';

    if (window.angular) {
        return;
    }

    /**
     * @description
     *
     * This object provides a utility for producing rich Error messages within
     * Angular. It can be called as follows:
     *
     * var exampleMinErr = minErr('example');
     * throw exampleMinErr('one', 'This {0} is {1}', foo, bar);
     *
     * The above creates an instance of minErr in the example namespace. The
     * resulting error will have a namespaced error code of example.one.  The
     * resulting error will replace {0} with the value of foo, and {1} with the
     * value of bar. The object is not restricted in the number of arguments it can
     * take.
     *
     * If fewer arguments are specified than necessary for interpolation, the extra
     * interpolation markers will be preserved in the final string.
     *
     * Since data will be parsed statically during a build step, some restrictions
     * are applied with respect to how minErr instances are created and called.
     * Instances should have names of the form namespaceMinErr for a minErr created
     * using minErr('namespace') . Error codes, namespaces and template strings
     * should all be static strings, not variables or general expressions.
     *
     * @param {string} module The namespace to use for the new minErr instance.
     * @param {function} ErrorConstructor Custom error constructor to be instantiated when returning
     *   error from returned function, for cases when a particular type of error is useful.
     * @returns {function(code:string, template:string, ...templateArgs): Error} minErr instance
     */

    function minErr(module, ErrorConstructor) {
        ErrorConstructor = ErrorConstructor || Error;
        return function() {
            var SKIP_INDEXES = 2;

            var templateArgs = arguments,
                code = templateArgs[0],
                message = '[' + (module ? module + ':' : '') + code + '] ',
                template = templateArgs[1],
                paramPrefix, i;

            message += template.replace(/\{\d+\}/g, function(match) {
                var index = +match.slice(1, -1),
                    shiftedIndex = index + SKIP_INDEXES;

                if (shiftedIndex < templateArgs.length) {
                    return toDebugString(templateArgs[shiftedIndex]);
                }

                return match;
            });

            message += '\nhttp://errors.angularjs.org/1.5.9/' +
                (module ? module + '/' : '') + code;

            for (i = SKIP_INDEXES, paramPrefix = '?'; i < templateArgs.length; i++, paramPrefix = '&') {
                message += paramPrefix + 'p' + (i - SKIP_INDEXES) + '=' +
                    encodeURIComponent(toDebugString(templateArgs[i]));
            }

            return new ErrorConstructor(message);
        };
    }

    /* We need to tell ESLint what variables are being exported */
    /* exported
     angular,
     msie,
     jqLite,
     jQuery,
     slice,
     splice,
     push,
     toString,
     ngMinErr,
     angularModule,
     uid,
     REGEX_STRING_REGEXP,
     VALIDITY_STATE_PROPERTY,

     lowercase,
     uppercase,
     manualLowercase,
     manualUppercase,
     nodeName_,
     isArrayLike,
     forEach,
     forEachSorted,
     reverseParams,
     nextUid,
     setHashKey,
     extend,
     toInt,
     inherit,
     merge,
     noop,
     identity,
     valueFn,
     isUndefined,
     isDefined,
     isObject,
     isBlankObject,
     isString,
     isNumber,
     isNumberNaN,
     isDate,
     isArray,
     isFunction,
     isRegExp,
     isWindow,
     isScope,
     isFile,
     isFormData,
     isBlob,
     isBoolean,
     isPromiseLike,
     trim,
     escapeForRegexp,
     isElement,
     makeMap,
     includes,
     arrayRemove,
     copy,
     equals,
     csp,
     jq,
     concat,
     sliceArgs,
     bind,
     toJsonReplacer,
     toJson,
     fromJson,
     convertTimezoneToLocal,
     timezoneToOffset,
     startingTag,
     tryDecodeURIComponent,
     parseKeyValue,
     toKeyValue,
     encodeUriSegment,
     encodeUriQuery,
     angularInit,
     bootstrap,
     getTestability,
     snake_case,
     bindJQuery,
     assertArg,
     assertArgFn,
     assertNotHasOwnProperty,
     getter,
     getBlockNodes,
     hasOwnProperty,
     createMap,

     NODE_TYPE_ELEMENT,
     NODE_TYPE_ATTRIBUTE,
     NODE_TYPE_TEXT,
     NODE_TYPE_COMMENT,
     NODE_TYPE_DOCUMENT,
     NODE_TYPE_DOCUMENT_FRAGMENT
     */

////////////////////////////////////

    /**
     * @ngdoc module
     * @name ng
     * @module ng
     * @installation
     * @description
     *
     * # ng (core module)
     * The ng module is loaded by default when an AngularJS application is started. The module itself
     * contains the essential components for an AngularJS application to function. The table below
     * lists a high level breakdown of each of the services/factories, filters, directives and testing
     * components available within this core module.
     *
     * <div doc-module-components="ng"></div>
     */

    var REGEX_STRING_REGEXP = /^\/(.+)\/([a-z]*)$/;

// The name of a form control's ValidityState property.
// This is used so that it's possible for internal tests to create mock ValidityStates.
    var VALIDITY_STATE_PROPERTY = 'validity';

    var hasOwnProperty = Object.prototype.hasOwnProperty;

    var lowercase = function(string) {return isString(string) ? string.toLowerCase() : string;};
    var uppercase = function(string) {return isString(string) ? string.toUpperCase() : string;};


    var manualLowercase = function(s) {
        /* eslint-disable no-bitwise */
        return isString(s)
            ? s.replace(/[A-Z]/g, function(ch) {return String.fromCharCode(ch.charCodeAt(0) | 32);})
            : s;
        /* eslint-enable */
    };
    var manualUppercase = function(s) {
        /* eslint-disable no-bitwise */
        return isString(s)
            ? s.replace(/[a-z]/g, function(ch) {return String.fromCharCode(ch.charCodeAt(0) & ~32);})
            : s;
        /* eslint-enable */
    };


// String#toLowerCase and String#toUpperCase don't produce correct results in browsers with Turkish
// locale, for this reason we need to detect this case and redefine lowercase/uppercase methods
// with correct but slower alternatives. See https://github.com/angular/angular.js/issues/11387
    if ('i' !== 'I'.toLowerCase()) {
        lowercase = manualLowercase;
        uppercase = manualUppercase;
    }


    var
        msie,             // holds major version number for IE, or NaN if UA is not IE.
        jqLite,           // delay binding since jQuery could be loaded after us.
        jQuery,           // delay binding
        slice             = [].slice,
        splice            = [].splice,
        push              = [].push,
        toString          = Object.prototype.toString,
        getPrototypeOf    = Object.getPrototypeOf,
        ngMinErr          = minErr('ng'),

        /** @name angular */
        angular           = window.angular || (window.angular = {}),
        angularModule,
        uid               = 0;

    /**
     * documentMode is an IE-only property
     * http://msdn.microsoft.com/en-us/library/ie/cc196988(v=vs.85).aspx
     */
    msie = window.document.documentMode;


    /**
     * @private
     * @param {*} obj
     * @return {boolean} Returns true if `obj` is an array or array-like object (NodeList, Arguments,
     *                   String ...)
     */
    function isArrayLike(obj) {

        // `null`, `undefined` and `window` are not array-like
        if (obj == null || isWindow(obj)) return false;

        // arrays, strings and jQuery/jqLite objects are array like
        // * jqLite is either the jQuery or jqLite constructor function
        // * we have to check the existence of jqLite first as this method is called
        //   via the forEach method when constructing the jqLite object in the first place
        if (isArray(obj) || isString(obj) || (jqLite && obj instanceof jqLite)) return true;

        // Support: iOS 8.2 (not reproducible in simulator)
        // "length" in obj used to prevent JIT error (gh-11508)
        var length = 'length' in Object(obj) && obj.length;

        // NodeList objects (with `item` method) and
        // other objects with suitable length characteristics are array-like
        return isNumber(length) &&
            (length >= 0 && ((length - 1) in obj || obj instanceof Array) || typeof obj.item === 'function');

    }

    /**
     * @ngdoc function
     * @name angular.forEach
     * @module ng
     * @kind function
     *
     * @description
     * Invokes the `iterator` function once for each item in `obj` collection, which can be either an
     * object or an array. The `iterator` function is invoked with `iterator(value, key, obj)`, where `value`
     * is the value of an object property or an array element, `key` is the object property key or
     * array element index and obj is the `obj` itself. Specifying a `context` for the function is optional.
     *
     * It is worth noting that `.forEach` does not iterate over inherited properties because it filters
     * using the `hasOwnProperty` method.
     *
     * Unlike ES262's
     * [Array.prototype.forEach](http://www.ecma-international.org/ecma-262/5.1/#sec-15.4.4.18),
     * providing 'undefined' or 'null' values for `obj` will not throw a TypeError, but rather just
     * return the value provided.
     *
     ```js
     var values = {name: 'misko', gender: 'male'};
     var log = [];
     angular.forEach(values, function(value, key) {
       this.push(key + ': ' + value);
     }, log);
     expect(log).toEqual(['name: misko', 'gender: male']);
     ```
     *
     * @param {Object|Array} obj Object to iterate over.
     * @param {Function} iterator Iterator function.
     * @param {Object=} context Object to become context (`this`) for the iterator function.
     * @returns {Object|Array} Reference to `obj`.
     */

    function forEach(obj, iterator, context) {
        var key, length;
        if (obj) {
            if (isFunction(obj)) {
                for (key in obj) {
                    // Need to check if hasOwnProperty exists,
                    // as on IE8 the result of querySelectorAll is an object without a hasOwnProperty function
                    if (key !== 'prototype' && key !== 'length' && key !== 'name' && (!obj.hasOwnProperty || obj.hasOwnProperty(key))) {
                        iterator.call(context, obj[key], key, obj);
                    }
                }
            } else if (isArray(obj) || isArrayLike(obj)) {
                var isPrimitive = typeof obj !== 'object';
                for (key = 0, length = obj.length; key < length; key++) {
                    if (isPrimitive || key in obj) {
                        iterator.call(context, obj[key], key, obj);
                    }
                }
            } else if (obj.forEach && obj.forEach !== forEach) {
                obj.forEach(iterator, context, obj);
            } else if (isBlankObject(obj)) {
                // createMap() fast path --- Safe to avoid hasOwnProperty check because prototype chain is empty
                for (key in obj) {
                    iterator.call(context, obj[key], key, obj);
                }
            } else if (typeof obj.hasOwnProperty === 'function') {
                // Slow path for objects inheriting Object.prototype, hasOwnProperty check needed
                for (key in obj) {
                    if (obj.hasOwnProperty(key)) {
                        iterator.call(context, obj[key], key, obj);
                    }
                }
            } else {
                // Slow path for objects which do not have a method `hasOwnProperty`
                for (key in obj) {
                    if (hasOwnProperty.call(obj, key)) {
                        iterator.call(context, obj[key], key, obj);
                    }
                }
            }
        }
        return obj;
    }

    function forEachSorted(obj, iterator, context) {
        var keys = Object.keys(obj).sort();
        for (var i = 0; i < keys.length; i++) {
            iterator.call(context, obj[keys[i]], keys[i]);
        }
        return keys;
    }


    /**
     * when using forEach the params are value, key, but it is often useful to have key, value.
     * @param {function(string, *)} iteratorFn
     * @returns {function(*, string)}
     */
    function reverseParams(iteratorFn) {
        return function(value, key) {iteratorFn(key, value);};
    }

    /**
     * A consistent way of creating unique IDs in angular.
     *
     * Using simple numbers allows us to generate 28.6 million unique ids per second for 10 years before
     * we hit number precision issues in JavaScript.
     *
     * Math.pow(2,53) / 60 / 60 / 24 / 365 / 10 = 28.6M
     *
     * @returns {number} an unique alpha-numeric string
     */
    function nextUid() {
        return ++uid;
    }


    /**
     * Set or clear the hashkey for an object.
     * @param obj object
     * @param h the hashkey (!truthy to delete the hashkey)
     */
    function setHashKey(obj, h) {
        if (h) {
            obj.$$hashKey = h;
        } else {
            delete obj.$$hashKey;
        }
    }


    function baseExtend(dst, objs, deep) {
        var h = dst.$$hashKey;

        for (var i = 0, ii = objs.length; i < ii; ++i) {
            var obj = objs[i];
            if (!isObject(obj) && !isFunction(obj)) continue;
            var keys = Object.keys(obj);
            for (var j = 0, jj = keys.length; j < jj; j++) {
                var key = keys[j];
                var src = obj[key];

                if (deep && isObject(src)) {
                    if (isDate(src)) {
                        dst[key] = new Date(src.valueOf());
                    } else if (isRegExp(src)) {
                        dst[key] = new RegExp(src);
                    } else if (src.nodeName) {
                        dst[key] = src.cloneNode(true);
                    } else if (isElement(src)) {
                        dst[key] = src.clone();
                    } else {
                        if (!isObject(dst[key])) dst[key] = isArray(src) ? [] : {};
                        baseExtend(dst[key], [src], true);
                    }
                } else {
                    dst[key] = src;
                }
            }
        }

        setHashKey(dst, h);
        return dst;
    }

    /**
     * @ngdoc function
     * @name angular.extend
     * @module ng
     * @kind function
     *
     * @description
     * Extends the destination object `dst` by copying own enumerable properties from the `src` object(s)
     * to `dst`. You can specify multiple `src` objects. If you want to preserve original objects, you can do so
     * by passing an empty object as the target: `var object = angular.extend({}, object1, object2)`.
     *
     * **Note:** Keep in mind that `angular.extend` does not support recursive merge (deep copy). Use
     * {@link angular.merge} for this.
     *
     * @param {Object} dst Destination object.
     * @param {...Object} src Source object(s).
     * @returns {Object} Reference to `dst`.
     */
    function extend(dst) {
        return baseExtend(dst, slice.call(arguments, 1), false);
    }


    /**
     * @ngdoc function
     * @name angular.merge
     * @module ng
     * @kind function
     *
     * @description
     * Deeply extends the destination object `dst` by copying own enumerable properties from the `src` object(s)
     * to `dst`. You can specify multiple `src` objects. If you want to preserve original objects, you can do so
     * by passing an empty object as the target: `var object = angular.merge({}, object1, object2)`.
     *
     * Unlike {@link angular.extend extend()}, `merge()` recursively descends into object properties of source
     * objects, performing a deep copy.
     *
     * @param {Object} dst Destination object.
     * @param {...Object} src Source object(s).
     * @returns {Object} Reference to `dst`.
     */
    function merge(dst) {
        return baseExtend(dst, slice.call(arguments, 1), true);
    }



    function toInt(str) {
        return parseInt(str, 10);
    }

    var isNumberNaN = Number.isNaN || function isNumberNaN(num) {
            // eslint-disable-next-line no-self-compare
            return num !== num;
        };


    function inherit(parent, extra) {
        return extend(Object.create(parent), extra);
    }

    /**
     * @ngdoc function
     * @name angular.noop
     * @module ng
     * @kind function
     *
     * @description
     * A function that performs no operations. This function can be useful when writing code in the
     * functional style.
     ```js
     function foo(callback) {
       var result = calculateResult();
       (callback || angular.noop)(result);
     }
     ```
     */
    function noop() {}
    noop.$inject = [];


    /**
     * @ngdoc function
     * @name angular.identity
     * @module ng
     * @kind function
     *
     * @description
     * A function that returns its first argument. This function is useful when writing code in the
     * functional style.
     *
     ```js
     function transformer(transformationFn, value) {
     return (transformationFn || angular.identity)(value);
   };

     // E.g.
     function getResult(fn, input) {
     return (fn || angular.identity)(input);
   };

     getResult(function(n) { return n * 2; }, 21);   // returns 42
     getResult(null, 21);                            // returns 21
     getResult(undefined, 21);                       // returns 21
     ```
     *
     * @param {*} value to be returned.
     * @returns {*} the value passed in.
     */
    function identity($) {return $;}
    identity.$inject = [];


    function valueFn(value) {return function valueRef() {return value;};}

    function hasCustomToString(obj) {
        return isFunction(obj.toString) && obj.toString !== toString;
    }


    /**
     * @ngdoc function
     * @name angular.isUndefined
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is undefined.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is undefined.
     */
    function isUndefined(value) {return typeof value === 'undefined';}


    /**
     * @ngdoc function
     * @name angular.isDefined
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is defined.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is defined.
     */
    function isDefined(value) {return typeof value !== 'undefined';}


    /**
     * @ngdoc function
     * @name angular.isObject
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is an `Object`. Unlike `typeof` in JavaScript, `null`s are not
     * considered to be objects. Note that JavaScript arrays are objects.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is an `Object` but not `null`.
     */
    function isObject(value) {
        // http://jsperf.com/isobject4
        return value !== null && typeof value === 'object';
    }


    /**
     * Determine if a value is an object with a null prototype
     *
     * @returns {boolean} True if `value` is an `Object` with a null prototype
     */
    function isBlankObject(value) {
        return value !== null && typeof value === 'object' && !getPrototypeOf(value);
    }


    /**
     * @ngdoc function
     * @name angular.isString
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is a `String`.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is a `String`.
     */
    function isString(value) {return typeof value === 'string';}


    /**
     * @ngdoc function
     * @name angular.isNumber
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is a `Number`.
     *
     * This includes the "special" numbers `NaN`, `+Infinity` and `-Infinity`.
     *
     * If you wish to exclude these then you can use the native
     * [`isFinite'](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isFinite)
     * method.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is a `Number`.
     */
    function isNumber(value) {return typeof value === 'number';}


    /**
     * @ngdoc function
     * @name angular.isDate
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a value is a date.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is a `Date`.
     */
    function isDate(value) {
        return toString.call(value) === '[object Date]';
    }


    /**
     * @ngdoc function
     * @name angular.isArray
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is an `Array`.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is an `Array`.
     */
    var isArray = Array.isArray;

    /**
     * @ngdoc function
     * @name angular.isFunction
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is a `Function`.
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is a `Function`.
     */
    function isFunction(value) {return typeof value === 'function';}


    /**
     * Determines if a value is a regular expression object.
     *
     * @private
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is a `RegExp`.
     */
    function isRegExp(value) {
        return toString.call(value) === '[object RegExp]';
    }


    /**
     * Checks if `obj` is a window object.
     *
     * @private
     * @param {*} obj Object to check
     * @returns {boolean} True if `obj` is a window obj.
     */
    function isWindow(obj) {
        return obj && obj.window === obj;
    }


    function isScope(obj) {
        return obj && obj.$evalAsync && obj.$watch;
    }


    function isFile(obj) {
        return toString.call(obj) === '[object File]';
    }


    function isFormData(obj) {
        return toString.call(obj) === '[object FormData]';
    }


    function isBlob(obj) {
        return toString.call(obj) === '[object Blob]';
    }


    function isBoolean(value) {
        return typeof value === 'boolean';
    }


    function isPromiseLike(obj) {
        return obj && isFunction(obj.then);
    }


    var TYPED_ARRAY_REGEXP = /^\[object (?:Uint8|Uint8Clamped|Uint16|Uint32|Int8|Int16|Int32|Float32|Float64)Array\]$/;
    function isTypedArray(value) {
        return value && isNumber(value.length) && TYPED_ARRAY_REGEXP.test(toString.call(value));
    }

    function isArrayBuffer(obj) {
        return toString.call(obj) === '[object ArrayBuffer]';
    }


    var trim = function(value) {
        return isString(value) ? value.trim() : value;
    };

// Copied from:
// http://docs.closure-library.googlecode.com/git/local_closure_goog_string_string.js.source.html#line1021
// Prereq: s is a string.
    var escapeForRegexp = function(s) {
        return s
            .replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, '\\$1')
            // eslint-disable-next-line no-control-regex
            .replace(/\x08/g, '\\x08');
    };


    /**
     * @ngdoc function
     * @name angular.isElement
     * @module ng
     * @kind function
     *
     * @description
     * Determines if a reference is a DOM element (or wrapped jQuery element).
     *
     * @param {*} value Reference to check.
     * @returns {boolean} True if `value` is a DOM element (or wrapped jQuery element).
     */
    function isElement(node) {
        return !!(node &&
        (node.nodeName  // We are a direct element.
        || (node.prop && node.attr && node.find)));  // We have an on and find method part of jQuery API.
    }

    /**
     * @param str 'key1,key2,...'
     * @returns {object} in the form of {key1:true, key2:true, ...}
     */
    function makeMap(str) {
        var obj = {}, items = str.split(','), i;
        for (i = 0; i < items.length; i++) {
            obj[items[i]] = true;
        }
        return obj;
    }


    function nodeName_(element) {
        return lowercase(element.nodeName || (element[0] && element[0].nodeName));
    }

    function includes(array, obj) {
        return Array.prototype.indexOf.call(array, obj) !== -1;
    }

    function arrayRemove(array, value) {
        var index = array.indexOf(value);
        if (index >= 0) {
            array.splice(index, 1);
        }
        return index;
    }

    /**
     * @ngdoc function
     * @name angular.copy
     * @module ng
     * @kind function
     *
     * @description
     * Creates a deep copy of `source`, which should be an object or an array.
     *
     * * If no destination is supplied, a copy of the object or array is created.
     * * If a destination is provided, all of its elements (for arrays) or properties (for objects)
     *   are deleted and then all elements/properties from the source are copied to it.
     * * If `source` is not an object or array (inc. `null` and `undefined`), `source` is returned.
     * * If `source` is identical to `destination` an exception will be thrown.
     *
     * <br />
     * <div class="alert alert-warning">
     *   Only enumerable properties are taken into account. Non-enumerable properties (both on `source`
     *   and on `destination`) will be ignored.
     * </div>
     *
     * @param {*} source The source that will be used to make a copy.
     *                   Can be any type, including primitives, `null`, and `undefined`.
     * @param {(Object|Array)=} destination Destination into which the source is copied. If
     *     provided, must be of the same type as `source`.
     * @returns {*} The copy or updated `destination`, if `destination` was specified.
     *
     * @example
     <example module="copyExample" name="angular-copy">
     <file name="index.html">
     <div ng-controller="ExampleController">
     <form novalidate class="simple-form">
     <label>Name: <input type="text" ng-model="user.name" /></label><br />
     <label>Age:  <input type="number" ng-model="user.age" /></label><br />
     Gender: <label><input type="radio" ng-model="user.gender" value="male" />male</label>
     <label><input type="radio" ng-model="user.gender" value="female" />female</label><br />
     <button ng-click="reset()">RESET</button>
     <button ng-click="update(user)">SAVE</button>
     </form>
     <pre>form = {{user | json}}</pre>
     <pre>master = {{master | json}}</pre>
     </div>
     </file>
     <file name="script.js">
     // Module: copyExample
     angular.
     module('copyExample', []).
     controller('ExampleController', ['$scope', function($scope) {
          $scope.master = {};

          $scope.reset = function() {
            // Example with 1 argument
            $scope.user = angular.copy($scope.master);
          };

          $scope.update = function(user) {
            // Example with 2 arguments
            angular.copy(user, $scope.master);
          };

          $scope.reset();
        }]);
     </file>
     </example>
     */
    function copy(source, destination) {
        var stackSource = [];
        var stackDest = [];

        if (destination) {
            if (isTypedArray(destination) || isArrayBuffer(destination)) {
                throw ngMinErr('cpta', 'Can\'t copy! TypedArray destination cannot be mutated.');
            }
            if (source === destination) {
                throw ngMinErr('cpi', 'Can\'t copy! Source and destination are identical.');
            }

            // Empty the destination object
            if (isArray(destination)) {
                destination.length = 0;
            } else {
                forEach(destination, function(value, key) {
                    if (key !== '$$hashKey') {
                        delete destination[key];
                    }
                });
            }

            stackSource.push(source);
            stackDest.push(destination);
            return copyRecurse(source, destination);
        }

        return copyElement(source);

        function copyRecurse(source, destination) {
            var h = destination.$$hashKey;
            var key;
            if (isArray(source)) {
                for (var i = 0, ii = source.length; i < ii; i++) {
                    destination.push(copyElement(source[i]));
                }
            } else if (isBlankObject(source)) {
                // createMap() fast path --- Safe to avoid hasOwnProperty check because prototype chain is empty
                for (key in source) {
                    destination[key] = copyElement(source[key]);
                }
            } else if (source && typeof source.hasOwnProperty === 'function') {
                // Slow path, which must rely on hasOwnProperty
                for (key in source) {
                    if (source.hasOwnProperty(key)) {
                        destination[key] = copyElement(source[key]);
                    }
                }
            } else {
                // Slowest path --- hasOwnProperty can't be called as a method
                for (key in source) {
                    if (hasOwnProperty.call(source, key)) {
                        destination[key] = copyElement(source[key]);
                    }
                }
            }
            setHashKey(destination, h);
            return destination;
        }

        function copyElement(source) {
            // Simple values
            if (!isObject(source)) {
                return source;
            }

            // Already copied values
            var index = stackSource.indexOf(source);
            if (index !== -1) {
                return stackDest[index];
            }

            if (isWindow(source) || isScope(source)) {
                throw ngMinErr('cpws',
                    'Can\'t copy! Making copies of Window or Scope instances is not supported.');
            }

            var needsRecurse = false;
            var destination = copyType(source);

            if (destination === undefined) {
                destination = isArray(source) ? [] : Object.create(getPrototypeOf(source));
                needsRecurse = true;
            }

            stackSource.push(source);
            stackDest.push(destination);

            return needsRecurse
                ? copyRecurse(source, destination)
                : destination;
        }

        function copyType(source) {
            switch (toString.call(source)) {
                case '[object Int8Array]':
                case '[object Int16Array]':
                case '[object Int32Array]':
                case '[object Float32Array]':
                case '[object Float64Array]':
                case '[object Uint8Array]':
                case '[object Uint8ClampedArray]':
                case '[object Uint16Array]':
                case '[object Uint32Array]':
                    return new source.constructor(copyElement(source.buffer), source.byteOffset, source.length);

                case '[object ArrayBuffer]':
                    // Support: IE10
                    if (!source.slice) {
                        // If we're in this case we know the environment supports ArrayBuffer
                        /* eslint-disable no-undef */
                        var copied = new ArrayBuffer(source.byteLength);
                        new Uint8Array(copied).set(new Uint8Array(source));
                        /* eslint-enable */
                        return copied;
                    }
                    return source.slice(0);

                case '[object Boolean]':
                case '[object Number]':
                case '[object String]':
                case '[object Date]':
                    return new source.constructor(source.valueOf());

                case '[object RegExp]':
                    var re = new RegExp(source.source, source.toString().match(/[^\/]*$/)[0]);
                    re.lastIndex = source.lastIndex;
                    return re;

                case '[object Blob]':
                    return new source.constructor([source], {type: source.type});
            }

            if (isFunction(source.cloneNode)) {
                return source.cloneNode(true);
            }
        }
    }


    /**
     * @ngdoc function
     * @name angular.equals
     * @module ng
     * @kind function
     *
     * @description
     * Determines if two objects or two values are equivalent. Supports value types, regular
     * expressions, arrays and objects.
     *
     * Two objects or values are considered equivalent if at least one of the following is true:
     *
     * * Both objects or values pass `===` comparison.
     * * Both objects or values are of the same type and all of their properties are equal by
     *   comparing them with `angular.equals`.
     * * Both values are NaN. (In JavaScript, NaN == NaN => false. But we consider two NaN as equal)
     * * Both values represent the same regular expression (In JavaScript,
     *   /abc/ == /abc/ => false. But we consider two regular expressions as equal when their textual
     *   representation matches).
     *
     * During a property comparison, properties of `function` type and properties with names
     * that begin with `$` are ignored.
     *
     * Scope and DOMWindow objects are being compared only by identify (`===`).
     *
     * @param {*} o1 Object or value to compare.
     * @param {*} o2 Object or value to compare.
     * @returns {boolean} True if arguments are equal.
     *
     * @example
     <example module="equalsExample" name="equalsExample">
     <file name="index.html">
     <div ng-controller="ExampleController">
     <form novalidate>
     <h3>User 1</h3>
     Name: <input type="text" ng-model="user1.name">
     Age: <input type="number" ng-model="user1.age">

     <h3>User 2</h3>
     Name: <input type="text" ng-model="user2.name">
     Age: <input type="number" ng-model="user2.age">

     <div>
     <br/>
     <input type="button" value="Compare" ng-click="compare()">
     </div>
     User 1: <pre>{{user1 | json}}</pre>
     User 2: <pre>{{user2 | json}}</pre>
     Equal: <pre>{{result}}</pre>
     </form>
     </div>
     </file>
     <file name="script.js">
     angular.module('equalsExample', []).controller('ExampleController', ['$scope', function($scope) {
          $scope.user1 = {};
          $scope.user2 = {};
          $scope.compare = function() {
            $scope.result = angular.equals($scope.user1, $scope.user2);
          };
        }]);
     </file>
     </example>
     */
    function equals(o1, o2) {
        if (o1 === o2) return true;
        if (o1 === null || o2 === null) return false;
        // eslint-disable-next-line no-self-compare
        if (o1 !== o1 && o2 !== o2) return true; // NaN === NaN
        var t1 = typeof o1, t2 = typeof o2, length, key, keySet;
        if (t1 === t2 && t1 === 'object') {
            if (isArray(o1)) {
                if (!isArray(o2)) return false;
                if ((length = o1.length) === o2.length) {
                    for (key = 0; key < length; key++) {
                        if (!equals(o1[key], o2[key])) return false;
                    }
                    return true;
                }
            } else if (isDate(o1)) {
                if (!isDate(o2)) return false;
                return equals(o1.getTime(), o2.getTime());
            } else if (isRegExp(o1)) {
                if (!isRegExp(o2)) return false;
                return o1.toString() === o2.toString();
            } else {
                if (isScope(o1) || isScope(o2) || isWindow(o1) || isWindow(o2) ||
                    isArray(o2) || isDate(o2) || isRegExp(o2)) return false;
                keySet = createMap();
                for (key in o1) {
                    if (key.charAt(0) === '$' || isFunction(o1[key])) continue;
                    if (!equals(o1[key], o2[key])) return false;
                    keySet[key] = true;
                }
                for (key in o2) {
                    if (!(key in keySet) &&
                        key.charAt(0) !== '$' &&
                        isDefined(o2[key]) &&
                        !isFunction(o2[key])) return false;
                }
                return true;
            }
        }
        return false;
    }

    var csp = function() {
        if (!isDefined(csp.rules)) {


            var ngCspElement = (window.document.querySelector('[ng-csp]') ||
            window.document.querySelector('[data-ng-csp]'));

            if (ngCspElement) {
                var ngCspAttribute = ngCspElement.getAttribute('ng-csp') ||
                    ngCspElement.getAttribute('data-ng-csp');
                csp.rules = {
                    noUnsafeEval: !ngCspAttribute || (ngCspAttribute.indexOf('no-unsafe-eval') !== -1),
                    noInlineStyle: !ngCspAttribute || (ngCspAttribute.indexOf('no-inline-style') !== -1)
                };
            } else {
                csp.rules = {
                    noUnsafeEval: noUnsafeEval(),
                    noInlineStyle: false
                };
            }
        }

        return csp.rules;

        function noUnsafeEval() {
            try {
                // eslint-disable-next-line no-new, no-new-func
                new Function('');
                return false;
            } catch (e) {
                return true;
            }
        }
    };

    /**
     * @ngdoc directive
     * @module ng
     * @name ngJq
     *
     * @element ANY
     * @param {string=} ngJq the name of the library available under `window`
     * to be used for angular.element
     * @description
     * Use this directive to force the angular.element library.  This should be
     * used to force either jqLite by leaving ng-jq blank or setting the name of
     * the jquery variable under window (eg. jQuery).
     *
     * Since angular looks for this directive when it is loaded (doesn't wait for the
     * DOMContentLoaded event), it must be placed on an element that comes before the script
     * which loads angular. Also, only the first instance of `ng-jq` will be used and all
     * others ignored.
     *
     * @example
     * This example shows how to force jqLite using the `ngJq` directive to the `html` tag.
     ```html
     <!doctype html>
     <html ng-app ng-jq>
     ...
     ...
     </html>
     ```
     * @example
     * This example shows how to use a jQuery based library of a different name.
     * The library name must be available at the top most 'window'.
     ```html
     <!doctype html>
     <html ng-app ng-jq="jQueryLib">
     ...
     ...
     </html>
     ```
     */
    var jq = function() {
        if (isDefined(jq.name_)) return jq.name_;
        var el;
        var i, ii = ngAttrPrefixes.length, prefix, name;
        for (i = 0; i < ii; ++i) {
            prefix = ngAttrPrefixes[i];
            el = window.document.querySelector('[' + prefix.replace(':', '\\:') + 'jq]');
            if (el) {
                name = el.getAttribute(prefix + 'jq');
                break;
            }
        }

        return (jq.name_ = name);
    };

    function concat(array1, array2, index) {
        return array1.concat(slice.call(array2, index));
    }

    function sliceArgs(args, startIndex) {
        return slice.call(args, startIndex || 0);
    }


    /**
     * @ngdoc function
     * @name angular.bind
     * @module ng
     * @kind function
     *
     * @description
     * Returns a function which calls function `fn` bound to `self` (`self` becomes the `this` for
     * `fn`). You can supply optional `args` that are prebound to the function. This feature is also
     * known as [partial application](http://en.wikipedia.org/wiki/Partial_application), as
     * distinguished from [function currying](http://en.wikipedia.org/wiki/Currying#Contrast_with_partial_function_application).
     *
     * @param {Object} self Context which `fn` should be evaluated in.
     * @param {function()} fn Function to be bound.
     * @param {...*} args Optional arguments to be prebound to the `fn` function call.
     * @returns {function()} Function that wraps the `fn` with all the specified bindings.
     */
    function bind(self, fn) {
        var curryArgs = arguments.length > 2 ? sliceArgs(arguments, 2) : [];
        if (isFunction(fn) && !(fn instanceof RegExp)) {
            return curryArgs.length
                ? function() {
                return arguments.length
                    ? fn.apply(self, concat(curryArgs, arguments, 0))
                    : fn.apply(self, curryArgs);
            }
                : function() {
                return arguments.length
                    ? fn.apply(self, arguments)
                    : fn.call(self);
            };
        } else {
            // In IE, native methods are not functions so they cannot be bound (note: they don't need to be).
            return fn;
        }
    }


    function toJsonReplacer(key, value) {
        var val = value;

        if (typeof key === 'string' && key.charAt(0) === '$' && key.charAt(1) === '$') {
            val = undefined;
        } else if (isWindow(value)) {
            val = '$WINDOW';
        } else if (value &&  window.document === value) {
            val = '$DOCUMENT';
        } else if (isScope(value)) {
            val = '$SCOPE';
        }

        return val;
    }


    /**
     * @ngdoc function
     * @name angular.toJson
     * @module ng
     * @kind function
     *
     * @description
     * Serializes input into a JSON-formatted string. Properties with leading $$ characters will be
     * stripped since angular uses this notation internally.
     *
     * @param {Object|Array|Date|string|number} obj Input to be serialized into JSON.
     * @param {boolean|number} [pretty=2] If set to true, the JSON output will contain newlines and whitespace.
     *    If set to an integer, the JSON output will contain that many spaces per indentation.
     * @returns {string|undefined} JSON-ified string representing `obj`.
     * @knownIssue
     *
     * The Safari browser throws a `RangeError` instead of returning `null` when it tries to stringify a `Date`
     * object with an invalid date value. The only reliable way to prevent this is to monkeypatch the
     * `Date.prototype.toJSON` method as follows:
     *
     * ```
     * var _DatetoJSON = Date.prototype.toJSON;
     * Date.prototype.toJSON = function() {
 *   try {
 *     return _DatetoJSON.call(this);
 *   } catch(e) {
 *     if (e instanceof RangeError) {
 *       return null;
 *     }
 *     throw e;
 *   }
 * };
     * ```
     *
     * See https://github.com/angular/angular.js/pull/14221 for more information.
     */
    function toJson(obj, pretty) {
        if (isUndefined(obj)) return undefined;
        if (!isNumber(pretty)) {
            pretty = pretty ? 2 : null;
        }
        return JSON.stringify(obj, toJsonReplacer, pretty);
    }


    /**
     * @ngdoc function
     * @name angular.fromJson
     * @module ng
     * @kind function
     *
     * @description
     * Deserializes a JSON string.
     *
     * @param {string} json JSON string to deserialize.
     * @returns {Object|Array|string|number} Deserialized JSON string.
     */
    function fromJson(json) {
        return isString(json)
            ? JSON.parse(json)
            : json;
    }


    var ALL_COLONS = /:/g;
    function timezoneToOffset(timezone, fallback) {
        // IE/Edge do not "understand" colon (`:`) in timezone
        timezone = timezone.replace(ALL_COLONS, '');
        var requestedTimezoneOffset = Date.parse('Jan 01, 1970 00:00:00 ' + timezone) / 60000;
        return isNumberNaN(requestedTimezoneOffset) ? fallback : requestedTimezoneOffset;
    }


    function addDateMinutes(date, minutes) {
        date = new Date(date.getTime());
        date.setMinutes(date.getMinutes() + minutes);
        return date;
    }


    function convertTimezoneToLocal(date, timezone, reverse) {
        reverse = reverse ? -1 : 1;
        var dateTimezoneOffset = date.getTimezoneOffset();
        var timezoneOffset = timezoneToOffset(timezone, dateTimezoneOffset);
        return addDateMinutes(date, reverse * (timezoneOffset - dateTimezoneOffset));
    }


    /**
     * @returns {string} Returns the string representation of the element.
     */
    function startingTag(element) {
        element = jqLite(element).clone();
        try {
            // turns out IE does not let you set .html() on elements which
            // are not allowed to have children. So we just ignore it.
            element.empty();
        } catch (e) { /* empty */ }
        var elemHtml = jqLite('<div>').append(element).html();
        try {
            return element[0].nodeType === NODE_TYPE_TEXT ? lowercase(elemHtml) :
                elemHtml.
                match(/^(<[^>]+>)/)[1].
                replace(/^<([\w\-]+)/, function(match, nodeName) {return '<' + lowercase(nodeName);});
        } catch (e) {
            return lowercase(elemHtml);
        }

    }


/////////////////////////////////////////////////

    /**
     * Tries to decode the URI component without throwing an exception.
     *
     * @private
     * @param str value potential URI component to check.
     * @returns {boolean} True if `value` can be decoded
     * with the decodeURIComponent function.
     */
    function tryDecodeURIComponent(value) {
        try {
            return decodeURIComponent(value);
        } catch (e) {
            // Ignore any invalid uri component.
        }
    }


    /**
     * Parses an escaped url query string into key-value pairs.
     * @returns {Object.<string,boolean|Array>}
     */
    function parseKeyValue(/**string*/keyValue) {
        var obj = {};
        forEach((keyValue || '').split('&'), function(keyValue) {
            var splitPoint, key, val;
            if (keyValue) {
                key = keyValue = keyValue.replace(/\+/g,'%20');
                splitPoint = keyValue.indexOf('=');
                if (splitPoint !== -1) {
                    key = keyValue.substring(0, splitPoint);
                    val = keyValue.substring(splitPoint + 1);
                }
                key = tryDecodeURIComponent(key);
                if (isDefined(key)) {
                    val = isDefined(val) ? tryDecodeURIComponent(val) : true;
                    if (!hasOwnProperty.call(obj, key)) {
                        obj[key] = val;
                    } else if (isArray(obj[key])) {
                        obj[key].push(val);
                    } else {
                        obj[key] = [obj[key],val];
                    }
                }
            }
        });
        return obj;
    }

    function toKeyValue(obj) {
        var parts = [];
        forEach(obj, function(value, key) {
            if (isArray(value)) {
                forEach(value, function(arrayValue) {
                    parts.push(encodeUriQuery(key, true) +
                        (arrayValue === true ? '' : '=' + encodeUriQuery(arrayValue, true)));
                });
            } else {
                parts.push(encodeUriQuery(key, true) +
                    (value === true ? '' : '=' + encodeUriQuery(value, true)));
            }
        });
        return parts.length ? parts.join('&') : '';
    }


    /**
     * We need our custom method because encodeURIComponent is too aggressive and doesn't follow
     * http://www.ietf.org/rfc/rfc3986.txt with regards to the character set (pchar) allowed in path
     * segments:
     *    segment       = *pchar
     *    pchar         = unreserved / pct-encoded / sub-delims / ":" / "@"
     *    pct-encoded   = "%" HEXDIG HEXDIG
     *    unreserved    = ALPHA / DIGIT / "-" / "." / "_" / "~"
     *    sub-delims    = "!" / "$" / "&" / "'" / "(" / ")"
     *                     / "*" / "+" / "," / ";" / "="
     */
    function encodeUriSegment(val) {
        return encodeUriQuery(val, true).
        replace(/%26/gi, '&').
        replace(/%3D/gi, '=').
        replace(/%2B/gi, '+');
    }


    /**
     * This method is intended for encoding *key* or *value* parts of query component. We need a custom
     * method because encodeURIComponent is too aggressive and encodes stuff that doesn't have to be
     * encoded per http://tools.ietf.org/html/rfc3986:
     *    query       = *( pchar / "/" / "?" )
     *    pchar         = unreserved / pct-encoded / sub-delims / ":" / "@"
     *    unreserved    = ALPHA / DIGIT / "-" / "." / "_" / "~"
     *    pct-encoded   = "%" HEXDIG HEXDIG
     *    sub-delims    = "!" / "$" / "&" / "'" / "(" / ")"
     *                     / "*" / "+" / "," / ";" / "="
     */
    function encodeUriQuery(val, pctEncodeSpaces) {
        return encodeURIComponent(val).
        replace(/%40/gi, '@').
        replace(/%3A/gi, ':').
        replace(/%24/g, '$').
        replace(/%2C/gi, ',').
        replace(/%3B/gi, ';').
        replace(/%20/g, (pctEncodeSpaces ? '%20' : '+'));
    }

    var ngAttrPrefixes = ['ng-', 'data-ng-', 'ng:', 'x-ng-'];

    function getNgAttribute(element, ngAttr) {
        var attr, i, ii = ngAttrPrefixes.length;
        for (i = 0; i < ii; ++i) {
            attr = ngAttrPrefixes[i] + ngAttr;
            if (isString(attr = element.getAttribute(attr))) {
                return attr;
            }
        }
        return null;
    }

    function allowAutoBootstrap(document) {
        if (!document.currentScript) {
            return true;
        }
        var src = document.currentScript.getAttribute('src');
        var link = document.createElement('a');
        link.href = src;
        var scriptProtocol = link.protocol;
        var docLoadProtocol = document.location.protocol;
        if (docLoadProtocol === scriptProtocol) {
            return true;
        }
        switch (scriptProtocol) {
            case 'http:':
            case 'https:':
            case 'ftp:':
            case 'blob:':
            case 'file:':
            case 'data:':
                return true;
            default:
                return false;
        }
    }

// Cached as it has to run during loading so that document.currentScript is available.
    var isAutoBootstrapAllowed = allowAutoBootstrap(window.document);

    /**
     * @ngdoc directive
     * @name ngApp
     * @module ng
     *
     * @element ANY
     * @param {angular.Module} ngApp an optional application
     *   {@link angular.module module} name to load.
     * @param {boolean=} ngStrictDi if this attribute is present on the app element, the injector will be
     *   created in "strict-di" mode. This means that the application will fail to invoke functions which
     *   do not use explicit function annotation (and are thus unsuitable for minification), as described
     *   in {@link guide/di the Dependency Injection guide}, and useful debugging info will assist in
     *   tracking down the root of these bugs.
     *
     * @description
     *
     * Use this directive to **auto-bootstrap** an AngularJS application. The `ngApp` directive
     * designates the **root element** of the application and is typically placed near the root element
     * of the page - e.g. on the `<body>` or `<html>` tags.
     *
     * There are a few things to keep in mind when using `ngApp`:
     * - only one AngularJS application can be auto-bootstrapped per HTML document. The first `ngApp`
     *   found in the document will be used to define the root element to auto-bootstrap as an
     *   application. To run multiple applications in an HTML document you must manually bootstrap them using
     *   {@link angular.bootstrap} instead.
     * - AngularJS applications cannot be nested within each other.
     * - Do not use a directive that uses {@link ng.$compile#transclusion transclusion} on the same element as `ngApp`.
     *   This includes directives such as {@link ng.ngIf `ngIf`}, {@link ng.ngInclude `ngInclude`} and
     *   {@link ngRoute.ngView `ngView`}.
     *   Doing this misplaces the app {@link ng.$rootElement `$rootElement`} and the app's {@link auto.$injector injector},
     *   causing animations to stop working and making the injector inaccessible from outside the app.
     *
     * You can specify an **AngularJS module** to be used as the root module for the application.  This
     * module will be loaded into the {@link auto.$injector} when the application is bootstrapped. It
     * should contain the application code needed or have dependencies on other modules that will
     * contain the code. See {@link angular.module} for more information.
     *
     * In the example below if the `ngApp` directive were not placed on the `html` element then the
     * document would not be compiled, the `AppController` would not be instantiated and the `{{ a+b }}`
     * would not be resolved to `3`.
     *
     * `ngApp` is the easiest, and most common way to bootstrap an application.
     *
     <example module="ngAppDemo" name="ng-app">
     <file name="index.html">
     <div ng-controller="ngAppDemoController">
     I can add: {{a}} + {{b}} =  {{ a+b }}
     </div>
     </file>
     <file name="script.js">
     angular.module('ngAppDemo', []).controller('ngAppDemoController', function($scope) {
     $scope.a = 1;
     $scope.b = 2;
   });
     </file>
     </example>
     *
     * Using `ngStrictDi`, you would see something like this:
     *
     <example ng-app-included="true" name="strict-di">
     <file name="index.html">
     <div ng-app="ngAppStrictDemo" ng-strict-di>
     <div ng-controller="GoodController1">
     I can add: {{a}} + {{b}} =  {{ a+b }}

     <p>This renders because the controller does not fail to
     instantiate, by using explicit annotation style (see
     script.js for details)
     </p>
     </div>

     <div ng-controller="GoodController2">
     Name: <input ng-model="name"><br />
     Hello, {{name}}!

     <p>This renders because the controller does not fail to
     instantiate, by using explicit annotation style
     (see script.js for details)
     </p>
     </div>

     <div ng-controller="BadController">
     I can add: {{a}} + {{b}} =  {{ a+b }}

     <p>The controller could not be instantiated, due to relying
     on automatic function annotations (which are disabled in
     strict mode). As such, the content of this section is not
     interpolated, and there should be an error in your web console.
     </p>
     </div>
     </div>
     </file>
     <file name="script.js">
     angular.module('ngAppStrictDemo', [])
     // BadController will fail to instantiate, due to relying on automatic function annotation,
     // rather than an explicit annotation
     .controller('BadController', function($scope) {
       $scope.a = 1;
       $scope.b = 2;
     })
     // Unlike BadController, GoodController1 and GoodController2 will not fail to be instantiated,
     // due to using explicit annotations using the array style and $inject property, respectively.
     .controller('GoodController1', ['$scope', function($scope) {
       $scope.a = 1;
       $scope.b = 2;
     }])
     .controller('GoodController2', GoodController2);
     function GoodController2($scope) {
       $scope.name = 'World';
     }
     GoodController2.$inject = ['$scope'];
     </file>
     <file name="style.css">
     div[ng-controller] {
       margin-bottom: 1em;
       -webkit-border-radius: 4px;
       border-radius: 4px;
       border: 1px solid;
       padding: .5em;
   }
     div[ng-controller^=Good] {
       border-color: #d6e9c6;
       background-color: #dff0d8;
       color: #3c763d;
   }
     div[ng-controller^=Bad] {
       border-color: #ebccd1;
       background-color: #f2dede;
       color: #a94442;
       margin-bottom: 0;
   }
     </file>
     </example>
     */
    function angularInit(element, bootstrap) {
        var appElement,
            module,
            config = {};

        // The element `element` has priority over any other element.
        forEach(ngAttrPrefixes, function(prefix) {
            var name = prefix + 'app';

            if (!appElement && element.hasAttribute && element.hasAttribute(name)) {
                appElement = element;
                module = element.getAttribute(name);
            }
        });
        forEach(ngAttrPrefixes, function(prefix) {
            var name = prefix + 'app';
            var candidate;

            if (!appElement && (candidate = element.querySelector('[' + name.replace(':', '\\:') + ']'))) {
                appElement = candidate;
                module = candidate.getAttribute(name);
            }
        });
        if (appElement) {
            if (!isAutoBootstrapAllowed) {
                window.console.error('Angular: disabling automatic bootstrap. <script> protocol indicates ' +
                    'an extension, document.location.href does not match.');
                return;
            }
            config.strictDi = getNgAttribute(appElement, 'strict-di') !== null;
            bootstrap(appElement, module ? [module] : [], config);
        }
    }

    /**
     * @ngdoc function
     * @name angular.bootstrap
     * @module ng
     * @description
     * Use this function to manually start up angular application.
     *
     * For more information, see the {@link guide/bootstrap Bootstrap guide}.
     *
     * Angular will detect if it has been loaded into the browser more than once and only allow the
     * first loaded script to be bootstrapped and will report a warning to the browser console for
     * each of the subsequent scripts. This prevents strange results in applications, where otherwise
     * multiple instances of Angular try to work on the DOM.
     *
     * <div class="alert alert-warning">
     * **Note:** Protractor based end-to-end tests cannot use this function to bootstrap manually.
     * They must use {@link ng.directive:ngApp ngApp}.
     * </div>
     *
     * <div class="alert alert-warning">
     * **Note:** Do not bootstrap the app on an element with a directive that uses {@link ng.$compile#transclusion transclusion},
     * such as {@link ng.ngIf `ngIf`}, {@link ng.ngInclude `ngInclude`} and {@link ngRoute.ngView `ngView`}.
     * Doing this misplaces the app {@link ng.$rootElement `$rootElement`} and the app's {@link auto.$injector injector},
     * causing animations to stop working and making the injector inaccessible from outside the app.
     * </div>
     *
     * ```html
     * <!doctype html>
     * <html>
     * <body>
     * <div ng-controller="WelcomeController">
     *   {{greeting}}
     * </div>
     *
     * <script src="angular.js"></script>
     * <script>
     *   var app = angular.module('demo', [])
     *   .controller('WelcomeController', function($scope) {
 *       $scope.greeting = 'Welcome!';
 *   });
     *   angular.bootstrap(document, ['demo']);
     * </script>
     * </body>
     * </html>
     * ```
     *
     * @param {DOMElement} element DOM element which is the root of angular application.
     * @param {Array<String|Function|Array>=} modules an array of modules to load into the application.
     *     Each item in the array should be the name of a predefined module or a (DI annotated)
     *     function that will be invoked by the injector as a `config` block.
     *     See: {@link angular.module modules}
     * @param {Object=} config an object for defining configuration options for the application. The
     *     following keys are supported:
     *
     * * `strictDi` - disable automatic function annotation for the application. This is meant to
     *   assist in finding bugs which break minified code. Defaults to `false`.
     *
     * @returns {auto.$injector} Returns the newly created injector for this app.
     */
    function bootstrap(element, modules, config) {
        if (!isObject(config)) config = {};
        var defaultConfig = {
            strictDi: false
        };
        config = extend(defaultConfig, config);
        var doBootstrap = function() {
            element = jqLite(element);

            if (element.injector()) {
                var tag = (element[0] === window.document) ? 'document' : startingTag(element);
                // Encode angle brackets to prevent input from being sanitized to empty string #8683.
                throw ngMinErr(
                    'btstrpd',
                    'App already bootstrapped with this element \'{0}\'',
                    tag.replace(/</,'&lt;').replace(/>/,'&gt;'));
            }

            modules = modules || [];
            modules.unshift(['$provide', function($provide) {
                $provide.value('$rootElement', element);
            }]);

            if (config.debugInfoEnabled) {
                // Pushing so that this overrides `debugInfoEnabled` setting defined in user's `modules`.
                modules.push(['$compileProvider', function($compileProvider) {
                    $compileProvider.debugInfoEnabled(true);
                }]);
            }

            modules.unshift('ng');
            var injector = createInjector(modules, config.strictDi);
            injector.invoke(['$rootScope', '$rootElement', '$compile', '$injector',
                function bootstrapApply(scope, element, compile, injector) {
                    scope.$apply(function() {
                        element.data('$injector', injector);
                        compile(element)(scope);
                    });
                }]
            );
            return injector;
        };

        var NG_ENABLE_DEBUG_INFO = /^NG_ENABLE_DEBUG_INFO!/;
        var NG_DEFER_BOOTSTRAP = /^NG_DEFER_BOOTSTRAP!/;

        if (window && NG_ENABLE_DEBUG_INFO.test(window.name)) {
            config.debugInfoEnabled = true;
            window.name = window.name.replace(NG_ENABLE_DEBUG_INFO, '');
        }

        if (window && !NG_DEFER_BOOTSTRAP.test(window.name)) {
            return doBootstrap();
        }

        window.name = window.name.replace(NG_DEFER_BOOTSTRAP, '');
        angular.resumeBootstrap = function(extraModules) {
            forEach(extraModules, function(module) {
                modules.push(module);
            });
            return doBootstrap();
        };

        if (isFunction(angular.resumeDeferredBootstrap)) {
            angular.resumeDeferredBootstrap();
        }
    }

    /**
     * @ngdoc function
     * @name angular.reloadWithDebugInfo
     * @module ng
     * @description
     * Use this function to reload the current application with debug information turned on.
     * This takes precedence over a call to `$compileProvider.debugInfoEnabled(false)`.
     *
     * See {@link ng.$compileProvider#debugInfoEnabled} for more.
     */
    function reloadWithDebugInfo() {
        window.name = 'NG_ENABLE_DEBUG_INFO!' + window.name;
        window.location.reload();
    }

    /**
     * @name angular.getTestability
     * @module ng
     * @description
     * Get the testability service for the instance of Angular on the given
     * element.
     * @param {DOMElement} element DOM element which is the root of angular application.
     */
    function getTestability(rootElement) {
        var injector = angular.element(rootElement).injector();
        if (!injector) {
            throw ngMinErr('test',
                'no injector found for element argument to getTestability');
        }
        return injector.get('$$testability');
    }

    var SNAKE_CASE_REGEXP = /[A-Z]/g;
    function snake_case(name, separator) {
        separator = separator || '_';
        return name.replace(SNAKE_CASE_REGEXP, function(letter, pos) {
            return (pos ? separator : '') + letter.toLowerCase();
        });
    }

    var bindJQueryFired = false;
    function bindJQuery() {
        var originalCleanData;

        if (bindJQueryFired) {
            return;
        }

        // bind to jQuery if present;
        var jqName = jq();
        jQuery = isUndefined(jqName) ? window.jQuery :   // use jQuery (if present)
            !jqName             ? undefined     :   // use jqLite
                window[jqName];   // use jQuery specified by `ngJq`

        // Use jQuery if it exists with proper functionality, otherwise default to us.
        // Angular 1.2+ requires jQuery 1.7+ for on()/off() support.
        // Angular 1.3+ technically requires at least jQuery 2.1+ but it may work with older
        // versions. It will not work for sure with jQuery <1.7, though.
        if (jQuery && jQuery.fn.on) {
            jqLite = jQuery;
            extend(jQuery.fn, {
                scope: JQLitePrototype.scope,
                isolateScope: JQLitePrototype.isolateScope,
                controller: JQLitePrototype.controller,
                injector: JQLitePrototype.injector,
                inheritedData: JQLitePrototype.inheritedData
            });

            // All nodes removed from the DOM via various jQuery APIs like .remove()
            // are passed through jQuery.cleanData. Monkey-patch this method to fire
            // the $destroy event on all removed nodes.
            originalCleanData = jQuery.cleanData;
            jQuery.cleanData = function(elems) {
                var events;
                for (var i = 0, elem; (elem = elems[i]) != null; i++) {
                    events = jQuery._data(elem, 'events');
                    if (events && events.$destroy) {
                        jQuery(elem).triggerHandler('$destroy');
                    }
                }
                originalCleanData(elems);
            };
        } else {
            jqLite = JQLite;
        }

        angular.element = jqLite;

        // Prevent double-proxying.
        bindJQueryFired = true;
    }

    /**
     * throw error if the argument is falsy.
     */
    function assertArg(arg, name, reason) {
        if (!arg) {
            throw ngMinErr('areq', 'Argument \'{0}\' is {1}', (name || '?'), (reason || 'required'));
        }
        return arg;
    }

    function assertArgFn(arg, name, acceptArrayAnnotation) {
        if (acceptArrayAnnotation && isArray(arg)) {
            arg = arg[arg.length - 1];
        }

        assertArg(isFunction(arg), name, 'not a function, got ' +
            (arg && typeof arg === 'object' ? arg.constructor.name || 'Object' : typeof arg));
        return arg;
    }

    /**
     * throw error if the name given is hasOwnProperty
     * @param  {String} name    the name to test
     * @param  {String} context the context in which the name is used, such as module or directive
     */
    function assertNotHasOwnProperty(name, context) {
        if (name === 'hasOwnProperty') {
            throw ngMinErr('badname', 'hasOwnProperty is not a valid {0} name', context);
        }
    }

    /**
     * Return the value accessible from the object by path. Any undefined traversals are ignored
     * @param {Object} obj starting object
     * @param {String} path path to traverse
     * @param {boolean} [bindFnToScope=true]
     * @returns {Object} value as accessible by path
     */
//TODO(misko): this function needs to be removed
    function getter(obj, path, bindFnToScope) {
        if (!path) return obj;
        var keys = path.split('.');
        var key;
        var lastInstance = obj;
        var len = keys.length;

        for (var i = 0; i < len; i++) {
            key = keys[i];
            if (obj) {
                obj = (lastInstance = obj)[key];
            }
        }
        if (!bindFnToScope && isFunction(obj)) {
            return bind(lastInstance, obj);
        }
        return obj;
    }

    /**
     * Return the DOM siblings between the first and last node in the given array.
     * @param {Array} array like object
     * @returns {Array} the inputted object or a jqLite collection containing the nodes
     */
    function getBlockNodes(nodes) {
        // TODO(perf): update `nodes` instead of creating a new object?
        var node = nodes[0];
        var endNode = nodes[nodes.length - 1];
        var blockNodes;

        for (var i = 1; node !== endNode && (node = node.nextSibling); i++) {
            if (blockNodes || nodes[i] !== node) {
                if (!blockNodes) {
                    blockNodes = jqLite(slice.call(nodes, 0, i));
                }
                blockNodes.push(node);
            }
        }

        return blockNodes || nodes;
    }


    /**
     * Creates a new object without a prototype. This object is useful for lookup without having to
     * guard against prototypically inherited properties via hasOwnProperty.
     *
     * Related micro-benchmarks:
     * - http://jsperf.com/object-create2
     * - http://jsperf.com/proto-map-lookup/2
     * - http://jsperf.com/for-in-vs-object-keys2
     *
     * @returns {Object}
     */
    function createMap() {
        return Object.create(null);
    }

    var NODE_TYPE_ELEMENT = 1;
    var NODE_TYPE_ATTRIBUTE = 2;
    var NODE_TYPE_TEXT = 3;
    var NODE_TYPE_COMMENT = 8;
    var NODE_TYPE_DOCUMENT = 9;
    var NODE_TYPE_DOCUMENT_FRAGMENT = 11;

    /**
     * @ngdoc type
     * @name angular.Module
     * @module ng
     * @description
     *
     * Interface for configuring angular {@link angular.module modules}.
     */

    function setupModuleLoader(window) {

        var $injectorMinErr = minErr('$injector');
        var ngMinErr = minErr('ng');

        function ensure(obj, name, factory) {
            return obj[name] || (obj[name] = factory());
        }

        var angular = ensure(window, 'angular', Object);

        // We need to expose `angular.$$minErr` to modules such as `ngResource` that reference it during bootstrap
        angular.$$minErr = angular.$$minErr || minErr;

        return ensure(angular, 'module', function() {
            /** @type {Object.<string, angular.Module>} */
            var modules = {};

            /**
             * @ngdoc function
             * @name angular.module
             * @module ng
             * @description
             *
             * The `angular.module` is a global place for creating, registering and retrieving Angular
             * modules.
             * All modules (angular core or 3rd party) that should be available to an application must be
             * registered using this mechanism.
             *
             * Passing one argument retrieves an existing {@link angular.Module},
             * whereas passing more than one argument creates a new {@link angular.Module}
             *
             *
             * # Module
             *
             * A module is a collection of services, directives, controllers, filters, and configuration information.
             * `angular.module` is used to configure the {@link auto.$injector $injector}.
             *
             * ```js
             * // Create a new module
             * var myModule = angular.module('myModule', []);
             *
             * // register a new service
             * myModule.value('appName', 'MyCoolApp');
             *
             * // configure existing services inside initialization blocks.
             * myModule.config(['$locationProvider', function($locationProvider) {
     *   // Configure existing providers
     *   $locationProvider.hashPrefix('!');
     * }]);
             * ```
             *
             * Then you can create an injector and load your modules like this:
             *
             * ```js
             * var injector = angular.injector(['ng', 'myModule'])
             * ```
             *
             * However it's more likely that you'll just use
             * {@link ng.directive:ngApp ngApp} or
             * {@link angular.bootstrap} to simplify this process for you.
             *
             * @param {!string} name The name of the module to create or retrieve.
             * @param {!Array.<string>=} requires If specified then new module is being created. If
             *        unspecified then the module is being retrieved for further configuration.
             * @param {Function=} configFn Optional configuration function for the module. Same as
             *        {@link angular.Module#config Module#config()}.
             * @returns {angular.Module} new module with the {@link angular.Module} api.
             */
            return function module(name, requires, configFn) {
                var assertNotHasOwnProperty = function(name, context) {
                    if (name === 'hasOwnProperty') {
                        throw ngMinErr('badname', 'hasOwnProperty is not a valid {0} name', context);
                    }
                };

                assertNotHasOwnProperty(name, 'module');
                if (requires && modules.hasOwnProperty(name)) {
                    modules[name] = null;
                }
                return ensure(modules, name, function() {
                    if (!requires) {
                        throw $injectorMinErr('nomod', 'Module \'{0}\' is not available! You either misspelled ' +
                            'the module name or forgot to load it. If registering a module ensure that you ' +
                            'specify the dependencies as the second argument.', name);
                    }

                    /** @type {!Array.<Array.<*>>} */
                    var invokeQueue = [];

                    /** @type {!Array.<Function>} */
                    var configBlocks = [];

                    /** @type {!Array.<Function>} */
                    var runBlocks = [];

                    var config = invokeLater('$injector', 'invoke', 'push', configBlocks);

                    /** @type {angular.Module} */
                    var moduleInstance = {
                        // Private state
                        _invokeQueue: invokeQueue,
                        _configBlocks: configBlocks,
                        _runBlocks: runBlocks,

                        /**
                         * @ngdoc property
                         * @name angular.Module#requires
                         * @module ng
                         *
                         * @description
                         * Holds the list of modules which the injector will load before the current module is
                         * loaded.
                         */
                        requires: requires,

                        /**
                         * @ngdoc property
                         * @name angular.Module#name
                         * @module ng
                         *
                         * @description
                         * Name of the module.
                         */
                        name: name,


                        /**
                         * @ngdoc method
                         * @name angular.Module#provider
                         * @module ng
                         * @param {string} name service name
                         * @param {Function} providerType Construction function for creating new instance of the
                         *                                service.
                         * @description
                         * See {@link auto.$provide#provider $provide.provider()}.
                         */
                        provider: invokeLaterAndSetModuleName('$provide', 'provider'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#factory
                         * @module ng
                         * @param {string} name service name
                         * @param {Function} providerFunction Function for creating new instance of the service.
                         * @description
                         * See {@link auto.$provide#factory $provide.factory()}.
                         */
                        factory: invokeLaterAndSetModuleName('$provide', 'factory'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#service
                         * @module ng
                         * @param {string} name service name
                         * @param {Function} constructor A constructor function that will be instantiated.
                         * @description
                         * See {@link auto.$provide#service $provide.service()}.
                         */
                        service: invokeLaterAndSetModuleName('$provide', 'service'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#value
                         * @module ng
                         * @param {string} name service name
                         * @param {*} object Service instance object.
                         * @description
                         * See {@link auto.$provide#value $provide.value()}.
                         */
                        value: invokeLater('$provide', 'value'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#constant
                         * @module ng
                         * @param {string} name constant name
                         * @param {*} object Constant value.
                         * @description
                         * Because the constants are fixed, they get applied before other provide methods.
                         * See {@link auto.$provide#constant $provide.constant()}.
                         */
                        constant: invokeLater('$provide', 'constant', 'unshift'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#decorator
                         * @module ng
                         * @param {string} name The name of the service to decorate.
                         * @param {Function} decorFn This function will be invoked when the service needs to be
                         *                           instantiated and should return the decorated service instance.
                         * @description
                         * See {@link auto.$provide#decorator $provide.decorator()}.
                         */
                        decorator: invokeLaterAndSetModuleName('$provide', 'decorator'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#animation
                         * @module ng
                         * @param {string} name animation name
                         * @param {Function} animationFactory Factory function for creating new instance of an
                         *                                    animation.
                         * @description
                         *
                         * **NOTE**: animations take effect only if the **ngAnimate** module is loaded.
                         *
                         *
                         * Defines an animation hook that can be later used with
                         * {@link $animate $animate} service and directives that use this service.
                         *
                         * ```js
                         * module.animation('.animation-name', function($inject1, $inject2) {
           *   return {
           *     eventName : function(element, done) {
           *       //code to run the animation
           *       //once complete, then run done()
           *       return function cancellationFunction(element) {
           *         //code to cancel the animation
           *       }
           *     }
           *   }
           * })
                         * ```
                         *
                         * See {@link ng.$animateProvider#register $animateProvider.register()} and
                         * {@link ngAnimate ngAnimate module} for more information.
                         */
                        animation: invokeLaterAndSetModuleName('$animateProvider', 'register'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#filter
                         * @module ng
                         * @param {string} name Filter name - this must be a valid angular expression identifier
                         * @param {Function} filterFactory Factory function for creating new instance of filter.
                         * @description
                         * See {@link ng.$filterProvider#register $filterProvider.register()}.
                         *
                         * <div class="alert alert-warning">
                         * **Note:** Filter names must be valid angular {@link expression} identifiers, such as `uppercase` or `orderBy`.
                         * Names with special characters, such as hyphens and dots, are not allowed. If you wish to namespace
                         * your filters, then you can use capitalization (`myappSubsectionFilterx`) or underscores
                         * (`myapp_subsection_filterx`).
                         * </div>
                         */
                        filter: invokeLaterAndSetModuleName('$filterProvider', 'register'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#controller
                         * @module ng
                         * @param {string|Object} name Controller name, or an object map of controllers where the
                         *    keys are the names and the values are the constructors.
                         * @param {Function} constructor Controller constructor function.
                         * @description
                         * See {@link ng.$controllerProvider#register $controllerProvider.register()}.
                         */
                        controller: invokeLaterAndSetModuleName('$controllerProvider', 'register'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#directive
                         * @module ng
                         * @param {string|Object} name Directive name, or an object map of directives where the
                         *    keys are the names and the values are the factories.
                         * @param {Function} directiveFactory Factory function for creating new instance of
                         * directives.
                         * @description
                         * See {@link ng.$compileProvider#directive $compileProvider.directive()}.
                         */
                        directive: invokeLaterAndSetModuleName('$compileProvider', 'directive'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#component
                         * @module ng
                         * @param {string} name Name of the component in camel-case (i.e. myComp which will match as my-comp)
                         * @param {Object} options Component definition object (a simplified
                         *    {@link ng.$compile#directive-definition-object directive definition object})
                         *
                         * @description
                         * See {@link ng.$compileProvider#component $compileProvider.component()}.
                         */
                        component: invokeLaterAndSetModuleName('$compileProvider', 'component'),

                        /**
                         * @ngdoc method
                         * @name angular.Module#config
                         * @module ng
                         * @param {Function} configFn Execute this function on module load. Useful for service
                         *    configuration.
                         * @description
                         * Use this method to register work which needs to be performed on module loading.
                         * For more about how to configure services, see
                         * {@link providers#provider-recipe Provider Recipe}.
                         */
                        config: config,

                        /**
                         * @ngdoc method
                         * @name angular.Module#run
                         * @module ng
                         * @param {Function} initializationFn Execute this function after injector creation.
                         *    Useful for application initialization.
                         * @description
                         * Use this method to register work which should be performed when the injector is done
                         * loading all modules.
                         */
                        run: function(block) {
                            runBlocks.push(block);
                            return this;
                        }
                    };

                    if (configFn) {
                        config(configFn);
                    }

                    return moduleInstance;

                    /**
                     * @param {string} provider
                     * @param {string} method
                     * @param {String=} insertMethod
                     * @returns {angular.Module}
                     */
                    function invokeLater(provider, method, insertMethod, queue) {
                        if (!queue) queue = invokeQueue;
                        return function() {
                            queue[insertMethod || 'push']([provider, method, arguments]);
                            return moduleInstance;
                        };
                    }

                    /**
                     * @param {string} provider
                     * @param {string} method
                     * @returns {angular.Module}
                     */
                    function invokeLaterAndSetModuleName(provider, method) {
                        return function(recipeName, factoryFunction) {
                            if (factoryFunction && isFunction(factoryFunction)) factoryFunction.$$moduleName = name;
                            invokeQueue.push([provider, method, arguments]);
                            return moduleInstance;
                        };
                    }
                });
            };
        });

    }

    /* global shallowCopy: true */

    /**
     * Creates a shallow copy of an object, an array or a primitive.
     *
     * Assumes that there are no proto properties for objects.
     */
    function shallowCopy(src, dst) {
        if (isArray(src)) {
            dst = dst || [];

            for (var i = 0, ii = src.length; i < ii; i++) {
                dst[i] = src[i];
            }
        } else if (isObject(src)) {
            dst = dst || {};

            for (var key in src) {
                if (!(key.charAt(0) === '$' && key.charAt(1) === '$')) {
                    dst[key] = src[key];
                }
            }
        }

        return dst || src;
    }

    /* global toDebugString: true */

    function serializeObject(obj) {
        var seen = [];

        return JSON.stringify(obj, function(key, val) {
            val = toJsonReplacer(key, val);
            if (isObject(val)) {

                if (seen.indexOf(val) >= 0) return '...';

                seen.push(val);
            }
            return val;
        });
    }

    function toDebugString(obj) {
        if (typeof obj === 'function') {
            return obj.toString().replace(/ \{[\s\S]*$/, '');
        } else if (isUndefined(obj)) {
            return 'undefined';
        } else if (typeof obj !== 'string') {
            return serializeObject(obj);
        }
        return obj;
    }

    /* global angularModule: true,
     version: true,

     $CompileProvider,

     htmlAnchorDirective,
     inputDirective,
     inputDirective,
     formDirective,
     scriptDirective,
     selectDirective,
     optionDirective,
     ngBindDirective,
     ngBindHtmlDirective,
     ngBindTemplateDirective,
     ngClassDirective,
     ngClassEvenDirective,
     ngClassOddDirective,
     ngCloakDirective,
     ngControllerDirective,
     ngFormDirective,
     ngHideDirective,
     ngIfDirective,
     ngIncludeDirective,
     ngIncludeFillContentDirective,
     ngInitDirective,
     ngNonBindableDirective,
     ngPluralizeDirective,
     ngRepeatDirective,
     ngShowDirective,
     ngStyleDirective,
     ngSwitchDirective,
     ngSwitchWhenDirective,
     ngSwitchDefaultDirective,
     ngOptionsDirective,
     ngTranscludeDirective,
     ngModelDirective,
     ngListDirective,
     ngChangeDirective,
     patternDirective,
     patternDirective,
     requiredDirective,
     requiredDirective,
     minlengthDirective,
     minlengthDirective,
     maxlengthDirective,
     maxlengthDirective,
     ngValueDirective,
     ngModelOptionsDirective,
     ngAttributeAliasDirectives,
     ngEventDirectives,

     $AnchorScrollProvider,
     $AnimateProvider,
     $CoreAnimateCssProvider,
     $$CoreAnimateJsProvider,
     $$CoreAnimateQueueProvider,
     $$AnimateRunnerFactoryProvider,
     $$AnimateAsyncRunFactoryProvider,
     $BrowserProvider,
     $CacheFactoryProvider,
     $ControllerProvider,
     $DateProvider,
     $DocumentProvider,
     $ExceptionHandlerProvider,
     $FilterProvider,
     $$ForceReflowProvider,
     $InterpolateProvider,
     $IntervalProvider,
     $$HashMapProvider,
     $HttpProvider,
     $HttpParamSerializerProvider,
     $HttpParamSerializerJQLikeProvider,
     $HttpBackendProvider,
     $xhrFactoryProvider,
     $jsonpCallbacksProvider,
     $LocationProvider,
     $LogProvider,
     $ParseProvider,
     $RootScopeProvider,
     $QProvider,
     $$QProvider,
     $$SanitizeUriProvider,
     $SceProvider,
     $SceDelegateProvider,
     $SnifferProvider,
     $TemplateCacheProvider,
     $TemplateRequestProvider,
     $$TestabilityProvider,
     $TimeoutProvider,
     $$RAFProvider,
     $WindowProvider,
     $$jqLiteProvider,
     $$CookieReaderProvider
     */


    /**
     * @ngdoc object
     * @name angular.version
     * @module ng
     * @description
     * An object that contains information about the current AngularJS version.
     *
     * This object has the following properties:
     *
     * - `full` – `{string}` – Full version string, such as "0.9.18".
     * - `major` – `{number}` – Major version number, such as "0".
     * - `minor` – `{number}` – Minor version number, such as "9".
     * - `dot` – `{number}` – Dot version number, such as "18".
     * - `codeName` – `{string}` – Code name of the release, such as "jiggling-armfat".
     */
    var version = {
        // These placeholder strings will be replaced by grunt's `build` task.
        // They need to be double- or single-quoted.
        full: '1.5.9',
        major: 1,
        minor: 5,
        dot: 9,
        codeName: 'timeturning-lockdown'
    };


    function publishExternalAPI(angular) {
        extend(angular, {
            'bootstrap': bootstrap,
            'copy': copy,
            'extend': extend,
            'merge': merge,
            'equals': equals,
            'element': jqLite,
            'forEach': forEach,
            'injector': createInjector,
            'noop': noop,
            'bind': bind,
            'toJson': toJson,
            'fromJson': fromJson,
            'identity': identity,
            'isUndefined': isUndefined,
            'isDefined': isDefined,
            'isString': isString,
            'isFunction': isFunction,
            'isObject': isObject,
            'isNumber': isNumber,
            'isElement': isElement,
            'isArray': isArray,
            'version': version,
            'isDate': isDate,
            'lowercase': lowercase,
            'uppercase': uppercase,
            'callbacks': {$$counter: 0},
            'getTestability': getTestability,
            '$$minErr': minErr,
            '$$csp': csp,
            'reloadWithDebugInfo': reloadWithDebugInfo
        });

        angularModule = setupModuleLoader(window);

        angularModule('ng', ['ngLocale'], ['$provide',
            function ngModule($provide) {
                // $$sanitizeUriProvider needs to be before $compileProvider as it is used by it.
                $provide.provider({
                    $$sanitizeUri: $$SanitizeUriProvider
                });
                $provide.provider('$compile', $CompileProvider).
                directive({
                    a: htmlAnchorDirective,
                    input: inputDirective,
                    textarea: inputDirective,
                    form: formDirective,
                    script: scriptDirective,
                    select: selectDirective,
                    option: optionDirective,
                    ngBind: ngBindDirective,
                    ngBindHtml: ngBindHtmlDirective,
                    ngBindTemplate: ngBindTemplateDirective,
                    ngClass: ngClassDirective,
                    ngClassEven: ngClassEvenDirective,
                    ngClassOdd: ngClassOddDirective,
                    ngCloak: ngCloakDirective,
                    ngController: ngControllerDirective,
                    ngForm: ngFormDirective,
                    ngHide: ngHideDirective,
                    ngIf: ngIfDirective,
                    ngInclude: ngIncludeDirective,
                    ngInit: ngInitDirective,
                    ngNonBindable: ngNonBindableDirective,
                    ngPluralize: ngPluralizeDirective,
                    ngRepeat: ngRepeatDirective,
                    ngShow: ngShowDirective,
                    ngStyle: ngStyleDirective,
                    ngSwitch: ngSwitchDirective,
                    ngSwitchWhen: ngSwitchWhenDirective,
                    ngSwitchDefault: ngSwitchDefaultDirective,
                    ngOptions: ngOptionsDirective,
                    ngTransclude: ngTranscludeDirective,
                    ngModel: ngModelDirective,
                    ngList: ngListDirective,
                    ngChange: ngChangeDirective,
                    pattern: patternDirective,
                    ngPattern: patternDirective,
                    required: requiredDirective,
                    ngRequired: requiredDirective,
                    minlength: minlengthDirective,
                    ngMinlength: minlengthDirective,
                    maxlength: maxlengthDirective,
                    ngMaxlength: maxlengthDirective,
                    ngValue: ngValueDirective,
                    ngModelOptions: ngModelOptionsDirective
                }).
                directive({
                    ngInclude: ngIncludeFillContentDirective
                }).
                directive(ngAttributeAliasDirectives).
                directive(ngEventDirectives);
                $provide.provider({
                    $anchorScroll: $AnchorScrollProvider,
                    $animate: $AnimateProvider,
                    $animateCss: $CoreAnimateCssProvider,
                    $$animateJs: $$CoreAnimateJsProvider,
                    $$animateQueue: $$CoreAnimateQueueProvider,
                    $$AnimateRunner: $$AnimateRunnerFactoryProvider,
                    $$animateAsyncRun: $$AnimateAsyncRunFactoryProvider,
                    $browser: $BrowserProvider,
                    $cacheFactory: $CacheFactoryProvider,
                    $controller: $ControllerProvider,
                    $document: $DocumentProvider,
                    $exceptionHandler: $ExceptionHandlerProvider,
                    $filter: $FilterProvider,
                    $$forceReflow: $$ForceReflowProvider,
                    $interpolate: $InterpolateProvider,
                    $interval: $IntervalProvider,
                    $http: $HttpProvider,
                    $httpParamSerializer: $HttpParamSerializerProvider,
                    $httpParamSerializerJQLike: $HttpParamSerializerJQLikeProvider,
                    $httpBackend: $HttpBackendProvider,
                    $xhrFactory: $xhrFactoryProvider,
                    $jsonpCallbacks: $jsonpCallbacksProvider,
                    $location: $LocationProvider,
                    $log: $LogProvider,
                    $parse: $ParseProvider,
                    $rootScope: $RootScopeProvider,
                    $q: $QProvider,
                    $$q: $$QProvider,
                    $sce: $SceProvider,
                    $sceDelegate: $SceDelegateProvider,
                    $sniffer: $SnifferProvider,
                    $templateCache: $TemplateCacheProvider,
                    $templateRequest: $TemplateRequestProvider,
                    $$testability: $$TestabilityProvider,
                    $timeout: $TimeoutProvider,
                    $window: $WindowProvider,
                    $$rAF: $$RAFProvider,
                    $$jqLite: $$jqLiteProvider,
                    $$HashMap: $$HashMapProvider,
                    $$cookieReader: $$CookieReaderProvider
                });
            }
        ]);
    }

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     *     Any commits to this file should be reviewed with security in mind.  *
     *   Changes to this file can potentially create security vulnerabilities. *
     *          An approval from 2 Core members with history of modifying      *
     *                         this file is required.                          *
     *                                                                         *
     *  Does the change somehow allow for arbitrary javascript to be executed? *
     *    Or allows for someone to change the prototype of built-in objects?   *
     *     Or gives undesired access to variables likes document or window?    *
     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

    /* global JQLitePrototype: true,
     addEventListenerFn: true,
     removeEventListenerFn: true,
     BOOLEAN_ATTR: true,
     ALIASED_ATTR: true
     */

//////////////////////////////////
//JQLite
//////////////////////////////////

    /**
     * @ngdoc function
     * @name angular.element
     * @module ng
     * @kind function
     *
     * @description
     * Wraps a raw DOM element or HTML string as a [jQuery](http://jquery.com) element.
     *
     * If jQuery is available, `angular.element` is an alias for the
     * [jQuery](http://api.jquery.com/jQuery/) function. If jQuery is not available, `angular.element`
     * delegates to Angular's built-in subset of jQuery, called "jQuery lite" or **jqLite**.
     *
     * jqLite is a tiny, API-compatible subset of jQuery that allows
     * Angular to manipulate the DOM in a cross-browser compatible way. jqLite implements only the most
     * commonly needed functionality with the goal of having a very small footprint.
     *
     * To use `jQuery`, simply ensure it is loaded before the `angular.js` file. You can also use the
     * {@link ngJq `ngJq`} directive to specify that jqlite should be used over jQuery, or to use a
     * specific version of jQuery if multiple versions exist on the page.
     *
     * <div class="alert alert-info">**Note:** All element references in Angular are always wrapped with jQuery or
     * jqLite (such as the element argument in a directive's compile / link function). They are never raw DOM references.</div>
     *
     * <div class="alert alert-warning">**Note:** Keep in mind that this function will not find elements
     * by tag name / CSS selector. For lookups by tag name, try instead `angular.element(document).find(...)`
     * or `$document.find()`, or use the standard DOM APIs, e.g. `document.querySelectorAll()`.</div>
     *
     * ## Angular's jqLite
     * jqLite provides only the following jQuery methods:
     *
     * - [`addClass()`](http://api.jquery.com/addClass/) - Does not support a function as first argument
     * - [`after()`](http://api.jquery.com/after/)
     * - [`append()`](http://api.jquery.com/append/)
     * - [`attr()`](http://api.jquery.com/attr/) - Does not support functions as parameters
     * - [`bind()`](http://api.jquery.com/bind/) - Does not support namespaces, selectors or eventData
     * - [`children()`](http://api.jquery.com/children/) - Does not support selectors
     * - [`clone()`](http://api.jquery.com/clone/)
     * - [`contents()`](http://api.jquery.com/contents/)
     * - [`css()`](http://api.jquery.com/css/) - Only retrieves inline-styles, does not call `getComputedStyle()`.
     *   As a setter, does not convert numbers to strings or append 'px', and also does not have automatic property prefixing.
     * - [`data()`](http://api.jquery.com/data/)
     * - [`detach()`](http://api.jquery.com/detach/)
     * - [`empty()`](http://api.jquery.com/empty/)
     * - [`eq()`](http://api.jquery.com/eq/)
     * - [`find()`](http://api.jquery.com/find/) - Limited to lookups by tag name
     * - [`hasClass()`](http://api.jquery.com/hasClass/)
     * - [`html()`](http://api.jquery.com/html/)
     * - [`next()`](http://api.jquery.com/next/) - Does not support selectors
     * - [`on()`](http://api.jquery.com/on/) - Does not support namespaces, selectors or eventData
     * - [`off()`](http://api.jquery.com/off/) - Does not support namespaces, selectors or event object as parameter
     * - [`one()`](http://api.jquery.com/one/) - Does not support namespaces or selectors
     * - [`parent()`](http://api.jquery.com/parent/) - Does not support selectors
     * - [`prepend()`](http://api.jquery.com/prepend/)
     * - [`prop()`](http://api.jquery.com/prop/)
     * - [`ready()`](http://api.jquery.com/ready/)
     * - [`remove()`](http://api.jquery.com/remove/)
     * - [`removeAttr()`](http://api.jquery.com/removeAttr/)
     * - [`removeClass()`](http://api.jquery.com/removeClass/) - Does not support a function as first argument
     * - [`removeData()`](http://api.jquery.com/removeData/)
     * - [`replaceWith()`](http://api.jquery.com/replaceWith/)
     * - [`text()`](http://api.jquery.com/text/)
     * - [`toggleClass()`](http://api.jquery.com/toggleClass/) - Does not support a function as first argument
     * - [`triggerHandler()`](http://api.jquery.com/triggerHandler/) - Passes a dummy event object to handlers
     * - [`unbind()`](http://api.jquery.com/unbind/) - Does not support namespaces or event object as parameter
     * - [`val()`](http://api.jquery.com/val/)
     * - [`wrap()`](http://api.jquery.com/wrap/)
     *
     * ## jQuery/jqLite Extras
     * Angular also provides the following additional methods and events to both jQuery and jqLite:
     *
     * ### Events
     * - `$destroy` - AngularJS intercepts all jqLite/jQuery's DOM destruction apis and fires this event
     *    on all DOM nodes being removed.  This can be used to clean up any 3rd party bindings to the DOM
     *    element before it is removed.
     *
     * ### Methods
     * - `controller(name)` - retrieves the controller of the current element or its parent. By default
     *   retrieves controller associated with the `ngController` directive. If `name` is provided as
     *   camelCase directive name, then the controller for this directive will be retrieved (e.g.
     *   `'ngModel'`).
     * - `injector()` - retrieves the injector of the current element or its parent.
     * - `scope()` - retrieves the {@link ng.$rootScope.Scope scope} of the current
     *   element or its parent. Requires {@link guide/production#disabling-debug-data Debug Data} to
     *   be enabled.
     * - `isolateScope()` - retrieves an isolate {@link ng.$rootScope.Scope scope} if one is attached directly to the
     *   current element. This getter should be used only on elements that contain a directive which starts a new isolate
     *   scope. Calling `scope()` on this element always returns the original non-isolate scope.
     *   Requires {@link guide/production#disabling-debug-data Debug Data} to be enabled.
     * - `inheritedData()` - same as `data()`, but walks up the DOM until a value is found or the top
     *   parent element is reached.
     *
     * @knownIssue You cannot spy on `angular.element` if you are using Jasmine version 1.x. See
     * https://github.com/angular/angular.js/issues/14251 for more information.
     *
     * @param {string|DOMElement} element HTML string or DOMElement to be wrapped into jQuery.
     * @returns {Object} jQuery object.
     */

    JQLite.expando = 'ng339';

    var jqCache = JQLite.cache = {},
        jqId = 1,
        addEventListenerFn = function(element, type, fn) {
            element.addEventListener(type, fn, false);
        },
        removeEventListenerFn = function(element, type, fn) {
            element.removeEventListener(type, fn, false);
        };

    /*
     * !!! This is an undocumented "private" function !!!
     */
    JQLite._data = function(node) {
        //jQuery always returns an object on cache miss
        return this.cache[node[this.expando]] || {};
    };

    function jqNextId() { return ++jqId; }


    var SPECIAL_CHARS_REGEXP = /([:\-_]+(.))/g;
    var MOZ_HACK_REGEXP = /^moz([A-Z])/;
    var MOUSE_EVENT_MAP = { mouseleave: 'mouseout', mouseenter: 'mouseover' };
    var jqLiteMinErr = minErr('jqLite');

    /**
     * Converts snake_case to camelCase.
     * Also there is special case for Moz prefix starting with upper case letter.
     * @param name Name to normalize
     */
    function camelCase(name) {
        return name.
        replace(SPECIAL_CHARS_REGEXP, function(_, separator, letter, offset) {
            return offset ? letter.toUpperCase() : letter;
        }).
        replace(MOZ_HACK_REGEXP, 'Moz$1');
    }

    var SINGLE_TAG_REGEXP = /^<([\w-]+)\s*\/?>(?:<\/\1>|)$/;
    var HTML_REGEXP = /<|&#?\w+;/;
    var TAG_NAME_REGEXP = /<([\w:-]+)/;
    var XHTML_TAG_REGEXP = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:-]+)[^>]*)\/>/gi;

    var wrapMap = {
        'option': [1, '<select multiple="multiple">', '</select>'],

        'thead': [1, '<table>', '</table>'],
        'col': [2, '<table><colgroup>', '</colgroup></table>'],
        'tr': [2, '<table><tbody>', '</tbody></table>'],
        'td': [3, '<table><tbody><tr>', '</tr></tbody></table>'],
        '_default': [0, '', '']
    };

    wrapMap.optgroup = wrapMap.option;
    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
    wrapMap.th = wrapMap.td;


    function jqLiteIsTextNode(html) {
        return !HTML_REGEXP.test(html);
    }

    function jqLiteAcceptsData(node) {
        // The window object can accept data but has no nodeType
        // Otherwise we are only interested in elements (1) and documents (9)
        var nodeType = node.nodeType;
        return nodeType === NODE_TYPE_ELEMENT || !nodeType || nodeType === NODE_TYPE_DOCUMENT;
    }

    function jqLiteHasData(node) {
        for (var key in jqCache[node.ng339]) {
            return true;
        }
        return false;
    }

    function jqLiteCleanData(nodes) {
        for (var i = 0, ii = nodes.length; i < ii; i++) {
            jqLiteRemoveData(nodes[i]);
        }
    }

    function jqLiteBuildFragment(html, context) {
        var tmp, tag, wrap,
            fragment = context.createDocumentFragment(),
            nodes = [], i;

        if (jqLiteIsTextNode(html)) {
            // Convert non-html into a text node
            nodes.push(context.createTextNode(html));
        } else {
            // Convert html into DOM nodes
            tmp = fragment.appendChild(context.createElement('div'));
            tag = (TAG_NAME_REGEXP.exec(html) || ['', ''])[1].toLowerCase();
            wrap = wrapMap[tag] || wrapMap._default;
            tmp.innerHTML = wrap[1] + html.replace(XHTML_TAG_REGEXP, '<$1></$2>') + wrap[2];

            // Descend through wrappers to the right content
            i = wrap[0];
            while (i--) {
                tmp = tmp.lastChild;
            }

            nodes = concat(nodes, tmp.childNodes);

            tmp = fragment.firstChild;
            tmp.textContent = '';
        }

        // Remove wrapper from fragment
        fragment.textContent = '';
        fragment.innerHTML = ''; // Clear inner HTML
        forEach(nodes, function(node) {
            fragment.appendChild(node);
        });

        return fragment;
    }

    function jqLiteParseHTML(html, context) {
        context = context || window.document;
        var parsed;

        if ((parsed = SINGLE_TAG_REGEXP.exec(html))) {
            return [context.createElement(parsed[1])];
        }

        if ((parsed = jqLiteBuildFragment(html, context))) {
            return parsed.childNodes;
        }

        return [];
    }

    function jqLiteWrapNode(node, wrapper) {
        var parent = node.parentNode;

        if (parent) {
            parent.replaceChild(wrapper, node);
        }

        wrapper.appendChild(node);
    }


// IE9-11 has no method "contains" in SVG element and in Node.prototype. Bug #10259.
    var jqLiteContains = window.Node.prototype.contains || /** @this */ function(arg) {
            // eslint-disable-next-line no-bitwise
            return !!(this.compareDocumentPosition(arg) & 16);
        };

/////////////////////////////////////////////
    function JQLite(element) {
        if (element instanceof JQLite) {
            return element;
        }

        var argIsString;

        if (isString(element)) {
            element = trim(element);
            argIsString = true;
        }
        if (!(this instanceof JQLite)) {
            if (argIsString && element.charAt(0) !== '<') {
                throw jqLiteMinErr('nosel', 'Looking up elements via selectors is not supported by jqLite! See: http://docs.angularjs.org/api/angular.element');
            }
            return new JQLite(element);
        }

        if (argIsString) {
            jqLiteAddNodes(this, jqLiteParseHTML(element));
        } else {
            jqLiteAddNodes(this, element);
        }
    }

    function jqLiteClone(element) {
        return element.cloneNode(true);
    }

    function jqLiteDealoc(element, onlyDescendants) {
        if (!onlyDescendants) jqLiteRemoveData(element);

        if (element.querySelectorAll) {
            var descendants = element.querySelectorAll('*');
            for (var i = 0, l = descendants.length; i < l; i++) {
                jqLiteRemoveData(descendants[i]);
            }
        }
    }

    function jqLiteOff(element, type, fn, unsupported) {
        if (isDefined(unsupported)) throw jqLiteMinErr('offargs', 'jqLite#off() does not support the `selector` argument');

        var expandoStore = jqLiteExpandoStore(element);
        var events = expandoStore && expandoStore.events;
        var handle = expandoStore && expandoStore.handle;

        if (!handle) return; //no listeners registered

        if (!type) {
            for (type in events) {
                if (type !== '$destroy') {
                    removeEventListenerFn(element, type, handle);
                }
                delete events[type];
            }
        } else {

            var removeHandler = function(type) {
                var listenerFns = events[type];
                if (isDefined(fn)) {
                    arrayRemove(listenerFns || [], fn);
                }
                if (!(isDefined(fn) && listenerFns && listenerFns.length > 0)) {
                    removeEventListenerFn(element, type, handle);
                    delete events[type];
                }
            };

            forEach(type.split(' '), function(type) {
                removeHandler(type);
                if (MOUSE_EVENT_MAP[type]) {
                    removeHandler(MOUSE_EVENT_MAP[type]);
                }
            });
        }
    }

    function jqLiteRemoveData(element, name) {
        var expandoId = element.ng339;
        var expandoStore = expandoId && jqCache[expandoId];

        if (expandoStore) {
            if (name) {
                delete expandoStore.data[name];
                return;
            }

            if (expandoStore.handle) {
                if (expandoStore.events.$destroy) {
                    expandoStore.handle({}, '$destroy');
                }
                jqLiteOff(element);
            }
            delete jqCache[expandoId];
            element.ng339 = undefined; // don't delete DOM expandos. IE and Chrome don't like it
        }
    }


    function jqLiteExpandoStore(element, createIfNecessary) {
        var expandoId = element.ng339,
            expandoStore = expandoId && jqCache[expandoId];

        if (createIfNecessary && !expandoStore) {
            element.ng339 = expandoId = jqNextId();
            expandoStore = jqCache[expandoId] = {events: {}, data: {}, handle: undefined};
        }

        return expandoStore;
    }


    function jqLiteData(element, key, value) {
        if (jqLiteAcceptsData(element)) {

            var isSimpleSetter = isDefined(value);
            var isSimpleGetter = !isSimpleSetter && key && !isObject(key);
            var massGetter = !key;
            var expandoStore = jqLiteExpandoStore(element, !isSimpleGetter);
            var data = expandoStore && expandoStore.data;

            if (isSimpleSetter) { // data('key', value)
                data[key] = value;
            } else {
                if (massGetter) {  // data()
                    return data;
                } else {
                    if (isSimpleGetter) { // data('key')
                        // don't force creation of expandoStore if it doesn't exist yet
                        return data && data[key];
                    } else { // mass-setter: data({key1: val1, key2: val2})
                        extend(data, key);
                    }
                }
            }
        }
    }

    function jqLiteHasClass(element, selector) {
        if (!element.getAttribute) return false;
        return ((' ' + (element.getAttribute('class') || '') + ' ').replace(/[\n\t]/g, ' ').
        indexOf(' ' + selector + ' ') > -1);
    }

    function jqLiteRemoveClass(element, cssClasses) {
        if (cssClasses && element.setAttribute) {
            forEach(cssClasses.split(' '), function(cssClass) {
                element.setAttribute('class', trim(
                    (' ' + (element.getAttribute('class') || '') + ' ')
                        .replace(/[\n\t]/g, ' ')
                        .replace(' ' + trim(cssClass) + ' ', ' '))
                );
            });
        }
    }

    function jqLiteAddClass(element, cssClasses) {
        if (cssClasses && element.setAttribute) {
            var existingClasses = (' ' + (element.getAttribute('class') || '') + ' ')
                .replace(/[\n\t]/g, ' ');

            forEach(cssClasses.split(' '), function(cssClass) {
                cssClass = trim(cssClass);
                if (existingClasses.indexOf(' ' + cssClass + ' ') === -1) {
                    existingClasses += cssClass + ' ';
                }
            });

            element.setAttribute('class', trim(existingClasses));
        }
    }


    function jqLiteAddNodes(root, elements) {
        // THIS CODE IS VERY HOT. Don't make changes without benchmarking.

        if (elements) {

            // if a Node (the most common case)
            if (elements.nodeType) {
                root[root.length++] = elements;
            } else {
                var length = elements.length;

                // if an Array or NodeList and not a Window
                if (typeof length === 'number' && elements.window !== elements) {
                    if (length) {
                        for (var i = 0; i < length; i++) {
                            root[root.length++] = elements[i];
                        }
                    }
                } else {
                    root[root.length++] = elements;
                }
            }
        }
    }


    function jqLiteController(element, name) {
        return jqLiteInheritedData(element, '$' + (name || 'ngController') + 'Controller');
    }

    function jqLiteInheritedData(element, name, value) {
        // if element is the document object work with the html element instead
        // this makes $(document).scope() possible
        if (element.nodeType === NODE_TYPE_DOCUMENT) {
            element = element.documentElement;
        }
        var names = isArray(name) ? name : [name];

        while (element) {
            for (var i = 0, ii = names.length; i < ii; i++) {
                if (isDefined(value = jqLite.data(element, names[i]))) return value;
            }

            // If dealing with a document fragment node with a host element, and no parent, use the host
            // element as the parent. This enables directives within a Shadow DOM or polyfilled Shadow DOM
            // to lookup parent controllers.
            element = element.parentNode || (element.nodeType === NODE_TYPE_DOCUMENT_FRAGMENT && element.host);
        }
    }

    function jqLiteEmpty(element) {
        jqLiteDealoc(element, true);
        while (element.firstChild) {
            element.removeChild(element.firstChild);
        }
    }

    function jqLiteRemove(element, keepData) {
        if (!keepData) jqLiteDealoc(element);
        var parent = element.parentNode;
        if (parent) parent.removeChild(element);
    }


    function jqLiteDocumentLoaded(action, win) {
        win = win || window;
        if (win.document.readyState === 'complete') {
            // Force the action to be run async for consistent behavior
            // from the action's point of view
            // i.e. it will definitely not be in a $apply
            win.setTimeout(action);
        } else {
            // No need to unbind this handler as load is only ever called once
            jqLite(win).on('load', action);
        }
    }

//////////////////////////////////////////
// Functions which are declared directly.
//////////////////////////////////////////
    var JQLitePrototype = JQLite.prototype = {
        ready: function(fn) {
            var fired = false;

            function trigger() {
                if (fired) return;
                fired = true;
                fn();
            }

            // check if document is already loaded
            if (window.document.readyState === 'complete') {
                window.setTimeout(trigger);
            } else {
                this.on('DOMContentLoaded', trigger); // works for modern browsers and IE9
                // we can not use jqLite since we are not done loading and jQuery could be loaded later.
                // eslint-disable-next-line new-cap
                JQLite(window).on('load', trigger); // fallback to window.onload for others
            }
        },
        toString: function() {
            var value = [];
            forEach(this, function(e) { value.push('' + e);});
            return '[' + value.join(', ') + ']';
        },

        eq: function(index) {
            return (index >= 0) ? jqLite(this[index]) : jqLite(this[this.length + index]);
        },

        length: 0,
        push: push,
        sort: [].sort,
        splice: [].splice
    };

//////////////////////////////////////////
// Functions iterating getter/setters.
// these functions return self on setter and
// value on get.
//////////////////////////////////////////
    var BOOLEAN_ATTR = {};
    forEach('multiple,selected,checked,disabled,readOnly,required,open'.split(','), function(value) {
        BOOLEAN_ATTR[lowercase(value)] = value;
    });
    var BOOLEAN_ELEMENTS = {};
    forEach('input,select,option,textarea,button,form,details'.split(','), function(value) {
        BOOLEAN_ELEMENTS[value] = true;
    });
    var ALIASED_ATTR = {
        'ngMinlength': 'minlength',
        'ngMaxlength': 'maxlength',
        'ngMin': 'min',
        'ngMax': 'max',
        'ngPattern': 'pattern'
    };

    function getBooleanAttrName(element, name) {
        // check dom last since we will most likely fail on name
        var booleanAttr = BOOLEAN_ATTR[name.toLowerCase()];

        // booleanAttr is here twice to minimize DOM access
        return booleanAttr && BOOLEAN_ELEMENTS[nodeName_(element)] && booleanAttr;
    }

    function getAliasedAttrName(name) {
        return ALIASED_ATTR[name];
    }

    forEach({
        data: jqLiteData,
        removeData: jqLiteRemoveData,
        hasData: jqLiteHasData,
        cleanData: jqLiteCleanData
    }, function(fn, name) {
        JQLite[name] = fn;
    });

    forEach({
        data: jqLiteData,
        inheritedData: jqLiteInheritedData,

        scope: function(element) {
            // Can't use jqLiteData here directly so we stay compatible with jQuery!
            return jqLite.data(element, '$scope') || jqLiteInheritedData(element.parentNode || element, ['$isolateScope', '$scope']);
        },

        isolateScope: function(element) {
            // Can't use jqLiteData here directly so we stay compatible with jQuery!
            return jqLite.data(element, '$isolateScope') || jqLite.data(element, '$isolateScopeNoTemplate');
        },

        controller: jqLiteController,

        injector: function(element) {
            return jqLiteInheritedData(element, '$injector');
        },

        removeAttr: function(element, name) {
            element.removeAttribute(name);
        },

        hasClass: jqLiteHasClass,

        css: function(element, name, value) {
            name = camelCase(name);

            if (isDefined(value)) {
                element.style[name] = value;
            } else {
                return element.style[name];
            }
        },

        attr: function(element, name, value) {
            var nodeType = element.nodeType;
            if (nodeType === NODE_TYPE_TEXT || nodeType === NODE_TYPE_ATTRIBUTE || nodeType === NODE_TYPE_COMMENT) {
                return;
            }
            var lowercasedName = lowercase(name);
            if (BOOLEAN_ATTR[lowercasedName]) {
                if (isDefined(value)) {
                    if (value) {
                        element[name] = true;
                        element.setAttribute(name, lowercasedName);
                    } else {
                        element[name] = false;
                        element.removeAttribute(lowercasedName);
                    }
                } else {
                    return (element[name] ||
                    (element.attributes.getNamedItem(name) || noop).specified)
                        ? lowercasedName
                        : undefined;
                }
            } else if (isDefined(value)) {
                element.setAttribute(name, value);
            } else if (element.getAttribute) {
                // the extra argument "2" is to get the right thing for a.href in IE, see jQuery code
                // some elements (e.g. Document) don't have get attribute, so return undefined
                var ret = element.getAttribute(name, 2);
                // normalize non-existing attributes to undefined (as jQuery)
                return ret === null ? undefined : ret;
            }
        },

        prop: function(element, name, value) {
            if (isDefined(value)) {
                element[name] = value;
            } else {
                return element[name];
            }
        },

        text: (function() {
            getText.$dv = '';
            return getText;

            function getText(element, value) {
                if (isUndefined(value)) {
                    var nodeType = element.nodeType;
                    return (nodeType === NODE_TYPE_ELEMENT || nodeType === NODE_TYPE_TEXT) ? element.textContent : '';
                }
                element.textContent = value;
            }
        })(),

        val: function(element, value) {
            if (isUndefined(value)) {
                if (element.multiple && nodeName_(element) === 'select') {
                    var result = [];
                    forEach(element.options, function(option) {
                        if (option.selected) {
                            result.push(option.value || option.text);
                        }
                    });
                    return result.length === 0 ? null : result;
                }
                return element.value;
            }
            element.value = value;
        },

        html: function(element, value) {
            if (isUndefined(value)) {
                return element.innerHTML;
            }
            jqLiteDealoc(element, true);
            element.innerHTML = value;
        },

        empty: jqLiteEmpty
    }, function(fn, name) {
        /**
         * Properties: writes return selection, reads return first value
         */
        JQLite.prototype[name] = function(arg1, arg2) {
            var i, key;
            var nodeCount = this.length;

            // jqLiteHasClass has only two arguments, but is a getter-only fn, so we need to special-case it
            // in a way that survives minification.
            // jqLiteEmpty takes no arguments but is a setter.
            if (fn !== jqLiteEmpty &&
                (isUndefined((fn.length === 2 && (fn !== jqLiteHasClass && fn !== jqLiteController)) ? arg1 : arg2))) {
                if (isObject(arg1)) {

                    // we are a write, but the object properties are the key/values
                    for (i = 0; i < nodeCount; i++) {
                        if (fn === jqLiteData) {
                            // data() takes the whole object in jQuery
                            fn(this[i], arg1);
                        } else {
                            for (key in arg1) {
                                fn(this[i], key, arg1[key]);
                            }
                        }
                    }
                    // return self for chaining
                    return this;
                } else {
                    // we are a read, so read the first child.
                    // TODO: do we still need this?
                    var value = fn.$dv;
                    // Only if we have $dv do we iterate over all, otherwise it is just the first element.
                    var jj = (isUndefined(value)) ? Math.min(nodeCount, 1) : nodeCount;
                    for (var j = 0; j < jj; j++) {
                        var nodeValue = fn(this[j], arg1, arg2);
                        value = value ? value + nodeValue : nodeValue;
                    }
                    return value;
                }
            } else {
                // we are a write, so apply to all children
                for (i = 0; i < nodeCount; i++) {
                    fn(this[i], arg1, arg2);
                }
                // return self for chaining
                return this;
            }
        };
    });

    function createEventHandler(element, events) {
        var eventHandler = function(event, type) {
            // jQuery specific api
            event.isDefaultPrevented = function() {
                return event.defaultPrevented;
            };

            var eventFns = events[type || event.type];
            var eventFnsLength = eventFns ? eventFns.length : 0;

            if (!eventFnsLength) return;

            if (isUndefined(event.immediatePropagationStopped)) {
                var originalStopImmediatePropagation = event.stopImmediatePropagation;
                event.stopImmediatePropagation = function() {
                    event.immediatePropagationStopped = true;

                    if (event.stopPropagation) {
                        event.stopPropagation();
                    }

                    if (originalStopImmediatePropagation) {
                        originalStopImmediatePropagation.call(event);
                    }
                };
            }

            event.isImmediatePropagationStopped = function() {
                return event.immediatePropagationStopped === true;
            };

            // Some events have special handlers that wrap the real handler
            var handlerWrapper = eventFns.specialHandlerWrapper || defaultHandlerWrapper;

            // Copy event handlers in case event handlers array is modified during execution.
            if ((eventFnsLength > 1)) {
                eventFns = shallowCopy(eventFns);
            }

            for (var i = 0; i < eventFnsLength; i++) {
                if (!event.isImmediatePropagationStopped()) {
                    handlerWrapper(element, event, eventFns[i]);
                }
            }
        };

        // TODO: this is a hack for angularMocks/clearDataCache that makes it possible to deregister all
        //       events on `element`
        eventHandler.elem = element;
        return eventHandler;
    }

    function defaultHandlerWrapper(element, event, handler) {
        handler.call(element, event);
    }

    function specialMouseHandlerWrapper(target, event, handler) {
        // Refer to jQuery's implementation of mouseenter & mouseleave
        // Read about mouseenter and mouseleave:
        // http://www.quirksmode.org/js/events_mouse.html#link8
        var related = event.relatedTarget;
        // For mousenter/leave call the handler if related is outside the target.
        // NB: No relatedTarget if the mouse left/entered the browser window
        if (!related || (related !== target && !jqLiteContains.call(target, related))) {
            handler.call(target, event);
        }
    }

//////////////////////////////////////////
// Functions iterating traversal.
// These functions chain results into a single
// selector.
//////////////////////////////////////////
    forEach({
        removeData: jqLiteRemoveData,

        on: function jqLiteOn(element, type, fn, unsupported) {
            if (isDefined(unsupported)) throw jqLiteMinErr('onargs', 'jqLite#on() does not support the `selector` or `eventData` parameters');

            // Do not add event handlers to non-elements because they will not be cleaned up.
            if (!jqLiteAcceptsData(element)) {
                return;
            }

            var expandoStore = jqLiteExpandoStore(element, true);
            var events = expandoStore.events;
            var handle = expandoStore.handle;

            if (!handle) {
                handle = expandoStore.handle = createEventHandler(element, events);
            }

            // http://jsperf.com/string-indexof-vs-split
            var types = type.indexOf(' ') >= 0 ? type.split(' ') : [type];
            var i = types.length;

            var addHandler = function(type, specialHandlerWrapper, noEventListener) {
                var eventFns = events[type];

                if (!eventFns) {
                    eventFns = events[type] = [];
                    eventFns.specialHandlerWrapper = specialHandlerWrapper;
                    if (type !== '$destroy' && !noEventListener) {
                        addEventListenerFn(element, type, handle);
                    }
                }

                eventFns.push(fn);
            };

            while (i--) {
                type = types[i];
                if (MOUSE_EVENT_MAP[type]) {
                    addHandler(MOUSE_EVENT_MAP[type], specialMouseHandlerWrapper);
                    addHandler(type, undefined, true);
                } else {
                    addHandler(type);
                }
            }
        },

        off: jqLiteOff,

        one: function(element, type, fn) {
            element = jqLite(element);

            //add the listener twice so that when it is called
            //you can remove the original function and still be
            //able to call element.off(ev, fn) normally
            element.on(type, function onFn() {
                element.off(type, fn);
                element.off(type, onFn);
            });
            element.on(type, fn);
        },

        replaceWith: function(element, replaceNode) {
            var index, parent = element.parentNode;
            jqLiteDealoc(element);
            forEach(new JQLite(replaceNode), function(node) {
                if (index) {
                    parent.insertBefore(node, index.nextSibling);
                } else {
                    parent.replaceChild(node, element);
                }
                index = node;
            });
        },

        children: function(element) {
            var children = [];
            forEach(element.childNodes, function(element) {
                if (element.nodeType === NODE_TYPE_ELEMENT) {
                    children.push(element);
                }
            });
            return children;
        },

        contents: function(element) {
            return element.contentDocument || element.childNodes || [];
        },

        append: function(element, node) {
            var nodeType = element.nodeType;
            if (nodeType !== NODE_TYPE_ELEMENT && nodeType !== NODE_TYPE_DOCUMENT_FRAGMENT) return;

            node = new JQLite(node);

            for (var i = 0, ii = node.length; i < ii; i++) {
                var child = node[i];
                element.appendChild(child);
            }
        },

        prepend: function(element, node) {
            if (element.nodeType === NODE_TYPE_ELEMENT) {
                var index = element.firstChild;
                forEach(new JQLite(node), function(child) {
                    element.insertBefore(child, index);
                });
            }
        },

        wrap: function(element, wrapNode) {
            jqLiteWrapNode(element, jqLite(wrapNode).eq(0).clone()[0]);
        },

        remove: jqLiteRemove,

        detach: function(element) {
            jqLiteRemove(element, true);
        },

        after: function(element, newElement) {
            var index = element, parent = element.parentNode;
            newElement = new JQLite(newElement);

            for (var i = 0, ii = newElement.length; i < ii; i++) {
                var node = newElement[i];
                parent.insertBefore(node, index.nextSibling);
                index = node;
            }
        },

        addClass: jqLiteAddClass,
        removeClass: jqLiteRemoveClass,

        toggleClass: function(element, selector, condition) {
            if (selector) {
                forEach(selector.split(' '), function(className) {
                    var classCondition = condition;
                    if (isUndefined(classCondition)) {
                        classCondition = !jqLiteHasClass(element, className);
                    }
                    (classCondition ? jqLiteAddClass : jqLiteRemoveClass)(element, className);
                });
            }
        },

        parent: function(element) {
            var parent = element.parentNode;
            return parent && parent.nodeType !== NODE_TYPE_DOCUMENT_FRAGMENT ? parent : null;
        },

        next: function(element) {
            return element.nextElementSibling;
        },

        find: function(element, selector) {
            if (element.getElementsByTagName) {
                return element.getElementsByTagName(selector);
            } else {
                return [];
            }
        },

        clone: jqLiteClone,

        triggerHandler: function(element, event, extraParameters) {

            var dummyEvent, eventFnsCopy, handlerArgs;
            var eventName = event.type || event;
            var expandoStore = jqLiteExpandoStore(element);
            var events = expandoStore && expandoStore.events;
            var eventFns = events && events[eventName];

            if (eventFns) {
                // Create a dummy event to pass to the handlers
                dummyEvent = {
                    preventDefault: function() { this.defaultPrevented = true; },
                    isDefaultPrevented: function() { return this.defaultPrevented === true; },
                    stopImmediatePropagation: function() { this.immediatePropagationStopped = true; },
                    isImmediatePropagationStopped: function() { return this.immediatePropagationStopped === true; },
                    stopPropagation: noop,
                    type: eventName,
                    target: element
                };

                // If a custom event was provided then extend our dummy event with it
                if (event.type) {
                    dummyEvent = extend(dummyEvent, event);
                }

                // Copy event handlers in case event handlers array is modified during execution.
                eventFnsCopy = shallowCopy(eventFns);
                handlerArgs = extraParameters ? [dummyEvent].concat(extraParameters) : [dummyEvent];

                forEach(eventFnsCopy, function(fn) {
                    if (!dummyEvent.isImmediatePropagationStopped()) {
                        fn.apply(element, handlerArgs);
                    }
                });
            }
        }
    }, function(fn, name) {
        /**
         * chaining functions
         */
        JQLite.prototype[name] = function(arg1, arg2, arg3) {
            var value;

            for (var i = 0, ii = this.length; i < ii; i++) {
                if (isUndefined(value)) {
                    value = fn(this[i], arg1, arg2, arg3);
                    if (isDefined(value)) {
                        // any function which returns a value needs to be wrapped
                        value = jqLite(value);
                    }
                } else {
                    jqLiteAddNodes(value, fn(this[i], arg1, arg2, arg3));
                }
            }
            return isDefined(value) ? value : this;
        };

        // bind legacy bind/unbind to on/off
        JQLite.prototype.bind = JQLite.prototype.on;
        JQLite.prototype.unbind = JQLite.prototype.off;
    });


// Provider for private $$jqLite service
    /** @this */
    function $$jqLiteProvider() {
        this.$get = function $$jqLite() {
            return extend(JQLite, {
                hasClass: function(node, classes) {
                    if (node.attr) node = node[0];
                    return jqLiteHasClass(node, classes);
                },
                addClass: function(node, classes) {
                    if (node.attr) node = node[0];
                    return jqLiteAddClass(node, classes);
                },
                removeClass: function(node, classes) {
                    if (node.attr) node = node[0];
                    return jqLiteRemoveClass(node, classes);
                }
            });
        };
    }

    /**
     * Computes a hash of an 'obj'.
     * Hash of a:
     *  string is string
     *  number is number as string
     *  object is either result of calling $$hashKey function on the object or uniquely generated id,
     *         that is also assigned to the $$hashKey property of the object.
     *
     * @param obj
     * @returns {string} hash string such that the same input will have the same hash string.
     *         The resulting string key is in 'type:hashKey' format.
     */
    function hashKey(obj, nextUidFn) {
        var key = obj && obj.$$hashKey;

        if (key) {
            if (typeof key === 'function') {
                key = obj.$$hashKey();
            }
            return key;
        }

        var objType = typeof obj;
        if (objType === 'function' || (objType === 'object' && obj !== null)) {
            key = obj.$$hashKey = objType + ':' + (nextUidFn || nextUid)();
        } else {
            key = objType + ':' + obj;
        }

        return key;
    }

    /**
     * HashMap which can use objects as keys
     */
    function HashMap(array, isolatedUid) {
        if (isolatedUid) {
            var uid = 0;
            this.nextUid = function() {
                return ++uid;
            };
        }
        forEach(array, this.put, this);
    }
    HashMap.prototype = {
        /**
         * Store key value pair
         * @param key key to store can be any type
         * @param value value to store can be any type
         */
        put: function(key, value) {
            this[hashKey(key, this.nextUid)] = value;
        },

        /**
         * @param key
         * @returns {Object} the value for the key
         */
        get: function(key) {
            return this[hashKey(key, this.nextUid)];
        },

        /**
         * Remove the key/value pair
         * @param key
         */
        remove: function(key) {
            var value = this[key = hashKey(key, this.nextUid)];
            delete this[key];
            return value;
        }
    };

    var $$HashMapProvider = [/** @this */function() {
        this.$get = [function() {
            return HashMap;
        }];
    }];

    /**
     * @ngdoc function
     * @module ng
     * @name angular.injector
     * @kind function
     *
     * @description
     * Creates an injector object that can be used for retrieving services as well as for
     * dependency injection (see {@link guide/di dependency injection}).
     *
     * @param {Array.<string|Function>} modules A list of module functions or their aliases. See
     *     {@link angular.module}. The `ng` module must be explicitly added.
     * @param {boolean=} [strictDi=false] Whether the injector should be in strict mode, which
     *     disallows argument name annotation inference.
     * @returns {injector} Injector object. See {@link auto.$injector $injector}.
     *
     * @example
     * Typical usage
     * ```js
     *   // create an injector
     *   var $injector = angular.injector(['ng']);
     *
     *   // use the injector to kick off your application
     *   // use the type inference to auto inject arguments, or use implicit injection
     *   $injector.invoke(function($rootScope, $compile, $document) {
 *     $compile($document)($rootScope);
 *     $rootScope.$digest();
 *   });
     * ```
     *
     * Sometimes you want to get access to the injector of a currently running Angular app
     * from outside Angular. Perhaps, you want to inject and compile some markup after the
     * application has been bootstrapped. You can do this using the extra `injector()` added
     * to JQuery/jqLite elements. See {@link angular.element}.
     *
     * *This is fairly rare but could be the case if a third party library is injecting the
     * markup.*
     *
     * In the following example a new block of HTML containing a `ng-controller`
     * directive is added to the end of the document body by JQuery. We then compile and link
     * it into the current AngularJS scope.
     *
     * ```js
     * var $div = $('<div ng-controller="MyCtrl">{{content.label}}</div>');
     * $(document.body).append($div);
     *
     * angular.element(document).injector().invoke(function($compile) {
 *   var scope = angular.element($div).scope();
 *   $compile($div)(scope);
 * });
     * ```
     */


    /**
     * @ngdoc module
     * @name auto
     * @installation
     * @description
     *
     * Implicit module which gets automatically added to each {@link auto.$injector $injector}.
     */

    var ARROW_ARG = /^([^\(]+?)=>/;
    var FN_ARGS = /^[^\(]*\(\s*([^\)]*)\)/m;
    var FN_ARG_SPLIT = /,/;
    var FN_ARG = /^\s*(_?)(\S+?)\1\s*$/;
    var STRIP_COMMENTS = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg;
    var $injectorMinErr = minErr('$injector');

    function stringifyFn(fn) {
        // Support: Chrome 50-51 only
        // Creating a new string by adding `' '` at the end, to hack around some bug in Chrome v50/51
        // (See https://github.com/angular/angular.js/issues/14487.)
        // TODO (gkalpak): Remove workaround when Chrome v52 is released
        return Function.prototype.toString.call(fn) + ' ';
    }

    function extractArgs(fn) {
        var fnText = stringifyFn(fn).replace(STRIP_COMMENTS, ''),
            args = fnText.match(ARROW_ARG) || fnText.match(FN_ARGS);
        return args;
    }

    function anonFn(fn) {
        // For anonymous functions, showing at the very least the function signature can help in
        // debugging.
        var args = extractArgs(fn);
        if (args) {
            return 'function(' + (args[1] || '').replace(/[\s\r\n]+/, ' ') + ')';
        }
        return 'fn';
    }

    function annotate(fn, strictDi, name) {
        var $inject,
            argDecl,
            last;

        if (typeof fn === 'function') {
            if (!($inject = fn.$inject)) {
                $inject = [];
                if (fn.length) {
                    if (strictDi) {
                        if (!isString(name) || !name) {
                            name = fn.name || anonFn(fn);
                        }
                        throw $injectorMinErr('strictdi',
                            '{0} is not using explicit annotation and cannot be invoked in strict mode', name);
                    }
                    argDecl = extractArgs(fn);
                    forEach(argDecl[1].split(FN_ARG_SPLIT), function(arg) {
                        arg.replace(FN_ARG, function(all, underscore, name) {
                            $inject.push(name);
                        });
                    });
                }
                fn.$inject = $inject;
            }
        } else if (isArray(fn)) {
            last = fn.length - 1;
            assertArgFn(fn[last], 'fn');
            $inject = fn.slice(0, last);
        } else {
            assertArgFn(fn, 'fn', true);
        }
        return $inject;
    }

///////////////////////////////////////

    /**
     * @ngdoc service
     * @name $injector
     *
     * @description
     *
     * `$injector` is used to retrieve object instances as defined by
     * {@link auto.$provide provider}, instantiate types, invoke methods,
     * and load modules.
     *
     * The following always holds true:
     *
     * ```js
     *   var $injector = angular.injector();
     *   expect($injector.get('$injector')).toBe($injector);
     *   expect($injector.invoke(function($injector) {
 *     return $injector;
 *   })).toBe($injector);
     * ```
     *
     * # Injection Function Annotation
     *
     * JavaScript does not have annotations, and annotations are needed for dependency injection. The
     * following are all valid ways of annotating function with injection arguments and are equivalent.
     *
     * ```js
     *   // inferred (only works if code not minified/obfuscated)
     *   $injector.invoke(function(serviceA){});
     *
     *   // annotated
     *   function explicit(serviceA) {};
     *   explicit.$inject = ['serviceA'];
     *   $injector.invoke(explicit);
     *
     *   // inline
     *   $injector.invoke(['serviceA', function(serviceA){}]);
     * ```
     *
     * ## Inference
     *
     * In JavaScript calling `toString()` on a function returns the function definition. The definition
     * can then be parsed and the function arguments can be extracted. This method of discovering
     * annotations is disallowed when the injector is in strict mode.
     * *NOTE:* This does not work with minification, and obfuscation tools since these tools change the
     * argument names.
     *
     * ## `$inject` Annotation
     * By adding an `$inject` property onto a function the injection parameters can be specified.
     *
     * ## Inline
     * As an array of injection names, where the last item in the array is the function to call.
     */

    /**
     * @ngdoc method
     * @name $injector#get
     *
     * @description
     * Return an instance of the service.
     *
     * @param {string} name The name of the instance to retrieve.
     * @param {string=} caller An optional string to provide the origin of the function call for error messages.
     * @return {*} The instance.
     */

    /**
     * @ngdoc method
     * @name $injector#invoke
     *
     * @description
     * Invoke the method and supply the method arguments from the `$injector`.
     *
     * @param {Function|Array.<string|Function>} fn The injectable function to invoke. Function parameters are
     *   injected according to the {@link guide/di $inject Annotation} rules.
     * @param {Object=} self The `this` for the invoked method.
     * @param {Object=} locals Optional object. If preset then any argument names are read from this
     *                         object first, before the `$injector` is consulted.
     * @returns {*} the value returned by the invoked `fn` function.
     */

    /**
     * @ngdoc method
     * @name $injector#has
     *
     * @description
     * Allows the user to query if the particular service exists.
     *
     * @param {string} name Name of the service to query.
     * @returns {boolean} `true` if injector has given service.
     */

    /**
     * @ngdoc method
     * @name $injector#instantiate
     * @description
     * Create a new instance of JS type. The method takes a constructor function, invokes the new
     * operator, and supplies all of the arguments to the constructor function as specified by the
     * constructor annotation.
     *
     * @param {Function} Type Annotated constructor function.
     * @param {Object=} locals Optional object. If preset then any argument names are read from this
     * object first, before the `$injector` is consulted.
     * @returns {Object} new instance of `Type`.
     */

    /**
     * @ngdoc method
     * @name $injector#annotate
     *
     * @description
     * Returns an array of service names which the function is requesting for injection. This API is
     * used by the injector to determine which services need to be injected into the function when the
     * function is invoked. There are three ways in which the function can be annotated with the needed
     * dependencies.
     *
     * # Argument names
     *
     * The simplest form is to extract the dependencies from the arguments of the function. This is done
     * by converting the function into a string using `toString()` method and extracting the argument
     * names.
     * ```js
     *   // Given
     *   function MyController($scope, $route) {
 *     // ...
 *   }
     *
     *   // Then
     *   expect(injector.annotate(MyController)).toEqual(['$scope', '$route']);
     * ```
     *
     * You can disallow this method by using strict injection mode.
     *
     * This method does not work with code minification / obfuscation. For this reason the following
     * annotation strategies are supported.
     *
     * # The `$inject` property
     *
     * If a function has an `$inject` property and its value is an array of strings, then the strings
     * represent names of services to be injected into the function.
     * ```js
     *   // Given
     *   var MyController = function(obfuscatedScope, obfuscatedRoute) {
 *     // ...
 *   }
     *   // Define function dependencies
     *   MyController['$inject'] = ['$scope', '$route'];
     *
     *   // Then
     *   expect(injector.annotate(MyController)).toEqual(['$scope', '$route']);
     * ```
     *
     * # The array notation
     *
     * It is often desirable to inline Injected functions and that's when setting the `$inject` property
     * is very inconvenient. In these situations using the array notation to specify the dependencies in
     * a way that survives minification is a better choice:
     *
     * ```js
     *   // We wish to write this (not minification / obfuscation safe)
     *   injector.invoke(function($compile, $rootScope) {
 *     // ...
 *   });
     *
     *   // We are forced to write break inlining
     *   var tmpFn = function(obfuscatedCompile, obfuscatedRootScope) {
 *     // ...
 *   };
     *   tmpFn.$inject = ['$compile', '$rootScope'];
     *   injector.invoke(tmpFn);
     *
     *   // To better support inline function the inline annotation is supported
     *   injector.invoke(['$compile', '$rootScope', function(obfCompile, obfRootScope) {
 *     // ...
 *   }]);
     *
     *   // Therefore
     *   expect(injector.annotate(
     *      ['$compile', '$rootScope', function(obfus_$compile, obfus_$rootScope) {}])
     *    ).toEqual(['$compile', '$rootScope']);
     * ```
     *
     * @param {Function|Array.<string|Function>} fn Function for which dependent service names need to
     * be retrieved as described above.
     *
     * @param {boolean=} [strictDi=false] Disallow argument name annotation inference.
     *
     * @returns {Array.<string>} The names of the services which the function requires.
     */



    /**
     * @ngdoc service
     * @name $provide
     *
     * @description
     *
     * The {@link auto.$provide $provide} service has a number of methods for registering components
     * with the {@link auto.$injector $injector}. Many of these functions are also exposed on
     * {@link angular.Module}.
     *
     * An Angular **service** is a singleton object created by a **service factory**.  These **service
     * factories** are functions which, in turn, are created by a **service provider**.
     * The **service providers** are constructor functions. When instantiated they must contain a
     * property called `$get`, which holds the **service factory** function.
     *
     * When you request a service, the {@link auto.$injector $injector} is responsible for finding the
     * correct **service provider**, instantiating it and then calling its `$get` **service factory**
     * function to get the instance of the **service**.
     *
     * Often services have no configuration options and there is no need to add methods to the service
     * provider.  The provider will be no more than a constructor function with a `$get` property. For
     * these cases the {@link auto.$provide $provide} service has additional helper methods to register
     * services without specifying a provider.
     *
     * * {@link auto.$provide#provider provider(name, provider)} - registers a **service provider** with the
     *     {@link auto.$injector $injector}
     * * {@link auto.$provide#constant constant(name, obj)} - registers a value/object that can be accessed by
     *     providers and services.
     * * {@link auto.$provide#value value(name, obj)} - registers a value/object that can only be accessed by
     *     services, not providers.
     * * {@link auto.$provide#factory factory(name, fn)} - registers a service **factory function**
     *     that will be wrapped in a **service provider** object, whose `$get` property will contain the
     *     given factory function.
     * * {@link auto.$provide#service service(name, Fn)} - registers a **constructor function**
     *     that will be wrapped in a **service provider** object, whose `$get` property will instantiate
     *      a new object using the given constructor function.
     * * {@link auto.$provide#decorator decorator(name, decorFn)} - registers a **decorator function** that
     *      will be able to modify or replace the implementation of another service.
     *
     * See the individual methods for more information and examples.
     */

    /**
     * @ngdoc method
     * @name $provide#provider
     * @description
     *
     * Register a **provider function** with the {@link auto.$injector $injector}. Provider functions
     * are constructor functions, whose instances are responsible for "providing" a factory for a
     * service.
     *
     * Service provider names start with the name of the service they provide followed by `Provider`.
     * For example, the {@link ng.$log $log} service has a provider called
     * {@link ng.$logProvider $logProvider}.
     *
     * Service provider objects can have additional methods which allow configuration of the provider
     * and its service. Importantly, you can configure what kind of service is created by the `$get`
     * method, or how that service will act. For example, the {@link ng.$logProvider $logProvider} has a
     * method {@link ng.$logProvider#debugEnabled debugEnabled}
     * which lets you specify whether the {@link ng.$log $log} service will log debug messages to the
     * console or not.
     *
     * @param {string} name The name of the instance. NOTE: the provider will be available under `name +
     'Provider'` key.
     * @param {(Object|function())} provider If the provider is:
     *
     *   - `Object`: then it should have a `$get` method. The `$get` method will be invoked using
     *     {@link auto.$injector#invoke $injector.invoke()} when an instance needs to be created.
     *   - `Constructor`: a new instance of the provider will be created using
     *     {@link auto.$injector#instantiate $injector.instantiate()}, then treated as `object`.
     *
     * @returns {Object} registered provider instance

     * @example
     *
     * The following example shows how to create a simple event tracking service and register it using
     * {@link auto.$provide#provider $provide.provider()}.
     *
     * ```js
     *  // Define the eventTracker provider
     *  function EventTrackerProvider() {
 *    var trackingUrl = '/track';
 *
 *    // A provider method for configuring where the tracked events should been saved
 *    this.setTrackingUrl = function(url) {
 *      trackingUrl = url;
 *    };
 *
 *    // The service factory function
 *    this.$get = ['$http', function($http) {
 *      var trackedEvents = {};
 *      return {
 *        // Call this to track an event
 *        event: function(event) {
 *          var count = trackedEvents[event] || 0;
 *          count += 1;
 *          trackedEvents[event] = count;
 *          return count;
 *        },
 *        // Call this to save the tracked events to the trackingUrl
 *        save: function() {
 *          $http.post(trackingUrl, trackedEvents);
 *        }
 *      };
 *    }];
 *  }
     *
     *  describe('eventTracker', function() {
 *    var postSpy;
 *
 *    beforeEach(module(function($provide) {
 *      // Register the eventTracker provider
 *      $provide.provider('eventTracker', EventTrackerProvider);
 *    }));
 *
 *    beforeEach(module(function(eventTrackerProvider) {
 *      // Configure eventTracker provider
 *      eventTrackerProvider.setTrackingUrl('/custom-track');
 *    }));
 *
 *    it('tracks events', inject(function(eventTracker) {
 *      expect(eventTracker.event('login')).toEqual(1);
 *      expect(eventTracker.event('login')).toEqual(2);
 *    }));
 *
 *    it('saves to the tracking url', inject(function(eventTracker, $http) {
 *      postSpy = spyOn($http, 'post');
 *      eventTracker.event('login');
 *      eventTracker.save();
 *      expect(postSpy).toHaveBeenCalled();
 *      expect(postSpy.mostRecentCall.args[0]).not.toEqual('/track');
 *      expect(postSpy.mostRecentCall.args[0]).toEqual('/custom-track');
 *      expect(postSpy.mostRecentCall.args[1]).toEqual({ 'login': 1 });
 *    }));
 *  });
     * ```
     */

    /**
     * @ngdoc method
     * @name $provide#factory
     * @description
     *
     * Register a **service factory**, which will be called to return the service instance.
     * This is short for registering a service where its provider consists of only a `$get` property,
     * which is the given service factory function.
     * You should use {@link auto.$provide#factory $provide.factory(getFn)} if you do not need to
     * configure your service in a provider.
     *
     * @param {string} name The name of the instance.
     * @param {Function|Array.<string|Function>} $getFn The injectable $getFn for the instance creation.
     *                      Internally this is a short hand for `$provide.provider(name, {$get: $getFn})`.
     * @returns {Object} registered provider instance
     *
     * @example
     * Here is an example of registering a service
     * ```js
     *   $provide.factory('ping', ['$http', function($http) {
 *     return function ping() {
 *       return $http.send('/ping');
 *     };
 *   }]);
     * ```
     * You would then inject and use this service like this:
     * ```js
     *   someModule.controller('Ctrl', ['ping', function(ping) {
 *     ping();
 *   }]);
     * ```
     */


    /**
     * @ngdoc method
     * @name $provide#service
     * @description
     *
     * Register a **service constructor**, which will be invoked with `new` to create the service
     * instance.
     * This is short for registering a service where its provider's `$get` property is a factory
     * function that returns an instance instantiated by the injector from the service constructor
     * function.
     *
     * Internally it looks a bit like this:
     *
     * ```
     * {
 *   $get: function() {
 *     return $injector.instantiate(constructor);
 *   }
 * }
     * ```
     *
     *
     * You should use {@link auto.$provide#service $provide.service(class)} if you define your service
     * as a type/class.
     *
     * @param {string} name The name of the instance.
     * @param {Function|Array.<string|Function>} constructor An injectable class (constructor function)
     *     that will be instantiated.
     * @returns {Object} registered provider instance
     *
     * @example
     * Here is an example of registering a service using
     * {@link auto.$provide#service $provide.service(class)}.
     * ```js
     *   var Ping = function($http) {
 *     this.$http = $http;
 *   };
     *
     *   Ping.$inject = ['$http'];
     *
     *   Ping.prototype.send = function() {
 *     return this.$http.get('/ping');
 *   };
     *   $provide.service('ping', Ping);
     * ```
     * You would then inject and use this service like this:
     * ```js
     *   someModule.controller('Ctrl', ['ping', function(ping) {
 *     ping.send();
 *   }]);
     * ```
     */


    /**
     * @ngdoc method
     * @name $provide#value
     * @description
     *
     * Register a **value service** with the {@link auto.$injector $injector}, such as a string, a
     * number, an array, an object or a function. This is short for registering a service where its
     * provider's `$get` property is a factory function that takes no arguments and returns the **value
     * service**. That also means it is not possible to inject other services into a value service.
     *
     * Value services are similar to constant services, except that they cannot be injected into a
     * module configuration function (see {@link angular.Module#config}) but they can be overridden by
     * an Angular {@link auto.$provide#decorator decorator}.
     *
     * @param {string} name The name of the instance.
     * @param {*} value The value.
     * @returns {Object} registered provider instance
     *
     * @example
     * Here are some examples of creating value services.
     * ```js
     *   $provide.value('ADMIN_USER', 'admin');
     *
     *   $provide.value('RoleLookup', { admin: 0, writer: 1, reader: 2 });
     *
     *   $provide.value('halfOf', function(value) {
 *     return value / 2;
 *   });
     * ```
     */


    /**
     * @ngdoc method
     * @name $provide#constant
     * @description
     *
     * Register a **constant service** with the {@link auto.$injector $injector}, such as a string,
     * a number, an array, an object or a function. Like the {@link auto.$provide#value value}, it is not
     * possible to inject other services into a constant.
     *
     * But unlike {@link auto.$provide#value value}, a constant can be
     * injected into a module configuration function (see {@link angular.Module#config}) and it cannot
     * be overridden by an Angular {@link auto.$provide#decorator decorator}.
     *
     * @param {string} name The name of the constant.
     * @param {*} value The constant value.
     * @returns {Object} registered instance
     *
     * @example
     * Here a some examples of creating constants:
     * ```js
     *   $provide.constant('SHARD_HEIGHT', 306);
     *
     *   $provide.constant('MY_COLOURS', ['red', 'blue', 'grey']);
     *
     *   $provide.constant('double', function(value) {
 *     return value * 2;
 *   });
     * ```
     */


    /**
     * @ngdoc method
     * @name $provide#decorator
     * @description
     *
     * Register a **decorator function** with the {@link auto.$injector $injector}. A decorator function
     * intercepts the creation of a service, allowing it to override or modify the behavior of the
     * service. The return value of the decorator function may be the original service, or a new service
     * that replaces (or wraps and delegates to) the original service.
     *
     * You can find out more about using decorators in the {@link guide/decorators} guide.
     *
     * @param {string} name The name of the service to decorate.
     * @param {Function|Array.<string|Function>} decorator This function will be invoked when the service needs to be
     *    provided and should return the decorated service instance. The function is called using
     *    the {@link auto.$injector#invoke injector.invoke} method and is therefore fully injectable.
     *    Local injection arguments:
     *
     *    * `$delegate` - The original service instance, which can be replaced, monkey patched, configured,
     *      decorated or delegated to.
     *
     * @example
     * Here we decorate the {@link ng.$log $log} service to convert warnings to errors by intercepting
     * calls to {@link ng.$log#error $log.warn()}.
     * ```js
     *   $provide.decorator('$log', ['$delegate', function($delegate) {
 *     $delegate.warn = $delegate.error;
 *     return $delegate;
 *   }]);
     * ```
     */


    function createInjector(modulesToLoad, strictDi) {
        strictDi = (strictDi === true);
        var INSTANTIATING = {},
            providerSuffix = 'Provider',
            path = [],
            loadedModules = new HashMap([], true),
            providerCache = {
                $provide: {
                    provider: supportObject(provider),
                    factory: supportObject(factory),
                    service: supportObject(service),
                    value: supportObject(value),
                    constant: supportObject(constant),
                    decorator: decorator
                }
            },
            providerInjector = (providerCache.$injector =
                createInternalInjector(providerCache, function(serviceName, caller) {
                    if (angular.isString(caller)) {
                        path.push(caller);
                    }
                    throw $injectorMinErr('unpr', 'Unknown provider: {0}', path.join(' <- '));
                })),
            instanceCache = {},
            protoInstanceInjector =
                createInternalInjector(instanceCache, function(serviceName, caller) {
                    var provider = providerInjector.get(serviceName + providerSuffix, caller);
                    return instanceInjector.invoke(
                        provider.$get, provider, undefined, serviceName);
                }),
            instanceInjector = protoInstanceInjector;

        providerCache['$injector' + providerSuffix] = { $get: valueFn(protoInstanceInjector) };
        var runBlocks = loadModules(modulesToLoad);
        instanceInjector = protoInstanceInjector.get('$injector');
        instanceInjector.strictDi = strictDi;
        forEach(runBlocks, function(fn) { if (fn) instanceInjector.invoke(fn); });

        return instanceInjector;

        ////////////////////////////////////
        // $provider
        ////////////////////////////////////

        function supportObject(delegate) {
            return function(key, value) {
                if (isObject(key)) {
                    forEach(key, reverseParams(delegate));
                } else {
                    return delegate(key, value);
                }
            };
        }

        function provider(name, provider_) {
            assertNotHasOwnProperty(name, 'service');
            if (isFunction(provider_) || isArray(provider_)) {
                provider_ = providerInjector.instantiate(provider_);
            }
            if (!provider_.$get) {
                throw $injectorMinErr('pget', 'Provider \'{0}\' must define $get factory method.', name);
            }
            return (providerCache[name + providerSuffix] = provider_);
        }

        function enforceReturnValue(name, factory) {
            return /** @this */ function enforcedReturnValue() {
                var result = instanceInjector.invoke(factory, this);
                if (isUndefined(result)) {
                    throw $injectorMinErr('undef', 'Provider \'{0}\' must return a value from $get factory method.', name);
                }
                return result;
            };
        }

        function factory(name, factoryFn, enforce) {
            return provider(name, {
                $get: enforce !== false ? enforceReturnValue(name, factoryFn) : factoryFn
            });
        }

        function service(name, constructor) {
            return factory(name, ['$injector', function($injector) {
                return $injector.instantiate(constructor);
            }]);
        }

        function value(name, val) { return factory(name, valueFn(val), false); }

        function constant(name, value) {
            assertNotHasOwnProperty(name, 'constant');
            providerCache[name] = value;
            instanceCache[name] = value;
        }

        function decorator(serviceName, decorFn) {
            var origProvider = providerInjector.get(serviceName + providerSuffix),
                orig$get = origProvider.$get;

            origProvider.$get = function() {
                var origInstance = instanceInjector.invoke(orig$get, origProvider);
                return instanceInjector.invoke(decorFn, null, {$delegate: origInstance});
            };
        }

        ////////////////////////////////////
        // Module Loading
        ////////////////////////////////////
        function loadModules(modulesToLoad) {
            assertArg(isUndefined(modulesToLoad) || isArray(modulesToLoad), 'modulesToLoad', 'not an array');
            var runBlocks = [], moduleFn;
            forEach(modulesToLoad, function(module) {
                if (loadedModules.get(module)) return;
                loadedModules.put(module, true);

                function runInvokeQueue(queue) {
                    var i, ii;
                    for (i = 0, ii = queue.length; i < ii; i++) {
                        var invokeArgs = queue[i],
                            provider = providerInjector.get(invokeArgs[0]);

                        provider[invokeArgs[1]].apply(provider, invokeArgs[2]);
                    }
                }

                try {
                    if (isString(module)) {
                        moduleFn = angularModule(module);
                        runBlocks = runBlocks.concat(loadModules(moduleFn.requires)).concat(moduleFn._runBlocks);
                        runInvokeQueue(moduleFn._invokeQueue);
                        runInvokeQueue(moduleFn._configBlocks);
                    } else if (isFunction(module)) {
                        runBlocks.push(providerInjector.invoke(module));
                    } else if (isArray(module)) {
                        runBlocks.push(providerInjector.invoke(module));
                    } else {
                        assertArgFn(module, 'module');
                    }
                } catch (e) {
                    if (isArray(module)) {
                        module = module[module.length - 1];
                    }
                    if (e.message && e.stack && e.stack.indexOf(e.message) === -1) {
                        // Safari & FF's stack traces don't contain error.message content
                        // unlike those of Chrome and IE
                        // So if stack doesn't contain message, we create a new string that contains both.
                        // Since error.stack is read-only in Safari, I'm overriding e and not e.stack here.
                        // eslint-disable-next-line no-ex-assign
                        e = e.message + '\n' + e.stack;
                    }
                    throw $injectorMinErr('modulerr', 'Failed to instantiate module {0} due to:\n{1}',
                        module, e.stack || e.message || e);
                }
            });
            return runBlocks;
        }

        ////////////////////////////////////
        // internal Injector
        ////////////////////////////////////

        function createInternalInjector(cache, factory) {

            function getService(serviceName, caller) {
                if (cache.hasOwnProperty(serviceName)) {
                    if (cache[serviceName] === INSTANTIATING) {
                        throw $injectorMinErr('cdep', 'Circular dependency found: {0}',
                            serviceName + ' <- ' + path.join(' <- '));
                    }
                    return cache[serviceName];
                } else {
                    try {
                        path.unshift(serviceName);
                        cache[serviceName] = INSTANTIATING;
                        cache[serviceName] = factory(serviceName, caller);
                        return cache[serviceName];
                    } catch (err) {
                        if (cache[serviceName] === INSTANTIATING) {
                            delete cache[serviceName];
                        }
                        throw err;
                    } finally {
                        path.shift();
                    }
                }
            }


            function injectionArgs(fn, locals, serviceName) {
                var args = [],
                    $inject = createInjector.$$annotate(fn, strictDi, serviceName);

                for (var i = 0, length = $inject.length; i < length; i++) {
                    var key = $inject[i];
                    if (typeof key !== 'string') {
                        throw $injectorMinErr('itkn',
                            'Incorrect injection token! Expected service name as string, got {0}', key);
                    }
                    args.push(locals && locals.hasOwnProperty(key) ? locals[key] :
                        getService(key, serviceName));
                }
                return args;
            }

            function isClass(func) {
                // IE 9-11 do not support classes and IE9 leaks with the code below.
                if (msie <= 11) {
                    return false;
                }
                // Support: Edge 12-13 only
                // See: https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/6156135/
                return typeof func === 'function'
                    && /^(?:class\b|constructor\()/.test(stringifyFn(func));
            }

            function invoke(fn, self, locals, serviceName) {
                if (typeof locals === 'string') {
                    serviceName = locals;
                    locals = null;
                }

                var args = injectionArgs(fn, locals, serviceName);
                if (isArray(fn)) {
                    fn = fn[fn.length - 1];
                }

                if (!isClass(fn)) {
                    // http://jsperf.com/angularjs-invoke-apply-vs-switch
                    // #5388
                    return fn.apply(self, args);
                } else {
                    args.unshift(null);
                    return new (Function.prototype.bind.apply(fn, args))();
                }
            }


            function instantiate(Type, locals, serviceName) {
                // Check if Type is annotated and use just the given function at n-1 as parameter
                // e.g. someModule.factory('greeter', ['$window', function(renamed$window) {}]);
                var ctor = (isArray(Type) ? Type[Type.length - 1] : Type);
                var args = injectionArgs(Type, locals, serviceName);
                // Empty object at position 0 is ignored for invocation with `new`, but required.
                args.unshift(null);
                return new (Function.prototype.bind.apply(ctor, args))();
            }


            return {
                invoke: invoke,
                instantiate: instantiate,
                get: getService,
                annotate: createInjector.$$annotate,
                has: function(name) {
                    return providerCache.hasOwnProperty(name + providerSuffix) || cache.hasOwnProperty(name);
                }
            };
        }
    }

    createInjector.$$annotate = annotate;

    /**
     * @ngdoc provider
     * @name $anchorScrollProvider
     * @this
     *
     * @description
     * Use `$anchorScrollProvider` to disable automatic scrolling whenever
     * {@link ng.$location#hash $location.hash()} changes.
     */
    function $AnchorScrollProvider() {

        var autoScrollingEnabled = true;

        /**
         * @ngdoc method
         * @name $anchorScrollProvider#disableAutoScrolling
         *
         * @description
         * By default, {@link ng.$anchorScroll $anchorScroll()} will automatically detect changes to
         * {@link ng.$location#hash $location.hash()} and scroll to the element matching the new hash.<br />
         * Use this method to disable automatic scrolling.
         *
         * If automatic scrolling is disabled, one must explicitly call
         * {@link ng.$anchorScroll $anchorScroll()} in order to scroll to the element related to the
         * current hash.
         */
        this.disableAutoScrolling = function() {
            autoScrollingEnabled = false;
        };

        /**
         * @ngdoc service
         * @name $anchorScroll
         * @kind function
         * @requires $window
         * @requires $location
         * @requires $rootScope
         *
         * @description
         * When called, it scrolls to the element related to the specified `hash` or (if omitted) to the
         * current value of {@link ng.$location#hash $location.hash()}, according to the rules specified
         * in the
         * [HTML5 spec](http://www.w3.org/html/wg/drafts/html/master/browsers.html#an-indicated-part-of-the-document).
         *
         * It also watches the {@link ng.$location#hash $location.hash()} and automatically scrolls to
         * match any anchor whenever it changes. This can be disabled by calling
         * {@link ng.$anchorScrollProvider#disableAutoScrolling $anchorScrollProvider.disableAutoScrolling()}.
         *
         * Additionally, you can use its {@link ng.$anchorScroll#yOffset yOffset} property to specify a
         * vertical scroll-offset (either fixed or dynamic).
         *
         * @param {string=} hash The hash specifying the element to scroll to. If omitted, the value of
         *                       {@link ng.$location#hash $location.hash()} will be used.
         *
         * @property {(number|function|jqLite)} yOffset
         * If set, specifies a vertical scroll-offset. This is often useful when there are fixed
         * positioned elements at the top of the page, such as navbars, headers etc.
         *
         * `yOffset` can be specified in various ways:
         * - **number**: A fixed number of pixels to be used as offset.<br /><br />
         * - **function**: A getter function called everytime `$anchorScroll()` is executed. Must return
         *   a number representing the offset (in pixels).<br /><br />
         * - **jqLite**: A jqLite/jQuery element to be used for specifying the offset. The distance from
         *   the top of the page to the element's bottom will be used as offset.<br />
         *   **Note**: The element will be taken into account only as long as its `position` is set to
         *   `fixed`. This option is useful, when dealing with responsive navbars/headers that adjust
         *   their height and/or positioning according to the viewport's size.
         *
         * <br />
         * <div class="alert alert-warning">
         * In order for `yOffset` to work properly, scrolling should take place on the document's root and
         * not some child element.
         * </div>
         *
         * @example
         <example module="anchorScrollExample" name="anchor-scroll">
         <file name="index.html">
         <div id="scrollArea" ng-controller="ScrollController">
         <a ng-click="gotoBottom()">Go to bottom</a>
         <a id="bottom"></a> You're at the bottom!
         </div>
         </file>
         <file name="script.js">
         angular.module('anchorScrollExample', [])
         .controller('ScrollController', ['$scope', '$location', '$anchorScroll',
         function($scope, $location, $anchorScroll) {
               $scope.gotoBottom = function() {
                 // set the location.hash to the id of
                 // the element you wish to scroll to.
                 $location.hash('bottom');

                 // call $anchorScroll()
                 $anchorScroll();
               };
             }]);
         </file>
         <file name="style.css">
         #scrollArea {
           height: 280px;
           overflow: auto;
         }

         #bottom {
           display: block;
           margin-top: 2000px;
         }
         </file>
         </example>
         *
         * <hr />
         * The example below illustrates the use of a vertical scroll-offset (specified as a fixed value).
         * See {@link ng.$anchorScroll#yOffset $anchorScroll.yOffset} for more details.
         *
         * @example
         <example module="anchorScrollOffsetExample" name="anchor-scroll-offset">
         <file name="index.html">
         <div class="fixed-header" ng-controller="headerCtrl">
         <a href="" ng-click="gotoAnchor(x)" ng-repeat="x in [1,2,3,4,5]">
         Go to anchor {{x}}
         </a>
         </div>
         <div id="anchor{{x}}" class="anchor" ng-repeat="x in [1,2,3,4,5]">
         Anchor {{x}} of 5
         </div>
         </file>
         <file name="script.js">
         angular.module('anchorScrollOffsetExample', [])
         .run(['$anchorScroll', function($anchorScroll) {
             $anchorScroll.yOffset = 50;   // always scroll by 50 extra pixels
           }])
         .controller('headerCtrl', ['$anchorScroll', '$location', '$scope',
         function($anchorScroll, $location, $scope) {
               $scope.gotoAnchor = function(x) {
                 var newHash = 'anchor' + x;
                 if ($location.hash() !== newHash) {
                   // set the $location.hash to `newHash` and
                   // $anchorScroll will automatically scroll to it
                   $location.hash('anchor' + x);
                 } else {
                   // call $anchorScroll() explicitly,
                   // since $location.hash hasn't changed
                   $anchorScroll();
                 }
               };
             }
         ]);
         </file>
         <file name="style.css">
         body {
           padding-top: 50px;
         }

         .anchor {
           border: 2px dashed DarkOrchid;
           padding: 10px 10px 200px 10px;
         }

         .fixed-header {
           background-color: rgba(0, 0, 0, 0.2);
           height: 50px;
           position: fixed;
           top: 0; left: 0; right: 0;
         }

         .fixed-header > a {
           display: inline-block;
           margin: 5px 15px;
         }
         </file>
         </example>
         */
        this.$get = ['$window', '$location', '$rootScope', function($window, $location, $rootScope) {
            var document = $window.document;

            // Helper function to get first anchor from a NodeList
            // (using `Array#some()` instead of `angular#forEach()` since it's more performant
            //  and working in all supported browsers.)
            function getFirstAnchor(list) {
                var result = null;
                Array.prototype.some.call(list, function(element) {
                    if (nodeName_(element) === 'a') {
                        result = element;
                        return true;
                    }
                });
                return result;
            }

            function getYOffset() {

                var offset = scroll.yOffset;

                if (isFunction(offset)) {
                    offset = offset();
                } else if (isElement(offset)) {
                    var elem = offset[0];
                    var style = $window.getComputedStyle(elem);
                    if (style.position !== 'fixed') {
                        offset = 0;
                    } else {
                        offset = elem.getBoundingClientRect().bottom;
                    }
                } else if (!isNumber(offset)) {
                    offset = 0;
                }

                return offset;
            }

            function scrollTo(elem) {
                if (elem) {
                    elem.scrollIntoView();

                    var offset = getYOffset();

                    if (offset) {
                        // `offset` is the number of pixels we should scroll UP in order to align `elem` properly.
                        // This is true ONLY if the call to `elem.scrollIntoView()` initially aligns `elem` at the
                        // top of the viewport.
                        //
                        // IF the number of pixels from the top of `elem` to the end of the page's content is less
                        // than the height of the viewport, then `elem.scrollIntoView()` will align the `elem` some
                        // way down the page.
                        //
                        // This is often the case for elements near the bottom of the page.
                        //
                        // In such cases we do not need to scroll the whole `offset` up, just the difference between
                        // the top of the element and the offset, which is enough to align the top of `elem` at the
                        // desired position.
                        var elemTop = elem.getBoundingClientRect().top;
                        $window.scrollBy(0, elemTop - offset);
                    }
                } else {
                    $window.scrollTo(0, 0);
                }
            }

            function scroll(hash) {
                hash = isString(hash) ? hash : $location.hash();
                var elm;

                // empty hash, scroll to the top of the page
                if (!hash) scrollTo(null);

                // element with given id
                else if ((elm = document.getElementById(hash))) scrollTo(elm);

                // first anchor with given name :-D
                else if ((elm = getFirstAnchor(document.getElementsByName(hash)))) scrollTo(elm);

                // no element and hash === 'top', scroll to the top of the page
                else if (hash === 'top') scrollTo(null);
            }

            // does not scroll when user clicks on anchor link that is currently on
            // (no url change, no $location.hash() change), browser native does scroll
            if (autoScrollingEnabled) {
                $rootScope.$watch(function autoScrollWatch() {return $location.hash();},
                    function autoScrollWatchAction(newVal, oldVal) {
                        // skip the initial scroll if $location.hash is empty
                        if (newVal === oldVal && newVal === '') return;

                        jqLiteDocumentLoaded(function() {
                            $rootScope.$evalAsync(scroll);
                        });
                    });
            }

            return scroll;
        }];
    }

    var $animateMinErr = minErr('$animate');
    var ELEMENT_NODE = 1;
    var NG_ANIMATE_CLASSNAME = 'ng-animate';

    function mergeClasses(a,b) {
        if (!a && !b) return '';
        if (!a) return b;
        if (!b) return a;
        if (isArray(a)) a = a.join(' ');
        if (isArray(b)) b = b.join(' ');
        return a + ' ' + b;
    }

    function extractElementNode(element) {
        for (var i = 0; i < element.length; i++) {
            var elm = element[i];
            if (elm.nodeType === ELEMENT_NODE) {
                return elm;
            }
        }
    }

    function splitClasses(classes) {
        if (isString(classes)) {
            classes = classes.split(' ');
        }

        // Use createMap() to prevent class assumptions involving property names in
        // Object.prototype
        var obj = createMap();
        forEach(classes, function(klass) {
            // sometimes the split leaves empty string values
            // incase extra spaces were applied to the options
            if (klass.length) {
                obj[klass] = true;
            }
        });
        return obj;
    }

// if any other type of options value besides an Object value is
// passed into the $animate.method() animation then this helper code
// will be run which will ignore it. While this patch is not the
// greatest solution to this, a lot of existing plugins depend on
// $animate to either call the callback (< 1.2) or return a promise
// that can be changed. This helper function ensures that the options
// are wiped clean incase a callback function is provided.
    function prepareAnimateOptions(options) {
        return isObject(options)
            ? options
            : {};
    }

    var $$CoreAnimateJsProvider = /** @this */ function() {
        this.$get = noop;
    };

// this is prefixed with Core since it conflicts with
// the animateQueueProvider defined in ngAnimate/animateQueue.js
    var $$CoreAnimateQueueProvider = /** @this */ function() {
        var postDigestQueue = new HashMap();
        var postDigestElements = [];

        this.$get = ['$$AnimateRunner', '$rootScope',
            function($$AnimateRunner,   $rootScope) {
                return {
                    enabled: noop,
                    on: noop,
                    off: noop,
                    pin: noop,

                    push: function(element, event, options, domOperation) {
                        if (domOperation) {
                            domOperation();
                        }

                        options = options || {};
                        if (options.from) {
                            element.css(options.from);
                        }
                        if (options.to) {
                            element.css(options.to);
                        }

                        if (options.addClass || options.removeClass) {
                            addRemoveClassesPostDigest(element, options.addClass, options.removeClass);
                        }

                        var runner = new $$AnimateRunner();

                        // since there are no animations to run the runner needs to be
                        // notified that the animation call is complete.
                        runner.complete();
                        return runner;
                    }
                };


                function updateData(data, classes, value) {
                    var changed = false;
                    if (classes) {
                        classes = isString(classes) ? classes.split(' ') :
                            isArray(classes) ? classes : [];
                        forEach(classes, function(className) {
                            if (className) {
                                changed = true;
                                data[className] = value;
                            }
                        });
                    }
                    return changed;
                }

                function handleCSSClassChanges() {
                    forEach(postDigestElements, function(element) {
                        var data = postDigestQueue.get(element);
                        if (data) {
                            var existing = splitClasses(element.attr('class'));
                            var toAdd = '';
                            var toRemove = '';
                            forEach(data, function(status, className) {
                                var hasClass = !!existing[className];
                                if (status !== hasClass) {
                                    if (status) {
                                        toAdd += (toAdd.length ? ' ' : '') + className;
                                    } else {
                                        toRemove += (toRemove.length ? ' ' : '') + className;
                                    }
                                }
                            });

                            forEach(element, function(elm) {
                                if (toAdd) {
                                    jqLiteAddClass(elm, toAdd);
                                }
                                if (toRemove) {
                                    jqLiteRemoveClass(elm, toRemove);
                                }
                            });
                            postDigestQueue.remove(element);
                        }
                    });
                    postDigestElements.length = 0;
                }


                function addRemoveClassesPostDigest(element, add, remove) {
                    var data = postDigestQueue.get(element) || {};

                    var classesAdded = updateData(data, add, true);
                    var classesRemoved = updateData(data, remove, false);

                    if (classesAdded || classesRemoved) {

                        postDigestQueue.put(element, data);
                        postDigestElements.push(element);

                        if (postDigestElements.length === 1) {
                            $rootScope.$$postDigest(handleCSSClassChanges);
                        }
                    }
                }
            }];
    };

    /**
     * @ngdoc provider
     * @name $animateProvider
     *
     * @description
     * Default implementation of $animate that doesn't perform any animations, instead just
     * synchronously performs DOM updates and resolves the returned runner promise.
     *
     * In order to enable animations the `ngAnimate` module has to be loaded.
     *
     * To see the functional implementation check out `src/ngAnimate/animate.js`.
     */
    var $AnimateProvider = ['$provide', /** @this */ function($provide) {
        var provider = this;

        this.$$registeredAnimations = Object.create(null);

        /**
         * @ngdoc method
         * @name $animateProvider#register
         *
         * @description
         * Registers a new injectable animation factory function. The factory function produces the
         * animation object which contains callback functions for each event that is expected to be
         * animated.
         *
         *   * `eventFn`: `function(element, ... , doneFunction, options)`
         *   The element to animate, the `doneFunction` and the options fed into the animation. Depending
         *   on the type of animation additional arguments will be injected into the animation function. The
         *   list below explains the function signatures for the different animation methods:
         *
         *   - setClass: function(element, addedClasses, removedClasses, doneFunction, options)
         *   - addClass: function(element, addedClasses, doneFunction, options)
         *   - removeClass: function(element, removedClasses, doneFunction, options)
         *   - enter, leave, move: function(element, doneFunction, options)
         *   - animate: function(element, fromStyles, toStyles, doneFunction, options)
         *
         *   Make sure to trigger the `doneFunction` once the animation is fully complete.
         *
         * ```js
         *   return {
   *     //enter, leave, move signature
   *     eventFn : function(element, done, options) {
   *       //code to run the animation
   *       //once complete, then run done()
   *       return function endFunction(wasCancelled) {
   *         //code to cancel the animation
   *       }
   *     }
   *   }
         * ```
         *
         * @param {string} name The name of the animation (this is what the class-based CSS value will be compared to).
         * @param {Function} factory The factory function that will be executed to return the animation
         *                           object.
         */
        this.register = function(name, factory) {
            if (name && name.charAt(0) !== '.') {
                throw $animateMinErr('notcsel', 'Expecting class selector starting with \'.\' got \'{0}\'.', name);
            }

            var key = name + '-animation';
            provider.$$registeredAnimations[name.substr(1)] = key;
            $provide.factory(key, factory);
        };

        /**
         * @ngdoc method
         * @name $animateProvider#classNameFilter
         *
         * @description
         * Sets and/or returns the CSS class regular expression that is checked when performing
         * an animation. Upon bootstrap the classNameFilter value is not set at all and will
         * therefore enable $animate to attempt to perform an animation on any element that is triggered.
         * When setting the `classNameFilter` value, animations will only be performed on elements
         * that successfully match the filter expression. This in turn can boost performance
         * for low-powered devices as well as applications containing a lot of structural operations.
         * @param {RegExp=} expression The className expression which will be checked against all animations
         * @return {RegExp} The current CSS className expression value. If null then there is no expression value
         */
        this.classNameFilter = function(expression) {
            if (arguments.length === 1) {
                this.$$classNameFilter = (expression instanceof RegExp) ? expression : null;
                if (this.$$classNameFilter) {
                    var reservedRegex = new RegExp('(\\s+|\\/)' + NG_ANIMATE_CLASSNAME + '(\\s+|\\/)');
                    if (reservedRegex.test(this.$$classNameFilter.toString())) {
                        throw $animateMinErr('nongcls','$animateProvider.classNameFilter(regex) prohibits accepting a regex value which matches/contains the "{0}" CSS class.', NG_ANIMATE_CLASSNAME);

                    }
                }
            }
            return this.$$classNameFilter;
        };

        this.$get = ['$$animateQueue', function($$animateQueue) {
            function domInsert(element, parentElement, afterElement) {
                // if for some reason the previous element was removed
                // from the dom sometime before this code runs then let's
                // just stick to using the parent element as the anchor
                if (afterElement) {
                    var afterNode = extractElementNode(afterElement);
                    if (afterNode && !afterNode.parentNode && !afterNode.previousElementSibling) {
                        afterElement = null;
                    }
                }
                if (afterElement) {
                    afterElement.after(element);
                } else {
                    parentElement.prepend(element);
                }
            }

            /**
             * @ngdoc service
             * @name $animate
             * @description The $animate service exposes a series of DOM utility methods that provide support
             * for animation hooks. The default behavior is the application of DOM operations, however,
             * when an animation is detected (and animations are enabled), $animate will do the heavy lifting
             * to ensure that animation runs with the triggered DOM operation.
             *
             * By default $animate doesn't trigger any animations. This is because the `ngAnimate` module isn't
             * included and only when it is active then the animation hooks that `$animate` triggers will be
             * functional. Once active then all structural `ng-` directives will trigger animations as they perform
             * their DOM-related operations (enter, leave and move). Other directives such as `ngClass`,
             * `ngShow`, `ngHide` and `ngMessages` also provide support for animations.
             *
             * It is recommended that the`$animate` service is always used when executing DOM-related procedures within directives.
             *
             * To learn more about enabling animation support, click here to visit the
             * {@link ngAnimate ngAnimate module page}.
             */
            return {
                // we don't call it directly since non-existant arguments may
                // be interpreted as null within the sub enabled function

                /**
                 *
                 * @ngdoc method
                 * @name $animate#on
                 * @kind function
                 * @description Sets up an event listener to fire whenever the animation event (enter, leave, move, etc...)
                 *    has fired on the given element or among any of its children. Once the listener is fired, the provided callback
                 *    is fired with the following params:
                 *
                 * ```js
                 * $animate.on('enter', container,
                 *    function callback(element, phase) {
       *      // cool we detected an enter animation within the container
       *    }
                 * );
                 * ```
                 *
                 * @param {string} event the animation event that will be captured (e.g. enter, leave, move, addClass, removeClass, etc...)
                 * @param {DOMElement} container the container element that will capture each of the animation events that are fired on itself
                 *     as well as among its children
                 * @param {Function} callback the callback function that will be fired when the listener is triggered
                 *
                 * The arguments present in the callback function are:
                 * * `element` - The captured DOM element that the animation was fired on.
                 * * `phase` - The phase of the animation. The two possible phases are **start** (when the animation starts) and **close** (when it ends).
                 */
                on: $$animateQueue.on,

                /**
                 *
                 * @ngdoc method
                 * @name $animate#off
                 * @kind function
                 * @description Deregisters an event listener based on the event which has been associated with the provided element. This method
                 * can be used in three different ways depending on the arguments:
                 *
                 * ```js
                 * // remove all the animation event listeners listening for `enter`
                 * $animate.off('enter');
                 *
                 * // remove listeners for all animation events from the container element
                 * $animate.off(container);
                 *
                 * // remove all the animation event listeners listening for `enter` on the given element and its children
                 * $animate.off('enter', container);
                 *
                 * // remove the event listener function provided by `callback` that is set
                 * // to listen for `enter` on the given `container` as well as its children
                 * $animate.off('enter', container, callback);
                 * ```
                 *
                 * @param {string|DOMElement} event|container the animation event (e.g. enter, leave, move,
                 * addClass, removeClass, etc...), or the container element. If it is the element, all other
                 * arguments are ignored.
                 * @param {DOMElement=} container the container element the event listener was placed on
                 * @param {Function=} callback the callback function that was registered as the listener
                 */
                off: $$animateQueue.off,

                /**
                 * @ngdoc method
                 * @name $animate#pin
                 * @kind function
                 * @description Associates the provided element with a host parent element to allow the element to be animated even if it exists
                 *    outside of the DOM structure of the Angular application. By doing so, any animation triggered via `$animate` can be issued on the
                 *    element despite being outside the realm of the application or within another application. Say for example if the application
                 *    was bootstrapped on an element that is somewhere inside of the `<body>` tag, but we wanted to allow for an element to be situated
                 *    as a direct child of `document.body`, then this can be achieved by pinning the element via `$animate.pin(element)`. Keep in mind
                 *    that calling `$animate.pin(element, parentElement)` will not actually insert into the DOM anywhere; it will just create the association.
                 *
                 *    Note that this feature is only active when the `ngAnimate` module is used.
                 *
                 * @param {DOMElement} element the external element that will be pinned
                 * @param {DOMElement} parentElement the host parent element that will be associated with the external element
                 */
                pin: $$animateQueue.pin,

                /**
                 *
                 * @ngdoc method
                 * @name $animate#enabled
                 * @kind function
                 * @description Used to get and set whether animations are enabled or not on the entire application or on an element and its children. This
                 * function can be called in four ways:
                 *
                 * ```js
                 * // returns true or false
                 * $animate.enabled();
                 *
                 * // changes the enabled state for all animations
                 * $animate.enabled(false);
                 * $animate.enabled(true);
                 *
                 * // returns true or false if animations are enabled for an element
                 * $animate.enabled(element);
                 *
                 * // changes the enabled state for an element and its children
                 * $animate.enabled(element, true);
                 * $animate.enabled(element, false);
                 * ```
                 *
                 * @param {DOMElement=} element the element that will be considered for checking/setting the enabled state
                 * @param {boolean=} enabled whether or not the animations will be enabled for the element
                 *
                 * @return {boolean} whether or not animations are enabled
                 */
                enabled: $$animateQueue.enabled,

                /**
                 * @ngdoc method
                 * @name $animate#cancel
                 * @kind function
                 * @description Cancels the provided animation.
                 *
                 * @param {Promise} animationPromise The animation promise that is returned when an animation is started.
                 */
                cancel: function(runner) {
                    if (runner.end) {
                        runner.end();
                    }
                },

                /**
                 *
                 * @ngdoc method
                 * @name $animate#enter
                 * @kind function
                 * @description Inserts the element into the DOM either after the `after` element (if provided) or
                 *   as the first child within the `parent` element and then triggers an animation.
                 *   A promise is returned that will be resolved during the next digest once the animation
                 *   has completed.
                 *
                 * @param {DOMElement} element the element which will be inserted into the DOM
                 * @param {DOMElement} parent the parent element which will append the element as
                 *   a child (so long as the after element is not present)
                 * @param {DOMElement=} after the sibling element after which the element will be appended
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                enter: function(element, parent, after, options) {
                    parent = parent && jqLite(parent);
                    after = after && jqLite(after);
                    parent = parent || after.parent();
                    domInsert(element, parent, after);
                    return $$animateQueue.push(element, 'enter', prepareAnimateOptions(options));
                },

                /**
                 *
                 * @ngdoc method
                 * @name $animate#move
                 * @kind function
                 * @description Inserts (moves) the element into its new position in the DOM either after
                 *   the `after` element (if provided) or as the first child within the `parent` element
                 *   and then triggers an animation. A promise is returned that will be resolved
                 *   during the next digest once the animation has completed.
                 *
                 * @param {DOMElement} element the element which will be moved into the new DOM position
                 * @param {DOMElement} parent the parent element which will append the element as
                 *   a child (so long as the after element is not present)
                 * @param {DOMElement=} after the sibling element after which the element will be appended
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                move: function(element, parent, after, options) {
                    parent = parent && jqLite(parent);
                    after = after && jqLite(after);
                    parent = parent || after.parent();
                    domInsert(element, parent, after);
                    return $$animateQueue.push(element, 'move', prepareAnimateOptions(options));
                },

                /**
                 * @ngdoc method
                 * @name $animate#leave
                 * @kind function
                 * @description Triggers an animation and then removes the element from the DOM.
                 * When the function is called a promise is returned that will be resolved during the next
                 * digest once the animation has completed.
                 *
                 * @param {DOMElement} element the element which will be removed from the DOM
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                leave: function(element, options) {
                    return $$animateQueue.push(element, 'leave', prepareAnimateOptions(options), function() {
                        element.remove();
                    });
                },

                /**
                 * @ngdoc method
                 * @name $animate#addClass
                 * @kind function
                 *
                 * @description Triggers an addClass animation surrounding the addition of the provided CSS class(es). Upon
                 *   execution, the addClass operation will only be handled after the next digest and it will not trigger an
                 *   animation if element already contains the CSS class or if the class is removed at a later step.
                 *   Note that class-based animations are treated differently compared to structural animations
                 *   (like enter, move and leave) since the CSS classes may be added/removed at different points
                 *   depending if CSS or JavaScript animations are used.
                 *
                 * @param {DOMElement} element the element which the CSS classes will be applied to
                 * @param {string} className the CSS class(es) that will be added (multiple classes are separated via spaces)
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                addClass: function(element, className, options) {
                    options = prepareAnimateOptions(options);
                    options.addClass = mergeClasses(options.addclass, className);
                    return $$animateQueue.push(element, 'addClass', options);
                },

                /**
                 * @ngdoc method
                 * @name $animate#removeClass
                 * @kind function
                 *
                 * @description Triggers a removeClass animation surrounding the removal of the provided CSS class(es). Upon
                 *   execution, the removeClass operation will only be handled after the next digest and it will not trigger an
                 *   animation if element does not contain the CSS class or if the class is added at a later step.
                 *   Note that class-based animations are treated differently compared to structural animations
                 *   (like enter, move and leave) since the CSS classes may be added/removed at different points
                 *   depending if CSS or JavaScript animations are used.
                 *
                 * @param {DOMElement} element the element which the CSS classes will be applied to
                 * @param {string} className the CSS class(es) that will be removed (multiple classes are separated via spaces)
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                removeClass: function(element, className, options) {
                    options = prepareAnimateOptions(options);
                    options.removeClass = mergeClasses(options.removeClass, className);
                    return $$animateQueue.push(element, 'removeClass', options);
                },

                /**
                 * @ngdoc method
                 * @name $animate#setClass
                 * @kind function
                 *
                 * @description Performs both the addition and removal of a CSS classes on an element and (during the process)
                 *    triggers an animation surrounding the class addition/removal. Much like `$animate.addClass` and
                 *    `$animate.removeClass`, `setClass` will only evaluate the classes being added/removed once a digest has
                 *    passed. Note that class-based animations are treated differently compared to structural animations
                 *    (like enter, move and leave) since the CSS classes may be added/removed at different points
                 *    depending if CSS or JavaScript animations are used.
                 *
                 * @param {DOMElement} element the element which the CSS classes will be applied to
                 * @param {string} add the CSS class(es) that will be added (multiple classes are separated via spaces)
                 * @param {string} remove the CSS class(es) that will be removed (multiple classes are separated via spaces)
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                setClass: function(element, add, remove, options) {
                    options = prepareAnimateOptions(options);
                    options.addClass = mergeClasses(options.addClass, add);
                    options.removeClass = mergeClasses(options.removeClass, remove);
                    return $$animateQueue.push(element, 'setClass', options);
                },

                /**
                 * @ngdoc method
                 * @name $animate#animate
                 * @kind function
                 *
                 * @description Performs an inline animation on the element which applies the provided to and from CSS styles to the element.
                 * If any detected CSS transition, keyframe or JavaScript matches the provided className value, then the animation will take
                 * on the provided styles. For example, if a transition animation is set for the given classNamem, then the provided `from` and
                 * `to` styles will be applied alongside the given transition. If the CSS style provided in `from` does not have a corresponding
                 * style in `to`, the style in `from` is applied immediately, and no animation is run.
                 * If a JavaScript animation is detected then the provided styles will be given in as function parameters into the `animate`
                 * method (or as part of the `options` parameter):
                 *
                 * ```js
                 * ngModule.animation('.my-inline-animation', function() {
       *   return {
       *     animate : function(element, from, to, done, options) {
       *       //animation
       *       done();
       *     }
       *   }
       * });
                 * ```
                 *
                 * @param {DOMElement} element the element which the CSS styles will be applied to
                 * @param {object} from the from (starting) CSS styles that will be applied to the element and across the animation.
                 * @param {object} to the to (destination) CSS styles that will be applied to the element and across the animation.
                 * @param {string=} className an optional CSS class that will be applied to the element for the duration of the animation. If
                 *    this value is left as empty then a CSS class of `ng-inline-animate` will be applied to the element.
                 *    (Note that if no animation is detected then this value will not be applied to the element.)
                 * @param {object=} options an optional collection of options/styles that will be applied to the element.
                 *   The object can have the following properties:
                 *
                 *   - **addClass** - `{string}` - space-separated CSS classes to add to element
                 *   - **from** - `{Object}` - CSS properties & values at the beginning of animation. Must have matching `to`
                 *   - **removeClass** - `{string}` - space-separated CSS classes to remove from element
                 *   - **to** - `{Object}` - CSS properties & values at end of animation. Must have matching `from`
                 *
                 * @return {Promise} the animation callback promise
                 */
                animate: function(element, from, to, className, options) {
                    options = prepareAnimateOptions(options);
                    options.from = options.from ? extend(options.from, from) : from;
                    options.to   = options.to   ? extend(options.to, to)     : to;

                    className = className || 'ng-inline-animate';
                    options.tempClasses = mergeClasses(options.tempClasses, className);
                    return $$animateQueue.push(element, 'animate', options);
                }
            };
        }];
    }];

    var $$AnimateAsyncRunFactoryProvider = /** @this */ function() {
        this.$get = ['$$rAF', function($$rAF) {
            var waitQueue = [];

            function waitForTick(fn) {
                waitQueue.push(fn);
                if (waitQueue.length > 1) return;
                $$rAF(function() {
                    for (var i = 0; i < waitQueue.length; i++) {
                        waitQueue[i]();
                    }
                    waitQueue = [];
                });
            }

            return function() {
                var passed = false;
                waitForTick(function() {
                    passed = true;
                });
                return function(callback) {
                    if (passed) {
                        callback();
                    } else {
                        waitForTick(callback);
                    }
                };
            };
        }];
    };

    var $$AnimateRunnerFactoryProvider = /** @this */ function() {
        this.$get = ['$q', '$sniffer', '$$animateAsyncRun', '$document', '$timeout',
            function($q,   $sniffer,   $$animateAsyncRun,   $document,   $timeout) {

                var INITIAL_STATE = 0;
                var DONE_PENDING_STATE = 1;
                var DONE_COMPLETE_STATE = 2;

                AnimateRunner.chain = function(chain, callback) {
                    var index = 0;

                    next();
                    function next() {
                        if (index === chain.length) {
                            callback(true);
                            return;
                        }

                        chain[index](function(response) {
                            if (response === false) {
                                callback(false);
                                return;
                            }
                            index++;
                            next();
                        });
                    }
                };

                AnimateRunner.all = function(runners, callback) {
                    var count = 0;
                    var status = true;
                    forEach(runners, function(runner) {
                        runner.done(onProgress);
                    });

                    function onProgress(response) {
                        status = status && response;
                        if (++count === runners.length) {
                            callback(status);
                        }
                    }
                };

                function AnimateRunner(host) {
                    this.setHost(host);

                    var rafTick = $$animateAsyncRun();
                    var timeoutTick = function(fn) {
                        $timeout(fn, 0, false);
                    };

                    this._doneCallbacks = [];
                    this._tick = function(fn) {
                        var doc = $document[0];

                        // the document may not be ready or attached
                        // to the module for some internal tests
                        if (doc && doc.hidden) {
                            timeoutTick(fn);
                        } else {
                            rafTick(fn);
                        }
                    };
                    this._state = 0;
                }

                AnimateRunner.prototype = {
                    setHost: function(host) {
                        this.host = host || {};
                    },

                    done: function(fn) {
                        if (this._state === DONE_COMPLETE_STATE) {
                            fn();
                        } else {
                            this._doneCallbacks.push(fn);
                        }
                    },

                    progress: noop,

                    getPromise: function() {
                        if (!this.promise) {
                            var self = this;
                            this.promise = $q(function(resolve, reject) {
                                self.done(function(status) {
                                    if (status === false) {
                                        reject();
                                    } else {
                                        resolve();
                                    }
                                });
                            });
                        }
                        return this.promise;
                    },

                    then: function(resolveHandler, rejectHandler) {
                        return this.getPromise().then(resolveHandler, rejectHandler);
                    },

                    'catch': function(handler) {
                        return this.getPromise()['catch'](handler);
                    },

                    'finally': function(handler) {
                        return this.getPromise()['finally'](handler);
                    },

                    pause: function() {
                        if (this.host.pause) {
                            this.host.pause();
                        }
                    },

                    resume: function() {
                        if (this.host.resume) {
                            this.host.resume();
                        }
                    },

                    end: function() {
                        if (this.host.end) {
                            this.host.end();
                        }
                        this._resolve(true);
                    },

                    cancel: function() {
                        if (this.host.cancel) {
                            this.host.cancel();
                        }
                        this._resolve(false);
                    },

                    complete: function(response) {
                        var self = this;
                        if (self._state === INITIAL_STATE) {
                            self._state = DONE_PENDING_STATE;
                            self._tick(function() {
                                self._resolve(response);
                            });
                        }
                    },

                    _resolve: function(response) {
                        if (this._state !== DONE_COMPLETE_STATE) {
                            forEach(this._doneCallbacks, function(fn) {
                                fn(response);
                            });
                            this._doneCallbacks.length = 0;
                            this._state = DONE_COMPLETE_STATE;
                        }
                    }
                };

                return AnimateRunner;
            }];
    };

    /* exported $CoreAnimateCssProvider */

    /**
     * @ngdoc service
     * @name $animateCss
     * @kind object
     * @this
     *
     * @description
     * This is the core version of `$animateCss`. By default, only when the `ngAnimate` is included,
     * then the `$animateCss` service will actually perform animations.
     *
     * Click here {@link ngAnimate.$animateCss to read the documentation for $animateCss}.
     */
    var $CoreAnimateCssProvider = function() {
        this.$get = ['$$rAF', '$q', '$$AnimateRunner', function($$rAF, $q, $$AnimateRunner) {

            return function(element, initialOptions) {
                // all of the animation functions should create
                // a copy of the options data, however, if a
                // parent service has already created a copy then
                // we should stick to using that
                var options = initialOptions || {};
                if (!options.$$prepared) {
                    options = copy(options);
                }

                // there is no point in applying the styles since
                // there is no animation that goes on at all in
                // this version of $animateCss.
                if (options.cleanupStyles) {
                    options.from = options.to = null;
                }

                if (options.from) {
                    element.css(options.from);
                    options.from = null;
                }

                var closed, runner = new $$AnimateRunner();
                return {
                    start: run,
                    end: run
                };

                function run() {
                    $$rAF(function() {
                        applyAnimationContents();
                        if (!closed) {
                            runner.complete();
                        }
                        closed = true;
                    });
                    return runner;
                }

                function applyAnimationContents() {
                    if (options.addClass) {
                        element.addClass(options.addClass);
                        options.addClass = null;
                    }
                    if (options.removeClass) {
                        element.removeClass(options.removeClass);
                        options.removeClass = null;
                    }
                    if (options.to) {
                        element.css(options.to);
                        options.to = null;
                    }
                }
            };
        }];
    };

    /* global stripHash: true */

    /**
     * ! This is a private undocumented service !
     *
     * @name $browser
     * @requires $log
     * @description
     * This object has two goals:
     *
     * - hide all the global state in the browser caused by the window object
     * - abstract away all the browser specific features and inconsistencies
     *
     * For tests we provide {@link ngMock.$browser mock implementation} of the `$browser`
     * service, which can be used for convenient testing of the application without the interaction with
     * the real browser apis.
     */
    /**
     * @param {object} window The global window object.
     * @param {object} document jQuery wrapped document.
     * @param {object} $log window.console or an object with the same interface.
     * @param {object} $sniffer $sniffer service
     */
    function Browser(window, document, $log, $sniffer) {
        var self = this,
            location = window.location,
            history = window.history,
            setTimeout = window.setTimeout,
            clearTimeout = window.clearTimeout,
            pendingDeferIds = {};

        self.isMock = false;

        var outstandingRequestCount = 0;
        var outstandingRequestCallbacks = [];

        // TODO(vojta): remove this temporary api
        self.$$completeOutstandingRequest = completeOutstandingRequest;
        self.$$incOutstandingRequestCount = function() { outstandingRequestCount++; };

        /**
         * Executes the `fn` function(supports currying) and decrements the `outstandingRequestCallbacks`
         * counter. If the counter reaches 0, all the `outstandingRequestCallbacks` are executed.
         */
        function completeOutstandingRequest(fn) {
            try {
                fn.apply(null, sliceArgs(arguments, 1));
            } finally {
                outstandingRequestCount--;
                if (outstandingRequestCount === 0) {
                    while (outstandingRequestCallbacks.length) {
                        try {
                            outstandingRequestCallbacks.pop()();
                        } catch (e) {
                            $log.error(e);
                        }
                    }
                }
            }
        }

        function getHash(url) {
            var index = url.indexOf('#');
            return index === -1 ? '' : url.substr(index);
        }

        /**
         * @private
         * Note: this method is used only by scenario runner
         * TODO(vojta): prefix this method with $$ ?
         * @param {function()} callback Function that will be called when no outstanding request
         */
        self.notifyWhenNoOutstandingRequests = function(callback) {
            if (outstandingRequestCount === 0) {
                callback();
            } else {
                outstandingRequestCallbacks.push(callback);
            }
        };

        //////////////////////////////////////////////////////////////
        // URL API
        //////////////////////////////////////////////////////////////

        var cachedState, lastHistoryState,
            lastBrowserUrl = location.href,
            baseElement = document.find('base'),
            pendingLocation = null,
            getCurrentState = !$sniffer.history ? noop : function getCurrentState() {
                try {
                    return history.state;
                } catch (e) {
                    // MSIE can reportedly throw when there is no state (UNCONFIRMED).
                }
            };

        cacheState();
        lastHistoryState = cachedState;

        /**
         * @name $browser#url
         *
         * @description
         * GETTER:
         * Without any argument, this method just returns current value of location.href.
         *
         * SETTER:
         * With at least one argument, this method sets url to new value.
         * If html5 history api supported, pushState/replaceState is used, otherwise
         * location.href/location.replace is used.
         * Returns its own instance to allow chaining
         *
         * NOTE: this api is intended for use only by the $location service. Please use the
         * {@link ng.$location $location service} to change url.
         *
         * @param {string} url New url (when used as setter)
         * @param {boolean=} replace Should new url replace current history record?
         * @param {object=} state object to use with pushState/replaceState
         */
        self.url = function(url, replace, state) {
            // In modern browsers `history.state` is `null` by default; treating it separately
            // from `undefined` would cause `$browser.url('/foo')` to change `history.state`
            // to undefined via `pushState`. Instead, let's change `undefined` to `null` here.
            if (isUndefined(state)) {
                state = null;
            }

            // Android Browser BFCache causes location, history reference to become stale.
            if (location !== window.location) location = window.location;
            if (history !== window.history) history = window.history;

            // setter
            if (url) {
                var sameState = lastHistoryState === state;

                // Don't change anything if previous and current URLs and states match. This also prevents
                // IE<10 from getting into redirect loop when in LocationHashbangInHtml5Url mode.
                // See https://github.com/angular/angular.js/commit/ffb2701
                if (lastBrowserUrl === url && (!$sniffer.history || sameState)) {
                    return self;
                }
                var sameBase = lastBrowserUrl && stripHash(lastBrowserUrl) === stripHash(url);
                lastBrowserUrl = url;
                lastHistoryState = state;
                // Don't use history API if only the hash changed
                // due to a bug in IE10/IE11 which leads
                // to not firing a `hashchange` nor `popstate` event
                // in some cases (see #9143).
                if ($sniffer.history && (!sameBase || !sameState)) {
                    history[replace ? 'replaceState' : 'pushState'](state, '', url);
                    cacheState();
                    // Do the assignment again so that those two variables are referentially identical.
                    lastHistoryState = cachedState;
                } else {
                    if (!sameBase) {
                        pendingLocation = url;
                    }
                    if (replace) {
                        location.replace(url);
                    } else if (!sameBase) {
                        location.href = url;
                    } else {
                        location.hash = getHash(url);
                    }
                    if (location.href !== url) {
                        pendingLocation = url;
                    }
                }
                if (pendingLocation) {
                    pendingLocation = url;
                }
                return self;
                // getter
            } else {
                // - pendingLocation is needed as browsers don't allow to read out
                //   the new location.href if a reload happened or if there is a bug like in iOS 9 (see
                //   https://openradar.appspot.com/22186109).
                // - the replacement is a workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=407172
                return pendingLocation || location.href.replace(/%27/g,'\'');
            }
        };

        /**
         * @name $browser#state
         *
         * @description
         * This method is a getter.
         *
         * Return history.state or null if history.state is undefined.
         *
         * @returns {object} state
         */
        self.state = function() {
            return cachedState;
        };

        var urlChangeListeners = [],
            urlChangeInit = false;

        function cacheStateAndFireUrlChange() {
            pendingLocation = null;
            cacheState();
            fireUrlChange();
        }

        // This variable should be used *only* inside the cacheState function.
        var lastCachedState = null;
        function cacheState() {
            // This should be the only place in $browser where `history.state` is read.
            cachedState = getCurrentState();
            cachedState = isUndefined(cachedState) ? null : cachedState;

            // Prevent callbacks fo fire twice if both hashchange & popstate were fired.
            if (equals(cachedState, lastCachedState)) {
                cachedState = lastCachedState;
            }
            lastCachedState = cachedState;
        }

        function fireUrlChange() {
            if (lastBrowserUrl === self.url() && lastHistoryState === cachedState) {
                return;
            }

            lastBrowserUrl = self.url();
            lastHistoryState = cachedState;
            forEach(urlChangeListeners, function(listener) {
                listener(self.url(), cachedState);
            });
        }

        /**
         * @name $browser#onUrlChange
         *
         * @description
         * Register callback function that will be called, when url changes.
         *
         * It's only called when the url is changed from outside of angular:
         * - user types different url into address bar
         * - user clicks on history (forward/back) button
         * - user clicks on a link
         *
         * It's not called when url is changed by $browser.url() method
         *
         * The listener gets called with new url as parameter.
         *
         * NOTE: this api is intended for use only by the $location service. Please use the
         * {@link ng.$location $location service} to monitor url changes in angular apps.
         *
         * @param {function(string)} listener Listener function to be called when url changes.
         * @return {function(string)} Returns the registered listener fn - handy if the fn is anonymous.
         */
        self.onUrlChange = function(callback) {
            // TODO(vojta): refactor to use node's syntax for events
            if (!urlChangeInit) {
                // We listen on both (hashchange/popstate) when available, as some browsers (e.g. Opera)
                // don't fire popstate when user change the address bar and don't fire hashchange when url
                // changed by push/replaceState

                // html5 history api - popstate event
                if ($sniffer.history) jqLite(window).on('popstate', cacheStateAndFireUrlChange);
                // hashchange event
                jqLite(window).on('hashchange', cacheStateAndFireUrlChange);

                urlChangeInit = true;
            }

            urlChangeListeners.push(callback);
            return callback;
        };

        /**
         * @private
         * Remove popstate and hashchange handler from window.
         *
         * NOTE: this api is intended for use only by $rootScope.
         */
        self.$$applicationDestroyed = function() {
            jqLite(window).off('hashchange popstate', cacheStateAndFireUrlChange);
        };

        /**
         * Checks whether the url has changed outside of Angular.
         * Needs to be exported to be able to check for changes that have been done in sync,
         * as hashchange/popstate events fire in async.
         */
        self.$$checkUrlChange = fireUrlChange;

        //////////////////////////////////////////////////////////////
        // Misc API
        //////////////////////////////////////////////////////////////

        /**
         * @name $browser#baseHref
         *
         * @description
         * Returns current <base href>
         * (always relative - without domain)
         *
         * @returns {string} The current base href
         */
        self.baseHref = function() {
            var href = baseElement.attr('href');
            return href ? href.replace(/^(https?:)?\/\/[^\/]*/, '') : '';
        };

        /**
         * @name $browser#defer
         * @param {function()} fn A function, who's execution should be deferred.
         * @param {number=} [delay=0] of milliseconds to defer the function execution.
         * @returns {*} DeferId that can be used to cancel the task via `$browser.defer.cancel()`.
         *
         * @description
         * Executes a fn asynchronously via `setTimeout(fn, delay)`.
         *
         * Unlike when calling `setTimeout` directly, in test this function is mocked and instead of using
         * `setTimeout` in tests, the fns are queued in an array, which can be programmatically flushed
         * via `$browser.defer.flush()`.
         *
         */
        self.defer = function(fn, delay) {
            var timeoutId;
            outstandingRequestCount++;
            timeoutId = setTimeout(function() {
                delete pendingDeferIds[timeoutId];
                completeOutstandingRequest(fn);
            }, delay || 0);
            pendingDeferIds[timeoutId] = true;
            return timeoutId;
        };


        /**
         * @name $browser#defer.cancel
         *
         * @description
         * Cancels a deferred task identified with `deferId`.
         *
         * @param {*} deferId Token returned by the `$browser.defer` function.
         * @returns {boolean} Returns `true` if the task hasn't executed yet and was successfully
         *                    canceled.
         */
        self.defer.cancel = function(deferId) {
            if (pendingDeferIds[deferId]) {
                delete pendingDeferIds[deferId];
                clearTimeout(deferId);
                completeOutstandingRequest(noop);
                return true;
            }
            return false;
        };

    }

    /** @this */
    function $BrowserProvider() {
        this.$get = ['$window', '$log', '$sniffer', '$document',
            function($window, $log, $sniffer, $document) {
                return new Browser($window, $document, $log, $sniffer);
            }];
    }

    /**
     * @ngdoc service
     * @name $cacheFactory
     * @this
     *
     * @description
     * Factory that constructs {@link $cacheFactory.Cache Cache} objects and gives access to
     * them.
     *
     * ```js
     *
     *  var cache = $cacheFactory('cacheId');
     *  expect($cacheFactory.get('cacheId')).toBe(cache);
     *  expect($cacheFactory.get('noSuchCacheId')).not.toBeDefined();
     *
     *  cache.put("key", "value");
     *  cache.put("another key", "another value");
     *
     *  // We've specified no options on creation
     *  expect(cache.info()).toEqual({id: 'cacheId', size: 2});
     *
     * ```
     *
     *
     * @param {string} cacheId Name or id of the newly created cache.
     * @param {object=} options Options object that specifies the cache behavior. Properties:
     *
     *   - `{number=}` `capacity` — turns the cache into LRU cache.
     *
     * @returns {object} Newly created cache object with the following set of methods:
     *
     * - `{object}` `info()` — Returns id, size, and options of cache.
     * - `{{*}}` `put({string} key, {*} value)` — Puts a new key-value pair into the cache and returns
     *   it.
     * - `{{*}}` `get({string} key)` — Returns cached value for `key` or undefined for cache miss.
     * - `{void}` `remove({string} key)` — Removes a key-value pair from the cache.
     * - `{void}` `removeAll()` — Removes all cached values.
     * - `{void}` `destroy()` — Removes references to this cache from $cacheFactory.
     *
     * @example
     <example module="cacheExampleApp" name="cache-factory">
     <file name="index.html">
     <div ng-controller="CacheController">
     <input ng-model="newCacheKey" placeholder="Key">
     <input ng-model="newCacheValue" placeholder="Value">
     <button ng-click="put(newCacheKey, newCacheValue)">Cache</button>

     <p ng-if="keys.length">Cached Values</p>
     <div ng-repeat="key in keys">
     <span ng-bind="key"></span>
     <span>: </span>
     <b ng-bind="cache.get(key)"></b>
     </div>

     <p>Cache Info</p>
     <div ng-repeat="(key, value) in cache.info()">
     <span ng-bind="key"></span>
     <span>: </span>
     <b ng-bind="value"></b>
     </div>
     </div>
     </file>
     <file name="script.js">
     angular.module('cacheExampleApp', []).
     controller('CacheController', ['$scope', '$cacheFactory', function($scope, $cacheFactory) {
           $scope.keys = [];
           $scope.cache = $cacheFactory('cacheId');
           $scope.put = function(key, value) {
             if (angular.isUndefined($scope.cache.get(key))) {
               $scope.keys.push(key);
             }
             $scope.cache.put(key, angular.isUndefined(value) ? null : value);
           };
         }]);
     </file>
     <file name="style.css">
     p {
         margin: 10px 0 3px;
       }
     </file>
     </example>
     */
    function $CacheFactoryProvider() {

        this.$get = function() {
            var caches = {};

            function cacheFactory(cacheId, options) {
                if (cacheId in caches) {
                    throw minErr('$cacheFactory')('iid', 'CacheId \'{0}\' is already taken!', cacheId);
                }

                var size = 0,
                    stats = extend({}, options, {id: cacheId}),
                    data = createMap(),
                    capacity = (options && options.capacity) || Number.MAX_VALUE,
                    lruHash = createMap(),
                    freshEnd = null,
                    staleEnd = null;

                /**
                 * @ngdoc type
                 * @name $cacheFactory.Cache
                 *
                 * @description
                 * A cache object used to store and retrieve data, primarily used by
                 * {@link $http $http} and the {@link ng.directive:script script} directive to cache
                 * templates and other data.
                 *
                 * ```js
                 *  angular.module('superCache')
                 *    .factory('superCache', ['$cacheFactory', function($cacheFactory) {
       *      return $cacheFactory('super-cache');
       *    }]);
                 * ```
                 *
                 * Example test:
                 *
                 * ```js
                 *  it('should behave like a cache', inject(function(superCache) {
       *    superCache.put('key', 'value');
       *    superCache.put('another key', 'another value');
       *
       *    expect(superCache.info()).toEqual({
       *      id: 'super-cache',
       *      size: 2
       *    });
       *
       *    superCache.remove('another key');
       *    expect(superCache.get('another key')).toBeUndefined();
       *
       *    superCache.removeAll();
       *    expect(superCache.info()).toEqual({
       *      id: 'super-cache',
       *      size: 0
       *    });
       *  }));
                 * ```
                 */
                return (caches[cacheId] = {

                    /**
                     * @ngdoc method
                     * @name $cacheFactory.Cache#put
                     * @kind function
                     *
                     * @description
                     * Inserts a named entry into the {@link $cacheFactory.Cache Cache} object to be
                     * retrieved later, and incrementing the size of the cache if the key was not already
                     * present in the cache. If behaving like an LRU cache, it will also remove stale
                     * entries from the set.
                     *
                     * It will not insert undefined values into the cache.
                     *
                     * @param {string} key the key under which the cached data is stored.
                     * @param {*} value the value to store alongside the key. If it is undefined, the key
                     *    will not be stored.
                     * @returns {*} the value stored.
                     */
                    put: function(key, value) {
                        if (isUndefined(value)) return;
                        if (capacity < Number.MAX_VALUE) {
                            var lruEntry = lruHash[key] || (lruHash[key] = {key: key});

                            refresh(lruEntry);
                        }

                        if (!(key in data)) size++;
                        data[key] = value;

                        if (size > capacity) {
                            this.remove(staleEnd.key);
                        }

                        return value;
                    },

                    /**
                     * @ngdoc method
                     * @name $cacheFactory.Cache#get
                     * @kind function
                     *
                     * @description
                     * Retrieves named data stored in the {@link $cacheFactory.Cache Cache} object.
                     *
                     * @param {string} key the key of the data to be retrieved
                     * @returns {*} the value stored.
                     */
                    get: function(key) {
                        if (capacity < Number.MAX_VALUE) {
                            var lruEntry = lruHash[key];

                            if (!lruEntry) return;

                            refresh(lruEntry);
                        }

                        return data[key];
                    },


                    /**
                     * @ngdoc method
                     * @name $cacheFactory.Cache#remove
                     * @kind function
                     *
                     * @description
                     * Removes an entry from the {@link $cacheFactory.Cache Cache} object.
                     *
                     * @param {string} key the key of the entry to be removed
                     */
                    remove: function(key) {
                        if (capacity < Number.MAX_VALUE) {
                            var lruEntry = lruHash[key];

                            if (!lruEntry) return;

                            if (lruEntry === freshEnd) freshEnd = lruEntry.p;
                            if (lruEntry === staleEnd) staleEnd = lruEntry.n;
                            link(lruEntry.n,lruEntry.p);

                            delete lruHash[key];
                        }

                        if (!(key in data)) return;

                        delete data[key];
                        size--;
                    },


                    /**
                     * @ngdoc method
                     * @name $cacheFactory.Cache#removeAll
                     * @kind function
                     *
                     * @description
                     * Clears the cache object of any entries.
                     */
                    removeAll: function() {
                        data = createMap();
                        size = 0;
                        lruHash = createMap();
                        freshEnd = staleEnd = null;
                    },


                    /**
                     * @ngdoc method
                     * @name $cacheFactory.Cache#destroy
                     * @kind function
                     *
                     * @description
                     * Destroys the {@link $cacheFactory.Cache Cache} object entirely,
                     * removing it from the {@link $cacheFactory $cacheFactory} set.
                     */
                    destroy: function() {
                        data = null;
                        stats = null;
                        lruHash = null;
                        delete caches[cacheId];
                    },


                    /**
                     * @ngdoc method
                     * @name $cacheFactory.Cache#info
                     * @kind function
                     *
                     * @description
                     * Retrieve information regarding a particular {@link $cacheFactory.Cache Cache}.
                     *
                     * @returns {object} an object with the following properties:
                     *   <ul>
                     *     <li>**id**: the id of the cache instance</li>
                     *     <li>**size**: the number of entries kept in the cache instance</li>
                     *     <li>**...**: any additional properties from the options object when creating the
                     *       cache.</li>
                     *   </ul>
                     */
                    info: function() {
                        return extend({}, stats, {size: size});
                    }
                });


                /**
                 * makes the `entry` the freshEnd of the LRU linked list
                 */
                function refresh(entry) {
                    if (entry !== freshEnd) {
                        if (!staleEnd) {
                            staleEnd = entry;
                        } else if (staleEnd === entry) {
                            staleEnd = entry.n;
                        }

                        link(entry.n, entry.p);
                        link(entry, freshEnd);
                        freshEnd = entry;
                        freshEnd.n = null;
                    }
                }


                /**
                 * bidirectionally links two entries of the LRU linked list
                 */
                function link(nextEntry, prevEntry) {
                    if (nextEntry !== prevEntry) {
                        if (nextEntry) nextEntry.p = prevEntry; //p stands for previous, 'prev' didn't minify
                        if (prevEntry) prevEntry.n = nextEntry; //n stands for next, 'next' didn't minify
                    }
                }
            }


            /**
             * @ngdoc method
             * @name $cacheFactory#info
             *
             * @description
             * Get information about all the caches that have been created
             *
             * @returns {Object} - key-value map of `cacheId` to the result of calling `cache#info`
             */
            cacheFactory.info = function() {
                var info = {};
                forEach(caches, function(cache, cacheId) {
                    info[cacheId] = cache.info();
                });
                return info;
            };


            /**
             * @ngdoc method
             * @name $cacheFactory#get
             *
             * @description
             * Get access to a cache object by the `cacheId` used when it was created.
             *
             * @param {string} cacheId Name or id of a cache to access.
             * @returns {object} Cache object identified by the cacheId or undefined if no such cache.
             */
            cacheFactory.get = function(cacheId) {
                return caches[cacheId];
            };


            return cacheFactory;
        };
    }

    /**
     * @ngdoc service
     * @name $templateCache
     * @this
     *
     * @description
     * The first time a template is used, it is loaded in the template cache for quick retrieval. You
     * can load templates directly into the cache in a `script` tag, or by consuming the
     * `$templateCache` service directly.
     *
     * Adding via the `script` tag:
     *
     * ```html
     *   <script type="text/ng-template" id="templateId.html">
     *     <p>This is the content of the template</p>
     *   </script>
     * ```
     *
     * **Note:** the `script` tag containing the template does not need to be included in the `head` of
     * the document, but it must be a descendent of the {@link ng.$rootElement $rootElement} (IE,
     * element with ng-app attribute), otherwise the template will be ignored.
     *
     * Adding via the `$templateCache` service:
     *
     * ```js
     * var myApp = angular.module('myApp', []);
     * myApp.run(function($templateCache) {
 *   $templateCache.put('templateId.html', 'This is the content of the template');
 * });
     * ```
     *
     * To retrieve the template later, simply use it in your HTML:
     * ```html
     * <div ng-include=" 'templateId.html' "></div>
     * ```
     *
     * or get it via Javascript:
     * ```js
     * $templateCache.get('templateId.html')
     * ```
     *
     * See {@link ng.$cacheFactory $cacheFactory}.
     *
     */
    function $TemplateCacheProvider() {
        this.$get = ['$cacheFactory', function($cacheFactory) {
            return $cacheFactory('templates');
        }];
    }

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     *     Any commits to this file should be reviewed with security in mind.  *
     *   Changes to this file can potentially create security vulnerabilities. *
     *          An approval from 2 Core members with history of modifying      *
     *                         this file is required.                          *
     *                                                                         *
     *  Does the change somehow allow for arbitrary javascript to be executed? *
     *    Or allows for someone to change the prototype of built-in objects?   *
     *     Or gives undesired access to variables likes document or window?    *
     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

    /* ! VARIABLE/FUNCTION NAMING CONVENTIONS THAT APPLY TO THIS FILE!
     *
     * DOM-related variables:
     *
     * - "node" - DOM Node
     * - "element" - DOM Element or Node
     * - "$node" or "$element" - jqLite-wrapped node or element
     *
     *
     * Compiler related stuff:
     *
     * - "linkFn" - linking fn of a single directive
     * - "nodeLinkFn" - function that aggregates all linking fns for a particular node
     * - "childLinkFn" -  function that aggregates all linking fns for child nodes of a particular node
     * - "compositeLinkFn" - function that aggregates all linking fns for a compilation root (nodeList)
     */


    /**
     * @ngdoc service
     * @name $compile
     * @kind function
     *
     * @description
     * Compiles an HTML string or DOM into a template and produces a template function, which
     * can then be used to link {@link ng.$rootScope.Scope `scope`} and the template together.
     *
     * The compilation is a process of walking the DOM tree and matching DOM elements to
     * {@link ng.$compileProvider#directive directives}.
     *
     * <div class="alert alert-warning">
     * **Note:** This document is an in-depth reference of all directive options.
     * For a gentle introduction to directives with examples of common use cases,
     * see the {@link guide/directive directive guide}.
     * </div>
     *
     * ## Comprehensive Directive API
     *
     * There are many different options for a directive.
     *
     * The difference resides in the return value of the factory function.
     * You can either return a {@link $compile#directive-definition-object Directive Definition Object (see below)}
     * that defines the directive properties, or just the `postLink` function (all other properties will have
     * the default values).
     *
     * <div class="alert alert-success">
     * **Best Practice:** It's recommended to use the "directive definition object" form.
     * </div>
     *
     * Here's an example directive declared with a Directive Definition Object:
     *
     * ```js
     *   var myModule = angular.module(...);
     *
     *   myModule.directive('directiveName', function factory(injectables) {
 *     var directiveDefinitionObject = {
 *       priority: 0,
 *       template: '<div></div>', // or // function(tElement, tAttrs) { ... },
 *       // or
 *       // templateUrl: 'directive.html', // or // function(tElement, tAttrs) { ... },
 *       transclude: false,
 *       restrict: 'A',
 *       templateNamespace: 'html',
 *       scope: false,
 *       controller: function($scope, $element, $attrs, $transclude, otherInjectables) { ... },
 *       controllerAs: 'stringIdentifier',
 *       bindToController: false,
 *       require: 'siblingDirectiveName', // or // ['^parentDirectiveName', '?optionalDirectiveName', '?^optionalParent'],
 *       compile: function compile(tElement, tAttrs, transclude) {
 *         return {
 *           pre: function preLink(scope, iElement, iAttrs, controller) { ... },
 *           post: function postLink(scope, iElement, iAttrs, controller) { ... }
 *         }
 *         // or
 *         // return function postLink( ... ) { ... }
 *       },
 *       // or
 *       // link: {
 *       //  pre: function preLink(scope, iElement, iAttrs, controller) { ... },
 *       //  post: function postLink(scope, iElement, iAttrs, controller) { ... }
 *       // }
 *       // or
 *       // link: function postLink( ... ) { ... }
 *     };
 *     return directiveDefinitionObject;
 *   });
     * ```
     *
     * <div class="alert alert-warning">
     * **Note:** Any unspecified options will use the default value. You can see the default values below.
     * </div>
     *
     * Therefore the above can be simplified as:
     *
     * ```js
     *   var myModule = angular.module(...);
     *
     *   myModule.directive('directiveName', function factory(injectables) {
 *     var directiveDefinitionObject = {
 *       link: function postLink(scope, iElement, iAttrs) { ... }
 *     };
 *     return directiveDefinitionObject;
 *     // or
 *     // return function postLink(scope, iElement, iAttrs) { ... }
 *   });
     * ```
     *
     * ### Life-cycle hooks
     * Directive controllers can provide the following methods that are called by Angular at points in the life-cycle of the
     * directive:
     * * `$onInit()` - Called on each controller after all the controllers on an element have been constructed and
     *   had their bindings initialized (and before the pre &amp; post linking functions for the directives on
     *   this element). This is a good place to put initialization code for your controller.
     * * `$onChanges(changesObj)` - Called whenever one-way (`<`) or interpolation (`@`) bindings are updated. The
     *   `changesObj` is a hash whose keys are the names of the bound properties that have changed, and the values are an
     *   object of the form `{ currentValue, previousValue, isFirstChange() }`. Use this hook to trigger updates within a
     *   component such as cloning the bound value to prevent accidental mutation of the outer value.
     * * `$doCheck()` - Called on each turn of the digest cycle. Provides an opportunity to detect and act on
     *   changes. Any actions that you wish to take in response to the changes that you detect must be
     *   invoked from this hook; implementing this has no effect on when `$onChanges` is called. For example, this hook
     *   could be useful if you wish to perform a deep equality check, or to check a Date object, changes to which would not
     *   be detected by Angular's change detector and thus not trigger `$onChanges`. This hook is invoked with no arguments;
     *   if detecting changes, you must store the previous value(s) for comparison to the current values.
     * * `$onDestroy()` - Called on a controller when its containing scope is destroyed. Use this hook for releasing
     *   external resources, watches and event handlers. Note that components have their `$onDestroy()` hooks called in
     *   the same order as the `$scope.$broadcast` events are triggered, which is top down. This means that parent
     *   components will have their `$onDestroy()` hook called before child components.
     * * `$postLink()` - Called after this controller's element and its children have been linked. Similar to the post-link
     *   function this hook can be used to set up DOM event handlers and do direct DOM manipulation.
     *   Note that child elements that contain `templateUrl` directives will not have been compiled and linked since
     *   they are waiting for their template to load asynchronously and their own compilation and linking has been
     *   suspended until that occurs.
     *
     * #### Comparison with Angular 2 life-cycle hooks
     * Angular 2 also uses life-cycle hooks for its components. While the Angular 1 life-cycle hooks are similar there are
     * some differences that you should be aware of, especially when it comes to moving your code from Angular 1 to Angular 2:
     *
     * * Angular 1 hooks are prefixed with `$`, such as `$onInit`. Angular 2 hooks are prefixed with `ng`, such as `ngOnInit`.
     * * Angular 1 hooks can be defined on the controller prototype or added to the controller inside its constructor.
     *   In Angular 2 you can only define hooks on the prototype of the Component class.
     * * Due to the differences in change-detection, you may get many more calls to `$doCheck` in Angular 1 than you would to
     *   `ngDoCheck` in Angular 2
     * * Changes to the model inside `$doCheck` will trigger new turns of the digest loop, which will cause the changes to be
     *   propagated throughout the application.
     *   Angular 2 does not allow the `ngDoCheck` hook to trigger a change outside of the component. It will either throw an
     *   error or do nothing depending upon the state of `enableProdMode()`.
     *
     * #### Life-cycle hook examples
     *
     * This example shows how you can check for mutations to a Date object even though the identity of the object
     * has not changed.
     *
     * <example name="doCheckDateExample" module="do-check-module">
     *   <file name="app.js">
     *     angular.module('do-check-module', [])
     *       .component('app', {
 *         template:
 *           'Month: <input ng-model="$ctrl.month" ng-change="$ctrl.updateDate()">' +
 *           'Date: {{ $ctrl.date }}' +
 *           '<test date="$ctrl.date"></test>',
 *         controller: function() {
 *           this.date = new Date();
 *           this.month = this.date.getMonth();
 *           this.updateDate = function() {
 *             this.date.setMonth(this.month);
 *           };
 *         }
 *       })
     *       .component('test', {
 *         bindings: { date: '<' },
 *         template:
 *           '<pre>{{ $ctrl.log | json }}</pre>',
 *         controller: function() {
 *           var previousValue;
 *           this.log = [];
 *           this.$doCheck = function() {
 *             var currentValue = this.date && this.date.valueOf();
 *             if (previousValue !== currentValue) {
 *               this.log.push('doCheck: date mutated: ' + this.date);
 *               previousValue = currentValue;
 *             }
 *           };
 *         }
 *       });
     *   </file>
     *   <file name="index.html">
     *     <app></app>
     *   </file>
     * </example>
     *
     * This example show how you might use `$doCheck` to trigger changes in your component's inputs even if the
     * actual identity of the component doesn't change. (Be aware that cloning and deep equality checks on large
     * arrays or objects can have a negative impact on your application performance)
     *
     * <example name="doCheckArrayExample" module="do-check-module">
     *   <file name="index.html">
     *     <div ng-init="items = []">
     *       <button ng-click="items.push(items.length)">Add Item</button>
     *       <button ng-click="items = []">Reset Items</button>
     *       <pre>{{ items }}</pre>
     *       <test items="items"></test>
     *     </div>
     *   </file>
     *   <file name="app.js">
     *      angular.module('do-check-module', [])
     *        .component('test', {
 *          bindings: { items: '<' },
 *          template:
 *            '<pre>{{ $ctrl.log | json }}</pre>',
 *          controller: function() {
 *            this.log = [];
 *
 *            this.$doCheck = function() {
 *              if (this.items_ref !== this.items) {
 *                this.log.push('doCheck: items changed');
 *                this.items_ref = this.items;
 *              }
 *              if (!angular.equals(this.items_clone, this.items)) {
 *                this.log.push('doCheck: items mutated');
 *                this.items_clone = angular.copy(this.items);
 *              }
 *            };
 *          }
 *        });
     *   </file>
     * </example>
     *
     *
     * ### Directive Definition Object
     *
     * The directive definition object provides instructions to the {@link ng.$compile
 * compiler}. The attributes are:
     *
     * #### `multiElement`
     * When this property is set to true, the HTML compiler will collect DOM nodes between
     * nodes with the attributes `directive-name-start` and `directive-name-end`, and group them
     * together as the directive elements. It is recommended that this feature be used on directives
     * which are not strictly behavioral (such as {@link ngClick}), and which
     * do not manipulate or replace child nodes (such as {@link ngInclude}).
     *
     * #### `priority`
     * When there are multiple directives defined on a single DOM element, sometimes it
     * is necessary to specify the order in which the directives are applied. The `priority` is used
     * to sort the directives before their `compile` functions get called. Priority is defined as a
     * number. Directives with greater numerical `priority` are compiled first. Pre-link functions
     * are also run in priority order, but post-link functions are run in reverse order. The order
     * of directives with the same priority is undefined. The default priority is `0`.
     *
     * #### `terminal`
     * If set to true then the current `priority` will be the last set of directives
     * which will execute (any directives at the current priority will still execute
     * as the order of execution on same `priority` is undefined). Note that expressions
     * and other directives used in the directive's template will also be excluded from execution.
     *
     * #### `scope`
     * The scope property can be `true`, an object or a falsy value:
     *
     * * **falsy:** No scope will be created for the directive. The directive will use its parent's scope.
     *
     * * **`true`:** A new child scope that prototypically inherits from its parent will be created for
     * the directive's element. If multiple directives on the same element request a new scope,
     * only one new scope is created. The new scope rule does not apply for the root of the template
     * since the root of the template always gets a new scope.
     *
     * * **`{...}` (an object hash):** A new "isolate" scope is created for the directive's element. The
     * 'isolate' scope differs from normal scope in that it does not prototypically inherit from its parent
     * scope. This is useful when creating reusable components, which should not accidentally read or modify
     * data in the parent scope.
     *
     * The 'isolate' scope object hash defines a set of local scope properties derived from attributes on the
     * directive's element. These local properties are useful for aliasing values for templates. The keys in
     * the object hash map to the name of the property on the isolate scope; the values define how the property
     * is bound to the parent scope, via matching attributes on the directive's element:
     *
     * * `@` or `@attr` - bind a local scope property to the value of DOM attribute. The result is
     *   always a string since DOM attributes are strings. If no `attr` name is specified then the
     *   attribute name is assumed to be the same as the local name. Given `<my-component
     *   my-attr="hello {{name}}">` and the isolate scope definition `scope: { localName:'@myAttr' }`,
     *   the directive's scope property `localName` will reflect the interpolated value of `hello
     *   {{name}}`. As the `name` attribute changes so will the `localName` property on the directive's
     *   scope. The `name` is read from the parent scope (not the directive's scope).
     *
     * * `=` or `=attr` - set up a bidirectional binding between a local scope property and an expression
     *   passed via the attribute `attr`. The expression is evaluated in the context of the parent scope.
     *   If no `attr` name is specified then the attribute name is assumed to be the same as the local
     *   name. Given `<my-component my-attr="parentModel">` and the isolate scope definition `scope: {
 *   localModel: '=myAttr' }`, the property `localModel` on the directive's scope will reflect the
     *   value of `parentModel` on the parent scope. Changes to `parentModel` will be reflected in
     *   `localModel` and vice versa. Optional attributes should be marked as such with a question mark:
     *   `=?` or `=?attr`. If the binding expression is non-assignable, or if the attribute isn't
     *   optional and doesn't exist, an exception ({@link error/$compile/nonassign `$compile:nonassign`})
     *   will be thrown upon discovering changes to the local value, since it will be impossible to sync
     *   them back to the parent scope. By default, the {@link ng.$rootScope.Scope#$watch `$watch`}
     *   method is used for tracking changes, and the equality check is based on object identity.
     *   However, if an object literal or an array literal is passed as the binding expression, the
     *   equality check is done by value (using the {@link angular.equals} function). It's also possible
     *   to watch the evaluated value shallowly with {@link ng.$rootScope.Scope#$watchCollection
 *   `$watchCollection`}: use `=*` or `=*attr` (`=*?` or `=*?attr` if the attribute is optional).
     *
     * * `<` or `<attr` - set up a one-way (one-directional) binding between a local scope property and an
     *   expression passed via the attribute `attr`. The expression is evaluated in the context of the
     *   parent scope. If no `attr` name is specified then the attribute name is assumed to be the same as the
     *   local name. You can also make the binding optional by adding `?`: `<?` or `<?attr`.
     *
     *   For example, given `<my-component my-attr="parentModel">` and directive definition of
     *   `scope: { localModel:'<myAttr' }`, then the isolated scope property `localModel` will reflect the
     *   value of `parentModel` on the parent scope. Any changes to `parentModel` will be reflected
     *   in `localModel`, but changes in `localModel` will not reflect in `parentModel`. There are however
     *   two caveats:
     *     1. one-way binding does not copy the value from the parent to the isolate scope, it simply
     *     sets the same value. That means if your bound value is an object, changes to its properties
     *     in the isolated scope will be reflected in the parent scope (because both reference the same object).
     *     2. one-way binding watches changes to the **identity** of the parent value. That means the
     *     {@link ng.$rootScope.Scope#$watch `$watch`} on the parent value only fires if the reference
     *     to the value has changed. In most cases, this should not be of concern, but can be important
     *     to know if you one-way bind to an object, and then replace that object in the isolated scope.
     *     If you now change a property of the object in your parent scope, the change will not be
     *     propagated to the isolated scope, because the identity of the object on the parent scope
     *     has not changed. Instead you must assign a new object.
     *
     *   One-way binding is useful if you do not plan to propagate changes to your isolated scope bindings
     *   back to the parent. However, it does not make this completely impossible.
     *
     * * `&` or `&attr` - provides a way to execute an expression in the context of the parent scope. If
     *   no `attr` name is specified then the attribute name is assumed to be the same as the local name.
     *   Given `<my-component my-attr="count = count + value">` and the isolate scope definition `scope: {
 *   localFn:'&myAttr' }`, the isolate scope property `localFn` will point to a function wrapper for
     *   the `count = count + value` expression. Often it's desirable to pass data from the isolated scope
     *   via an expression to the parent scope. This can be done by passing a map of local variable names
     *   and values into the expression wrapper fn. For example, if the expression is `increment(amount)`
     *   then we can specify the amount value by calling the `localFn` as `localFn({amount: 22})`.
     *
     * In general it's possible to apply more than one directive to one element, but there might be limitations
     * depending on the type of scope required by the directives. The following points will help explain these limitations.
     * For simplicity only two directives are taken into account, but it is also applicable for several directives:
     *
     * * **no scope** + **no scope** => Two directives which don't require their own scope will use their parent's scope
     * * **child scope** + **no scope** =>  Both directives will share one single child scope
     * * **child scope** + **child scope** =>  Both directives will share one single child scope
     * * **isolated scope** + **no scope** =>  The isolated directive will use it's own created isolated scope. The other directive will use
     * its parent's scope
     * * **isolated scope** + **child scope** =>  **Won't work!** Only one scope can be related to one element. Therefore these directives cannot
     * be applied to the same element.
     * * **isolated scope** + **isolated scope**  =>  **Won't work!** Only one scope can be related to one element. Therefore these directives
     * cannot be applied to the same element.
     *
     *
     * #### `bindToController`
     * This property is used to bind scope properties directly to the controller. It can be either
     * `true` or an object hash with the same format as the `scope` property. Additionally, a controller
     * alias must be set, either by using `controllerAs: 'myAlias'` or by specifying the alias in the controller
     * definition: `controller: 'myCtrl as myAlias'`.
     *
     * When an isolate scope is used for a directive (see above), `bindToController: true` will
     * allow a component to have its properties bound to the controller, rather than to scope.
     *
     * After the controller is instantiated, the initial values of the isolate scope bindings will be bound to the controller
     * properties. You can access these bindings once they have been initialized by providing a controller method called
     * `$onInit`, which is called after all the controllers on an element have been constructed and had their bindings
     * initialized.
     *
     * <div class="alert alert-warning">
     * **Deprecation warning:** although bindings for non-ES6 class controllers are currently
     * bound to `this` before the controller constructor is called, this use is now deprecated. Please place initialization
     * code that relies upon bindings inside a `$onInit` method on the controller, instead.
     * </div>
     *
     * It is also possible to set `bindToController` to an object hash with the same format as the `scope` property.
     * This will set up the scope bindings to the controller directly. Note that `scope` can still be used
     * to define which kind of scope is created. By default, no scope is created. Use `scope: {}` to create an isolate
     * scope (useful for component directives).
     *
     * If both `bindToController` and `scope` are defined and have object hashes, `bindToController` overrides `scope`.
     *
     *
     * #### `controller`
     * Controller constructor function. The controller is instantiated before the
     * pre-linking phase and can be accessed by other directives (see
     * `require` attribute). This allows the directives to communicate with each other and augment
     * each other's behavior. The controller is injectable (and supports bracket notation) with the following locals:
     *
     * * `$scope` - Current scope associated with the element
     * * `$element` - Current element
     * * `$attrs` - Current attributes object for the element
     * * `$transclude` - A transclude linking function pre-bound to the correct transclusion scope:
     *   `function([scope], cloneLinkingFn, futureParentElement, slotName)`:
     *    * `scope`: (optional) override the scope.
     *    * `cloneLinkingFn`: (optional) argument to create clones of the original transcluded content.
     *    * `futureParentElement` (optional):
     *        * defines the parent to which the `cloneLinkingFn` will add the cloned elements.
     *        * default: `$element.parent()` resp. `$element` for `transclude:'element'` resp. `transclude:true`.
     *        * only needed for transcludes that are allowed to contain non html elements (e.g. SVG elements)
     *          and when the `cloneLinkinFn` is passed,
     *          as those elements need to created and cloned in a special way when they are defined outside their
     *          usual containers (e.g. like `<svg>`).
     *        * See also the `directive.templateNamespace` property.
     *    * `slotName`: (optional) the name of the slot to transclude. If falsy (e.g. `null`, `undefined` or `''`)
     *      then the default translusion is provided.
     *    The `$transclude` function also has a method on it, `$transclude.isSlotFilled(slotName)`, which returns
     *    `true` if the specified slot contains content (i.e. one or more DOM nodes).
     *
     * #### `require`
     * Require another directive and inject its controller as the fourth argument to the linking function. The
     * `require` property can be a string, an array or an object:
     * * a **string** containing the name of the directive to pass to the linking function
     * * an **array** containing the names of directives to pass to the linking function. The argument passed to the
     * linking function will be an array of controllers in the same order as the names in the `require` property
     * * an **object** whose property values are the names of the directives to pass to the linking function. The argument
     * passed to the linking function will also be an object with matching keys, whose values will hold the corresponding
     * controllers.
     *
     * If the `require` property is an object and `bindToController` is truthy, then the required controllers are
     * bound to the controller using the keys of the `require` property. This binding occurs after all the controllers
     * have been constructed but before `$onInit` is called.
     * If the name of the required controller is the same as the local name (the key), the name can be
     * omitted. For example, `{parentDir: '^^'}` is equivalent to `{parentDir: '^^parentDir'}`.
     * See the {@link $compileProvider#component} helper for an example of how this can be used.
     * If no such required directive(s) can be found, or if the directive does not have a controller, then an error is
     * raised (unless no link function is specified and the required controllers are not being bound to the directive
     * controller, in which case error checking is skipped). The name can be prefixed with:
     *
     * * (no prefix) - Locate the required controller on the current element. Throw an error if not found.
     * * `?` - Attempt to locate the required controller or pass `null` to the `link` fn if not found.
     * * `^` - Locate the required controller by searching the element and its parents. Throw an error if not found.
     * * `^^` - Locate the required controller by searching the element's parents. Throw an error if not found.
     * * `?^` - Attempt to locate the required controller by searching the element and its parents or pass
     *   `null` to the `link` fn if not found.
     * * `?^^` - Attempt to locate the required controller by searching the element's parents, or pass
     *   `null` to the `link` fn if not found.
     *
     *
     * #### `controllerAs`
     * Identifier name for a reference to the controller in the directive's scope.
     * This allows the controller to be referenced from the directive template. This is especially
     * useful when a directive is used as component, i.e. with an `isolate` scope. It's also possible
     * to use it in a directive without an `isolate` / `new` scope, but you need to be aware that the
     * `controllerAs` reference might overwrite a property that already exists on the parent scope.
     *
     *
     * #### `restrict`
     * String of subset of `EACM` which restricts the directive to a specific directive
     * declaration style. If omitted, the defaults (elements and attributes) are used.
     *
     * * `E` - Element name (default): `<my-directive></my-directive>`
     * * `A` - Attribute (default): `<div my-directive="exp"></div>`
     * * `C` - Class: `<div class="my-directive: exp;"></div>`
     * * `M` - Comment: `<!-- directive: my-directive exp -->`
     *
     *
     * #### `templateNamespace`
     * String representing the document type used by the markup in the template.
     * AngularJS needs this information as those elements need to be created and cloned
     * in a special way when they are defined outside their usual containers like `<svg>` and `<math>`.
     *
     * * `html` - All root nodes in the template are HTML. Root nodes may also be
     *   top-level elements such as `<svg>` or `<math>`.
     * * `svg` - The root nodes in the template are SVG elements (excluding `<math>`).
     * * `math` - The root nodes in the template are MathML elements (excluding `<svg>`).
     *
     * If no `templateNamespace` is specified, then the namespace is considered to be `html`.
     *
     * #### `template`
     * HTML markup that may:
     * * Replace the contents of the directive's element (default).
     * * Replace the directive's element itself (if `replace` is true - DEPRECATED).
     * * Wrap the contents of the directive's element (if `transclude` is true).
     *
     * Value may be:
     *
     * * A string. For example `<div red-on-hover>{{delete_str}}</div>`.
     * * A function which takes two arguments `tElement` and `tAttrs` (described in the `compile`
     *   function api below) and returns a string value.
     *
     *
     * #### `templateUrl`
     * This is similar to `template` but the template is loaded from the specified URL, asynchronously.
     *
     * Because template loading is asynchronous the compiler will suspend compilation of directives on that element
     * for later when the template has been resolved.  In the meantime it will continue to compile and link
     * sibling and parent elements as though this element had not contained any directives.
     *
     * The compiler does not suspend the entire compilation to wait for templates to be loaded because this
     * would result in the whole app "stalling" until all templates are loaded asynchronously - even in the
     * case when only one deeply nested directive has `templateUrl`.
     *
     * Template loading is asynchronous even if the template has been preloaded into the {@link $templateCache}
     *
     * You can specify `templateUrl` as a string representing the URL or as a function which takes two
     * arguments `tElement` and `tAttrs` (described in the `compile` function api below) and returns
     * a string value representing the url.  In either case, the template URL is passed through {@link
        * $sce#getTrustedResourceUrl $sce.getTrustedResourceUrl}.
     *
     *
     * #### `replace` ([*DEPRECATED*!], will be removed in next major release - i.e. v2.0)
     * specify what the template should replace. Defaults to `false`.
     *
     * * `true` - the template will replace the directive's element.
     * * `false` - the template will replace the contents of the directive's element.
     *
     * The replacement process migrates all of the attributes / classes from the old element to the new
     * one. See the {@link guide/directive#template-expanding-directive
 * Directives Guide} for an example.
     *
     * There are very few scenarios where element replacement is required for the application function,
     * the main one being reusable custom components that are used within SVG contexts
     * (because SVG doesn't work with custom elements in the DOM tree).
     *
     * #### `transclude`
     * Extract the contents of the element where the directive appears and make it available to the directive.
     * The contents are compiled and provided to the directive as a **transclusion function**. See the
     * {@link $compile#transclusion Transclusion} section below.
     *
     *
     * #### `compile`
     *
     * ```js
     *   function compile(tElement, tAttrs, transclude) { ... }
     * ```
     *
     * The compile function deals with transforming the template DOM. Since most directives do not do
     * template transformation, it is not used often. The compile function takes the following arguments:
     *
     *   * `tElement` - template element - The element where the directive has been declared. It is
     *     safe to do template transformation on the element and child elements only.
     *
     *   * `tAttrs` - template attributes - Normalized list of attributes declared on this element shared
     *     between all directive compile functions.
     *
     *   * `transclude` -  [*DEPRECATED*!] A transclude linking function: `function(scope, cloneLinkingFn)`
     *
     * <div class="alert alert-warning">
     * **Note:** The template instance and the link instance may be different objects if the template has
     * been cloned. For this reason it is **not** safe to do anything other than DOM transformations that
     * apply to all cloned DOM nodes within the compile function. Specifically, DOM listener registration
     * should be done in a linking function rather than in a compile function.
     * </div>

     * <div class="alert alert-warning">
     * **Note:** The compile function cannot handle directives that recursively use themselves in their
     * own templates or compile functions. Compiling these directives results in an infinite loop and
     * stack overflow errors.
     *
     * This can be avoided by manually using $compile in the postLink function to imperatively compile
     * a directive's template instead of relying on automatic template compilation via `template` or
     * `templateUrl` declaration or manual compilation inside the compile function.
     * </div>
     *
     * <div class="alert alert-danger">
     * **Note:** The `transclude` function that is passed to the compile function is deprecated, as it
     *   e.g. does not know about the right outer scope. Please use the transclude function that is passed
     *   to the link function instead.
     * </div>

     * A compile function can have a return value which can be either a function or an object.
     *
     * * returning a (post-link) function - is equivalent to registering the linking function via the
     *   `link` property of the config object when the compile function is empty.
     *
     * * returning an object with function(s) registered via `pre` and `post` properties - allows you to
     *   control when a linking function should be called during the linking phase. See info about
     *   pre-linking and post-linking functions below.
     *
     *
     * #### `link`
     * This property is used only if the `compile` property is not defined.
     *
     * ```js
     *   function link(scope, iElement, iAttrs, controller, transcludeFn) { ... }
     * ```
     *
     * The link function is responsible for registering DOM listeners as well as updating the DOM. It is
     * executed after the template has been cloned. This is where most of the directive logic will be
     * put.
     *
     *   * `scope` - {@link ng.$rootScope.Scope Scope} - The scope to be used by the
     *     directive for registering {@link ng.$rootScope.Scope#$watch watches}.
     *
     *   * `iElement` - instance element - The element where the directive is to be used. It is safe to
     *     manipulate the children of the element only in `postLink` function since the children have
     *     already been linked.
     *
     *   * `iAttrs` - instance attributes - Normalized list of attributes declared on this element shared
     *     between all directive linking functions.
     *
     *   * `controller` - the directive's required controller instance(s) - Instances are shared
     *     among all directives, which allows the directives to use the controllers as a communication
     *     channel. The exact value depends on the directive's `require` property:
     *       * no controller(s) required: the directive's own controller, or `undefined` if it doesn't have one
     *       * `string`: the controller instance
     *       * `array`: array of controller instances
     *
     *     If a required controller cannot be found, and it is optional, the instance is `null`,
     *     otherwise the {@link error:$compile:ctreq Missing Required Controller} error is thrown.
     *
     *     Note that you can also require the directive's own controller - it will be made available like
     *     any other controller.
     *
     *   * `transcludeFn` - A transclude linking function pre-bound to the correct transclusion scope.
     *     This is the same as the `$transclude` parameter of directive controllers,
     *     see {@link ng.$compile#-controller- the controller section for details}.
     *     `function([scope], cloneLinkingFn, futureParentElement)`.
     *
     * #### Pre-linking function
     *
     * Executed before the child elements are linked. Not safe to do DOM transformation since the
     * compiler linking function will fail to locate the correct elements for linking.
     *
     * #### Post-linking function
     *
     * Executed after the child elements are linked.
     *
     * Note that child elements that contain `templateUrl` directives will not have been compiled
     * and linked since they are waiting for their template to load asynchronously and their own
     * compilation and linking has been suspended until that occurs.
     *
     * It is safe to do DOM transformation in the post-linking function on elements that are not waiting
     * for their async templates to be resolved.
     *
     *
     * ### Transclusion
     *
     * Transclusion is the process of extracting a collection of DOM elements from one part of the DOM and
     * copying them to another part of the DOM, while maintaining their connection to the original AngularJS
     * scope from where they were taken.
     *
     * Transclusion is used (often with {@link ngTransclude}) to insert the
     * original contents of a directive's element into a specified place in the template of the directive.
     * The benefit of transclusion, over simply moving the DOM elements manually, is that the transcluded
     * content has access to the properties on the scope from which it was taken, even if the directive
     * has isolated scope.
     * See the {@link guide/directive#creating-a-directive-that-wraps-other-elements Directives Guide}.
     *
     * This makes it possible for the widget to have private state for its template, while the transcluded
     * content has access to its originating scope.
     *
     * <div class="alert alert-warning">
     * **Note:** When testing an element transclude directive you must not place the directive at the root of the
     * DOM fragment that is being compiled. See {@link guide/unit-testing#testing-transclusion-directives
 * Testing Transclusion Directives}.
     * </div>
     *
     * There are three kinds of transclusion depending upon whether you want to transclude just the contents of the
     * directive's element, the entire element or multiple parts of the element contents:
     *
     * * `true` - transclude the content (i.e. the child nodes) of the directive's element.
     * * `'element'` - transclude the whole of the directive's element including any directives on this
     *   element that defined at a lower priority than this directive. When used, the `template`
     *   property is ignored.
     * * **`{...}` (an object hash):** - map elements of the content onto transclusion "slots" in the template.
     *
     * **Mult-slot transclusion** is declared by providing an object for the `transclude` property.
     *
     * This object is a map where the keys are the name of the slot to fill and the value is an element selector
     * used to match the HTML to the slot. The element selector should be in normalized form (e.g. `myElement`)
     * and will match the standard element variants (e.g. `my-element`, `my:element`, `data-my-element`, etc).
     *
     * For further information check out the guide on {@link guide/directive#matching-directives Matching Directives}
     *
     * If the element selector is prefixed with a `?` then that slot is optional.
     *
     * For example, the transclude object `{ slotA: '?myCustomElement' }` maps `<my-custom-element>` elements to
     * the `slotA` slot, which can be accessed via the `$transclude` function or via the {@link ngTransclude} directive.
     *
     * Slots that are not marked as optional (`?`) will trigger a compile time error if there are no matching elements
     * in the transclude content. If you wish to know if an optional slot was filled with content, then you can call
     * `$transclude.isSlotFilled(slotName)` on the transclude function passed to the directive's link function and
     * injectable into the directive's controller.
     *
     *
     * #### Transclusion Functions
     *
     * When a directive requests transclusion, the compiler extracts its contents and provides a **transclusion
     * function** to the directive's `link` function and `controller`. This transclusion function is a special
     * **linking function** that will return the compiled contents linked to a new transclusion scope.
     *
     * <div class="alert alert-info">
     * If you are just using {@link ngTransclude} then you don't need to worry about this function, since
     * ngTransclude will deal with it for us.
     * </div>
     *
     * If you want to manually control the insertion and removal of the transcluded content in your directive
     * then you must use this transclude function. When you call a transclude function it returns a a jqLite/JQuery
     * object that contains the compiled DOM, which is linked to the correct transclusion scope.
     *
     * When you call a transclusion function you can pass in a **clone attach function**. This function accepts
     * two parameters, `function(clone, scope) { ... }`, where the `clone` is a fresh compiled copy of your transcluded
     * content and the `scope` is the newly created transclusion scope, to which the clone is bound.
     *
     * <div class="alert alert-info">
     * **Best Practice**: Always provide a `cloneFn` (clone attach function) when you call a transclude function
     * since you then get a fresh clone of the original DOM and also have access to the new transclusion scope.
     * </div>
     *
     * It is normal practice to attach your transcluded content (`clone`) to the DOM inside your **clone
     * attach function**:
     *
     * ```js
     * var transcludedContent, transclusionScope;
     *
     * $transclude(function(clone, scope) {
 *   element.append(clone);
 *   transcludedContent = clone;
 *   transclusionScope = scope;
 * });
     * ```
     *
     * Later, if you want to remove the transcluded content from your DOM then you should also destroy the
     * associated transclusion scope:
     *
     * ```js
     * transcludedContent.remove();
     * transclusionScope.$destroy();
     * ```
     *
     * <div class="alert alert-info">
     * **Best Practice**: if you intend to add and remove transcluded content manually in your directive
     * (by calling the transclude function to get the DOM and calling `element.remove()` to remove it),
     * then you are also responsible for calling `$destroy` on the transclusion scope.
     * </div>
     *
     * The built-in DOM manipulation directives, such as {@link ngIf}, {@link ngSwitch} and {@link ngRepeat}
     * automatically destroy their transcluded clones as necessary so you do not need to worry about this if
     * you are simply using {@link ngTransclude} to inject the transclusion into your directive.
     *
     *
     * #### Transclusion Scopes
     *
     * When you call a transclude function it returns a DOM fragment that is pre-bound to a **transclusion
     * scope**. This scope is special, in that it is a child of the directive's scope (and so gets destroyed
     * when the directive's scope gets destroyed) but it inherits the properties of the scope from which it
     * was taken.
     *
     * For example consider a directive that uses transclusion and isolated scope. The DOM hierarchy might look
     * like this:
     *
     * ```html
     * <div ng-app>
     *   <div isolate>
     *     <div transclusion>
     *     </div>
     *   </div>
     * </div>
     * ```
     *
     * The `$parent` scope hierarchy will look like this:
     *
     ```
     - $rootScope
     - isolate
     - transclusion
     ```
     *
     * but the scopes will inherit prototypically from different scopes to their `$parent`.
     *
     ```
     - $rootScope
     - transclusion
     - isolate
     ```
     *
     *
     * ### Attributes
     *
     * The {@link ng.$compile.directive.Attributes Attributes} object - passed as a parameter in the
     * `link()` or `compile()` functions. It has a variety of uses.
     *
     * * *Accessing normalized attribute names:* Directives like 'ngBind' can be expressed in many ways:
     *   'ng:bind', `data-ng-bind`, or 'x-ng-bind'. The attributes object allows for normalized access
     *   to the attributes.
     *
     * * *Directive inter-communication:* All directives share the same instance of the attributes
     *   object which allows the directives to use the attributes object as inter directive
     *   communication.
     *
     * * *Supports interpolation:* Interpolation attributes are assigned to the attribute object
     *   allowing other directives to read the interpolated value.
     *
     * * *Observing interpolated attributes:* Use `$observe` to observe the value changes of attributes
     *   that contain interpolation (e.g. `src="{{bar}}"`). Not only is this very efficient but it's also
     *   the only way to easily get the actual value because during the linking phase the interpolation
     *   hasn't been evaluated yet and so the value is at this time set to `undefined`.
     *
     * ```js
     * function linkingFn(scope, elm, attrs, ctrl) {
 *   // get the attribute value
 *   console.log(attrs.ngModel);
 *
 *   // change the attribute
 *   attrs.$set('ngModel', 'new value');
 *
 *   // observe changes to interpolated attribute
 *   attrs.$observe('ngModel', function(value) {
 *     console.log('ngModel has changed value to ' + value);
 *   });
 * }
     * ```
     *
     * ## Example
     *
     * <div class="alert alert-warning">
     * **Note**: Typically directives are registered with `module.directive`. The example below is
     * to illustrate how `$compile` works.
     * </div>
     *
     <example module="compileExample" name="compile">
     <file name="index.html">
     <script>
     angular.module('compileExample', [], function($compileProvider) {
        // configure new 'compile' directive by passing a directive
        // factory function. The factory function injects the '$compile'
        $compileProvider.directive('compile', function($compile) {
          // directive factory creates a link function
          return function(scope, element, attrs) {
            scope.$watch(
              function(scope) {
                 // watch the 'compile' expression for changes
                return scope.$eval(attrs.compile);
              },
              function(value) {
                // when the 'compile' expression changes
                // assign it into the current DOM
                element.html(value);

                // compile the new DOM and link it to the current
                // scope.
                // NOTE: we only compile .childNodes so that
                // we don't get into infinite loop compiling ourselves
                $compile(element.contents())(scope);
              }
            );
          };
        });
      })
     .controller('GreeterController', ['$scope', function($scope) {
        $scope.name = 'Angular';
        $scope.html = 'Hello {{name}}';
      }]);
     </script>
     <div ng-controller="GreeterController">
     <input ng-model="name"> <br/>
     <textarea ng-model="html"></textarea> <br/>
     <div compile="html"></div>
     </div>
     </file>
     <file name="protractor.js" type="protractor">
     it('should auto compile', function() {
       var textarea = $('textarea');
       var output = $('div[compile]');
       // The initial state reads 'Hello Angular'.
       expect(output.getText()).toBe('Hello Angular');
       textarea.clear();
       textarea.sendKeys('{{name}}!');
       expect(output.getText()).toBe('Angular!');
     });
     </file>
     </example>

     *
     *
     * @param {string|DOMElement} element Element or HTML string to compile into a template function.
     * @param {function(angular.Scope, cloneAttachFn=)} transclude function available to directives - DEPRECATED.
     *
     * <div class="alert alert-danger">
     * **Note:** Passing a `transclude` function to the $compile function is deprecated, as it
     *   e.g. will not use the right outer scope. Please pass the transclude function as a
     *   `parentBoundTranscludeFn` to the link function instead.
     * </div>
     *
     * @param {number} maxPriority only apply directives lower than given priority (Only effects the
     *                 root element(s), not their children)
     * @returns {function(scope, cloneAttachFn=, options=)} a link function which is used to bind template
     * (a DOM element/tree) to a scope. Where:
     *
     *  * `scope` - A {@link ng.$rootScope.Scope Scope} to bind to.
     *  * `cloneAttachFn` - If `cloneAttachFn` is provided, then the link function will clone the
     *  `template` and call the `cloneAttachFn` function allowing the caller to attach the
     *  cloned elements to the DOM document at the appropriate place. The `cloneAttachFn` is
     *  called as: <br/> `cloneAttachFn(clonedElement, scope)` where:
     *
     *      * `clonedElement` - is a clone of the original `element` passed into the compiler.
     *      * `scope` - is the current scope with which the linking function is working with.
     *
     *  * `options` - An optional object hash with linking options. If `options` is provided, then the following
     *  keys may be used to control linking behavior:
     *
     *      * `parentBoundTranscludeFn` - the transclude function made available to
     *        directives; if given, it will be passed through to the link functions of
     *        directives found in `element` during compilation.
     *      * `transcludeControllers` - an object hash with keys that map controller names
     *        to a hash with the key `instance`, which maps to the controller instance;
     *        if given, it will make the controllers available to directives on the compileNode:
     *        ```
     *        {
 *          parent: {
 *            instance: parentControllerInstance
 *          }
 *        }
     *        ```
     *      * `futureParentElement` - defines the parent to which the `cloneAttachFn` will add
     *        the cloned elements; only needed for transcludes that are allowed to contain non html
     *        elements (e.g. SVG elements). See also the directive.controller property.
     *
     * Calling the linking function returns the element of the template. It is either the original
     * element passed in, or the clone of the element if the `cloneAttachFn` is provided.
     *
     * After linking the view is not updated until after a call to $digest which typically is done by
     * Angular automatically.
     *
     * If you need access to the bound view, there are two ways to do it:
     *
     * - If you are not asking the linking function to clone the template, create the DOM element(s)
     *   before you send them to the compiler and keep this reference around.
     *   ```js
     *     var element = $compile('<p>{{total}}</p>')(scope);
     *   ```
     *
     * - if on the other hand, you need the element to be cloned, the view reference from the original
     *   example would not point to the clone, but rather to the original template that was cloned. In
     *   this case, you can access the clone via the cloneAttachFn:
     *   ```js
     *     var templateElement = angular.element('<p>{{total}}</p>'),
     *         scope = ....;
     *
     *     var clonedElement = $compile(templateElement)(scope, function(clonedElement, scope) {
 *       //attach the clone to DOM document at the right place
 *     });
     *
     *     //now we have reference to the cloned DOM via `clonedElement`
     *   ```
     *
     *
     * For information on how the compiler works, see the
     * {@link guide/compiler Angular HTML Compiler} section of the Developer Guide.
     */

    var $compileMinErr = minErr('$compile');

    function UNINITIALIZED_VALUE() {}
    var _UNINITIALIZED_VALUE = new UNINITIALIZED_VALUE();

    /**
     * @ngdoc provider
     * @name $compileProvider
     *
     * @description
     */
    $CompileProvider.$inject = ['$provide', '$$sanitizeUriProvider'];
    /** @this */
    function $CompileProvider($provide, $$sanitizeUriProvider) {
        var hasDirectives = {},
            Suffix = 'Directive',
            COMMENT_DIRECTIVE_REGEXP = /^\s*directive:\s*([\w\-]+)\s+(.*)$/,
            CLASS_DIRECTIVE_REGEXP = /(([\w\-]+)(?::([^;]+))?;?)/,
            ALL_OR_NOTHING_ATTRS = makeMap('ngSrc,ngSrcset,src,srcset'),
            REQUIRE_PREFIX_REGEXP = /^(?:(\^\^?)?(\?)?(\^\^?)?)?/;

        // Ref: http://developers.whatwg.org/webappapis.html#event-handler-idl-attributes
        // The assumption is that future DOM event attribute names will begin with
        // 'on' and be composed of only English letters.
        var EVENT_HANDLER_ATTR_REGEXP = /^(on[a-z]+|formaction)$/;
        var bindingCache = createMap();

        function parseIsolateBindings(scope, directiveName, isController) {
            var LOCAL_REGEXP = /^\s*([@&<]|=(\*?))(\??)\s*(\w*)\s*$/;

            var bindings = createMap();

            forEach(scope, function(definition, scopeName) {
                if (definition in bindingCache) {
                    bindings[scopeName] = bindingCache[definition];
                    return;
                }
                var match = definition.match(LOCAL_REGEXP);

                if (!match) {
                    throw $compileMinErr('iscp',
                        'Invalid {3} for directive \'{0}\'.' +
                        ' Definition: {... {1}: \'{2}\' ...}',
                        directiveName, scopeName, definition,
                        (isController ? 'controller bindings definition' :
                            'isolate scope definition'));
                }

                bindings[scopeName] = {
                    mode: match[1][0],
                    collection: match[2] === '*',
                    optional: match[3] === '?',
                    attrName: match[4] || scopeName
                };
                if (match[4]) {
                    bindingCache[definition] = bindings[scopeName];
                }
            });

            return bindings;
        }

        function parseDirectiveBindings(directive, directiveName) {
            var bindings = {
                isolateScope: null,
                bindToController: null
            };
            if (isObject(directive.scope)) {
                if (directive.bindToController === true) {
                    bindings.bindToController = parseIsolateBindings(directive.scope,
                        directiveName, true);
                    bindings.isolateScope = {};
                } else {
                    bindings.isolateScope = parseIsolateBindings(directive.scope,
                        directiveName, false);
                }
            }
            if (isObject(directive.bindToController)) {
                bindings.bindToController =
                    parseIsolateBindings(directive.bindToController, directiveName, true);
            }
            if (isObject(bindings.bindToController)) {
                var controller = directive.controller;
                var controllerAs = directive.controllerAs;
                if (!controller) {
                    // There is no controller, there may or may not be a controllerAs property
                    throw $compileMinErr('noctrl',
                        'Cannot bind to controller without directive \'{0}\'s controller.',
                        directiveName);
                } else if (!identifierForController(controller, controllerAs)) {
                    // There is a controller, but no identifier or controllerAs property
                    throw $compileMinErr('noident',
                        'Cannot bind to controller without identifier for directive \'{0}\'.',
                        directiveName);
                }
            }
            return bindings;
        }

        function assertValidDirectiveName(name) {
            var letter = name.charAt(0);
            if (!letter || letter !== lowercase(letter)) {
                throw $compileMinErr('baddir', 'Directive/Component name \'{0}\' is invalid. The first character must be a lowercase letter', name);
            }
            if (name !== name.trim()) {
                throw $compileMinErr('baddir',
                    'Directive/Component name \'{0}\' is invalid. The name should not contain leading or trailing whitespaces',
                    name);
            }
        }

        function getDirectiveRequire(directive) {
            var require = directive.require || (directive.controller && directive.name);

            if (!isArray(require) && isObject(require)) {
                forEach(require, function(value, key) {
                    var match = value.match(REQUIRE_PREFIX_REGEXP);
                    var name = value.substring(match[0].length);
                    if (!name) require[key] = match[0] + key;
                });
            }

            return require;
        }

        /**
         * @ngdoc method
         * @name $compileProvider#directive
         * @kind function
         *
         * @description
         * Register a new directive with the compiler.
         *
         * @param {string|Object} name Name of the directive in camel-case (i.e. <code>ngBind</code> which
         *    will match as <code>ng-bind</code>), or an object map of directives where the keys are the
         *    names and the values are the factories.
         * @param {Function|Array} directiveFactory An injectable directive factory function. See the
         *    {@link guide/directive directive guide} and the {@link $compile compile API} for more info.
         * @returns {ng.$compileProvider} Self for chaining.
         */
        this.directive = function registerDirective(name, directiveFactory) {
            assertNotHasOwnProperty(name, 'directive');
            if (isString(name)) {
                assertValidDirectiveName(name);
                assertArg(directiveFactory, 'directiveFactory');
                if (!hasDirectives.hasOwnProperty(name)) {
                    hasDirectives[name] = [];
                    $provide.factory(name + Suffix, ['$injector', '$exceptionHandler',
                        function($injector, $exceptionHandler) {
                            var directives = [];
                            forEach(hasDirectives[name], function(directiveFactory, index) {
                                try {
                                    var directive = $injector.invoke(directiveFactory);
                                    if (isFunction(directive)) {
                                        directive = { compile: valueFn(directive) };
                                    } else if (!directive.compile && directive.link) {
                                        directive.compile = valueFn(directive.link);
                                    }
                                    directive.priority = directive.priority || 0;
                                    directive.index = index;
                                    directive.name = directive.name || name;
                                    directive.require = getDirectiveRequire(directive);
                                    directive.restrict = directive.restrict || 'EA';
                                    directive.$$moduleName = directiveFactory.$$moduleName;
                                    directives.push(directive);
                                } catch (e) {
                                    $exceptionHandler(e);
                                }
                            });
                            return directives;
                        }]);
                }
                hasDirectives[name].push(directiveFactory);
            } else {
                forEach(name, reverseParams(registerDirective));
            }
            return this;
        };

        /**
         * @ngdoc method
         * @name $compileProvider#component
         * @module ng
         * @param {string} name Name of the component in camelCase (i.e. `myComp` which will match `<my-comp>`)
         * @param {Object} options Component definition object (a simplified
         *    {@link ng.$compile#directive-definition-object directive definition object}),
         *    with the following properties (all optional):
         *
         *    - `controller` – `{(string|function()=}` – controller constructor function that should be
         *      associated with newly created scope or the name of a {@link ng.$compile#-controller-
   *      registered controller} if passed as a string. An empty `noop` function by default.
         *    - `controllerAs` – `{string=}` – identifier name for to reference the controller in the component's scope.
         *      If present, the controller will be published to scope under the `controllerAs` name.
         *      If not present, this will default to be `$ctrl`.
         *    - `template` – `{string=|function()=}` – html template as a string or a function that
         *      returns an html template as a string which should be used as the contents of this component.
         *      Empty string by default.
         *
         *      If `template` is a function, then it is {@link auto.$injector#invoke injected} with
         *      the following locals:
         *
         *      - `$element` - Current element
         *      - `$attrs` - Current attributes object for the element
         *
         *    - `templateUrl` – `{string=|function()=}` – path or function that returns a path to an html
         *      template that should be used  as the contents of this component.
         *
         *      If `templateUrl` is a function, then it is {@link auto.$injector#invoke injected} with
         *      the following locals:
         *
         *      - `$element` - Current element
         *      - `$attrs` - Current attributes object for the element
         *
         *    - `bindings` – `{object=}` – defines bindings between DOM attributes and component properties.
         *      Component properties are always bound to the component controller and not to the scope.
         *      See {@link ng.$compile#-bindtocontroller- `bindToController`}.
         *    - `transclude` – `{boolean=}` – whether {@link $compile#transclusion content transclusion} is enabled.
         *      Disabled by default.
         *    - `require` - `{Object<string, string>=}` - requires the controllers of other directives and binds them to
         *      this component's controller. The object keys specify the property names under which the required
         *      controllers (object values) will be bound. See {@link ng.$compile#-require- `require`}.
         *    - `$...` – additional properties to attach to the directive factory function and the controller
         *      constructor function. (This is used by the component router to annotate)
         *
         * @returns {ng.$compileProvider} the compile provider itself, for chaining of function calls.
         * @description
         * Register a **component definition** with the compiler. This is a shorthand for registering a special
         * type of directive, which represents a self-contained UI component in your application. Such components
         * are always isolated (i.e. `scope: {}`) and are always restricted to elements (i.e. `restrict: 'E'`).
         *
         * Component definitions are very simple and do not require as much configuration as defining general
         * directives. Component definitions usually consist only of a template and a controller backing it.
         *
         * In order to make the definition easier, components enforce best practices like use of `controllerAs`,
         * `bindToController`. They always have **isolate scope** and are restricted to elements.
         *
         * Here are a few examples of how you would usually define components:
         *
         * ```js
         *   var myMod = angular.module(...);
         *   myMod.component('myComp', {
   *     template: '<div>My name is {{$ctrl.name}}</div>',
   *     controller: function() {
   *       this.name = 'shahar';
   *     }
   *   });
         *
         *   myMod.component('myComp', {
   *     template: '<div>My name is {{$ctrl.name}}</div>',
   *     bindings: {name: '@'}
   *   });
         *
         *   myMod.component('myComp', {
   *     templateUrl: 'views/my-comp.html',
   *     controller: 'MyCtrl',
   *     controllerAs: 'ctrl',
   *     bindings: {name: '@'}
   *   });
         *
         * ```
         * For more examples, and an in-depth guide, see the {@link guide/component component guide}.
         *
         * <br />
         * See also {@link ng.$compileProvider#directive $compileProvider.directive()}.
         */
        this.component = function registerComponent(name, options) {
            var controller = options.controller || function() {};

            function factory($injector) {
                function makeInjectable(fn) {
                    if (isFunction(fn) || isArray(fn)) {
                        return /** @this */ function(tElement, tAttrs) {
                            return $injector.invoke(fn, this, {$element: tElement, $attrs: tAttrs});
                        };
                    } else {
                        return fn;
                    }
                }

                var template = (!options.template && !options.templateUrl ? '' : options.template);
                var ddo = {
                    controller: controller,
                    controllerAs: identifierForController(options.controller) || options.controllerAs || '$ctrl',
                    template: makeInjectable(template),
                    templateUrl: makeInjectable(options.templateUrl),
                    transclude: options.transclude,
                    scope: {},
                    bindToController: options.bindings || {},
                    restrict: 'E',
                    require: options.require
                };

                // Copy annotations (starting with $) over to the DDO
                forEach(options, function(val, key) {
                    if (key.charAt(0) === '$') ddo[key] = val;
                });

                return ddo;
            }

            // TODO(pete) remove the following `forEach` before we release 1.6.0
            // The component-router@0.2.0 looks for the annotations on the controller constructor
            // Nothing in Angular looks for annotations on the factory function but we can't remove
            // it from 1.5.x yet.

            // Copy any annotation properties (starting with $) over to the factory and controller constructor functions
            // These could be used by libraries such as the new component router
            forEach(options, function(val, key) {
                if (key.charAt(0) === '$') {
                    factory[key] = val;
                    // Don't try to copy over annotations to named controller
                    if (isFunction(controller)) controller[key] = val;
                }
            });

            factory.$inject = ['$injector'];

            return this.directive(name, factory);
        };


        /**
         * @ngdoc method
         * @name $compileProvider#aHrefSanitizationWhitelist
         * @kind function
         *
         * @description
         * Retrieves or overrides the default regular expression that is used for whitelisting of safe
         * urls during a[href] sanitization.
         *
         * The sanitization is a security measure aimed at preventing XSS attacks via html links.
         *
         * Any url about to be assigned to a[href] via data-binding is first normalized and turned into
         * an absolute url. Afterwards, the url is matched against the `aHrefSanitizationWhitelist`
         * regular expression. If a match is found, the original url is written into the dom. Otherwise,
         * the absolute url is prefixed with `'unsafe:'` string and only then is it written into the DOM.
         *
         * @param {RegExp=} regexp New regexp to whitelist urls with.
         * @returns {RegExp|ng.$compileProvider} Current RegExp if called without value or self for
         *    chaining otherwise.
         */
        this.aHrefSanitizationWhitelist = function(regexp) {
            if (isDefined(regexp)) {
                $$sanitizeUriProvider.aHrefSanitizationWhitelist(regexp);
                return this;
            } else {
                return $$sanitizeUriProvider.aHrefSanitizationWhitelist();
            }
        };


        /**
         * @ngdoc method
         * @name $compileProvider#imgSrcSanitizationWhitelist
         * @kind function
         *
         * @description
         * Retrieves or overrides the default regular expression that is used for whitelisting of safe
         * urls during img[src] sanitization.
         *
         * The sanitization is a security measure aimed at prevent XSS attacks via html links.
         *
         * Any url about to be assigned to img[src] via data-binding is first normalized and turned into
         * an absolute url. Afterwards, the url is matched against the `imgSrcSanitizationWhitelist`
         * regular expression. If a match is found, the original url is written into the dom. Otherwise,
         * the absolute url is prefixed with `'unsafe:'` string and only then is it written into the DOM.
         *
         * @param {RegExp=} regexp New regexp to whitelist urls with.
         * @returns {RegExp|ng.$compileProvider} Current RegExp if called without value or self for
         *    chaining otherwise.
         */
        this.imgSrcSanitizationWhitelist = function(regexp) {
            if (isDefined(regexp)) {
                $$sanitizeUriProvider.imgSrcSanitizationWhitelist(regexp);
                return this;
            } else {
                return $$sanitizeUriProvider.imgSrcSanitizationWhitelist();
            }
        };

        /**
         * @ngdoc method
         * @name  $compileProvider#debugInfoEnabled
         *
         * @param {boolean=} enabled update the debugInfoEnabled state if provided, otherwise just return the
         * current debugInfoEnabled state
         * @returns {*} current value if used as getter or itself (chaining) if used as setter
         *
         * @kind function
         *
         * @description
         * Call this method to enable/disable various debug runtime information in the compiler such as adding
         * binding information and a reference to the current scope on to DOM elements.
         * If enabled, the compiler will add the following to DOM elements that have been bound to the scope
         * * `ng-binding` CSS class
         * * `$binding` data property containing an array of the binding expressions
         *
         * You may want to disable this in production for a significant performance boost. See
         * {@link guide/production#disabling-debug-data Disabling Debug Data} for more.
         *
         * The default value is true.
         */
        var debugInfoEnabled = true;
        this.debugInfoEnabled = function(enabled) {
            if (isDefined(enabled)) {
                debugInfoEnabled = enabled;
                return this;
            }
            return debugInfoEnabled;
        };


        var TTL = 10;
        /**
         * @ngdoc method
         * @name $compileProvider#onChangesTtl
         * @description
         *
         * Sets the number of times `$onChanges` hooks can trigger new changes before giving up and
         * assuming that the model is unstable.
         *
         * The current default is 10 iterations.
         *
         * In complex applications it's possible that dependencies between `$onChanges` hooks and bindings will result
         * in several iterations of calls to these hooks. However if an application needs more than the default 10
         * iterations to stabilize then you should investigate what is causing the model to continuously change during
         * the `$onChanges` hook execution.
         *
         * Increasing the TTL could have performance implications, so you should not change it without proper justification.
         *
         * @param {number} limit The number of `$onChanges` hook iterations.
         * @returns {number|object} the current limit (or `this` if called as a setter for chaining)
         */
        this.onChangesTtl = function(value) {
            if (arguments.length) {
                TTL = value;
                return this;
            }
            return TTL;
        };

        var commentDirectivesEnabledConfig = true;
        /**
         * @ngdoc method
         * @name $compileProvider#commentDirectivesEnabled
         * @description
         *
         * It indicates to the compiler
         * whether or not directives on comments should be compiled.
         * Defaults to `true`.
         *
         * Calling this function with false disables the compilation of directives
         * on comments for the whole application.
         * This results in a compilation performance gain,
         * as the compiler doesn't have to check comments when looking for directives.
         * This should however only be used if you are sure that no comment directives are used in
         * the application (including any 3rd party directives).
         *
         * @param {boolean} enabled `false` if the compiler may ignore directives on comments
         * @returns {boolean|object} the current value (or `this` if called as a setter for chaining)
         */
        this.commentDirectivesEnabled = function(value) {
            if (arguments.length) {
                commentDirectivesEnabledConfig = value;
                return this;
            }
            return commentDirectivesEnabledConfig;
        };


        var cssClassDirectivesEnabledConfig = true;
        /**
         * @ngdoc method
         * @name $compileProvider#cssClassDirectivesEnabled
         * @description
         *
         * It indicates to the compiler
         * whether or not directives on element classes should be compiled.
         * Defaults to `true`.
         *
         * Calling this function with false disables the compilation of directives
         * on element classes for the whole application.
         * This results in a compilation performance gain,
         * as the compiler doesn't have to check element classes when looking for directives.
         * This should however only be used if you are sure that no class directives are used in
         * the application (including any 3rd party directives).
         *
         * @param {boolean} enabled `false` if the compiler may ignore directives on element classes
         * @returns {boolean|object} the current value (or `this` if called as a setter for chaining)
         */
        this.cssClassDirectivesEnabled = function(value) {
            if (arguments.length) {
                cssClassDirectivesEnabledConfig = value;
                return this;
            }
            return cssClassDirectivesEnabledConfig;
        };

        this.$get = [
            '$injector', '$interpolate', '$exceptionHandler', '$templateRequest', '$parse',
            '$controller', '$rootScope', '$sce', '$animate', '$$sanitizeUri',
            function($injector,   $interpolate,   $exceptionHandler,   $templateRequest,   $parse,
                     $controller,   $rootScope,   $sce,   $animate,   $$sanitizeUri) {

                var SIMPLE_ATTR_NAME = /^\w/;
                var specialAttrHolder = window.document.createElement('div');


                var commentDirectivesEnabled = commentDirectivesEnabledConfig;
                var cssClassDirectivesEnabled = cssClassDirectivesEnabledConfig;


                var onChangesTtl = TTL;
                // The onChanges hooks should all be run together in a single digest
                // When changes occur, the call to trigger their hooks will be added to this queue
                var onChangesQueue;

                // This function is called in a $$postDigest to trigger all the onChanges hooks in a single digest
                function flushOnChangesQueue() {
                    try {
                        if (!(--onChangesTtl)) {
                            // We have hit the TTL limit so reset everything
                            onChangesQueue = undefined;
                            throw $compileMinErr('infchng', '{0} $onChanges() iterations reached. Aborting!\n', TTL);
                        }
                        // We must run this hook in an apply since the $$postDigest runs outside apply
                        $rootScope.$apply(function() {
                            var errors = [];
                            for (var i = 0, ii = onChangesQueue.length; i < ii; ++i) {
                                try {
                                    onChangesQueue[i]();
                                } catch (e) {
                                    errors.push(e);
                                }
                            }
                            // Reset the queue to trigger a new schedule next time there is a change
                            onChangesQueue = undefined;
                            if (errors.length) {
                                throw errors;
                            }
                        });
                    } finally {
                        onChangesTtl++;
                    }
                }


                function Attributes(element, attributesToCopy) {
                    if (attributesToCopy) {
                        var keys = Object.keys(attributesToCopy);
                        var i, l, key;

                        for (i = 0, l = keys.length; i < l; i++) {
                            key = keys[i];
                            this[key] = attributesToCopy[key];
                        }
                    } else {
                        this.$attr = {};
                    }

                    this.$$element = element;
                }

                Attributes.prototype = {
                    /**
                     * @ngdoc method
                     * @name $compile.directive.Attributes#$normalize
                     * @kind function
                     *
                     * @description
                     * Converts an attribute name (e.g. dash/colon/underscore-delimited string, optionally prefixed with `x-` or
                     * `data-`) to its normalized, camelCase form.
                     *
                     * Also there is special case for Moz prefix starting with upper case letter.
                     *
                     * For further information check out the guide on {@link guide/directive#matching-directives Matching Directives}
                     *
                     * @param {string} name Name to normalize
                     */
                    $normalize: directiveNormalize,


                    /**
                     * @ngdoc method
                     * @name $compile.directive.Attributes#$addClass
                     * @kind function
                     *
                     * @description
                     * Adds the CSS class value specified by the classVal parameter to the element. If animations
                     * are enabled then an animation will be triggered for the class addition.
                     *
                     * @param {string} classVal The className value that will be added to the element
                     */
                    $addClass: function(classVal) {
                        if (classVal && classVal.length > 0) {
                            $animate.addClass(this.$$element, classVal);
                        }
                    },

                    /**
                     * @ngdoc method
                     * @name $compile.directive.Attributes#$removeClass
                     * @kind function
                     *
                     * @description
                     * Removes the CSS class value specified by the classVal parameter from the element. If
                     * animations are enabled then an animation will be triggered for the class removal.
                     *
                     * @param {string} classVal The className value that will be removed from the element
                     */
                    $removeClass: function(classVal) {
                        if (classVal && classVal.length > 0) {
                            $animate.removeClass(this.$$element, classVal);
                        }
                    },

                    /**
                     * @ngdoc method
                     * @name $compile.directive.Attributes#$updateClass
                     * @kind function
                     *
                     * @description
                     * Adds and removes the appropriate CSS class values to the element based on the difference
                     * between the new and old CSS class values (specified as newClasses and oldClasses).
                     *
                     * @param {string} newClasses The current CSS className value
                     * @param {string} oldClasses The former CSS className value
                     */
                    $updateClass: function(newClasses, oldClasses) {
                        var toAdd = tokenDifference(newClasses, oldClasses);
                        if (toAdd && toAdd.length) {
                            $animate.addClass(this.$$element, toAdd);
                        }

                        var toRemove = tokenDifference(oldClasses, newClasses);
                        if (toRemove && toRemove.length) {
                            $animate.removeClass(this.$$element, toRemove);
                        }
                    },

                    /**
                     * Set a normalized attribute on the element in a way such that all directives
                     * can share the attribute. This function properly handles boolean attributes.
                     * @param {string} key Normalized key. (ie ngAttribute)
                     * @param {string|boolean} value The value to set. If `null` attribute will be deleted.
                     * @param {boolean=} writeAttr If false, does not write the value to DOM element attribute.
                     *     Defaults to true.
                     * @param {string=} attrName Optional none normalized name. Defaults to key.
                     */
                    $set: function(key, value, writeAttr, attrName) {
                        // TODO: decide whether or not to throw an error if "class"
                        //is set through this function since it may cause $updateClass to
                        //become unstable.

                        var node = this.$$element[0],
                            booleanKey = getBooleanAttrName(node, key),
                            aliasedKey = getAliasedAttrName(key),
                            observer = key,
                            nodeName;

                        if (booleanKey) {
                            this.$$element.prop(key, value);
                            attrName = booleanKey;
                        } else if (aliasedKey) {
                            this[aliasedKey] = value;
                            observer = aliasedKey;
                        }

                        this[key] = value;

                        // translate normalized key to actual key
                        if (attrName) {
                            this.$attr[key] = attrName;
                        } else {
                            attrName = this.$attr[key];
                            if (!attrName) {
                                this.$attr[key] = attrName = snake_case(key, '-');
                            }
                        }

                        nodeName = nodeName_(this.$$element);

                        if ((nodeName === 'a' && (key === 'href' || key === 'xlinkHref')) ||
                            (nodeName === 'img' && key === 'src')) {
                            // sanitize a[href] and img[src] values
                            this[key] = value = $$sanitizeUri(value, key === 'src');
                        } else if (nodeName === 'img' && key === 'srcset' && isDefined(value)) {
                            // sanitize img[srcset] values
                            var result = '';

                            // first check if there are spaces because it's not the same pattern
                            var trimmedSrcset = trim(value);
                            //                (   999x   ,|   999w   ,|   ,|,   )
                            var srcPattern = /(\s+\d+x\s*,|\s+\d+w\s*,|\s+,|,\s+)/;
                            var pattern = /\s/.test(trimmedSrcset) ? srcPattern : /(,)/;

                            // split srcset into tuple of uri and descriptor except for the last item
                            var rawUris = trimmedSrcset.split(pattern);

                            // for each tuples
                            var nbrUrisWith2parts = Math.floor(rawUris.length / 2);
                            for (var i = 0; i < nbrUrisWith2parts; i++) {
                                var innerIdx = i * 2;
                                // sanitize the uri
                                result += $$sanitizeUri(trim(rawUris[innerIdx]), true);
                                // add the descriptor
                                result += (' ' + trim(rawUris[innerIdx + 1]));
                            }

                            // split the last item into uri and descriptor
                            var lastTuple = trim(rawUris[i * 2]).split(/\s/);

                            // sanitize the last uri
                            result += $$sanitizeUri(trim(lastTuple[0]), true);

                            // and add the last descriptor if any
                            if (lastTuple.length === 2) {
                                result += (' ' + trim(lastTuple[1]));
                            }
                            this[key] = value = result;
                        }

                        if (writeAttr !== false) {
                            if (value === null || isUndefined(value)) {
                                this.$$element.removeAttr(attrName);
                            } else {
                                if (SIMPLE_ATTR_NAME.test(attrName)) {
                                    this.$$element.attr(attrName, value);
                                } else {
                                    setSpecialAttr(this.$$element[0], attrName, value);
                                }
                            }
                        }

                        // fire observers
                        var $$observers = this.$$observers;
                        if ($$observers) {
                            forEach($$observers[observer], function(fn) {
                                try {
                                    fn(value);
                                } catch (e) {
                                    $exceptionHandler(e);
                                }
                            });
                        }
                    },


                    /**
                     * @ngdoc method
                     * @name $compile.directive.Attributes#$observe
                     * @kind function
                     *
                     * @description
                     * Observes an interpolated attribute.
                     *
                     * The observer function will be invoked once during the next `$digest` following
                     * compilation. The observer is then invoked whenever the interpolated value
                     * changes.
                     *
                     * @param {string} key Normalized key. (ie ngAttribute) .
                     * @param {function(interpolatedValue)} fn Function that will be called whenever
                     the interpolated value of the attribute changes.
                     *        See the {@link guide/interpolation#how-text-and-attribute-bindings-work Interpolation
       *        guide} for more info.
                     * @returns {function()} Returns a deregistration function for this observer.
                     */
                    $observe: function(key, fn) {
                        var attrs = this,
                            $$observers = (attrs.$$observers || (attrs.$$observers = createMap())),
                            listeners = ($$observers[key] || ($$observers[key] = []));

                        listeners.push(fn);
                        $rootScope.$evalAsync(function() {
                            if (!listeners.$$inter && attrs.hasOwnProperty(key) && !isUndefined(attrs[key])) {
                                // no one registered attribute interpolation function, so lets call it manually
                                fn(attrs[key]);
                            }
                        });

                        return function() {
                            arrayRemove(listeners, fn);
                        };
                    }
                };

                function setSpecialAttr(element, attrName, value) {
                    // Attributes names that do not start with letters (such as `(click)`) cannot be set using `setAttribute`
                    // so we have to jump through some hoops to get such an attribute
                    // https://github.com/angular/angular.js/pull/13318
                    specialAttrHolder.innerHTML = '<span ' + attrName + '>';
                    var attributes = specialAttrHolder.firstChild.attributes;
                    var attribute = attributes[0];
                    // We have to remove the attribute from its container element before we can add it to the destination element
                    attributes.removeNamedItem(attribute.name);
                    attribute.value = value;
                    element.attributes.setNamedItem(attribute);
                }

                function safeAddClass($element, className) {
                    try {
                        $element.addClass(className);
                    } catch (e) {
                        // ignore, since it means that we are trying to set class on
                        // SVG element, where class name is read-only.
                    }
                }


                var startSymbol = $interpolate.startSymbol(),
                    endSymbol = $interpolate.endSymbol(),
                    denormalizeTemplate = (startSymbol === '{{' && endSymbol  === '}}')
                        ? identity
                        : function denormalizeTemplate(template) {
                        return template.replace(/\{\{/g, startSymbol).replace(/}}/g, endSymbol);
                    },
                    NG_ATTR_BINDING = /^ngAttr[A-Z]/;
                var MULTI_ELEMENT_DIR_RE = /^(.+)Start$/;

                compile.$$addBindingInfo = debugInfoEnabled ? function $$addBindingInfo($element, binding) {
                    var bindings = $element.data('$binding') || [];

                    if (isArray(binding)) {
                        bindings = bindings.concat(binding);
                    } else {
                        bindings.push(binding);
                    }

                    $element.data('$binding', bindings);
                } : noop;

                compile.$$addBindingClass = debugInfoEnabled ? function $$addBindingClass($element) {
                    safeAddClass($element, 'ng-binding');
                } : noop;

                compile.$$addScopeInfo = debugInfoEnabled ? function $$addScopeInfo($element, scope, isolated, noTemplate) {
                    var dataName = isolated ? (noTemplate ? '$isolateScopeNoTemplate' : '$isolateScope') : '$scope';
                    $element.data(dataName, scope);
                } : noop;

                compile.$$addScopeClass = debugInfoEnabled ? function $$addScopeClass($element, isolated) {
                    safeAddClass($element, isolated ? 'ng-isolate-scope' : 'ng-scope');
                } : noop;

                compile.$$createComment = function(directiveName, comment) {
                    var content = '';
                    if (debugInfoEnabled) {
                        content = ' ' + (directiveName || '') + ': ';
                        if (comment) content += comment + ' ';
                    }
                    return window.document.createComment(content);
                };

                return compile;

                //================================

                function compile($compileNodes, transcludeFn, maxPriority, ignoreDirective,
                                 previousCompileContext) {
                    if (!($compileNodes instanceof jqLite)) {
                        // jquery always rewraps, whereas we need to preserve the original selector so that we can
                        // modify it.
                        $compileNodes = jqLite($compileNodes);
                    }

                    var NOT_EMPTY = /\S+/;

                    // We can not compile top level text elements since text nodes can be merged and we will
                    // not be able to attach scope data to them, so we will wrap them in <span>
                    for (var i = 0, len = $compileNodes.length; i < len; i++) {
                        var domNode = $compileNodes[i];

                        if (domNode.nodeType === NODE_TYPE_TEXT && domNode.nodeValue.match(NOT_EMPTY) /* non-empty */) {
                            jqLiteWrapNode(domNode, $compileNodes[i] = window.document.createElement('span'));
                        }
                    }

                    var compositeLinkFn =
                        compileNodes($compileNodes, transcludeFn, $compileNodes,
                            maxPriority, ignoreDirective, previousCompileContext);
                    compile.$$addScopeClass($compileNodes);
                    var namespace = null;
                    return function publicLinkFn(scope, cloneConnectFn, options) {
                        assertArg(scope, 'scope');

                        if (previousCompileContext && previousCompileContext.needsNewScope) {
                            // A parent directive did a replace and a directive on this element asked
                            // for transclusion, which caused us to lose a layer of element on which
                            // we could hold the new transclusion scope, so we will create it manually
                            // here.
                            scope = scope.$parent.$new();
                        }

                        options = options || {};
                        var parentBoundTranscludeFn = options.parentBoundTranscludeFn,
                            transcludeControllers = options.transcludeControllers,
                            futureParentElement = options.futureParentElement;

                        // When `parentBoundTranscludeFn` is passed, it is a
                        // `controllersBoundTransclude` function (it was previously passed
                        // as `transclude` to directive.link) so we must unwrap it to get
                        // its `boundTranscludeFn`
                        if (parentBoundTranscludeFn && parentBoundTranscludeFn.$$boundTransclude) {
                            parentBoundTranscludeFn = parentBoundTranscludeFn.$$boundTransclude;
                        }

                        if (!namespace) {
                            namespace = detectNamespaceForChildElements(futureParentElement);
                        }
                        var $linkNode;
                        if (namespace !== 'html') {
                            // When using a directive with replace:true and templateUrl the $compileNodes
                            // (or a child element inside of them)
                            // might change, so we need to recreate the namespace adapted compileNodes
                            // for call to the link function.
                            // Note: This will already clone the nodes...
                            $linkNode = jqLite(
                                wrapTemplate(namespace, jqLite('<div>').append($compileNodes).html())
                            );
                        } else if (cloneConnectFn) {
                            // important!!: we must call our jqLite.clone() since the jQuery one is trying to be smart
                            // and sometimes changes the structure of the DOM.
                            $linkNode = JQLitePrototype.clone.call($compileNodes);
                        } else {
                            $linkNode = $compileNodes;
                        }

                        if (transcludeControllers) {
                            for (var controllerName in transcludeControllers) {
                                $linkNode.data('$' + controllerName + 'Controller', transcludeControllers[controllerName].instance);
                            }
                        }

                        compile.$$addScopeInfo($linkNode, scope);

                        if (cloneConnectFn) cloneConnectFn($linkNode, scope);
                        if (compositeLinkFn) compositeLinkFn(scope, $linkNode, $linkNode, parentBoundTranscludeFn);
                        return $linkNode;
                    };
                }

                function detectNamespaceForChildElements(parentElement) {
                    // TODO: Make this detect MathML as well...
                    var node = parentElement && parentElement[0];
                    if (!node) {
                        return 'html';
                    } else {
                        return nodeName_(node) !== 'foreignobject' && toString.call(node).match(/SVG/) ? 'svg' : 'html';
                    }
                }

                /**
                 * Compile function matches each node in nodeList against the directives. Once all directives
                 * for a particular node are collected their compile functions are executed. The compile
                 * functions return values - the linking functions - are combined into a composite linking
                 * function, which is the a linking function for the node.
                 *
                 * @param {NodeList} nodeList an array of nodes or NodeList to compile
                 * @param {function(angular.Scope, cloneAttachFn=)} transcludeFn A linking function, where the
                 *        scope argument is auto-generated to the new child of the transcluded parent scope.
                 * @param {DOMElement=} $rootElement If the nodeList is the root of the compilation tree then
                 *        the rootElement must be set the jqLite collection of the compile root. This is
                 *        needed so that the jqLite collection items can be replaced with widgets.
                 * @param {number=} maxPriority Max directive priority.
                 * @returns {Function} A composite linking function of all of the matched directives or null.
                 */
                function compileNodes(nodeList, transcludeFn, $rootElement, maxPriority, ignoreDirective,
                                      previousCompileContext) {
                    var linkFns = [],
                        attrs, directives, nodeLinkFn, childNodes, childLinkFn, linkFnFound, nodeLinkFnFound;

                    for (var i = 0; i < nodeList.length; i++) {
                        attrs = new Attributes();

                        // we must always refer to nodeList[i] since the nodes can be replaced underneath us.
                        directives = collectDirectives(nodeList[i], [], attrs, i === 0 ? maxPriority : undefined,
                            ignoreDirective);

                        nodeLinkFn = (directives.length)
                            ? applyDirectivesToNode(directives, nodeList[i], attrs, transcludeFn, $rootElement,
                            null, [], [], previousCompileContext)
                            : null;

                        if (nodeLinkFn && nodeLinkFn.scope) {
                            compile.$$addScopeClass(attrs.$$element);
                        }

                        childLinkFn = (nodeLinkFn && nodeLinkFn.terminal ||
                        !(childNodes = nodeList[i].childNodes) ||
                        !childNodes.length)
                            ? null
                            : compileNodes(childNodes,
                            nodeLinkFn ? (
                            (nodeLinkFn.transcludeOnThisElement || !nodeLinkFn.templateOnThisElement)
                            && nodeLinkFn.transclude) : transcludeFn);

                        if (nodeLinkFn || childLinkFn) {
                            linkFns.push(i, nodeLinkFn, childLinkFn);
                            linkFnFound = true;
                            nodeLinkFnFound = nodeLinkFnFound || nodeLinkFn;
                        }

                        //use the previous context only for the first element in the virtual group
                        previousCompileContext = null;
                    }

                    // return a linking function if we have found anything, null otherwise
                    return linkFnFound ? compositeLinkFn : null;

                    function compositeLinkFn(scope, nodeList, $rootElement, parentBoundTranscludeFn) {
                        var nodeLinkFn, childLinkFn, node, childScope, i, ii, idx, childBoundTranscludeFn;
                        var stableNodeList;


                        if (nodeLinkFnFound) {
                            // copy nodeList so that if a nodeLinkFn removes or adds an element at this DOM level our
                            // offsets don't get screwed up
                            var nodeListLength = nodeList.length;
                            stableNodeList = new Array(nodeListLength);

                            // create a sparse array by only copying the elements which have a linkFn
                            for (i = 0; i < linkFns.length; i += 3) {
                                idx = linkFns[i];
                                stableNodeList[idx] = nodeList[idx];
                            }
                        } else {
                            stableNodeList = nodeList;
                        }

                        for (i = 0, ii = linkFns.length; i < ii;) {
                            node = stableNodeList[linkFns[i++]];
                            nodeLinkFn = linkFns[i++];
                            childLinkFn = linkFns[i++];

                            if (nodeLinkFn) {
                                if (nodeLinkFn.scope) {
                                    childScope = scope.$new();
                                    compile.$$addScopeInfo(jqLite(node), childScope);
                                } else {
                                    childScope = scope;
                                }

                                if (nodeLinkFn.transcludeOnThisElement) {
                                    childBoundTranscludeFn = createBoundTranscludeFn(
                                        scope, nodeLinkFn.transclude, parentBoundTranscludeFn);

                                } else if (!nodeLinkFn.templateOnThisElement && parentBoundTranscludeFn) {
                                    childBoundTranscludeFn = parentBoundTranscludeFn;

                                } else if (!parentBoundTranscludeFn && transcludeFn) {
                                    childBoundTranscludeFn = createBoundTranscludeFn(scope, transcludeFn);

                                } else {
                                    childBoundTranscludeFn = null;
                                }

                                nodeLinkFn(childLinkFn, childScope, node, $rootElement, childBoundTranscludeFn);

                            } else if (childLinkFn) {
                                childLinkFn(scope, node.childNodes, undefined, parentBoundTranscludeFn);
                            }
                        }
                    }
                }

                function createBoundTranscludeFn(scope, transcludeFn, previousBoundTranscludeFn) {
                    function boundTranscludeFn(transcludedScope, cloneFn, controllers, futureParentElement, containingScope) {

                        if (!transcludedScope) {
                            transcludedScope = scope.$new(false, containingScope);
                            transcludedScope.$$transcluded = true;
                        }

                        return transcludeFn(transcludedScope, cloneFn, {
                            parentBoundTranscludeFn: previousBoundTranscludeFn,
                            transcludeControllers: controllers,
                            futureParentElement: futureParentElement
                        });
                    }

                    // We need  to attach the transclusion slots onto the `boundTranscludeFn`
                    // so that they are available inside the `controllersBoundTransclude` function
                    var boundSlots = boundTranscludeFn.$$slots = createMap();
                    for (var slotName in transcludeFn.$$slots) {
                        if (transcludeFn.$$slots[slotName]) {
                            boundSlots[slotName] = createBoundTranscludeFn(scope, transcludeFn.$$slots[slotName], previousBoundTranscludeFn);
                        } else {
                            boundSlots[slotName] = null;
                        }
                    }

                    return boundTranscludeFn;
                }

                /**
                 * Looks for directives on the given node and adds them to the directive collection which is
                 * sorted.
                 *
                 * @param node Node to search.
                 * @param directives An array to which the directives are added to. This array is sorted before
                 *        the function returns.
                 * @param attrs The shared attrs object which is used to populate the normalized attributes.
                 * @param {number=} maxPriority Max directive priority.
                 */
                function collectDirectives(node, directives, attrs, maxPriority, ignoreDirective) {
                    var nodeType = node.nodeType,
                        attrsMap = attrs.$attr,
                        match,
                        nodeName,
                        className;

                    switch (nodeType) {
                        case NODE_TYPE_ELEMENT: /* Element */

                            nodeName = nodeName_(node);

                            // use the node name: <directive>
                            addDirective(directives,
                                directiveNormalize(nodeName), 'E', maxPriority, ignoreDirective);

                            // iterate over the attributes
                            for (var attr, name, nName, ngAttrName, value, isNgAttr, nAttrs = node.attributes,
                                     j = 0, jj = nAttrs && nAttrs.length; j < jj; j++) {
                                var attrStartName = false;
                                var attrEndName = false;

                                attr = nAttrs[j];
                                name = attr.name;
                                value = trim(attr.value);

                                // support ngAttr attribute binding
                                ngAttrName = directiveNormalize(name);
                                isNgAttr = NG_ATTR_BINDING.test(ngAttrName);
                                if (isNgAttr) {
                                    name = name.replace(PREFIX_REGEXP, '')
                                        .substr(8).replace(/_(.)/g, function(match, letter) {
                                            return letter.toUpperCase();
                                        });
                                }

                                var multiElementMatch = ngAttrName.match(MULTI_ELEMENT_DIR_RE);
                                if (multiElementMatch && directiveIsMultiElement(multiElementMatch[1])) {
                                    attrStartName = name;
                                    attrEndName = name.substr(0, name.length - 5) + 'end';
                                    name = name.substr(0, name.length - 6);
                                }

                                nName = directiveNormalize(name.toLowerCase());
                                attrsMap[nName] = name;
                                if (isNgAttr || !attrs.hasOwnProperty(nName)) {
                                    attrs[nName] = value;
                                    if (getBooleanAttrName(node, nName)) {
                                        attrs[nName] = true; // presence means true
                                    }
                                }
                                addAttrInterpolateDirective(node, directives, value, nName, isNgAttr);
                                addDirective(directives, nName, 'A', maxPriority, ignoreDirective, attrStartName,
                                    attrEndName);
                            }

                            if (nodeName === 'input' && node.getAttribute('type') === 'hidden') {
                                // Hidden input elements can have strange behaviour when navigating back to the page
                                // This tells the browser not to try to cache and reinstate previous values
                                node.setAttribute('autocomplete', 'off');
                            }

                            // use class as directive
                            if (!cssClassDirectivesEnabled) break;
                            className = node.className;
                            if (isObject(className)) {
                                // Maybe SVGAnimatedString
                                className = className.animVal;
                            }
                            if (isString(className) && className !== '') {
                                while ((match = CLASS_DIRECTIVE_REGEXP.exec(className))) {
                                    nName = directiveNormalize(match[2]);
                                    if (addDirective(directives, nName, 'C', maxPriority, ignoreDirective)) {
                                        attrs[nName] = trim(match[3]);
                                    }
                                    className = className.substr(match.index + match[0].length);
                                }
                            }
                            break;
                        case NODE_TYPE_TEXT: /* Text Node */
                            if (msie === 11) {
                                // Workaround for #11781
                                while (node.parentNode && node.nextSibling && node.nextSibling.nodeType === NODE_TYPE_TEXT) {
                                    node.nodeValue = node.nodeValue + node.nextSibling.nodeValue;
                                    node.parentNode.removeChild(node.nextSibling);
                                }
                            }
                            addTextInterpolateDirective(directives, node.nodeValue);
                            break;
                        case NODE_TYPE_COMMENT: /* Comment */
                            if (!commentDirectivesEnabled) break;
                            collectCommentDirectives(node, directives, attrs, maxPriority, ignoreDirective);
                            break;
                    }

                    directives.sort(byPriority);
                    return directives;
                }

                function collectCommentDirectives(node, directives, attrs, maxPriority, ignoreDirective) {
                    // function created because of performance, try/catch disables
                    // the optimization of the whole function #14848
                    try {
                        var match = COMMENT_DIRECTIVE_REGEXP.exec(node.nodeValue);
                        if (match) {
                            var nName = directiveNormalize(match[1]);
                            if (addDirective(directives, nName, 'M', maxPriority, ignoreDirective)) {
                                attrs[nName] = trim(match[2]);
                            }
                        }
                    } catch (e) {
                        // turns out that under some circumstances IE9 throws errors when one attempts to read
                        // comment's node value.
                        // Just ignore it and continue. (Can't seem to reproduce in test case.)
                    }
                }

                /**
                 * Given a node with an directive-start it collects all of the siblings until it finds
                 * directive-end.
                 * @param node
                 * @param attrStart
                 * @param attrEnd
                 * @returns {*}
                 */
                function groupScan(node, attrStart, attrEnd) {
                    var nodes = [];
                    var depth = 0;
                    if (attrStart && node.hasAttribute && node.hasAttribute(attrStart)) {
                        do {
                            if (!node) {
                                throw $compileMinErr('uterdir',
                                    'Unterminated attribute, found \'{0}\' but no matching \'{1}\' found.',
                                    attrStart, attrEnd);
                            }
                            if (node.nodeType === NODE_TYPE_ELEMENT) {
                                if (node.hasAttribute(attrStart)) depth++;
                                if (node.hasAttribute(attrEnd)) depth--;
                            }
                            nodes.push(node);
                            node = node.nextSibling;
                        } while (depth > 0);
                    } else {
                        nodes.push(node);
                    }

                    return jqLite(nodes);
                }

                /**
                 * Wrapper for linking function which converts normal linking function into a grouped
                 * linking function.
                 * @param linkFn
                 * @param attrStart
                 * @param attrEnd
                 * @returns {Function}
                 */
                function groupElementsLinkFnWrapper(linkFn, attrStart, attrEnd) {
                    return function groupedElementsLink(scope, element, attrs, controllers, transcludeFn) {
                        element = groupScan(element[0], attrStart, attrEnd);
                        return linkFn(scope, element, attrs, controllers, transcludeFn);
                    };
                }

                /**
                 * A function generator that is used to support both eager and lazy compilation
                 * linking function.
                 * @param eager
                 * @param $compileNodes
                 * @param transcludeFn
                 * @param maxPriority
                 * @param ignoreDirective
                 * @param previousCompileContext
                 * @returns {Function}
                 */
                function compilationGenerator(eager, $compileNodes, transcludeFn, maxPriority, ignoreDirective, previousCompileContext) {
                    var compiled;

                    if (eager) {
                        return compile($compileNodes, transcludeFn, maxPriority, ignoreDirective, previousCompileContext);
                    }
                    return /** @this */ function lazyCompilation() {
                        if (!compiled) {
                            compiled = compile($compileNodes, transcludeFn, maxPriority, ignoreDirective, previousCompileContext);

                            // Null out all of these references in order to make them eligible for garbage collection
                            // since this is a potentially long lived closure
                            $compileNodes = transcludeFn = previousCompileContext = null;
                        }
                        return compiled.apply(this, arguments);
                    };
                }

                /**
                 * Once the directives have been collected, their compile functions are executed. This method
                 * is responsible for inlining directive templates as well as terminating the application
                 * of the directives if the terminal directive has been reached.
                 *
                 * @param {Array} directives Array of collected directives to execute their compile function.
                 *        this needs to be pre-sorted by priority order.
                 * @param {Node} compileNode The raw DOM node to apply the compile functions to
                 * @param {Object} templateAttrs The shared attribute function
                 * @param {function(angular.Scope, cloneAttachFn=)} transcludeFn A linking function, where the
                 *                                                  scope argument is auto-generated to the new
                 *                                                  child of the transcluded parent scope.
                 * @param {JQLite} jqCollection If we are working on the root of the compile tree then this
                 *                              argument has the root jqLite array so that we can replace nodes
                 *                              on it.
                 * @param {Object=} originalReplaceDirective An optional directive that will be ignored when
                 *                                           compiling the transclusion.
                 * @param {Array.<Function>} preLinkFns
                 * @param {Array.<Function>} postLinkFns
                 * @param {Object} previousCompileContext Context used for previous compilation of the current
                 *                                        node
                 * @returns {Function} linkFn
                 */
                function applyDirectivesToNode(directives, compileNode, templateAttrs, transcludeFn,
                                               jqCollection, originalReplaceDirective, preLinkFns, postLinkFns,
                                               previousCompileContext) {
                    previousCompileContext = previousCompileContext || {};

                    var terminalPriority = -Number.MAX_VALUE,
                        newScopeDirective = previousCompileContext.newScopeDirective,
                        controllerDirectives = previousCompileContext.controllerDirectives,
                        newIsolateScopeDirective = previousCompileContext.newIsolateScopeDirective,
                        templateDirective = previousCompileContext.templateDirective,
                        nonTlbTranscludeDirective = previousCompileContext.nonTlbTranscludeDirective,
                        hasTranscludeDirective = false,
                        hasTemplate = false,
                        hasElementTranscludeDirective = previousCompileContext.hasElementTranscludeDirective,
                        $compileNode = templateAttrs.$$element = jqLite(compileNode),
                        directive,
                        directiveName,
                        $template,
                        replaceDirective = originalReplaceDirective,
                        childTranscludeFn = transcludeFn,
                        linkFn,
                        didScanForMultipleTransclusion = false,
                        mightHaveMultipleTransclusionError = false,
                        directiveValue;

                    // executes all directives on the current element
                    for (var i = 0, ii = directives.length; i < ii; i++) {
                        directive = directives[i];
                        var attrStart = directive.$$start;
                        var attrEnd = directive.$$end;

                        // collect multiblock sections
                        if (attrStart) {
                            $compileNode = groupScan(compileNode, attrStart, attrEnd);
                        }
                        $template = undefined;

                        if (terminalPriority > directive.priority) {
                            break; // prevent further processing of directives
                        }

                        directiveValue = directive.scope;

                        if (directiveValue) {

                            // skip the check for directives with async templates, we'll check the derived sync
                            // directive when the template arrives
                            if (!directive.templateUrl) {
                                if (isObject(directiveValue)) {
                                    // This directive is trying to add an isolated scope.
                                    // Check that there is no scope of any kind already
                                    assertNoDuplicate('new/isolated scope', newIsolateScopeDirective || newScopeDirective,
                                        directive, $compileNode);
                                    newIsolateScopeDirective = directive;
                                } else {
                                    // This directive is trying to add a child scope.
                                    // Check that there is no isolated scope already
                                    assertNoDuplicate('new/isolated scope', newIsolateScopeDirective, directive,
                                        $compileNode);
                                }
                            }

                            newScopeDirective = newScopeDirective || directive;
                        }

                        directiveName = directive.name;

                        // If we encounter a condition that can result in transclusion on the directive,
                        // then scan ahead in the remaining directives for others that may cause a multiple
                        // transclusion error to be thrown during the compilation process.  If a matching directive
                        // is found, then we know that when we encounter a transcluded directive, we need to eagerly
                        // compile the `transclude` function rather than doing it lazily in order to throw
                        // exceptions at the correct time
                        if (!didScanForMultipleTransclusion && ((directive.replace && (directive.templateUrl || directive.template))
                            || (directive.transclude && !directive.$$tlb))) {
                            var candidateDirective;

                            for (var scanningIndex = i + 1; (candidateDirective = directives[scanningIndex++]);) {
                                if ((candidateDirective.transclude && !candidateDirective.$$tlb)
                                    || (candidateDirective.replace && (candidateDirective.templateUrl || candidateDirective.template))) {
                                    mightHaveMultipleTransclusionError = true;
                                    break;
                                }
                            }

                            didScanForMultipleTransclusion = true;
                        }

                        if (!directive.templateUrl && directive.controller) {
                            directiveValue = directive.controller;
                            controllerDirectives = controllerDirectives || createMap();
                            assertNoDuplicate('\'' + directiveName + '\' controller',
                                controllerDirectives[directiveName], directive, $compileNode);
                            controllerDirectives[directiveName] = directive;
                        }

                        directiveValue = directive.transclude;

                        if (directiveValue) {
                            hasTranscludeDirective = true;

                            // Special case ngIf and ngRepeat so that we don't complain about duplicate transclusion.
                            // This option should only be used by directives that know how to safely handle element transclusion,
                            // where the transcluded nodes are added or replaced after linking.
                            if (!directive.$$tlb) {
                                assertNoDuplicate('transclusion', nonTlbTranscludeDirective, directive, $compileNode);
                                nonTlbTranscludeDirective = directive;
                            }

                            if (directiveValue === 'element') {
                                hasElementTranscludeDirective = true;
                                terminalPriority = directive.priority;
                                $template = $compileNode;
                                $compileNode = templateAttrs.$$element =
                                    jqLite(compile.$$createComment(directiveName, templateAttrs[directiveName]));
                                compileNode = $compileNode[0];
                                replaceWith(jqCollection, sliceArgs($template), compileNode);

                                // Support: Chrome < 50
                                // https://github.com/angular/angular.js/issues/14041

                                // In the versions of V8 prior to Chrome 50, the document fragment that is created
                                // in the `replaceWith` function is improperly garbage collected despite still
                                // being referenced by the `parentNode` property of all of the child nodes.  By adding
                                // a reference to the fragment via a different property, we can avoid that incorrect
                                // behavior.
                                // TODO: remove this line after Chrome 50 has been released
                                $template[0].$$parentNode = $template[0].parentNode;

                                childTranscludeFn = compilationGenerator(mightHaveMultipleTransclusionError, $template, transcludeFn, terminalPriority,
                                    replaceDirective && replaceDirective.name, {
                                        // Don't pass in:
                                        // - controllerDirectives - otherwise we'll create duplicates controllers
                                        // - newIsolateScopeDirective or templateDirective - combining templates with
                                        //   element transclusion doesn't make sense.
                                        //
                                        // We need only nonTlbTranscludeDirective so that we prevent putting transclusion
                                        // on the same element more than once.
                                        nonTlbTranscludeDirective: nonTlbTranscludeDirective
                                    });
                            } else {

                                var slots = createMap();

                                $template = jqLite(jqLiteClone(compileNode)).contents();

                                if (isObject(directiveValue)) {

                                    // We have transclusion slots,
                                    // collect them up, compile them and store their transclusion functions
                                    $template = [];

                                    var slotMap = createMap();
                                    var filledSlots = createMap();

                                    // Parse the element selectors
                                    forEach(directiveValue, function(elementSelector, slotName) {
                                        // If an element selector starts with a ? then it is optional
                                        var optional = (elementSelector.charAt(0) === '?');
                                        elementSelector = optional ? elementSelector.substring(1) : elementSelector;

                                        slotMap[elementSelector] = slotName;

                                        // We explicitly assign `null` since this implies that a slot was defined but not filled.
                                        // Later when calling boundTransclusion functions with a slot name we only error if the
                                        // slot is `undefined`
                                        slots[slotName] = null;

                                        // filledSlots contains `true` for all slots that are either optional or have been
                                        // filled. This is used to check that we have not missed any required slots
                                        filledSlots[slotName] = optional;
                                    });

                                    // Add the matching elements into their slot
                                    forEach($compileNode.contents(), function(node) {
                                        var slotName = slotMap[directiveNormalize(nodeName_(node))];
                                        if (slotName) {
                                            filledSlots[slotName] = true;
                                            slots[slotName] = slots[slotName] || [];
                                            slots[slotName].push(node);
                                        } else {
                                            $template.push(node);
                                        }
                                    });

                                    // Check for required slots that were not filled
                                    forEach(filledSlots, function(filled, slotName) {
                                        if (!filled) {
                                            throw $compileMinErr('reqslot', 'Required transclusion slot `{0}` was not filled.', slotName);
                                        }
                                    });

                                    for (var slotName in slots) {
                                        if (slots[slotName]) {
                                            // Only define a transclusion function if the slot was filled
                                            slots[slotName] = compilationGenerator(mightHaveMultipleTransclusionError, slots[slotName], transcludeFn);
                                        }
                                    }
                                }

                                $compileNode.empty(); // clear contents
                                childTranscludeFn = compilationGenerator(mightHaveMultipleTransclusionError, $template, transcludeFn, undefined,
                                    undefined, { needsNewScope: directive.$$isolateScope || directive.$$newScope});
                                childTranscludeFn.$$slots = slots;
                            }
                        }

                        if (directive.template) {
                            hasTemplate = true;
                            assertNoDuplicate('template', templateDirective, directive, $compileNode);
                            templateDirective = directive;

                            directiveValue = (isFunction(directive.template))
                                ? directive.template($compileNode, templateAttrs)
                                : directive.template;

                            directiveValue = denormalizeTemplate(directiveValue);

                            if (directive.replace) {
                                replaceDirective = directive;
                                if (jqLiteIsTextNode(directiveValue)) {
                                    $template = [];
                                } else {
                                    $template = removeComments(wrapTemplate(directive.templateNamespace, trim(directiveValue)));
                                }
                                compileNode = $template[0];

                                if ($template.length !== 1 || compileNode.nodeType !== NODE_TYPE_ELEMENT) {
                                    throw $compileMinErr('tplrt',
                                        'Template for directive \'{0}\' must have exactly one root element. {1}',
                                        directiveName, '');
                                }

                                replaceWith(jqCollection, $compileNode, compileNode);

                                var newTemplateAttrs = {$attr: {}};

                                // combine directives from the original node and from the template:
                                // - take the array of directives for this element
                                // - split it into two parts, those that already applied (processed) and those that weren't (unprocessed)
                                // - collect directives from the template and sort them by priority
                                // - combine directives as: processed + template + unprocessed
                                var templateDirectives = collectDirectives(compileNode, [], newTemplateAttrs);
                                var unprocessedDirectives = directives.splice(i + 1, directives.length - (i + 1));

                                if (newIsolateScopeDirective || newScopeDirective) {
                                    // The original directive caused the current element to be replaced but this element
                                    // also needs to have a new scope, so we need to tell the template directives
                                    // that they would need to get their scope from further up, if they require transclusion
                                    markDirectiveScope(templateDirectives, newIsolateScopeDirective, newScopeDirective);
                                }
                                directives = directives.concat(templateDirectives).concat(unprocessedDirectives);
                                mergeTemplateAttributes(templateAttrs, newTemplateAttrs);

                                ii = directives.length;
                            } else {
                                $compileNode.html(directiveValue);
                            }
                        }

                        if (directive.templateUrl) {
                            hasTemplate = true;
                            assertNoDuplicate('template', templateDirective, directive, $compileNode);
                            templateDirective = directive;

                            if (directive.replace) {
                                replaceDirective = directive;
                            }

                            // eslint-disable-next-line no-func-assign
                            nodeLinkFn = compileTemplateUrl(directives.splice(i, directives.length - i), $compileNode,
                                templateAttrs, jqCollection, hasTranscludeDirective && childTranscludeFn, preLinkFns, postLinkFns, {
                                    controllerDirectives: controllerDirectives,
                                    newScopeDirective: (newScopeDirective !== directive) && newScopeDirective,
                                    newIsolateScopeDirective: newIsolateScopeDirective,
                                    templateDirective: templateDirective,
                                    nonTlbTranscludeDirective: nonTlbTranscludeDirective
                                });
                            ii = directives.length;
                        } else if (directive.compile) {
                            try {
                                linkFn = directive.compile($compileNode, templateAttrs, childTranscludeFn);
                                var context = directive.$$originalDirective || directive;
                                if (isFunction(linkFn)) {
                                    addLinkFns(null, bind(context, linkFn), attrStart, attrEnd);
                                } else if (linkFn) {
                                    addLinkFns(bind(context, linkFn.pre), bind(context, linkFn.post), attrStart, attrEnd);
                                }
                            } catch (e) {
                                $exceptionHandler(e, startingTag($compileNode));
                            }
                        }

                        if (directive.terminal) {
                            nodeLinkFn.terminal = true;
                            terminalPriority = Math.max(terminalPriority, directive.priority);
                        }

                    }

                    nodeLinkFn.scope = newScopeDirective && newScopeDirective.scope === true;
                    nodeLinkFn.transcludeOnThisElement = hasTranscludeDirective;
                    nodeLinkFn.templateOnThisElement = hasTemplate;
                    nodeLinkFn.transclude = childTranscludeFn;

                    previousCompileContext.hasElementTranscludeDirective = hasElementTranscludeDirective;

                    // might be normal or delayed nodeLinkFn depending on if templateUrl is present
                    return nodeLinkFn;

                    ////////////////////

                    function addLinkFns(pre, post, attrStart, attrEnd) {
                        if (pre) {
                            if (attrStart) pre = groupElementsLinkFnWrapper(pre, attrStart, attrEnd);
                            pre.require = directive.require;
                            pre.directiveName = directiveName;
                            if (newIsolateScopeDirective === directive || directive.$$isolateScope) {
                                pre = cloneAndAnnotateFn(pre, {isolateScope: true});
                            }
                            preLinkFns.push(pre);
                        }
                        if (post) {
                            if (attrStart) post = groupElementsLinkFnWrapper(post, attrStart, attrEnd);
                            post.require = directive.require;
                            post.directiveName = directiveName;
                            if (newIsolateScopeDirective === directive || directive.$$isolateScope) {
                                post = cloneAndAnnotateFn(post, {isolateScope: true});
                            }
                            postLinkFns.push(post);
                        }
                    }

                    function nodeLinkFn(childLinkFn, scope, linkNode, $rootElement, boundTranscludeFn) {
                        var i, ii, linkFn, isolateScope, controllerScope, elementControllers, transcludeFn, $element,
                            attrs, scopeBindingInfo;

                        if (compileNode === linkNode) {
                            attrs = templateAttrs;
                            $element = templateAttrs.$$element;
                        } else {
                            $element = jqLite(linkNode);
                            attrs = new Attributes($element, templateAttrs);
                        }

                        controllerScope = scope;
                        if (newIsolateScopeDirective) {
                            isolateScope = scope.$new(true);
                        } else if (newScopeDirective) {
                            controllerScope = scope.$parent;
                        }

                        if (boundTranscludeFn) {
                            // track `boundTranscludeFn` so it can be unwrapped if `transcludeFn`
                            // is later passed as `parentBoundTranscludeFn` to `publicLinkFn`
                            transcludeFn = controllersBoundTransclude;
                            transcludeFn.$$boundTransclude = boundTranscludeFn;
                            // expose the slots on the `$transclude` function
                            transcludeFn.isSlotFilled = function(slotName) {
                                return !!boundTranscludeFn.$$slots[slotName];
                            };
                        }

                        if (controllerDirectives) {
                            elementControllers = setupControllers($element, attrs, transcludeFn, controllerDirectives, isolateScope, scope, newIsolateScopeDirective);
                        }

                        if (newIsolateScopeDirective) {
                            // Initialize isolate scope bindings for new isolate scope directive.
                            compile.$$addScopeInfo($element, isolateScope, true, !(templateDirective && (templateDirective === newIsolateScopeDirective ||
                            templateDirective === newIsolateScopeDirective.$$originalDirective)));
                            compile.$$addScopeClass($element, true);
                            isolateScope.$$isolateBindings =
                                newIsolateScopeDirective.$$isolateBindings;
                            scopeBindingInfo = initializeDirectiveBindings(scope, attrs, isolateScope,
                                isolateScope.$$isolateBindings,
                                newIsolateScopeDirective);
                            if (scopeBindingInfo.removeWatches) {
                                isolateScope.$on('$destroy', scopeBindingInfo.removeWatches);
                            }
                        }

                        // Initialize bindToController bindings
                        for (var name in elementControllers) {
                            var controllerDirective = controllerDirectives[name];
                            var controller = elementControllers[name];
                            var bindings = controllerDirective.$$bindings.bindToController;

                            if (controller.identifier && bindings) {
                                controller.bindingInfo =
                                    initializeDirectiveBindings(controllerScope, attrs, controller.instance, bindings, controllerDirective);
                            } else {
                                controller.bindingInfo = {};
                            }

                            var controllerResult = controller();
                            if (controllerResult !== controller.instance) {
                                // If the controller constructor has a return value, overwrite the instance
                                // from setupControllers
                                controller.instance = controllerResult;
                                $element.data('$' + controllerDirective.name + 'Controller', controllerResult);
                                if (controller.bindingInfo.removeWatches) {
                                    controller.bindingInfo.removeWatches();
                                }
                                controller.bindingInfo =
                                    initializeDirectiveBindings(controllerScope, attrs, controller.instance, bindings, controllerDirective);
                            }
                        }

                        // Bind the required controllers to the controller, if `require` is an object and `bindToController` is truthy
                        forEach(controllerDirectives, function(controllerDirective, name) {
                            var require = controllerDirective.require;
                            if (controllerDirective.bindToController && !isArray(require) && isObject(require)) {
                                extend(elementControllers[name].instance, getControllers(name, require, $element, elementControllers));
                            }
                        });

                        // Handle the init and destroy lifecycle hooks on all controllers that have them
                        forEach(elementControllers, function(controller) {
                            var controllerInstance = controller.instance;
                            if (isFunction(controllerInstance.$onChanges)) {
                                try {
                                    controllerInstance.$onChanges(controller.bindingInfo.initialChanges);
                                } catch (e) {
                                    $exceptionHandler(e);
                                }
                            }
                            if (isFunction(controllerInstance.$onInit)) {
                                try {
                                    controllerInstance.$onInit();
                                } catch (e) {
                                    $exceptionHandler(e);
                                }
                            }
                            if (isFunction(controllerInstance.$doCheck)) {
                                controllerScope.$watch(function() { controllerInstance.$doCheck(); });
                                controllerInstance.$doCheck();
                            }
                            if (isFunction(controllerInstance.$onDestroy)) {
                                controllerScope.$on('$destroy', function callOnDestroyHook() {
                                    controllerInstance.$onDestroy();
                                });
                            }
                        });

                        // PRELINKING
                        for (i = 0, ii = preLinkFns.length; i < ii; i++) {
                            linkFn = preLinkFns[i];
                            invokeLinkFn(linkFn,
                                linkFn.isolateScope ? isolateScope : scope,
                                $element,
                                attrs,
                                linkFn.require && getControllers(linkFn.directiveName, linkFn.require, $element, elementControllers),
                                transcludeFn
                            );
                        }

                        // RECURSION
                        // We only pass the isolate scope, if the isolate directive has a template,
                        // otherwise the child elements do not belong to the isolate directive.
                        var scopeToChild = scope;
                        if (newIsolateScopeDirective && (newIsolateScopeDirective.template || newIsolateScopeDirective.templateUrl === null)) {
                            scopeToChild = isolateScope;
                        }
                        if (childLinkFn) {
                            childLinkFn(scopeToChild, linkNode.childNodes, undefined, boundTranscludeFn);
                        }

                        // POSTLINKING
                        for (i = postLinkFns.length - 1; i >= 0; i--) {
                            linkFn = postLinkFns[i];
                            invokeLinkFn(linkFn,
                                linkFn.isolateScope ? isolateScope : scope,
                                $element,
                                attrs,
                                linkFn.require && getControllers(linkFn.directiveName, linkFn.require, $element, elementControllers),
                                transcludeFn
                            );
                        }

                        // Trigger $postLink lifecycle hooks
                        forEach(elementControllers, function(controller) {
                            var controllerInstance = controller.instance;
                            if (isFunction(controllerInstance.$postLink)) {
                                controllerInstance.$postLink();
                            }
                        });

                        // This is the function that is injected as `$transclude`.
                        // Note: all arguments are optional!
                        function controllersBoundTransclude(scope, cloneAttachFn, futureParentElement, slotName) {
                            var transcludeControllers;
                            // No scope passed in:
                            if (!isScope(scope)) {
                                slotName = futureParentElement;
                                futureParentElement = cloneAttachFn;
                                cloneAttachFn = scope;
                                scope = undefined;
                            }

                            if (hasElementTranscludeDirective) {
                                transcludeControllers = elementControllers;
                            }
                            if (!futureParentElement) {
                                futureParentElement = hasElementTranscludeDirective ? $element.parent() : $element;
                            }
                            if (slotName) {
                                // slotTranscludeFn can be one of three things:
                                //  * a transclude function - a filled slot
                                //  * `null` - an optional slot that was not filled
                                //  * `undefined` - a slot that was not declared (i.e. invalid)
                                var slotTranscludeFn = boundTranscludeFn.$$slots[slotName];
                                if (slotTranscludeFn) {
                                    return slotTranscludeFn(scope, cloneAttachFn, transcludeControllers, futureParentElement, scopeToChild);
                                } else if (isUndefined(slotTranscludeFn)) {
                                    throw $compileMinErr('noslot',
                                        'No parent directive that requires a transclusion with slot name "{0}". ' +
                                        'Element: {1}',
                                        slotName, startingTag($element));
                                }
                            } else {
                                return boundTranscludeFn(scope, cloneAttachFn, transcludeControllers, futureParentElement, scopeToChild);
                            }
                        }
                    }
                }

                function getControllers(directiveName, require, $element, elementControllers) {
                    var value;

                    if (isString(require)) {
                        var match = require.match(REQUIRE_PREFIX_REGEXP);
                        var name = require.substring(match[0].length);
                        var inheritType = match[1] || match[3];
                        var optional = match[2] === '?';

                        //If only parents then start at the parent element
                        if (inheritType === '^^') {
                            $element = $element.parent();
                            //Otherwise attempt getting the controller from elementControllers in case
                            //the element is transcluded (and has no data) and to avoid .data if possible
                        } else {
                            value = elementControllers && elementControllers[name];
                            value = value && value.instance;
                        }

                        if (!value) {
                            var dataName = '$' + name + 'Controller';
                            value = inheritType ? $element.inheritedData(dataName) : $element.data(dataName);
                        }

                        if (!value && !optional) {
                            throw $compileMinErr('ctreq',
                                'Controller \'{0}\', required by directive \'{1}\', can\'t be found!',
                                name, directiveName);
                        }
                    } else if (isArray(require)) {
                        value = [];
                        for (var i = 0, ii = require.length; i < ii; i++) {
                            value[i] = getControllers(directiveName, require[i], $element, elementControllers);
                        }
                    } else if (isObject(require)) {
                        value = {};
                        forEach(require, function(controller, property) {
                            value[property] = getControllers(directiveName, controller, $element, elementControllers);
                        });
                    }

                    return value || null;
                }

                function setupControllers($element, attrs, transcludeFn, controllerDirectives, isolateScope, scope, newIsolateScopeDirective) {
                    var elementControllers = createMap();
                    for (var controllerKey in controllerDirectives) {
                        var directive = controllerDirectives[controllerKey];
                        var locals = {
                            $scope: directive === newIsolateScopeDirective || directive.$$isolateScope ? isolateScope : scope,
                            $element: $element,
                            $attrs: attrs,
                            $transclude: transcludeFn
                        };

                        var controller = directive.controller;
                        if (controller === '@') {
                            controller = attrs[directive.name];
                        }

                        var controllerInstance = $controller(controller, locals, true, directive.controllerAs);

                        // For directives with element transclusion the element is a comment.
                        // In this case .data will not attach any data.
                        // Instead, we save the controllers for the element in a local hash and attach to .data
                        // later, once we have the actual element.
                        elementControllers[directive.name] = controllerInstance;
                        $element.data('$' + directive.name + 'Controller', controllerInstance.instance);
                    }
                    return elementControllers;
                }

                // Depending upon the context in which a directive finds itself it might need to have a new isolated
                // or child scope created. For instance:
                // * if the directive has been pulled into a template because another directive with a higher priority
                // asked for element transclusion
                // * if the directive itself asks for transclusion but it is at the root of a template and the original
                // element was replaced. See https://github.com/angular/angular.js/issues/12936
                function markDirectiveScope(directives, isolateScope, newScope) {
                    for (var j = 0, jj = directives.length; j < jj; j++) {
                        directives[j] = inherit(directives[j], {$$isolateScope: isolateScope, $$newScope: newScope});
                    }
                }

                /**
                 * looks up the directive and decorates it with exception handling and proper parameters. We
                 * call this the boundDirective.
                 *
                 * @param {string} name name of the directive to look up.
                 * @param {string} location The directive must be found in specific format.
                 *   String containing any of theses characters:
                 *
                 *   * `E`: element name
                 *   * `A': attribute
                 *   * `C`: class
                 *   * `M`: comment
                 * @returns {boolean} true if directive was added.
                 */
                function addDirective(tDirectives, name, location, maxPriority, ignoreDirective, startAttrName,
                                      endAttrName) {
                    if (name === ignoreDirective) return null;
                    var match = null;
                    if (hasDirectives.hasOwnProperty(name)) {
                        for (var directive, directives = $injector.get(name + Suffix),
                                 i = 0, ii = directives.length; i < ii; i++) {
                            try {
                                directive = directives[i];
                                if ((isUndefined(maxPriority) || maxPriority > directive.priority) &&
                                    directive.restrict.indexOf(location) !== -1) {
                                    if (startAttrName) {
                                        directive = inherit(directive, {$$start: startAttrName, $$end: endAttrName});
                                    }
                                    if (!directive.$$bindings) {
                                        var bindings = directive.$$bindings =
                                            parseDirectiveBindings(directive, directive.name);
                                        if (isObject(bindings.isolateScope)) {
                                            directive.$$isolateBindings = bindings.isolateScope;
                                        }
                                    }
                                    tDirectives.push(directive);
                                    match = directive;
                                }
                            } catch (e) { $exceptionHandler(e); }
                        }
                    }
                    return match;
                }


                /**
                 * looks up the directive and returns true if it is a multi-element directive,
                 * and therefore requires DOM nodes between -start and -end markers to be grouped
                 * together.
                 *
                 * @param {string} name name of the directive to look up.
                 * @returns true if directive was registered as multi-element.
                 */
                function directiveIsMultiElement(name) {
                    if (hasDirectives.hasOwnProperty(name)) {
                        for (var directive, directives = $injector.get(name + Suffix),
                                 i = 0, ii = directives.length; i < ii; i++) {
                            directive = directives[i];
                            if (directive.multiElement) {
                                return true;
                            }
                        }
                    }
                    return false;
                }

                /**
                 * When the element is replaced with HTML template then the new attributes
                 * on the template need to be merged with the existing attributes in the DOM.
                 * The desired effect is to have both of the attributes present.
                 *
                 * @param {object} dst destination attributes (original DOM)
                 * @param {object} src source attributes (from the directive template)
                 */
                function mergeTemplateAttributes(dst, src) {
                    var srcAttr = src.$attr,
                        dstAttr = dst.$attr;

                    // reapply the old attributes to the new element
                    forEach(dst, function(value, key) {
                        if (key.charAt(0) !== '$') {
                            if (src[key] && src[key] !== value) {
                                value += (key === 'style' ? ';' : ' ') + src[key];
                            }
                            dst.$set(key, value, true, srcAttr[key]);
                        }
                    });

                    // copy the new attributes on the old attrs object
                    forEach(src, function(value, key) {
                        // Check if we already set this attribute in the loop above.
                        // `dst` will never contain hasOwnProperty as DOM parser won't let it.
                        // You will get an "InvalidCharacterError: DOM Exception 5" error if you
                        // have an attribute like "has-own-property" or "data-has-own-property", etc.
                        if (!dst.hasOwnProperty(key) && key.charAt(0) !== '$') {
                            dst[key] = value;

                            if (key !== 'class' && key !== 'style') {
                                dstAttr[key] = srcAttr[key];
                            }
                        }
                    });
                }


                function compileTemplateUrl(directives, $compileNode, tAttrs,
                                            $rootElement, childTranscludeFn, preLinkFns, postLinkFns, previousCompileContext) {
                    var linkQueue = [],
                        afterTemplateNodeLinkFn,
                        afterTemplateChildLinkFn,
                        beforeTemplateCompileNode = $compileNode[0],
                        origAsyncDirective = directives.shift(),
                        derivedSyncDirective = inherit(origAsyncDirective, {
                            templateUrl: null, transclude: null, replace: null, $$originalDirective: origAsyncDirective
                        }),
                        templateUrl = (isFunction(origAsyncDirective.templateUrl))
                            ? origAsyncDirective.templateUrl($compileNode, tAttrs)
                            : origAsyncDirective.templateUrl,
                        templateNamespace = origAsyncDirective.templateNamespace;

                    $compileNode.empty();

                    $templateRequest(templateUrl)
                        .then(function(content) {
                            var compileNode, tempTemplateAttrs, $template, childBoundTranscludeFn;

                            content = denormalizeTemplate(content);

                            if (origAsyncDirective.replace) {
                                if (jqLiteIsTextNode(content)) {
                                    $template = [];
                                } else {
                                    $template = removeComments(wrapTemplate(templateNamespace, trim(content)));
                                }
                                compileNode = $template[0];

                                if ($template.length !== 1 || compileNode.nodeType !== NODE_TYPE_ELEMENT) {
                                    throw $compileMinErr('tplrt',
                                        'Template for directive \'{0}\' must have exactly one root element. {1}',
                                        origAsyncDirective.name, templateUrl);
                                }

                                tempTemplateAttrs = {$attr: {}};
                                replaceWith($rootElement, $compileNode, compileNode);
                                var templateDirectives = collectDirectives(compileNode, [], tempTemplateAttrs);

                                if (isObject(origAsyncDirective.scope)) {
                                    // the original directive that caused the template to be loaded async required
                                    // an isolate scope
                                    markDirectiveScope(templateDirectives, true);
                                }
                                directives = templateDirectives.concat(directives);
                                mergeTemplateAttributes(tAttrs, tempTemplateAttrs);
                            } else {
                                compileNode = beforeTemplateCompileNode;
                                $compileNode.html(content);
                            }

                            directives.unshift(derivedSyncDirective);

                            afterTemplateNodeLinkFn = applyDirectivesToNode(directives, compileNode, tAttrs,
                                childTranscludeFn, $compileNode, origAsyncDirective, preLinkFns, postLinkFns,
                                previousCompileContext);
                            forEach($rootElement, function(node, i) {
                                if (node === compileNode) {
                                    $rootElement[i] = $compileNode[0];
                                }
                            });
                            afterTemplateChildLinkFn = compileNodes($compileNode[0].childNodes, childTranscludeFn);

                            while (linkQueue.length) {
                                var scope = linkQueue.shift(),
                                    beforeTemplateLinkNode = linkQueue.shift(),
                                    linkRootElement = linkQueue.shift(),
                                    boundTranscludeFn = linkQueue.shift(),
                                    linkNode = $compileNode[0];

                                if (scope.$$destroyed) continue;

                                if (beforeTemplateLinkNode !== beforeTemplateCompileNode) {
                                    var oldClasses = beforeTemplateLinkNode.className;

                                    if (!(previousCompileContext.hasElementTranscludeDirective &&
                                        origAsyncDirective.replace)) {
                                        // it was cloned therefore we have to clone as well.
                                        linkNode = jqLiteClone(compileNode);
                                    }
                                    replaceWith(linkRootElement, jqLite(beforeTemplateLinkNode), linkNode);

                                    // Copy in CSS classes from original node
                                    safeAddClass(jqLite(linkNode), oldClasses);
                                }
                                if (afterTemplateNodeLinkFn.transcludeOnThisElement) {
                                    childBoundTranscludeFn = createBoundTranscludeFn(scope, afterTemplateNodeLinkFn.transclude, boundTranscludeFn);
                                } else {
                                    childBoundTranscludeFn = boundTranscludeFn;
                                }
                                afterTemplateNodeLinkFn(afterTemplateChildLinkFn, scope, linkNode, $rootElement,
                                    childBoundTranscludeFn);
                            }
                            linkQueue = null;
                        });

                    return function delayedNodeLinkFn(ignoreChildLinkFn, scope, node, rootElement, boundTranscludeFn) {
                        var childBoundTranscludeFn = boundTranscludeFn;
                        if (scope.$$destroyed) return;
                        if (linkQueue) {
                            linkQueue.push(scope,
                                node,
                                rootElement,
                                childBoundTranscludeFn);
                        } else {
                            if (afterTemplateNodeLinkFn.transcludeOnThisElement) {
                                childBoundTranscludeFn = createBoundTranscludeFn(scope, afterTemplateNodeLinkFn.transclude, boundTranscludeFn);
                            }
                            afterTemplateNodeLinkFn(afterTemplateChildLinkFn, scope, node, rootElement, childBoundTranscludeFn);
                        }
                    };
                }


                /**
                 * Sorting function for bound directives.
                 */
                function byPriority(a, b) {
                    var diff = b.priority - a.priority;
                    if (diff !== 0) return diff;
                    if (a.name !== b.name) return (a.name < b.name) ? -1 : 1;
                    return a.index - b.index;
                }

                function assertNoDuplicate(what, previousDirective, directive, element) {

                    function wrapModuleNameIfDefined(moduleName) {
                        return moduleName ?
                            (' (module: ' + moduleName + ')') :
                            '';
                    }

                    if (previousDirective) {
                        throw $compileMinErr('multidir', 'Multiple directives [{0}{1}, {2}{3}] asking for {4} on: {5}',
                            previousDirective.name, wrapModuleNameIfDefined(previousDirective.$$moduleName),
                            directive.name, wrapModuleNameIfDefined(directive.$$moduleName), what, startingTag(element));
                    }
                }


                function addTextInterpolateDirective(directives, text) {
                    var interpolateFn = $interpolate(text, true);
                    if (interpolateFn) {
                        directives.push({
                            priority: 0,
                            compile: function textInterpolateCompileFn(templateNode) {
                                var templateNodeParent = templateNode.parent(),
                                    hasCompileParent = !!templateNodeParent.length;

                                // When transcluding a template that has bindings in the root
                                // we don't have a parent and thus need to add the class during linking fn.
                                if (hasCompileParent) compile.$$addBindingClass(templateNodeParent);

                                return function textInterpolateLinkFn(scope, node) {
                                    var parent = node.parent();
                                    if (!hasCompileParent) compile.$$addBindingClass(parent);
                                    compile.$$addBindingInfo(parent, interpolateFn.expressions);
                                    scope.$watch(interpolateFn, function interpolateFnWatchAction(value) {
                                        node[0].nodeValue = value;
                                    });
                                };
                            }
                        });
                    }
                }


                function wrapTemplate(type, template) {
                    type = lowercase(type || 'html');
                    switch (type) {
                        case 'svg':
                        case 'math':
                            var wrapper = window.document.createElement('div');
                            wrapper.innerHTML = '<' + type + '>' + template + '</' + type + '>';
                            return wrapper.childNodes[0].childNodes;
                        default:
                            return template;
                    }
                }


                function getTrustedContext(node, attrNormalizedName) {
                    if (attrNormalizedName === 'srcdoc') {
                        return $sce.HTML;
                    }
                    var tag = nodeName_(node);
                    // All tags with src attributes require a RESOURCE_URL value, except for
                    // img and various html5 media tags.
                    if (attrNormalizedName === 'src' || attrNormalizedName === 'ngSrc') {
                        if (['img', 'video', 'audio', 'source', 'track'].indexOf(tag) === -1) {
                            return $sce.RESOURCE_URL;
                        }
                        // maction[xlink:href] can source SVG.  It's not limited to <maction>.
                    } else if (attrNormalizedName === 'xlinkHref' ||
                        (tag === 'form' && attrNormalizedName === 'action')
                    ) {
                        return $sce.RESOURCE_URL;
                    }
                }


                function addAttrInterpolateDirective(node, directives, value, name, allOrNothing) {
                    var trustedContext = getTrustedContext(node, name);
                    allOrNothing = ALL_OR_NOTHING_ATTRS[name] || allOrNothing;

                    var interpolateFn = $interpolate(value, true, trustedContext, allOrNothing);

                    // no interpolation found -> ignore
                    if (!interpolateFn) return;


                    if (name === 'multiple' && nodeName_(node) === 'select') {
                        throw $compileMinErr('selmulti',
                            'Binding to the \'multiple\' attribute is not supported. Element: {0}',
                            startingTag(node));
                    }

                    directives.push({
                        priority: 100,
                        compile: function() {
                            return {
                                pre: function attrInterpolatePreLinkFn(scope, element, attr) {
                                    var $$observers = (attr.$$observers || (attr.$$observers = createMap()));

                                    if (EVENT_HANDLER_ATTR_REGEXP.test(name)) {
                                        throw $compileMinErr('nodomevents',
                                            'Interpolations for HTML DOM event attributes are disallowed.  Please use the ' +
                                            'ng- versions (such as ng-click instead of onclick) instead.');
                                    }

                                    // If the attribute has changed since last $interpolate()ed
                                    var newValue = attr[name];
                                    if (newValue !== value) {
                                        // we need to interpolate again since the attribute value has been updated
                                        // (e.g. by another directive's compile function)
                                        // ensure unset/empty values make interpolateFn falsy
                                        interpolateFn = newValue && $interpolate(newValue, true, trustedContext, allOrNothing);
                                        value = newValue;
                                    }

                                    // if attribute was updated so that there is no interpolation going on we don't want to
                                    // register any observers
                                    if (!interpolateFn) return;

                                    // initialize attr object so that it's ready in case we need the value for isolate
                                    // scope initialization, otherwise the value would not be available from isolate
                                    // directive's linking fn during linking phase
                                    attr[name] = interpolateFn(scope);

                                    ($$observers[name] || ($$observers[name] = [])).$$inter = true;
                                    (attr.$$observers && attr.$$observers[name].$$scope || scope).
                                    $watch(interpolateFn, function interpolateFnWatchAction(newValue, oldValue) {
                                        //special case for class attribute addition + removal
                                        //so that class changes can tap into the animation
                                        //hooks provided by the $animate service. Be sure to
                                        //skip animations when the first digest occurs (when
                                        //both the new and the old values are the same) since
                                        //the CSS classes are the non-interpolated values
                                        if (name === 'class' && newValue !== oldValue) {
                                            attr.$updateClass(newValue, oldValue);
                                        } else {
                                            attr.$set(name, newValue);
                                        }
                                    });
                                }
                            };
                        }
                    });
                }


                /**
                 * This is a special jqLite.replaceWith, which can replace items which
                 * have no parents, provided that the containing jqLite collection is provided.
                 *
                 * @param {JqLite=} $rootElement The root of the compile tree. Used so that we can replace nodes
                 *                               in the root of the tree.
                 * @param {JqLite} elementsToRemove The jqLite element which we are going to replace. We keep
                 *                                  the shell, but replace its DOM node reference.
                 * @param {Node} newNode The new DOM node.
                 */
                function replaceWith($rootElement, elementsToRemove, newNode) {
                    var firstElementToRemove = elementsToRemove[0],
                        removeCount = elementsToRemove.length,
                        parent = firstElementToRemove.parentNode,
                        i, ii;

                    if ($rootElement) {
                        for (i = 0, ii = $rootElement.length; i < ii; i++) {
                            if ($rootElement[i] === firstElementToRemove) {
                                $rootElement[i++] = newNode;
                                for (var j = i, j2 = j + removeCount - 1,
                                         jj = $rootElement.length;
                                     j < jj; j++, j2++) {
                                    if (j2 < jj) {
                                        $rootElement[j] = $rootElement[j2];
                                    } else {
                                        delete $rootElement[j];
                                    }
                                }
                                $rootElement.length -= removeCount - 1;

                                // If the replaced element is also the jQuery .context then replace it
                                // .context is a deprecated jQuery api, so we should set it only when jQuery set it
                                // http://api.jquery.com/context/
                                if ($rootElement.context === firstElementToRemove) {
                                    $rootElement.context = newNode;
                                }
                                break;
                            }
                        }
                    }

                    if