/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.securityControl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.entity.ActionItemEntity;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceHierarchyValidator {
    private final ActiveObjects activeObjects;

    @Autowired
    public ResourceHierarchyValidator(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void validateGroupBelongsRetro(int groupId, long retroId) throws FourHundredException {
        GroupElementEntity groupElementEntity = (GroupElementEntity)this.activeObjects.get(GroupElementEntity.class, (Object)groupId);
        if (groupElementEntity == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        if (groupElementEntity.getNumericPageId() != retroId) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
    }

    public void validateIdeaBelongsRetros(int ideaId, long retroId) throws FourHundredException {
        ThinkElementEntity thinkElementEntity = (ThinkElementEntity)this.activeObjects.get(ThinkElementEntity.class, (Object)ideaId);
        if (thinkElementEntity == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        if (thinkElementEntity.getNumericPageId() != retroId) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
    }

    public void validateActionItemBelongsGroup(int actionItemId, int groupId) throws FourHundredException {
        ActionItemEntity actionItemEntity = (ActionItemEntity)this.activeObjects.get(ActionItemEntity.class, (Object)actionItemId);
        if (actionItemEntity == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        if (actionItemEntity.getGroupElement() == null) {
            throw new FourHundredException(Response.Status.CONFLICT);
        }
        if (actionItemEntity.getGroupElement().getID() != groupId) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
    }
}

