/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.impl;

import com.atlassian.migration.app.tracker.AccessScope;
import com.atlassian.migration.app.tracker.CloudMigrationAccessor;
import com.atlassian.migration.app.tracker.CloudMigrationListenerV1;
import com.atlassian.migration.app.tracker.MigrationDetailsV1;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nearsoft.retrospective.api.MyPluginComponent;
import com.nearsoft.retrospective.impl.LocalCloudMigrationAccessor;
import com.nearsoft.retrospective.migration_to_cloud.ServerMigrationStatus;
import com.nearsoft.retrospective.migration_to_cloud.dto.MigrationDataDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.RetrospectiveDTO;
import com.nearsoft.retrospective.migration_to_cloud.service.RetrosMapDataService;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@ExportAsService(value={MyPluginComponent.class})
@Named(value="myPluginComponent")
public class MyPluginComponentImpl
implements MyPluginComponent,
CloudMigrationListenerV1,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyPluginComponentImpl.class);
    private CloudMigrationAccessor accessor;
    private RetrosMapDataService retrosMapDataService;
    @ComponentImport
    private ApplicationProperties applicationProperties;

    @Inject
    public MyPluginComponentImpl(ApplicationProperties applicationProperties, LocalCloudMigrationAccessor accessor, RetrosMapDataService retrosMapDataService) {
        this.applicationProperties = applicationProperties;
        this.accessor = accessor.getCloudMigrationAccessor();
        this.retrosMapDataService = retrosMapDataService;
    }

    @Override
    public String getName() {
        if (null != this.applicationProperties) {
            return "myComponent:" + this.applicationProperties.getDisplayName();
        }
        return "myComponent";
    }

    @Override
    public void onStartAppMigration(String transferId, MigrationDetailsV1 migrationDetails) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        MigrationDataDTO migrationDataDTO = new MigrationDataDTO();
        List<RetrospectiveDTO> retrospectiveDTOS = new ArrayList<RetrospectiveDTO>();
        migrationDataDTO.setRetrospectives(retrospectiveDTOS);
        try {
            retrospectiveDTOS = this.retrosMapDataService.matchRetrosForCloud(transferId, this.accessor, migrationDetails.getConfluenceClientKey());
            LOGGER.info("{} retrospective sessions were found for migration", (Object)retrospectiveDTOS.size());
            migrationDataDTO.setRetrospectives(retrospectiveDTOS);
            migrationDataDTO.setServerMigrationStatus(ServerMigrationStatus.SUCCESS);
        }
        catch (Exception e) {
            migrationDataDTO.setServerMigrationStatus(ServerMigrationStatus.FAILED);
            LOGGER.error("Error while retrieving retrospectives for migration", (Throwable)e);
        }
        try {
            OutputStream firstDataStream = this.accessor.getCloudMigrationGateway().createAppData(transferId);
            firstDataStream.write(gson.toJson(migrationDataDTO).getBytes());
            firstDataStream.close();
            LOGGER.info("Retrospectives migration finished with transferId: {}", (Object)transferId);
        }
        catch (Exception e) {
            LOGGER.error("Error uploading files to the cloud", (Throwable)e);
            this.destroy();
        }
    }

    @Override
    public void onRegistrationAccepted() {
        LOGGER.info("Nice! The migration listener is ready to take migrations events");
    }

    @Override
    public void onRegistrarRemoved() {
        LOGGER.info("The listener is no longer active");
    }

    @Override
    public String getCloudAppKey() {
        return "retrospectives4confluence";
    }

    @Override
    public String getServerAppKey() {
        return "retrospectives4confluence";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    public void afterPropertiesSet() {
        this.accessor.registerListener(this);
    }

    public void destroy() {
        this.accessor.deregisterListener(this);
    }
}

