/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.filter;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.google.gson.Gson;
import com.nearsoft.retrospective.dto.ErrorResponse;
import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class ConfluencePermissionFilter
extends AbstractHttpFilter {
    @ConfluenceImport
    private final PermissionManager permissionManager;

    @Inject
    public ConfluencePermissionFilter(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ConfluenceUser cUser = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager.hasPermission((User)cUser, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            PrintWriter output = response.getWriter();
            ErrorResponse errorResponse = new ErrorResponse();
            response.setContentType("application/json");
            response.setStatus(403);
            errorResponse.setMessage("PERMISSION_REVOKED");
            output.print(new Gson().toJson(errorResponse));
            output.flush();
        }
    }
}

