(function (angular) {
    angular
        .module('retrospectiveApp')
        .service('NotificationsService', NotificationsService);

    NotificationsService.$inject = ['$rootScope', 'WorkflowService', 'StatefulService'];

    function NotificationsService($rootScope, WorkflowResource, Stateful) {
        Stateful.make(this);

        WorkflowResource.subscribe((event) => {
            if (event.state.moderator && (!this.state.get('moderator', false) || this.state.get('moderator').userKey !== event.state.moderator.userKey)) {
                const isCurrentUserModerator = this.state.shared._get('userKey') === event.state.moderator.userKey;

                if (isCurrentUserModerator) {
                    const text = 'You are the new Moderator of this Retro. You can transfer this role in the dropdown menu.';
                    sendNotification('Congratulations!', text, 'success');
                } else {
                    const text = `has been successfully named Moderator.`;
                    sendNotification(event.state.moderator.fullName, text, 'success');
                }

                this.state.set('moderator', event.state.moderator);
            }
        }, ['moderator']);

        WorkflowResource.subscribe((event) => {
            const newParticipants = event.state.participants;
            const currentParticipants = this.state.get('participants', []);

            // search for new participants

            newParticipants.forEach((p) => {
                const found = currentParticipants.find(cp => cp.userKey === p.userKey);

                // is new participant
                if (!found && p.userKey !== this.state.shared._get('userKey')) {
                    const text = `${p.fullName} has joined the session.`;
                    sendNotification('', text);
                }
            });

            // search for participants that left the session
            currentParticipants.forEach((p) => {
                const found = newParticipants.find(cp => cp.userKey === p.userKey);

                // left the session
                if (!found) {
                    const text = `${p.fullName} has left the session.`;
                    sendNotification('', text);
                }
            });

            this.state.set('participants', newParticipants);
        }, ['participants']);

        function isFunction(functionToCheck) {
            return functionToCheck && {}.toString.call(functionToCheck) === '[object Function]';
        }

        /*
         type can be: error, warning, success, info
         */
        function sendNotification(title, message, type = 'info') {
            AJS.flag = null;

            if (AJS.flag && isFunction(AJS.flag)) {
                const flag = AJS.flag({
                    type: type,
                    body: title
                });

                setTimeout(() => {
                    flag.close();
                }, 8000);
            } else {
                $rootScope.$broadcast('SHOW_NOTIFICATION', {
                    type,
                    message: message,
                    title
                });
            }
        }

        return {
            sendNotification
        };
    }
}(angular));
