/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.model;

import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.VoteElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupElement
implements Comparable<GroupElement> {
    private int id;
    private HashMap<String, Integer> votesPerUser;
    private String description;
    private List<ThinkElement> ideas;
    private Boolean grouped;
    private Integer votes;
    private List<ActionItem> actionItems;
    private Set<String> userKeys;
    private List<VoteElement> voteList;

    public GroupElement() {
        this.grouped = false;
        this.votesPerUser = new HashMap();
    }

    public GroupElement(String description, List<ThinkElement> ideas) {
        this.description = description;
        this.ideas = ideas;
        this.grouped = true;
        this.votes = 0;
        this.userKeys = new HashSet<String>();
        this.votesPerUser = new HashMap();
    }

    public GroupElement(List<ThinkElement> ideas) {
        this.ideas = ideas;
        this.grouped = false;
        this.votes = 0;
        this.userKeys = new HashSet<String>();
        this.votesPerUser = new HashMap();
    }

    @Override
    public int compareTo(GroupElement groupElement) {
        return Integer.compare(groupElement.getVotes(), this.votes);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ThinkElement> getIdeas() {
        return this.ideas;
    }

    public void setIdeas(List<ThinkElement> ideas) {
        this.ideas = ideas;
    }

    public void setGrouped(Boolean grouped) {
        this.grouped = grouped;
    }

    public Boolean isGrouped() {
        return this.grouped;
    }

    public Integer getVotes() {
        return this.votes;
    }

    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    public List<ActionItem> getActionItems() {
        return this.actionItems;
    }

    public void setActionItems(List<ActionItem> actionItems) {
        this.actionItems = actionItems;
    }

    public Set<String> getUserKeys() {
        return this.userKeys;
    }

    public void setUserKeys(Set<String> userKeys) {
        this.userKeys = userKeys;
    }

    public HashMap<String, Integer> getVotesPerUser() {
        return this.votesPerUser;
    }

    public void setVotesPerUser(HashMap<String, Integer> votesPerUser) {
        this.votesPerUser = votesPerUser;
    }

    public List<VoteElement> getVoteList() {
        if (this.voteList == null) {
            this.voteList = new ArrayList<VoteElement>();
        }
        return this.voteList;
    }

    public void setVoteList(List<VoteElement> voteList) {
        this.voteList = voteList;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupElement)) {
            return false;
        }
        GroupElement groupElement = (GroupElement)obj;
        if (!Objects.equals(groupElement.isGrouped(), this.grouped)) {
            return false;
        }
        return Objects.equals(groupElement.getDescription(), this.description);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.grouped.hashCode();
        return result;
    }
}

