/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.nearsoft.retrospective.exception.FourHundredException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Service;

@Service
public class ConfluenceUserService {
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private final UserAccessor userAccessor;

    public ConfluenceUserService(@ComponentImport SpaceManager spaceManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport UserAccessor userAccessor) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userAccessor = userAccessor;
    }

    public List<com.nearsoft.retrospective.model.User> getUsersBySpace(String spaceKey) throws FourHundredException {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        HashMap<String, ConfluenceUser> cUsersMap = new HashMap<String, ConfluenceUser>();
        List users = (List)this.spacePermissionManager.getUsersWithPermissions(space);
        users.forEach(user -> {
            ConfluenceUser cUser = this.userAccessor.getUserByName(user.getName());
            if (cUser != null) {
                cUsersMap.put(cUser.getKey().getStringValue(), cUser);
            }
        });
        List groups = (List)this.spacePermissionManager.getGroupsWithPermissions(space);
        for (Group group : groups) {
            Iterable confluenceUsersInGroup = this.userAccessor.getMembers(group);
            for (ConfluenceUser cUser : confluenceUsersInGroup) {
                cUsersMap.put(cUser.getKey().getStringValue(), cUser);
            }
        }
        ArrayList<com.nearsoft.retrospective.model.User> userDtos = new ArrayList<com.nearsoft.retrospective.model.User>();
        ArrayList cUsersList = new ArrayList(cUsersMap.values());
        for (ConfluenceUser cUser : cUsersList) {
            String profilePicture = this.userAccessor.getUserProfilePicture((User)cUser).getDownloadPath();
            com.nearsoft.retrospective.model.User userDto = new com.nearsoft.retrospective.model.User(cUser.getKey().getStringValue(), cUser.getName(), cUser.getFullName(), profilePicture);
            userDtos.add(userDto);
        }
        return userDtos;
    }
}

