/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.model;

import com.nearsoft.retrospective.model.PendingMessage;
import com.nearsoft.retrospective.service.EventName;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class User {
    private static final int MAX_PENDING_MESSAGES = 10;
    private static final long MAX_PENDING_MESSAGE_AGE_IN_SECONDS = 20L;
    private String userKey;
    private String userName;
    private String fullName;
    private String pageId;
    private long numericPageId;
    private String imageURI;
    private Boolean disconnected;
    private boolean isModerator;
    private boolean isReady;
    private transient List<PendingMessage> pendingMessages = new ArrayList<PendingMessage>();

    public User() {
    }

    public User(String userKey, String userName, String fullName, String imageURI) {
        this.userKey = userKey;
        this.userName = userName;
        this.fullName = fullName;
        this.imageURI = imageURI;
        this.disconnected = null;
        this.isModerator = false;
        this.isReady = false;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String getName() {
        return this.userName;
    }

    public void setName(String userName) {
        this.userName = userName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getImageURI() {
        return this.imageURI;
    }

    public void setImageURI(String imageURI) {
        this.imageURI = imageURI;
    }

    public void setDisconnected(Boolean disconnected) {
        this.disconnected = disconnected;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Boolean getDisconnected() {
        return this.disconnected;
    }

    public boolean getIsModerator() {
        return this.isModerator;
    }

    public void setIsModerator(boolean moderator) {
        this.isModerator = moderator;
    }

    public void setIsReady(boolean ready) {
        this.isReady = ready;
    }

    public boolean getIsReady() {
        return this.isReady;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User user = (User)obj;
        if (!user.getUserKey().equals(this.userKey)) {
            return false;
        }
        if (!user.getUserName().equals(this.userName)) {
            return false;
        }
        if (!user.getFullName().equals(this.fullName)) {
            return false;
        }
        return user.getImageURI().equals(this.imageURI);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.userKey.hashCode();
        result = 31 * result + this.userName.hashCode();
        result = 31 * result + this.fullName.hashCode();
        result = 31 * result + this.imageURI.hashCode();
        return result;
    }

    public boolean canAceptPendingMessages() {
        return this.pendingMessages.size() < 10 || !this.hasReallyOldMessages();
    }

    boolean hasReallyOldMessages() {
        if (this.pendingMessages.isEmpty()) {
            return false;
        }
        PendingMessage oldestMessage = Collections.min(this.pendingMessages, Comparator.comparing(m -> m.getTimestamp()));
        long secondsSinceOldestMessage = ChronoUnit.SECONDS.between(oldestMessage.getTimestamp(), this.getNow());
        return secondsSinceOldestMessage > 20L;
    }

    Instant getNow() {
        return Instant.now();
    }

    public void leaveAPendingMessage(Object data, EventName eventName) {
        PendingMessage pendingMessage = new PendingMessage();
        pendingMessage.setData(data);
        pendingMessage.setEventName(eventName);
        pendingMessage.setTimestamp(this.getNow());
        this.pendingMessages.add(pendingMessage);
    }

    public boolean hasPendingMessages() {
        return this.pendingMessages.size() > 0;
    }

    public List<PendingMessage> getPendingMessages() {
        return this.pendingMessages;
    }

    public long getNumericPageId() {
        return this.numericPageId;
    }

    public void setNumericPageId(long numericPageId) {
        this.numericPageId = numericPageId;
    }
}

