/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.ConfluenceTaskTransaction;
import com.nearsoft.retrospective.model.GroupCollection;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.model.SessionExport;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.pojo.ConfluenceTask;
import com.nearsoft.retrospective.securityControl.CreatorValidator;
import com.nearsoft.retrospective.securityControl.ModeratorValidator;
import com.nearsoft.retrospective.securityControl.PermissionValidator;
import com.nearsoft.retrospective.service.ConfluenceTaskTransactionService;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.service.ThinkService;
import com.nearsoft.retrospective.util.SanitizationUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/workflow")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class WorkflowResource {
    private static final Gson GSON = new Gson();
    private final ThinkService thinkService;
    private final GroupService groupService;
    private final SettingsService settingsService;
    private final SessionDataService sessionDataService;
    private final ConfluenceTaskTransactionService confluenceTaskTransactionService;
    private final ModeratorValidator _moderatorValidator;
    private final CreatorValidator _creatorValidator;
    private final PermissionValidator permissionValidator;

    @Autowired
    public WorkflowResource(SessionDataService sessionDataService, ThinkService thinkService, GroupService groupService, SettingsService settingsService, ConfluenceTaskTransactionService confluenceTaskTransactionService, ModeratorValidator moderatorValidator, CreatorValidator creatorValidator, PermissionValidator permissionValidator) {
        this.sessionDataService = sessionDataService;
        this.thinkService = thinkService;
        this.groupService = groupService;
        this.settingsService = settingsService;
        this.confluenceTaskTransactionService = confluenceTaskTransactionService;
        this._moderatorValidator = moderatorValidator;
        this._creatorValidator = creatorValidator;
        this.permissionValidator = permissionValidator;
    }

    @PUT
    @Path(value="/{retroId}")
    public Response initSettings(@PathParam(value="retroId") int retroId, @RequestBody long pageId) throws FourHundredException {
        this.settingsService.initSettings(retroId, pageId);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/set-moderator")
    public Response setModerator(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid, @DefaultValue(value="") @QueryParam(value="prevMod") String prevModUserKey) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateNotEmptyString(userKey);
        if (!this._moderatorValidator.isCurrentUserModeratorForRetro(uuid)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.sessionDataService.setModerator(userKey, uuid);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/change-view")
    public Response changeView(@QueryParam(value="uuid") int uuid, @DefaultValue(value="") @QueryParam(value="viewName") String viewName) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        if (!this._moderatorValidator.isCurrentUserModeratorForRetro(uuid)) {
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
        if ((viewName = SanitizationUtil.escapeHtml(viewName)).equals("vote")) {
            this.groupService.processNonGroupedIdeas(uuid, this.thinkService.getThinkElementsList(uuid));
        }
        this.sessionDataService.setView(uuid, viewName);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/flush")
    public Response flushByPageId(@QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        return Response.ok().build();
    }

    @POST
    @Path(value="/disconnect")
    public Response disconnectUser(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateNotEmptyString(userKey);
        this.sessionDataService.setUserAsDisconnected(userKey, uuid);
        return Response.ok().build();
    }

    @POST
    @Path(value="/heartbeat")
    public Response heartbeat(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateNotEmptyString(userKey);
        this.sessionDataService.hearthbeat(userKey, uuid);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/im-ready")
    public Response imReady(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateNotEmptyString(userKey);
        this.sessionDataService.toggleIsReadyByUserKeyAndPageId(userKey, uuid);
        return Response.ok().build();
    }

    @GET
    @Path(value="/reopen")
    public Response fillRetrospectiveMaps(@QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        if (!this._creatorValidator.isCurrentUserCreatorForRetro(uuid) && !this._moderatorValidator.isCurrentUserPresetModeratorForRetro(uuid)) {
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
        this.sessionDataService.reopen(uuid);
        return Response.ok().build();
    }

    @GET
    @Path(value="/retros-expired/{uuid}")
    public Response isRetroExpired(@PathParam(value="uuid") int uuid) throws Exception {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        boolean isExpired = !this.verifyRetroAvailability(uuid);
        return Response.ok((Object)GSON.toJson(isExpired)).build();
    }

    @GET
    @Path(value="/session-data")
    public Response getSessionData(@QueryParam(value="uuid") int uuid) throws Exception {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        SessionData sessionData = this.sessionDataService.getSessionDataByUUID(uuid);
        return Response.ok((Object)GSON.toJson(sessionData)).build();
    }

    @PUT
    @Path(value="/nexttopic")
    @Consumes(value={"application/json"})
    public Response nextTopic(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateNotEmptyString(userKey);
        if (!this._moderatorValidator.isCurrentUserModeratorForRetro(uuid)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        int limit = this.groupService.getGroupsByPageId(uuid, this.thinkService.getThinkElementsList(uuid)).getGroupList().size() - 1;
        this.sessionDataService.nextTopic(uuid, limit);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/previoustopic")
    @Consumes(value={"application/json"})
    public Response previousTopic(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateNotEmptyString(userKey);
        if (!this._moderatorValidator.isCurrentUserModeratorForRetro(uuid)) {
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
        this.sessionDataService.previousTopic(uuid);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @GET
    @Path(value="/export")
    public Response exportData() {
        List<SessionData> sessionDataList = this.sessionDataService.getSessionDatas();
        ArrayList<SessionExport> sessions = new ArrayList<SessionExport>();
        for (SessionData sessionData : sessionDataList) {
            long uuid = sessionData.getNumericPageId();
            RetrosSettings retrosSettings = this.settingsService.getRetrosSettingsById(uuid);
            GroupCollection collection = this.groupService.getGroupsByPageId(uuid, this.thinkService.getThinkElementsList(uuid));
            if (retrosSettings.isAnonymousPlayersAllowed()) {
                for (GroupElement group : collection.getGroupList()) {
                    if (group == null || group.getIdeas() == null) continue;
                    for (ThinkElement idea : group.getIdeas()) {
                        idea.setUser(null);
                    }
                }
            }
            sessions.add(new SessionExport(sessionData, retrosSettings, collection));
        }
        return Response.ok((Object)GSON.toJson(sessions)).build();
    }

    @POST
    @Path(value="/confluence-tasks-transaction")
    public Response createConfluenceTaskTransaction(ConfluenceTask confluenceTask) throws FourHundredException {
        if (confluenceTask.getContent() == null || confluenceTask.getContent().isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        ConfluenceTaskTransaction confluenceTaskTransaction = this.confluenceTaskTransactionService.create(confluenceTask);
        return Response.ok((Object)GSON.toJson(confluenceTaskTransaction)).build();
    }

    @GET
    @Path(value="/confluence-tasks-transaction/{transactionId}")
    public Response getConfluenceTasksTransaction(@PathParam(value="transactionId") int transactionId) throws FourHundredException {
        ConfluenceTaskTransaction confluenceTaskTransaction = this.confluenceTaskTransactionService.getById(transactionId);
        if (confluenceTaskTransaction == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)GSON.toJson(confluenceTaskTransaction)).build();
    }

    boolean verifyRetroAvailability(long uuid) throws Exception {
        SessionData sessionData = this.sessionDataService.getSessionDataByUUID(uuid);
        String completionDate = sessionData.getCompletionDate();
        if (completionDate != null && !completionDate.equals("")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date completion = sdf.parse(completionDate);
            Date current = this.getCurrentDate();
            long diff = (current.getTime() - completion.getTime()) / 60000L;
            if (diff >= 60L) {
                return false;
            }
        }
        return true;
    }

    Date getCurrentDate() {
        return new Date();
    }

    private void validateNotEmptyString(String string) throws FourHundredException {
        if (string.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
    }
}

