(function (angular) {
    /*
     The motivation for this logic is that
     when we are viewing a page, after the base url,
     we'll find the /display path, so that we can distinct between the base url and
     the path of the page.

     The approach of @@BASE_REST_URL is no longer working since users can have
     a base url with a permanent path included

     i.e.

     https://mydomain.com/itservices/

     instead of just

     https://mydomain.com/
     */

    function tryGetBase() {
        const baseUrl = window.location.origin + window.location.pathname;

        // we enter using the confluence UI
        if (baseUrl.indexOf('/display') >= 0) {
            return baseUrl.split('/display')[0];
        }
        // we enter by copy and paste a url
        else if (baseUrl.indexOf('/pages') >= 0) {
            return baseUrl.split('/pages')[0];
        }
        else if (baseUrl.indexOf('/plugins') >= 0) {
            return baseUrl.split('/plugins')[0];
        }
        // we'll use default value
        else {
            return null;
        }
    }

    function getBaseUrl() {
        const url = tryGetBase();
        return url ? url : '@@BASE_REST_URL';
    }

    function getServletBaseUrl() {
        const url = tryGetBase();
        return url ? url : '@@SERVLET_PATH';
    }

    angular
        .module('retrospectiveApp')
        .constant('HTTP_PATH', `${getBaseUrl()}/rest/retrospective/latest`)
        .constant('IMAGES_BASE_PATH', getBaseUrl())
        .constant('SERVLET_PATH', `${getServletBaseUrl()}`);
}(angular));

