/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.nearsoft.retrospective.dto.Format;
import com.nearsoft.retrospective.dto.FormatColumn;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.mappers.RetroSettingsMapper;
import com.nearsoft.retrospective.model.RetrosColumn;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.entity.FormatColumnEntity;
import com.nearsoft.retrospective.model.entity.FormatEntity;
import com.nearsoft.retrospective.model.entity.RetrosColumnEntity;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import com.nearsoft.retrospective.model.entity.RetrosSettingsTemplateEntity;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettingsService {
    private static final Logger LOGGER = Logger.getLogger((String)SettingsService.class.getName());
    private final ActiveObjects activeObjects;
    private final RetrospectiveUserService _retrospectiveUserService;
    @ConfluenceImport
    private final ContentService contentService;

    @Autowired
    public SettingsService(@ComponentImport ActiveObjects activeObjects, RetrospectiveUserService retrospectiveUserService, ContentService contentService) {
        this.activeObjects = activeObjects;
        this._retrospectiveUserService = retrospectiveUserService;
        this.contentService = contentService;
    }

    public RetrosSettingsEntity createAndSaveRetrosSettings(int votesPerPlayer, int votesPerCard, boolean anonymousIdeas, String presetModeratorUserKey, boolean isTemplate, Integer formatId, String spaceKey) throws Exception {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.create(RetrosSettingsEntity.class, new DBParam[0]);
        String currentUserKey = this._retrospectiveUserService.getCurrentUserKey();
        if (currentUserKey == null || currentUserKey.isEmpty()) {
            LOGGER.warn((Object)"The current user key is null or empty at SettingsService#createAndSaveRetrosSettings");
            throw new Exception("Empty current user key");
        }
        retrosSettingsEntity.setCreatorUserKey(currentUserKey);
        retrosSettingsEntity.setAnonymousPlayersAllowed(anonymousIdeas);
        retrosSettingsEntity.setVotesAllowedPerCard(votesPerCard);
        retrosSettingsEntity.setVotesPerPlayer(votesPerPlayer);
        retrosSettingsEntity.setPresetModeratorUserKey(presetModeratorUserKey);
        retrosSettingsEntity.setIsTemplate(isTemplate);
        FormatEntity formatEntity = (FormatEntity)this.activeObjects.get(FormatEntity.class, (Object)formatId);
        if (formatEntity == null) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        retrosSettingsEntity.setFormat(formatEntity);
        retrosSettingsEntity.setSpaceKey(spaceKey);
        retrosSettingsEntity.save();
        return retrosSettingsEntity;
    }

    public Long searchRetroTemplate(long pageId, long templateId) {
        RetrosSettingsTemplateEntity[] retroTemplate = (RetrosSettingsTemplateEntity[])this.activeObjects.find(RetrosSettingsTemplateEntity.class, QueryHelper.ByPageIdAndTemplateId(pageId, templateId));
        if (retroTemplate.length == 0) {
            return null;
        }
        return retroTemplate[0].getRetroId();
    }

    public void saveRetroTemplate(long pageId, long uuid, long uuidTemplate) {
        RetrosSettingsTemplateEntity retrosTemplate = (RetrosSettingsTemplateEntity)this.activeObjects.create(RetrosSettingsTemplateEntity.class, new DBParam[0]);
        retrosTemplate.setUuidTemplate(uuidTemplate);
        retrosTemplate.setRetroId(uuid);
        retrosTemplate.setPageId(pageId);
        retrosTemplate.save();
    }

    public RetrosColumnEntity saveAndCreateRetrosColumn(RetrosSettingsEntity retrosSettingsEntity, String content, String color, String columnId) {
        RetrosColumnEntity retrosColumnEntity = (RetrosColumnEntity)this.activeObjects.create(RetrosColumnEntity.class, new DBParam[0]);
        retrosColumnEntity.setColumnId(columnId);
        retrosColumnEntity.setContent(content);
        retrosColumnEntity.setColor(color);
        retrosColumnEntity.setSettingsEntity(retrosSettingsEntity);
        retrosColumnEntity.save();
        return retrosColumnEntity;
    }

    private RetrosSettings getDefaultSettings() {
        RetrosSettings settings = new RetrosSettings();
        ArrayList<RetrosColumn> columns = new ArrayList<RetrosColumn>();
        RetrosColumn columnWell = new RetrosColumn();
        columnWell.setColumnId("C1");
        columnWell.setContent("What went well?");
        columnWell.setColor("#7ED321");
        columns.add(columnWell);
        RetrosColumn columnWrong = new RetrosColumn();
        columnWrong.setColumnId("C2");
        columnWrong.setContent("What didn't go well?");
        columnWrong.setColor("#D0021B");
        columns.add(columnWrong);
        settings.setColumns(columns.toArray(new RetrosColumn[columns.size()]));
        settings.setCreatorUserKey(Optional.empty());
        return settings;
    }

    public RetrosSettings getRetrosSettingsById(long id) {
        RetrosSettingsEntity[] retrosSettingsResult = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class, QueryHelper.ById(id));
        if (retrosSettingsResult.length == 0) {
            return this.getDefaultSettings();
        }
        return RetroSettingsMapper.map(retrosSettingsResult[0]);
    }

    public boolean updatePresetModeratorForRetrosSettingsById(long id, String newPresetModeratorUserKey) {
        RetrosSettingsEntity[] retrosSettingsResult = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class, QueryHelper.ById(id));
        if (retrosSettingsResult.length > 0) {
            RetrosSettingsEntity settingsEntity = retrosSettingsResult[0];
            if (!settingsEntity.getPresetModeratorUserKey().equals("RETROS_DYNAMIC_MODERATOR")) {
                settingsEntity.setPresetModeratorUserKey(newPresetModeratorUserKey);
                settingsEntity.save();
                return true;
            }
            return false;
        }
        return false;
    }

    public Format[] getFormats() {
        FormatEntity[] formatEntities = (FormatEntity[])this.activeObjects.find(FormatEntity.class);
        Format[] formats = new Format[formatEntities.length];
        for (int i = 0; i < formatEntities.length; ++i) {
            int formatId = formatEntities[i].getID();
            FormatColumnEntity[] columnEntities = formatEntities[i].getFormatColumns();
            FormatColumn[] formatColumns = new FormatColumn[columnEntities.length];
            String formatName = formatEntities[i].getName();
            for (int j = 0; j < columnEntities.length; ++j) {
                String content = columnEntities[j].getContent();
                String color = columnEntities[j].getColor();
                formatColumns[j] = new FormatColumn(content, color);
            }
            formats[i] = new Format(formatId, formatName, formatColumns);
        }
        return formats;
    }

    public List<RetrosSettings> getAllRetros() {
        return (List)this.activeObjects.executeInTransaction(() -> {
            RetrosSettingsEntity[] retrosSettingsResult = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class);
            ArrayList allMappedRetros = new ArrayList();
            if (retrosSettingsResult.length > 0) {
                Arrays.stream(retrosSettingsResult).forEach(retroEntity -> allMappedRetros.add(RetroSettingsMapper.map(retroEntity)));
            }
            return allMappedRetros;
        });
    }

    public void initSettings(int settingsId, long pageId) throws FourHundredException {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)settingsId);
        if (retrosSettingsEntity == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        if (retrosSettingsEntity.getPageId() != null) {
            return;
        }
        Content page = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withType(new ContentType[]{ContentType.PAGE}).withId(ContentId.of((long)pageId), new ContentId[0]).fetchOrNull();
        if (page == null) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        if (retrosSettingsEntity.getSpaceKey() == null) {
            retrosSettingsEntity.setSpaceKey(page.getSpace().getKey());
        }
        if (!retrosSettingsEntity.getSpaceKey().equals(page.getSpace().getKey())) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        retrosSettingsEntity.setPageId(page.getId().asLong());
        retrosSettingsEntity.save();
    }
}

