import mappings, {steps} from "../steps/";

class StepsModel {
    private currentStep: steps;

    constructor() {
        this.reset();
    }

    getCurrentStep(): steps {
        return this.currentStep;
    }

    hasNext() {
        const currentStepConfig = mappings[this.currentStep];
        return currentStepConfig && currentStepConfig.nextStep;
    }

    next() {
        const currentStepConfig = mappings[this.currentStep];
        if (currentStepConfig && currentStepConfig.nextStep === null){
            return
        }
        if (currentStepConfig && currentStepConfig.nextStep) {
            this.currentStep = currentStepConfig.nextStep;
        } else {
            this.currentStep = null;
        }
    }

    back() {
        const currentStepConfig = mappings[this.currentStep];
        if (currentStepConfig && currentStepConfig.previousStep === null) {
            return
        }
        if (currentStepConfig && currentStepConfig.previousStep) {
            this.currentStep = currentStepConfig.previousStep;
        } else {
            this.currentStep = null;
        }
    }

    getCurrentConfiguration() {
        return mappings[this.currentStep];
    }

    reset() {
        this.currentStep = steps.task_create;
    }

}

const stepsModel = new StepsModel();
export default stepsModel;