/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.securityControl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.exception.PermissionRevokedException;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionValidator {
    @ConfluenceImport
    private final ContentService contentService;
    @ConfluenceImport
    private final SpaceService spaceService;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ConfluenceImport
    private final PermissionManager permissionManager;

    @Autowired
    public PermissionValidator(ContentService contentService, SpaceService spaceService, ActiveObjects activeObjects, PermissionManager permissionManager) {
        this.contentService = contentService;
        this.spaceService = spaceService;
        this.activeObjects = activeObjects;
        this.permissionManager = permissionManager;
    }

    public void validatePagePermission(long pageId) throws FourHundredException {
        Content page = (Content)this.contentService.find(new Expansion[0]).withType(new ContentType[]{ContentType.PAGE}).withId(ContentId.of((long)pageId), new ContentId[0]).fetchOrNull();
        if (page == null) {
            throw new PermissionRevokedException();
        }
    }

    public void validateSpacePermission(String spaceKey) throws FourHundredException {
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        if (space == null) {
            throw new PermissionRevokedException();
        }
    }

    public void validatePagePermissionByRetroId(int retroId) throws FourHundredException {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)retroId);
        if (retrosSettingsEntity == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        Long pageId = retrosSettingsEntity.getPageId();
        if (pageId == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        this.validatePagePermission(pageId);
    }

    public void isConfluenceAdmin() throws FourHundredException {
        ConfluenceUser cUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)cUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
    }
}

