/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.securityControl.PermissionValidator;
import com.nearsoft.retrospective.service.ConfluenceUserService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/confluence/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class ConfluenceUserResource {
    private final ConfluenceUserService confluenceUserService;
    private final PermissionValidator permissionValidator;
    private static final Gson GSON = new Gson();

    @Autowired
    public ConfluenceUserResource(ConfluenceUserService confluenceUserService, PermissionValidator permissionValidator) {
        this.confluenceUserService = confluenceUserService;
        this.permissionValidator = permissionValidator;
    }

    @GET
    @Path(value="{spaceKey}")
    public Response getConfluenceUsersBySpace(@PathParam(value="spaceKey") String spaceKey) throws FourHundredException {
        if (spaceKey == null || spaceKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.permissionValidator.validateSpacePermission(spaceKey);
        return Response.ok((Object)GSON.toJson(this.confluenceUserService.getUsersBySpace(spaceKey))).build();
    }
}

