(function (angular) {
    angular
        .module('retrospectiveApp')
        .service('UserService', UserService);

    UserService.$inject = ['WorkflowService', 'StatefulService'];

    function UserService(WorkflowService, Stateful) {
        Stateful.make(this);

        /*
            subscribe to events to always get the newest state
         */
        WorkflowService.subscribe((event) => {
            this.state.set('participants', event.state.participants);
        }, ['participants']);

        WorkflowService.subscribe((event) => {
            this.state.set('moderator', event.state.moderator);
        }, ['moderator']);

        // TODO rename to getParticipants
        this.getUserList = () => this.state.get('participants');

        this.getModerator = () => this.state.get('moderator');

        this.getUserByUserKey = (userKey) => this.state.get('participants', []).find(p=> p.userKey === userKey);

        // TODO rename to something related with a number
        this.getReadyUsers = () => this.state.get('participants').filter(p => p.isReady).length;
    }
}(angular));