/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.GroupCollection;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.GroupIdeaRequest;
import com.nearsoft.retrospective.model.GroupRequest;
import com.nearsoft.retrospective.model.GroupedIdea;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.VoteRequest;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.ThinkService;
import com.nearsoft.retrospective.service.VoteService;
import com.nearsoft.retrospective.service.response.wrappers.VoteResponse;
import com.nearsoft.retrospective.util.SanitizationUtil;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/group")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class GroupResource {
    private static final Gson GSON = new Gson();
    private final ThinkService thinkService;
    private final GroupService groupService;
    private final VoteService voteService;
    private final SessionDataService sessionDataService;

    @Autowired
    public GroupResource(ThinkService thinkService, GroupService groupService, VoteService voteService, SessionDataService sessionDataService) {
        this.thinkService = thinkService;
        this.groupService = groupService;
        this.voteService = voteService;
        this.sessionDataService = sessionDataService;
    }

    @GET
    public Response getCompleteIdeasCollection(@QueryParam(value="uuid") long uuid) throws FourHundredException {
        this.validateAndGetUser(uuid);
        GroupCollection groupCollection = this.groupService.getGroupsByPageId(uuid, this.thinkService.getThinkElementsList(uuid));
        return Response.ok((Object)GSON.toJson(groupCollection)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response saveGroup(@QueryParam(value="uuid") long uuid) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        List<ThinkElement> list = this.thinkService.getThinkElementsList(uuid);
        GroupElement group = this.groupService.saveGroupedIdeaAsGroup(uuid, list.toArray(new ThinkElement[list.size()]));
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok((Object)GSON.toJson(group)).build();
    }

    @PUT
    @Path(value="/{groupId}")
    @Consumes(value={"application/json"})
    public Response editGroup(@QueryParam(value="uuid") long uuid, @PathParam(value="groupId") int groupId) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        this.groupService.editGroup(uuid, groupId);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response breakGroup(@QueryParam(value="uuid") long uuid) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        this.groupService.breakGroup(uuid);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/idea")
    @Consumes(value={"application/json"})
    public Response putIdeaInGroup(@QueryParam(value="uuid") long uuid, GroupIdeaRequest request) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        this.groupService.addIdeaToGroupedIdea(uuid, request.getThinkElement());
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/idea/name")
    @Consumes(value={"application/json"})
    public Response editGroupIdeaName(@QueryParam(value="uuid") long uuid, GroupRequest request) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        String name = SanitizationUtil.escapeHtml(request.getName());
        if (!this.groupService.updateGroupedIdeaName(uuid, name)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/idea/{ideaId}")
    @Consumes(value={"application/json"})
    public Response deleteIdeaInGroup(@QueryParam(value="uuid") long uuid, @PathParam(value="ideaId") int ideaId) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        this.groupService.removeIdeaFromGroupedIdea(uuid, ideaId);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @POST
    @Path(value="/idea")
    @Consumes(value={"application/json"})
    public Response postIdeaInGroup(@QueryParam(value="uuid") long uuid, GroupIdeaRequest request) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        this.groupService.createGroupedIdea(uuid, request.getThinkElement(), "Untitled group", -1);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @POST
    @Path(value="/vote")
    @Consumes(value={"application/json"})
    public Response postVote(@DefaultValue(value="true") @QueryParam(value="increased") boolean increased, @QueryParam(value="uuid") long uuid, VoteRequest request) throws Exception {
        User user = this.validateAndGetUser(uuid);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        VoteResponse voteResponse = null;
        voteResponse = this.voteService.vote(uuid, request, increased, user.getUserKey());
        return Response.ok((Object)GSON.toJson(voteResponse)).build();
    }

    @GET
    @Path(value="/current")
    public Response getGroupedIdea(@QueryParam(value="uuid") long uuid) throws FourHundredException {
        this.validateAndGetUser(uuid);
        GroupedIdea groupedIdea = this.groupService.getGroupedIdea(uuid);
        if (groupedIdea == null) {
            return Response.ok().build();
        }
        return Response.ok((Object)GSON.toJson(groupedIdea)).build();
    }

    @POST
    @Path(value="/{groupId}/actionitems")
    @Consumes(value={"application/json"})
    public Response addActionItem(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") long uuid, @PathParam(value="groupId") int groupId, ActionItem actionItem) throws FourHundredException {
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        actionItem.setDescription(SanitizationUtil.escapeHtml(actionItem.getDescription()));
        this.groupService.addActionItem(uuid, groupId, actionItem);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{groupId}/actionitems/{actionItemId}")
    @Consumes(value={"application/json"})
    public Response deleteActionItem(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") long uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId) throws FourHundredException {
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.groupService.removeActionItem(actionItemId);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{groupId}/actionitems/{actionItemId}/assignee")
    @Consumes(value={"application/json"})
    public Response setAssignee(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") long uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId, User user) throws FourHundredException {
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.groupService.setActionItemAssignee(actionItemId, user);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{groupId}/actionitems/{actionItemId}/assignee")
    @Consumes(value={"application/json"})
    public Response clearAssignee(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") long uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId) throws FourHundredException {
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.groupService.removeActionItemAssignee(actionItemId);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{groupId}/actionitems/{actionItemId}/togglecomplete")
    @Consumes(value={"application/json"})
    public Response toggleCompleteActionItem(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") long uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId) throws FourHundredException {
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.groupService.toggleCompleteActionItem(actionItemId);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    private User validateAndGetUser(long uuid) throws FourHundredException {
        User user = this.sessionDataService.getUserByPageIdOrCreate(uuid);
        if (user == null) {
            throw new FourHundredException(Response.Status.UNAUTHORIZED);
        }
        return user;
    }
}

