/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nearsoft.retrospective.dto.Format;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.EditPermissions;
import com.nearsoft.retrospective.model.RetrosColumn;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import com.nearsoft.retrospective.securityControl.CreatorValidator;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.service.ThinkService;
import com.nearsoft.retrospective.util.SanitizationUtil;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class SettingsResource {
    private static final Gson GSON = new Gson();
    private final SessionDataService sessionDataService;
    private final ThinkService thinkService;
    private final SettingsService settingsService;
    private final CreatorValidator _creatorValidator;

    @Autowired
    public SettingsResource(SessionDataService sessionDataService, ThinkService thinkService, SettingsService settingsService, CreatorValidator creatorValidator) {
        this.sessionDataService = sessionDataService;
        this.thinkService = thinkService;
        this.settingsService = settingsService;
        this._creatorValidator = creatorValidator;
    }

    @POST
    public Response saveSettings(String json) throws Exception {
        JsonElement jelem = GSON.fromJson(json, JsonElement.class);
        JsonObject jsonObject = jelem.getAsJsonObject();
        int votesPerPlayer = jsonObject.get("votes_per_player").getAsInt();
        int votesPerCard = jsonObject.get("votes_per_card").getAsInt();
        boolean anonymousIdeas = jsonObject.get("anonymous_players").getAsBoolean();
        String presetModeratorUserKey = jsonObject.get("preset_moderator_user_key").getAsString();
        boolean isTemplate = jsonObject.get("isTemplate").getAsBoolean();
        Integer formatId = jsonObject.get("formatId").getAsInt();
        if (presetModeratorUserKey.isEmpty()) {
            presetModeratorUserKey = "RETROS_DYNAMIC_MODERATOR";
        }
        RetrosSettingsEntity retrosSettingsEntity = this.settingsService.createAndSaveRetrosSettings(votesPerPlayer, votesPerCard, anonymousIdeas, presetModeratorUserKey, isTemplate, formatId);
        int uuid = retrosSettingsEntity.getID();
        JsonArray columns = jsonObject.getAsJsonArray("columns");
        for (int i = 0; i < columns.size(); ++i) {
            JsonElement c = columns.get(i);
            JsonObject column = c.getAsJsonObject();
            String content = SanitizationUtil.escapeHtml(column.get("content").getAsString());
            String color = SanitizationUtil.escapeHtml(column.get("color").getAsString());
            String columnId = "C" + (i + 1);
            this.settingsService.saveAndCreateRetrosColumn(retrosSettingsEntity, content, color, columnId);
        }
        return Response.status((int)201).entity((Object)uuid).build();
    }

    @GET
    @Path(value="/{uuid}")
    public Response editSettings(@PathParam(value="uuid") @DefaultValue(value="") String uuid) throws FourHundredException {
        int id;
        if (uuid.isEmpty()) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        try {
            id = Integer.parseInt(uuid);
        }
        catch (NumberFormatException e) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        RetrosSettings retrosSettings = this.settingsService.getRetrosSettingsById(id);
        if (retrosSettings == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        HashMap<String, String> columnColors = new HashMap<String, String>();
        for (RetrosColumn column : retrosSettings.getColumns()) {
            columnColors.put(column.getColumnId(), SanitizationUtil.escapeHtml(column.getColor()));
        }
        retrosSettings.setColumnColors(columnColors);
        return Response.ok((Object)GSON.toJson(retrosSettings)).build();
    }

    @GET
    @Path(value="/permissions/{uuid}")
    public Response getSettingsEditPermissions(@PathParam(value="uuid") long uuid) {
        EditPermissions permission = new EditPermissions();
        boolean availablePermission = this.hasAvailablePermission(uuid);
        permission.setAvailable(availablePermission);
        return Response.ok((Object)GSON.toJson(permission)).build();
    }

    boolean hasAvailablePermission(long uuid) {
        ThinkElementEntity[] elements;
        SessionData session = this.sessionDataService.getSessionDataByUUID(uuid);
        boolean availablePermission = session != null ? session.getViewName() == null || session.getViewName().equals("wait") || session.getViewName().isEmpty() : (elements = this.thinkService.getThinkElementsByPageId(uuid)).length == 0;
        return availablePermission;
    }

    @GET
    @Path(value="/formats")
    @Produces(value={"application/json"})
    public Response getFormats() {
        Format[] formats = this.settingsService.getFormats();
        return Response.ok().entity((Object)formats).build();
    }
}

