/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.Idea;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.ThinkService;
import com.nearsoft.retrospective.util.SanitizationUtil;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/ideas")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class IdeasResource {
    private static final Gson GSON = new Gson();
    private final ThinkService thinkService;
    private final SessionDataService sessionDataService;

    @Autowired
    public IdeasResource(SessionDataService sessionDataService, ThinkService thinkService) {
        this.sessionDataService = sessionDataService;
        this.thinkService = thinkService;
    }

    @GET
    public Response getThinkIdeasCollection(@QueryParam(value="uuid") long uuid) throws FourHundredException {
        this.validateAndGetUser(uuid);
        return Response.ok((Object)GSON.toJson(this.thinkService.getThinkElementsList(uuid)), (String)"application/json").build();
    }

    @POST
    public Response postIdea(@QueryParam(value="uuid") long uuid, @RequestBody Idea idea) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        String ideaText = SanitizationUtil.escapeHtml(idea.getIdea());
        this.thinkService.insertIdea(uuid, ideaText, user, idea.getColumnId());
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @DELETE
    public Response deleteIdea(@DefaultValue(value="-1") @QueryParam(value="id") int ideaId, @QueryParam(value="uuid") long uuid) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        if (ideaId < 0) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.thinkService.deleteIdea(ideaId, user.getUserKey());
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{ideaId}")
    public Response updateIdea(@DefaultValue(value="0") @PathParam(value="ideaId") int ideaId, @QueryParam(value="uuid") long uuid, @RequestBody Idea idea) throws FourHundredException {
        User user = this.validateAndGetUser(uuid);
        if (ideaId <= 0) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        String userKey = user.getUserKey();
        String ideaText = idea.getIdea();
        if (ideaText.isEmpty() || userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        ideaText = SanitizationUtil.escapeHtml(ideaText);
        this.thinkService.updateThinkElement(ideaId, ideaText, userKey);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    private User validateAndGetUser(long uuid) throws FourHundredException {
        User user = this.sessionDataService.getUserByPageIdOrCreate(uuid);
        if (user == null) {
            throw new FourHundredException(Response.Status.UNAUTHORIZED);
        }
        return user;
    }
}

