/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.task;

import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.ao.CSUMActiveObjectServiceImpl;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.util.UserUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CSVNotifyUser {
    private static final Logger LOG = LoggerFactory.getLogger(CSVNotifyUser.class);
    private final CSUMActiveObjectServiceImpl fActiveObjectService;
    private final UserAccessor fUserAccessor;
    private final UserUtil fUserUtil;
    private final NotificationsSender fNotificationsSender;

    @Autowired
    public CSVNotifyUser(CSUMActiveObjectServiceImpl activeObjectService, @ComponentImport UserAccessor userAccessor, UserUtil userUtil, @ComponentImport NotificationsSender notificationsSender) {
        this.fActiveObjectService = activeObjectService;
        this.fUserAccessor = userAccessor;
        this.fUserUtil = userUtil;
        this.fNotificationsSender = notificationsSender;
    }

    public void sendNotificationEmail(int taskEntityId, Space space, String message) {
        CSUMTaskEntity taskEntity = this.fActiveObjectService.getTaskEntity(taskEntityId);
        ConfluenceUser initiatingUser = this.fUserAccessor.getUserByName(taskEntity.getInitiatingUser());
        String userEmail = null;
        if (initiatingUser != null) {
            userEmail = initiatingUser.getEmail();
        }
        if (userEmail != null && this.fUserUtil.isValidEmail(userEmail)) {
            int successfulTotal = taskEntity.getSuccessfulTotal();
            int unsuccessfulTotal = taskEntity.getUnsuccessfulTotal();
            String fileName = taskEntity.getFilename();
            String status = taskEntity.getStatus();
            String taskType = taskEntity.getTaskType();
            Timestamp timeFinished = taskEntity.getFinished();
            Timestamp timeSubmitted = taskEntity.getSubmitted();
            NotificationData notificationData = new NotificationData((User)initiatingUser, false, null);
            notificationData.setSubject("CSUM CSV processing " + status);
            if (status.equals("requires_attention") || status.equals("failure") || status.equals("rejected")) {
                notificationData.setTemplateName("csv-error.vm");
            } else {
                if (status.equals("cancelled")) {
                    return;
                }
                notificationData.setTemplateName("csv-success.vm");
            }
            notificationData.addToContext("initiatingUser", (Serializable)((Object)initiatingUser.getName()));
            notificationData.addToContext("space", (Serializable)((Object)space.getKey()));
            notificationData.addToContext("status", (Serializable)((Object)status));
            notificationData.addToContext("successes", (Serializable)Integer.valueOf(successfulTotal));
            notificationData.addToContext("failures", (Serializable)Integer.valueOf(unsuccessfulTotal));
            notificationData.addToContext("fileName", (Serializable)((Object)fileName));
            notificationData.addToContext("taskType", (Serializable)((Object)taskType));
            notificationData.addToContext("timeFinished", (Serializable)timeFinished.toLocalDateTime());
            notificationData.addToContext("timeSubmitted", (Serializable)timeSubmitted.toLocalDateTime());
            notificationData.addToContext("info", (Serializable)((Object)message));
            if (initiatingUser != null && initiatingUser.getName() != null) {
                this.fNotificationsSender.sendNotification(initiatingUser.getName(), notificationData.getCommonContext(), notificationData, null);
            }
            LOG.debug("email sent to " + initiatingUser.getName());
        } else {
            LOG.error("\"" + userEmail + "\" is not a valid email");
        }
    }
}

