/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service;

import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigGeneralBean;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigGroupBean;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigUserBean;
import com.pluginpeople.confluence.csum.service.AdminConfigService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdminConfigService
implements AdminConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAdminConfigService.class);
    private static final String OFF = "off";
    private static final String LOCAL = "local";
    private static final String GLOBAL = "global";
    private static final String SHOW = "show";
    private static final String HIDE = "hide";
    private static final String NONE = "none";
    private static final String LASTNAME_FIRSTNAMES = "[Lastname] Firstname(s)";
    private static final String FIRSTNAMES_LASTNAME = "Firstname(s) [Lastname]";
    private static final String FIRSTNAME_LASTNAMES = "Firstname [Lastname(s)]";
    private static final int VAR_CHAR_STRING_LENGTH_LIMIT = 255;
    private static final int TEXT_STRING_LENGTH_LIMIT = 32000;

    @Autowired
    public DefaultAdminConfigService() {
    }

    @Override
    public List<String> validateConfigGroupData(AdminConfigGroupBean adminConfigGroupBean) {
        ArrayList<String> errors = new ArrayList<String>();
        if (adminConfigGroupBean != null) {
            String blocklistedGroups;
            String maximumCleanupPagePermissionsScope;
            String maximumCleanupSpacePermissionsScope;
            String groupNameAllowedCharsRegexp;
            String msg;
            String spaceGroupPatternPrefix = adminConfigGroupBean.getSpaceGroupPatternPrefix();
            String spaceGroupPatternSuffix = adminConfigGroupBean.getSpaceGroupPatternSuffix();
            if ((spaceGroupPatternPrefix == null || spaceGroupPatternPrefix.isEmpty()) && (spaceGroupPatternSuffix == null || spaceGroupPatternSuffix.isEmpty())) {
                LOG.debug("You must specify either a Space group pattern prefix or suffix");
                errors.add("You must specify either a Space group pattern prefix or suffix");
            }
            if (spaceGroupPatternPrefix != null && spaceGroupPatternPrefix.length() > 255) {
                msg = "Defined Space Group Pattern Prefix exceeds maximum character length [255]";
                LOG.debug(msg);
                errors.add(msg);
            }
            if (spaceGroupPatternSuffix != null && spaceGroupPatternSuffix.length() > 255) {
                msg = "Defined Space Group Pattern Suffix exceeds maximum character length [255]";
                LOG.debug(msg);
                errors.add(msg);
            }
            if ((groupNameAllowedCharsRegexp = adminConfigGroupBean.getGroupNameAllowedCharsRegexp()) != null && !this.isRegExpValid(groupNameAllowedCharsRegexp)) {
                LOG.debug("Your group name allowed regular expression is invalid");
                errors.add("Your group name allowed regular expression is invalid");
            }
            if (groupNameAllowedCharsRegexp != null && groupNameAllowedCharsRegexp.length() > 255) {
                String msg2 = "Defined Group Allowed Characters pattern exceeds maximum character length [255]";
                LOG.debug(msg2);
                errors.add(msg2);
            }
            boolean hideOperationsGroupSelect = adminConfigGroupBean.getHideOperationsGroupSelect();
            boolean hideOperationsUserSelect = adminConfigGroupBean.getHideOperationsUserSelect();
            if (hideOperationsGroupSelect && hideOperationsUserSelect) {
                LOG.debug("At most, only one of the Hide operations can be on at a time");
                errors.add("At most, only one of the Hide operations can be on at a time");
            }
            if (!((maximumCleanupSpacePermissionsScope = adminConfigGroupBean.getMaximumCleanupSpacePermissionsScope()) == null || maximumCleanupSpacePermissionsScope.equalsIgnoreCase(OFF) || maximumCleanupSpacePermissionsScope.equalsIgnoreCase(LOCAL) || maximumCleanupSpacePermissionsScope.equalsIgnoreCase(GLOBAL))) {
                LOG.debug("The maximum cleanup Space permissions scope was an invalid value of: " + maximumCleanupSpacePermissionsScope);
                errors.add("The maximum cleanup Space permissions scope was an invalid value of: " + maximumCleanupSpacePermissionsScope);
            }
            if (!((maximumCleanupPagePermissionsScope = adminConfigGroupBean.getMaximumCleanupPagePermissionsScope()) == null || maximumCleanupPagePermissionsScope.equalsIgnoreCase(OFF) || maximumCleanupPagePermissionsScope.equalsIgnoreCase(LOCAL) || maximumCleanupPagePermissionsScope.equalsIgnoreCase(GLOBAL))) {
                LOG.debug("The maximum cleanup Page permissions scope was an invalid value of: " + maximumCleanupPagePermissionsScope);
                errors.add("The maximum cleanup Page permissions scope was an invalid value of: " + maximumCleanupPagePermissionsScope);
            }
            if ((blocklistedGroups = adminConfigGroupBean.getGroupBlocklist()) != null && blocklistedGroups.length() > 32000) {
                String msg3 = "Defined Group Blocklist CSV exceeds maximum character length [32000]";
                LOG.debug(msg3);
                errors.add(msg3);
            }
        } else {
            LOG.debug("No data was received to update the system config");
            errors.add("No data was received to update the system config");
        }
        return errors;
    }

    @Override
    public List<String> validateConfigUserData(AdminConfigUserBean adminConfigUserBean) {
        ArrayList<String> errors = new ArrayList<String>();
        if (adminConfigUserBean != null) {
            String groupFilterCSV;
            String activeLDAPConfigurations;
            String userDirectories;
            String autoJoinGroupsCSV;
            String userLastnameExtractionStrategy;
            String disabledUserVisibility = adminConfigUserBean.getDisabledUserVisibility();
            if (disabledUserVisibility != null && !disabledUserVisibility.equalsIgnoreCase(SHOW) && !disabledUserVisibility.equalsIgnoreCase(HIDE)) {
                LOG.debug("The disabled user visibility was an invalid value of: " + disabledUserVisibility);
                errors.add("The disabled user visibility was an invalid value of: " + disabledUserVisibility);
            }
            if (!((userLastnameExtractionStrategy = adminConfigUserBean.getUserLastnameExtractionStrategy()) == null || userLastnameExtractionStrategy.equalsIgnoreCase(NONE) || userLastnameExtractionStrategy.equalsIgnoreCase(LASTNAME_FIRSTNAMES) || userLastnameExtractionStrategy.equalsIgnoreCase(FIRSTNAMES_LASTNAME) || userLastnameExtractionStrategy.equalsIgnoreCase(FIRSTNAME_LASTNAMES))) {
                LOG.debug("The user name extraction strategy was an invalid value of: " + userLastnameExtractionStrategy);
                errors.add("The user name extraction strategy was an invalid value of: " + userLastnameExtractionStrategy);
            }
            if ((autoJoinGroupsCSV = adminConfigUserBean.getAutoJoinGroups()) != null && autoJoinGroupsCSV.length() > 255) {
                String msg = "Defined Auto Join Group CSV  exceeds maximum character length [255]";
                LOG.debug(msg);
                errors.add(msg);
            }
            if ((userDirectories = adminConfigUserBean.getUserDirectories()) != null && userDirectories.length() > 255) {
                String msg = "Defined User Directories CSV exceeds maximum character length [255]";
                LOG.debug(msg);
                errors.add(msg);
            }
            if ((activeLDAPConfigurations = adminConfigUserBean.getActiveLDAPConfigurations()) != null && activeLDAPConfigurations.length() > 255) {
                String msg = "Defined LDAP Configurations CSV exceeds maximum character length [255]";
                LOG.debug(msg);
                errors.add(msg);
            }
            if ((groupFilterCSV = adminConfigUserBean.getUserGroupFilter()) != null && groupFilterCSV.length() > 255) {
                String msg = "Defined Group Filter CSV exceeds maximum character length [255]";
                LOG.debug(msg);
                errors.add(msg);
            }
        } else {
            LOG.debug("No data was received to update the system config");
            errors.add("No data was received to update the system config");
        }
        return errors;
    }

    @Override
    public List<String> validateConfigGeneralData(AdminConfigGeneralBean adminConfigGeneralBean) {
        ArrayList<String> errors = new ArrayList<String>();
        if (adminConfigGeneralBean != null) {
            String addonDowntimeMessage = adminConfigGeneralBean.getAddonDowntimeMessage();
            if (addonDowntimeMessage == null || addonDowntimeMessage.isEmpty()) {
                LOG.debug("You must define a message to display if CSUM is disabled");
                errors.add("You must define a message to display if CSUM is disabled");
            } else if (addonDowntimeMessage.length() > 32000) {
                String msg = "Defined Downtime message exceeds maximum length of [32000]";
                LOG.debug(msg);
                errors.add(msg);
            }
        } else {
            LOG.debug("No data was received to update the system config");
            errors.add("No data was received to update the system config");
        }
        return errors;
    }

    @Override
    public boolean isRegExpValid(String regExpInput) {
        boolean valid = false;
        try {
            Pattern.compile(regExpInput);
            LOG.debug("regex is currently valid");
            valid = true;
        }
        catch (PatternSyntaxException e) {
            LOG.debug("regex is currently invalid");
        }
        return valid;
    }
}

