/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest.beans;

import com.atlassian.plugin.PluginAccessor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="data")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class ExceptionBean {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionBean.class);
    private static final int STACK_LINES = 20;
    private String exceptionName;
    private String exceptionMessage;
    private String stackTrace;
    private String pluginVersion;

    public ExceptionBean(Throwable e, PluginAccessor pluginAccessor) {
        this.exceptionName = e.getClass().getSimpleName();
        this.exceptionMessage = e.getLocalizedMessage();
        this.stackTrace = this.getExceptionSnippet(e);
        this.pluginVersion = pluginAccessor.getPlugin("raju.kadam.confluence.permissionmgmt").getPluginInformation().getVersion();
    }

    private String getExceptionSnippet(Throwable exception) {
        String stack = null;
        if (exception != null) {
            try {
                StringBuilder sb = new StringBuilder();
                String[] stackLines = ExceptionUtils.getStackTrace((Throwable)exception).split("\n");
                sb.append(exception.getClass().getSimpleName()).append(": ").append(exception.getLocalizedMessage()).append(":\n");
                for (int i = 0; i < Math.min(20, stackLines.length); ++i) {
                    sb.append(stackLines[i]).append("\r\n");
                }
                stack = sb.toString();
            }
            catch (Exception e2) {
                LOG.error("An exception occurred while trying to get the referred exception details (yes really) : " + exception.getLocalizedMessage(), (Throwable)e2);
            }
        }
        return stack;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public void setExceptionName(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }
}

