/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest.beans;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="data")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class AuditTableData {
    private String[][] data;
    private final int draw;
    private final int recordsTotal;
    private final int recordsFiltered;
    private final String error;

    public AuditTableData(CSUMAuditEntity[] auditEvents, int draw, int recordsFiltered, int recordsTotal, String error, UserAccessor userAccessor) {
        this.data = new String[auditEvents.length][];
        this.draw = draw;
        this.recordsFiltered = recordsFiltered;
        this.recordsTotal = recordsTotal;
        this.error = error;
        for (int i = 0; i < auditEvents.length; ++i) {
            ConfluenceUser userByKey;
            String ctxUsername = null;
            if (auditEvents[i].getContextUserKey() != null) {
                userByKey = userAccessor.getUserByKey(new UserKey(auditEvents[i].getContextUserKey()));
                ctxUsername = userByKey != null ? userByKey.getName() : null;
            }
            userByKey = userAccessor.getUserByKey(new UserKey(auditEvents[i].getCreatedByUserKey()));
            this.data[i] = new String[]{auditEvents[i].getCreatedDate().toString(), auditEvents[i].getSpaceKey(), userByKey != null ? userByKey.getName() : null, auditEvents[i].getOperationType(), auditEvents[i].getGroupName(), ctxUsername, auditEvents[i].getEventOutcome(), auditEvents[i].getAuthGroup()};
        }
    }

    public String[][] getData() {
        return this.data;
    }

    public void setData(String[][] data) {
        this.data = data;
    }

    public int getDraw() {
        return this.draw;
    }

    public int getRecordsTotal() {
        return this.recordsTotal;
    }

    public int getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public String getError() {
        return this.error;
    }
}

