/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.beans.AddDlgConfirmBean;
import com.pluginpeople.confluence.csum.api.beans.AuthGroupBean;
import com.pluginpeople.confluence.csum.api.beans.AuthUserBean;
import com.pluginpeople.confluence.csum.api.beans.DlgGroupBean;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.AuthCreateResult;
import com.pluginpeople.confluence.csum.rest.beans.CountForAuthEntities;
import com.pluginpeople.confluence.csum.rest.beans.CountForAuthGrps;
import com.pluginpeople.confluence.csum.rest.beans.CountForAuthUsers;
import com.pluginpeople.confluence.csum.rest.beans.DataTableGroupList;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.rest.beans.JSONAddGroupResultParent;
import com.pluginpeople.confluence.csum.rest.beans.Select2ResponseBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dlggroup")
public class DelegationConfigResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationConfigResource.class);
    private final ICSUMCacheManager fICSUMCacheManager;
    private final DlgGroupManager fDgm;
    private final PluginAccessor fPluginAccessor;
    private final ICSUMActiveObjectService fAos;
    private static final int SEARCH_TERM_MINIMUM_LENGTH = 2;

    @Inject
    public DelegationConfigResource(SpaceManager spaceManager, ICSUMCacheManager cacheManager, DlgGroupManager dGm, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport AccessModeService accessModeService, ICSUMActiveObjectService aos) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fICSUMCacheManager = cacheManager;
        this.fDgm = dGm;
        this.fPluginAccessor = pluginAccessor;
        this.fAos = aos;
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchForGroups(@Context HttpServletRequest hsr, @QueryParam(value="prefix") String groupPrefix, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                List<String> groupList = this.fDgm.performGroupSearch(groupPrefix, 100, dlgGroupId);
                String[] groupArr = new String[groupList.size()];
                groupList.toArray(groupArr);
                List<Select2ResponseBean> result = this.getSelect2OptionsForArray(groupArr);
                response = Response.ok(result).build();
            }
            catch (EntityException e) {
                LOG.error("could not find group(s) with prefix: " + (groupPrefix != null ? groupPrefix : "null"), (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
            catch (Exception e) {
                LOG.error("Error searching for group with search term: " + (groupPrefix != null ? groupPrefix : "null"), (Throwable)e);
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exceptionBean).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/search/auth/users/from/group")
    @Produces(value={"application/json"})
    public Response searchAuthorizedGroups(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="prefix") String groupPrefix, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                List<String> groupList = this.fDgm.performAuthGroupSearch(groupPrefix, 100, dlgGroupId);
                String[] groupArr = new String[groupList.size()];
                groupList.toArray(groupArr);
                List<Select2ResponseBean> result = this.getSelect2OptionsForArray(groupArr);
                response = Response.ok(result).build();
            }
            catch (EntityException e) {
                LOG.error("Could not find group(s) with prefix: " + (groupPrefix != null ? groupPrefix : "null"), (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/list/groups")
    @Produces(value={"application/json"})
    public Response getEnabledGroups(@Context HttpServletRequest hsr, @QueryParam(value="draw") int draw, @QueryParam(value="start") int start, @QueryParam(value="length") int length, @QueryParam(value="isGroupProc") boolean isServerSideProcEnabled, @QueryParam(value="searchVal") String searchVal, @QueryParam(value="atl_token") String atlToken) {
        Response response = null;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            DlgGroupBean[] enabledGroups = isServerSideProcEnabled ? (searchVal != null && searchVal.length() >= 2 ? this.fDgm.getDlgGroupsViaSearch(searchVal) : this.fDgm.getPagedDlgGroups(start, length)) : this.fDgm.getDlgGroups();
            if (enabledGroups != null) {
                String[][] data = new String[enabledGroups.length][];
                for (int i = 0; i < enabledGroups.length; ++i) {
                    data[i] = new String[]{String.valueOf(enabledGroups[i].getDlgGroupEntityId()), enabledGroups[i].getGroupName()};
                }
                int delegatedGroupCount = this.fAos.getDelegatedGroupsCount();
                DataTableGroupList dataTableGroupList = new DataTableGroupList(data, false, draw, delegatedGroupCount, delegatedGroupCount);
                response = Response.ok((Object)dataTableGroupList).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/list/auth")
    @Produces(value={"application/json"})
    public Response getAuthorizedGroups(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                List<AuthGroupBean> authGroups = this.fDgm.getDlgAuthGroups(dlgGroupId);
                String[][] data = new String[authGroups.size()][];
                for (int i = 0; i < authGroups.size(); ++i) {
                    data[i] = new String[]{authGroups.get(i).getGroupName()};
                }
                response = Response.ok((Object)new DataTableGroupList(data, false)).build();
            }
            catch (EntityException e) {
                LOG.error("Could not find group(s) for delegated group with id: " + dlgGroupId, (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/fill/auth")
    @Produces(value={"application/json"})
    public Response fillAuthorizedGroups(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                List<AuthGroupBean> authGroups = this.fDgm.getDlgAuthGroups(dlgGroupId);
                String[] formattedData = this.fDgm.fillFormatData(authGroups);
                response = Response.ok((Object)formattedData).build();
            }
            catch (EntityException e) {
                LOG.error("Could not find group(s) for delegated group with id: " + dlgGroupId, (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/count/auth")
    @Produces(value={"application/json"})
    public Response getAuthUsersCount(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                List<AuthUserBean> authorizedUsers = this.fDgm.getDlgAuthUsers(dlgGroupId);
                List<AuthGroupBean> authorizedGroups = this.fDgm.getDlgAuthGroups(dlgGroupId);
                int userCount = authorizedUsers.size();
                int groupCount = authorizedGroups.size();
                CountForAuthUsers countForUsers = new CountForAuthUsers(userCount, false);
                CountForAuthGrps countForGroups = new CountForAuthGrps(groupCount, false);
                CountForAuthEntities countForAuthEntities = new CountForAuthEntities(countForGroups, countForUsers);
                response = Response.ok((Object)countForAuthEntities).build();
            }
            catch (EntityException e) {
                LOG.error("Could not find user(s) for delegated group with id: " + dlgGroupId, (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
        }
        return response;
    }

    @POST
    @Path(value="/add")
    @Produces(value={"application/json"})
    public Response addGroups(@Context HttpServletRequest hsr, @FormParam(value="groupNames") String groupNames, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        block11: {
            RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
            if (!rab.isAuthenticated()) {
                response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
            } else if (!this.fDgm.dlgGroupActionsPermitted()) {
                response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            } else if (!groupNames.isEmpty()) {
                try {
                    String[] groupNameArr = groupNames.split(",");
                    AddDlgConfirmBean confirmationsBean = this.fDgm.validateDlgGroupCreate(groupNameArr);
                    if (confirmationsBean != null && (confirmationsBean.getDuplicateGroups().length > 0 || confirmationsBean.getSuccessfulGroups().length > 0)) {
                        JSONAddGroupResultParent result = this.fDgm.addDlgGroupConfirmation(confirmationsBean);
                        response = Response.ok((Object)result).build();
                        break block11;
                    }
                    LOG.error("Unsuccessful validation of group(s): " + groupNames);
                    response = Response.noContent().build();
                }
                catch (GroupActionNotPermittedException e) {
                    ICSUMCachedConfig cachedConfig = this.fICSUMCacheManager.getCachedConfig();
                    LOG.error("Group actions appear to be disabled, GroupActionsPermitted Status: " + (cachedConfig != null && cachedConfig.isGroupActionsPermitted()), (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (AuthorizationException e) {
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error occurred adding group(s): " + groupNames, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            } else {
                LOG.error("No groups were received by rest resource groups: " + groupNames);
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        }
        return response;
    }

    @POST
    @Path(value="/authorize")
    @Produces(value={"application/json"})
    public Response authorize(@Context HttpServletRequest hsr, @FormParam(value="dlgGroupId") int dlgGroupId, @FormParam(value="groups") String groups, @FormParam(value="userNames") String userNames, @FormParam(value="importViaGroups") String importViaGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                AuthCreateResult result = this.fDgm.authorizeUsersAndGroups(dlgGroupId, groups, userNames, importViaGroups);
                response = Response.ok((Object)result).build();
            }
            catch (EntityException e) {
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
            }
        }
        return response;
    }

    @DELETE
    @Path(value="/group/remove")
    @Produces(value={"application/json"})
    public Response removeDlgGroupAndAuthorizations(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        Response response = null;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (!this.fDgm.dlgGroupActionsPermitted()) {
            response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        } else if (dlgGroupId == 0) {
            LOG.error("could not delete group, server received delegated group id of 0");
            response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        } else {
            try {
                DlgGroupBean dlgGroupToRemove = this.fDgm.getDlgGroup(dlgGroupId);
                if (dlgGroupToRemove.getDlgGroupEntityId() == dlgGroupId) {
                    boolean deleted = this.fDgm.deleteDlgGroup(dlgGroupToRemove, "via-event-listener");
                    if (deleted) {
                        response = Response.ok().build();
                    } else {
                        LOG.error("Could not delete [" + dlgGroupToRemove.getGroupName() + "] Please contact support with the Confluence log attached");
                        response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                    }
                }
            }
            catch (EntityException e) {
                LOG.error("Failed to find Group with ID [" + dlgGroupId + "] Please contact support with the Confluence log attached", (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return response;
    }

    @DELETE
    @Path(value="/deauthorize")
    @Produces(value={"application/json"})
    public Response deAuthorizeGroupsAndUsers(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="userNames") String userNames, @QueryParam(value="groupNames") String groupNames, @QueryParam(value="targetViaMembership") String viaMembership, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                String[][] data = this.fDgm.deauthUsersAndGroups(dlgGroupId, userNames, groupNames, viaMembership);
                response = Response.ok((Object)data).build();
            }
            catch (EntityException e) {
                LOG.error("Error attempting to unauthorize users/groups: " + (userNames != null ? userNames : "null") + ", " + (groupNames != null ? groupNames : "null") + ", " + (viaMembership != null ? viaMembership : "null"), (Throwable)e);
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
            }
        }
        return response;
    }

    @DELETE
    @Path(value="cache")
    @Produces(value={"application/json"})
    public Response clearSpaceCache(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            this.fICSUMCacheManager.invalidateDlgGroupsForAllUsers();
            response = Response.ok().build();
        }
        return response;
    }
}

