/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.UserSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
@Path(value="/dlguser")
public class DelegatedUserResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatedUserResource.class);
    private final DlgGroupManager fDgm;

    @Inject
    public DelegatedUserResource(XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, DlgGroupManager dGm, SpaceManager spaceManager, ICSUMCacheManager cacheManager, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fDgm = dGm;
    }

    @GET
    @Path(value="/list/auth")
    @Produces(value={"application/json"})
    public Response listAuthUsers(@Context HttpServletRequest hsr, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) throws EntityException {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            try {
                DataTableUserList dataTableFormat = this.fDgm.listAuthUsers(dlgGroupId);
                response = Response.ok((Object)dataTableFormat).build();
            }
            catch (EntityException e) {
                LOG.error("Error getting list of authorized users for: " + (dlgGroupId > 0 ? this.fDgm.getDlgGroup(dlgGroupId).getGroupName() : "null"), (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/search/auth/users")
    @Produces(value={"application/json"})
    public Response searchAuthUsers(@Context HttpServletRequest hsr, @QueryParam(value="query") String query, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            UserSearchResult[] result = this.fDgm.searchAuthUsers(query);
            response = Response.ok((Object)result).build();
        }
        return response;
    }

    @GET
    @Path(value="/search/auth/users/from/group")
    @Produces(value={"application/json"})
    public Response searchAuthUsersFromGroup(@Context HttpServletRequest hsr, @QueryParam(value="query") String query, @QueryParam(value="dlgGroupId") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            UserSearchResult[] result = null;
            try {
                result = this.fDgm.searchAuthUsersFromGroup(query, dlgGroupId);
            }
            catch (AuthorizationException e) {
                LOG.error("Authorization Exception, could not search auth users without an authorized user", (Throwable)e);
            }
            response = Response.ok((Object)result).build();
        }
        return response;
    }
}

