/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ldap;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.beans.LDAPQueryResultList;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPQueryResult;
import com.pluginpeople.confluence.csum.ldap.LDAPUser;
import com.pluginpeople.confluence.csum.ldap.LdapItemBean;
import com.pluginpeople.confluence.csum.service.CSUMEncryptionException;
import com.pluginpeople.confluence.csum.util.SecurityUtils;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Rdn;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPLookupUtil {
    public static final int INITIAL_DEPTH = 0;
    public static final int MAX_DEPTH = 50;
    public static final String ATLASSIAN_REFERRAL_KEY = "atlassian.java.naming.referral";
    private static final Logger LOG = LoggerFactory.getLogger(LDAPLookupUtil.class);
    private static final int MAX_RESULTS = 1;
    private static final String DISTINGUISHED_NAME1 = "distinguishedName";
    public static final String DISTINGUISHED_NAME = "distinguishedName";
    private static final String ROOT1 = "[root] ";
    public static final String ROOT = "[root] ";
    public static final String OBJECT_CLASS = "objectClass";
    private static final String LDAP_RESULT = "\n-------------------------------\nLDAP result:\n-------------------------------\n";
    private static final String DIVIDER = "\n-------------------------------\n";
    private final SecurityUtils fSecurityUtils;
    private InitialDirContext fContext;
    private SearchControls fControl;
    private String[] fRequiredAttributes;
    private static final int F_SEARCH_SCOPE = 2;
    private final LdapDetailsDTO fLdapDto;
    private Hashtable<String, String> fCurrentEnv;

    public LDAPLookupUtil(LdapDetailsDTO dto) {
        this.fLdapDto = dto;
        BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
        SystemInformationService systemInformationService = (SystemInformationService)ComponentLocator.getComponent(SystemInformationService.class);
        String serverId = systemInformationService != null && systemInformationService.getConfluenceInfo() != null ? systemInformationService.getConfluenceInfo().getServerId() : null;
        this.fSecurityUtils = new SecurityUtils(bootstrapManager, serverId);
    }

    private void init() throws LDAPException {
        this.fCurrentEnv = (Hashtable)this.getEnvironmentForDto(this.fLdapDto);
        this.fControl = new SearchControls();
        this.fControl.setReturningAttributes(this.fRequiredAttributes);
        this.fControl.setSearchScope(2);
        this.fControl.setCountLimit(1L);
        this.fContext = this.createInitialContext(this.fCurrentEnv);
    }

    private String getStreamableMapString(Map<String, String> map) {
        String mapString = "";
        if (map != null) {
            StringBuilder mapBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                mapBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
            mapBuilder.delete(mapBuilder.length() - 1, mapBuilder.length());
            mapString = mapBuilder.toString();
        }
        return mapString;
    }

    private void setupAttributesForEnv(Hashtable<String, String> anEnv) throws LDAPException {
        if (this.fLdapDto.getLdapAdditionalParams() != null) {
            try {
                Properties p = new Properties();
                p.load(IOUtils.toInputStream((CharSequence)this.getStreamableMapString(this.fLdapDto.getLdapAdditionalParams()), (Charset)StandardCharsets.UTF_8));
                if (!p.isEmpty()) {
                    Set<Object> keys = p.keySet();
                    for (Object key : keys) {
                        String aKey = (String)key;
                        String aValue = (String)p.get(aKey);
                        anEnv.put(aKey, aValue);
                    }
                }
            }
            catch (IOException e) {
                throw new LDAPException("LDAP problem loading additional properties.", e);
            }
        }
        HashSet<String> requiredAttributes = new HashSet<String>();
        if (this.fLdapDto.getLdapUserAttr() != null) {
            requiredAttributes.add(this.fLdapDto.getLdapUserAttr().trim());
        }
        if (this.fLdapDto.getLdapUserFirstNameAttr() != null) {
            requiredAttributes.add(this.fLdapDto.getLdapUserFirstNameAttr().trim());
        }
        if (this.fLdapDto.getLdapUserLastNameAttr() != null) {
            requiredAttributes.add(this.fLdapDto.getLdapUserLastNameAttr().trim());
        }
        if (this.fLdapDto.getLdapUserEmailAttr() != null) {
            requiredAttributes.add(this.fLdapDto.getLdapUserEmailAttr().trim());
        }
        if (this.fLdapDto.getLdapUserDisplayNameAttr() != null) {
            requiredAttributes.add(this.fLdapDto.getLdapUserDisplayNameAttr().trim());
        }
        this.fRequiredAttributes = new String[requiredAttributes.size()];
        requiredAttributes.toArray(this.fRequiredAttributes);
    }

    private InitialDirContext createInitialContext(Hashtable env) throws LDAPException {
        LDAPException ex = null;
        InitialDirContext context = null;
        try {
            LOG.debug("Creating InitialDirContext for LDAP server: " + String.valueOf(env.get("java.naming.provider.url")) + "/" + this.fLdapDto.getLdapBaseDN());
            context = new InitialDirContext(env);
        }
        catch (NotContextException nce) {
            LOG.error("InitialDirContext could not be created: " + nce.getLocalizedMessage());
            for (String aKey : env.keySet()) {
                LOG.error("[ldap env] " + aKey + " = " + (String)env.get(aKey));
            }
            ex = new LDAPException("Unable to connect", nce);
        }
        catch (ServiceUnavailableException sue) {
            LOG.error("Service Unavailable.  Unable to configure initial context, connection failed [" + String.valueOf(env.get("java.naming.provider.url")) + "]");
            ex = new LDAPException("Service unavailable", sue);
        }
        catch (CommunicationException ce) {
            LOG.error("Service Unavailable, communication problem: connection failed [" + String.valueOf(env.get("java.naming.provider.url")) + "]");
            String additional = null;
            if (ce.getCause() != null) {
                additional = ce.getCause().getLocalizedMessage();
            }
            ex = new LDAPException("Communication Error, service unavailable:" + ce.getLocalizedMessage() + (String)(additional != null ? ", cause: " + ce.getCause().getClass().getName() + ":" + additional : ""), ce);
        }
        catch (NamingException ne) {
            LOG.error("Naming Problem.  Unable to configure initial context: " + ne.getLocalizedMessage());
            if (!ne.getLocalizedMessage().contains("AcceptSecurityContext")) {
                LOG.debug("LDAP directory [" + String.valueOf(env.get("java.naming.provider.url")) + "] connection (authentication) failed : " + ne.getLocalizedMessage(), (Throwable)ne);
            }
            ex = new LDAPException("Naming problem", ne);
        }
        catch (Exception ce) {
            String msg = ce.getClass() != NullPointerException.class ? ce.getLocalizedMessage() : "NPE...";
            LOG.debug("Unknown Exception : " + msg);
            ex = new LDAPException("Unhandled exception of type " + ce.getClass().getName(), ce);
        }
        if (ex != null) {
            throw ex;
        }
        return context;
    }

    public void resetConnection() throws LDAPException {
        if (this.fCurrentEnv != null) {
            if (this.fContext != null) {
                try {
                    this.fContext.close();
                }
                catch (NamingException e) {
                    LOG.error("NamingException during resetConnection: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.fContext = this.createInitialContext(this.fCurrentEnv);
        } else {
            try {
                this.init();
            }
            catch (LDAPException e) {
                LOG.error("LDAPException during resetConnection: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public LDAPUser getUserDetailsByEmailAddress(String emailAddress) throws LDAPException {
        return this.getUserDetailsByEmailAddress(emailAddress, null);
    }

    public LDAPUser getUserDetailsByEmailAddress(String emailAddress, String[] equivalentDomains) throws LDAPException {
        LDAPUser theLdapUser = null;
        emailAddress = emailAddress.trim();
        this.init();
        if (this.fContext != null) {
            List<LDAPUser> userList;
            String ldapAttribute = this.fLdapDto.getLdapUserEmailAttr();
            String searchFilter = "(" + ldapAttribute + "=" + emailAddress.trim() + ")";
            if (this.fLdapDto.getLdapObjectFilter() != null) {
                searchFilter = "(&" + this.fLdapDto.getLdapObjectFilter() + searchFilter + ")";
            }
            if ((userList = this.searchFor(searchFilter)) != null && !userList.isEmpty()) {
                block0: for (LDAPUser ldapUser : userList) {
                    if (ldapUser.getEmail().equalsIgnoreCase(emailAddress)) {
                        theLdapUser = ldapUser;
                        LOG.debug("Returning direct match for user: " + theLdapUser.getUserId() + " / " + theLdapUser.getEmail());
                        break;
                    }
                    if (ldapUser.getProxyAddresses() == null) continue;
                    String[] proxyAddresses = ldapUser.getProxyAddresses();
                    int len = ldapUser.getProxyAddresses().length;
                    for (int i = 0; i < len; ++i) {
                        if (!proxyAddresses[i].equalsIgnoreCase(emailAddress)) continue;
                        theLdapUser = ldapUser;
                        LOG.debug("Returning proxyAddress match [" + proxyAddresses[i] + "] for user: " + theLdapUser.getUserId() + " / " + theLdapUser.getEmail());
                        continue block0;
                    }
                }
            }
        } else {
            throw new LDAPException("No context.");
        }
        if (theLdapUser == null) {
            LOG.info("No user with either mailAttr[" + this.getVal(this.fLdapDto.getLdapUserEmailAttr()) + "] value: " + emailAddress);
        }
        return theLdapUser;
    }

    private String getVal(String val) {
        if (val != null) {
            return val;
        }
        return "null";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LDAPUser getUserDetails(String userId) throws LDAPException {
        if (userId == null || userId.length() == 0) {
            throw new LDAPException("Empty name provided.");
        }
        this.init();
        LDAPUser anLdapUser = null;
        if (this.fContext == null) throw new LDAPException("No context.");
        try {
            String decryptedUserId = this.fSecurityUtils.decryptString(userId);
            String searchFilter = this.createLdapFilter(decryptedUserId);
            LOG.debug("Searching for user [" + decryptedUserId + "] based on filter: " + searchFilter);
            List<LDAPUser> userList = this.searchFor(searchFilter);
            if (userList == null || userList.isEmpty()) return anLdapUser;
            anLdapUser = userList.get(0);
            if (userList.size() <= 1) return anLdapUser;
            LOG.debug("userList contains multiple users, returning " + anLdapUser.getUserId());
            return anLdapUser;
        }
        catch (CSUMEncryptionException | IOException e) {
            LOG.error("Exception while decrypting LDAP User: " + e.getLocalizedMessage(), (Throwable)e);
            throw new LDAPException(e.getLocalizedMessage(), e);
        }
    }

    private String createLdapFilter(String userId) {
        StringBuilder filterBuffer = new StringBuilder();
        filterBuffer.append("(&");
        if (this.fLdapDto.getLdapObjectClass() != null) {
            filterBuffer.append("(objectClass=").append(this.fLdapDto.getLdapObjectClass()).append(")");
        }
        if (this.fLdapDto.getLdapObjectFilter() != null) {
            filterBuffer.append(this.fLdapDto.getLdapObjectFilter());
        }
        filterBuffer.append("(" + this.fLdapDto.getLdapUserAttr() + "=" + userId.trim() + ")");
        filterBuffer.append(")");
        return filterBuffer.toString();
    }

    public Map<String, Map<String, List<Object>>> searchFor(String searchFilter, String[] requiredReturnAtts) throws LDAPException {
        return this.searchFor(searchFilter, requiredReturnAtts, 1L);
    }

    public Map<String, Map<String, List<Object>>> searchFor(String searchFilter, String[] requiredReturnAtts, long maxResults) throws LDAPException {
        return this.searchWithAdditionalDN(this.fLdapDto.getLdapAdditionalUserDN(), searchFilter, requiredReturnAtts, maxResults);
    }

    private Map<String, Map<String, List<Object>>> searchWithAdditionalDN(String additionalDN, String searchFilter, String[] requiredReturnAtts, long maxResults) throws LDAPException {
        SearchControls newControl = new SearchControls();
        newControl.setReturningAttributes(requiredReturnAtts);
        newControl.setSearchScope(2);
        newControl.setCountLimit(maxResults);
        newControl.setTimeLimit(this.fLdapDto.getLdapSearchTimeout());
        Object searchBase = additionalDN == null ? this.fLdapDto.getLdapBaseDN() : additionalDN + "," + this.fLdapDto.getLdapBaseDN();
        LOG.debug("Search Base will be: " + (String)searchBase);
        NamingEnumeration<SearchResult> matchingEnum = null;
        TreeMap<String, Map<String, List<Object>>> results = new TreeMap<String, Map<String, List<Object>>>();
        int count = 0;
        do {
            try {
                matchingEnum = this.fContext.search((String)searchBase, searchFilter, null, newControl);
                if (matchingEnum != null && matchingEnum.hasMore()) {
                    do {
                        SearchResult sr;
                        Attributes searchResultAttributes;
                        if ((searchResultAttributes = (sr = (SearchResult)matchingEnum.nextElement()).getAttributes()) == null) continue;
                        HashMap attributeEntries = new HashMap();
                        if (requiredReturnAtts != null && requiredReturnAtts.length > 0) {
                            Attribute attIfExists = searchResultAttributes.get(requiredReturnAtts[0]);
                            if (attIfExists != null) {
                                String expectedSingleValue = (String)attIfExists.get(0);
                                results.put(expectedSingleValue, attributeEntries);
                            }
                        } else {
                            Attribute cn = searchResultAttributes.get("cn");
                            if (cn != null) {
                                results.put(cn.toString(), attributeEntries);
                            } else {
                                results.put(((Object)attributeEntries).toString(), attributeEntries);
                            }
                        }
                        String[] iterAttributes = null;
                        if (requiredReturnAtts != null) {
                            iterAttributes = requiredReturnAtts;
                        } else {
                            ArrayList<String> namesToAdd = new ArrayList<String>();
                            NamingEnumeration<String> all = searchResultAttributes.getIDs();
                            while (all.hasMore()) {
                                String o = all.next();
                                namesToAdd.add(o.toString());
                            }
                            Collections.sort(namesToAdd);
                            iterAttributes = namesToAdd.toArray(new String[namesToAdd.size()]);
                        }
                        for (int i = 0; i < iterAttributes.length; ++i) {
                            String attrib = iterAttributes[i];
                            Attribute anAtt = null;
                            if (attrib != null) {
                                anAtt = searchResultAttributes.get(attrib);
                            }
                            if (anAtt != null) {
                                ArrayList<String> attributeValues = new ArrayList<String>();
                                attributeEntries.put(anAtt.getID(), attributeValues);
                                NamingEnumeration<?> ne = anAtt.getAll();
                                if (ne == null) continue;
                                while (ne.hasMore()) {
                                    Object o = ne.nextElement();
                                    attributeValues.add(o.toString());
                                }
                                continue;
                            }
                            LOG.debug("wanted attribute [" + attrib + "] but it wasn't found in the returned set");
                        }
                    } while (matchingEnum.hasMoreElements());
                    continue;
                }
                LOG.debug("User not found with filter: " + searchFilter);
            }
            catch (NamingException ne) {
                LOG.info("failed lookup, possibly ldap connection needs renewing, retrying once more: \nException: " + ne.getLocalizedMessage() + "\nExplanation: " + ne.getExplanation() + "\n");
            }
        } while (matchingEnum == null && count++ <= 1);
        return results;
    }

    public List<LDAPUser> searchWildcarded(String partialValue) throws LDAPException {
        String matchOnEmail = null;
        if (this.fRequiredAttributes == null) {
            this.init();
        }
        StringBuilder buff = new StringBuilder();
        if (this.fLdapDto.getLdapUserEmailAttr() != null) {
            matchOnEmail = this.fLdapDto.getLdapUserEmailAttr();
        }
        buff.append("(|");
        for (String fRequiredAttribute : this.fRequiredAttributes) {
            buff.append("(").append(fRequiredAttribute).append("=*").append(partialValue).append("*)");
        }
        buff.append(")");
        List<LDAPUser> ret = matchOnEmail != null ? this.searchFor("(&(" + matchOnEmail + "=*)" + buff.toString() + ")") : this.searchFor(buff.toString());
        return ret;
    }

    public List<LDAPUser> searchFor(String searchFilter) throws LDAPException {
        LOG.debug("searchFor: " + searchFilter);
        List<LDAPUser> ldapUsers = null;
        if (this.fContext == null) {
            this.init();
        }
        NamingEnumeration<SearchResult> matchingEnum = null;
        Object searchBase = this.fLdapDto.getLdapBaseDN();
        if (this.fLdapDto.getLdapAdditionalUserDN() != null) {
            searchBase = this.fLdapDto.getLdapAdditionalUserDN() + "," + (String)searchBase;
        }
        try {
            LOG.info("Search base: " + (String)searchBase);
            matchingEnum = this.fContext.search((String)searchBase, searchFilter, null, this.fControl);
            LOG.debug("matchingEnum!=null: " + (matchingEnum != null));
            if (matchingEnum != null && matchingEnum.hasMore()) {
                ldapUsers = this.processEnum(matchingEnum);
            } else {
                LOG.debug("User not found with filter: " + searchFilter);
            }
        }
        catch (CommunicationException ce) {
            LOG.debug("LDAP Session appears to have been timed out, trying to revalidate");
            this.init();
            LOG.info("reinit: after ldap time-out complete.");
            try {
                LOG.info("reinit: looking up search filter: " + searchFilter);
                matchingEnum = this.fContext.search((String)searchBase, searchFilter, null, this.fControl);
                LOG.info("reinit: processing enum");
                ldapUsers = this.processEnum(matchingEnum);
                LOG.info("reinit: founder users? " + (ldapUsers != null && !ldapUsers.isEmpty()));
            }
            catch (NamingException ne) {
                String msg = "NamingException during resetConnection; Unable to execute search after attempted session timeout revalidation: " + ne.getLocalizedMessage();
                LOG.error(msg, (Throwable)ne);
                throw new LDAPException(msg, ne);
            }
        }
        catch (NamingException ne) {
            String msg = "NamingException during resetConnection; Unable to execute search, " + ne.getLocalizedMessage();
            LOG.error(msg, (Throwable)ne);
            throw new LDAPException(msg, ne);
        }
        int createdUsers = 0;
        if (ldapUsers != null) {
            createdUsers = ldapUsers.size();
        }
        LOG.debug("searchFor '" + searchFilter + "', returning matches: " + String.valueOf(createdUsers > 0 ? "" + createdUsers : Integer.valueOf(0)));
        return ldapUsers;
    }

    private List<LDAPUser> processEnum(NamingEnumeration en) throws LDAPException {
        LOG.debug("processEnum");
        ArrayList<LDAPUser> userList = new ArrayList<LDAPUser>();
        if (en != null) {
            while (en.hasMoreElements()) {
                SearchResult sr = (SearchResult)en.nextElement();
                LDAPUser user = this.createLDAPUser(sr);
                if (user == null) continue;
                LOG.debug("adding user to matching user list: " + user.getFullName());
                userList.add(user);
            }
        }
        return userList;
    }

    private String getFirst(Attribute att) throws NamingException {
        String ret = null;
        if (att != null) {
            ret = (String)att.get(0);
        }
        return ret;
    }

    private String[] getAll(Attribute att) throws NamingException {
        String[] ret = null;
        if (att != null) {
            ArrayList<String> values = new ArrayList<String>();
            NamingEnumeration<?> e = att.getAll();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                values.add((String)o);
            }
            ret = new String[values.size()];
            ret = values.toArray(ret);
        }
        return ret;
    }

    public boolean isGroupAddress(LDAPUser ldapUser) {
        String[] classes = ldapUser.getObjectClasses();
        boolean ret = false;
        if (classes != null) {
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].equalsIgnoreCase("group")) continue;
                ret = true;
            }
        }
        return ret;
    }

    private LDAPUser createLDAPUser(SearchResult sr) throws LDAPException {
        LOG.debug("createLDAPUser()");
        LDAPUser user = new LDAPUser();
        Attributes attribs = sr.getAttributes();
        try {
            String userid = this.getFirst(attribs.get(this.fLdapDto.getLdapUserAttr()));
            if (userid != null) {
                if (this.fLdapDto.getFullNameFormat() == 0) {
                    user.setUserId(userid.toLowerCase());
                } else if (this.fLdapDto.getFullNameFormat() == 1) {
                    user.setUserId(userid.toUpperCase());
                } else {
                    user.setUserId(userid);
                }
            }
            user.setFirstName(this.getFirst(attribs.get(this.fLdapDto.getLdapUserFirstNameAttr())));
            user.setLastName(this.getFirst(attribs.get(this.fLdapDto.getLdapUserLastNameAttr())));
            user.setEmail(this.getFirst(attribs.get(this.fLdapDto.getLdapUserEmailAttr())));
            user.setDisplayName(this.getFirst(attribs.get(this.fLdapDto.getLdapUserDisplayNameAttr())));
            if (this.fLdapDto.getLdapObjectClass() != null) {
                user.setObjectClasses(this.fLdapDto.getLdapObjectClass().split(","));
            }
        }
        catch (NamingException ne) {
            LOG.error("Unable to retrieve attributes " + ne.getExplanation() + ", " + ne.getLocalizedMessage(), (Throwable)ne);
            throw new LDAPException("Unable to retrieve attributes " + ne.getExplanation(), ne);
        }
        return user;
    }

    public Map<String, String> getEnvironmentForDto(LdapDetailsDTO dto) throws LDAPException {
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("com.sun.jndi.ldap.read.timeout", "" + dto.getLdapSearchTimeout());
        ldapEnv.put("com.sun.jndi.ldap.connect.timeout", "" + dto.getLdapConnectionTimeout());
        ldapEnv.put("java.naming.provider.url", LDAPLookupUtil.getConnectionUrl(dto));
        ldapEnv.put("java.naming.security.authentication", "simple");
        if (dto.getLdapUsername() != null && dto.getLdapPassword() != null) {
            try {
                ldapEnv.put("java.naming.security.principal", this.fSecurityUtils.decryptString(dto.getLdapUsername()));
                ldapEnv.put("java.naming.security.credentials", this.fSecurityUtils.decryptString(dto.getLdapPassword()));
            }
            catch (IOException e) {
                LOG.error("IOException: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
            catch (CSUMEncryptionException e) {
                LOG.error("CSUMEncryptionException: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        this.setupAttributesForEnv(ldapEnv);
        return ldapEnv;
    }

    public static String getConnectionUrl(LdapItemBean bean) {
        StringBuilder url = new StringBuilder();
        if (bean.isUseSSL()) {
            url.append("ldaps://");
        } else {
            url.append("ldap://");
        }
        url.append(bean.getHostname());
        url.append(":").append(bean.getPort());
        return url.toString();
    }

    public static String getConnectionUrl(LdapDetailsDTO dto) {
        StringBuilder url = new StringBuilder();
        if (dto.isLdapUseSSL()) {
            url.append("ldaps://");
        } else {
            url.append("ldap://");
        }
        url.append(dto.getLdapHostname());
        url.append(":").append(dto.getLdapPort());
        return url.toString();
    }

    public LDAPQueryResultList runGroupExpandionQuery(String ldapFilter, String[] requiredAttributes, String[] expandAttributes, long maxResults) {
        LOG.info("LDAP filter: " + ldapFilter);
        LOG.info("max (root) results: " + maxResults);
        StringBuilder requiredAttsBuff = new StringBuilder("requiredAttributes: ");
        if (requiredAttributes != null) {
            for (int i = 0; i < requiredAttributes.length; ++i) {
                requiredAttsBuff.append(requiredAttributes[i]);
                if (i + 1 >= requiredAttributes.length) continue;
                requiredAttsBuff.append(", ");
            }
            LOG.info(requiredAttsBuff.toString());
        }
        if (expandAttributes != null) {
            StringBuilder expandAttsBuff = new StringBuilder("expandAttributes: ");
            for (int i = 0; i < expandAttributes.length; ++i) {
                expandAttsBuff.append(expandAttributes[i]);
                if (i + 1 >= expandAttributes.length) continue;
                expandAttsBuff.append(", ");
            }
            LOG.info(expandAttsBuff.toString());
        }
        ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> restResultListDto = new ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult>();
        LDAPQueryResultList restResult = new LDAPQueryResultList(restResultListDto);
        try {
            this.resetConnection();
            Map<String, Map<String, List<Object>>> searchResult = this.searchFor(ldapFilter, requiredAttributes, maxResults);
            boolean mAD = true;
            for (String username : searchResult.keySet()) {
                com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult = this.sortKeysAndSetAttr(restResultListDto, searchResult, username);
                if (expandAttributes != null) {
                    this.expandResults(aResult, requiredAttributes, expandAttributes, 0);
                }
                if (mAD) {
                    mAD = this.logResultIfMAD(aResult);
                    continue;
                }
                this.logResultNotMAD(aResult);
            }
        }
        catch (Exception e) {
            restResult.setError(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
        }
        return restResult;
    }

    private com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult sortKeysAndSetAttr(List<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> restResultListDto, Map<String, Map<String, List<Object>>> searchResult, String username) {
        Map<String, List<Object>> attributeMap = searchResult.get(username);
        com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult = new com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult();
        ArrayList<String> keysToSort = new ArrayList<String>(attributeMap.keySet());
        Collections.sort(keysToSort);
        aResult.setAttributes(keysToSort.toArray(new String[0]));
        aResult.setValues(this.buildAttributeMapArray(attributeMap));
        restResultListDto.add(aResult);
        return aResult;
    }

    public void logDistListAddressResult(LDAPQueryResult aResult) {
        StringBuilder resultTree = new StringBuilder();
        resultTree.append(LDAP_RESULT);
        resultTree.append("[root] ").append(aResult.getValues().get("mail")[0]);
        this.appendChildren(resultTree, aResult.getSubResults());
        String result = resultTree.toString() + DIVIDER;
        LOG.info(result);
    }

    public boolean logResultIfMAD(com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult) {
        boolean mAD = true;
        StringBuilder resultTree = new StringBuilder();
        resultTree.append(LDAP_RESULT);
        try {
            resultTree.append("[root] ").append(((String[])aResult.getValues().get("distinguishedName"))[0]);
        }
        catch (NullPointerException e) {
            LOG.error("Cannot find \"distinguishedName\": " + e.getClass().getSimpleName() + ", falling back to \"uid\"");
            resultTree.append("[UID]  ").append(((String[])aResult.getValues().get("uid"))[0]);
            mAD = false;
        }
        this.appendChildren(resultTree, aResult.getSubResults());
        String result = resultTree.toString() + DIVIDER;
        LOG.info(result);
        return mAD;
    }

    public boolean logResultNotMAD(com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult) {
        boolean mAD = true;
        StringBuilder resultTree = new StringBuilder();
        resultTree.append(LDAP_RESULT);
        resultTree.append("[UID]  ").append(((String[])aResult.getValues().get("uid"))[0]);
        this.appendChildren(resultTree, aResult.getSubResults());
        String result = resultTree.toString() + DIVIDER;
        LOG.info(result);
        return mAD;
    }

    private void appendChildren(StringBuilder resultTree, List<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> subResults) {
        if (subResults != null) {
            for (com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult ldapQueryResult : subResults) {
                resultTree.append("\n");
                for (int i = 0; i < ldapQueryResult.getDepth(); ++i) {
                    resultTree.append("\t");
                }
                resultTree.append("[").append(ldapQueryResult.getDepth()).append("] ");
                String[] objectClasses = (String[])ldapQueryResult.getValues().get(OBJECT_CLASS);
                String[] mailAttr = (String[])ldapQueryResult.getValues().get(this.fLdapDto.getLdapUserEmailAttr());
                if (this.isGroup(objectClasses)) {
                    resultTree.append("group: ");
                    resultTree.append(((String[])ldapQueryResult.getValues().get("distinguishedName"))[0]).append(", mail: ").append(mailAttr == null || mailAttr.length == 0 ? "not defined" : mailAttr[0]);
                    this.appendChildren(resultTree, ldapQueryResult.getSubResults());
                    continue;
                }
                if (!this.isUser(objectClasses)) continue;
                resultTree.append(" user: ");
                resultTree.append(((String[])ldapQueryResult.getValues().get("distinguishedName"))[0]).append(", mail: ").append(mailAttr == null || mailAttr.length == 0 ? "not defined" : mailAttr[0]);
            }
        }
    }

    public void expandResults(com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult parentResult, String[] requiredAttributes, String[] expandAttributes, int depth) throws LDAPException {
        if (depth >= 50 || expandAttributes == null) {
            return;
        }
        ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> subResultListDto = new ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult>();
        Map values = parentResult.getValues();
        for (String expandAttribute : expandAttributes) {
            String[] dnList = (String[])values.get(expandAttribute);
            if (dnList == null || dnList.length <= 0) continue;
            String dnFilter = this.buildDnFilter(dnList);
            this.resetConnection();
            Map<String, Map<String, List<Object>>> searchResult = this.searchWithAdditionalDN(this.fLdapDto.getLdapAdditionalGroupDN(), dnFilter, requiredAttributes, 0L);
            for (Map<String, List<Object>> attributeMap : searchResult.values()) {
                com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult subResult = new com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult();
                subResult.setDepth(depth + 1);
                ArrayList<String> keysToSort = new ArrayList<String>(attributeMap.keySet());
                Collections.sort(keysToSort);
                subResult.setAttributes(keysToSort.toArray(new String[0]));
                Map<String, String[]> attributes = this.buildAttributeMapArray(attributeMap);
                subResult.setValues(attributes);
                subResultListDto.add(subResult);
                String[] objectClasses = attributes.get(OBJECT_CLASS);
                if (objectClasses == null || !this.isGroup(objectClasses)) continue;
                this.expandResults(subResult, requiredAttributes, expandAttributes, ++depth);
            }
        }
        parentResult.setSubResults(subResultListDto);
    }

    private boolean isUser(String[] classes) {
        boolean isUser = false;
        for (String aClass : classes) {
            if (!aClass.equalsIgnoreCase("user")) continue;
            isUser = true;
            break;
        }
        return isUser;
    }

    private boolean isGroup(String[] classes) {
        boolean isGroup = false;
        for (String aClass : classes) {
            if (!aClass.equalsIgnoreCase("group")) continue;
            isGroup = true;
            break;
        }
        return isGroup;
    }

    private String buildDnFilter(String[] dnList) {
        StringBuilder dnListBldr = new StringBuilder();
        dnListBldr.append("(|");
        for (String s : dnList) {
            dnListBldr.append("(distinguishedName=").append(this.escapeDN(s)).append(")");
        }
        dnListBldr.append(")");
        return dnListBldr.toString();
    }

    private Map<String, String[]> buildAttributeMapArray(Map<String, List<Object>> attributeMap) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        for (String anAttKey : attributeMap.keySet()) {
            List<Object> attValues = attributeMap.get(anAttKey);
            ArrayList<String> attValueArr = new ArrayList<String>();
            for (Object object : attValues) {
                String s = object.toString();
                attValueArr.add(s);
            }
            attributes.put(anAttKey, attValueArr.toArray(new String[0]));
        }
        return attributes;
    }

    private Set<String> toText(Set<InternetAddress> uniqueAddressees) {
        HashSet<String> asTextAddresses = new HashSet<String>(uniqueAddressees.size());
        for (InternetAddress anAddress : uniqueAddressees) {
            asTextAddresses.add(anAddress.getAddress());
        }
        return asTextAddresses;
    }

    public void getUniqueUserList(String[] distListAddresses, String[] requireAttributes, String[] expandAttributes, int maxResults) {
        LOG.debug("getUniqueUserList()");
        long start = System.currentTimeMillis();
        ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> restResultListDto = new ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult>();
        LDAPQueryResultList restResult = new LDAPQueryResultList(restResultListDto);
        String mailAttr = this.fLdapDto.getLdapUserEmailAttr();
        try {
            this.resetConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("(&");
            sb.append("(|");
            for (String distListAddress : distListAddresses) {
                sb.append("(").append(mailAttr).append("=").append(distListAddress).append(")");
            }
            sb.append(")");
            sb.append(")");
            String ldapFilter = sb.toString();
            LOG.debug("LDAP user for users: " + ldapFilter);
            Map<String, Map<String, List<Object>>> searchResult = this.searchFor(ldapFilter, requireAttributes, maxResults);
            Iterator<String> keyIterator = searchResult.keySet().iterator();
            if (keyIterator.hasNext()) {
                String username = keyIterator.next();
                com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult = this.sortKeysAndSetAttr(restResultListDto, searchResult, username);
                if (expandAttributes != null) {
                    this.expandResults(aResult, null, expandAttributes, 0);
                }
                this.logResultIfMAD(aResult);
            } else {
                String msg = "No results found for filter: " + ldapFilter;
                LOG.debug(msg);
            }
            HashMap<String, com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> uniqueUserSearchResults = new HashMap<String, com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult>();
            List results = restResult.getResults();
            for (com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult ldapQueryResult : results) {
                this.addResult(uniqueUserSearchResults, ldapQueryResult);
            }
        }
        catch (LDAPException e) {
            LOG.error("LDAP exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOG.error("Unhandled exception querying backend LDAP: " + e.getClass().getSimpleName() + " :" + e.getLocalizedMessage());
        }
        String duration = System.currentTimeMillis() - start + " mS";
        LOG.debug("Query time: " + duration);
    }

    private void addResult(Map<String, com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> uniqueUsers, com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult ldapQueryResult) {
        Map valueMap = ldapQueryResult.getValues();
        String[] objectClasses = (String[])valueMap.get(OBJECT_CLASS);
        if (this.isUser(objectClasses)) {
            String[] mailPossibilities = (String[])valueMap.get("mail");
            if (!uniqueUsers.containsKey(mailPossibilities[0])) {
                uniqueUsers.put(mailPossibilities[0], ldapQueryResult);
            }
        } else if (this.isGroup(objectClasses)) {
            List subResults = ldapQueryResult.getSubResults();
            for (com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult ldapQueryResult2 : subResults) {
                this.addResult(uniqueUsers, ldapQueryResult2);
            }
        }
    }

    public String escapeDN(String dnIn) {
        return Rdn.escapeValue(dnIn);
    }

    public LDAPQueryResultList runGroupExpansionQuery(String ldapFilter, String[] requiredAttributes, String[] expandAttributes, long maxResults) {
        LOG.info("LDAP filter: " + ldapFilter);
        LOG.info("max (root) results: " + maxResults);
        StringBuilder requiredAttsBuff = new StringBuilder("requiredAttributes: ");
        if (requiredAttributes != null) {
            for (int i = 0; i < requiredAttributes.length; ++i) {
                requiredAttsBuff.append(requiredAttributes[i]);
                if (i + 1 >= requiredAttributes.length) continue;
                requiredAttsBuff.append(", ");
            }
            LOG.info(requiredAttsBuff.toString());
        }
        if (expandAttributes != null) {
            StringBuilder expandAttsBuff = new StringBuilder("expandAttributes: ");
            for (int i = 0; i < expandAttributes.length; ++i) {
                expandAttsBuff.append(expandAttributes[i]);
                if (i + 1 >= expandAttributes.length) continue;
                expandAttsBuff.append(", ");
            }
            LOG.info(expandAttsBuff.toString());
        }
        ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult> restResultListDto = new ArrayList<com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult>();
        LDAPQueryResultList restResult = new LDAPQueryResultList(restResultListDto);
        try {
            this.resetConnection();
            Map<String, Map<String, List<Object>>> searchResult = this.searchFor(ldapFilter, requiredAttributes, maxResults);
            for (String username : searchResult.keySet()) {
                Map<String, List<Object>> attributeMap = searchResult.get(username);
                com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult = new com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult();
                ArrayList<String> keysToSort = new ArrayList<String>(attributeMap.keySet());
                Collections.sort(keysToSort);
                aResult.setAttributes(keysToSort.toArray(new String[0]));
                aResult.setValues(this.buildAttributeMapArray(attributeMap));
                restResultListDto.add(aResult);
                if (expandAttributes != null) {
                    this.expandResults(aResult, requiredAttributes, expandAttributes, 0);
                }
                this.logResult(aResult);
            }
        }
        catch (Exception e) {
            restResult.setError(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
        }
        return restResult;
    }

    public void logResult(com.pluginpeople.confluence.csum.api.beans.LDAPQueryResult aResult) {
        StringBuilder resultTree = new StringBuilder();
        resultTree.append(LDAP_RESULT);
        resultTree.append("[root] ").append(((String[])aResult.getValues().get("distinguishedName"))[0]);
        this.appendChildren(resultTree, aResult.getSubResults());
        String result = resultTree.toString() + DIVIDER;
        LOG.info(result);
    }
}

