/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ldap;

import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.ldap.LdapItemBean;
import com.pluginpeople.confluence.csum.service.CSUMEncryptionException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LDAPHydrationManager {
    private static final Logger LOG = LoggerFactory.getLogger(LDAPHydrationManager.class);
    private final ICSUMActiveObjectService fAos;

    @Autowired
    public LDAPHydrationManager(ICSUMActiveObjectService aos) {
        this.fAos = aos;
    }

    public Map<String, String> getMapFromStringProps(String propertiesAsStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Properties p = new Properties();
            p.load(new ByteArrayInputStream(propertiesAsStr.getBytes()));
            for (Object o : p.keySet()) {
                String aKey = (String)o;
                String aVal = (String)p.get(aKey);
                map.put(aKey, aVal);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load additional params as a map", (Throwable)e);
        }
        return map;
    }

    public String getStringFromPropsMap(Map<String, String> map) {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String aKey = entry.getKey();
            String aValue = entry.getValue();
            if (aKey == null || aKey.isEmpty()) continue;
            out.append(aKey).append("=").append(aValue).append("\n");
        }
        return out.toString();
    }

    public LdapDetailsDTO getSerializableLdapConfig(CSUMLdapConfigEntity ldapConfig) {
        LdapDetailsDTO dto = new LdapDetailsDTO();
        dto.setID(ldapConfig.getID());
        dto.setLdapConfigName(ldapConfig.getLdapConfigName());
        dto.setSortOrder(ldapConfig.getSortOrder());
        dto.setLdapAdditionalGroupDN(ldapConfig.getAdditionalGroupDN());
        if (ldapConfig.getAdditionalParams() != null) {
            dto.setLdapAdditionalParams(this.getMapFromStringProps(ldapConfig.getAdditionalParams()));
        }
        dto.setLdapAdditionalUserDN(ldapConfig.getAdditionalUserDN());
        dto.setLdapBaseDN(ldapConfig.getBaseDN());
        dto.setLdapConnectionTimeout(ldapConfig.getConnectionTimeout());
        dto.setLdapUserGroupMembershipAttr(ldapConfig.getGroupMembershipAttr());
        dto.setLdapHostname(ldapConfig.getHostname());
        dto.setLdapObjectClass(ldapConfig.getObjectClass());
        dto.setLdapObjectFilter(ldapConfig.getObjectFilter());
        dto.setLdapPort(ldapConfig.getPort());
        dto.setLdapResultsPerPage(ldapConfig.getResultsPerPage());
        dto.setLdapSearchTimeout(ldapConfig.getSearchTimeout());
        dto.setLdapTestLookupUsername(ldapConfig.getTestLookupUsername());
        dto.setLdapUsePagedResults(ldapConfig.getUsePagedResults());
        dto.setLdapUserAttr(ldapConfig.getUsernameAttr());
        dto.setLdapUserDisplayNameAttr(ldapConfig.getUserDisplayNameAttr());
        dto.setLdapUserEmailAttr(ldapConfig.getUserEmailAttr());
        dto.setLdapUserFirstNameAttr(ldapConfig.getUserFirstNameAttr());
        dto.setLdapUserLastNameAttr(ldapConfig.getUserLastNameAttr());
        dto.setLdapUserPasswordAttr(ldapConfig.getUserPasswordAttr());
        dto.setLdapUserRDNAttr(ldapConfig.getUserRDNAttr());
        dto.setLdapUseSSL(ldapConfig.isUseSSL());
        dto.setValidateOnSave(ldapConfig.getValidateOnSave());
        return dto;
    }

    public CSUMLdapConfigEntity getDeSerializedLdapConfig(LdapItemBean ldapItemBean) {
        CSUMLdapConfigEntity deSerializedLdapConfig = null;
        try {
            deSerializedLdapConfig = this.fAos.createLdapConfig(ldapItemBean);
        }
        catch (CSUMEncryptionException e) {
            LOG.error("CSUM Encryption Exception{}", (Object)e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOG.error("IO Exception{}", (Object)e.getLocalizedMessage());
        }
        return deSerializedLdapConfig;
    }

    public CSUMLdapConfigEntity restoreLDAPFromXml(String xml) throws JAXBException {
        String nonNullXml = xml.replace("\u0000", "");
        if (xml.length() != nonNullXml.length()) {
            LOG.info("Found and removed " + (xml.length() - nonNullXml.length()) + " NULLs");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LdapItemBean.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        LdapItemBean ldapBean = (LdapItemBean)unmarshaller.unmarshal((Reader)new StringReader(nonNullXml));
        StringWriter writer = new StringWriter();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)ldapBean, (Writer)writer);
        return this.getDeSerializedLdapConfig(ldapBean);
    }

    public String exportLDAPAsXml(CSUMLdapConfigEntity ldapEntity) throws JAXBException {
        LdapDetailsDTO ldapConfigBean = this.getSerializableLdapConfig(ldapEntity);
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LdapDetailsDTO.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)ldapConfigBean, (Writer)writer);
        String xml = writer.toString();
        LOG.debug(xml);
        return xml;
    }
}

