/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.ITConfigManager;
import com.pluginpeople.confluence.csum.api.beans.ConfigBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITConfigManagerImpl
implements ITConfigManager {
    private final ICSUMCacheManager fCacheManager;
    private final ICSUMActiveObjectService fAos;

    @Autowired
    public ITConfigManagerImpl(ICSUMCacheManager cacheManager, ICSUMActiveObjectService aos) {
        this.fCacheManager = cacheManager;
        this.fAos = aos;
    }

    public ConfigBean getConfiguration() {
        ICSUMCachedConfig current = this.fCacheManager.getCachedConfig();
        ConfigBean bean = new ConfigBean();
        if (current != null) {
            bean.setGroupPrefixPattern(current.getGroupPrefixPattern());
            bean.setGroupSuffixPattern(current.getGroupSuffixPattern());
            bean.setAutoJoinGroups(current.getAutoJoinGroups());
            bean.setGroupActionsPermitted(current.isGroupActionsPermitted());
            bean.setGroupAddRemovePermitted(current.isGroupAddRemovePermitted());
            bean.setGroupRenamePermitted(current.isGroupRenamePermitted());
            bean.setRenameGlobalPermitted(current.isRenameGlobalPermitted());
            bean.setCleanSpacePermsSelected(current.getCleanSpacePermsSelected());
            bean.setCleanPagePermsSelected(current.getCleanPagePermsSelected());
            bean.setRemoveUserFromPermGrpPerm(current.isRemoveUserFromPermGrpPerm());
            bean.setDlgGrpActPerm(current.isDlgGrpActPerm());
            bean.setShowGroupInformation(current.getShowGroupInformation());
            bean.setGroupPrefixPattern(current.getGroupPrefixPattern());
            bean.setGroupSuffixPattern(current.getGroupSuffixPattern());
            bean.setGroupNameRegexp(current.getGroupNameRegexp());
            bean.setMaxGroupIDsLimit(current.getMaxGroupIDsLimit());
            bean.setMaxUserIDsLimit(current.getMaxUserIDsLimit());
            bean.setPersonalSpaceAllowed(current.isPersonalSpaceAllowed());
            bean.setPluginDown(current.isPluginDown());
            bean.setPluginDownMsg(current.getPluginDownMsg());
            bean.setUserSearchEnabled(current.isUserSearchEnabled());
            bean.setDisabledUserHandling(current.getDisabledUserHandling());
            bean.setBlocklistGroups(current.getBlocklistGroups());
            bean.setGroupFilter(current.getGroupFilter());
            bean.setGroupFilterBehavior(current.getGroupFilterBehavior());
            bean.setCreateUsersEnabled(current.isCreateUsersEnabled());
            bean.setUserDirectories(current.getUserDirectories());
            bean.setExtLdapDirectories(current.getExtLdapDirectories());
            bean.setHideUserOperations(current.isHideUserOperations());
            bean.setHideGroupOperations(current.isHideGroupOperations());
            bean.setAllowAdminDeleteAudits(current.isAllowAdminDeleteAudits());
            bean.setGroupPageProcessing(current.isGroupPageProcessing());
            bean.setUserPageProcessing(current.isUserPageProcessing());
            bean.setDisableFileImport(current.getDisableFileImport());
            bean.setDisableFileExport(current.getDisableFileExport());
            bean.setIgnorePermissionCheck(current.isIgnorePermissionCheck());
        }
        return bean;
    }

    public void setConfiguration(ConfigBean config) {
        CSUMConfigEntity entity = this.fAos.getConfig();
        if (entity != null) {
            entity.setGroupPrefixPattern(config.getGroupPrefixPattern());
            entity.setGroupSuffixPattern(config.getGroupSuffixPattern());
            entity.setAutoJoinGroups(config.getAutoJoinGroups());
            entity.setGroupActionsPermitted(config.isGroupActionsPermitted());
            entity.setGroupAddRemovePermitted(config.isGroupAddRemovePermitted());
            entity.setGroupRenamePermitted(config.isGroupRenamePermitted());
            entity.setRenameGlobalPermitted(config.isRenameGlobalPermitted());
            entity.setCleanSpacePermsSelected(config.getCleanSpacePermsSelected());
            entity.setCleanPagePermsSelected(config.getCleanPagePermsSelected());
            entity.setRemoveUserFromPermGrpPerm(config.isRemoveUserFromPermGrpPerm());
            entity.setDlgGrpActPerm(config.isDlgGrpActPerm());
            entity.setShowGroupInformation(config.getShowGroupInformation());
            entity.setGroupPrefixPattern(config.getGroupPrefixPattern());
            entity.setGroupSuffixPattern(config.getGroupSuffixPattern());
            entity.setGroupNameRegexp(config.getGroupNameRegexp());
            entity.setMaxGroupIDsLimit(config.getMaxGroupIDsLimit());
            entity.setMaxUserIDsLimit(config.getMaxUserIDsLimit());
            entity.setPersonalSpaceAllowed(config.isPersonalSpaceAllowed());
            entity.setPluginDown(config.isPluginDown());
            entity.setPluginDownMsg(config.getPluginDownMsg());
            entity.setUserSearchEnabled(config.isUserSearchEnabled());
            entity.setDisabledUserHandling(config.getDisabledUserHandling());
            entity.setBlocklistGroups(config.getBlocklistGroups());
            entity.setGroupFilter(config.getGroupFilter());
            entity.setGroupFilterBehavior(config.getGroupFilterBehavior());
            entity.setCreateUsersEnabled(config.isCreateUsersEnabled());
            entity.setUserDirectories(config.getUserDirectories());
            entity.setExtLdapDirectories(config.getExtLdapDirectories());
            entity.setHideUserOperations(config.isHideUserOperations());
            entity.setHideGroupOperations(config.isHideGroupOperations());
            entity.setAllowAdminDeleteAudits(config.isAllowAdminDeleteAudits());
            entity.setGroupPageProcessing(config.isGroupPageProcessing());
            entity.setUserPageProcessing(config.isUserPageProcessing());
            entity.setDisableFileImport(config.getDisableFileImport());
            entity.setDisableFileExport(config.getDisableFileExport());
            entity.setIgnorePermissionCheck(config.isIgnorePermissionCheck());
            this.fAos.saveCSUMConfigEntity(entity);
        }
    }
}

