/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.action;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.avatar.AvatarProviderAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.pluginpeople.confluence.csum.action.beans.UIConfigBean;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCSUMSpaceAction
extends AbstractSpaceAction {
    private static final long serialVersionUID = -8404731613599051465L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCSUMSpaceAction.class);
    protected transient PermissionManager fPermissionManager;
    protected transient PluginLicenseManager fLicenseManager;
    protected transient ICSUMActiveObjectService fAos;
    protected transient AvatarProviderAccessor fAvatarAccessor;
    protected transient SpaceManager fSpaceManager;
    protected transient ICSUMCacheManager fCacheManager;
    protected transient GroupManager fGroupManager;
    protected transient UserManager fUserManager;
    protected transient CSUMPermissionUtil fCsumPermissionUtil;
    protected transient UserAccessor fUserAccessor;

    public void setCSUMPermissionUtil(CSUMPermissionUtil permissionUtil) {
        this.fLicenseManager = permissionUtil.getPluginLicenseManager();
        this.fCsumPermissionUtil = permissionUtil;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        super.setSpaceManager(spaceManager);
        this.fSpaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        super.setUserAccessor(userAccessor);
        this.fUserAccessor = userAccessor;
    }

    public boolean isAuthenticatedUserPresent() {
        return this.getAuthenticatedUser() != null;
    }

    public void setUserManager(UserManager userManager) {
        this.fUserManager = userManager;
    }

    public void setICSUMActiveObjectService(ICSUMActiveObjectService aos) {
        this.fAos = aos;
    }

    public void setPermissionManager(PermissionManager pm) {
        this.fPermissionManager = pm;
    }

    public void setAvatarProviderAccessor(AvatarProviderAccessor avatarAccessor) {
        this.fAvatarAccessor = avatarAccessor;
    }

    public void setCsumCacheManager(ICSUMCacheManager cacheManager) {
        this.fCacheManager = cacheManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.fGroupManager = groupManager;
    }

    protected String getUrlDecodedCleanedTrimmedParameterValue(Map paramMap, String param) {
        String value = this.getRawParameterValue(paramMap, param);
        return this.cleanParamValue(param, value);
    }

    String getUsernameFromKey(String key) {
        if (key == null) {
            return null;
        }
        ConfluenceUser userByKey = this.fUserAccessor.getUserByKey(new UserKey(key));
        if (userByKey != null) {
            return userByKey.getName();
        }
        return null;
    }

    private String cleanParamValue(String param, String value) {
        if (value != null && !(value = StringUtil.clean(value.trim())).trim().isEmpty()) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                LOG.debug("request parameter '" + (param != null ? param : "null") + "' had cleaned up value '" + value + "' which could not be URL decoded", (Throwable)e);
            }
        }
        return value;
    }

    private String getRawParameterValue(Map paramMap, String param) {
        String[] values = (String[])paramMap.get(param);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final boolean isPermitted() {
        boolean permitted = false;
        ConfluenceUser u = this.getAuthenticatedUser();
        boolean isSysAdmin = this.fPermissionManager.isSystemAdministrator(u);
        boolean isSpaceAdmin = this.fPermissionManager.hasPermission(u, Permission.ADMINISTER, (Object)this.getSpace());
        if (this.isLicenseValid() && (isSysAdmin || isSpaceAdmin)) {
            permitted = true;
        }
        return permitted;
    }

    public boolean isNotAllowed() {
        boolean isNotAllowed = false;
        String spaceKey = this.getKey();
        if (spaceKey != null && spaceKey.startsWith("~")) {
            if (!this.isPersonalSpaceAdminAllowed()) {
                LOG.info("Refused to allow " + (this.getAuthenticatedUser().getName() != null ? this.getAuthenticatedUser().getName() : "null") + " to administer users/groups in personal space " + spaceKey);
                isNotAllowed = true;
            }
        } else {
            LOG.debug("Space is not a personal space");
        }
        return isNotAllowed;
    }

    protected boolean isPersonalSpaceAdminAllowed() {
        boolean isPersonalSpaceAdminAllowed = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isPersonalSpaceAdminAllowed = cachedConfig.isPersonalSpaceAllowed();
        }
        return isPersonalSpaceAdminAllowed;
    }

    public boolean isGroupActionsPermitted() {
        boolean isGroupActionsPermitted = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isGroupActionsPermitted = cachedConfig.isGroupActionsPermitted();
        }
        return isGroupActionsPermitted;
    }

    public boolean isRemoveUserFromPermGrpPerm() {
        boolean isRemoveUserFromPermGrpPerm = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isRemoveUserFromPermGrpPerm = cachedConfig.isRemoveUserFromPermGrpPerm();
        }
        return isRemoveUserFromPermGrpPerm;
    }

    public boolean isGroupAddRemovePermitted() {
        boolean isGroupAddRemovePermitted = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isGroupAddRemovePermitted = cachedConfig.isGroupAddRemovePermitted();
        }
        return isGroupAddRemovePermitted;
    }

    public boolean isGroupRenamePermitted() {
        boolean isGroupRenamePermitted = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isGroupRenamePermitted = cachedConfig.isGroupRenamePermitted();
        }
        return isGroupRenamePermitted;
    }

    public boolean isRenameGlobalPermitted() {
        boolean isRenameGlobalPermitted = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isRenameGlobalPermitted = cachedConfig.isRenameGlobalPermitted();
        }
        return isRenameGlobalPermitted;
    }

    public String getCleanSpacePermsSelected() {
        String cleanSpacePermsSelected = null;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            cleanSpacePermsSelected = cachedConfig.getCleanSpacePermsSelected();
        }
        return cleanSpacePermsSelected;
    }

    public String getCleanPagePermsSelected() {
        String cleanPagePermsSelected = null;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            cleanPagePermsSelected = cachedConfig.getCleanPagePermsSelected();
        }
        return cleanPagePermsSelected;
    }

    public boolean isDlgGrpActPerm() {
        boolean isGroupActionsPermitted = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isGroupActionsPermitted = cachedConfig.isGroupActionsPermitted();
        }
        return isGroupActionsPermitted;
    }

    public boolean isHideUserOperations() {
        boolean isHideUserOperations = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isHideUserOperations = cachedConfig.isHideUserOperations();
        }
        return isHideUserOperations;
    }

    public boolean isLdapDirectories() {
        String ldapDirectories;
        boolean isLdapDirectories = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null && (ldapDirectories = cachedConfig.getExtLdapDirectories()) != null && !ldapDirectories.trim().isEmpty()) {
            isLdapDirectories = true;
        }
        return isLdapDirectories;
    }

    public boolean isHideGroupOperations() {
        boolean isHideGroupOperations = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isHideGroupOperations = cachedConfig.isHideGroupOperations();
        }
        return isHideGroupOperations;
    }

    public boolean isAllowSpcAdminDeleteAudits() {
        boolean isAllowSpcAdminDeleteAudits = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isAllowSpcAdminDeleteAudits = cachedConfig.isAllowAdminDeleteAudits();
        }
        return isAllowSpcAdminDeleteAudits;
    }

    public boolean isGroupPageProcessing() {
        boolean isGroupPageProcessing = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isGroupPageProcessing = cachedConfig.isGroupPageProcessing();
        }
        return isGroupPageProcessing;
    }

    public boolean isUserPageProcessing() {
        boolean isUserPageProcessing = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            isUserPageProcessing = cachedConfig.isUserPageProcessing();
        }
        return isUserPageProcessing;
    }

    protected final boolean isLicenseValid() {
        boolean valid = false;
        try {
            if (this.fLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.fLicenseManager.getLicense().get();
                valid = !license.getError().isDefined();
            }
        }
        catch (Exception e) {
            LOG.error("Unhandled Exception: " + e.getLocalizedMessage());
            valid = false;
        }
        return valid;
    }

    public boolean isNotLicensed() {
        return !this.isLicenseValid();
    }

    public final String getLicenseError() {
        String msg = null;
        try {
            if (this.fLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.fLicenseManager.getLicense().get();
                if (license.getError().isDefined()) {
                    msg = ((LicenseError)license.getError().get()).toString();
                }
            } else {
                msg = "Not Installed";
            }
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
        }
        return msg;
    }

    public String formatDate(Timestamp t) {
        return this.getDateFormatter().formatDateTime((Date)t);
    }

    public String getNulled(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public UIConfigBean getConfig() {
        return new UIConfigBean(this.fCacheManager.getCachedConfig());
    }
}

