/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.setup.BootstrapManager;
import com.pluginpeople.confluence.csum.util.CSUMFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SltManager {
    private static final Logger LOG = LoggerFactory.getLogger(SltManager.class);
    private static CSUMFileUtil fCsumFileUtil;
    public static final String CSUM_SLT_NAME = "slt.properties";
    public static final String CSUM_SLT_PROPERTY = "slt";
    public static final int SLT_LENGTH = 30;

    public SltManager(BootstrapManager bootstrapManager) {
        fCsumFileUtil = new CSUMFileUtil(bootstrapManager);
    }

    public String getSLT() throws IOException {
        String salt = null;
        try {
            salt = SltManager.getLocalSLT();
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("FileNotFoundException thrown whilst attempting to read the local encryption SLT properties file, encryption/decryption of user credentials cannot be done {}", (Object)fnfe.getLocalizedMessage(), (Object)fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            LOG.error("Failed to retrieve local encryption SLT, encryption/decryption of user credentials cannot be done. Please review read/write permissions on the CONFLUENCE_HOME/data/csum directory: {}", (Object)ioe.getLocalizedMessage(), (Object)ioe);
            throw ioe;
        }
        if (salt == null) {
            String msg = "Failed to retrieve local encryption SLT, encryption/decryption of user credentials cannot be done. Please review read/write permissions on the CONFLUENCE_HOME/data/csum directory";
            LOG.error(msg);
            throw new FileNotFoundException(msg);
        }
        return salt;
    }

    private static synchronized File getLocalSLTFile() throws IOException {
        File csumSaltDir = fCsumFileUtil.getConfluenceHomeCSUMFolder();
        File csumSLT = new File(csumSaltDir, CSUM_SLT_NAME);
        if (!csumSLT.exists() && csumSLT.createNewFile()) {
            csumSLT = SltManager.createLocalSLTPropertiesFile(csumSLT);
        }
        return csumSLT;
    }

    private static File createLocalSLTPropertiesFile(File sltFile) throws IOException {
        Properties props = new Properties();
        String randomString = RandomStringUtils.random((int)30, (boolean)true, (boolean)true);
        props.setProperty(CSUM_SLT_PROPERTY, randomString);
        try (FileOutputStream os = new FileOutputStream(sltFile);){
            props.store(os, null);
        }
        catch (IOException ioe) {
            LOG.error("An IOException was thrown whilst attempting to create a new CSUM SLT Properties File. See: {}", (Object)ioe.getLocalizedMessage(), (Object)ioe);
            throw ioe;
        }
        return sltFile;
    }

    private static String getLocalSLT() throws IOException {
        File csumSLTFile;
        String sltProperties = null;
        File csumSaltDir = fCsumFileUtil.getConfluenceHomeCSUMFolder();
        if (csumSaltDir.exists() && (csumSLTFile = SltManager.getLocalSLTFile()).exists()) {
            try (FileInputStream is = new FileInputStream(csumSLTFile);){
                Properties props = new Properties();
                props.load(is);
                sltProperties = props.getProperty(CSUM_SLT_PROPERTY);
            }
            catch (IOException ioe) {
                LOG.error("An IOException was thrown whilst attempting to create a new CSUM SLT Properties File. See: {}", (Object)ioe.getLocalizedMessage(), (Object)ioe);
                throw ioe;
            }
        }
        return sltProperties;
    }
}

