/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.setup.BootstrapManager;
import com.pluginpeople.confluence.csum.service.CSUMEncryptionException;
import com.pluginpeople.confluence.csum.util.SltManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static final int KEY_BYTE_LENGTH = 32;
    private static final String ALGORITHM_KEY = "AES";
    private static final String CSUM_ENCRYPTION_PREFIX = "csum_enc_";
    private static BouncyCastleProvider gBouncyCastleProvider = new BouncyCastleProvider();
    private final SltManager fSltManager;
    private String fLocalSlt = null;
    private final String fServerId;

    public SecurityUtils(BootstrapManager bootstrapManager, String serverId) {
        this.fSltManager = new SltManager(bootstrapManager);
        this.fServerId = serverId;
        try {
            this.fLocalSlt = this.getSlt();
        }
        catch (IOException ioe) {
            LOG.error("Failed to generate SLT on instantiation, likely due to the Confluence User not having permission to read/write on the Shared Home", (Throwable)ioe);
        }
    }

    private byte[] getValidKey() throws IOException {
        String localSalt = this.getSlt();
        return this.getValidKeyFromSLT(localSalt);
    }

    private String getSlt() throws IOException {
        if (this.fLocalSlt == null) {
            this.fLocalSlt = this.fSltManager.getSLT();
        }
        return this.fLocalSlt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getValidKeyFromSLT(String slt) throws IOException {
        byte[] keyBytes = null;
        if (slt != null && !slt.isEmpty()) {
            String encryptionString = slt + this.fServerId;
            String hashedEncryptionString = DigestUtils.md5Hex((byte[])encryptionString.getBytes());
            if (hashedEncryptionString.getBytes().length == 32) {
                return hashedEncryptionString.getBytes();
            }
            String msg = "Failed to create a valid Encryption key as provided key was not [32] bytes long as expected. Preventing Key from being used in encryption";
            LOG.error(msg);
            throw new IOException(msg);
        }
        LOG.error("Failed to retrieve local encryption SLT, encryption/decryption of user cannot be done. Please review read/write permissions on the CONFLUENCE_HOME/data/jemh directory");
        return keyBytes;
    }

    public String encryptString(String toEncrypt) throws IOException, CSUMEncryptionException {
        Object returnString = toEncrypt;
        if (toEncrypt != null && !toEncrypt.startsWith(CSUM_ENCRYPTION_PREFIX)) {
            byte[] processedEncryption = this.process(this.getValidKey(), toEncrypt.getBytes(), true);
            String encryptedString = processedEncryption != null ? Base64.encodeBase64String((byte[])processedEncryption) : null;
            returnString = encryptedString != null ? CSUM_ENCRYPTION_PREFIX + encryptedString : null;
        }
        return returnString;
    }

    public String decryptString(String toDecrypt) throws IOException, CSUMEncryptionException {
        String returnString = toDecrypt;
        if (toDecrypt != null && toDecrypt.startsWith(CSUM_ENCRYPTION_PREFIX)) {
            String rawStringToDecrypt = toDecrypt.substring(CSUM_ENCRYPTION_PREFIX.length());
            byte[] processedDecryption = this.process(this.getValidKey(), Base64.decodeBase64((String)rawStringToDecrypt), false);
            returnString = processedDecryption != null ? new String(processedDecryption) : null;
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] process(byte[] key, byte[] input, boolean isEncryption) throws CSUMEncryptionException {
        GeneralSecurityException exception = null;
        byte[] processedBytes = null;
        try {
            BouncyCastleProvider bouncyCastleProvider = gBouncyCastleProvider;
            synchronized (bouncyCastleProvider) {
                Cipher cipher = Cipher.getInstance(ALGORITHM_KEY, (Provider)gBouncyCastleProvider);
                SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_KEY);
                cipher.init(isEncryption ? 1 : 2, secretKey);
                processedBytes = cipher.doFinal(input);
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            exception = e;
        }
        if (exception != null) {
            LOG.error("Failed to Encrypt/Decrypt provided input. Please see: {}", (Object)exception.getLocalizedMessage());
            throw new CSUMEncryptionException(exception);
        }
        return processedBytes;
    }
}

