/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.JSONAddUserResultBean;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.rest.beans.Select2ResponseBean;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedDlgGroup;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgEntryXmlStrConv;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import com.pluginpeople.confluence.csum.util.GroupUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresLicensedConfluenceAccess
@Path(value="/space/dlg")
public class SpaceDelegatedResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceDelegatedResource.class);
    private final GroupUtil fGroupUtil;
    private final UserAccessor fUserAccessor;
    private final GroupManager fGroupManager;
    private final ICSUMCacheManager fCacheManager;
    private final DlgGroupManager fDgm;
    private final PluginAccessor fPluginAccessor;

    @Inject
    public SpaceDelegatedResource(@ComponentImport SpaceManager spaceManager, GroupUtil groupUtil, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager, ICSUMCacheManager cacheManager, DlgGroupManager dGm, CSUMPermissionUtil permissionUtil, @ComponentImport XsrfTokenService tokenService, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fGroupUtil = groupUtil;
        this.fUserAccessor = userAccessor;
        this.fGroupManager = groupManager;
        this.fCacheManager = cacheManager;
        this.fDgm = dGm;
        this.fPluginAccessor = pluginAccessor;
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response getDelegatedGroups(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="searchVal") String search, @QueryParam(value="isGroupProc") boolean isServerSideProcEnabled, @QueryParam(value="length") int maxRows, @QueryParam(value="draw") int draw, @QueryParam(value="start") int offset, @QueryParam(value="atl_token") String atlToken) throws EntityException, JAXBException {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            boolean validSpace = false;
            try {
                validSpace = this.getValidSpaceFromKey(spaceKey) != null;
            }
            catch (InvalidSpaceException e) {
                LOG.error("Invalid Space, cannot retrieve dlgGroups in delegated resource", (Throwable)e);
            }
            if (!validSpace) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else if (this.invalidPrefixAndSuffix()) {
                LOG.error("Neither the prefix or suffix is set in the CSUM config");
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            } else {
                ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
                if (remoteUser != null) {
                    String[] groupEntryBeans = isServerSideProcEnabled ? this.fCacheManager.getPagedDlgGroupsForUser(remoteUser, maxRows, offset, search) : this.fCacheManager.getDlgGroupsForUser(remoteUser, search);
                    int total = groupEntryBeans.length;
                    CSUMCachedDlgGroup[] visibleGroupList = new CSUMCachedDlgGroup[groupEntryBeans.length];
                    for (int i = 0; i < groupEntryBeans.length; ++i) {
                        visibleGroupList[i] = DlgEntryXmlStrConv.stringToBean(groupEntryBeans[i]);
                    }
                    response = Response.ok((Object)this.fDgm.formatSpaceDelegatedGroupData(visibleGroupList, draw, total, total)).build();
                } else {
                    response = Response.noContent().build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/members")
    @Produces(value={"application/json"})
    public Response getGroupMembers(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="draw") int draw, @QueryParam(value="start") int offset, @QueryParam(value="length") int maxRows, @QueryParam(value="searchVal") String searchVal, @QueryParam(value="isUserProc") boolean isServerSideProcEnabled, @QueryParam(value="group") String group, @QueryParam(value="highlightedGroup") String selectedGroup, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            boolean validSpace = false;
            try {
                validSpace = this.getValidSpaceFromKey(spaceKey) != null;
            }
            catch (InvalidSpaceException e) {
                LOG.error("Invalid Space, cannot retrieve group members in delegated resource", (Throwable)e);
            }
            if (!validSpace) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else if (this.invalidPrefixAndSuffix()) {
                LOG.error("Neither the prefix or suffix is set in the CSUM config");
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            } else {
                try {
                    DataTableUserList dataTableFormat;
                    List<Object> memberList;
                    if (isServerSideProcEnabled && this.serverSideGroupSelected(selectedGroup)) {
                        String groupName = null;
                        String[] split = selectedGroup.split(",");
                        if (split.length > 0) {
                            groupName = split[1];
                        }
                        memberList = searchVal != null && !searchVal.isEmpty() ? this.fGroupUtil.getPagedGroupMembers(groupName, offset, maxRows, searchVal) : this.fGroupUtil.getPagedGroupMembers(groupName, offset, maxRows, null);
                    } else {
                        memberList = !isServerSideProcEnabled ? this.fGroupUtil.getGroupMembers(group) : new ArrayList();
                    }
                    User[] arr = new User[memberList.size()];
                    memberList.toArray(arr);
                    if (isServerSideProcEnabled) {
                        int filteredRecords = 0;
                        int totalRecords = 0;
                        if (this.serverSideGroupSelected(selectedGroup)) {
                            String[] split = selectedGroup.split(",");
                            totalRecords = this.fGroupUtil.getTotalGroupMembersCount(split[1]);
                            filteredRecords = searchVal != null && !searchVal.isEmpty() ? this.fGroupUtil.getFilteredGroupMembersCount(split[1], searchVal) : totalRecords;
                        }
                        dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGroupManager, this.fCacheManager, this.fGroupUtil, draw, totalRecords, filteredRecords);
                    } else {
                        dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGroupManager, this.fCacheManager, this.fGroupUtil);
                    }
                    response = Response.ok((Object)dataTableFormat).build();
                }
                catch (EntityException e) {
                    LOG.error("Could not get group members for: " + (group != null ? group : "null"), (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/group/search")
    @Produces(value={"application/json"})
    public Response searchGroups(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="query") String groupPrefix, @QueryParam(value="atl_token") String atlToken) throws EntityException, JAXBException {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
            if (remoteUser != null) {
                List<String> groupList = this.fDgm.performSpaceDlgGroupSearch(groupPrefix, 100, remoteUser);
                String[] groupArr = new String[groupList.size()];
                groupList.toArray(groupArr);
                List<Select2ResponseBean> result = this.getSelect2OptionsForArray(groupArr);
                response = Response.ok(result).build();
            } else {
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        return response;
    }

    @PUT
    @Path(value="/addusers")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response addUsersToGroups(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="dlgGroups") String dlgGroups, @FormParam(value="spaceUsers") String spaceUsers, @FormParam(value="importViaGroups") String importViaGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = null;
            try {
                validSpace = this.getValidSpaceFromKey(spaceKey);
            }
            catch (InvalidSpaceException e) {
                LOG.error("Invalid Space, cannot add members in delegated resource", (Throwable)e);
            }
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
            } else if (dlgGroups == null || dlgGroups.trim().isEmpty() || (spaceUsers == null || spaceUsers.trim().isEmpty()) && (importViaGroups == null || importViaGroups.trim().isEmpty())) {
                LOG.error("No groups or users specified: spaceGroups=" + dlgGroups + ", spaceUsers=" + spaceUsers);
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            } else {
                try {
                    ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
                    if (cachedConfig == null || !cachedConfig.isDlgGrpActPerm()) {
                        throw new AuthorizationException("Delegated group actions are disabled within your global CSUM configuration.");
                    }
                    JSONAddUserResultBean[] result = this.fDgm.addUsersToGroups(validSpace, dlgGroups, spaceUsers, importViaGroups);
                    response = Response.ok((Object)result).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + " is not authorized to add users to delegated groups: " + dlgGroups);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (EntityException e) {
                    LOG.error("Could not get group members for space: " + spaceKey, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error when adding users: " + (spaceUsers != null ? spaceUsers : "null") + " to group(s): " + dlgGroups + ", " + (importViaGroups != null ? importViaGroups : "null"), (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @DELETE
    @Path(value="/removeusers")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response removeGroupMembers(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="dlgGroups") String dlgGroups, @FormParam(value="userNames") String userNames, @FormParam(value="viaMembership") String viaMembershipGroups, @QueryParam(value="atl_token") String atlToken) throws EntityException {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = null;
            try {
                validSpace = this.getValidSpaceFromKey(spaceKey);
            }
            catch (InvalidSpaceException e) {
                LOG.error("Invalid Space, cannot remove members in delegated resource", (Throwable)e);
            }
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
            } else if (dlgGroups == null || dlgGroups.trim().isEmpty() || (userNames == null || userNames.trim().isEmpty()) && (viaMembershipGroups == null || viaMembershipGroups.trim().isEmpty())) {
                LOG.error("No groups or users specified: spaceGroups=" + dlgGroups + ", spaceUsers=" + userNames);
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            } else if (this.fDgm.isRemovingLastUser(dlgGroups, userNames, validSpace)) {
                response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            } else {
                try {
                    ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
                    if (cachedConfig == null || !cachedConfig.isDlgGrpActPerm()) {
                        throw new AuthorizationException("Delegated group actions are disabled within your global CSUM configuration.");
                    }
                    List<String> failedToRemove = this.fDgm.removeUsersSpaceDlgGroups(dlgGroups, userNames, viaMembershipGroups, validSpace);
                    response = Response.ok(failedToRemove).build();
                }
                catch (RemoveAllUsersException e) {
                    LOG.error("Attempting to remove last member from group(s): " + dlgGroups);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + " is not authorized to remove users from delegated groups: " + dlgGroups);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error when removing group members: " + (userNames != null ? userNames : "null") + " from: " + dlgGroups + ", " + (viaMembershipGroups != null ? viaMembershipGroups : "null"), (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    private boolean serverSideGroupSelected(String spaceGroup) {
        return spaceGroup != null && !spaceGroup.equals("") && !spaceGroup.equals("null");
    }
}

