/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.publicapi.rest;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.api.beans.AddUserOutcomeBean;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.rest.beans.publicapi.PublicApiAllGroupsList;
import com.pluginpeople.confluence.csum.rest.beans.publicapi.PublicApiGroupInfoBean;
import com.pluginpeople.confluence.csum.rest.beans.publicapi.PublicApiGroupMembersBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/public/group")
@PublicApi
public class PublicCSUMGroupResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(PublicCSUMGroupResource.class);
    private static final String NOT_AUTHORIZED_FOR_THIS_ACTION = " is not authorized for this action";
    ICSUMActiveObjectService fAos;
    private final ICSUMCacheManager fCacheManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final GroupManager fGroupManager;
    private final PluginAccessor fPluginAccessor;
    private final I18nResolver fI18n;
    private final CrowdDirectoryService fCrowdDirectoryService;
    private final UserAccessor fUserAccessor;
    private DirectoryManager fCrowdDirectoryManager;
    private static final String EMPTY_STRING = "";

    @Inject
    public PublicCSUMGroupResource(@ComponentImport SpaceManager spaceManager, ICSUMCacheManager cacheManager, @ComponentImport GroupManager groupMgr, ICSUMActiveObjectService aos, SpaceGroupUtil grpUtil, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport I18nResolver i18n, @ComponentImport AccessModeService accessModeService, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport UserAccessor userAccessor, @ComponentImport DirectoryManager directoryManager) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fCacheManager = cacheManager;
        this.fAos = aos;
        this.fSpaceGroupUtil = grpUtil;
        this.fGroupManager = groupMgr;
        this.fPluginAccessor = pluginAccessor;
        this.fI18n = i18n;
        this.fCrowdDirectoryService = crowdDirectoryService;
        this.fUserAccessor = userAccessor;
        this.fCrowdDirectoryManager = directoryManager;
    }

    @POST
    @Path(value="/create")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response createGroupFromName(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName) {
        ICSUMCachedConfig cachedConfig;
        RequestAuthenticationBean rab;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        Response response = validSpace == null ? Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build() : (!(rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow)).isAuthenticated() ? Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build() : (!this.fSpaceGroupUtil.doesMatchRegex(groupName) ? Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build() : (groupName != null ? ((cachedConfig = this.fCacheManager.getCachedConfig()) != null && !cachedConfig.isGroupActionsPermitted() ? Response.ok().status(Response.Status.UNAUTHORIZED).build() : this.createGroup(validSpace, groupName)) : Response.status((Response.Status)Response.Status.NO_CONTENT).build())));
        return response;
    }

    @DELETE
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response deleteSpaceGroup(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="groupName") String groupNameStr) {
        Response response;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String groupName = groupNameStr != null ? groupNameStr : EMPTY_STRING;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        } else {
            RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
            if (!rab.isAuthenticated()) {
                response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
            } else {
                try {
                    response = this.fSpaceGroupUtil.deleteSpaceGroup(validSpace, groupName) ? Response.ok().build() : Response.notModified().build();
                }
                catch (EntityException e) {
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + " not authorised for this action", (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (GroupActionNotPermittedException e) {
                    LOG.error("Group actions disabled in CSUM config for space: " + spaceKey, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error("SpaceKey: " + spaceKey + " is not associated with group: " + groupName, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error occurred when deleting space group: " + groupName, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @PUT
    @Path(value="/addusers")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response addUsersToGroups(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="spaceGroups") String spaceGroupsStr, @QueryParam(value="spaceUsers") String spaceUsersStr, @QueryParam(value="importViaGroups") String importViaGroupsStr) {
        Response response;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String spaceGroups = spaceGroupsStr != null ? spaceGroupsStr : EMPTY_STRING;
        String spaceUsers = spaceUsersStr != null ? spaceUsersStr : EMPTY_STRING;
        String importViaGroups = importViaGroupsStr != null ? importViaGroupsStr : EMPTY_STRING;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        } else {
            RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
            if (!rab.isAuthenticated()) {
                response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
            } else if (spaceUsers.trim().isEmpty() && importViaGroups.trim().isEmpty() || spaceGroups.trim().isEmpty()) {
                LOG.error("No groups or users specified: spaceGroups=" + spaceGroups + ", importViaGroups = null, spaceUsers=null");
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            } else {
                try {
                    AddUserOutcomeBean invalidUsersAndGroups = this.fSpaceGroupUtil.addUsersToGroups(validSpace, spaceGroups, spaceUsers, importViaGroups);
                    response = Response.ok((Object)invalidUsersAndGroups.getFailedUserAdditions()).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + "Not authorised for this action");
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exceptionBean).build();
                }
                catch (EntityException e) {
                    LOG.error("Unable to get group/user for : " + spaceGroups, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error("Spacekey: " + spaceKey + " not associated with this group", (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error when adding users: " + spaceUsers + " to groups: " + spaceGroups, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @DELETE
    @Path(value="/removeusers")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response removeUsersFromGroups(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="spaceGroups") String spaceGroupsStr, @QueryParam(value="spaceUsers") String spaceUsersStr, @QueryParam(value="importViaGroups") String importViaGroupsStr) {
        Response response;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String spaceGroups = spaceGroupsStr != null ? spaceGroupsStr : EMPTY_STRING;
        String spaceUsers = spaceUsersStr != null ? spaceUsersStr : EMPTY_STRING;
        String importViaGroups = importViaGroupsStr != null ? importViaGroupsStr : EMPTY_STRING;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
        } else {
            RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
            if (!rab.isAuthenticated()) {
                response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
            } else if (spaceGroups.trim().isEmpty() || spaceUsers.trim().isEmpty() && importViaGroups.trim().isEmpty()) {
                LOG.error("Insufficient data: spaceKey=" + spaceKey + ", spaceGroups=" + spaceGroups + ", spaceGroupMembers=" + spaceUsers + "}, importViaGroups=" + importViaGroups);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.fI18n.getText("space.not.found", new Serializable[]{spaceKey})).build();
            } else {
                try {
                    ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                    if (currentUser != null) {
                        this.fSpaceGroupUtil.removeGroupMembers(validSpace, spaceGroups, spaceUsers, importViaGroups, currentUser);
                        response = Response.ok().build();
                    } else {
                        response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + " not authorised for this action.", (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error("Problem with spacekey: " + spaceKey, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (EntityException e) {
                    LOG.error("Could not find users/groups: " + spaceGroups + ", " + spaceUsers, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (Exception e) {
                    LOG.error("Could not remove " + spaceUsers + " from group: " + spaceGroups, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    private Response createGroup(Space space, String groupName) {
        Response response;
        try {
            Group createdGroup;
            response = space != null ? ((createdGroup = this.fSpaceGroupUtil.createSpaceGroup(space, groupName)) != null ? Response.ok().build() : Response.serverError().build()) : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (DuplicateException e) {
            LOG.error("space group " + groupName + " already exists", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + " not authorized.", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (GroupActionNotPermittedException e) {
            LOG.error("Group actions disabled in CSUM config for space: " + space.getKey(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (EntityException e) {
            LOG.error("Error fetching existing space groups", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred when creating space group: " + groupName, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).build();
        }
        return response;
    }

    private Space getValidSpaceFromSpaceKey(@QueryParam(value="spaceKey") String spaceKey) {
        Space validSpace = null;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
        }
        return validSpace;
    }

    @GET
    @Path(value="/members")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response exportGroupMembers(@Context HttpServletResponse requestResponse, @QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="groupName") String groupNameStr) {
        Response response;
        block9: {
            String userKeyString;
            String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            UserKey userKey = currentUser != null ? currentUser.getKey() : null;
            String string = userKeyString = userKey != null ? userKey.toString() : null;
            if (validSpace != null) {
                RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
                if (!rab.isAuthenticated()) {
                    response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
                } else {
                    String groupName = groupNameStr != null ? groupNameStr : EMPTY_STRING;
                    try {
                        Group validGroup = this.fGroupManager.getGroup(groupName);
                        if (validGroup != null) {
                            boolean isUserAuthorisedToPerformGroupMembersExport = this.fSpaceGroupUtil.isUserAuthorisedToViewOrModifyGroup(validSpace, validGroup.getName());
                            if (isUserAuthorisedToPerformGroupMembersExport) {
                                this.fSpaceGroupUtil.exportGroupMembers(validGroup, requestResponse);
                                return null;
                            }
                            String msg = "User is not authorised";
                            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.apiExportGroupMembers, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, null, groupName, userKeyString, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)msg).build();
                            break block9;
                        }
                        String msg = "Group does not exist";
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.apiExportGroupMembers, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, groupName, userKeyString, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                        response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
                    }
                    catch (EntityException e) {
                        String msg = "Unhandled error occurred when exporting Group members";
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.apiExportGroupMembers, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, groupName, userKeyString, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                        ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                    }
                    catch (Exception e) {
                        String msg = "Unhandled error occurred when exporting Group members";
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.apiExportGroupMembers, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, groupName, userKeyString, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                        LOG.error(msg, (Throwable)e);
                        ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                        response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                    }
                }
            } else {
                String msg = "Space does not exist";
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.apiExportGroupMembers, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, groupNameStr, userKeyString, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/members/search")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response searchForGroupMembers(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="groupName") String groupNameStr, @QueryParam(value="query") String query, @QueryParam(value="offset") int offset, @QueryParam(value="pageSize") int pageSize) {
        Response response;
        block12: {
            String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace != null) {
                RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
                if (!rab.isAuthenticated()) {
                    response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
                } else {
                    try {
                        String groupName = groupNameStr != null ? groupNameStr : EMPTY_STRING;
                        Group validGroup = this.fGroupManager.getGroup(groupName);
                        if (validGroup != null) {
                            boolean isUserAuthorisedToPerformGroupMembersExport = this.fSpaceGroupUtil.isUserAuthorisedToViewOrModifyGroup(validSpace, validGroup.getName());
                            if (isUserAuthorisedToPerformGroupMembersExport) {
                                ArrayList<String> userNameList = new ArrayList<String>();
                                List<User> members = this.fSpaceGroupUtil.getPagedSpaceGroupMembers(validSpace, validGroup.getName(), this.getMaxGroupRetrievalSize(pageSize), offset, query, false);
                                if (members != null && !members.isEmpty()) {
                                    for (User member : members) {
                                        if (member == null || member.getName() == null) continue;
                                        userNameList.add(member.getName());
                                    }
                                }
                                response = Response.ok(userNameList).build();
                            } else {
                                String msg = "User is not authorised to view members of this group";
                                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)msg).build();
                            }
                            break block12;
                        }
                        String msg = "Group does not exist";
                        response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
                    }
                    catch (EntityException e) {
                        String msg = "Unhandled error occurred when gathering Group members";
                        LOG.error(msg, (Throwable)e);
                        ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                    }
                    catch (Exception e) {
                        String msg = "Unhandled error occurred when gathering Group members";
                        LOG.error(msg, (Throwable)e);
                        ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                        response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                    }
                }
            } else {
                String msg = "Space does not exist";
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getSpaceGroupInfo(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName) {
        Response response;
        block19: {
            response = Response.notModified().build();
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace != null) {
                RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
                if (!rab.isAuthenticated()) {
                    response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
                } else if (groupName != null) {
                    boolean isShowGroupInfo;
                    boolean bl = isShowGroupInfo = this.fCacheManager.getCachedConfig() != null && this.fCacheManager.getCachedConfig().getShowGroupInformation();
                    if (isShowGroupInfo) {
                        try {
                            boolean isUserAuthorisedToViewGroupInfo = this.fSpaceGroupUtil.isUserAuthorisedToViewOrModifyGroup(validSpace, groupName);
                            if (isUserAuthorisedToViewGroupInfo) {
                                com.atlassian.crowd.model.group.Group group = null;
                                String groupSourceDirectory = EMPTY_STRING;
                                String groupDescription = EMPTY_STRING;
                                List allDirectories = this.fCrowdDirectoryService.findAllDirectories();
                                if (allDirectories != null && !allDirectories.isEmpty()) {
                                    for (Directory aDirectory : allDirectories) {
                                        try {
                                            group = this.fCrowdDirectoryManager.findGroupByName(aDirectory.getId().longValue(), groupName);
                                            groupSourceDirectory = aDirectory.getName() != null ? aDirectory.getName() : EMPTY_STRING;
                                            groupDescription = group.getDescription() != null ? group.getDescription() : EMPTY_STRING;
                                            break;
                                        }
                                        catch (GroupNotFoundException groupNotFoundException) {
                                        }
                                    }
                                    if (group != null) {
                                        PublicApiGroupInfoBean groupData = new PublicApiGroupInfoBean(groupName, groupSourceDirectory, groupDescription);
                                        response = Response.ok((Object)groupData).build();
                                    } else {
                                        String msg = "Group does not exist";
                                        response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
                                    }
                                } else {
                                    LOG.debug("Directory Manager could not be found. Cannot run group information query");
                                }
                                break block19;
                            }
                            String msg = "User is not authorised to see this group";
                            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)msg).build();
                        }
                        catch (DirectoryNotFoundException e) {
                            LOG.error("DirectoryNotFoundException exception while attempting to retrieve group with the name: " + groupName + ". Exception: " + e);
                            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                        }
                        catch (OperationFailedException e) {
                            LOG.error("OperationFailedException exception while attempting to retrieve group with the name: " + groupName + ". Exception: " + e);
                            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                        }
                    } else {
                        String msg = "Show Group Information is not enabled within CSUM System Admin configuration";
                        response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
                    }
                } else {
                    String msg = "GroupName not provided";
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
                }
            } else {
                String msg = "Space does not exist";
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response searchForSpaceGroups(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="query") String query, @QueryParam(value="offset") int offset, @QueryParam(value="pageSize") int pageSize) {
        Response response;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace != null) {
            RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
            if (!rab.isAuthenticated()) {
                response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
            } else if (this.invalidPrefixAndSuffix()) {
                LOG.error("Neither the prefix or suffix is set in the CSUM config");
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            } else {
                try {
                    String[] groupArr = this.fSpaceGroupUtil.getPagedSpaceGroupsFromCache(validSpace, this.getMaxGroupRetrievalSize(pageSize), offset, query);
                    groupArr = this.fSpaceGroupUtil.removeBlocklistedGroups(groupArr).toArray(new String[0]);
                    groupArr = this.fSpaceGroupUtil.removeGlobalGroups(groupArr).toArray(new String[0]);
                    response = Response.ok((Object)groupArr).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
            }
        } else {
            String msg = "Space does not exist";
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
        }
        return response;
    }

    @GET
    @Path(value="/all/space/groups")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getAllSpaceGroupsForTargetSpace(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="offset") int offset, @QueryParam(value="pageSize") int pageSize) {
        Response response;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace != null) {
            RequestAuthenticationBean rab = this.authenticateEndpointForPublicApi(validSpace, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
            if (!rab.isAuthenticated()) {
                response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
            } else if (this.invalidPrefixAndSuffix()) {
                LOG.error("Neither the prefix or suffix is set in the CSUM config");
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            } else {
                Space currentSpace = this.getValidSpaceFromSpaceKey(spaceKey);
                if (currentSpace == null) {
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                } else {
                    try {
                        Object[] spaceGroups = this.fSpaceGroupUtil.getPagedSpaceGroupsFromCache(validSpace, this.getMaxGroupRetrievalSize(pageSize), offset, null);
                        int totalFoundSpaceGroups = this.fSpaceGroupUtil.getTotalGroupsCount(currentSpace);
                        int groupsBeforeFilter = spaceGroups.length;
                        spaceGroups = this.fSpaceGroupUtil.removeBlocklistedGroups((String[])spaceGroups).toArray(new String[0]);
                        spaceGroups = this.fSpaceGroupUtil.removeGlobalGroups((String[])spaceGroups).toArray(new String[0]);
                        int filteredGroups = groupsBeforeFilter - spaceGroups.length;
                        Arrays.sort(spaceGroups);
                        ArrayList<PublicApiGroupMembersBean> data = new ArrayList<PublicApiGroupMembersBean>();
                        for (int i = 0; i < spaceGroups.length; ++i) {
                            Group group = this.fGroupManager.getGroup((String)spaceGroups[i]);
                            int membersCount = 0;
                            if (group != null) {
                                membersCount = this.fUserAccessor.getMemberNamesAsList(group).size();
                                data.add(new PublicApiGroupMembersBean(group.getName(), membersCount));
                                continue;
                            }
                            LOG.error("Error fetching groups members because the group could no be found in confluence");
                        }
                        PublicApiAllGroupsList dataTableFormat = new PublicApiAllGroupsList(data, filteredGroups, totalFoundSpaceGroups);
                        response = Response.ok((Object)dataTableFormat).build();
                    }
                    catch (AuthorizationException e) {
                        LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                        response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                    }
                    catch (Exception e) {
                        LOG.error("There was an unexpected exception thrown trying to get groups for import for space: " + spaceKey, (Throwable)e);
                        response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                    }
                }
            }
        } else {
            String msg = "Space does not exist";
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
        }
        return response;
    }

    private DirectoryManager getDirectoryManager() {
        if (this.fCrowdDirectoryManager == null) {
            this.fCrowdDirectoryManager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        }
        return this.fCrowdDirectoryManager;
    }
}

