/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.search.page.Pager;
import com.pluginpeople.confluence.csum.api.beans.ConfigBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupUtil {
    private final GroupManager fGroupManager;
    private final UserManager fUserManager;
    private final I18nResolver fI18n;
    private static final int MINUS_ONE = -1;

    @Autowired
    public GroupUtil(@ComponentImport GroupManager groupManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager) {
        this.fGroupManager = groupManager;
        this.fI18n = i18nResolver;
        this.fUserManager = userManager;
    }

    public int getTotalGroupMembersCount(String groupName) throws EntityException {
        int ret = 0;
        Group group = this.fGroupManager.getGroup(groupName);
        Pager membersPager = this.fGroupManager.getMemberNames(group);
        if (!membersPager.isEmpty()) {
            boolean notLastPage = true;
            do {
                List currentMemberPage;
                if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                    ret += currentMemberPage.size();
                }
                if (membersPager.onLastPage()) {
                    notLastPage = false;
                    continue;
                }
                membersPager.nextPage();
            } while (notLastPage);
        }
        return ret;
    }

    public int getFilteredGroupMembersCount(String groupName, String searchVal) throws EntityException {
        int ret = 0;
        Group group = this.fGroupManager.getGroup(groupName);
        Pager membersPager = this.fGroupManager.getMemberNames(group);
        if (!membersPager.isEmpty()) {
            boolean notLastPage = true;
            do {
                List currentMemberPage;
                if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                    int totalOnPage = searchVal != null && !searchVal.isEmpty() ? this.getFilterMemberPageCount(currentMemberPage, searchVal) : currentMemberPage.size();
                    ret += totalOnPage;
                }
                if (membersPager.onLastPage()) {
                    notLastPage = false;
                    continue;
                }
                membersPager.nextPage();
            } while (notLastPage);
        }
        return ret;
    }

    public int getFilterMemberPageCount(List<String> memberPage, String searchVal) throws EntityException {
        int ret = 0;
        for (String member : memberPage) {
            User aUser = this.fUserManager.getUser(member);
            String userName = aUser.getName();
            if (!searchVal.equals("")) {
                if (!userName.contains(searchVal)) continue;
                ++ret;
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public List<User> getPagedGroupMembers(String groupName, int offset, int maxRows, String searchVal) throws EntityException {
        ArrayList<User> memberList = new ArrayList<User>();
        Group group = this.fGroupManager.getGroup(groupName);
        if (group == null) {
            throw new EntityException(this.fI18n.getText("error.group.not.found") + ": " + groupName);
        }
        Pager membersPager = this.fGroupManager.getMemberNames(group);
        if (!membersPager.isEmpty()) {
            boolean notLastPage = true;
            do {
                List currentMemberPage;
                if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                    this.addUsersToList(currentMemberPage, memberList, offset, maxRows, searchVal);
                }
                if (membersPager.onLastPage()) {
                    notLastPage = false;
                    continue;
                }
                membersPager.nextPage();
            } while (notLastPage);
        }
        return memberList;
    }

    public List<User> getGroupMembers(String groupName) throws EntityException {
        ArrayList<User> memberList = new ArrayList<User>();
        Group group = this.fGroupManager.getGroup(groupName);
        if (group == null) {
            throw new EntityException(this.fI18n.getText("error.group.not.found") + ": " + groupName);
        }
        Pager membersPager = this.fGroupManager.getMemberNames(group);
        if (!membersPager.isEmpty()) {
            boolean notLastPage = true;
            do {
                List currentMemberPage;
                if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                    this.addUsersToList(currentMemberPage, memberList, -1, -1, null);
                }
                if (membersPager.onLastPage()) {
                    notLastPage = false;
                    continue;
                }
                membersPager.nextPage();
            } while (notLastPage);
        }
        return memberList;
    }

    private void addUsersToList(List<String> currentMemberPage, List<User> memberList, int offset, int maxRows, String searchVal) throws EntityException {
        if (offset >= 0 && maxRows >= 0) {
            int count = 0;
            for (int i = 0; i < currentMemberPage.size(); ++i) {
                if (searchVal != null) {
                    String lowerCaseSearchVal = searchVal.toLowerCase();
                    if (count >= maxRows || i + offset >= currentMemberPage.size()) continue;
                    User aUser = this.fUserManager.getUser(currentMemberPage.get(i + offset));
                    String userName = null;
                    String userEmail = null;
                    String userFullName = null;
                    if (aUser.getName() != null && !aUser.getName().isEmpty() && (userName = aUser.getName().toLowerCase()).contains(lowerCaseSearchVal)) {
                        memberList.add(aUser);
                        ++count;
                        continue;
                    }
                    if (aUser.getEmail() != null && !aUser.getEmail().isEmpty() && (userEmail = aUser.getEmail().toLowerCase()).contains(lowerCaseSearchVal)) {
                        memberList.add(aUser);
                        ++count;
                        continue;
                    }
                    if (aUser.getFullName() == null || aUser.getFullName().isEmpty() || !(userFullName = aUser.getFullName().toLowerCase()).contains(lowerCaseSearchVal)) continue;
                    memberList.add(aUser);
                    ++count;
                    continue;
                }
                if (count >= maxRows || i + offset >= currentMemberPage.size()) continue;
                User aUser = this.fUserManager.getUser(currentMemberPage.get(i + offset));
                memberList.add(aUser);
                ++count;
            }
        } else {
            for (String member : currentMemberPage) {
                User aUser = this.fUserManager.getUser(member);
                memberList.add(aUser);
            }
        }
    }

    public String getGroupFilteredLoz(User groupMember, GroupManager gm, ICSUMCacheManager cacheManager) throws EntityException {
        String groupFiltersCsv;
        String filterLozenge = "false";
        ICSUMCachedConfig cachedConfig = cacheManager.getCachedConfig();
        String string = groupFiltersCsv = cachedConfig != null ? cachedConfig.getGroupFilter() : null;
        if (groupFiltersCsv != null && !groupFiltersCsv.isEmpty() && !groupFiltersCsv.equalsIgnoreCase("none")) {
            boolean filterBehavior = cachedConfig.getGroupFilterBehavior();
            String[] groupFilters = groupFiltersCsv.split(",");
            if (filterBehavior) {
                for (String groupFilter : groupFilters) {
                    Group group = gm.getGroup(groupFilter);
                    if (group == null || gm.hasMembership(group, groupMember)) continue;
                    filterLozenge = groupFilter;
                    break;
                }
            } else {
                int count = 0;
                for (String groupFilter : groupFilters) {
                    Group group = gm.getGroup(groupFilter);
                    if (!gm.hasMembership(group, groupMember)) continue;
                    ++count;
                }
                if (count == 0) {
                    filterLozenge = "all filter groups";
                }
            }
        }
        return filterLozenge;
    }

    public String[] getLastNames(User[] users, String fullNameFormat) {
        String[] lastnames = new String[users.length];
        for (int i = 0; i < users.length; ++i) {
            User user = users[i];
            String fullname = user.getFullName();
            if (fullname == null) continue;
            fullname = fullname.replace(",", " ");
            fullname = fullname.replace("  ", " ");
            String[] names = fullname.split(" ");
            if (fullNameFormat.equals(ConfigBean.FULL_NAME_FORMAT.lastname_firstnoun.name())) {
                lastnames[i] = names[0];
                continue;
            }
            if (fullNameFormat.equals(ConfigBean.FULL_NAME_FORMAT.lastname_lastnoun.name())) {
                lastnames[i] = names[names.length - 1];
                continue;
            }
            if (!fullNameFormat.equals(ConfigBean.FULL_NAME_FORMAT.lastname_exludes_firstnoun.name()) || names.length <= 1) continue;
            StringBuilder fullnames = new StringBuilder();
            for (int ii = 1; ii <= names.length - 1; ++ii) {
                fullnames.append((String)(fullnames.toString().isEmpty() ? names[ii] : " " + names[ii]));
            }
            lastnames[i] = fullnames.toString();
        }
        return lastnames;
    }
}

