/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest.beans;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.api.beans.ConfigBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.GroupUtil;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="data")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class DataTableUserList {
    private String[][] data;
    private int recordsTotal;
    private int draw;
    private int recordsFiltered;

    public DataTableUserList(User[] groupMembers, UserAccessor userAccessor, GroupManager gm, ICSUMCacheManager cacheManager, GroupUtil groupUtil) throws EntityException {
        ArrayList<String[]> rawList = new ArrayList<String[]>();
        ICSUMCachedConfig cachedConfig = cacheManager.getCachedConfig();
        String fullNameFormat = cachedConfig != null ? cachedConfig.getFullNameFormat() : null;
        String[] lastnames = fullNameFormat != null && !fullNameFormat.equals(ConfigBean.FULL_NAME_FORMAT.none.name()) ? groupUtil.getLastNames(groupMembers, fullNameFormat) : new String[groupMembers.length];
        for (int i = 0; i < groupMembers.length; ++i) {
            String filterLozenge = groupUtil.getGroupFilteredLoz(groupMembers[i], gm, cacheManager);
            User groupMember = groupMembers[i];
            if (groupMember == null) continue;
            String fullName = groupMember.getFullName();
            String lastName = lastnames[i];
            String name = groupMember.getName();
            String email = String.valueOf(groupMember.getEmail());
            String isDeactivated = String.valueOf(userAccessor.isDeactivated(name));
            rawList.add(new String[]{fullName, lastName, name, email, isDeactivated, filterLozenge});
        }
        this.data = new String[rawList.size()][];
        rawList.toArray((T[])this.data);
    }

    public DataTableUserList(User[] groupMembers, UserAccessor userAccessor, GroupManager gm, ICSUMCacheManager cacheManager, GroupUtil groupUtil, int currentDraw, int totalRecords, int filteredRecords) throws EntityException {
        this.data = new String[groupMembers.length][];
        ICSUMCachedConfig cachedConfig = cacheManager.getCachedConfig();
        String fullNameFormat = cachedConfig != null ? cachedConfig.getFullNameFormat() : null;
        String[] lastnames = fullNameFormat != null && !fullNameFormat.equals(ConfigBean.FULL_NAME_FORMAT.none.name()) ? groupUtil.getLastNames(groupMembers, fullNameFormat) : new String[groupMembers.length];
        for (int i = 0; i < groupMembers.length; ++i) {
            String filterLozenge = groupUtil.getGroupFilteredLoz(groupMembers[i], gm, cacheManager);
            this.data[i] = new String[]{groupMembers[i].getFullName(), lastnames[i], groupMembers[i].getName(), String.valueOf(groupMembers[i].getEmail()), String.valueOf(userAccessor.isDeactivated(groupMembers[i].getName())), filterLozenge};
        }
        this.draw = currentDraw;
        this.recordsFiltered = filteredRecords;
        this.recordsTotal = totalRecords;
    }

    public String[][] getData() {
        return this.data;
    }

    public void setData(String[][] data) {
        this.data = data;
    }

    public int getRecordsTotal() {
        return this.recordsTotal;
    }

    public void setRecordsTotal(int rows) {
        this.recordsTotal = rows;
    }

    public int getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public void setRecordsFiltered(int rows) {
        this.recordsFiltered = rows;
    }

    public int getDraw() {
        return this.draw;
    }

    public void setDraw(int draw) {
        this.draw = draw;
    }
}

