/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LDAPQueryEncoder;
import com.pluginpeople.confluence.csum.ldap.LDAPUser;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.UserSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.UserUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/space/user")
@RequiresLicensedConfluenceAccess
public class SpaceUserResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceUserResource.class);
    private final String ALL_DIRECTORIES = "all";
    private final String CONFLUENCE_DIRECTORIES = "confluence";
    private final String LDAP_DIRECTORIES = "ldap";
    private final CrowdService fCrowdService;
    private final ICSUMCacheManager fCacheManager;
    private final DirectoryInstanceLoader fDirectoryLoader;
    private final CrowdDirectoryService fCrowdDirectoryService;
    private final ICSUMActiveObjectService fAos;
    private final UserUtil fUserUtil;

    @Inject
    public SpaceUserResource(ICSUMCacheManager cacheManager, @ComponentImport CrowdService crowdService, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport DirectoryInstanceLoader directoryLoader, @ComponentImport SpaceManager spaceManager, @ComponentImport XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, ICSUMActiveObjectService aos, UserUtil userUtil, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fCrowdService = crowdService;
        this.fCrowdDirectoryService = crowdDirectoryService;
        this.fDirectoryLoader = directoryLoader;
        this.fCacheManager = cacheManager;
        this.fAos = aos;
        this.fUserUtil = userUtil;
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchForUsers(@Context HttpServletRequest hsr, @QueryParam(value="query") String unsafeQuery, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="directory") String directory, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            long queryStart = System.currentTimeMillis();
            ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
            boolean isEnableSearch = config.isUserSearchEnabled();
            boolean isSelectDirectories = config.isSelectDirectories();
            if (isEnableSearch) {
                boolean disabledUsersHidden = false;
                ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
                if (cachedConfig.getDisabledUserHandling().equalsIgnoreCase("hide")) {
                    disabledUsersHidden = true;
                }
                ArrayList<UserSearchResult> jsonObjList = new ArrayList();
                EntityQuery userQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)unsafeQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)unsafeQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)unsafeQuery)})).startingAt(0).returningAtMost(10);
                String csvIds = config.getUserDirectories();
                if (directory != null) {
                    if (directory.equalsIgnoreCase("all") || directory.equalsIgnoreCase("confluence")) {
                        List<UserSearchResult> allConfluenceUsers = this.getUsersFromConfluenceDirectories(isSelectDirectories, csvIds, (EntityQuery<User>)userQuery);
                        jsonObjList.addAll(allConfluenceUsers);
                    }
                    if (directory.equalsIgnoreCase("all") || directory.equalsIgnoreCase("ldap")) {
                        List<UserSearchResult> allLdapUsers = this.getUsersFromLdapDirectories(unsafeQuery, config);
                        jsonObjList.addAll(allLdapUsers);
                    }
                } else {
                    jsonObjList = this.getUsersFromConfluenceDirectories(isSelectDirectories, csvIds, (EntityQuery<User>)userQuery);
                }
                this.fUserUtil.removeDisabledUsers(disabledUsersHidden, jsonObjList);
                jsonObjList.sort(Comparator.comparing(o -> o.getUsername().toLowerCase()));
                UserSearchResult[] jsonObjArr = new UserSearchResult[jsonObjList.size()];
                jsonObjList.toArray(jsonObjArr);
                long queryEnd = System.currentTimeMillis();
                long duration = queryEnd - queryStart;
                if (duration > 5000L) {
                    LOG.info("query took longer that 5 seconds: " + duration + "ms");
                }
                HashMap<String, UserSearchResult[]> result = new HashMap<String, UserSearchResult[]>();
                result.put("users", jsonObjArr);
                response = Response.ok(result).build();
            } else {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                result.put("users", new String[0]);
                response = Response.ok(result).build();
            }
        }
        return response;
    }

    private List<UserSearchResult> getUsersFromLdapDirectories(String unsafeQuery, ICSUMCachedConfig config) {
        ArrayList<UserSearchResult> allLdapUsers = new ArrayList<UserSearchResult>();
        if (config.isCreateUsersEnabled()) {
            String ldapCsvIds = config.getExtLdapDirectories();
            if (ldapCsvIds != null && !ldapCsvIds.isEmpty()) {
                String[] ldapCsvIdsArr = ldapCsvIds.split(",");
                ArrayList<CSUMLdapConfigEntity> ldapConfigEntities = new ArrayList<CSUMLdapConfigEntity>();
                for (String s : ldapCsvIdsArr) {
                    try {
                        int ldapId = Integer.parseInt(s);
                        CSUMLdapConfigEntity ldapConfigEntity = this.fAos.getLdapConfigById(ldapId);
                        if (ldapConfigEntity != null) {
                            ldapConfigEntities.add(ldapConfigEntity);
                            continue;
                        }
                        LOG.debug("Provided ID for LDAP Config did not match an existing LDAP Config: [" + s + "]");
                    }
                    catch (NumberFormatException nfe) {
                        LOG.error("Provided Id for LDAP Configuration [" + s + "] is not a valid LDAP ID", (Throwable)nfe);
                    }
                }
                String safeQuery = LDAPQueryEncoder.encode(unsafeQuery);
                for (CSUMLdapConfigEntity anLdapConfig : ldapConfigEntities) {
                    LOG.info("Checking ext ldap: id=" + anLdapConfig.getID() + ", name=" + anLdapConfig.getLdapConfigName());
                    LdapDetailsDTO dto = this.fAos.getLdapDto(anLdapConfig);
                    LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
                    try {
                        List<LDAPUser> ldapUserList = lookupUtil.searchWildcarded(safeQuery);
                        if (ldapUserList == null) continue;
                        ArrayList<LDAPUser> toRemove = new ArrayList<LDAPUser>();
                        if (!ldapUserList.isEmpty() && !allLdapUsers.isEmpty()) {
                            block6: for (LDAPUser ldapUser : ldapUserList) {
                                for (UserSearchResult aFoundUser : allLdapUsers) {
                                    String aFoundUserEmail = aFoundUser.getEmail();
                                    String ldapUserEmail = ldapUser.getEmail();
                                    if (aFoundUserEmail != null && aFoundUserEmail.equalsIgnoreCase(ldapUserEmail)) {
                                        toRemove.add(ldapUser);
                                        LOG.debug("Removing already existing ldap user with email: " + ldapUserEmail);
                                        continue block6;
                                    }
                                    String aFoundUserUsername = aFoundUser.getUsername();
                                    String ldapUserId = ldapUser.getUserId();
                                    if (ldapUserId == null || !ldapUserId.equalsIgnoreCase(aFoundUserUsername)) continue;
                                    toRemove.add(ldapUser);
                                    LOG.debug("Removing already existing ldap user with userId: " + ldapUserId);
                                    continue block6;
                                }
                            }
                        }
                        if (!toRemove.isEmpty()) {
                            LOG.debug("Removing " + toRemove.size() + " users from ldap results that already exist in user directories");
                            ldapUserList.removeAll(toRemove);
                        }
                        for (LDAPUser ldapUser : ldapUserList) {
                            UserSearchResult o = new UserSearchResult(ldapUser.getUserId(), ldapUser.getDisplayName(), ldapUser.getEmail());
                            o.setSource("LDAP");
                            allLdapUsers.add(o);
                        }
                    }
                    catch (LDAPException e) {
                        LOG.error("LDAP problem: ", (Throwable)e);
                    }
                }
            } else {
                LOG.debug("Not querying external ldap, create users off");
            }
        }
        return allLdapUsers;
    }

    private List<UserSearchResult> getUsersFromConfluenceDirectories(boolean isSelectDirectories, String csvIds, EntityQuery<User> userQuery) {
        ArrayList<UserSearchResult> allConfluenceUsers = new ArrayList<UserSearchResult>();
        if (!isSelectDirectories || csvIds == null) {
            Iterable results = this.fCrowdService.search(userQuery);
            for (User aUser : results) {
                UserSearchResult o = new UserSearchResult(aUser.getName(), aUser.getDisplayName(), aUser.getEmailAddress());
                allConfluenceUsers.add(o);
            }
        } else {
            String[] idsArr;
            HashSet<Long> selectedDirectories = new HashSet<Long>();
            for (String s : idsArr = csvIds.split(",")) {
                selectedDirectories.add(Long.valueOf(s));
            }
            List allDirectories = this.fCrowdDirectoryService.findAllDirectories();
            for (Directory aDirectory : allDirectories) {
                String name = aDirectory.getName();
                if (aDirectory.isActive() && selectedDirectories.contains(aDirectory.getId())) {
                    LOG.debug("Using selected user repo for user search: id=" + aDirectory.getId() + ", name=" + aDirectory.getName() + ", impl=" + aDirectory.getImplementationClass());
                    try {
                        RemoteDirectory directoryInstance = this.fDirectoryLoader.getDirectory(aDirectory);
                        List directoryResults = directoryInstance.searchUsers(userQuery);
                        for (User aUser : directoryResults) {
                            UserSearchResult o = new UserSearchResult(aUser.getName(), aUser.getDisplayName(), aUser.getEmailAddress());
                            allConfluenceUsers.add(o);
                        }
                        continue;
                    }
                    catch (DirectoryInstantiationException e) {
                        LOG.error("Unable to load Internal Directory: ", (Throwable)e);
                        continue;
                    }
                    catch (OperationFailedException e) {
                        LOG.error("OperationFailedException : using Internal Directory: ", (Throwable)e);
                        continue;
                    }
                }
                LOG.debug("Directory [" + name + "] is not active right now.");
            }
        }
        return allConfluenceUsers;
    }
}

