/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.loader;

import com.atlassian.cache.CacheLoader;
import com.atlassian.confluence.setup.BootstrapManager;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedEncryptionStatus;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedEncryptionStatus;
import com.pluginpeople.confluence.csum.util.CSUMFileUtil;
import java.io.File;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMCachedEncryptionStatusLoader
implements CacheLoader<String, ICSUMCachedEncryptionStatus> {
    private static CSUMFileUtil fCsumFileUtil;
    private static final Logger LOG;

    public CSUMCachedEncryptionStatusLoader(BootstrapManager bootstrapManager) {
        fCsumFileUtil = new CSUMFileUtil(bootstrapManager);
    }

    @Nonnull
    public ICSUMCachedEncryptionStatus load(@Nonnull String key) {
        File confluenceHomeCSUMFolder;
        long start = System.currentTimeMillis();
        boolean hasHomeAccess = false;
        boolean hasSltFile = false;
        if (fCsumFileUtil != null && (confluenceHomeCSUMFolder = fCsumFileUtil.getConfluenceHomeCSUMFolder()) != null) {
            hasHomeAccess = confluenceHomeCSUMFolder.canRead() && confluenceHomeCSUMFolder.canWrite();
            File csumSLT = new File(confluenceHomeCSUMFolder, "slt.properties");
            hasSltFile = csumSLT.exists() && csumSLT.canRead();
        }
        long loadTime = System.currentTimeMillis() - start;
        LOG.debug("CacheLoadTime for " + CSUMCachedEncryptionStatus.class.getName() + " was: " + loadTime + " mS");
        return new CSUMCachedEncryptionStatus(hasHomeAccess, hasSltFile);
    }

    static {
        LOG = LoggerFactory.getLogger(CSUMCachedEncryptionStatusLoader.class);
    }
}

