/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Settings {
    private static final Logger LOG = LoggerFactory.getLogger(Settings.class);
    private static final String RESOURCES_PATH = "csum/confluence/permissionmgmt/react_i18ns/";
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginSettings globalSettings;
    private final PluginAccessor pluginAccessor;

    public Settings(PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory, PluginAccessor pluginAccessor) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginAccessor = pluginAccessor;
    }

    public String getSetting(String xtaKey) {
        return this.getSetting(xtaKey, null);
    }

    public String getSetting(String xtaKey, String defaultValue) {
        Object val = this.globalSettings.get(this.getPluginKey() + "_" + xtaKey);
        if (val == null) {
            val = defaultValue;
        }
        return val.toString();
    }

    public void setSetting(String xtaKey, String value) {
        this.globalSettings.put(this.getPluginKey() + "_" + xtaKey, (Object)value);
    }

    public Boolean getBooleanSetting(String xtaKey, Boolean defaultValue) {
        Object val = this.globalSettings.get(this.getPluginKey() + "_" + xtaKey);
        if (val == null) {
            val = defaultValue;
        }
        return Boolean.parseBoolean(val.toString());
    }

    public void setBooleanSetting(String xtaKey, Boolean value) {
        this.setSetting(xtaKey, value.toString());
    }

    public String getPluginKey() {
        return this.pluginLicenseManager.getPluginKey();
    }

    public abstract String getArtifactId();

    public Plugin getPlugin() {
        return this.pluginAccessor.getPlugin(this.getPluginKey());
    }

    public abstract String getPluginName();

    public String getResourcesPath() {
        return RESOURCES_PATH;
    }

    public Map<String, String> getResourcesBasenames() {
        ArrayList<String> resources = new ArrayList<String>();
        HashMap<String, String> resourcesMap = new HashMap<String, String>();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("csum/confluence/permissionmgmt/react_i18ns/csum_resources.properties");
            if (is != null) {
                String resource;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((resource = reader.readLine()) != null) {
                    resources.add(resource);
                }
                String[] splitString = null;
                String locale = null;
                String resourceBaseName = null;
                for (String resourceString : resources) {
                    boolean validResource = false;
                    if (resourceString != null && resourceString.contains("=") && (splitString = resourceString.split("=")).length == 2) {
                        validResource = true;
                        locale = splitString[0];
                        resourceBaseName = splitString[1];
                        resourcesMap.put(locale, resourceBaseName);
                    }
                    if (validResource) continue;
                    LOG.error("Resource string is invalid and should be a Locale followed by an '=' then the name of the properties file containing the translations. Resource String: " + resourceString);
                }
            } else {
                LOG.error("Missing resource containing names of i18n resources: csum/confluence/permissionmgmt/react_i18ns/csum_resources.properties");
            }
        }
        catch (IOException ioException) {
            LOG.error("caught IOException: " + ioException);
        }
        return resourcesMap;
    }
}

