/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ldap;

import com.atlassian.confluence.setup.BootstrapManager;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.CSUMEncryptionException;
import com.pluginpeople.confluence.csum.util.CSUMFileUtil;
import com.pluginpeople.confluence.csum.util.SecurityUtils;
import java.io.File;
import java.io.IOException;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConfigEncryptionUpgrader {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConfigEncryptionUpgrader.class);
    private static final int BATCH_SIZE = 100;
    private static SecurityUtils fSecurityUtils;
    private static CSUMFileUtil fCSUMFileUtil;
    private static ICSUMActiveObjectService fAos;

    public LdapConfigEncryptionUpgrader(BootstrapManager bootstrapManager, ICSUMActiveObjectService activeObjects, String serverId) {
        fSecurityUtils = new SecurityUtils(bootstrapManager, serverId);
        fCSUMFileUtil = new CSUMFileUtil(bootstrapManager);
        fAos = activeObjects;
    }

    public synchronized void upgradeLDAPConfigs() {
        if (fCSUMFileUtil != null) {
            int ldapConfigCount = fAos.getLdapConfigCount();
            if (ldapConfigCount > 0) {
                File csumHomeDir = fCSUMFileUtil.getConfluenceHomeCSUMFolder();
                File slt = new File(csumHomeDir, "slt.properties");
                if (csumHomeDir.exists() && !slt.exists()) {
                    LOG.info("Starting the upgrade task...");
                    this.encryptLdapConfigs();
                    LOG.info("Upgrade task complete.");
                } else {
                    LOG.info("Ldap Configs already encrypted");
                }
            } else {
                LOG.info("No Ldap Config Entities to encrypt");
            }
        }
    }

    private void encryptLdapConfigs() {
        int batchStart = 0;
        int ldapConfigCount = fAos.getLdapConfigCount();
        do {
            CSUMLdapConfigEntity[] ldapConfigEntities;
            if ((ldapConfigEntities = fAos.getLdapConfigForQuery(Query.select().limit(100).offset(batchStart))) == null) continue;
            try {
                this.encrypt(ldapConfigEntities);
            }
            catch (Exception e) {
                String msg = "Exception when retrieving LDAP Config entities:  " + e.getLocalizedMessage();
                LOG.error(msg, (Throwable)e);
            }
        } while ((batchStart += 100) <= ldapConfigCount);
    }

    private void encrypt(CSUMLdapConfigEntity[] ldapConfigEntities) {
        for (CSUMLdapConfigEntity aLDAPConfig : ldapConfigEntities) {
            try {
                String encryptedPassword = fSecurityUtils.encryptString(aLDAPConfig.getPassword());
                aLDAPConfig.setPassword(encryptedPassword);
                String encryptedUsername = fSecurityUtils.encryptString(aLDAPConfig.getUsername());
                aLDAPConfig.setUsername(encryptedUsername);
                fAos.saveLdapConfigById(aLDAPConfig);
            }
            catch (CSUMEncryptionException | IOException e) {
                String msg = "Failed to Update Config due to IOException. A likely cause is that the user credentials failed to be encrypted dueto a lack of Encryption SLT. Please review permissions on the CONFLUENCE_HOME/data/csumDirectory:" + e.getLocalizedMessage();
                LOG.error(msg, (Throwable)e);
            }
        }
    }
}

