/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.api.ITCloneManager;
import com.pluginpeople.confluence.csum.rest.beans.JSONCloneGroupsResult;
import com.pluginpeople.confluence.csum.util.CloneSpaceGroupUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITCloneManagerImpl
implements ITCloneManager {
    private final TransactionTemplate fTxTemplate;
    private final CloneSpaceGroupUtil fCloneSpaceGroupUtil;

    @Autowired
    public ITCloneManagerImpl(@ComponentImport TransactionTemplate txTemplate, CloneSpaceGroupUtil cloneSpaceGroupUtil) {
        this.fTxTemplate = txTemplate;
        this.fCloneSpaceGroupUtil = cloneSpaceGroupUtil;
    }

    public boolean cloneGroups(String currentSpaceKey, String cloneFromSpaceKey, String groupsToCloneCSV, boolean cloneUsers) {
        return (Boolean)this.fTxTemplate.execute(() -> {
            JSONCloneGroupsResult result = this.fCloneSpaceGroupUtil.cloneGroupsAndUsers(currentSpaceKey, cloneFromSpaceKey, groupsToCloneCSV, cloneUsers);
            return result.getExceptionBean() == null && result.getFailedGroups() != null && result.getFailedGroups().isEmpty() && result.getFailedUsers() != null && result.getFailedUsers().isEmpty();
        });
    }
}

