/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.setup.BootstrapManager;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMFileUtil.class);
    private static final String CSUM = "CSUM";
    private String fConfluenceSharedHomePath;
    private final BootstrapManager fBootstrapManager;

    public CSUMFileUtil(BootstrapManager bootstrapManager) {
        this.fBootstrapManager = bootstrapManager;
    }

    private void determineConfluenceHomeLocationAndPathIfRequired() {
        if (this.fConfluenceSharedHomePath == null) {
            if (this.fBootstrapManager != null) {
                File sharedHomeFile = this.fBootstrapManager.getSharedHome();
                if (sharedHomeFile != null) {
                    String sharedHomeFilePath = sharedHomeFile.getPath();
                    if (StringUtils.isNotEmpty((CharSequence)sharedHomeFilePath)) {
                        this.fConfluenceSharedHomePath = sharedHomeFilePath;
                    } else {
                        LOG.error("Confluence shared home folder file path could not be found");
                    }
                } else {
                    LOG.error("Confluence shared home folder file could not be found");
                }
            } else {
                LOG.error("Confluence ApplicationProperties is null");
            }
        }
    }

    public File getConfluenceHomeCSUMFolder() {
        File resultCsumFolder = null;
        this.determineConfluenceHomeLocationAndPathIfRequired();
        if (StringUtils.isNotEmpty((CharSequence)this.fConfluenceSharedHomePath)) {
            LOG.debug("First attempting to find Confluence shared home 'csum' folder");
            File csumFolder = new File(this.fConfluenceSharedHomePath, CSUM);
            if (!csumFolder.exists()) {
                LOG.debug("Falling back to attempt to create Confluence shared home 'csum' folder");
                if (!csumFolder.mkdir()) {
                    LOG.error("Failed to create Confluence shared home 'csum' folder. Check Confluence home permissions");
                }
            }
            if (csumFolder.exists()) {
                if (csumFolder.canWrite()) {
                    LOG.debug("Confluence shared home 'csum' folder file object has been found and is writeable");
                    resultCsumFolder = csumFolder;
                } else {
                    LOG.error("Confluence shared home 'csum' folder file object has been found but is not writeable. Check Confluence shared home permissions");
                }
            } else {
                LOG.error("Confluence shared home 'csum' folder file object could not be found");
            }
        } else {
            LOG.error("Confluence shared home folder file object path could not be found");
        }
        return resultCsumFolder;
    }

    public File createFileWithinConfluenceSharedHomeCsumFolder(String prefix, String suffix) {
        File createdFile = null;
        if (StringUtils.isNotEmpty((CharSequence)prefix) && prefix.length() >= 3) {
            File sharedHomeCsumFolder = this.getConfluenceHomeCSUMFolder();
            if (sharedHomeCsumFolder != null) {
                try {
                    createdFile = File.createTempFile(prefix, suffix, sharedHomeCsumFolder);
                }
                catch (IOException ioException) {
                    LOG.error("Exception while creating File within Confluence shared home 'csum' folder", (Throwable)ioException);
                }
            } else {
                LOG.error("Confluence shared home 'csum' folder file object could not be found");
            }
        } else {
            LOG.error("Prefix must be latest 3 characters long but is currently: " + prefix);
        }
        return createdFile;
    }
}

