/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.loader;

import com.atlassian.cache.CacheLoader;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedConfig;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMConfigCacheLoader
implements CacheLoader<String, ICSUMCachedConfig> {
    private final ICSUMActiveObjectService fCao;
    private static final Logger LOG = LoggerFactory.getLogger(CSUMConfigCacheLoader.class);

    public CSUMConfigCacheLoader(ICSUMActiveObjectService cao) {
        this.fCao = cao;
    }

    public ICSUMCachedConfig load(@Nonnull String key) {
        long start = System.currentTimeMillis();
        CSUMCachedConfig result = new CSUMCachedConfig();
        CSUMConfigEntity configEntity = this.fCao.getConfig();
        if (configEntity != null) {
            result = new CSUMCachedConfig(configEntity);
        }
        long loadTime = System.currentTimeMillis() - start;
        LOG.debug("CacheLoadTime for " + CSUMCachedConfig.class.getName() + " was: " + loadTime + " mS");
        return result;
    }
}

