/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.loader;

import com.atlassian.cache.CacheLoader;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.ao.CSUMDelegatedGroupEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedDlgGroup;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedUserAuthDlgGroups;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedUserAuthDlgGroups;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMAuthUserCacheLoader
implements CacheLoader<String, ICSUMCachedUserAuthDlgGroups> {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMAuthUserCacheLoader.class);
    private static ICSUMActiveObjectService fCao;
    private static UserAccessor fUserAccessor;
    private static final int GROUP_NAME_SIZE_LIMIT = 255;
    public static final int DLG_GROUP_AUTH_LIMIT = 100;

    public CSUMAuthUserCacheLoader(ICSUMActiveObjectService activeObjectService, UserAccessor userAccessor) {
        fCao = activeObjectService;
        fUserAccessor = userAccessor;
    }

    @Nonnull
    public ICSUMCachedUserAuthDlgGroups load(@Nonnull String userKey) {
        long start = System.currentTimeMillis();
        CSUMCachedUserAuthDlgGroups ret = new CSUMCachedUserAuthDlgGroups(new CSUMCachedDlgGroup[0]);
        try {
            UserKey userKeyObj = new UserKey(userKey);
            ConfluenceUser user = fUserAccessor.getUserByKey(userKeyObj);
            if (user != null) {
                CSUMDelegatedGroupEntity[] groups = fCao.getDelegatedGroupsForUser(user);
                int groupLength = groups.length;
                if (groupLength > 255) {
                    LOG.debug("Number of Delegated Groups Authorized for user [" + userKey + "] exceeds limit of [255] Only the first [100] will be added to the cache.");
                    groupLength = 100;
                }
                CSUMCachedDlgGroup[] dlgGroupEntries = new CSUMCachedDlgGroup[groupLength];
                for (int i = 0; i < groups.length; ++i) {
                    CSUMDelegatedGroupEntity group = groups[i];
                    if (group == null || group.getGroupName() == null) continue;
                    if (group.getGroupName().length() < 255) {
                        CSUMCachedDlgGroup entry;
                        dlgGroupEntries[i] = entry = new CSUMCachedDlgGroup(group);
                        continue;
                    }
                    LOG.debug("Delegated group Entity [" + group.getID() + "] has a Group Name which exceeds Confluence's limit of [255] characters. Actual length [" + group.getGroupName().length() + "]. Delegated group will not be added to cache");
                }
                ret = new CSUMCachedUserAuthDlgGroups(dlgGroupEntries);
                long loadTime = System.currentTimeMillis() - start;
                LOG.debug("CacheLoadTime for " + CSUMCachedUserAuthDlgGroups.class.getName() + " was: " + loadTime + " mS");
            }
        }
        catch (EntityException e) {
            LOG.error("Exception occurred during cache population", (Throwable)e);
        }
        return ret;
    }
}

