/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.rest.beans.JSONCloneGroupsResult;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloneSpaceGroupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CloneSpaceGroupUtil.class);
    private static final String COMMA = "%2C";
    private static final String INVALID_REASON = "invalid";
    private final PermissionManager fPermissionManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final PluginAccessor fPluginAccessor;
    ICSUMActiveObjectService fAos;
    private final SpaceManager fSpaceManager;
    private final GroupManager fGroupManager;
    private final UserAccessor fUserAccessor;

    @Autowired
    public CloneSpaceGroupUtil(SpaceGroupUtil spaceGroupUtil, @ComponentImport SpaceManager spaceManager, @ComponentImport GroupManager groupMgr, ICSUMActiveObjectService aos, @ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.fSpaceGroupUtil = spaceGroupUtil;
        this.fSpaceManager = spaceManager;
        this.fGroupManager = groupMgr;
        this.fAos = aos;
        this.fUserAccessor = userAccessor;
        this.fPermissionManager = permissionManager;
        this.fPluginAccessor = pluginAccessor;
    }

    public JSONCloneGroupsResult cloneGroupsAndUsers(String currentSpaceKey, String cloneFromSpaceKey, String groupsToCloneCsv, boolean cloneUsers) {
        int successfulGroupClones = 0;
        int successfulUserClones = 0;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        Space cloneFromSpace = this.fSpaceManager.getSpace(cloneFromSpaceKey);
        Space cloneToSpace = this.fSpaceManager.getSpace(currentSpaceKey);
        HashMap<String, String> failedUserClones = new HashMap<String, String>();
        ExceptionBean exceptionBean = null;
        if (!this.fPermissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)cloneFromSpace) || !this.fPermissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)cloneToSpace)) {
            GroupActionNotPermittedException e = new GroupActionNotPermittedException("Current user: " + currentUser.getName() + " does not have permission to Administer space(s):" + currentSpaceKey + ", " + cloneFromSpaceKey);
            exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            return new JSONCloneGroupsResult(successfulGroupClones, null, successfulUserClones, failedUserClones, exceptionBean);
        }
        Map<String, String> failedGroupClones = null;
        try {
            SpaceGroupUtil.OperationResult<Group> validateGroupsResult = this.fSpaceGroupUtil.validateSpaceGroups(cloneFromSpace, groupsToCloneCsv.split(COMMA));
            List validGroups = validateGroupsResult.successes;
            failedGroupClones = validateGroupsResult.failures;
            if (validGroups.isEmpty()) {
                NotPermittedException e = new NotPermittedException("User: " + currentUser.getName() + " is not authorized to manage space(s): " + currentSpaceKey + ", " + cloneFromSpaceKey);
                exceptionBean = new ExceptionBean((Throwable)e, this.fPluginAccessor);
                return new JSONCloneGroupsResult(successfulGroupClones, failedGroupClones, successfulUserClones, failedUserClones, exceptionBean);
            }
            for (Group validGroup : validGroups) {
                try {
                    Group cloned = this.fSpaceGroupUtil.cloneGroupToNewSpace(cloneFromSpace, cloneToSpace, validGroup.getName());
                    if (cloned == null) continue;
                    ++successfulGroupClones;
                    if (!cloneUsers) continue;
                    List userNames = this.fUserAccessor.getMemberNamesAsList(validGroup);
                    SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult = this.fSpaceGroupUtil.validateCSVUsers(cloneFromSpace, String.join((CharSequence)",", userNames), new String[0]);
                    List validUsers = userValidationResult.successes;
                    Map<String, String> failures = userValidationResult.failures;
                    failedUserClones.putAll(failures);
                    for (User validUser : validUsers) {
                        try {
                            this.fGroupManager.addMembership(cloned, validUser);
                            ++successfulUserClones;
                        }
                        catch (EntityException e) {
                            LOG.error("EntityException cloning user: " + validUser.getName(), (Throwable)e);
                            failedUserClones.put(validUser.getName(), INVALID_REASON);
                        }
                    }
                }
                catch (DuplicateException e) {
                    failedGroupClones.put(validGroup.getName(), INVALID_REASON);
                    if (!cloneUsers) continue;
                    Pager nonAttemptedUsers = this.fGroupManager.getMemberNames(validGroup);
                    for (String nonAttemptedUser : nonAttemptedUsers) {
                        failedUserClones.put(nonAttemptedUser, INVALID_REASON);
                    }
                }
                catch (GroupActionNotPermittedException | SpaceGroupPatternMismatchException e) {
                    exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                }
            }
        }
        catch (EntityException e) {
            exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
        }
        catch (AuthorizationException e) {
            LOG.error("Current user: " + currentUser.getName() + " does not have permission to Administer space(s):" + currentSpaceKey + ", " + cloneFromSpaceKey);
            exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
        }
        return new JSONCloneGroupsResult(successfulGroupClones, failedGroupClones, successfulUserClones, failedUserClones, exceptionBean);
    }
}

