/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.ITDlgGrpManager;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.AuthGroupBean;
import com.pluginpeople.confluence.csum.api.beans.AuthUserBean;
import com.pluginpeople.confluence.csum.api.beans.DlgGroupBean;
import com.pluginpeople.confluence.csum.rest.beans.AuthCreateResult;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITDlgGrpManagerImpl
implements ITDlgGrpManager {
    private static final Logger LOG = LoggerFactory.getLogger(ITDlgGrpManagerImpl.class);
    private final TransactionTemplate fTxTemplate;
    private final DlgGroupManager fDgm;
    private final GroupManager fGm;
    private final UserAccessor fUserAccessor;

    @Autowired
    public ITDlgGrpManagerImpl(@ComponentImport TransactionTemplate txTemplate, DlgGroupManager dlgGroupManager, @ComponentImport GroupManager groupManager, @ComponentImport UserAccessor userAccessor) {
        this.fTxTemplate = txTemplate;
        this.fDgm = dlgGroupManager;
        this.fGm = groupManager;
        this.fUserAccessor = userAccessor;
    }

    public DlgGroupBean[] getDlgGroups() {
        DlgGroupBean[] groups;
        ArrayList<DlgGroupBean> dlgGroupBeans = new ArrayList<DlgGroupBean>();
        for (DlgGroupBean group : groups = this.fDgm.getDlgGroups()) {
            DlgGroupBean groupBean = new DlgGroupBean();
            groupBean.setDlgGroupEntityId(group.getDlgGroupEntityId());
            groupBean.setGroupName(group.getGroupName());
            dlgGroupBeans.add(groupBean);
        }
        return dlgGroupBeans.toArray(new DlgGroupBean[0]);
    }

    public DlgGroupBean createDlgGroup(String groupName) {
        DlgGroupBean createdDlgGroupBean = null;
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            createdDlgGroupBean = (DlgGroupBean)this.fTxTemplate.execute(() -> {
                DlgGroupBean createdGroup = null;
                Group group = null;
                try {
                    group = this.fGm.getGroup(groupName);
                }
                catch (EntityException e) {
                    LOG.error("Could not get group: " + groupName, (Throwable)e);
                }
                if (group != null) {
                    try {
                        createdGroup = this.fDgm.createDlgGroup(groupName);
                    }
                    catch (AuthorizationException | GroupActionNotPermittedException e) {
                        LOG.error("Failed to create " + groupName, e);
                    }
                }
                return createdGroup;
            });
        }
        return createdDlgGroupBean;
    }

    public boolean isDlgGroup(String groupName) {
        boolean isDlg = false;
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            try {
                isDlg = this.fDgm.isDlgGroup(groupName);
            }
            catch (EntityException entityException) {
                LOG.error("EntityException when attempting to determine whether [" + groupName + "] is a delegated group.", (Throwable)entityException);
            }
            catch (DuplicateException duplicateException) {
                LOG.error("DuplicateException when attempting to determine whether [" + groupName + "] is a delegated group.", (Throwable)duplicateException);
            }
        }
        return isDlg;
    }

    public boolean deleteDlgGroup(int groupId) {
        boolean success = false;
        try {
            DlgGroupBean dlgGroup = this.fDgm.getDlgGroup(groupId);
            if (dlgGroup != null) {
                success = this.fDgm.deleteDlgGroup(dlgGroup, "via-event-listener");
            }
        }
        catch (EntityException e) {
            LOG.error("Failed to get group with ID: " + groupId, (Throwable)e);
        }
        return success;
    }

    public boolean authorizeUsersAndGroups(String[] dlgGroups, String users, String groups) throws DuplicateException, EntityException {
        Either either = (Either)this.fTxTemplate.execute(() -> {
            boolean success = false;
            for (String groupName : dlgGroups) {
                try {
                    AuthCreateResult result;
                    DlgGroupBean group = this.fDgm.getDlgGroupBean(groupName);
                    if (group == null) continue;
                    int groupId = group.getDlgGroupEntityId();
                    if (this.fGm.getGroup(groupName) == null || this.fDgm.getDlgGroup(groupId) == null || (result = this.fDgm.authorizeUsersAndGroups(groupId, groups, users, null)).getUserAuthSuccesses() <= 0 && result.getGroupAuthSuccesses() <= 0) continue;
                    success = true;
                }
                catch (EntityException | DuplicateException e) {
                    return Either.left((Object)e);
                }
            }
            return Either.right((Object)success);
        });
        if (either.isLeft()) {
            Exception exception = (Exception)either.left().get();
            if (exception instanceof DuplicateException) {
                throw (DuplicateException)((Object)exception);
            }
            if (exception instanceof EntityException) {
                throw (EntityException)((Object)exception);
            }
        }
        return (Boolean)either.right().get();
    }

    public boolean deauthorizeUsersAndGroups(String dlgGroupName, String groups, String users) {
        boolean success = false;
        try {
            DlgGroupBean group;
            if (StringUtils.isNotEmpty((CharSequence)dlgGroupName) && (group = this.fDgm.getDlgGroupBean(dlgGroupName)) != null) {
                int groupId = group.getDlgGroupEntityId();
                this.fDgm.deauthUsersAndGroups(groupId, users, groups, "");
                success = true;
            }
        }
        catch (EntityException entityException) {
            LOG.error("EntityException when attempting to unauthorize users and delegated groups from " + dlgGroupName, (Throwable)entityException);
        }
        catch (DuplicateException duplicateException) {
            LOG.error("DuplicateException when attempting to unauthorize users and delegated groups from " + dlgGroupName, (Throwable)duplicateException);
        }
        return success;
    }

    public boolean canManageGroup(String user, String dlgGroup) {
        return (Boolean)this.fTxTemplate.execute(() -> {
            boolean success = false;
            try {
                DlgGroupBean dlgGroupBean = this.fDgm.getDlgGroupBean(dlgGroup);
                if (dlgGroupBean != null) {
                    List authGroups;
                    ConfluenceUser confUser;
                    List authUsers = dlgGroupBean.getAuthUsers();
                    if (authUsers != null) {
                        for (AuthUserBean authUser : authUsers) {
                            if (!authUser.getUserName().equalsIgnoreCase(user)) continue;
                            success = true;
                            break;
                        }
                    }
                    if (!success && (confUser = this.fUserAccessor.getUserByName(user)) != null && (authGroups = dlgGroupBean.getAuthGroups()) != null) {
                        AuthGroupBean authGroup;
                        Group confGroup;
                        Iterator iterator = authGroups.iterator();
                        while (iterator.hasNext() && !(success = this.fGm.hasMembership(confGroup = this.fGm.getGroup((authGroup = (AuthGroupBean)iterator.next()).getGroupName()), (User)confUser))) {
                        }
                    }
                }
            }
            catch (EntityException | DuplicateException e) {
                LOG.error("cannot get item", e);
            }
            return success;
        });
    }

    public DlgGroupBean getDlgGroup(String dlgGroup) {
        DlgGroupBean dlgGroupBean = null;
        if (StringUtils.isNotEmpty((CharSequence)dlgGroup)) {
            try {
                dlgGroupBean = this.fDgm.getDlgGroupBean(dlgGroup);
            }
            catch (EntityException | DuplicateException e) {
                LOG.error("Could not find " + dlgGroup, e);
            }
        }
        return dlgGroupBean;
    }

    public void delAllAuthGroupsAndUsersFromDb() {
        this.fDgm.delAllDbAuthUsersAndGroups();
    }

    public void addUserToDlgGroup(Space space, String dlgGroupName, String userName) throws EntityException, AuthorizationException {
        Option result = (Option)this.fTxTemplate.execute(() -> {
            try {
                this.fDgm.addUsersToGroups(space, dlgGroupName, userName, "");
            }
            catch (EntityException | AuthorizationException e) {
                return Option.some((Object)e);
            }
            return Option.none();
        });
        if (result.isDefined()) {
            if (result.get() instanceof EntityException) {
                throw (EntityException)((Object)result.get());
            }
            if (result.get() instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)result.get());
            }
        }
    }

    public void removeUserFromDlgGroup(String remoteUser, String dlgGroupName, String userName, Space space) throws EntityException, RemoveAllUsersException, AuthorizationException {
        Option result = (Option)this.fTxTemplate.execute(() -> {
            try {
                this.fDgm.removeUsersSpaceDlgGroups(dlgGroupName, userName, null, space);
            }
            catch (EntityException | AuthorizationException | RemoveAllUsersException e) {
                return Option.some((Object)e);
            }
            return Option.none();
        });
        if (result.isDefined()) {
            if (result.get() instanceof EntityException) {
                throw (EntityException)((Object)result.get());
            }
            if (result.get() instanceof RemoveAllUsersException) {
                throw (RemoveAllUsersException)((Object)result.get());
            }
            if (result.get() instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)result.get());
            }
        }
    }

    public void rebuildAuthUserCache() {
        this.fDgm.rebuildAuthUserCache();
    }

    public String[][] getAuthUsersInDatatableFormat(DlgGroupBean dlgGroup) {
        String[][] data = null;
        try {
            DataTableUserList dataTableFormat = this.fDgm.getAuthUsersInDatatableFormat(dlgGroup);
            data = dataTableFormat.getData();
        }
        catch (EntityException e) {
            LOG.error("could not get datatable format for " + dlgGroup, (Throwable)e);
        }
        return data;
    }
}

