/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.loader;

import com.atlassian.cache.CacheLoader;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.ao.CSUMDelegatedGroupEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedDlgGroup;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedUserAuthDlgGroups;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedUserAuthDlgGroups;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMAuthUserCacheLoader
implements CacheLoader<String, ICSUMCachedUserAuthDlgGroups> {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMAuthUserCacheLoader.class);
    private static ICSUMActiveObjectService fCao;
    private static UserAccessor fUserAccessor;

    public CSUMAuthUserCacheLoader(ICSUMActiveObjectService activeObjectService, UserAccessor userAccessor) {
        fCao = activeObjectService;
        fUserAccessor = userAccessor;
    }

    @Nonnull
    public ICSUMCachedUserAuthDlgGroups load(@Nonnull String userKey) {
        CSUMCachedUserAuthDlgGroups ret = new CSUMCachedUserAuthDlgGroups(new CSUMCachedDlgGroup[0]);
        try {
            UserKey userKeyObj = new UserKey(userKey);
            ConfluenceUser user = fUserAccessor.getUserByKey(userKeyObj);
            if (user != null) {
                CSUMDelegatedGroupEntity[] groups = fCao.getDelegatedGroupsForUser(user);
                CSUMCachedDlgGroup[] dlgGroupEntries = new CSUMCachedDlgGroup[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    CSUMCachedDlgGroup entry;
                    CSUMDelegatedGroupEntity group = groups[i];
                    if (group == null) continue;
                    dlgGroupEntries[i] = entry = new CSUMCachedDlgGroup(group);
                }
                ret = new CSUMCachedUserAuthDlgGroups(dlgGroupEntries);
            }
        }
        catch (EntityException e) {
            LOG.error("Exception occurred during cache population", (Throwable)e);
        }
        return ret;
    }
}

