/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ldap;

import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.ldap.ICSUMUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPUser
implements ICSUMUser {
    private static final Logger LOG = LoggerFactory.getLogger(LDAPUser.class);
    private String fUserId;
    private String fFullName;
    private String fEmail;
    private String fFirstName;
    private String fLastName;
    private String[] fProxyAddresses;
    private ICSUMUser.JemhUserNameFormat fFullNameFormat = ICSUMUser.JemhUserNameFormat.LAST_NAME_COMMA_FIRST_NAME;
    private String fDisplayName;
    private User fUser;
    private boolean fIsEnabled;
    private String[] fObjectClasses;

    public LDAPUser() {
    }

    public LDAPUser(User u) {
        this.fUser = u;
        this.setEmail(u.getEmail());
        this.setDisplayName(u.getFullName());
        this.setUserId(u.getName());
    }

    public LDAPUser(String userid, String fullName, String email) {
        this.fUserId = userid;
        this.fFullName = fullName;
        this.fEmail = email;
    }

    public LDAPUser(String userid, String fullName, String email, String[] mailAliases) {
        this.fUserId = userid;
        this.fFullName = fullName;
        this.fEmail = email;
        this.fProxyAddresses = mailAliases;
    }

    @Override
    public String getUserId() {
        return this.fUserId;
    }

    @Override
    public void setUserId(String userId) {
        this.fUserId = userId;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public String getFullName() {
        Object name = null;
        if (this.fFullNameFormat.equals((Object)ICSUMUser.JemhUserNameFormat.LAST_NAME_COMMA_FIRST_NAME) || this.fFullNameFormat.equals((Object)ICSUMUser.JemhUserNameFormat.FIRST_NAME_SPACE_LAST_NAME)) {
            if (!this.isEmpty(this.fFirstName) && !this.isEmpty(this.fLastName)) {
                name = this.fFullNameFormat.equals((Object)ICSUMUser.JemhUserNameFormat.LAST_NAME_COMMA_FIRST_NAME) ? this.fLastName + ", " + this.fFirstName : this.fFirstName + " " + this.fLastName;
            } else if (!this.isEmpty(this.fFirstName) && this.isEmpty(this.fLastName)) {
                name = this.fFirstName;
            } else if (this.isEmpty(this.fFirstName) && !this.isEmpty(this.fLastName)) {
                name = this.fLastName;
            }
        } else {
            name = this.fUserId;
        }
        return name;
    }

    @Override
    public String getEmail() {
        return this.fEmail;
    }

    @Override
    public void setEmail(String email) {
        this.fEmail = email;
    }

    @Override
    public String getFirstName() {
        return this.fFirstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.fFirstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.fLastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.fLastName = lastName;
    }

    @Override
    public ICSUMUser.JemhUserNameFormat getFullNameFormat() {
        return this.fFullNameFormat;
    }

    @Override
    public void setFullNameFormat(ICSUMUser.JemhUserNameFormat fullNameFormat) {
        this.fFullNameFormat = fullNameFormat;
    }

    @Override
    public String[] getProxyAddresses() {
        return this.fProxyAddresses;
    }

    @Override
    public void setProxyAddresses(String[] proxyAliases) {
        this.fProxyAddresses = proxyAliases;
    }

    @Override
    public String getDisplayName() {
        return this.fDisplayName;
    }

    @Override
    public void setDisplayName(String value) {
        this.fDisplayName = value;
    }

    @Override
    public boolean isUserEnabled() {
        return this.fIsEnabled;
    }

    @Override
    public void setUserEnabled(boolean isEnabled) {
        this.fIsEnabled = isEnabled;
    }

    @Override
    public User getUser() {
        return this.fUser;
    }

    @Override
    public String[] getObjectClasses() {
        return this.fObjectClasses;
    }

    @Override
    public void setObjectClasses(String[] split) {
        this.fObjectClasses = split;
    }
}

