/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.ITLDAPManager;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.beans.LDAPQueryResultList;
import com.pluginpeople.confluence.csum.ldap.DTObuilder;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPHydrationManager;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LdapValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITLDAPManagerImpl
implements ITLDAPManager {
    private static final Logger LOG = LoggerFactory.getLogger(ITLDAPManagerImpl.class);
    private final ICSUMActiveObjectService fAo;
    private final OutboundWhitelist fOutboundAllowlist;

    @Autowired
    public ITLDAPManagerImpl(ICSUMActiveObjectService ao, @ComponentImport OutboundWhitelist outboundAllowlist) {
        this.fAo = ao;
        this.fOutboundAllowlist = outboundAllowlist;
    }

    public LdapDetailsDTO installConfig(InputStream is) throws RemoteException {
        LdapDetailsDTO bean = null;
        try {
            LDAPHydrationManager hydrationMgr = new LDAPHydrationManager(this.fAo);
            CSUMLdapConfigEntity configEntity = hydrationMgr.restoreLDAPFromXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            bean = hydrationMgr.getSerializableLdapConfig(configEntity);
            bean.setID(configEntity.getID());
        }
        catch (IOException | JAXBException e) {
            LOG.error("Exception during LDAP config install", e);
        }
        return bean;
    }

    public void deleteConfig(int id) {
        CSUMLdapConfigEntity ldapConfig = this.fAo.getLdapConfigById(id);
        if (ldapConfig != null) {
            this.fAo.delete(ldapConfig);
        }
    }

    public void deleteAllLdapConfigs() {
        CSUMLdapConfigEntity[] allLdapConfigs;
        for (CSUMLdapConfigEntity allLdapConfig : allLdapConfigs = this.fAo.getLdapConfigs()) {
            this.fAo.delete(allLdapConfig);
        }
    }

    public Map<String, String> validateLdapConfigurationValid(LdapDetailsDTO dto, String additionalParams) {
        boolean isValid;
        HashMap<String, String> errors;
        block9: {
            LOG.info("isLdapConfigurationValid: " + dto + " for [" + dto.getLdapConfigName() + "] : " + dto.getLdapHostname() + ":" + dto.getLdapPort());
            errors = new HashMap<String, String>();
            isValid = false;
            HashMap<String, String> additionalPropertiesMap = null;
            Properties p = new Properties();
            if (additionalParams != null) {
                try {
                    p.load(new StringReader(additionalParams));
                    LOG.info("Loaded " + p.size() + " values from additional params");
                }
                catch (IOException e1) {
                    errors.put("ldap", "Unable to load additional params: " + e1.getLocalizedMessage());
                }
                additionalPropertiesMap = new HashMap<String, String>();
                for (Object o : p.keySet()) {
                    String aValue;
                    String aKey = (String)o;
                    if (aKey == null || (aValue = p.getProperty(aKey)) == null) continue;
                    additionalPropertiesMap.put(aKey, aValue);
                }
            }
            dto.setLdapAdditionalParams(additionalPropertiesMap);
            try {
                if (dto.getLdapHostname() == null) {
                    errors.put("ldapHostname", "The hostname was empty");
                }
                if (dto.getLdapPort() == 0) {
                    errors.put("ldapPort", "The port was empty");
                }
                if (dto.getLdapPassword() != null && dto.getLdapPassword() == null) {
                    errors.put("ldapPassword", "Password is empty");
                }
                this.timeOutConnectAndSearch(errors, dto.getLdapConnectionTimeout(), "ldapConnectionTimeout", "Connect timeout is not in the range: 0 > val < 300000 (5mins)");
                this.timeOutConnectAndSearch(errors, dto.getLdapSearchTimeout(), "ldapSearchTimeout", "search timeout is not in the range: 0 > val < 300000 (5mins)");
                LdapValidator lv = new LdapValidator(dto, this.fOutboundAllowlist);
                isValid = lv.validateLdapServer();
                LOG.info("Validation success: " + isValid);
            }
            catch (Exception ldape) {
                errors.put("Exception", ldape.getLocalizedMessage());
                if (ldape.getCause() == null) break block9;
                errors.put("exceptionCause", ldape.getCause().getLocalizedMessage());
            }
        }
        LOG.info("LDAP Configuration validation result: " + isValid);
        return errors;
    }

    private void timeOutConnectAndSearch(Map<String, String> errors, int ldapSearchTimeout, String ldapSearchTimeout2, String s) {
        try {
            if (ldapSearchTimeout <= 0 || ldapSearchTimeout > 300000) {
                errors.put(ldapSearchTimeout2, s);
            }
        }
        catch (NumberFormatException nfe) {
            errors.put(ldapSearchTimeout2, nfe.getLocalizedMessage());
        }
    }

    public void updateConfig(LdapDetailsDTO b) {
        CSUMLdapConfigEntity e = this.fAo.getLdapConfigById(b.getID());
        LDAPHydrationManager mgr = new LDAPHydrationManager(this.fAo);
        e.setAdditionalGroupDN(b.getLdapAdditionalGroupDN());
        if (b.getLdapAdditionalParams() != null) {
            e.setAdditionalParams(mgr.getStringFromPropsMap(b.getLdapAdditionalParams()));
        }
        e.setAdditionalUserDN(b.getLdapAdditionalUserDN());
        e.setBaseDN(b.getLdapBaseDN());
        e.setConnectionTimeout(b.getLdapConnectionTimeout());
        e.setGroupMembershipAttr(b.getLdapUserGroupMembershipAttr());
        e.setHostname(b.getLdapHostname());
        e.setLdapConfigName(b.getLdapConfigName());
        e.setObjectClass(b.getLdapObjectClass());
        e.setObjectFilter(b.getLdapObjectFilter());
        e.setPassword(b.getLdapPassword());
        e.setPort(b.getLdapPort());
        e.setResultsPerPage(b.getLdapResultsPerPage());
        e.setSearchTimeout(b.getLdapSearchTimeout());
        e.setSortOrder(b.getSortOrder());
        e.setTestLookupUsername(b.getLdapTestLookupUsername());
        e.setUsePagedResults(b.isLdapUsePagedResults());
        e.setUserDisplayNameAttr(b.getLdapUserDisplayNameAttr());
        e.setUserEmailAttr(b.getLdapUserEmailAttr());
        e.setUserFirstNameAttr(b.getLdapUserFirstNameAttr());
        e.setUserLastNameAttr(b.getLdapUserLastNameAttr());
        e.setUsername(b.getLdapUsername());
        e.setUsernameAttr(b.getLdapUserAttr());
        e.setUserPasswordAttr(b.getLdapUserPasswordAttr());
        e.setUserRDNAttr(b.getLdapUserRDNAttr());
        e.setUseSSL(b.isLdapUseSSL());
        this.fAo.saveLdapConfigById(e);
    }

    public Map<String, Map<String, List<Object>>> query(int ldapConfigId, String ldapFilter, String[] requiredReturnAtts) throws RemoteException {
        Map<String, Map<String, List<Object>>> mapOfResults;
        CSUMLdapConfigEntity e = this.fAo.getLdapConfigById(ldapConfigId);
        LdapDetailsDTO dto = new LdapDetailsDTO();
        DTObuilder.updateDto(e, dto);
        LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
        try {
            lookupUtil.resetConnection();
            mapOfResults = lookupUtil.searchFor(ldapFilter, requiredReturnAtts);
        }
        catch (LDAPException e1) {
            throw new RemoteException(e1.getLocalizedMessage());
        }
        return mapOfResults;
    }

    public LDAPQueryResultList queryGroupMembership(int ldapConfigId, String ldapFilter, String[] requiredReturnAtts, String[] expandAttributes, long maxResults) throws RemoteException {
        LDAPQueryResultList resultList;
        CSUMLdapConfigEntity e = this.fAo.getLdapConfigById(ldapConfigId);
        LdapDetailsDTO dto = new LdapDetailsDTO();
        DTObuilder.updateDto(e, dto);
        LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
        try {
            lookupUtil.resetConnection();
            resultList = lookupUtil.runGroupExpansionQuery(ldapFilter, requiredReturnAtts, expandAttributes, maxResults);
        }
        catch (Exception e1) {
            throw new RemoteException(e1.getLocalizedMessage());
        }
        return resultList;
    }
}

