/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ldap;

import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.ldap.ICSUMUser;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LDAPUser;
import com.pluginpeople.confluence.csum.ldap.LdapItemBean;
import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapValidator {
    private static final Logger LOG = LoggerFactory.getLogger(LdapValidator.class);
    private final LdapDetailsDTO fDto;
    private LDAPLookupUtil fLookup;
    private OutboundWhitelist fWhitelist;

    public LdapValidator(LdapDetailsDTO dto, OutboundWhitelist outboundWhitelist) {
        this.fDto = dto;
        this.fWhitelist = outboundWhitelist;
    }

    public LdapValidator(LdapItemBean bean, OutboundWhitelist outboundWhitelist) {
        this.fDto = new LdapDetailsDTO();
        this.fDto.setSortOrder(bean.getSortOrder());
        this.fDto.setLdapConfigName(bean.getLdapConfigName());
        this.fDto.setLdapHostname(bean.getHostname());
        this.fDto.setLdapPort(bean.getPort());
        this.fDto.setLdapUseSSL(bean.isUseSSL());
        this.fDto.setLdapUsername(bean.getUsername());
        this.fDto.setLdapPassword(bean.getPassword());
        this.fDto.setLdapBaseDN(bean.getBaseDN());
        this.fDto.setLdapAdditionalUserDN(bean.getAdditionalUserDN());
        this.fDto.setLdapAdditionalGroupDN(bean.getAdditionalGroupDN());
        this.fDto.setLdapObjectClass(bean.getObjectClass());
        this.fDto.setLdapObjectFilter(bean.getObjectFilter());
        this.fDto.setLdapUserAttr(bean.getUsernameAttr());
        this.fDto.setLdapUserRDNAttr(bean.getUserRDNAttr());
        this.fDto.setLdapUserFirstNameAttr(bean.getUserFirstNameAttr());
        this.fDto.setLdapUserLastNameAttr(bean.getUserLastNameAttr());
        this.fDto.setLdapUserDisplayNameAttr(bean.getUserDisplayNameAttr());
        this.fDto.setLdapUserEmailAttr(bean.getUserEmailAttr());
        this.fDto.setLdapUserPasswordAttr(bean.getUserPasswordAttr());
        this.fDto.setEquivalentMailDomains(bean.getEquivalentMailDomains());
        this.fDto.setLdapUsePagedResults(bean.getUsePagedResults());
        this.fDto.setLdapResultsPerPage(bean.getResultsPerPage());
        this.fDto.setLdapSearchTimeout(bean.getSearchTimeout());
        this.fDto.setLdapConnectionTimeout(bean.getConnectionTimeout());
        this.fDto.setLdapTestLookupUsername(bean.getTestLookupUsername());
        this.fWhitelist = outboundWhitelist;
    }

    public boolean validateLdapServer() throws LDAPException, CommunicationException {
        this.assertHostnameAllowed();
        this.fLookup = new LDAPLookupUtil(this.fDto);
        LDAPUser anLdapUser = null;
        if (this.fDto.getLdapTestLookupUsername() != null) {
            anLdapUser = this.fLookup.getUserDetails(this.fDto.getLdapTestLookupUsername());
            if (anLdapUser == null) {
                throw new LDAPException("Test ldap user (" + this.fDto.getLdapTestLookupUsername() + ") not found.");
            }
            String userStr = "userId='" + anLdapUser.getUserId() + "', firstName='" + anLdapUser.getFirstName() + "', fullName='" + anLdapUser.getFullName() + "', mail='" + anLdapUser.getEmail() + "'";
            LOG.info("Found user: " + userStr);
        }
        return anLdapUser != null;
    }

    private void assertHostnameAllowed() throws LDAPException {
        if (this.fDto != null && this.fDto.getLdapHostname() != null) {
            String rawLdapUrl = LDAPLookupUtil.getConnectionUrl(this.fDto);
            try {
                URI ldapUri = new URI(rawLdapUrl);
                if (!this.fWhitelist.isAllowed(ldapUri)) {
                    throw new LDAPException("LDAP host url [" + rawLdapUrl + "] is not allowed by Confluence allowlist");
                }
            }
            catch (URISyntaxException e) {
                throw new LDAPException("LDAP host url [" + rawLdapUrl + "] is valid", e);
            }
        }
    }

    public ICSUMUser getLdapUserByName(String username) throws LDAPException {
        return this.fLookup.getUserDetails(username);
    }

    public ICSUMUser getLdapUserByEmail(String address) throws LDAPException {
        return this.fLookup.getUserDetailsByEmailAddress(address);
    }
}

