/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.loader;

import com.atlassian.cache.CacheLoader;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TwoTermBooleanQuery;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedSpaceGroups;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedSpaceGroups;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMSpaceGroupCacheLoader
implements CacheLoader<String, ICSUMCachedSpaceGroups> {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMSpaceGroupCacheLoader.class);
    private static final String VIEW_SPACE = "VIEWSPACE";
    private static final String SYS_VAR_GROUP_MAX = "csum.cache.group.max";
    private static ICSUMActiveObjectService fCao;
    private static ICSUMCacheManager fCacheManager;
    private static UserAccessor fUserAccessor;
    private static SpacePermissionManager fPermissionManager;
    private static SpaceManager fSpaceManager;
    private static int fMaxGroupsPerCacheEntry;

    public CSUMSpaceGroupCacheLoader(ICSUMActiveObjectService activeObjectService, ICSUMCacheManager cacheManager, int maxGroupsPerCacheEntry, UserAccessor userAccessor, SpaceManager spaceManager, SpacePermissionManager permissionManager) {
        fCao = activeObjectService;
        fCacheManager = cacheManager;
        fUserAccessor = userAccessor;
        fMaxGroupsPerCacheEntry = maxGroupsPerCacheEntry;
        fSpaceManager = spaceManager;
        fPermissionManager = permissionManager;
    }

    public ICSUMCachedSpaceGroups load(@Nonnull String spaceKey) {
        LOG.debug("spaceGroupCacheLoader, loading [" + spaceKey + "] groups");
        long tStart = System.currentTimeMillis();
        ICSUMCachedSpaceGroups cachedSpaceGroupBean = this.getSpaceGroupsFor(spaceKey);
        if (cachedSpaceGroupBean != null) {
            int len = cachedSpaceGroupBean.getSpaceGroups().length;
            long tDiff = System.currentTimeMillis() - tStart;
            LOG.debug("spaceGroupCacheLoader, loaded [" + len + "] groups for space [" + spaceKey + "] in " + tDiff + "ms");
        }
        return cachedSpaceGroupBean;
    }

    private ICSUMCachedSpaceGroups getSpaceGroupsFor(String spaceKey) {
        CSUMCachedSpaceGroups result = null;
        ICSUMCachedConfig cachedConfig = fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            String prefixUC = cachedConfig.getGroupPrefixPattern();
            String suffixUC = cachedConfig.getGroupSuffixPattern();
            String prefix = prefixUC != null ? prefixUC.replace("SPACEKEY", spaceKey).toLowerCase() : null;
            String suffix = suffixUC != null ? suffixUC.replace("SPACEKEY", spaceKey).toLowerCase() : null;
            LOG.debug("Looking for groups: [prefix=" + prefix + ", suffix=" + suffix + ", spaceKey=" + spaceKey + "]");
            Pair<List<Group>, Boolean> matches = new Pair<List<Group>, Boolean>(Collections.emptyList(), (Object)false);
            try {
                matches = this.performSpaceGroupSearch(prefix, suffix, fMaxGroupsPerCacheEntry, spaceKey);
                if (Boolean.TRUE.equals(matches.right())) {
                    LOG.warn("Reached groups per space cache limit (" + fMaxGroupsPerCacheEntry + "), consider using system property to increase: csum.cache.group.max");
                }
                LOG.debug("Found " + ((List)matches.left()).size() + " SpaceGroups for space " + spaceKey);
            }
            catch (EntityException e) {
                LOG.error("Exception during retrieval of space groups. Error: ", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Exception during retrieval of space groups as no CSUM Prefix or Suffix has been set in your CSUM configuration and current space key is null. Error: ", (Throwable)e);
            }
            result = new CSUMCachedSpaceGroups(spaceKey, (List)matches.left());
        }
        return result;
    }

    private Pair<List<Group>, Boolean> performSpaceGroupSearch(String prefix, String suffix, int max, String spaceKey) throws EntityException {
        boolean exitLoop;
        Query<Group> query = this.buildSpaceGroupQuery(prefix, suffix, spaceKey);
        SearchResult searchResult = fUserAccessor.findGroups(query);
        ArrayList<Group> matches = new ArrayList<Group>();
        boolean maxReached = false;
        Pager visibleGroups = searchResult.pager();
        do {
            List currentPage = visibleGroups.getCurrentPage();
            for (Group group : currentPage) {
                if (matches.size() < max) {
                    ICSUMCachedConfig cachedConfig = fCacheManager.getCachedConfig();
                    if (cachedConfig != null && cachedConfig.isIgnorePermissionCheck()) {
                        if (suffix != null && !group.getName().toLowerCase().endsWith(suffix.toLowerCase())) continue;
                        matches.add(group);
                        continue;
                    }
                    this.checkGroupViewPermission(suffix, spaceKey, matches, group);
                    continue;
                }
                maxReached = true;
                break;
            }
            boolean bl = exitLoop = visibleGroups.onLastPage() || matches.size() == max;
            if (exitLoop) continue;
            visibleGroups.nextPage();
        } while (!exitLoop);
        return new Pair(matches, (Object)maxReached);
    }

    private Query<Group> buildSpaceGroupQuery(String prefix, String suffix, String spaceKey) {
        GroupNameTermQuery retQuery;
        if (prefix != null && suffix != null) {
            GroupNameTermQuery prefixQuery = new GroupNameTermQuery(prefix, "starts_with");
            GroupNameTermQuery suffixQuery = new GroupNameTermQuery(suffix, "ends_with");
            retQuery = new TwoTermBooleanQuery((Query)prefixQuery, (Query)suffixQuery);
        } else if (prefix != null) {
            retQuery = new GroupNameTermQuery(prefix, "starts_with");
        } else if (suffix != null) {
            retQuery = new GroupNameTermQuery(suffix, "ends_with");
        } else if (spaceKey != null) {
            retQuery = new GroupNameTermQuery(spaceKey + "-", "starts_with");
            LOG.debug("No prefix or suffix set in CSUM config... finding existing groups with prefix as current spaceKey. Current spaceKey:  " + spaceKey);
        } else {
            throw new IllegalArgumentException("At least one of either current spaceKey, prefix or suffix should not be null");
        }
        return retQuery;
    }

    private void checkGroupViewPermission(String suffix, String spaceKey, List<Group> matches, Group group) {
        if ((suffix == null || group.getName().toLowerCase().endsWith(suffix.toLowerCase())) && fPermissionManager.groupHasPermission(VIEW_SPACE, fSpaceManager.getSpace(spaceKey), group.getName())) {
            matches.add(group);
        }
    }
}

