/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.legacy;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.legacy.ConfigUtil;
import com.pluginpeople.confluence.csum.legacy.LegacyCSUMConfigValidationResponse;
import com.pluginpeople.confluence.csum.legacy.LogUtil;
import com.pluginpeople.confluence.csum.service.CustomPermissionConfigurable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomPermissionConfiguration
implements CustomPermissionConfigurable {
    private static final Log LOG = LogFactory.getLog(CustomPermissionConfiguration.class);
    private static final String JIRA_REST_URL = "jiraRestUrl";
    private static final String GROUP_ACTIONS_PERMITTED = "groupActionsPermitted";
    private static final String GROUP_ADD_REMOVE_PERMITTED = "groupAddRemovePermitted";
    private static final String GROUP_REMOVE_USER_FROM_GLOBAL_PERM_GROUP_PERMITTED = "removeUserFromPermGrpPerm";
    private static final String DLG_GROUP_ACTIONS_PERMITTED = "dlgGrpActPerm";
    private static final String NEW_NAME_CREATION_PREFIX_PATTERN_INVALID = "csum.configure.error.newgroupnamecreationprefixpatterninvalid";
    private static final String NEW_NAME_CREATION_SUFFIX_PATTERN_INVALID = "csum.configure.error.newgroupnamecreationsuffixpatterninvalid";
    private static final String GROUP_ACTIONS_PERMITTED_INVALID = "csum.configure.error.groupactionspermittedinvalid";
    private static final String yesString = "yesString";
    private final BandanaManager bandanaManager;

    @Autowired
    public CustomPermissionConfiguration(@ComponentImport BandanaManager bandanaManager) {
        LOG.debug((Object)"instantiating CustomPermissionConfiguration");
        this.bandanaManager = bandanaManager;
        if (bandanaManager == null) {
            LOG.warn((Object)"bandanaManager was not autowired in CustomPermissionConfiguration");
            throw new RuntimeException("bandanaManager was not autowired in CustomPermissionConfiguration");
        }
        LOG.debug((Object)"instantiated CustomPermissionConfiguration");
    }

    public static LegacyCSUMConfigValidationResponse validate(CustomPermissionConfigurable config, CustomPermissionConfigurable existingConfig, String remoteUser, ConfluenceActionSupport cas, boolean shouldTestExternalServices) {
        String dlgGrpActPerm;
        String removeUserFromPermGrpPerm;
        String groupAddRemovePermitted;
        String groupActionsPermitted;
        String pluginInDown;
        boolean userManagerLocationIsJira;
        LegacyCSUMConfigValidationResponse result = new LegacyCSUMConfigValidationResponse();
        result.setValid(true);
        String userMgrLocation = config.getUserManagerLocation();
        boolean isUserManagerLocationSet = userMgrLocation != null;
        boolean userManagerLocationIsConfluence = userMgrLocation != null && userMgrLocation.equals("CONFLUENCE");
        boolean bl = userManagerLocationIsJira = userMgrLocation != null && userMgrLocation.equals("JIRA");
        if (!userManagerLocationIsConfluence && !userManagerLocationIsJira) {
            result.addFieldError("userManagerLocation", cas.getText("csum.configure.error.usermanagerlocationnull"));
            result.setValid(false);
        }
        if (isUserManagerLocationSet && userManagerLocationIsJira) {
            if (ConfigUtil.isNullOrEmpty(config.getJiraRestUrl())) {
                result.addFieldError(JIRA_REST_URL, cas.getText("csum.configure.error.jiraresturlempty"));
                result.setValid(false);
            }
            if (ConfigUtil.isNullOrEmpty(config.getJiraRestUsername())) {
                result.addFieldError("jiraRestUsername", cas.getText("csum.configure.error.jirarestusernameempty"));
                result.setValid(false);
            }
            if (config.getJiraRestPassword() == null && (existingConfig == null || existingConfig.getJiraRestPassword() == null)) {
                result.addFieldError("jiraRestPassword", cas.getText("csum.configure.error.jirarestpasswordnull"));
                result.setValid(false);
            }
            if (shouldTestExternalServices && result.isValid()) {
                String pingRestServiceUrl = config.getJiraRestUrl() + "/rest/api/2/mypermissions";
                try {
                    BasicClassicHttpRequest getRequest = new BasicClassicHttpRequest(Method.GET, pingRestServiceUrl);
                    try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                        client.execute((ClassicHttpRequest)getRequest, response -> {
                            int respCode = response.getCode();
                            LOG.info((Object)("Response Code : " + respCode));
                            if (respCode != 200) {
                                LogUtil.errorWithRemoteUserInfo(LOG, "Problem testing JIRA REST configuration by connecting to JIRA.  Server must be available to configure.  Got error code: " + respCode);
                                result.addFieldError(JIRA_REST_URL, cas.getText("csum.configure.error.jiraresttestconnectfailed") + ", URL: " + pingRestServiceUrl + ", HTTP:" + respCode);
                                result.setValid(false);
                            }
                            return null;
                        });
                    }
                }
                catch (Exception e) {
                    LogUtil.errorWithRemoteUserInfo(LOG, "Problem testing JIRA REST configuration by connecting to JIRA, communication must succeed in order to save.  Got exception during call: ", e);
                    result.addFieldError(JIRA_REST_URL, cas.getText("csum.configure.error.jiraresttestconnectfailed") + ", URL: " + pingRestServiceUrl + ", Exception:" + e.getLocalizedMessage());
                    result.setValid(false);
                }
            }
        }
        if (config.getLdapAuthUsed() != null && yesString.equals(config.getLdapAuthUsed())) {
            boolean idFormat;
            String providerType = config.getProviderType();
            if (providerType == null || !providerType.equals("OSUSER") && !providerType.equals("ATLASSIAN-USER")) {
                result.addFieldError("providerType", cas.getText("csum.configure.error.providertypeinvalid"));
                result.setValid(false);
            } else if (providerType.equals("OSUSER")) {
                if (config.getLdapUserIdAttribute() == null) {
                    result.addFieldError("ldapUserIdAttribute", cas.getText("csum.configure.error.ldapuseridattributenull"));
                    result.setValid(false);
                }
                if (config.getLdapEmailAttribute() == null) {
                    result.addFieldError("ldapEmailAttribute", cas.getText("csum.configure.error.ldapemailattributenull"));
                    result.setValid(false);
                }
                if (config.getLdapFirstNameAttribute() == null) {
                    result.addFieldError("ldapFirstNameAttribute", cas.getText("csum.configure.error.ldapfirstnameattributenull"));
                    result.setValid(false);
                }
                if (config.getLdapLastNameAttribute() == null) {
                    result.addFieldError("ldapLastNameAttribute", cas.getText("csum.configure.error.ldaplastnameattributenull"));
                    result.setValid(false);
                }
                if (config.getLdapProviderFullyQualifiedClassname() == null) {
                    result.addFieldError("ldapProviderFullyQualifiedClassname", cas.getText("csum.configure.error.ldapproviderfullyqualifiedclassnamenull"));
                    result.setValid(false);
                }
            }
            String userFullNameFormat = config.getUserFullNameFormat();
            boolean lastCommaFirstFormat = userFullNameFormat != null && userFullNameFormat.equals("LASTNAME_COMMA_FIRSTNAME");
            boolean firstLastFormat = userFullNameFormat != null && userFullNameFormat.equals("FIRSTNAME_LASTNAME");
            boolean bl2 = idFormat = userFullNameFormat != null && userFullNameFormat.equals("ID");
            if (userFullNameFormat == null) {
                result.addFieldError("userFullNameFormat", cas.getText("csum.configure.error.userfullnameformatnull"));
                result.setValid(false);
            } else if (!(lastCommaFirstFormat || firstLastFormat || idFormat)) {
                result.addFieldError("userFullNameFormat", cas.getText("csum.configure.error.userfullnameformatinvalid") + ": " + userFullNameFormat);
                result.setValid(false);
            }
            String ldapConfigTestUsername = config.getLdapConfigTestUsername();
            if (ldapConfigTestUsername == null || ldapConfigTestUsername.trim().isEmpty()) {
                result.addFieldError("ldapConfigTestUsername", cas.getText("csum.configure.error.ldapconfigtestusernameempty"));
                result.setValid(false);
            }
        }
        if (!ConfigUtil.isNotNullAndIsYesOrNo(config.getUserSearchEnabled())) {
            result.addFieldError("userSearchEnabled", cas.getText("csum.configure.error.usersearchenabledinvalid"));
            result.setValid(false);
        }
        if (config.getMaxUserIDsLimit() == null || !ConfigUtil.isNotNullAndIsIntGreaterThanZero(config.getMaxUserIDsLimit())) {
            result.addFieldError("maxUserIDsLimit", cas.getText("csum.configure.error.maxuseridslimitinvalid"));
            result.setValid(false);
        }
        if (config.getMaxGroupIDsLimit() == null || !ConfigUtil.isNotNullAndIsIntGreaterThanZero(config.getMaxGroupIDsLimit())) {
            result.addFieldError("maxGroupIDsLimit", cas.getText("csum.configure.error.maxgroupidslimitinvalid"));
            result.setValid(false);
        }
        if (config.getNumRowsPerPage() == null || !ConfigUtil.isNotNullAndIsIntBetween(config.getNumRowsPerPage(), 5, 10000)) {
            result.addFieldError("numRowsPerPage", cas.getText("csum.configure.error.numrowsperpageinvalid"));
            result.setValid(false);
        }
        if (ConfigUtil.isNotNullAndIsYesOrNo(pluginInDown = config.getPluginDown())) {
            if (yesString.equals(pluginInDown) && config.getDownTimeMessage() == null) {
                result.addFieldError("pluginInDown", cas.getText("csum.configure.error.downtimemessagenull"));
                result.setValid(false);
            }
        } else {
            result.addFieldError("pluginInDown", cas.getText("csum.configure.error.plugindowninvalid"));
            result.setValid(false);
        }
        if (ConfigUtil.isNotNullAndIsYesOrNo(groupActionsPermitted = config.getGroupActionsPermitted())) {
            if (yesString.equals(groupActionsPermitted)) {
                if (config.getNewGroupNameCreationPrefixPattern() == null) {
                    result.addFieldError(GROUP_ACTIONS_PERMITTED, cas.getText(NEW_NAME_CREATION_PREFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
                if (config.getNewGroupNameCreationSuffixPattern() == null) {
                    result.addFieldError(GROUP_ACTIONS_PERMITTED, cas.getText(NEW_NAME_CREATION_SUFFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
            }
        } else {
            result.addFieldError(GROUP_ACTIONS_PERMITTED, cas.getText(GROUP_ACTIONS_PERMITTED_INVALID));
            result.setValid(false);
        }
        if (ConfigUtil.isNotNullAndIsYesOrNo(groupAddRemovePermitted = config.getGroupAddRemovePermitted())) {
            if (yesString.equals(groupAddRemovePermitted)) {
                if (config.getNewGroupNameCreationPrefixPattern() == null) {
                    result.addFieldError(GROUP_ADD_REMOVE_PERMITTED, cas.getText(NEW_NAME_CREATION_PREFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
                if (config.getNewGroupNameCreationSuffixPattern() == null) {
                    result.addFieldError(GROUP_ADD_REMOVE_PERMITTED, cas.getText(NEW_NAME_CREATION_SUFFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
            }
        } else {
            result.addFieldError(GROUP_ADD_REMOVE_PERMITTED, cas.getText(GROUP_ACTIONS_PERMITTED_INVALID));
            result.setValid(false);
        }
        if (ConfigUtil.isNotNullAndIsYesOrNo(removeUserFromPermGrpPerm = config.getRemoveUserFromPermGrpPerm())) {
            if (yesString.equals(removeUserFromPermGrpPerm)) {
                if (config.getNewGroupNameCreationPrefixPattern() == null) {
                    result.addFieldError(GROUP_REMOVE_USER_FROM_GLOBAL_PERM_GROUP_PERMITTED, cas.getText(NEW_NAME_CREATION_PREFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
                if (config.getNewGroupNameCreationSuffixPattern() == null) {
                    result.addFieldError(GROUP_REMOVE_USER_FROM_GLOBAL_PERM_GROUP_PERMITTED, cas.getText(NEW_NAME_CREATION_SUFFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
            }
        } else {
            result.addFieldError(GROUP_REMOVE_USER_FROM_GLOBAL_PERM_GROUP_PERMITTED, cas.getText(GROUP_ACTIONS_PERMITTED_INVALID));
            result.setValid(false);
        }
        if (ConfigUtil.isNotNullAndIsYesOrNo(dlgGrpActPerm = config.getDlgGrpActPerm())) {
            if (yesString.equals(dlgGrpActPerm)) {
                if (config.getNewGroupNameCreationPrefixPattern() == null) {
                    result.addFieldError(DLG_GROUP_ACTIONS_PERMITTED, cas.getText(NEW_NAME_CREATION_PREFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
                if (config.getNewGroupNameCreationSuffixPattern() == null) {
                    result.addFieldError(DLG_GROUP_ACTIONS_PERMITTED, cas.getText(NEW_NAME_CREATION_SUFFIX_PATTERN_INVALID));
                    result.setValid(false);
                }
            }
        } else {
            result.addFieldError(DLG_GROUP_ACTIONS_PERMITTED, cas.getText(GROUP_ACTIONS_PERMITTED_INVALID));
            result.setValid(false);
        }
        if (!ConfigUtil.isNotNullAndIsYesOrNo(config.getPersonalSpaceAllowed())) {
            result.addFieldError("personalSpaceAllowed", cas.getText("csum.configure.error.personalspaceallowedinvalid"));
            result.setValid(false);
        }
        if (!ConfigUtil.isNotNullAndIsYesOrNo(config.getGroupMembershipRefreshFixEnabled())) {
            result.addFieldError("groupMembershipRefreshFixEnabled", cas.getText("csum.configure.error.groupmembershiprefreshfixenabledinvalid"));
            result.setValid(false);
        }
        if (!ConfigUtil.isNotNullAndIsYesOrNo(config.getUnvalidatedUserAdditionEnabled())) {
            result.addFieldError("unvalidatedUserAdditionEnabled", cas.getText("csum.configure.error.unvalidateduseradditionenabledinvalid"));
            result.setValid(false);
        }
        LOG.debug((Object)("CustomPermissionConfigAction - isValid=" + result + " fieldErrors=" + result.getFieldNameToErrorMessage()));
        return result;
    }

    public void copyTo(CustomPermissionConfigurable config) {
        config.setUserManagerLocation(this.getUserManagerLocation());
        config.setMaxUserIDsLimit(this.getMaxUserIDsLimit());
        config.setMaxGroupIDsLimit(this.getMaxGroupIDsLimit());
        config.setLdapAuthUsed(this.getLdapAuthUsed());
        config.setPluginDown(this.getPluginDown());
        config.setDownTimeMessage(this.getDownTimeMessage());
        config.setGroupActionsPermitted(this.getGroupActionsPermitted());
        config.setGroupAddRemovePermitted(this.getGroupAddRemovePermitted());
        config.setRemoveUserFromPermGrpPerm(this.getRemoveUserFromPermGrpPerm());
        config.setDlgGrpActPerm(this.getDlgGrpActPerm());
        config.setNewGroupNameCreationPrefixPattern(this.getNewGroupNameCreationPrefixPattern());
        config.setNewGroupNameCreationSuffixPattern(this.getNewGroupNameCreationSuffixPattern());
        config.setUserSearchEnabled(this.getUserSearchEnabled());
        config.setJiraRestUrl(this.getJiraRestUrl());
        config.setJiraRestUsername(this.getJiraRestUsername());
        config.setJiraRestPassword(this.getJiraRestPassword());
        config.setProviderType(this.getProviderType());
        config.setLdapUserIdAttribute(this.getLdapUserIdAttribute());
        config.setLdapEmailAttribute(this.getLdapEmailAttribute());
        config.setLdapFirstNameAttribute(this.getLdapFirstNameAttribute());
        config.setLdapLastNameAttribute(this.getLdapLastNameAttribute());
        config.setLdapProviderFullyQualifiedClassname(this.getLdapProviderFullyQualifiedClassname());
        config.setUserFullNameFormat(this.getUserFullNameFormat());
        config.setLdapConfigTestUsername(this.getLdapConfigTestUsername());
        config.setLdapNarrowingFilterExpression(this.getLdapNarrowingFilterExpression());
        config.setPersonalSpaceAllowed(this.getPersonalSpaceAllowed());
        config.setGroupMembershipRefreshFixEnabled(this.getGroupMembershipRefreshFixEnabled());
        config.setNumRowsPerPage(this.getNumRowsPerPage());
        config.setUnvalidatedUserAdditionEnabled(this.getUnvalidatedUserAdditionEnabled());
    }

    public void updateWith(CustomPermissionConfigurable config) {
        this.setUserManagerLocation(config.getUserManagerLocation());
        this.setMaxUserIDsLimit(config.getMaxUserIDsLimit());
        this.setMaxGroupIDsLimit(config.getMaxGroupIDsLimit());
        this.setLdapAuthUsed(config.getLdapAuthUsed());
        this.setPluginDown(config.getPluginDown());
        this.setDownTimeMessage(config.getDownTimeMessage());
        this.setGroupActionsPermitted(config.getGroupActionsPermitted());
        this.setGroupAddRemovePermitted(config.getGroupAddRemovePermitted());
        this.setRemoveUserFromPermGrpPerm(config.getRemoveUserFromPermGrpPerm());
        this.setDlgGrpActPerm(config.getDlgGrpActPerm());
        this.setNewGroupNameCreationPrefixPattern(config.getNewGroupNameCreationPrefixPattern());
        this.setNewGroupNameCreationSuffixPattern(config.getNewGroupNameCreationSuffixPattern());
        this.setUserSearchEnabled(config.getUserSearchEnabled());
        this.setJiraRestUrl(config.getJiraRestUrl());
        this.setJiraRestUsername(config.getJiraRestUsername());
        String jiraRestPassword = config.getJiraRestPassword();
        if (jiraRestPassword != null) {
            this.setJiraRestPassword(jiraRestPassword);
        }
        this.setProviderType(config.getProviderType());
        this.setLdapUserIdAttribute(config.getLdapUserIdAttribute());
        this.setLdapEmailAttribute(config.getLdapEmailAttribute());
        this.setLdapFirstNameAttribute(config.getLdapFirstNameAttribute());
        this.setLdapLastNameAttribute(config.getLdapLastNameAttribute());
        this.setLdapProviderFullyQualifiedClassname(config.getLdapProviderFullyQualifiedClassname());
        this.setUserFullNameFormat(config.getUserFullNameFormat());
        this.setLdapConfigTestUsername(config.getLdapConfigTestUsername());
        this.setLdapNarrowingFilterExpression(config.getLdapNarrowingFilterExpression());
        this.setPersonalSpaceAllowed(config.getPersonalSpaceAllowed());
        this.setGroupMembershipRefreshFixEnabled(config.getGroupMembershipRefreshFixEnabled());
        this.setNumRowsPerPage(config.getNumRowsPerPage());
        this.setUnvalidatedUserAdditionEnabled(config.getUnvalidatedUserAdditionEnabled());
    }

    public LegacyCSUMConfigValidationResponse validate(ConfluenceActionSupport cas) {
        return CustomPermissionConfiguration.validate(this, null, null, cas, false);
    }

    @Override
    public String getUserManagerLocation() {
        String ret = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.user.manager.location.value");
        return ret;
    }

    @Override
    public void setUserManagerLocation(String userManagerLocation) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.user.manager.location.value", (Object)userManagerLocation);
    }

    public String getJiraJNDILookupKey() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.jndi.value");
    }

    public void setJiraJNDILookupKey(String jiraJNDILookupKey) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.jndi.value", (Object)jiraJNDILookupKey);
    }

    @Override
    public String getLdapAuthUsed() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.isldapauthpresent.value");
    }

    @Override
    public void setLdapAuthUsed(String ldapAuthUsed) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.isldapauthpresent.value", (Object)ldapAuthUsed);
    }

    public String getCompanyLDAPUrl() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.company.ldap.url.value");
    }

    public void setCompanyLDAPUrl(String companyLDAPUrl) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.company.ldap.url.value", (Object)companyLDAPUrl);
    }

    public String getCompanyLDAPBaseDN() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.company.ldap.base.dn.value");
    }

    public void setCompanyLDAPBaseDN(String companyLDAPBaseDN) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.company.ldap.base.dn.value", (Object)companyLDAPBaseDN);
    }

    @Override
    public String getMaxUserIDsLimit() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.maxuserids.limit.value");
    }

    @Override
    public void setMaxUserIDsLimit(String maxUserIDsLimit) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.maxuserids.limit.value", (Object)maxUserIDsLimit);
    }

    @Override
    public String getMaxGroupIDsLimit() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.maxgroupids.limit.value");
    }

    @Override
    public void setMaxGroupIDsLimit(String maxGroupIDsLimit) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.maxgroupids.limit.value", (Object)maxGroupIDsLimit);
    }

    @Override
    public String getPluginDown() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.plugin.status");
    }

    @Override
    public void setPluginDown(String pluginDown) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.plugin.status", (Object)pluginDown);
    }

    @Override
    public String getDownTimeMessage() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.downtime.message.value");
    }

    @Override
    public void setDownTimeMessage(String downTimeMessage) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.downtime.message.value", (Object)downTimeMessage);
    }

    @Override
    public String getGroupActionsPermitted() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.actions.permitted.value");
    }

    @Override
    public void setGroupActionsPermitted(String groupActionsPermitted) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.actions.permitted.value", (Object)groupActionsPermitted);
    }

    @Override
    public String getGroupAddRemovePermitted() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.add.remove.permitted.value");
    }

    @Override
    public void setGroupAddRemovePermitted(String groupAddRemovePermitted) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.add.remove.permitted.value", (Object)groupAddRemovePermitted);
    }

    @Override
    public String getRemoveUserFromPermGrpPerm() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.remove.user.global.perm.group.permitted.value");
    }

    @Override
    public void setRemoveUserFromPermGrpPerm(String removeUserFromPermGrpPerm) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.remove.user.global.perm.group.permitted.value", (Object)removeUserFromPermGrpPerm);
    }

    @Override
    public String getDlgGrpActPerm() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.dlg.group.actions.permitted.value");
    }

    @Override
    public void setDlgGrpActPerm(String dlgGrpActPerm) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.dlg.group.actions.permitted.value", (Object)dlgGrpActPerm);
    }

    @Override
    public String getNewGroupNameCreationPrefixPattern() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.new.group.name.creation.prefix.pattern");
    }

    @Override
    public void setNewGroupNameCreationPrefixPattern(String newGroupNameCreationPrefixPattern) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.new.group.name.creation.prefix.pattern", (Object)newGroupNameCreationPrefixPattern);
    }

    @Override
    public String getNewGroupNameCreationSuffixPattern() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.new.group.name.creation.suffix.pattern");
    }

    @Override
    public void setNewGroupNameCreationSuffixPattern(String newGroupNameCreationSuffixPattern) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.new.group.name.creation.suffix.pattern", (Object)newGroupNameCreationSuffixPattern);
    }

    @Override
    public String getUserSearchEnabled() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.user.search.enabled");
    }

    @Override
    public void setUserSearchEnabled(String userSearchEnabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.user.search.enabled", (Object)userSearchEnabled);
    }

    @Override
    public String getJiraRestUrl() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.rest.url");
    }

    @Override
    public void setJiraRestUrl(String jiraRestUrl) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.rest.url", (Object)jiraRestUrl);
    }

    @Override
    public String getJiraRestUsername() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.rest.username");
    }

    @Override
    public void setJiraRestUsername(String jiraRestUsername) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.rest.username", (Object)jiraRestUsername);
    }

    @Override
    public String getJiraRestPassword() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.rest.password");
    }

    @Override
    public void setJiraRestPassword(String jiraRestPassword) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.jira.rest.password", (Object)jiraRestPassword);
    }

    @Override
    public String getProviderType() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.provider.type");
    }

    @Override
    public void setProviderType(String providerType) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.provider.type", (Object)providerType);
    }

    @Override
    public String getLdapUserIdAttribute() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap,user.id.attribute");
    }

    @Override
    public void setLdapUserIdAttribute(String ldapUserIdAttribute) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap,user.id.attribute", (Object)ldapUserIdAttribute);
    }

    @Override
    public String getLdapEmailAttribute() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.email.attribute");
    }

    @Override
    public void setLdapEmailAttribute(String ldapEmailAttribute) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.email.attribute", (Object)ldapEmailAttribute);
    }

    @Override
    public String getLdapFirstNameAttribute() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.firstname.attribute");
    }

    @Override
    public void setLdapFirstNameAttribute(String ldapNameAttribute) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.firstname.attribute", (Object)ldapNameAttribute);
    }

    @Override
    public String getLdapLastNameAttribute() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.lastname.attribute");
    }

    @Override
    public void setLdapLastNameAttribute(String ldapNameAttribute) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.lastname.attribute", (Object)ldapNameAttribute);
    }

    @Override
    public String getLdapProviderFullyQualifiedClassname() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.provider.fully.qualified.classname");
    }

    @Override
    public void setLdapProviderFullyQualifiedClassname(String ldapProviderFullyQualifiedClassname) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.provider.fully.qualified.classname", (Object)ldapProviderFullyQualifiedClassname);
    }

    @Override
    public String getUserFullNameFormat() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.user.full.name.format");
    }

    @Override
    public void setUserFullNameFormat(String userFullNameFormat) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.user.full.name.format", (Object)userFullNameFormat);
    }

    @Override
    public String getLdapConfigTestUsername() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.config.test.username");
    }

    @Override
    public void setLdapConfigTestUsername(String ldapConfigTestUsername) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.config.test.username", (Object)ldapConfigTestUsername);
    }

    @Override
    public String getLdapNarrowingFilterExpression() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.narrowing.filter.expression");
    }

    @Override
    public void setLdapNarrowingFilterExpression(String ldapNarrowingFilterExpression) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.ldap.narrowing.filter.expression", (Object)ldapNarrowingFilterExpression);
    }

    @Override
    public String getPersonalSpaceAllowed() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.personal.space.allowed");
    }

    @Override
    public void setPersonalSpaceAllowed(String personalSpaceAllowed) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.personal.space.allowed", (Object)personalSpaceAllowed);
    }

    @Override
    public String getGroupMembershipRefreshFixEnabled() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.management.refresh.fix.enabled");
    }

    @Override
    public void setGroupMembershipRefreshFixEnabled(String groupMembershipRefreshFixEnabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.group.management.refresh.fix.enabled", (Object)groupMembershipRefreshFixEnabled);
    }

    @Override
    public String getNumRowsPerPage() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.num.rows.per.page");
    }

    @Override
    public void setNumRowsPerPage(String numRowsPerPage) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.num.rows.per.page", (Object)numRowsPerPage);
    }

    @Override
    public String getUnvalidatedUserAdditionEnabled() {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.unvalidated.user.addition.enabled");
    }

    @Override
    public void setUnvalidatedUserAdditionEnabled(String unvalidatedUserAdditionEnabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "ext.delegateusermgmt.unvalidated.user.addition.enabled", (Object)unvalidatedUserAdditionEnabled);
    }
}

